<?php

/**
 * This is the model class for table "{{reservacion_desglose_activity}}".
 *
 * The followings are the available columns in table '{{reservacion_desglose_activity}}':
 * @property string $id_desglose
 * @property string $id_reservacion
 * @property double $precio_adulto
 * @property double $precio_ninio
 * @property string $num_adultos
 * @property double $num_ninios
 * @property integer $num_jrs
 * @property integer $estatus
 *
 * The followings are the available model relations:
 * @property ReservacionActivity $idReservacion
 * @property ReservacionDesglosePersonaActivity[] $reservacionDesglosePersonaActivities
 */
class ActivityReservacionDesglose extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ReservacionDesgloseActivity the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{activity_reservacion_desglose}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_reservacion, precio_adulto, num_adultos, num_ninios', 'required'),
			array('num_jrs, estatus', 'numerical', 'integerOnly'=>true),
			array('precio_adulto, precio_ninio, num_ninios', 'numerical'),
			array('id_reservacion, num_adultos', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_desglose, id_reservacion, precio_adulto, precio_ninio, num_adultos, num_ninios, num_jrs, estatus', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idReservacion' => array(self::BELONGS_TO, 'ReservacionActivity', 'id_reservacion'),
			'reservacionDesglosePersonaActivities' => array(self::HAS_MANY, 'ReservacionDesglosePersonaActivity', 'id_desglose'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_desglose' => 'Id Desglose',
			'id_reservacion' => 'Id Reservacion',
			'precio_adulto' => 'Precio Adulto',
			'precio_ninio' => 'Precio Ninio',
			'num_adultos' => 'Num Adultos',
			'num_ninios' => 'Num Ninios',
			'num_jrs' => 'Num Jrs',
			'estatus' => 'Estatus',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_desglose',$this->id_desglose,true);
		$criteria->compare('id_reservacion',$this->id_reservacion,true);
		$criteria->compare('precio_adulto',$this->precio_adulto);
		$criteria->compare('precio_ninio',$this->precio_ninio);
		$criteria->compare('num_adultos',$this->num_adultos,true);
		$criteria->compare('num_ninios',$this->num_ninios);
		$criteria->compare('num_jrs',$this->num_jrs);
		$criteria->compare('estatus',$this->estatus);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}