<?php



/**

 * This is the model class for table "{{reservacion_activity}}".

 *

 * The followings are the available columns in table '{{reservacion_activity}}':

 * @property string $id_reservacion

 * @property integer $id_agencia

 * @property integer $id_usuario

 * @property integer $id_agente

 * @property string $fecha_inicial

 * @property string $fecha_final

 * @property string $fecha_limite

 * @property string $fecha_limite_old

 * @property string $fecha_liberacion

 * @property integer $usuario_liberacion

 * @property string $num_noches

 * @property string $observaciones

 * @property string $comentarios

 * @property string $estatus

 * @property string $log

 * @property double $subtotal

 * @property double $comision

 * @property double $iva

 * @property double $tipo_cambio

 * @property double $total

 * @property double $total_tc

 * @property double $saldo

 * @property double $saldo_a

 * @property double $porc_com_agencia

 * @property string $nombre_cliente

 * @property string $apellido_cliente

 * @property string $tel_cliente

 * @property string $code

 * @property string $factura

 * @property integer $libera_cupon

 * @property double $comision_bancaria

 * @property string $motivo

 * @property integer $manual

 * @property string $politicas_cancelacion

 * @property string $activiad

 * @property string $modalidad

 * @property string $destino

 * @property string $picture

 */

class ActivityReservacion extends CActiveRecord

{

	/**

	 * Returns the static model of the specified AR class.

	 * @param string $className active record class name.

	 * @return ReservacionActivity the static model class

	 */

	public static function model($className=__CLASS__)

	{

		return parent::model($className);

	}



	/**

	 * @return string the associated database table name

	 */

	public function tableName()

	{

		return '{{activity_reservacion}}';

	}



	/**

	 * @return array validation rules for model attributes.

	 */

	public function rules()

	{

		// NOTE: you should only define rules for those attributes that

		// will receive user inputs.

		return array(

			array('id_agencia, id_usuario, fecha_inicial, fecha_final, num_noches, estatus, comision, total, total_tc, saldo, saldo_a, nombre_cliente, apellido_cliente', 'required'),

			array('id_agencia, id_usuario, id_agente, libera_cupon, manual', 'numerical', 'integerOnly'=>true),

			array('subtotal, comision, iva, tipo_cambio, total, total_tc, saldo, saldo_a, porc_com_agencia, comision_bancaria', 'numerical'),

			array('num_noches', 'length', 'max'=>10),

			array('estatus', 'length', 'max'=>3),

			array('nombre_cliente, apellido_cliente, code, factura', 'length', 'max'=>255),

			array('tel_cliente', 'length', 'max'=>45),

			array('motivo', 'length', 'max'=>200),

			

			array('fecha_limite, fecha_limite_a, Booking, fecha_liberacion, observaciones, comentarios, politicas_cancelacion, actividad, modalidad, destino, picture', 'safe'),

			// The following rule is used by search().

			// Please remove those attributes that should not be searched.

			array('id_reservacion, id_agencia, id_usuario, id_agente, fecha_inicial, fecha_final, fecha_limite, fecha_limite_a, fecha_liberacion, usuario_liberacion, num_noches, observaciones, comentarios, estatus, log, subtotal, comision, iva, tipo_cambio, total, total_tc, saldo, saldo_a, porc_com_agencia, nombre_cliente, apellido_cliente, tel_cliente, code, factura, libera_cupon, comision_bancaria, motivo, manual, politicas_cancelacion, actividad, modalidad, destino, picture', 'safe', 'on'=>'search'),

		);

	}



	/**

	 * @return array relational rules.

	 */



	public function relations()

	{

		// NOTE: you may need to adjust the relation name and the related

		// class name for the relations automatically generated below.

		return array(

			'idAgencia' => array(self::BELONGS_TO, 'Agencias', 'id_agencia'),			

			'idAgente' => array(self::BELONGS_TO, 'Usuarios', 'id_agente'),

			'idUser' => array(self::BELONGS_TO, 'Usuarios', 'id_usuario'),
			
			'idUsuario' => array(self::BELONGS_TO, 'Usuarios', 'id_usuario'),

			'idUserLibera' => array(self::BELONGS_TO, 'Usuarios', 'usuario_liberacion'),

			'DesglosePersona'=>array(self::HAS_MANY, 'ActivityReservacionDesglosePersona', 'id_reservacion', 'order'=>'edad DESC'),
			
			'DesgloseReservacion'=>array(self::BELONGS_TO, 'ActivityReservacionDesglose', 'id_reservacion'),

		);

	}











	/**

	 * @return array customized attribute labels (name=>label)

	 */

	public function attributeLabels()

	{

		return array(

			'id_reservacion' => 'Id Reservacion',

			'id_agencia' => 'Id Agencia',

			'id_usuario' => 'Id Usuario',

			'id_agente' => 'Id Agente',

			'fecha_inicial' => 'Fecha Inicial',

			'fecha_final' => 'Fecha Final',

			'fecha_limite' => 'Fecha Limite',

			'fecha_limite_a' => 'Fecha Limite Actividad',

			'fecha_liberacion' => 'Fecha Liberacion',

			'usuario_liberacion' => 'Usuario Liberacion',

			'num_noches' => 'Num Noches',

			'observaciones' => 'Observaciones',

			'comentarios' => 'Comentarios',

			'estatus' => 'Estatus',

			'log' => 'Log',

			'subtotal' => 'Subtotal',

			'comision' => 'Comision',

			'iva' => 'Iva',

			'tipo_cambio' => 'Tipo Cambio',

			'total' => 'Total',

			'total_tc' => 'Total Tc',

			'saldo' => 'Saldo',

			'saldo_a' => 'Saldo Actividad',

			'porc_com_agencia' => 'Porc Com Agencia',

			'nombre_cliente' => 'Nombre Cliente',

			'apellido_cliente' => 'Apellido Cliente',

			'tel_cliente' => 'Tel Cliente',

			'code' => 'Code',

			'factura' => 'Factura',

			'libera_cupon' => 'Libera Cupon',

			'comision_bancaria' => 'Comision Bancaria',

			'motivo' => 'Motivo',

			'manual' => 'Manual',

			'politicas_cancelacion' => 'Politicas Cancelacion',

			'actividad' => 'Actividad',

			'modalidad' => 'Modalidad',

			'destino' => 'Destino',

			'picture' => 'Foto Actividad',

			'Booking'=>'Booking'

		);

	}



	/**

	 * Retrieves a list of models based on the current search/filter conditions.

	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.

	 */

	public function search()

	{

		// Warning: Please modify the following code to remove attributes that

		// should not be searched.



		$criteria=new CDbCriteria;



		$criteria->compare('id_reservacion',$this->id_reservacion,true);

		$criteria->compare('id_agencia',$this->id_agencia);

		$criteria->compare('id_usuario',$this->id_usuario);

		$criteria->compare('id_agente',$this->id_agente);

		$criteria->compare('fecha_inicial',$this->fecha_inicial,true);

		$criteria->compare('fecha_final',$this->fecha_final,true);

		$criteria->compare('fecha_limite',$this->fecha_limite,true);

		$criteria->compare('fecha_limite_a',$this->fecha_limite_a,true);

		$criteria->compare('fecha_liberacion',$this->fecha_liberacion,true);

		$criteria->compare('usuario_liberacion',$this->usuario_liberacion);

		$criteria->compare('num_noches',$this->num_noches,true);

		$criteria->compare('observaciones',$this->observaciones,true);

		$criteria->compare('comentarios',$this->comentarios,true);

		$criteria->compare('estatus',$this->estatus,true);

		$criteria->compare('log',$this->log,true);

		$criteria->compare('subtotal',$this->subtotal);

		$criteria->compare('comision',$this->comision);

		$criteria->compare('iva',$this->iva);

		$criteria->compare('tipo_cambio',$this->tipo_cambio);

		$criteria->compare('total',$this->total);

		$criteria->compare('total_tc',$this->total_tc);

		$criteria->compare('saldo',$this->saldo);

		$criteria->compare('saldo_a',$this->saldo_a);

		$criteria->compare('porc_com_agencia',$this->porc_com_agencia);

		$criteria->compare('nombre_cliente',$this->nombre_cliente,true);

		$criteria->compare('apellido_cliente',$this->apellido_cliente,true);

		$criteria->compare('tel_cliente',$this->tel_cliente,true);

		$criteria->compare('code',$this->code,true);

		$criteria->compare('factura',$this->factura,true);

		$criteria->compare('libera_cupon',$this->libera_cupon);

		$criteria->compare('comision_bancaria',$this->comision_bancaria);

		$criteria->compare('motivo',$this->motivo,true);

		$criteria->compare('manual',$this->manual);

		$criteria->compare('politicas_cancelacion',$this->politicas_cancelacion,true);

		$criteria->compare('actividad',$this->actividad,true);

		$criteria->compare('modalidad',$this->modalidad,true);

		$criteria->compare('destino',$this->destino,true);

		$criteria->compare('picture',$this->picture,true);



		return new CActiveDataProvider($this, array(

			'criteria'=>$criteria,

		));

	}

}