<?php
class UsuariosController extends Controller

{

	/**

	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning

	 * using two-column layout. See 'protected/views/layouts/column2.php'.

	 */

	public $layout='//layouts/column1';



	/**

	 * @return array action filters

	 */

	public function filters()

	{

		return array(

			'accessControl', // perform access control for CRUD operations

		);

	}



	/**

	 * Specifies the access control rules.

	 * This method is used by the 'accessControl' filter.

	 * @return array access control rules

	 */

	public function accessRules()

	{

		$rules = AuthFuncion::model()->findAll('controlador="'.Yii::app()->controller->id.'"');

		$array = array();

		

		foreach($rules as $row){

			$rule = array('allow',

						'actions'=>array($row->funcion),

						'roles'=>array($row->operacion),

					);

			array_push($array,$rule);

		}

		

		array_push($array,
			array('allow',
					'actions'=>array('create'),
					'users'=>array('Sr. Ramses','SR. RAMSES','rmt')
				),

			array('allow',
					'actions'=>array('onesignal'),
					'users'=>array('@')
				),

			array('deny',  // deny all users

				'users'=>array('*'),

			)

		);

		

		return $array;

	}



		public function actionOneSignal()
	{
		$servicio="https://apituristico.com/rmt/WebServiceRMT.asmx/AgregarOneSignal"; //url del servicio
        //$parametros=array(); //parametros de la llamada
        $id_usuario =$_POST['idUsuario'];
        $id_agencia=$_POST['idAgencia'];
        $player_id=$_POST['playerId'];
       /* $client = new SoapClient($servicio);
        $result = $client->AgregarOneSignal($id_usuario, $id_agencia, $player_id);
        if($result)
        {
        	echo "correcto";
        }*/
        /*if($this->validacionOnesignal()===true)
   		{
   			
   		}else{
   			echo "Usuario registrado a notificaciones";
   		}*/

/*   		$curl = curl_init();

      curl_setopt_array($curl, array(
       
        CURLOPT_URL => $servicio,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "POST",
        CURLOPT_POSTFIELDS => "id_usuario=".$id_usuario."&id_agencia=".$id_agencia."&player_id=".$player_id,
     	CURLOPT_HTTPHEADER => array(
		    "content-type: application/x-www-form-urlencoded"
    
		),
      ));

      $response = curl_exec($curl);
      $err = curl_error($curl);

      curl_close($curl);

      if ($err) {
        echo "cURL Error #:" . $err;
      } else {
         
         echo $response;
        
      }*/

	}

	public function validacionOnesignal()
	{

		$url="https://apituristico.com/rmt/WebServiceRMT.asmx/OneSignal";
			
			 $ch = curl_init();
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch, CURLOPT_URL, $url);
			$result = curl_exec($ch);
			curl_close($ch);
				
			$reservar = json_decode($result);
			
			
			foreach ($reservar as $key => $value) {
				
				if($value->id_usuario==$_POST['idUsuario'] && $value->id_agencia==$_POST['idAgencia']&&$value->player_id==$_POST['playerId']) {
					return false;
				}else{
					return true;
				}
			}

	}


	/**

	 * Displays a particular model.

	 * @param integer $id the ID of the model to be displayed

	 */

	public function actionView($id)

	{

		$model=$this->loadModel($id);

		$model->fecha_nacimiento=implode('/',array_reverse(explode('-',$model->fecha_nacimiento)));

		if($model->tipo_usuario == 'ag')

		{

			$model->tipo_usuario = 'Propietario Agencia';

		}

		else if($model->tipo_usuario == 'agv')

		{

			$model->tipo_usuario = 'Agente de Ventas';

		}

		

		$this->render('view',array(

			'model'=>$model,

		));

	}



	/**

	 * Creates a new model.

	 * If creation is successful, the browser will be redirected to the 'view' page.

	 */

	public function actionCreate()

	{

		$model=new Usuarios;

		$user=new Users;

		$profile=new Profiles;



		// Uncomment the following line if AJAX validation is needed

		// $this->performAjaxValidation($model);



		if(isset($_POST['Usuarios']))

		{

			$model->attributes=$_POST['Usuarios'];

			$existe = Users::model()->findAll('email="'.$_POST['Usuarios']['email_usuario'].'"');

			if(count($existe) > 0)

			{

				echo "<legend>Este Email ya existe! Por favor vuelve a intentar con otro diferente.</legend>";

			}

			else

			{

				$model->clave_usuario=md5($_POST['Usuarios']['clave_usuario']);

				if(isset($_POST['agencia_id'])){

					$model->id_agencia=$_POST['agencia_id'];

				}else if(isset($_POST['id_hotel'])){

					$model->id_hotel=$_POST['id_hotel'];

				}

				$model->ip_publica="0";

				$model->tema="0";

				$model->plugin="0";

				$model->estatus = "I";

				$model->fecha_nacimiento=implode('-',array_reverse(explode('/',$_POST['Usuarios']['fecha_nacimiento'])));

				if(!empty($model->aviso))$model->aviso=implode(',',$_POST['Usuarios']['aviso']);

				$user->activkey=md5(microtime().$_POST['Usuarios']['clave_usuario']);

				$user->password=md5($_POST['Usuarios']['clave_usuario']);

				$user->username=substr($model->nombre_usuario,0,20);

				$user->email=$model->email_usuario;

				$user->superuser=0;

				$user->status=1;

				$profile->firstname=substr($model->nombre_usuario,0,50);

				if($model->tipo_usuario == "ag" || $model->tipo_usuario == "agv")

				{

					$profile->tipo="Agencia";

					$permiso="agencia";

				}

				else if($model->tipo_usuario == "vo" || $model->tipo_usuario == "su" || $model->tipo_usuario == "sa")

				{

					$profile->tipo="Admon";

					$permiso="agente";

				}

				else if($model->tipo_usuario == "agh")

				{

					$profile->tipo="Hotel";

					$permiso="hotel";

				}

			

				if($model->save()){

					$user->id = $model->id_usuario;

					if($user->save()){

						$profile->user_id = $user->id;

						if($profile->save())

						{

							$auth=Yii::app()->authManager;

							$auth->assign($permiso,$user->id);

							

							$this->enviarEmail($model);

							

							echo "<legend>Usuario Nuevo Creado!</legend>";

						}

						else{

							echo "<legend>Fallo al crear el usuario</legend>";

						}

					}

					else{

						echo "<legend>Fallo al crear el usuario</legend>";

					}

				}

				else{

					echo "<legend>Fallo al crear el usuario</legend>";

				}

			}

		}

	}

	

	private function enviarEmail($model)

	{

		if(!empty($model->id_agencia)){

			$pertenece = '<b>Agencia:</b> '.$model->idAgencia->nombre_agencia.'<br>';

			$url = $_SERVER['SERVER_NAME'].Yii::app()->createUrl('agencias/update',array('id'=>$model->id_agencia));

		}else if(!empty($model->id_hotel)){

			$pertenece = '<b>Hotel:</b> '.$model->idHotel->nombre_hotel.'<br>';

			$url = $_SERVER['SERVER_NAME'].Yii::app()->createUrl('hoteles/view',array('id'=>$model->id_hotel));

		}

		

		$subject = "Registro de Usuario";

		$message = "<div align='center' width='400' style='border:1px solid black'>

						<img src='http://".$_SERVER['SERVER_NAME']."/outlet/images/logo_rutamaya.jpg'>

						<p>Fecha: ".date('d/m/Y')."</p>

						<h4>SE HA REGISTRADO UN NUEVO USUARIO EN EL SISTEMA</h4><hr>

						<p><b>Nombre:</b> ".$model->nombre_usuario."<br>

						".$pertenece."

						<b>Tipo:</b> ".$model->tipo_usuario."<br>

						<b>Email:</b> ".$model->email_usuario."<br>

						<p>*Por favor revise la cuenta para activarla.</p>

						<p><a href='".$url."'>

						*Para revisar la cuenta ahora haga clic aqui.</a></p><br>

					</div>";

					

		Yii::import('application.extensions.phpmailer.JPhpMailer');

		$mail = new JPhpMailer;

		$mail->IsSMTP();

		$mail->Host = 'rutamayatravel.com'; 

		$mail->SMTPAuth = true;

		$mail->Username = 'no-reply@rutamayatravel.com'; 

		$mail->Port = '26'; 

		$mail->Password = 'Intelred76'; 

		$mail->SMTPKeepAlive = true;  

		$mail->Mailer = "smtp"; 

		$mail->IsSMTP(); // telling the class to use SMTP  

		$mail->SMTPAuth   = true;  

		$mail->CharSet = 'utf-8';  

		$mail->SMTPDebug  = 0;

		$mail->SetFrom('no-reply@rutamayatravel.com', 'Sistema Ruta Maya Travel'); 

		$mail->Subject = $subject; 

		$mail->AltBody = 'To view the message, please use an HTML compatible email viewer!'; 

		$mail->MsgHTML($message);

		/*$usuarios = Usuarios::model()->findAll('id_agencia=9 and estatus="A"');

		foreach($usuarios as $usr){

			$mail->AddAddress($usr->email_usuario, $usr->nombre_usuario);

		}*/

		$mail->AddAddress('danielruiz@rutamayatravel.com', 'Daniel Ruiz');

		$mail->AddAddress('leticiavarguez@rutamayatravel.com', 'Leticia Varguez');

		$mail->AddAddress('alfredocanche@rutamayatravel.com', 'Alfredo Canche');

		$mail->AddAddress('gbojorquez@rutamayatravel.com', 'Guimer Bojorquez');

		$mail->AddAddress('sugely.lizama@rutamayatravel.com', 'Sugely Lizama');

		$mail->AddAddress('mercichan@rutamayatravel.com', 'Merci Chan');

		$mail->AddAddress('contabilidad@rutamayatravel.com', 'Omar Bastos');

		

		$mail->AddAddress('fernandoeuan@rutamayatravel.com', 'Fernando Euan');

		

		$mail->Send();

	}



	/**

	 * Updates a particular model.

	 * If update is successful, the browser will be redirected to the 'view' page.

	 * @param integer $id the ID of the model to be updated

	 */

	public function actionUpdate($id)

	{


/*
		if($_SESSION["tipoUsuario"] == "Agencia")

        {

        	$id=Yii::app()->user->id;	

        }else

        {

        	$id=$_GET["id"];

        }*/



		$model=$this->loadModel($id);

		$profile=Profiles::model()->findByPk($id);

		$user=Users::model()->findByPk($id);

		/*echo "<textarea name=''>".CJSON::encode($model)."</textarea><textarea name=''>".CJSON::encode($profile)."</textarea><textarea name=''>".CJSON::encode($user)."</textarea>";
		exit;*/

		// Uncomment the following line if AJAX validation is needed

		// $this->performAjaxValidation($model);


		try {
			if(isset($_POST['Usuarios']))

		{

			if($model->clave_usuario != $_POST['Usuarios']['clave_usuario'])

			{

				$model->attributes=$_POST['Usuarios'];

				$model->clave_usuario=md5($_POST['Usuarios']['clave_usuario']);

				$user->password=md5($_POST['Usuarios']['clave_usuario']);

			}

			else

			{

				$model->attributes=$_POST['Usuarios'];

			}

			$model->fecha_nacimiento=implode('-',array_reverse(explode('/',$model->fecha_nacimiento)));

			$profile->firstname=(strlen($model->nombre_usuario) > 50) ? substr($model->nombre_usuario,0,50) : $model->nombre_usuario;

			$user->email=$model->email_usuario;

			

			if($model->save() && $profile->save() && $user->save())

			{

				if(is_uploaded_file($_FILES['file']['tmp_name']))

				{

					if(is_readable($_SERVER['DOCUMENT_ROOT'].'/imagenes/'.$model->foto))

					{

						if($model->foto!="")

						unlink($_SERVER['DOCUMENT_ROOT'].'/imagenes/'.$model->foto);

					}

					$fileName = $_FILES['file']['name'];

					$model->foto = date('Y-m-d').'_'.$model->id_usuario.''.$fileName;

					if($model->save())

					{

						$dir = $_SERVER['DOCUMENT_ROOT'].'/imagenes/'.$model->foto;

						if(!move_uploaded_file($_FILES['file']['tmp_name'],$dir))

						{

							echo "No se pudo subir el archivo!";

						}
						echo 'correcto';
					}

				}

				echo CJSON::encode($model);

			}

		}
				//$model->fecha_nacimiento=implode('/',array_reverse(explode('-',$model->fecha_nacimiento)));
			
		} catch (Exception $e) {
			print_r($e);
		}
		

		/*$this->render('update',array(

			'model'=>$model,

		));*/

	}



	/**

	 * Deletes a particular model.

	 * If deletion is successful, the browser will be redirected to the 'admin' page.

	 * @param integer $id the ID of the model to be deleted

	 */

	public function actionDelete()

	{

		$id = $_POST['id_user'];

		$idagencia = $_POST['id_agencia'];

		

		if(Yii::app()->request->isPostRequest)

		{

			// we only allow deletion via POST request

			$model=Usuarios::model()->findByPk($id);

			$user=Users::model()->findByPk($id);

			if($model->estatus == "A")

			{

				$model->estatus="I";

				$user->status=0;

			}

			else{

				$model->estatus="A";

				$user->status=1;

			}

			$model->save();

			if(!$user->save()){echo CJSON::encode($user->getErrors()); }

			

			$usuarios=Usuarios::model()->findAll('id_agencia='.$idagencia);

			

			$this->renderPartial('../agencias/tablausuarios',array('idagencia'=>$idagencia,'usuarios'=>$usuarios));

		}

		else

			throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');

	}

	

	public function actionDeletehotel()

	{

		$id = $_POST['id_user'];

		

		if(Yii::app()->request->isPostRequest)

		{

			// we only allow deletion via POST request

			$model=Usuarios::model()->findByPk($id);

			$user=Users::model()->findByPk($id);

			if($model->estatus == "A")

			{

				$model->estatus="I";

				$user->status=0;

			}

			else{

				$model->estatus="A";

				$user->status=1;

			}

			$model->save();

			$user->save();

			

			$usuarios=Usuarios::model()->findAll('tipo_usuario="agh"');	

			

			$this->renderPartial('../extranet/tablausuarios',array('usuarios'=>$usuarios));

		}

		else

			throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');

	}



	/**

	 * Lists all models.

	 */

	public function actionIndex()

	{

            $session=new CHttpSession;

            $session->open();		

            $criteria = new CDbCriteria();            



                $model=new Usuarios('search');

                $model->unsetAttributes();  // clear any default values



                if(isset($_GET['Usuarios']))

		{

                        $model->attributes=$_GET['Usuarios'];

			

			

                   	

                       if (!empty($model->id_usuario)) $criteria->addCondition("id_usuario = '".$model->id_usuario."'");

                     

                    	

                       if (!empty($model->nombre_usuario)) $criteria->addCondition("nombre_usuario = '".$model->nombre_usuario."'");

                     

                    	

                       if (!empty($model->email_usuario)) $criteria->addCondition("email_usuario = '".$model->email_usuario."'");

                     

                    	

                       if (!empty($model->clave_usuario)) $criteria->addCondition("clave_usuario = '".$model->clave_usuario."'");

                     

                    	

                       if (!empty($model->tipo_usuario)) $criteria->addCondition("tipo_usuario = '".$model->tipo_usuario."'");

                     

                    	

                       if (!empty($model->leng)) $criteria->addCondition("leng = '".$model->leng."'");

                     

                    	

                       if (!empty($model->id_agencia)) $criteria->addCondition("id_agencia = '".$model->id_agencia."'");

                     

                    	

                       if (!empty($model->ip_publica)) $criteria->addCondition("ip_publica = '".$model->ip_publica."'");

                     

                    	

                       if (!empty($model->log)) $criteria->addCondition("log = '".$model->log."'");

                     

                    	

                       if (!empty($model->foto)) $criteria->addCondition("foto = '".$model->foto."'");

                     

                    	

                       if (!empty($model->tema)) $criteria->addCondition("tema = '".$model->tema."'");

                     

                    	

                       if (!empty($model->plugin)) $criteria->addCondition("plugin = '".$model->plugin."'");

                     

                    	

                       if (!empty($model->activacion)) $criteria->addCondition("activacion = '".$model->activacion."'");

                     

                    	

                       if (!empty($model->estatus)) $criteria->addCondition("estatus = '".$model->estatus."'");

                     

                    	

                       if (!empty($model->fecha_nacimiento)) $criteria->addCondition("fecha_nacimiento = '".$model->fecha_nacimiento."'");

                     

                    			

                    $session['Usuarios_records']=Usuarios::model()->findAll($criteria); 

		}

       



                /*$this->render('index',array(

			'model'=>$model,

		));*/



	}



	/**

	 * Manages all models.

	 */

	public function actionAdmin()

	{

		$model=new Usuarios('search');

		$model->unsetAttributes();  // clear any default values

		if(isset($_GET['Usuarios']))

			$model->attributes=$_GET['Usuarios'];



		$this->render('admin',array(

			'model'=>$model,

		));

	}

	

	public function actionCargarusuario()

	{

		$id = Yii::app()->request->getParam('user_id');

		$model=Usuarios::model()->findByPk($id);

		$model->fecha_nacimiento = implode('/',array_reverse(explode('-',$model->fecha_nacimiento)));

		

		echo CJSON::encode(array(

			'nombre_usuario' => $model->nombre_usuario,

			'email_usuario' => $model->email_usuario,

			'clave_usuario' => $model->clave_usuario,

			'tipo_usuario' => $model->tipo_usuario,

			'fecha_nacimiento' => $model->fecha_nacimiento,

			'aviso' => $model->aviso != NULL ? explode(',',$model->aviso):NULL,

		));

	}

	

	public function actionEditarusuario()

	{

		$id = Yii::app()->request->getParam('user_id');

		$model=Usuarios::model()->findByPk($id);

		$profile=Profiles::model()->findByPk($id);

		$user=Users::model()->findByPk($id);

		

		if(isset($_POST['Usuarios']))

		{

			$_POST['Usuarios']['fecha_nacimiento'] = implode('-',array_reverse(explode('/',$_POST['Usuarios']['fecha_nacimiento'])));

			if($model->clave_usuario != $_POST['Usuarios']['clave_usuario'])

			{

				$model->attributes=$_POST['Usuarios'];

				$model->clave_usuario=md5($_POST['Usuarios']['clave_usuario']);

				$user->password=md5($_POST['Usuarios']['clave_usuario']);

			}

			else

			{

				$model->attributes=$_POST['Usuarios'];

			}

			//if(!empty($model->aviso)) $model->aviso=implode(',',$_POST['Usuarios']['aviso']);

			if($_POST['Usuarios']['aviso']) $model->aviso=implode(',',$_POST['Usuarios']['aviso']);

		

			$profile->firstname=substr($model->nombre_usuario,0,50);

			$user->username=substr($model->nombre_usuario,0,20);

			$user->email=$model->email_usuario;

			

			if($model->save() && $profile->save() && $user->save())

			{

				echo "<legend>Usuario actualizado!</legend>";

			}

			else{

				echo "<legend>Error al actualizar Usuario!</legend>";

			}

		}

	}



	/**

	 * Returns the data model based on the primary key given in the GET variable.

	 * If the data model is not found, an HTTP exception will be raised.

	 * @param integer the ID of the model to be loaded

	 */

	public function loadModel($id)

	{

		$model=Usuarios::model()->findByPk($id);

		if($model===null)

			throw new CHttpException(404,'The requested page does not exist.');

		return $model;

	}



	/**

	 * Performs the AJAX validation.

	 * @param CModel the model to be validated

	 */

	protected function performAjaxValidation($model)

	{

		if(isset($_POST['ajax']) && $_POST['ajax']==='usuarios-form')

		{

			echo CActiveForm::validate($model);

			Yii::app()->end();

		}

	}

        public function actionGenerateExcel()

	{

            $session=new CHttpSession;

            $session->open();		

            

             if(isset($session['Usuarios_records']))

               {

                $model=$session['Usuarios_records'];

               }

               else

                 $model = Usuarios::model()->findAll();



		

		Yii::app()->request->sendFile(date('YmdHis').'.xls',

			$this->renderPartial('excelReport', array(

				'model'=>$model

			), true)

		);

	}

        public function actionGeneratePdf() 

	{

           $session=new CHttpSession;

           $session->open();

		Yii::import('application.extensions.bootstrap.gii.*');

		require_once('bootstrap/tcpdf/tcpdf.php');

		require_once('bootstrap/tcpdf/config/lang/eng.php');



             if(isset($session['Usuarios_records']))

               {

                $model=$session['Usuarios_records'];

               }

               else

                 $model = Usuarios::model()->findAll();







		$html = $this->renderPartial('expenseGridtoReport', array(

			'model'=>$model

		), true);

		

		//die($html);

		

		$pdf = new TCPDF();

		$pdf->SetCreator(PDF_CREATOR);

		$pdf->SetAuthor(Yii::app()->name);

		$pdf->SetTitle('Usuarios Report');

		$pdf->SetSubject('Usuarios Report');

		//$pdf->SetKeywords('example, text, report');

		$pdf->SetHeaderData('', 0, "Report", '');

		$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, "Example Report by ".Yii::app()->name, "");

		$pdf->setHeaderFont(Array('helvetica', '', 8));

		$pdf->setFooterFont(Array('helvetica', '', 6));

		$pdf->SetMargins(15, 18, 15);

		$pdf->SetHeaderMargin(5);

		$pdf->SetFooterMargin(10);

		$pdf->SetAutoPageBreak(TRUE, 0);

		$pdf->SetFont('dejavusans', '', 7);

		$pdf->AddPage();

		$pdf->writeHTML($html, true, false, true, false, '');

		$pdf->LastPage();

		$pdf->Output("Usuarios_002.pdf", "I");

	}

}

