<?php
Yii::import('application.extensions.phpmailer.JPhpMailer');

class ToursCotizacionesController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/ansonika_site';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('@'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update','GeneratePdf','GenerateExcel'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new ToursCotizaciones;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['ToursCotizaciones']))
		{

			$model->attributes=$_POST['ToursCotizaciones'];
			$model->id_tour=substr($_POST['ToursCotizaciones']['id_tour'],2);
			$model->code="";
			$model->id_agencia = $_SESSION["agenciaUsuario"];
			$model->id_usuario = Yii::app()->user->id;
			//$model->fecha_viaje = implode("-", array_reverse(explode("/", $model->fecha_viaje)));
			$model->fecha_viaje = date("Y-m-d",strtotime($model->fecha_viaje));
			$model->estatus = "Solicitado";


			sort($_POST["num_edad"]);

		    $edad_menores = implode(",", $_POST["num_edad"]);


				// foreach ($_POST["num_edad"] as $edad) {
				// 	echo $edad;
				// }

			$model->edad_menores = $edad_menores;

			if($model->save()){
				//mail
				$id=$model->id_tours_cotizaciones;
				$this->enviarEmailCotizacion($id);
				//print_r($model->edad_menores);
				$this->redirect(array('view','id'=>$model->id_tours_cotizaciones));

			}
		}
		echo CJSON::encode($_POST);
		// $this->render('create',array('model'=>$model,));
	}

	public function enviarEmailCotizacion($id)
	{
		$model=$this->loadModel($id);

		if($model->num_menores > 0)
		{
			$menor = $edad_menores;
		}
		else
		{
			$menor = "No se han encontrado menores en la solicitud.";
		}

		$subject = "Su solicitud de cotización tour ".$model->idTour->nombre." ha sido creada con éxito";	
		
		$message = "<div align='center' style='font-family:helvetica'>
						<img src='http://".$_SERVER['SERVER_NAME']."".Yii::app()->baseUrl."/images/logo_rutamaya.jpg' border='1'>
						<div style='background:#2196f3;color:#fff;padding:24px;font-size:24px;font-weight:bold'>
							La solicitud de cotización de: ".$model->nombre_cliente."<br>
							ha sido creada con éxito.
						</div>
						<h4>Los datos de su cotización son:</h4>
						<p>No. de solicitud: <strong>".$model->id_tours_cotizaciones."</strong><br>
						Agencia: <strong>".$model->idAgencia->nombre_agencia."</strong><br>
						Tour: <strong>".$model->idTour->nombre."</strong><br>
						Fecha de Visita: <strong>".date('d/m/Y',strtotime($model->fecha_viaje))."</strong><br>
						Número de adultos: <strong>".$model->num_adultos."</strong><br>
						Número de menores: <strong>".$model->num_menores."</strong><br>
						Número de menores: <strong>".$menor."</strong><br>
						Comentarios: <strong>".$model->comentarios."</strong><br>

						
						<h4>SI TIENES ALGUNA DUDA CONTÁCTANOS, CON GUSTO TE ASESORAREMOS</h4>
						<h4>Tels: (999) 925-54-43</h4>
						<h4>Atentamente el equipo de Ruta Maya Travel</h4>
					</div>";

		
		$mail = new JPhpMailer;
		$mail->IsSMTP();
		$mail->Host = 'rutamayatravel.com'; 
		$mail->SMTPAuth = true;
		$mail->Username = 'no-reply@rutamayatravel.com'; 
		$mail->Port = '26'; 
		$mail->Password = 'Intelred76'; 
		$mail->SMTPKeepAlive = true;  
		$mail->Mailer = "smtp"; 
		$mail->IsSMTP();  
		$mail->SMTPAuth = true;  
		$mail->CharSet = 'utf-8';  
		$mail->SMTPDebug  = 0;
		$mail->SetFrom('no-reply@rutamayatravel.com', 'Sistema Ruta Maya Travel'); 
		$mail->Subject = $subject; 
		$mail->AltBody = 'To view the message, please use an HTML compatible email viewer!'; 
		$mail->AddReplyTo($model->idAgencia->email_agencia, $model->idAgencia->nombre_agencia);
		$mail->MsgHTML($message);
		// $mail->AddAddress($model->idUsuario->email_usuario, $model->idUsuario->nombre_usuario);
		// $mail->AddAddress($model->idAgencia->email_agencia, $model->idAgencia->nombre_agencia);

		// $mail->AddAddress('reservaciones@rutamayatravel.com');
		// $mail->AddAddress('soporte@rutamayatravel.com');
		$mail->AddAddress('programador3@rutamayatravel.com');

		$mail->Send();
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if($_POST['ToursCotizaciones'])
		{
			$model->attributes=$_POST['ToursCotizaciones'];

			$model->estatus = "Cotizado";
			$model->fecha_anexo = date("Y-m-d",strtotime($model->fecha_anexo));
			$model->usuario_anexo = Yii::app()->user->id;		

			$model->archivo=CUploadedFile::getInstance($model,'archivo');



			
			if($model->save())
			{
				$model->archivo->saveAs($_SERVER['DOCUMENT_ROOT'].'/archivos/toursCotizaciones/'.$model->archivo);

				
			}
		}
		$this->redirect(array('view','id'=>$model->id_tours_cotizaciones));
		/*$this->render('view',array(
			'model'=>$model,
		));*/
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		if(Yii::app()->request->isPostRequest)
		{
			// we only allow deletion via POST request
			$this->loadModel($id)->delete();

			// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
			if(!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
		}
		else
			throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
            $session=new CHttpSession;
            $session->open();		
            $criteria = new CDbCriteria();            

                $model=new ToursCotizaciones('search');
                $model->unsetAttributes();  // clear any default values

                if(isset($_GET['ToursCotizaciones']))
		{
                        $model->attributes=$_GET['ToursCotizaciones'];
			
			
                   	
                       if (!empty($model->id_tours_cotizaciones)) $criteria->addCondition("id_tours_cotizaciones = '".$model->id_tours_cotizaciones."'");
                     
                    	
                       if (!empty($model->log)) $criteria->addCondition("log = '".$model->log."'");
                     
                    	
                       if (!empty($model->id_agencia)) $criteria->addCondition("id_agencia = '".$model->id_agencia."'");
                     
                    	
                       if (!empty($model->id_usuario)) $criteria->addCondition("id_usuario = '".$model->id_usuario."'");
                     
                    	
                       if (!empty($model->id_tour)) $criteria->addCondition("id_tour = '".$model->id_tour."'");
                     
                    	
                       if (!empty($model->fecha_viaje)) $criteria->addCondition("fecha_viaje = '".$model->fecha_viaje."'");
                     
                    	
                       if (!empty($model->nombre_cliente)) $criteria->addCondition("nombre_cliente = '".$model->nombre_cliente."'");
                     
                    	
                       if (!empty($model->num_adultos)) $criteria->addCondition("num_adultos = '".$model->num_adultos."'");
                     
                    	
                       if (!empty($model->num_menores)) $criteria->addCondition("num_menores = '".$model->num_menores."'");
                     
                    	
                       if (!empty($model->edad_menores)) $criteria->addCondition("edad_menores = '".$model->edad_menores."'");
                     
                    	
                       if (!empty($model->comentarios)) $criteria->addCondition("comentarios = '".$model->comentarios."'");
                     
                    			
                    $session['ToursCotizaciones_records']=ToursCotizaciones::model()->findAll($criteria); 
		}
       

                $this->render('index',array(
			'model'=>$model,
		));

	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new ToursCotizaciones('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['ToursCotizaciones']))
			$model->attributes=$_GET['ToursCotizaciones'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model=ToursCotizaciones::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='tours-cotizaciones-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
        public function actionGenerateExcel()
	{
            $session=new CHttpSession;
            $session->open();		
            
             if(isset($session['ToursCotizaciones_records']))
               {
                $model=$session['ToursCotizaciones_records'];
               }
               else
                 $model = ToursCotizaciones::model()->findAll();

		
		Yii::app()->request->sendFile(date('YmdHis').'.xls',
			$this->renderPartial('excelReport', array(
				'model'=>$model
			), true)
		);
	}
        public function actionGeneratePdf() 
	{
           $session=new CHttpSession;
           $session->open();
		Yii::import('application.extensions.bootstrap.gii.*');
		require_once('bootstrap/tcpdf/tcpdf.php');
		require_once('bootstrap/tcpdf/config/lang/eng.php');

             if(isset($session['ToursCotizaciones_records']))
               {
                $model=$session['ToursCotizaciones_records'];
               }
               else
                 $model = ToursCotizaciones::model()->findAll();



		$html = $this->renderPartial('expenseGridtoReport', array(
			'model'=>$model
		), true);
		
		//die($html);
		
		$pdf = new TCPDF();
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor(Yii::app()->name);
		$pdf->SetTitle('ToursCotizaciones Report');
		$pdf->SetSubject('ToursCotizaciones Report');
		//$pdf->SetKeywords('example, text, report');
		$pdf->SetHeaderData('', 0, "Report", '');
		$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, "Example Report by ".Yii::app()->name, "");
		$pdf->setHeaderFont(Array('helvetica', '', 8));
		$pdf->setFooterFont(Array('helvetica', '', 6));
		$pdf->SetMargins(15, 18, 15);
		$pdf->SetHeaderMargin(5);
		$pdf->SetFooterMargin(10);
		$pdf->SetAutoPageBreak(TRUE, 0);
		$pdf->SetFont('dejavusans', '', 7);
		$pdf->AddPage();
		$pdf->writeHTML($html, true, false, true, false, '');
		$pdf->LastPage();
		$pdf->Output("ToursCotizaciones_002.pdf", "I");
	}



}
