<?php
Yii::import('application.extensions.phpmailer.JPhpMailer');
class TourController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column1';
	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}
	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view','reservar'),
				'users'=>array('@'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update','GeneratePdf','GenerateExcel','Deshabilitar', 'tarifas', 'booking'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('@'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}
	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id) {
	}

	public function actionTarifas() {
		$_SESSION["search_tour"] = $_GET;
		$tipo_destino = explode("_", $_GET["destino"]);
		switch ($tipo_destino[0]) {
			case 't':
				$id_destino = "T.id_tour = ". $tipo_destino[1];
				break;
			
			case 'd':
				$id_destino = "T.id_destino = ".  $tipo_destino[1];
				break;

			case 'c':
				$id_destino = "TC.idTipoCategoria = ". $tipo_destino[1];
				break;
		}
		$fecha_entrada = implode("-", array_reverse(explode("/", $_GET["fecha_entrada"])));
		//$tour_model = Tour::model()->with('fotosTour')->findAll($id_destino ." AND estatus = 1");
		$sql = "SELECT T.*, TC.nombre AS 'tipo', (SELECT imagen FROM tbl_tour_fotos WHERE id_tour = T.id_tour LIMIT 1) AS 'imagen' FROM tbl_tour T INNER JOIN tbl_tipo_categoria TC ON TC.idTipoCategoria = T.idTipoCategoria WHERE ". $id_destino ." AND T.estatus = 1";
		$tour_model = Yii::app()->db->createCommand($sql)->queryAll();
		$tour_model = CJSON::encode($tour_model);
		$array_model = CJSON::decode($tour_model, true);

		foreach ($array_model as $key_tour => $value_tour) {
			$sql_info = "SELECT TT.* FROM tbl_tour_tarifa TT INNER JOIN tbl_tour_tarifa_fechas TTF ON TTF.id_tarifa = TT.id_tarifa INNER JOIN tbl_tour_tarifa_diasvalidos TTDV ON TTDV.id_tour_tarifa = TT.id_tarifa WHERE TT.id_tour = ". $value_tour["id_tour"] ." AND TT.estatus = 1 AND ('". $fecha_entrada ."' BETWEEN TTF.fecha_ini AND TTF.fecha_fin) AND ((CURDATE() BETWEEN TT.fecha_precompra AND TT.fecha_limite) OR TT.fecha_precompra IS NULL) AND DATEDIFF('". $fecha_entrada ."', CURDATE()) >= TT.fecha_limite_dias AND TTDV.dia = DAYOFWEEK('". $fecha_entrada ."') AND TT.tipo_tarifa != 'PAQUETE'";
			$info_tour = Yii::app()->db->createCommand($sql_info)->queryAll();
			if(count($info_tour) > 0 || $value_tour["idTipoCategoria"] == "2" || $value_tour["idTipoCategoria"] == "7") {
				$array_model[$key_tour]["tarifas"] = $info_tour;
				$info_tour = CJSON::encode($info_tour);
				$array_info = CJSON::decode($info_tour, true);
				foreach ($array_info as $key => $value) {
					$tarifa_tour = TourTarifaDesglose::model()->findAll("id_tarifa = ". $value["id_tarifa"]);
					$tarifa_tour = CJSON::encode($tarifa_tour);
					$array_tarifa = CJSON::decode($tarifa_tour, true);
					$array_model[$key_tour]["tarifas"][$key]["desglose"] = $array_tarifa;
				}
			} else {
				unset($array_model[$key_tour]);
			}
		}
		echo json_encode($array_model);
	}

	public function actionFotosTour() {
		
	}

	public function actionReservar() {
		$id=1;
		$this->render('reservar',array(
			'model'=>$this->loadModel($id),
		));
	}
	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate() {
		$model=new Tour;
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);
		if(isset($_POST['Tour']))
		{
			$model->attributes=$_POST['Tour'];
			if($model->save())
				$this->redirect(array('update','id'=>$model->id_tour));
		}
		$this->render('_form',array(
			'model'=>$model,
		));
	}
	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id) {
		if(1<=$id): $model=$this->loadModel($id);
		else: $model=new Tour; 
		endif;	
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);
		if(isset($_POST['Tour']))
		{
			$model->attributes=$_POST['Tour'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id_tour));
		}
		$this->render('_form',array(
			'model'=>$model,
		));
	}

	/*public function actionDeshabilitar($id) {
		$model=$this->loadModel($id);
		$model->estatus=0;
		if($model->save())
		{
			$model=new Tour('search');
			$model->unsetAttributes();
			$this->render('admin',array(
			'model'=>$model
		));
		}
	}*/

	public function actionDeshabilitar() {
		if(Yii::app()->request->isPostRequest) {
			$ajax=$_POST['ajax'];
			$id=$_POST['id_tour'];
			$model=$this->loadModel($id);
			if($ajax=='Deshabilitar') {	
				$model->estatus=0;
				$title="Habilitar";
				$class="fa-circle text-danger";
			} else {
				$model->estatus=1;
				$title="Deshabilitar";
				$class="fa-ban text-danger";
			}
			if($model->save()) {
				echo '<a data-id_tour="'.$id.'" data-confirmar="" data-original-title="'.$title.'" onClick="if(confirm('."'¿Seguro que desea ".$title." este Tour?')) { return true; }else{ return false; }".'" class="deshabilitar"><i class="fa '.$class.' text-default m-r"></i></a>';
			}
		}
		else
			throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');
	}
	/*$model=new Tour('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Tour']))
			$model->attributes=$_GET['Tour'];
		$this->render('admin',array(
			'model'=>$model,
		));*/
	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete() {
		if(Yii::app()->request->isPostRequest) {
			$id=$_POST['id_tour'];
			$this->loadModel($id)->delete();
			echo $id;
		}
		else
			throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');
	}
	/**
	 * Lists all models.
	 */
	public function actionIndex() {
        $session=new CHttpSession;
        $session->open();		
        $criteria = new CDbCriteria();            
        $model=new Tour('search');
        $model->unsetAttributes();
		if(!empty($_GET['num_adultos'])) {
			$_SESSION['searchAct']['num_adultos'] = $_GET['num_adultos'];
		}
		$_SESSION['searchAct']['num_ninios'] = $_GET['num_ninios'];
		if(!empty($_GET['num_ninios'])) {
			for($j=1;$j<=$_GET['num_ninios'];$j++) {
				if(isset($_GET['num_edad']['edad_'.$j])) {
					$_SESSION['searchAct']['num_edad']['edad_'.$j]=$_GET['num_edad']['edad_'.$j];
				}
			}
		}
		$_SESSION['searchAct']['from'] = $_GET['fecha_entrada'];
		$_SESSION['searchAct']['to'] = $_GET['fecha_salida'];
		$habitaciones = $_SESSION['searchAct']['habs'];
		if(!empty($_GET["destino"])) {
			$model->estatus = 1;	
			$destino = explode('_',$_GET["destino"]);
			switch ($destino[0]) {
				case 'd':
					$id_destino = $destino[1];
					$model->id_destino = $id_destino;
					$_SESSION['searchAct']['destino'] = $_GET["destino"];
					break;
				case 't':
					$model->id_tour = $destino[1];
					$_SESSION['searchAct']['Tour'] = $_GET["destino"];
					break;
				case 'c':
					$model->idTipoCategoria = $destino[1];
					$_SESSION['searchAct']['categoriaTour'] = $_GET["destino"];
					break;
				default:
					break;
			}
		}
        if(isset($_GET['Tour'])) {
    		$model->attributes=$_GET['Tour'];
           	if (!empty($model->id_tour)) $criteria->addCondition("id_tour = '".$model->id_tour."'");
           	if (!empty($model->nombre)) $criteria->addCondition("nombre = '".$model->nombre."'");
           	if (!empty($model->nombre_en)) $criteria->addCondition("nombre_en = '".$model->nombre_en."'");
           	if (!empty($model->descripcion_corta)) $criteria->addCondition("descripcion_corta = '".$model->descripcion_corta."'");
           	if (!empty($model->descripcion_corta_en)) $criteria->addCondition("descripcion_corta_en = '".$model->descripcion_corta_en."'");
           	if (!empty($model->descripcion)) $criteria->addCondition("descripcion = '".$model->descripcion."'");
           	if (!empty($model->descripcion_en)) $criteria->addCondition("descripcion_en = '".$model->descripcion_en."'");
           	if (!empty($model->adicional)) $criteria->addCondition("adicional = '".$model->adicional."'");
           	if (!empty($model->adicional_en)) $criteria->addCondition("adicional_en = '".$model->adicional_en."'");
           	if (!empty($model->idTipoCategoria)) $criteria->addCondition("idTipoCategoria = '".$model->idTipoCategoria."'");
           	if (!empty($model->idTipoCategoria)) $criteria->addCondition("id_destino = '".$model->id_destino."'");
           	if (!empty($model->map_markers)) $criteria->addCondition("map_markers = '".$model->map_markers."'");
           	//$criteria->addCondition("estatus=1");
            $session['Tour_records']=Tour::model()->findAll($criteria); 
		}
        $this->render('index', array('model'=>$model,));
	}
	/**
	 * Manages all models.
	 */
	public function actionAdmin() {
		$model=new Tour('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Tour']))
			$model->attributes=$_GET['Tour'];
		$this->render('admin',array(
			'model'=>$model,
		));
	}
	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id) {
		$model=Tour::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}
	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model) {
		if(isset($_POST['ajax']) && $_POST['ajax']==='tour-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}

    public function actionGenerateExcel() {
        $session=new CHttpSession;
        $session->open();
     	if(isset($session['Tour_records'])) {
            $model=$session['Tour_records'];
       	}
       else
         	$model = Tour::model()->findAll();
		Yii::app()->request->sendFile(date('YmdHis').'.xls',
			$this->renderPartial('excelReport', array(
				'model'=>$model
			), true)
		);
	}
    
    public function actionGeneratePdf() {
       	$session=new CHttpSession;
       	$session->open();
		Yii::import('application.extensions.bootstrap.gii.*');
		require_once('bootstrap/tcpdf/tcpdf.php');
		require_once('bootstrap/tcpdf/config/lang/eng.php');
     	if(isset($session['Tour_records'])) {
            $model=$session['Tour_records'];
       	}
       else
         	$model = Tour::model()->findAll();
		$html = $this->renderPartial('expenseGridtoReport', array(
			'model'=>$model
		), true);
		//die($html);
		$pdf = new TCPDF();
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor(Yii::app()->name);
		$pdf->SetTitle('Tour Report');
		$pdf->SetSubject('Tour Report');
		//$pdf->SetKeywords('example, text, report');
		$pdf->SetHeaderData('', 0, "Report", '');
		$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, "Example Report by ".Yii::app()->name, "");
		$pdf->setHeaderFont(Array('helvetica', '', 8));
		$pdf->setFooterFont(Array('helvetica', '', 6));
		$pdf->SetMargins(15, 18, 15);
		$pdf->SetHeaderMargin(5);
		$pdf->SetFooterMargin(10);
		$pdf->SetAutoPageBreak(TRUE, 0);
		$pdf->SetFont('dejavusans', '', 7);
		$pdf->AddPage();
		$pdf->writeHTML($html, true, false, true, false, '');
		$pdf->LastPage();
		$pdf->Output("Tour_002.pdf", "I");
	}
}