<?php
error_reporting(E_ERROR | E_WARNING | E_PARSE);
Yii::import('application.extensions.phpmailer.JPhpMailer');
Yii::import('application.extensions.bootstrap.gii.*');
require_once('bootstrap/tcpdf/tcpdf.php');
require_once('bootstrap/tcpdf/config/lang/eng.php');

class MYPDF extends TCPDF {
	public $footer = "";
	public $model_contract = "";
	public $tipo_bloqueo = "";
	private $last_page = false;

	public function Close() {
		$this->last_page = true;
		parent::Close();
	}
	
	function setParams($contacto, $model_c, $tipo) {
		$this->contacto_agencia = $contacto;
		$this->model_contract = $model_c;
		$this->tipo_bloqueo = $tipo;
	}

	//Page header
    public function Header() {
        // Logo
    	$this->Image(($_SERVER['DOCUMENT_ROOT'] ."/archivos/contratos/logo-rmt.PNG"), 20, 5, 30, '', 'PNG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        if($this->tipo_bloqueo == "GRUPAL")
        	$this->Image(($_SERVER['DOCUMENT_ROOT'] ."/archivos/contratos/logo-grupos.PNG"), 155, 5, 30, '', 'PNG', '', 'T', false, 300, '', false, false, 0, false, false, false);
		else if($this->tipo_bloqueo="BODA")
			$this->Image(($_SERVER['DOCUMENT_ROOT'] ."/archivos/contratos/logo-casate-conmigo.png"), 155, 10, 30, '', 'PNG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        // Set font
        $this->SetFont('helvetica', 'B', 20);
        // Title
        $this->Cell(0, 15, "", 0, false, 'C', 0, '', 0, false, 'M', 'M');
		//$this->writeHTML("AAAAAAAAAAAAAAAAAAA", true, false, false, false, "");
    }

    // Page footer
    public function Footer() {
    	$contacto="";
    	if (!$this->last_page) {
    		$contacto= $this->contacto_agencia;
    	}
			$this->footer = "
			<table>
				<tr>
					<td>Av. Cupúles # 236 por 20 y 22 Col. García Ginerés C.P. 97070,</td>
					<td></td>
					<td></td>
					<td></td>
				</tr>
				<tr>
					<td>Mérida, Yucatán Tels. (999) 925 5443</td>
					<td></td>
					<td>". $contacto."</td>
					<td></td>
				</tr>
				<tr>
					<td>www.rutamayatravel.com</td>
					<td>Página ". $this->getAliasNumPage()." de ".$this->getAliasNbPages() ."</td>
					<td></td>
					<td><img src='".$_SERVER['DOCUMENT_ROOT'] ."/archivos/contratos/negrogarantia.png' with='50'></td>
				</tr>
			</table>";
			// Position at 15 mm from bottom
			$this->SetY(-20);
			// Set font
			$this->SetFont('helvetica', 'I', 8);
			// Page number
			//$this->Cell(0, 10, 'Page '.$this->getAliasNumPage().' of '.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
			//$this->Cell(0, 10, $this->footer, 0, false, 'C', 0, '', 0, false, 'T', 'M');
			//$this->writeHTML($this->footer, false, true, false, true); //ORIGINAL
			if(!$this->last_page) {
				if($this->model_contract->status == "S" ){
					$this->Image(($_SERVER['DOCUMENT_ROOT'] ."/archivos/contratos/firmas/". $this->model_contract->id_user_signed ."-signature.jpg"), 105, 268, 60, 20, 'JPG', '', '', true, 150, '', false, false, 0, false, false, false);
				}
			} 
			$this->writeHTML($this->footer, true, false, false, false, "");
			$this->Image(($_SERVER['DOCUMENT_ROOT'] ."/archivos/contratos/negrogarantia.png"), 170, 270, 30, '', 'PNG', '', 'T', false, 100, '', false, false, 0, false, false, false);
			//$this->writeHTMLCell(0, 0, '', '', $this->footer, 0, 0, false,true, "L", true);
    }
}

class TestsController extends Controller {
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/ansonika_site';
	/**
	 * @return array action filters
	 */
	/*public function filters() {
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}*/
	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	/*public function accessRules() {
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index', 'getCadenasWithWeddings', 'getPaquetesBoda', 'first', 'cropImage', 'signature', 'signContract', 'uploadImgBase64', 'getSignatureBase64', 'signaturePDF', 'viewContract','mailEnlaceContratos'),
				'users'=>array('*'),
			),
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('echo'),
				'users'=>array('@'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}*/

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionIndex() {
		$this->render("index");
	}

	public function actionCropImage() {
		$this->render("cropImage");
	}

	public function actionSignature() {
		$this->render("signature");
	}

	public function actionViewContract($id, $us) {
		$this->layout='//layouts/homey_blanco';
		
		$id_us = base64_decode($us);
		$model_user = User::model()->findByPk($id_us);
		$model_contract = Contracts::model()->find("id_bloqueo = ". $id);

		if(is_null($model_user->id)) {
			$this->render("errorPDF", array(
				"error" => "NO SE HA ENCONTRADO NINGÚN USUARIO QUE COINCIDA CON ESTE CONTRATO."
			));
		} else if(is_null($model_contract->id_contract)) {
			$this->render("errorPDF", array(
				"error" => "NO SE CREÓ NINGÚN CONTRATO PARA ESTE GRUPO."
			));
		}  else if($model_contract->status == "S") {
			$this->render("errorPDF", array(
				"error" => "ESTE CONTRATO YA HA SIDO FIRMADO PREVIAMENTE."
			));
		} else {
			$this->render("viewContract");
		}
	}

	public function actionUploadImgBase64() {
		$data = $_POST["base64img"];
		list($type, $data) = explode(';', $data);
		list(, $data) = explode(',', $data);
		$data = base64_decode($data);
		$url = $_POST["type"] == "signature" ? "firmas" : "logos";
		/*echo $_SERVER['DOCUMENT_ROOT'] ."/archivos/contratos/". $url ."/image.png";
		exit;*/

		$id_user = Yii::app()->user->id;
		$model_signature = Signatures::model()->find("id_user = ". $id_user);
		$model_signature->signature = $id_user ."-signature.jpg";
		if(!isset($model_signature->id_signature)) {
			$model_signature = new Signatures;
			$model_signature->id_user = $id_user;
			$model_signature->save();
		}
		
		echo file_put_contents($_SERVER['DOCUMENT_ROOT'] ."/archivos/contratos/". $url ."/". $model_signature->signature, $data);
	}

	public function uploadSignatureBase64($base64img, $id_usuario) {
		//$data = $_POST["base64img"];
		$data = $base64img;
		list($type, $data) = explode(';', $data);
		list(, $data) = explode(',', $data);
		$data = base64_decode($data);
		//$url = $_POST["type"] == "signature" ? "firmas" : "logos";
		$url = "firmas";
		/*echo $_SERVER['DOCUMENT_ROOT'] ."/archivos/contratos/". $url ."/image.png";
		exit;*/
		//$id_user = Yii::app()->user->id;
		$id_user = $id_usuario;
		$model_signature = Signatures::model()->find("id_user = ". $id_user);
		if(is_null($model_signature->id_signature)) {
			$model_signature = new Signatures;
			$model_signature->signature = $id_user ."-signature.jpg";
			$model_signature->id_user = $id_user;
			$model_signature->save();
		}
		
		return file_put_contents($_SERVER['DOCUMENT_ROOT'] ."/archivos/contratos/". $url ."/". $model_signature->signature, $data);
	}

	public function actionSignContract() {
		$params = $_POST;
		$id_usuario = base64_decode($_POST["id_us"]);

		$model_signature = Signatures::model()->find("id_user = ". $id_usuario);
		$model_contract = Contracts::model()->find("id_bloqueo = ". $params["id_bloqueo"]);

		if($model_contract->status == "S") {
			echo "El contrato ya ha sido firmado con anterioridad.";
			
			exit;
		}
		

		if(is_null($model_signature->id_signature) || $_POST["edited"]) {
			$this->uploadSignatureBase64($params["base64img"], $id_usuario);
		}

		//$model_contract->id_user_signed = Yii::app()->user->id;
		$model_contract->id_user_signed = $id_usuario;
		$model_contract->status = "S";
		$model_contract->time = date("H:i:s");
		$model_contract->date = date("Y-m-d");
		$model_contract->ip = $_SERVER['REMOTE_ADDR'];
		$model_contract->save();
		$this->sendAdviceSignedContract($model_contract);
		echo CJSON::encode($model_contract);
	}	

	public function actionEcho() {
		//echo 'http://'.$_SERVER["SERVER_NAME"].Yii::app()->request->baseUrl.'/getTarifas/ObtenerTarifas';
		//echo date("H:i:s");
		$rmt_url = Yii::app()->baseUrl ."/admin";
      	$rmt_url = substr($rmt_url, 0, -5);
      	echo $rmt_url;
	}

	public function sendAdviceSignedContract($model_contract) {
		$model_bloqueo=Bloqueos::model()->findByPk($_POST['id_bloqueo']);
		$message = "Buenas tardes. Es un gusto saludarle. <br>Por este medio le confirmamos que su contrato del grupo: <b>". $model_contract->id_bloqueo  .", ". $model_bloqueo->titulo_evento ."</b> ha sido firmado con éxito.";
		$message.=$this->renderPartial('//bloqueos/_informacionEvento',array('model'=>$model_bloqueo),true);
		$message.="<p>Sin más por el momento, quedo a sus órdenes.</p> <p>Saludos cordiales.</p>";
		$mail = new JPhpMailer;
		$mail->IsSMTP();
		$mail->Host = 'rutamayatravel.com'; 
		$mail->SMTPAuth = true;
		$mail->Username = 'no-reply@rutamayatravel.com'; 
		$mail->Port = '26'; 
		$mail->Password = 'Intelred76'; 
		$mail->SMTPKeepAlive = true;  
		$mail->Mailer = "smtp"; 
		$mail->IsSMTP();  
		$mail->SMTPAuth = true;  
		$mail->CharSet = 'utf-8';  
		$mail->SMTPDebug  = 0;
		//$mail->SetFrom('no-reply@rutamayatravel.com', 'Sistema Ruta Maya Travel'); 
		$mail->Subject = "Contrato firmado"; 
		$mail->AltBody = 'To view the message, please use an HTML compatible email viewer!'; 
		$mail->MsgHTML($message);

		$model_user = Usuarios::model()->findByPk($model_contract->id_user_created);
		$model_user_agencia = Usuarios::model()->findByPk($model_contract->id_user_signed);
		$mail->SetFrom($model_user->email_usuario, $model_user->nombre_usuario); 
		$mail->AddAddress($model_user_agencia->email_usuario, $model_user_agencia->nombre_usuario);
		//$mail->AddAddress("programador4@rutamayatravel.com", $model_user_agencia->nombre_usuario);
		//$mail->AddAddress($model_user->email_usuario, $model_user->nombre_usuario);
		//$mail->AddBCC("grupos1@rutamayatravel.com");
		//$mail->AddBCC("grupos2@rutamayatravel.com");
		//
		if ($model_bloqueo->idTarifa->precio=="BODA") {
			$mail->AddBCC("bodas@rutamayatravel.com");
			$mail->AddBCC("sugely.lizama@rutamayatravel.com");
			
		}else{
			$mail->AddBCC("leticiavarguez@rutamayatravel.com");

		}
		$mail->AddBCC("programador2@rutamayatravel.com");
		$mail->AddBCC("jorgevadillo@rutamayatravel.com");
		//$mail->AddBCC($model_user->email_usuario);
		$mail->Send();
	}

	public function actionGetSignatureBase64($id_us) {
		//$id_user = Yii::app()->user->id;
		$id_user = base64_decode($id_us);
		//$id_user = 1432;
		$signature = Signatures::model()->find("id_user = ". $id_user);
		if(is_null($signature->id_signature)) {
			echo "not found";
		} else {
			echo base64_encode(file_get_contents($_SERVER['DOCUMENT_ROOT'] ."/archivos/contratos/firmas/". $id_user ."-signature.jpg"));
		}
	}

	public function actionSignaturePDF($id_bloqueo) {
		$model_contract = Contracts::model()->find("id_bloqueo = ". $id_bloqueo);
		$model_bloqueo = Bloqueos::model()->findByPk($id_bloqueo);
		$model_agencia = Agencias::model()->findByPk($model_bloqueo->id_agencia);
		$model_user_created = Usuarios::model()->findByPk($model_contract->id_user_created);
		$model_hotel = Hoteles::model()->findByPk($model_bloqueo->id_hotel);
		$model_plan = Plan::model()->findByPk($model_bloqueo->id_tipo_plan);
		$model_tipo_hab = TipoHabitaciones::model()->findByPk($model_bloqueo->id_tipo_habitacion);
		$model_tarifa = Tarifa::model()->findByPk($model_bloqueo->id_tarifa);
		$model_tarifa_desglose = TarifaDesglose::model()->findAll("id_tarifa = ". $model_bloqueo->id_tarifa);
		$model_desglose_menores = DesgloseMenores::model()->findAll("id_tarifa = ". $model_bloqueo->id_tarifa);
		$model_cortesias = Roominglist::model()->findAll("id_bloqueo = ". $id_bloqueo ." AND cortesia = 1");
		$model = Roominglist::model()->findAll("id_bloqueo = ". $id_bloqueo);

		$desglose=$this->desgloseReservacion($model[0]);
		//echo json_encode($desglose);
		if(!is_null($model_contract->id_user_signed)) {
			$model_signature_signed = Signatures::model()->find("id_user = ". $model_contract->id_user_signed);
		}
		$model_signature_rmt = Signatures::model()->find("id_user = ". $model_contract->id_user_created);

		$model_politica_pago = GruposPoliticasPagos::model()->find("id_bloqueo = ". $id_bloqueo);
		if(count($model_politica_pago) == 0) {
			$this->render("errorPDF", array(
				"error" => "NO DIO DE ALTA UNA POLÍTICA DE PAGO, POR FAVOR AGREGUE UNA E INTENTE DE NUEVO."
			));
		} else {
			$model_pagos_desglose = GruposPoliticasPagosDesglose::model()->findAll(array("condition" => "id_politicas_pagos = ". $model_politica_pago->id_politicas_pagos, "order" => "fecha"));
			//$model_pagos_desglose = GruposPoliticasPagosDesglose::model()->findAll("id_politicas_pagos = ". $model_politica_pago->id_politicas_pagos);
			if(count($model_pagos_desglose) == 0) {
				$this->render("errorPDF", array(
					"error" => "NO DIO DE ALTA NINGUNA FECHA DE PAGO, POR FAVOR AGREGUE AL MENOS UNA E INTENTE DE NUEVO."
				));
			}
		}

		$html = $this->renderPartial("contractHtmlToPdf", array(
			"model_contract" => $model_contract,
			"model_bloqueo" => $model_bloqueo,
			"model_agencia" => $model_agencia,
			"model_user_created" => $model_user_created,
			"model_hotel" => $model_hotel,
			"model_plan" => $model_plan,
			"model_tipo_hab" => $model_tipo_hab,
			"model_tarifa" => $model_tarifa,
			"model_tarifa_desglose" => $model_tarifa_desglose,
			"model_desglose_menores" => $model_desglose_menores,
			"model_cortesias" => $model_cortesias,
			"model_politica_pago" => $model_politica_pago,
			"model_pagos_desglose" => $model_pagos_desglose,
			"model_signature_signed" => $model_signature_signed,
			"model_signature_rmt" => $model_signature_rmt,
			"desglose"=>$desglose,
		), true);

		/* echo $html_footer;
		exit; */

		$pdf = new MYPDF();
		//$pdf->setParams($html_footer, $model_contract, "0");
		$contacto = is_null($model_agencia->representante_legal) || empty($model_agencia->representante_legal) ? $model_agencia->contacto : $model_agencia->representante_legal;
		$pdf->setParams($contacto, $model_contract, $model_tarifa->precio);
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor(Yii::app()->name);
		$pdf->SetTitle("Contrato");
		$pdf->SetSubject("Contrato");
		$pdf->SetMargins(20, 35, 20);

		$pdf->setPrintHeader(true);
		$pdf->SetHeaderMargin(10);

		$pdf->setPrintFooter(true);
		$pdf->SetFooterMargin(10);

		$pdf->SetAutoPageBreak(TRUE, 30); //SEGUNDO PARAMETRO PARA MARGIN BOTTOM
		$pdf->SetFont('dejavusans', '', 10);
		// $pdf->setPageOrientation('L');
		$pdf->AddPage();
		// get the current page break margin
		$bMargin = $pdf->getBreakMargin();
		// get current auto-page-break mode
		$auto_page_break = $pdf->getAutoPageBreak();
		// disable auto-page-break
		$pdf->SetAutoPageBreak(false, 0);

		// set bacground image
		//$img_file = K_PATH_IMAGES . $model_event->flyer;

		//$pdf->Image($img_file, 0, 10, 210, 277, '', '', '', false, 300, '', false, false, 0);
		// restore auto-page-break status
		$pdf->SetAutoPageBreak($auto_page_break, $bMargin);
		// set the starting point for the page content
		$pdf->setPageMark();

		$pdf->writeHTML($html, true, false, true, false, '');
		$pdf->LastPage();

		$pdf->Output("contrato.pdf", "I");
		if ($model_contract->status=="S") {
			if (!file_exists($_SERVER['DOCUMENT_ROOT'] ."/archivos/contratos/contratosFirmados/contrato_firmado_".$model_bloqueo->id_bloqueo.'.pdf')) {
				$pdf->Output($_SERVER['DOCUMENT_ROOT'] ."/archivos/contratos/contratosFirmados/contrato_firmado_".$model_bloqueo->id_bloqueo.'.pdf', "F");
			}
		}
	}

	public function desgloseReservacion($model)
	{
		

		$datos=array(); $menores=array(); $precioNoche=array();
		$Total = array();
		$maxT = 0;
		$tarifaAgencias="";
		$agenciaUsuario="";
		$tarifaEstados="";
	/*	if($_SESSION["agenciaUsuario"] != 9){
			$tarifaAgencias = ' and not exists(select NULL from tbl_tarifa_agencia tarifaAgencias where tarifaAgencias.id_tarifa=t.id_tarifa and tarifaAgencias.id_agencia!='.$_SESSION["agenciaUsuario"].')';
			$agenciaUsuario = Agencias::model()->findByPk($_SESSION["agenciaUsuario"]);
			$tarifaEstados = ' and exists(select NULL from tbl_tarifa_estados tarifaEstados where tarifaEstados.id_tarifa=t.id_tarifa and tarifaEstados.id_estado='.$agenciaUsuario->id_estado_agencia.')';
		}*/
		$bloqueo = Bloqueos::model()->findByPk($model->id_bloqueo);
		$origin = date_create($bloqueo->fecha_inicio);
		$target = date_create($bloqueo->fecha_final);
		$interval = date_diff($origin, $target);
		$noches=$interval->format('%a');
		$fecha_promo = ' and "'.date('Y-m-d',strtotime($bloqueo->fecha_inicio)).'" between fecha_promo_inicio and fecha_promo';
		$precompraMenor = 'fecha_inicio_precompra is null or "'.date('Y-m-d',strtotime($bloqueo->fecha_inicio)).'" between fecha_inicio_precompra and fecha_final_precompra';
		for($dia=0; $dia<$noches; $dia++)
		{
			$fecha= date("Y-m-d", strtotime(implode("-", array_reverse(explode("-", $bloqueo->fecha_inicio))))+$dia*24*60*60);
			$fechadia = strtotime(implode("-", array_reverse(explode("-", $bloqueo->fecha_inicio))))+$dia*24*60*60;
				
				$tipo_precio = $bloqueo->idTarifa->precio;
				$tarifa = Tarifa::model()->with('tarifaDiasvalidos')->findAll(array('condition'=>'t.id_tarifa='.$bloqueo->id_tarifa.'   and precio="'.$tipo_precio.'" and estatus=1 and dia='.date("N",$fechadia).' and "'.$fecha.'" between t.fecha_inicial and t.fecha_final  and not exists(select NULL from tbl_fechas_bloqueadas tarifaFechasbloqueadas where "'.$fecha.'" between tarifaFechasbloqueadas.fecha_inicio and tarifaFechasbloqueadas.fecha_final and tarifaFechasbloqueadas.id_tipo_habitacion is null and tarifaFechasbloqueadas.id_tarifa=t.id_tarifa)', 'order'=>'precio'));
			
			
			
			
			if($maxT > count($tarifa))
			{
				$tarifaComb = Tarifa::model()->with('tarifaDiasvalidos')->findAll(array('condition'=>'id_hotel='.$bloqueo->id_hotel.' and id_tipo_plan='.$bloqueo->idTarifa->id_tipo_plan.' '.$fecha_promo.' and precio="'.$tipo_precio.'" and promocontigua=1 and estatus=1 and dia='.date("N",$fechadia).' and "'.$fecha.'" between t.fecha_inicial and t.fecha_final', 'limit'=>1));
				if(!empty($tarifaComb)){
					$tarifa = (object) array_merge((array) $tarifa, (array) $tarifaComb);
					$combinada = true;
					$combT = $maxT - 1;
				}else{
					$tarifa = (object) array_merge((array) $tarifa, (array) $tarifa);
					$combinada = true;
					$combT = $maxT - 1;
				}
			}
			$t = 0;
			foreach($tarifa as $row)
			{
				$costoTotal = 0;
				$habitacion = Roominglist::model()->findAll('id_roominglist='.$model->id_roominglist);
				$i=1;
				foreach($habitacion as $hab)
				{
					$base = 2;							
					$tarifaDesglose = TarifaDesglose::model()->find('id_tarifa='.$row->id_tarifa.' and id_tipo_habitacion='.$hab->idBloqueo->id_tipo_habitacion.' and id_base_habitacion='.$base);
					$nocheGratis = NochesGratis::model()->find('id_tarifa='.$row->id_tarifa.' and (id_tipo_habitacion is null or id_tipo_habitacion='.$hab->idBloqueo->id_tipo_habitacion.')' );
					if(!empty($nocheGratis) && (($dia+1) % $nocheGratis->noche == 0)){
						if(($dia+1) > $nocheGratis->noche && $nocheGratis->acumulable != 1){
							$nocheGratis = false;
						}else{
							$tarifaDesglose->precio_normal = 0;
							$nocheGratis = true;
						}
					}
					//$suplemento = $this->Sumarsuplemento($model->idBloqueo->id_tarifa,$fecha,$tarifaDesglose->id_base_habitacion,'A',NULL);
					$costoAdultos = $tarifaDesglose->precio_normal + $suplemento;

					

					$datos[$dia][$t][$i]['adultos'] = number_format($costoAdultos,'2','.',',');
					$costoMenores = 0;
					$menorgratis = 0;
					$persona = RoominglistDesglose::model()->findAll('id_roominglist='.$model->id_roominglist.' and tipo="N"');
					$n=1;
					$niniopaga = 1;
					foreach($persona as $menor)
					{
						$tarifaMenor=DesgloseMenores::model()->find("id_tarifa=".$row->id_tarifa." and id_tipo_habitacion=".$model->idBloqueo->id_tipo_habitacion." and ".$menor->edad." <= edad_max_menor and num_evaluar=".$niniopaga." and es_junior=0 and(".$precompraMenor.") and(fecha_inicio is null or '".$fecha."' between fecha_inicio and fecha_final) ORDER BY precio ASC");
						if(empty($tarifaMenor)){
							$tarifaMenor=DesgloseMenores::model()->find("id_tarifa=".$row->id_tarifa." and id_tipo_habitacion=".$$model->idBloqueo->id_tipo_habitacion." and ".$menor->edad." between edad_min_menor and edad_max_menor and es_junior=1 and(".$precompraMenor.") and(fecha_inicio is null or '".$fecha."' between fecha_inicio and fecha_final) ORDER BY precio ASC");
						}
						if($tarifaMenor->es_junior != 1)$niniopaga++;
						if($menor->edad < $tarifaMenor->edad_min_menor || $nocheGratis == true)$tarifaMenor->precio = 0;
						$suplemento = $this->Sumarsuplemento($row->id_tarifa,$fecha,0,'N',$menor->edad);
						$precioMenor = $tarifaMenor->precio + $suplemento;
						$costoMenores += $precioMenor;
						$menores[$dia][$t][$i] .= "Menor ".$n.": $ ".number_format($precioMenor,'2','.',',')." / ";
						$n++;
					}
					

					$datos[$dia][$t][$i]['menores'] = number_format($costoMenores,'2','.',',');
					$costoHabitacion = $costoAdultos + $costoMenores;
					$costoTotal += $costoHabitacion;
					$precioNoche[$dia][$t] += $costoHabitacion;
					$datos[$dia][$t][$i]['fecha'] = date("d M y", strtotime($fecha));
					$datos[$dia][$t][$i]['total'] = number_format($costoHabitacion,'2','.',',');
					$i++;
				}
				if($combinada == true && $Total[$t]['codigo'] != $row->codigo)
				{
					if(strpos($Total[$t]['nombre'], $row->nombre_tarifa) === FALSE){
						$Total[$t]['nombre'] .= " + ".$row->nombre_tarifa;
						$Total[$t]['codigo'] .= " + ".$row->codigo;
					}
					if($row->restricciones != ""){
						$Total[$t]['restricciones'] .= "<br><br>Otras Restricciones: ".$row->restricciones;
					}
				}
				else{
					$Total[$t]['tarifa'] = $row->id_tarifa;
					$Total[$t]['nombre'] = $row->precio." ".$row->nombre_tarifa;
					$Total[$t]['codigo'] = $row->codigo;
					$Total[$t]['min_noches'] = $row->min_noches;
					$Total[$t]['restricciones'] = $row->restricciones;
					$Total[$t]['moneda'] = 'MXN';
				}
				$Total[$t]['total'] += $costoTotal;
				$costoM+=$costoMenores;
				
				$t++;
				if($maxT < $t) $maxT = $t;
			}
		}
		for($j=0;$j<$maxT;$j++)
		{
			if(number_format($Total[$j]['total'],1))
			{
				$t = $j;
			}
		}
		return array($datos,$Total,$t,$menores,$precioNoche);
	}

	public function Sumarsuplemento($tarifa,$fecha,$base,$persona,$edad)
	{
		if($persona == 'A')
		{
			$suplementos = Suplemento::model()->findAll('id_tarifa='.$tarifa.' and persona="'.$persona.'" and "'.$fecha.'" between fecha_inicio and fecha_final');
		}
		else if($edad != NULL)
		{		
			$suplementos = Suplemento::model()->findAll('id_tarifa='.$tarifa.' and persona="'.$persona.'" and "'.$fecha.'" between fecha_inicio and fecha_final and '.$edad.' between edad_min and edad_max');
		}
		else{
			$suplementos = Suplemento::model()->findAll('id_tarifa='.$tarifa.' and persona="'.$persona.'" and "'.$fecha.'" between fecha_inicio and fecha_final');
		}
		$importe = 0;
		foreach($suplementos as $row)
		{
			$importe+=$row->publico;
		}
		if($persona == 'A')$importe *= $base;
		return $importe;
	}

	public function getActions() {
        $path = Yii::app()->controllerPath;
        $data = array();
        $files = CFileHelper::findFiles($path, array("fileTypes" => array("php")));
        //echo json_encode($files);
        $index = array_search("/home/rutamayatravel/public_html/sur4demo/protected/controllers/TestsController.php", $files);
        $filename = basename($files[$index], '.php');
        if (($pos = strpos($filename, 'Controller')) > 0) {
            $class_name = $controllers[] = substr($filename, 0, $pos);
            $f = new ReflectionClass($filename);
            $methods = array();
            foreach ($f->getMethods() as $m) {
                if ($m->class == $class_name . "Controller" && preg_match('/^action+\w{2,}/', $m->name)) {
                    $methods[] = str_replace("action", "", $m->name);
                }
            }
            //$data[$filename] = $methods;
        }
        return $methods;
    }

    // Metodo orignial de getActions
    public function getControllers() {
        $path = Yii::app()->controllerPath;
        $data = array();
        $files = CFileHelper::findFiles($path, array("fileTypes" => array("php")));
        foreach ($files as $file) {
            include_once $file;
            $filename = basename($file, '.php');
            if (($pos = strpos($filename, 'Controller')) > 0) {
                $class_name = $controllers[] = substr($filename, 0, $pos);
                $f = new ReflectionClass($filename);
                $methods = array();
                foreach ($f->getMethods() as $m) {
                    if ($m->class == $class_name . "Controller" && preg_match('/^action+\w{2,}/', $m->name)) {
                        $methods[] = str_replace("action", "", $m->name);
                    }
                }
                $data[$filename] = $methods;
            }
        }
        return $data;
    }

	public function actionGetCadenasWithWeddings() {
		$query = "SELECT * FROM tbl_cadena_hotel CH WHERE CH.id IN (SELECT H.id_hotel FROM tbl_hoteles H WHERE H.id_hotel IN (SELECT PB.id_hotel FROM tbl_paquetes_boda PB));";
		$model_cadenas = Yii::app()->db->createCommand($query)->queryAll();
		echo CJSON::encode($model_cadenas);
	}

	public function actionGetPaquetesBoda($type = null, $id = null) {
		if($type == null) 
			$query = "SELECT * FROM tbl_hoteles H WHERE H.id_hotel IN (SELECT PB.id_hotel FROM tbl_paquetes_boda PB);";
		else if($type == "d")
			$query = "SELECT * FROM tbl_hoteles H WHERE H.id_hotel IN (SELECT PB.id_hotel FROM tbl_paquetes_boda PB) AND H.id_destino = ". $id .";";
		else
			$query = "SELECT * FROM tbl_hoteles H WHERE H.id_hotel IN (SELECT PB.id_hotel FROM tbl_paquetes_boda PB) AND H.id_cadena = ". $id .";";

		$model_hoteles = Yii::app()->db->createCommand($query)->queryAll();
		foreach ($model_hoteles as $key => $hotel) {
			$criteria = new CDbCriteria();
			$criteria->addCondition("visibilidad = 1 AND tipo_paquete = 'Bodas' AND id_hotel = ". $hotel["id_hotel"] ." AND CURDATE() < fecha_vigencia");
			$criteria->order = "id_paquete DESC";

			$hotel["paquetes_boda"] = PaquetesBoda::model()->findAll($criteria);
		}
		echo CJSON::encode($model_hoteles);
	}

	public function actionFirst() {
		$this->render('first');
	}
	public function actionTest()
	{
		$model=Bloqueos::model()->findByPk(1758);
		$this->renderPartial('//bloqueos/_informacionEvento',array('model'=>$model));
	}
	
	public function actionMailEnlaceContratos()
	{
		//$id=explode('id=', $_POST['email_enlace']);
		$emailrmt = Yii::app()->user->email;
		if (Yii::app()->user->id==51) {
			$emailrmt = "bodas@rutamayatravel.com";
		}
		
		$model = Bloqueos::model()->findByPk($_POST['id_bloqueo']);
		/*$encabezados  = "MIME-Version: 1.0\n";
		$encabezados .= "Content-type: text/html; charset=UTF-8\n";
		$encabezados .= "From:  Ruta Maya Travel <".$emailrmt.">\n";
		$encabezados .= 'Cc: '.$emailrmt. "\r\n";
		$encabezados .= "X-Sender: <contacto web>\n";
		$encabezados .= "X-Mailer: PHP\n";
		$encabezados .= "X-Priority: 3\n";
		$encabezados .= "Return-Path: <web page>\n";
		$fecha = date("d-m-Y H:i:s");
		$recipent = $_POST["email_enlace"];
		$subject = "Enlace de Contrato de grupo: ".$model->titulo;*/
		$styles = "<style>
			.button {
				border-radius: 2px;
				padding: 8px 12px;
    			border: 1px solid #ED2939;
    			border-radius: 2px;
    			font-family: Helvetica, Arial, sans-serif;
    			font-size: 14px;
    			background-color: #ED2939;
    			color: #ffffff;
    			text-decoration: none;
    			font-weight: bold;
    			display: inline-block;
			}</style>";
		$message = $styles ."
				<center><b>RUTA MAYA TRAVEL</b>
				<p>
					Agradeciendo la preferencia, por este medio le envío el siguiente enlace para la revisión del convenio ". $model->idTarifa->precio. ", solicitamos su revisión y estando todo en orden solicitamos por favor firmar digitalmente.
				</p>";
		$message .= $this->renderPartial('//bloqueos/_informacionEvento',array('model'=>$model), true);
		$message .= "<a class='button' href=". $_POST['enlace']. ">Ir a firma en linea</a></center>";
		$mail = new JPhpMailer;
		$mail->IsSMTP();
		$mail->Host = 'rutamayatravel.com'; 
		$mail->SMTPAuth = true;
		$mail->Username = 'no-reply@rutamayatravel.com'; 
		$mail->Port = '26'; 
		$mail->Password = 'Intelred76'; 
		$mail->SMTPKeepAlive = true;  
		$mail->Mailer = "smtp"; 
		$mail->IsSMTP();  
		$mail->SMTPAuth = true;  
		$mail->CharSet = 'utf-8';  
		$mail->SMTPDebug  = 0;
		//$mail->SetFrom('no-reply@rutamayatravel.com', 'Sistema Ruta Maya Travel'); 
		$mail->Subject = "Enlace de Contrato de grupo: ". $model->titulo;
		$mail->AltBody = 'To view the message, please use an HTML compatible email viewer!'; 
		$mail->MsgHTML($message);

		
		$mail->SetFrom($emailrmt, "Ruta Maya Travel");
		$mail->AddAddress($_POST["email_enlace"],$_POST["email_enlace"]);
		//$mail->AddAddress("programador4@rutamayatravel.com", $model_user_agencia->nombre_usuario);
		//$mail->AddAddress($model_user->email_usuario, $model_user->nombre_usuario);
		//$mail->AddBCC("grupos1@rutamayatravel.com");
		//$mail->AddBCC("grupos2@rutamayatravel.com");
		//
		if ($model_bloqueo->idTarifa->precio=="BODA") {
			$mail->AddBCC("bodas@rutamayatravel.com");
			$mail->AddBCC("sugely.lizama@rutamayatravel.com");
			
		}else{
			$mail->AddBCC("leticiavarguez@rutamayatravel.com");

		}
		$mail->AddBCC("programador2@rutamayatravel.com");
		$mail->AddBCC("jorgevadillo@rutamayatravel.com");
		//$mail->AddBCC($model_user->email_usuario);
		$mail->Send();
		
		// message lines should not exceed 70 characters (PHP rule), so wrap it
		// send mail
		/*if(mail($recipent,$subject,$message,$encabezados)){

			echo 'Mensaje Enviado!';
		}else{
			echo "Mensaje No enviado. Intente de nuevo";
		}*/
	}
}