<?php

class TarifaController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column1';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
			array(
                'ext.starship.RestfullYii.filters.ERestFilter + 
                REST.GET, REST.PUT, REST.POST, REST.DELETE'
            ),
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow', 'actions'=>array('REST.GET', 'REST.PUT', 'REST.POST', 'REST.DELETE'),
				'users'=>array('@'),
			),
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('@'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update','GeneratePdf','GenerateExcel','ListadoTarifas','Cargarhabitaciones','Tarifasbase'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	public function actions()
	{
        return array('REST.'=>'ext.starship.RestfullYii.actions.ERestActionProvider',);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */

	public function actionListadoTarifas(){

		$data = json_decode($_POST["resultadoBusqueda"]);
		$id_hotel = $_POST['hotel'];

		$this->renderPartial('_listadoTarifas',array('data'=>$data,'id_hotel'=>$id_hotel));
		
	}

	public function actionCargarhabitaciones()
	{
		$id_hotel = $_POST['id_hotel'];
		$id_tarifa = $_POST['id_tarifa'];
		$id_plan = $_POST['id_plan'];
		$tipohabs = TipoHabitaciones::model()->with('tarifaDesgloses')->findAll(array('condition'=>'id_hotel='.$id_hotel.' and id_tarifa='.$id_tarifa.' and t.estatus=1','order'=>'precio_normal '.$_POST['ORDER_PRECIO'].''));
		$this->renderPartial('_desglosetarifa',array('tipohabs'=>$tipohabs,'id_tarifa'=>$id_tarifa,'id_plan'=>$id_plan,'id_hotel'=>$id_hotel));
	}
	public function actionTarifasbase()
	{
		$id_hotel = $_POST['id_hotel'];
		$id_tarifa = $_POST['id_tarifa'];
		$tipohab = TipoHabitaciones::model()->findByPk($_POST['id_hab']);
		$fecha_inicio = $_POST['fecha_inicio'];
		$noches = $_POST['noches'];
		$combinar = $_POST['combinar'];
		$ORDER_PRECIO = $_POST['ORDER_PRECIO'];
		$this->renderPartial('_tarifasbase',array('tipohab'=>$tipohab,'id_tarifa'=>$id_tarifa,'id_hotel'=>$id_hotel,'fecha_inicial'=>$fecha_inicio,'noches'=>$noches,'ORDER_PRECIO'=>$ORDER_PRECIO,'combinar'=>$combinar));
	}
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new Tarifa;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Tarifa']))
		{
			$model->attributes=$_POST['Tarifa'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id_tarifa));
		}

		$this->render('create',array(
			'model'=>$model,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Tarifa']))
		{
			$model->attributes=$_POST['Tarifa'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id_tarifa));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		if(Yii::app()->request->isPostRequest)
		{
			// we only allow deletion via POST request
			$this->loadModel($id)->delete();

			// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
			if(!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
		}
		else
			throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
            $session=new CHttpSession;
            $session->open();		
            $criteria = new CDbCriteria();            

                $model=new Tarifa('search');
                $model->unsetAttributes();  // clear any default values

                if(isset($_GET['Tarifa']))
		{
                        $model->attributes=$_GET['Tarifa'];
			
			
                   	
                       if (!empty($model->id_tarifa)) $criteria->addCondition("id_tarifa = '".$model->id_tarifa."'");
                     
                    	
                       if (!empty($model->id_hotel)) $criteria->addCondition("id_hotel = '".$model->id_hotel."'");
                     
                    	
                       if (!empty($model->id_tipo_plan)) $criteria->addCondition("id_tipo_plan = '".$model->id_tipo_plan."'");
                     
                    	
                       if (!empty($model->fecha_promo)) $criteria->addCondition("fecha_promo = '".$model->fecha_promo."'");
                     
                    	
                       if (!empty($model->fecha_promo_inicio)) $criteria->addCondition("fecha_promo_inicio = '".$model->fecha_promo_inicio."'");
                     
                    	
                       if (!empty($model->fecha_inicial)) $criteria->addCondition("fecha_inicial = '".$model->fecha_inicial."'");
                     
                    	
                       if (!empty($model->fecha_final)) $criteria->addCondition("fecha_final = '".$model->fecha_final."'");
                     
                    	
                       if (!empty($model->hora_inicio)) $criteria->addCondition("hora_inicio = '".$model->hora_inicio."'");
                     
                    	
                       if (!empty($model->hora_final)) $criteria->addCondition("hora_final = '".$model->hora_final."'");
                     
                    	
                       if (!empty($model->estatus)) $criteria->addCondition("estatus = '".$model->estatus."'");
                     
                    	
                       if (!empty($model->log)) $criteria->addCondition("log = '".$model->log."'");
                     
                    	
                       if (!empty($model->min_noches)) $criteria->addCondition("min_noches = '".$model->min_noches."'");
                     
                    	
                       if (!empty($model->num_ninios_gratis)) $criteria->addCondition("num_ninios_gratis = '".$model->num_ninios_gratis."'");
                     
                    	
                       if (!empty($model->edad_maxima_ninio)) $criteria->addCondition("edad_maxima_ninio = '".$model->edad_maxima_ninio."'");
                     
                    	
                       if (!empty($model->edad_maxima_jr)) $criteria->addCondition("edad_maxima_jr = '".$model->edad_maxima_jr."'");
                     
                    	
                       if (!empty($model->iva)) $criteria->addCondition("iva = '".$model->iva."'");
                     
                    	
                       if (!empty($model->impuesto_hospedaje)) $criteria->addCondition("impuesto_hospedaje = '".$model->impuesto_hospedaje."'");
                     
                    	
                       if (!empty($model->comision)) $criteria->addCondition("comision = '".$model->comision."'");
                     
                    	
                       if (!empty($model->tipo_costo)) $criteria->addCondition("tipo_costo = '".$model->tipo_costo."'");
                     
                    	
                       if (!empty($model->precio)) $criteria->addCondition("precio = '".$model->precio."'");
                     
                    	
                       if (!empty($model->promocontigua)) $criteria->addCondition("promocontigua = '".$model->promocontigua."'");
                     
                    	
                       if (!empty($model->id_combina)) $criteria->addCondition("id_combina = '".$model->id_combina."'");
                     
                    	
                       if (!empty($model->nombre_tarifa)) $criteria->addCondition("nombre_tarifa = '".$model->nombre_tarifa."'");
                     
                    	
                       if (!empty($model->codigo)) $criteria->addCondition("codigo = '".$model->codigo."'");
                     
                    	
                       if (!empty($model->fecha_limite)) $criteria->addCondition("fecha_limite = '".$model->fecha_limite."'");
                     
                    	
                       if (!empty($model->fecha_limite_dias)) $criteria->addCondition("fecha_limite_dias = '".$model->fecha_limite_dias."'");
                     
                    	
                       if (!empty($model->early_booking)) $criteria->addCondition("early_booking = '".$model->early_booking."'");
                     
                    	
                       if (!empty($model->release)) $criteria->addCondition("release = '".$model->release."'");
                     
                    	
                       if (!empty($model->restricciones)) $criteria->addCondition("restricciones = '".$model->restricciones."'");
                     
                    	
                       if (!empty($model->moneda)) $criteria->addCondition("moneda = '".$model->moneda."'");
                     
                    	
                       if (!empty($model->id_logo)) $criteria->addCondition("id_logo = '".$model->id_logo."'");
                     
                    	
                       if (!empty($model->tipo_cambio)) $criteria->addCondition("tipo_cambio = '".$model->tipo_cambio."'");
                     
                    	
                       if (!empty($model->tasa_cambio)) $criteria->addCondition("tasa_cambio = '".$model->tasa_cambio."'");
                     
                    	
                       if (!empty($model->mostrar_conversion)) $criteria->addCondition("mostrar_conversion = '".$model->mostrar_conversion."'");
                     
                    			
                    $session['Tarifa_records']=Tarifa::model()->findAll($criteria); 
		}
       

                $this->render('index',array(
			'model'=>$model,
		));

	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Tarifa('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Tarifa']))
			$model->attributes=$_GET['Tarifa'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model=Tarifa::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='tarifa-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
        public function actionGenerateExcel()
	{
            $session=new CHttpSession;
            $session->open();		
            
             if(isset($session['Tarifa_records']))
               {
                $model=$session['Tarifa_records'];
               }
               else
                 $model = Tarifa::model()->findAll();

		
		Yii::app()->request->sendFile(date('YmdHis').'.xls',
			$this->renderPartial('excelReport', array(
				'model'=>$model
			), true)
		);
	}
        public function actionGeneratePdf() 
	{
           $session=new CHttpSession;
           $session->open();
		Yii::import('application.extensions.bootstrap.gii.*');
		require_once('bootstrap/tcpdf/tcpdf.php');
		require_once('bootstrap/tcpdf/config/lang/eng.php');

             if(isset($session['Tarifa_records']))
               {
                $model=$session['Tarifa_records'];
               }
               else
                 $model = Tarifa::model()->findAll();



		$html = $this->renderPartial('expenseGridtoReport', array(
			'model'=>$model
		), true);
		
		//die($html);
		
		$pdf = new TCPDF();
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor(Yii::app()->name);
		$pdf->SetTitle('Tarifa Report');
		$pdf->SetSubject('Tarifa Report');
		//$pdf->SetKeywords('example, text, report');
		$pdf->SetHeaderData('', 0, "Report", '');
		$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, "Example Report by ".Yii::app()->name, "");
		$pdf->setHeaderFont(Array('helvetica', '', 8));
		$pdf->setFooterFont(Array('helvetica', '', 6));
		$pdf->SetMargins(15, 18, 15);
		$pdf->SetHeaderMargin(5);
		$pdf->SetFooterMargin(10);
		$pdf->SetAutoPageBreak(TRUE, 0);
		$pdf->SetFont('dejavusans', '', 7);
		$pdf->AddPage();
		$pdf->writeHTML($html, true, false, true, false, '');
		$pdf->LastPage();
		$pdf->Output("Tarifa_002.pdf", "I");
	}
}
