<?php

require_once('../api/beds/HotelApi.php');
require_once('../api/omnibees/Token.php');
require_once('../api/riu/apiRiu.php');
require_once('../api/dingus/apiDingus.php');
require_once('../api/travelsolution/TravelSolution.php');
Yii::import('application.extensions.phpmailer.JPhpMailer');
class SolicitudCancelacionController extends Controller {
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column1';

	public $username='rutamayatravel';

	public $password="jcilqiqhudejdngu";

	public $url="https://pull.omnibees.com/Pullservice.svc?wsdl";

	/**
	 * @return array action filters
	 */
	public function filters() {
		return array(
			'accessControl', // perform access control for CRUD operations
			array(
                'ext.starship.RestfullYii.filters.ERestFilter + 
                REST.GET, REST.PUT, REST.POST, REST.DELETE'
            ),
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules() {
		return array(
			array('allow', 'actions'=>array('REST.GET', 'REST.PUT', 'REST.POST', 'REST.DELETE'),
				'users'=>array('@'),
			),
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('@'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update','GeneratePdf','GenerateExcel', 'sendSolicitud', 'cancelarApis','cancelarNow','loadSolicitudes'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	public function actions() {
        return array('REST.'=>'ext.starship.RestfullYii.actions.ERestActionProvider',);
	}

	public function actionSendSolicitud() {
		$model_solicitud = SolicitudCancelacion::model()->findByPk($_POST["id_solicitud"]);
		$model_usuario = Usuarios::model()->findByPk(Yii::app()->user->id);
		if ($_POST['tipo']==0) {
			$model= Reservacion::model()->findByPk($model_solicitud->id_reserva);
			$resmensaje="de habitación de hotel ";
			$url=" <a href=\"https://". $_SERVER["SERVER_NAME"] . Yii::app()->createUrl("reservacion/view", array("id"=>$model_solicitud->id_reserva)) ."\">". $model_solicitud->id_reserva ."</a> ";
		}else if($_POST['tipo']==1){
			$model = ActivityReservacion::model()->findByPk($model_solicitud->id_reserva);
			$resmensaje="de Actividad ";
			$url=" <a href=\"https://". $_SERVER["SERVER_NAME"] . Yii::app()->createUrl("activities/view", array("id"=>$model_solicitud->id_reserva)) ."\">". $model_solicitud->id_reserva ."</a> ";
		}else if($_POST['tipo']==2){
			$model= TourReservacion::model()->findByPk($model_solicitud->id_reserva);
			$resmensaje="de Tour ";
			$url=" <a href=\"https://". $_SERVER["SERVER_NAME"] . Yii::app()->createUrl("tourReservacion/view", array("id"=>$model_solicitud->id_reserva)) ."\">". $model_solicitud->id_reserva ."</a> ";
		}
		$message = "Se solicitó la cancelación de la reserva ".$resmensaje.$url." de la agencia \"". $model->idAgencia->nombre_agencia ."\" por el usuario \"". $model_usuario->nombre_usuario ."\" con motivo: \"". $model_solicitud->idMotivo->motivo ."\" Comentarios: \"". $model_solicitud->comentario."\"";
		
		$mail = new JPhpMailer;
		$mail->IsSMTP();
		$mail->Host = 'rutamayatravel.com'; 
		$mail->SMTPAuth = true;
		$mail->Username = 'no-reply@rutamayatravel.com'; 
		$mail->Port = '26'; 
		$mail->Password = 'Intelred76'; 
		$mail->SMTPKeepAlive = true;  
		$mail->Mailer = "smtp"; 
		$mail->IsSMTP();  
		$mail->SMTPAuth = true;  
		$mail->CharSet = 'utf-8';  
		$mail->SMTPDebug  = 0;
		$mail->SetFrom('no-reply@rutamayatravel.com', 'Sistema Ruta Maya Travel'); 
		$mail->Subject = "Solicitud de cancelación de reservación";
		$mail->AltBody = 'To view the message, please use an HTML compatible email viewer!'; 
		$mail->MsgHTML($message);
		$mail->AddAddress($model->idAgente->email_usuario, $model->idAgente->nombre_usuario);
		$mail->AddBCC("programador2@rutamayatravel.com", "Programador");
		$mail->AddBCC('jorgevadillo@rutamayatravel.com');
		$mail->AddBCC('lgvarguez@rutamayatravel.com');
		$mail->AddBCC('contabilidad@rutamayatravel.com');
		if ($model_usuario->email_usuario!=$model->idUsuario->nombre_usuario) {		
		 $mail->AddBCC($model->idUsuario->email_usuario, $model->idUsuario->nombre_usuario);
		}
		$mail->AddBCC($model_usuario->email_usuario, $model_usuario->nombre_usuario);
		$mail->AddBCC($model->idAgencia->email_agencia, $model->idAgencia->nombre_agencia);
		/*$mail->AddBCC('melbacampos@rutamayatravel.com');
		$mail->AddBCC('leticiavarguez@rutamayatravel.com');*/
		if ($mail->Send()) {
			$model->estatus="PC";
			if($_POST['tipo']==2)
			$model->cancelacion_motivo=$model_solicitud->idMotivo->motivo;
			else
			$model->motivo=$model_solicitud->idMotivo->motivo;
			$model->save();
		}
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id) {
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate() {
		$model=new SolicitudCancelacion;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['SolicitudCancelacion']))
		{
			$model->attributes=$_POST['SolicitudCancelacion'];
			if($model->save())
				echo CJSON::encode($model);
			else
				echo array('error',CJSON::encode($model->getErrors()));
				//$this->redirect(array('view','id'=>$model->id_solicitud_cancelacion));
		}

		$this->render('create',array(
			'model'=>$model,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id) {
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['SolicitudCancelacion']))
		{
			$model->attributes=$_POST['SolicitudCancelacion'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id_solicitud_cancelacion));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		if(Yii::app()->request->isPostRequest)
		{
			// we only allow deletion via POST request
			$this->loadModel($id)->delete();

			// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
			if(!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
		}
		else
			throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex() {
        $session=new CHttpSession;
        $session->open();		
        $criteria = new CDbCriteria();            

        $model=new SolicitudCancelacion('search');
        $model->unsetAttributes();  // clear any default values

        if(isset($_GET['SolicitudCancelacion'])) {
            $model->attributes=$_GET['SolicitudCancelacion'];
                   	
           	if (!empty($model->id_solicitud_cancelacion)) $criteria->addCondition("id_solicitud_cancelacion = '".$model->id_solicitud_cancelacion."'");
                    	
           	if (!empty($model->motivo)) $criteria->addCondition("motivo = '".$model->motivo."'");
                    	
           	if (!empty($model->id_reserva)) $criteria->addCondition("id_reserva = '".$model->id_reserva."'");
                    	
           	if (!empty($model->id_usuario)) $criteria->addCondition("id_usuario = '".$model->id_usuario."'");
                    	
           	if (!empty($model->log)) $criteria->addCondition("log = '".$model->log."'");
                    			
            $session['SolicitudCancelacion_records']=SolicitudCancelacion::model()->findAll($criteria); 
		}

        $this->render('index',array(
			'model'=>$model,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin() {
		$model=new SolicitudCancelacion('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['SolicitudCancelacion']))
			$model->attributes=$_GET['SolicitudCancelacion'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id) {
		$model=SolicitudCancelacion::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model) {
		if(isset($_POST['ajax']) && $_POST['ajax']==='solicitud-cancelacion-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
        
    public function actionGenerateExcel() {
        $session=new CHttpSession;
        $session->open();		
            
     	if(isset($session['SolicitudCancelacion_records'])) {
            $model=$session['SolicitudCancelacion_records'];
       	}
       	else
         	$model = SolicitudCancelacion::model()->findAll();

		Yii::app()->request->sendFile(date('YmdHis').'.xls',
			$this->renderPartial('excelReport', array(
				'model'=>$model
			), true)
		);
	}
        
    public function actionGeneratePdf() {
       	$session=new CHttpSession;
       	$session->open();
		Yii::import('application.extensions.bootstrap.gii.*');
		require_once('bootstrap/tcpdf/tcpdf.php');
		require_once('bootstrap/tcpdf/config/lang/eng.php');

     	if(isset($session['SolicitudCancelacion_records'])) {
        	$model=$session['SolicitudCancelacion_records'];
       	}
       	else
         	$model = SolicitudCancelacion::model()->findAll();

		$html = $this->renderPartial('expenseGridtoReport', array(
			'model'=>$model
		), true);
		
		//die($html);
		
		$pdf = new TCPDF();
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor(Yii::app()->name);
		$pdf->SetTitle('SolicitudCancelacion Report');
		$pdf->SetSubject('SolicitudCancelacion Report');
		//$pdf->SetKeywords('example, text, report');
		$pdf->SetHeaderData('', 0, "Report", '');
		$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, "Example Report by ".Yii::app()->name, "");
		$pdf->setHeaderFont(Array('helvetica', '', 8));
		$pdf->setFooterFont(Array('helvetica', '', 6));
		$pdf->SetMargins(15, 18, 15);
		$pdf->SetHeaderMargin(5);
		$pdf->SetFooterMargin(10);
		$pdf->SetAutoPageBreak(TRUE, 0);
		$pdf->SetFont('dejavusans', '', 7);
		$pdf->AddPage();
		$pdf->writeHTML($html, true, false, true, false, '');
		$pdf->LastPage();
		$pdf->Output("SolicitudCancelacion_002.pdf", "I");
	}
	public function actionLoadSolicitudes()
	{
		$criteria= new CDbCriteria;
		$criteria->order="idReserva.estatus ASC";
		$model=SolicitudCancelacion::model()->with('idUsuario','idReserva','idMotivo')->findAll($criteria);
		 $arrayModel=$this->convertModelToArray($model);
		 foreach ($arrayModel as $key=>$value) {
		 	switch ($value['tipo']) {
		 		case 0:
		 			$idReserva=Reservacion::model()->findByPk($value['id_reserva']);
		 			break;
		 		case 1:
		 			$idReserva=ActivityReservacion::model()->findByPk($value['id_reserva']);
		 			break;
		 		case 2:
		 			$idReserva=TourReservacion::model()->findByPk($value['id_reserva']);
		 			break;
		 		
		 	}
		 	$arrayModel[$key]['agente']= Usuarios::model()->findByPk($idReserva->id_agente)->nombre_usuario;
		 	$arrayModel[$key]['idReserva']=json_decode(CJSON::encode($idReserva),true);
		 	unset($arrayModel[$key]['idReserva']['politicas_cancelacion']);
		 	unset($arrayModel[$key]['idReserva']['desglose_rate']);
		 	unset($arrayModel[$key]['idReserva']['motivo']);
		 	unset($arrayModel[$key]['idReserva']['obeservaciones']);
		 }
		 echo json_encode($arrayModel);
	}
	public function convertModelToArray($models) {
        if (is_array($models))
            $arrayMode = TRUE;
        else {
            $models = array($models);
            $arrayMode = FALSE;
        }

        $result = array();

        foreach ($models as $model) {
            $attributes = $model->getAttributes();
            $relations = array();

            foreach ($model->relations() as $key => $related) {
                if ($model->hasRelated($key)) {
                	if ($model->$key) {
                    	$relations[$key] = $this->convertModelToArray($model->$key);	
                	}else if($key=="idBaseHabitacion" || $key=="idReservacion"){
                		$relations[$key] =null;
                	}else{
                		$relations[$key] =[];
                	}
                }
            }

            $all = array_merge($attributes, $relations);

            if ($arrayMode)
                array_push($result, $all);
            else
                $result = $all;
        }

        return $result;
    }
	public function actionCancelarNow($id)
	{
		$dia=0;
    	$tipo=0;
    	
    	switch ($tipo) {
    		case 0:
    			$row = Reservacion::model()->findByPk($id);
    			
    			$cancelado=false;
				$habs=ReservacionDesglose::model()->count('id_reservacion='.$row->id_reservacion);
				$provArray=array("BR","WS","DI","RI","OB","TS");
				$codigo=substr($row->code,0,2);
				
    			
				//$cancelacionMotivo= SolicitudCancelacion::model()->findByPk($_POST['id_motivo']);
				$user=Usuarios::model()->findByPk(Yii::app()->user->id);

				if ($habs!=0) {
					
					switch ($codigo) {
						case "BR":
						    $cancelado= true;//$this->CancelarBeds($row->code, $row->id_reservacion);
								
							break;
						case "OB":
							$cancelado=true; //$this->CancelarOmnibees($row->code, $row->id_reservacion);
							
							break;
						case "TS":
							$cancelado=$this->CancelarHotelDo($row->code, $row->id_reservacion);
							
							break;
						case "RI":
							$cancelado=$this->CancelarRiu($row);
							
							break;
						case "DI":
							$cancelado=$this->CancelarDingus($row);
							
							break;
						case "WS":
							$cancelado=$this->CancelarPalace($row);
							break;
						
					}

					if (in_array($codigo, $provArray))  {
						if ($cancelado) {
							
							$this->emailCancelarApi($row,'h');
							$row->estatus="C";
							$row->motivo="Fecha: ".date('d/m/Y')." , Motivo:El pasajero no viaja";
							$row->save();
							//$this->cancelarRecibos($row);
						}
					}
					
				}
    			break;
    		case 1:
    			
    			$row = $this->cancelarActividad($id,$cancelacionMotivo->idMotivo->motivo,$user->nombre_usuario);
    			break;
    	
    	}
		

		
	}
	public function actionCancelarApis($id)
	{
		
    	$dia=0;
    	$tipo=$_POST['tipo'];
    	switch ($tipo) {
    		case 0:
    			$row = Reservacion::model()->findByPk($id);
    			$cancelado=false;
				$habs=ReservacionDesglose::model()->count('id_reservacion='.$row->id_reservacion." and estatus!=0 ");
				$provArray=array("BR","WS","DI","RI","OB","TS");
				$codigo=substr($row->code,0,2);
				$cancelacionMotivo= SolicitudCancelacion::model()->findByPk($_POST['id_motivo']);
				$user=Usuarios::model()->findByPk(Yii::app()->user->id);
				if ($habs!=0) {
					
					switch ($codigo) {
						case "BR":
						    $cancelado=$this->CancelarBeds($row->code, $row->id_reservacion);
								
							break;
						case "OB":
							$cancelado=$this->CancelarOmnibees($row->code, $row->id_reservacion);
							
							break;
						case "TS":
							$cancelado=$this->CancelarHotelDo($row->code, $row->id_reservacion);
							
							break;
						case "RI":
							$cancelado=$this->CancelarRiu($row);
							
							break;
						case "DI":
							$cancelado=$this->CancelarDingus($row);
							
							break;
						case "WS":
							$cancelado=$this->CancelarPalace($row);
							break;
						
					}

					if (in_array($codigo, $provArray))  {
						if ($cancelado) {
							$this->emailCancelarApi($row,'h');
							$row->estatus="C";
							$row->motivo="Fecha: ".date('d/m/Y')." Cancelado por:".$user->nombre_usuario." Socio Agencia Motivo: ".$cancelacionMotivo->idMotivo->motivo;
							$row->save();
							$this->cancelarRecibos($row);
						}
					}
					
				}
    			break;
    		case 1:
    			
    			$row = $this->cancelarActividad($id,$cancelacionMotivo->idMotivo->motivo,$user->nombre_usuario);
    			break;
    	
    	}
		
		
	
				
		
	}

	public function Crearnota($importe,$model,$concepto)
	{
		$notacredito = new NotaCredito;
		$notacredito->importe = $importe;
		$notacredito->id_tipo = 11;
		$notacredito->id_agencia = $model->id_agencia;
		$notacredito->id_ref = $model->id_reservacion;
		$notacredito->tipo_ref = "RESERVACION";
		$notacredito->concepto = $concepto;
		$notacredito->estatus = "A";
		$notacredito->id_user = Yii::app()->user->id;
		$notacredito->save();
	}
	public function CancelarBeds($code, $id_reservacion)
	{
		$code=explode(',', $code);
		$habitaciones=ReservacionDesglose::model()->findAll('id_reservacion='.$id_reservacion);
		foreach ($habitaciones as $key=>$hab) {		
			$cancelar = $this->CancelarHotelBeds($code[$key],$hab->id_desglose);
			if ($cancelar) {
				$hab->estatus=0;
				$hab->save();
			}
		}
		return $cancelar;
	}
	public function CancelarHotelBeds($code,$id_desglose)
	{
		$code=substr($code,2);
		$params= array();
		$params['bookingId']=$code;
		$params['cancellationFlag']="CANCELLATION";
		$logHotelbeds['header'] = "cancelAg";
		$logHotelbeds['request'] = json_encode($params);
		$idWs=$this->logWsRequest($logHotelbeds,'hotelBeds');
		$cancel= $this->cancelar(json_encode($params));	
		$booking=json_decode($cancel);
		
		$logHotelbeds['response'] = $cancel;
		$logHotelbeds['reference'] = $code;
		$this->logWsResponse($idWs,$logHotelbeds);				 
		if($booking->booking->reference==$params['bookingId'] && $booking->booking->status=="CANCELLED")
		{
			return true;
		}
		return false;
	}

	public function cancelar($params)
	{
		$hotelApi = new HotelApi();
		$estatus = $hotelApi->estatus();
		if($estatus=="OK")
		{
			$datos = $hotelApi->bookingCancellation($params);
			return $datos;
		}
		else
		{
			return "No hubo conexión";
		}
	}
	
	public function CancelarOmnibees($code, $id_reservacion)
	{
				
				$uniqueID=substr($code,2);
				$hotel=explode("-", $code)[1];

				$reservacion = Reservacion::model()->findByPk($id_reservacion);


				$token= new Token;
				$echoToken=$token->obtenToken();
				$session=new CHttpSession;
				$session->open();
				$UserName = $this->username;
				$Password = $this->password;
				$url = $this->url;
				$data=array("SendHotelResCancel"=>array(
						"login"=>array("Password"=>$Password, "UserName"=>$UserName),
						"ota_CancelRQ"=>array(
							"EchoToken"=>$echoToken,
							"TimeStamp"=>date("Y-m-d").'T'.date("H:i:s").'Z',
							"Target"=>"Test",
							"Version"=>2.5,
							"PrimaryLangID"=>"es",
							"UniqueID"=>array(
									array(
										"ID"=>$uniqueID,
										"Type"=>"Reservation"
									)
							),
							"Verification"=>array(
								"Email"=>"programador2@rutamayatravel.com",
								"HotelRef"=>array(
									"HotelCode"=>$hotel
								),
								"ReservationTimeSpan"=>array(
									"End"=>$reservacion->fecha_final."T00:00:00",
									"Start"=>$reservacion->fecha_inicial."T00:00:00"
								),
							),
							/*"CancelType"=>"CancelRoom",
							"Segment"=>array(
								array(
									"ItinSegNbr"=>$itinSegNbr,
									"Status"=>"Cancelled"
								)
							),*/
							"POS"=>null	
							)
					)
				);
				$options = array(
		                'soap_version'=>SOAP_1_1,
		                'trace'=>1,
		                "location" => "https://pull.omnibees.com",
				        'exceptions' => 1,
				        'connection_timeout' => 60,
				        "stream_context" => stream_context_create(
				            array(
				                'ssl' => array(
				                    'verify_peer'       => false,
				                    'verify_peer_name'  => false,
				                ),
				               
				            )
				        )
		                
		        );
				$client = new SoapClient($url,$options);
				$logHotelbeds['header'] = "cancelAg";
				$logHotelbeds['request'] = json_encode($data);
				$idWs=$this->logWsRequest($logHotelbeds,'Omnibees');
				try
				{
					$result = $client->__soapCall("SendHotelResCancel", $data, NULL, $header);
				}
				catch (SoapFault $exception)
				{
					$result=$exception;
					$estatus=false;

				}
				$logHotelbeds['response'] = json_encode($result);
				$logHotelbeds['reference'] = $id_reservacion;
				$this->logWsResponse($idWs,$logHotelbeds);
			
					$response=json_decode($logHotelbeds['response']);

					if($response->SendHotelResCancelResult->Status=='Cancelled')
					{
						if($id_reservacion){

								$habitaciones = ReservacionDesglose::model()->findAll('id_reservacion='.$id_reservacion);	
							
							foreach ($habitaciones as $habs) {
								if($habs->estatus!=0)
								{
									$habs->estatus=0; 
									$habs->save();
								}
							}	
						}			
						$estatus=true;
					}
				
				return $estatus;
	}
	

	public function CancelarHotelDo($code,$id_reservacion)
	{		
			$reference=substr($code, 2);
		
			$desglose=ReservacionDesglose::model()->findAll('id_reservacion='.$id_reservacion);
		foreach ($desglose as $k=>$hab) {
			$ref=$reference."/".($k+1);
			$estatus=$this->CancelarDo($ref,$hab);

		}
		return $estatus;
	}
	/*public function CancelarHotelDo2($code,$id_reservacion)
	{		
			$reference=substr($code, 2);
		
			$desglose=ReservacionDesglose::model()->findAll('id_reservacion='.$id_reservacion);
		foreach ($desglose as $k=>$hab) {
			$ref=$reference."/".($k+1);
			echo $ref;
			$estatus=$this->CancelarDo2($ref,$hab);

		}
		return $estatus;
	}*/
	public function actionReservasCambioComision()
	{
		$model=Reservacion::model()->findAll('log>="2019-09-23" AND id_bloqueo is null and estatus!="C"');
		foreach ($model as $key=>$value) {
			$comision=(int)$value->comision;
			if ($comision!=$value->idAgencia->porcentaje_comision) {
			
				

				$recibos=ReciboDetalles::model()->findAll('id_reservacion='.$value->id_reservacion);
					
				if (count($recibos)==0) {
					echo $value->id_reservacion."--".$value->comision." -- ".$value->idAgencia->porcentaje_comision."<br>";
					$value->comision=$value->idAgencia->porcentaje_comision;
					if (!$value->save()) {
						print_r($value->getErrors());
						exit;
					}
				}else{
					foreach ($recibos as $rec) {
						echo $value->id_reservacion."--".$rec->id_recibo."<br>";
					}
				}
			}
		}
	}
	public function CancelarDo($code,$desglose)
	{
		$code=explode("/", $code);
		
				$response = $this->counsultaCancelarBooking($code);	
				$response=json_decode($response);
				$estatus=false;
			
		
				
				if($response->status=="CA" || $response->code=="221" || $response->status=="CP")
				{
					
						$desglose->estatus=0; 
						$desglose->save();
											
					
					$estatus=true;
				}
			
			return $estatus;
	}
	/*public function CancelarDo2($code,$desglose)
	{
		$code=explode("/", $code);
		
				$response = $this->counsultaCancelarBooking2($code);
				echo $response;	
				$response=json_decode($response);
				$estatus=false;
			
			var_dump($response->code);
				
				if($response->status=="CA" || $response->code=="221" || $response->status=="CP")
				{
					
						$desglose->estatus=0; 
						$desglose->save();
											
					
					$estatus=true;
				}
			
			return $estatus;
	}*/
	/*public function counsultaCancelarBooking2($reference)
	{
		$lenguage="ESP";
		$currency="MX";
		$travelSolution = new TravelSolution;	
		//bn=47121828&bc=9&ch=111635&rc=
		$request="a=".$travelSolution->affiliateId."&ip=".$_SERVER["REMOTE_ADDR"]."&l=".$lenguage."&c=".$currency."&bn=".$reference[0]."&bc=".$reference[1];  
		
		$response = $travelSolution->cancelItineraryHotel($request);
		$doControl=Yii::app()->createController('travelSolution');
		$doControl=$doControl[0];
			$logHotelbeds['header'] = 'AgCancelHotelDo';
			$logHotelbeds['request'] = $request;
			$logHotelbeds['response'] = $response;
			$logHotelbeds['reference'] = implode('/', $reference);
		$response=$doControl->xml_to_json($response);

		$this->logWs($logHotelbeds,'Hoteldo');

		return $response;
	}*/
	public function counsultaCancelarBooking($reference)
	{
		$lenguage="ESP";
		$currency="MX";
		$travelSolution = new TravelSolution;	
		//bn=47121828&bc=9&ch=111635&rc=
		$request="a=".$travelSolution->affiliateId."&ip=".$_SERVER["REMOTE_ADDR"]."&l=".$lenguage."&c=".$currency."&bn=".$reference[0]."&bc=".$reference[1]; 
		$logHotelbeds['header'] = 'cacnelAg';
		$logHotelbeds['request'] = $request;
		$idWs=$this->logWsRequest($logHotelbeds,'HotelDo');  
		$response = $travelSolution->cancelItineraryHotel($request);
		$doControl=Yii::app()->createController('travelSolution');
		$doControl=$doControl[0];
		
			$logHotelbeds['response'] = $response;
			$logHotelbeds['reference'] = implode('/', $reference);
		$response=$doControl->xml_to_json($response);
		$this->logWsResponse($idWs,$logHotelbeds);
		return $response;
	}
	public function CancelarRiu($model)
	{
			$riuControl=Yii::app()->createController('riu');
			$riuControl=$riuControl[0];
			$riuControl->login();
			$riu = new apiRiu;
			$code=explode('-', $model->code);
			$coderiu=$code[1];
			$custom=substr($code[0], 2);
			$coderiu[1]? $reservationID=$coderiu[1]:$reservationID=1;
			$codeHotel=explode('/', $model->id_hotel);
			
			$params='<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:ser="http://services.enginexml.rumbonet.riu.com" xmlns:dtos="http://dtos.enginexml.rumbonet.riu.com">
				   <soapenv:Body>
				      <ser:HotelResCancel>
				         <ser:in0>
				            <dtos:CountryCode>MX</dtos:CountryCode>
				            <dtos:CustomerReservationCode>'.$custom.'</dtos:CustomerReservationCode>
				            <dtos:hotelReservationCode>'.$coderiu.'</dtos:hotelReservationCode>
				            <dtos:hotelReservationID>1</dtos:hotelReservationID>
				            <dtos:Language>E</dtos:Language>
				         </ser:in0>
				      </ser:HotelResCancel>
				   </soapenv:Body>
				</soapenv:Envelope>';
				$log['header'] = "cancelAg";
				$log['request'] = $params;
				$idWs=$this->logWsRequest($log,'Riu');
			$res = $riu->HotelResCancel($params);
		    $response = $riuControl->xml_to_json($res);
			
		 	 	   $jsonResponse = json_decode($response)[0];
						
						$log['response'] = $response;
						$log['reference'] = $model->id_reservacion;
						$this->logWsResponse($idWs,$log);
							
					$status= $jsonResponse->HotelResCancelResponse->HotelResCancelRS->bookingState;
			
					if ($status=="CNL") {
						if($id_reservacion>1){

							$habitaciones = ReservacionDesglose::model()->findAll('id_reservacion='.$id_reservacion);	
							foreach ($habitaciones as $habs) {
								if($habs->estatus!=0)
								{
									$habs->estatus=0; 
									$habs->save();
								}
							}			
						}
						return true;
					}else{
						return false;
					}

		
	}

	public function CancelarDingus($model)
	{
		$hotelID = Hoteles::model()->findByPk($model->id_hotel);
    	// echo "hotel= ".$hotelID->id_cadena;
    	$cadenaID = CadenaHotel::model()->findByPk($model->idHotel->id_cadena);
    	$url=$cadenaID->url_dingus;
    	$vendor_code = VendorCode::model()->find("id_cadena=".$cadenaID->id)->vendorCode;
			$dingus= new apiDingus();
			$codeDingus=explode('-', $model->code);
			$codeDingus=$codeDingus[1];
			$codeHotel=explode('/', $model->idHotel->codigo);
		
				$commit="true";
		
				$params = '<?xml version="1.0" encoding="utf-8"?><SOAP-ENV:Envelope xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/" xmlns:SOAPENC="http://schemas.xmlsoap.org/soap/encoding/" xmlns:xsi="http://www.w3.org/2001/XMLSchemainstance" xmlns:xsd="http://www.w3.org/2001/XMLSchema"> <SOAP-ENV:Body> <m:OTA_CancelRQ xmlns:m="http://www.opentravel.org/OTA/2003/05" Version="0" PrimaryLangID="es" Commit="'.$commit.'"> <m:POS> <m:Source> <m:RequestorID MessagePassword="rT4726mY" ID="rutamaya"/> </m:Source> </m:POS> <m:BasicPropertyInfo HotelCode="'.$codeHotel[0].'" ChainCode="" VendorCode="'.$vendor_code.'"/> <m:UniqueID ID="'.$codeDingus.'"/> </m:OTA_CancelRQ> </SOAP-ENV:Body> </SOAP-ENV:Envelope>';
				$log['header']="cancelAg";
				$log['request']=$params;
				$idWs=$this->logWsRequest($log,'Dingus');
		$response=$dingus->cancel($params, $url);
			$dinguscontrol=Yii::app()->createController('dingus');
			$dinguscontrol=$dinguscontrol[0];		
		$res=$dinguscontrol->xml_to_json($response);
						$hoteles=$jsonResponse[0]['OTA_HotelResRS']['HotelReservations']['HotelReservation']['ResGlobalInfo']['HotelReservationIDs']['HotelReservationID']['@attributes']['ResID_Value'];
						
						$log['response']=$res;
						$log['reference']=$model->id_reservacion;
						$this->logWsResponse($idWs,$log);
						$reservas= json_decode($res,true);
						$status=$reservas[0]['OTA_CancelRS']['@attributes']['Status'];
						$est=false;
						if ($status=="Cancelled" || $status=="Pending" ) {

							$rooms=ReservacionDesglose::model()->findAll('id_reservacion='.$model->id_reservacion);
							foreach ($rooms as $cuarto) {
								$cuarto->estatus=0;
								$cuarto->save();
							}
							$est=true;
						}

		return $est;
	}
	public function CancelarPalace($model)
	{
		if(!empty($this->palaceResorts[$model->idHotel->codigo]))
		{
				$ini = ini_set("soap.wsdl_cache_enabled","0");
				$client = new SoapClient($this->clientUrl);
				$folios = explode('WS',$model->code);
				$url = 'https://api.palaceresorts.com/EnterpriseServiceInterface/ServiceInterface.asmx?wsdl';
				$action = 'http://localhost/xmlschemas/enterpriseservice/16-07-2009/CancellingReservations';
				for($n=1;$n<count($folios);$n++){
				$xml='<soap:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/"><soap:Body><CancellingReservations xmlns="http://localhost/xmlschemas/enterpriseservice/16-07-2009/"><cancellationRequest xmlns="http://localhost/pr_xmlschemas/hotel/01-03-2006/cancellationRequest.xsd"><Data><cancellationList><Hotel xmlns="http://localhost/pr_xmlschemas/hotel/01-03-2006/cancellationList.xsd">'.$model->idHotel->codigo.'</Hotel><Folio xmlns="http://localhost/pr_xmlschemas/hotel/01-03-2006/cancellationList.xsd">'.$folios[$n].'</Folio><Reason xmlns="http://localhost/pr_xmlschemas/hotel/01-03-2006/cancellationList.xsd">Cancelado por Sistema</Reason><Ent_User xmlns="http://localhost/pr_xmlschemas/hotel/01-03-2006/cancellationList.xsd">RMY</Ent_User><Ent_Term xmlns="http://localhost/pr_xmlschemas/hotel/01-03-2006/cancellationList.xsd">RMY</Ent_Term><Cancelled xmlns="http://localhost/pr_xmlschemas/hotel/01-03-2006/cancellationList.xsd">false</Cancelled></cancellationList></Data><AuthInfo><Recnum xmlns="http://localhost/pr_xmlschemas/hotel/01-03-2006/authInfo.xsd">0</Recnum><Ent_User xmlns="http://localhost/pr_xmlschemas/hotel/01-03-2006/authInfo.xsd">RMY</Ent_User><Ent_Pass xmlns="http://localhost/pr_xmlschemas/hotel/01-03-2006/authInfo.xsd">QMrq8UzEru</Ent_Pass><Ent_Term xmlns="http://localhost/pr_xmlschemas/hotel/01-03-2006/authInfo.xsd">RMY</Ent_Term></AuthInfo></cancellationRequest></CancellingReservations></soap:Body></soap:Envelope>';
				$auxXml=$xml;
				$client = new SoapClient(null, array(
							'location' => $url,
							'uri'      => "",
							'trace'    => 1,
						));
						try{
						    $result = $client->__doRequest($xml, $url, $action, 1);
							//print_r($result);
						    $xml = simplexml_load_string($result, NULL, NULL, "http://schemas.xmlsoap.org/soap/envelope/");
							$ns = $xml->getNamespaces(true);
							$soap = $xml->children($ns['soap']);
							$body = $soap->Body->children($ns['CancellingReservationsResponse']);
							$result=$body->CancellingReservationsResponse->cancellationResponse;
							$status=(String)$result->Data->cancellationList->Cancelled;
							$log=array();
							$log['header'] = "AgenciaCancelPalace";
							$log['request'] = $auxXml;
							$log['response'] = $xml;
							$log['reference'] = $model->id_reservacion;
							//$this->logWs($log,'Palace');
							if ($status=="true") {
								$desglose=ReservacionDesglose::model()->findAll('id_reservacion='.$model->id_reservacion);
								foreach ($desglose as $habs) {
									$habs=0;
									$habs->save();
								}
								$est=true;
							}
						//	echo "Folio:".$result->folioResponse->Folio;
						}catch (SoapFault $exception){
							echo "falló";
						    print_r($exception);
						    $ex=$exception;
						    $est=false;
						}
				$error = "";
							//$result = $client->CancellingReservations($parametros);
					
				}
				return $est;
		}
	}


	private function noches($fecha_inicio,$fecha_final)
	{
		$datetime1 = new DateTime($fecha_inicio);
		$datetime2 = new DateTime($fecha_final);
		$interval = $datetime1->diff($datetime2);
		$noches= $interval->format('%a');
		return $noches;
	}
	/*private function logWs($data, $ws)
	{
		$logWsControl=Yii::app()->createController('logWs');
		$logWsControl=$logWsControl[0];
		if ($ws=="Actividad") {
			$logWsControl->Activities($data, $ws);
		}else{
			$logWsControl->Create($data, $ws);
		}
	}*/
	public function logWsRequest($data,$ws)
	{
		$logWsControl=Yii::app()->createController('logWs');
		$logWsControl=$logWsControl[0];
		return $logWsControl->logCreate($data, $ws);
	}
	public function logWsResponse($id,$data)
	{
		$logWsControl=Yii::app()->createController('logWs');
		$logWsControl=$logWsControl[0];
		$logWsControl->Update($id,$data);
	}
	private function emailCancelarApi($model,$tipo)
	{
		$encabezados  = "MIME-Version: 1.0\n";
		$encabezados .= "Content-type: text/html; charset=UTF-8\n";
		$encabezados .= "From:  Ruta Maya Travel <no-reply@rutamayatravel.com>\n";
		$encabezados .= "X-Sender: <contacto web>\n";
		$encabezados .= "X-Mailer: PHP\n";
		$encabezados .= "X-Priority: 3\n";
		$encabezados .= "Return-Path: <web page>\n";
		
			
			if ($tipo=="h") {
				$type="de Hotel";
				$crurl="activities/view";
				$subject="Cancelación de reserva inmediata ";
			}elseif ($tipo=="a") {
				$subject="Cancelación de actividad inmediata ";
				$type="de Actividad";
				$crurl="reservacion/view";
			}
			$message = "
			<div align='center' style='width:400px;font-family:helvetica'>
							<img src='http://".$_SERVER['SERVER_NAME']."".Yii::app()->baseUrl."/images/logo_rutamaya.jpg' border='1'><br>
							<p>Estimado agente de Ruta Maya Travel ".$model->idAgente->nombre_usuario." por este medio le informamos que la reserva ".$type." <a href='".Yii::app()->createUrl($curl,array('id'=>$model->id_reservacion))."'> #".$model->id_reservacion."</a> a sido cancelada por medio de solicitud de agencia. La reserva ha sido cancelada en nuestro sistema y en el del proveedor. Por favor revisa que esta información sea correcta. 
						</div>";
			$message2 = "
			<div align='center' style='width:400px;font-family:helvetica'>
							<img src='http://".$_SERVER['SERVER_NAME']."".Yii::app()->baseUrl."/images/logo_rutamaya.jpg' border='1'><br>
							<p>Estimado socio de Ruta Maya Travel ".$model->idUsuario->nombre_usuario." por este medio le informamos que la reserva ".$type." <a href='".Yii::app()->createUrl($curl,array('id'=>$model->id_reservacion))."'> #".$model->id_reservacion."</a> a sido cancelada por medio de solicitud de agencia. La reserva ha sido cancelada en nuestro sistema y con el socio online. Por favor revisa que esta información sea correcta. 
						</div>";
		
		$mail = new JPhpMailer;
		$mail->IsSMTP();
		$mail->Host = 'rutamayatravel.com'; 
		$mail->SMTPAuth = true;
		$mail->Username = 'no-reply@rutamayatravel.com'; 
		$mail->Port = '26'; 
		$mail->Password = 'Intelred76'; 
		$mail->SMTPKeepAlive = true;  
		$mail->Mailer = "smtp"; 
		$mail->IsSMTP();  
		$mail->SMTPAuth = true;  
		$mail->CharSet = 'utf-8';  
		$mail->SMTPDebug  = 0;
		$mail->SetFrom('no-reply@rutamayatravel.com.mx', 'Sistema Ruta Maya Travel'); 
		$mail->Subject = $subject; 
		$mail->AltBody = 'To view the message, please use an HTML compatible email viewer!'; 
		$mail->MsgHTML($message);
		$mail->AddAddress($model->idAgente->email_usuario, $model->idAgente->nombre_usuario);
		$mail->AddAddress('contabilidad@rutamayatravel.com', 'Contabilidad');
		$mail->AddAddress('jorgevadillo@rutamayatravel.com', 'Jorge');
		$mail->AddAddress('programador2@rutamayatravel.com', 'Christian');
		$mail->Send();

		$mail->MsgHTML($message2);
		$mail->AddAddress($model->idUsuario->email_usuario, $model->idUsuario->nombre_usuario);
		$mail->AddAddress($model->idAgencia->email_agencia, $model->idAgencia->nombre_agencia);
		$mail->AddAddress('programador2@rutamayatravel.com', 'Christian');
		$mail->Send();
	}

	public function cancelarRecibos($model)
	{
		
		$recibos = ReciboDetalles::model()->with('idRecibo')->findAll('id_reservacion='.$model->id_reservacion.' and idRecibo.estado!="C"');
	
			$importe = 0;
			$cancelados = "";
			if ($recibos) {
			
				foreach($recibos as $row)
				{
					$importe += $row->importe;
					$cancelarecibo = Recibo::model()->findByPk($row->id_recibo);
					$cancelarecibo->estado = 'C';
					$cancelarecibo->motivo = "Solicitud de Cancelación de Reservación #".$model->id_reservacion;
					$cancelarecibo->save();
					$cancelados .= "#".$row->id_recibo." ";
					$reservas="# ".$model->id_reservacion;
					$otrasreservas = ReciboDetalles::model()->findAll('id_recibo='.$row->id_recibo.' and id_reservacion!='.$model->id_reservacion);
					if(count($otrasreservas) > 0){
						$importeotras = 0; $reservas = "";
						foreach($otrasreservas as $otras){
							$importeotras += $otras->importe;
							$reservacion = Reservacion::model()->findByPk($otras->id_reservacion);
							$reservacion->saldo += $otras->importe;
							$reservacion->save();
							$reservas .= "#".$otras->id_reservacion." ";
						}
						$this->Crearnota($importeotras,$model,"Cancelación de Reservación #".$otras->id_reservacion." - Importe de Reservas: ".$reservas);
					}
						$this->Crearnota($importe,$model,"Cancelación de Reservación #".$model->id_reservacion." - Importe de Reservas: ".$cancelados);
				}
				$model->saldo+=$importe;
				$model->save();
				
					$operacion = Yii::app()->createController('operacionesLog');
					$operacion = $operacion[0];
					$operacion->Create($model->id_reservacion,5);		
			}
	}
	public function cancelarActividad($id,$motivo,$user) {
		$idReservacion=$id;
		$actividad = ActivityReservacion::model()->findByPk($idReservacion);
		$code=$actividad->code;
		$cancelar="CANCELLATION";
		$params= array();
		$params['bookingReference']=substr($code,6);
		$params['cancellationFlag']=$cancelar;
		$actControl=Yii::app()->createController('activities')[0];
		$cancel= $actControl->activityCancelar(json_encode($params));
		$logActivities['header']='AgenciaCancelAct';
		$logActivities['request']=json_encode($params);
		$logActivities['response']=$cancel;
		$logActivities['reference']=$code;
		$this->logWs($logActivities,'Actividad');
		$booking=json_decode($cancel);
		$markup = Api::model()->findByPk(2)->markup;
		
		if(($booking->booking->reference==$params['bookingReference'] && $booking->booking->status=="CANCELLED") || ($booking->errors[0]->code=="ACTGTW_E_113" && $actividad->estatus!='C'))
		{
			if(isset($actividad))
			{
				$actividad->motivo=$_POST['motivo']." Canceló:".$actividad->idUsuario->nombre_usuario;
				$actividad->estatus='C'; 
				if($actividad->save())
				{
					$recibos = ReciboDetalles::model()->with('idRecibo')->findAll('id_reservacion='.$idReservacion.' and estado!="C" and tipo="Activ"');
					$importe = 0;
					$cancelados = "";
					foreach($recibos as $row)
					{
						$importe += $row->importe;
						$cancelarecibo = Recibo::model()->findByPk($row->id_recibo);
						$cancelarecibo->estado = 'C';
						$cancelarecibo->motivo = "Fecha: ".date("d/m/Y H:i:s").", Cancelado por: ".$user.", Motivo: ".$motivo;
						$cancelarecibo->save();
						$cancelados .= "#".$row->id_recibo." ";
						$otrasreservas = ReciboDetalles::model()->findAll('id_recibo='.$row->id_recibo.' and tipo="Activ" and id_reservacion!='.$actividad->id_reservacion);
						if(count($otrasreservas) > 0){
							$importeotras = 0; $reservas = "";
							foreach($otrasreservas as $otras){
								$importeotras += $otras->importe;
								$reservacion = ActivityReservacion::model()->findByPk($otras->id_reservacion);
								$reservacion->saldo += $otras->importe;
								$reservacion->save();
								$reservas .= "#".$otras->id_reservacion." ";
							}
							$Crearnota=$this->Crearnota($importeotras,$actividad,"Cancelación de Actividad #".$actividad->id_reservacion." - Importe de Actividad: ".$reservas);
						}
					}
					if($importe>0)
					$Crearnota=$this->Crearnota($importe,$actividad,"Cancelación de Actividad #".$actividad->id_reservacion." - Importe de Actividad: ".$importe);
				}
					
						$this->emailCancelarApi($actividad,'a');
						return $actividad;
			}else{
				echo "no hay actividad".$idReservacion;
			}
		}
		else if($booking->errors){
			echo "<b>Error:</b> <small>".$booking->errors[0]->text."</small> <br> <b>Codigo de Error:</b>  ".$booking->errors[0]->code;
		}
			
		
	}

}