<?php
error_reporting(E_ALL & ~E_NOTICE);
Yii::import('application.extensions.bootstrap.gii.*');
require_once('bootstrap/tcpdf/tcpdf.php');
require_once('bootstrap/tcpdf/config/lang/eng.php');
require_once('../api/beds/HotelApi.php');
require_once('../api/beds/ActivityApi.php');
class ReservasController extends Controller
{
	/**
	 * Declares the behaviors.
	 * @return array the behaviors
	 */
	public function behaviors()
	{
		return array(
			'seo'=>'ext.seo.components.SeoControllerBehavior',
		);
	}
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}
	public function accessRules()
	{
		return array(
			array('allow',
				'actions'=>array('error'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('index','Reservaciones','ReservacionesAll','ReservacionesAlljson', 'ReservacionesjsonBroked','ReservacionesBro','BookingInf','Reservacionesjson', 'CancelarBooking','PoliticasCancelacion', 'ActivityReservaciones', 'ActivityReservacionesJson','ActivityInf','ReservacionesTours','ReservacionesjsonTours','ReservacionesOmnibees', 'OmnibeesReservacionesjson', 'BookingInfOmniBees', 'Bloqueos', 'BloqueosJson','reservacionesTS','reservacionesJsonTS','reservacionesDingus','reservacionesJsonDingus','BookingInfoDingus','reservacionesRiu','reservacionesRiuJson','resultados','recibosAgencia','misReservaciones','cancelarRmt','cancelarRmTours','tours','Facturas','consultaOrdenDetalles'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('ConsultarTarifas'),
				'roles'=>array('verTarifa'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}
	/**
	 * Declares class-based actions.
	 * @return array the actions
	 */
	public function actions()
	{
		return array(
			'captcha'=>array(
				'class'=>'CCaptchaAction',
				'backColor'=>0xFFFFFF,
			),
		);
	}
	public function actionMisReservaciones(){
		unset($_SESSION['searching']);
		$this->redirect(array('reservaciones'));
	}
	public function actionReservaciones()
	{
		$this->layout = "//layouts/ansonika_site";
		
		$this->render('reservaciones');
	}
	
	
	public function actionRecibosAgencia(){
		$condAgencia = "";
		if($_SESSION["tipoUsuario"] == "Agencia")
		{
			$condAgencia = " where r.id_agencia=".$_SESSION["agenciaUsuario"]."";
		}
		$sqlRecibos="select r.id_recibo, t.descripcion, r.id_tipo as id_tipo_pago, r.referencia, r.tarjeta, IF(r.estado='C' OR r.id_tipo=11,0,r.importe) as importe, IF(MONTH (r.log) = MONTH (NOW()),1,0) as puede_facturar_fecha, date_format(r.log,'%Y-%m-%d %H:%i:%s') as log, r.facturado as facturado_bd, a.id_agencia, a.nombre_agencia, u.nombre_usuario, r.comision, r.estado, r.revisado, r.id_cuenta
				from tbl_recibo r 
				inner join tbl_tipo_pago t on r.id_tipo=t.id_tipo 
				left join tbl_agencias a on r.id_agencia=a.id_agencia 
				inner join tbl_usuarios u on r.id_user=u.id_usuario where r.id_agencia=".$_POST["agenciaUsuario"]." ORDER BY r.log DESC;";
		$sqlNC="select r.id_nota_credito, t.descripcion, r.id_tipo as id_tipo_pago, r.referencia, r.tarjeta, IF(r.estatus='C' OR r.id_tipo=11,0,r.importe) as importe, IF(MONTH (r.fecha) = MONTH (NOW()),1,0) as puede_facturar_fecha, date_format(r.fecha,'%Y-%m-%d %H:%i:%s') as log, r.facturado as facturado_bd, a.id_agencia, a.nombre_agencia, u.nombre_usuario, r.comision, r.estatus as estado, r.revisado, r.id_cuenta, r.tipo_ref
				from tbl_nota_credito r 
				inner join tbl_tipo_pago t on r.id_tipo=t.id_tipo 
				left join tbl_agencias a on r.id_agencia=a.id_agencia 
				inner join tbl_usuarios u on r.id_user=u.id_usuario where r.id_agencia=".$_POST["agenciaUsuario"]." ORDER BY r.fecha DESC";
		$sqlCompr="select r.id_comprobante_pago, t.descripcion, r.id_tipo as id_tipo_pago, r.referencia, r.tarjeta, IF(r.estatus='C' OR r.id_tipo=11,0,r.total) as importe, IF(MONTH (r.log) = MONTH (NOW()),1,0) as puede_facturar_fecha, date_format(r.log,'%Y-%m-%d %H:%i:%s') as log, r.facturado as facturado_bd, a.id_agencia, a.nombre_agencia, u.nombre_usuario, r.comision, r.estatus as estado, r.revisado, r.id_cuenta, r.id_orden_pago
				from tbl_comprobantes_pago r 
				inner join tbl_tipo_pago t on r.id_tipo=t.id_tipo 
				left join tbl_agencias a on r.id_agencia=a.id_agencia 
				inner join tbl_usuarios u on r.id_user=u.id_usuario where r.id_agencia=".$_POST["agenciaUsuario"]." AND tipo='agencia' ORDER BY r.log DESC;";

		$rowsRecibos=Yii::app()->db->createCommand($sqlRecibos)->queryAll();
		$rowsNC=Yii::app()->db->createCommand($sqlNC)->queryAll();
		$rowsCompr=Yii::app()->db->createCommand($sqlCompr)->queryAll();

		$facturables = array_merge($rowsRecibos,$rowsNC);
		$facturables = array_merge($facturables,$rowsCompr);
		
		$hoy = date('Y-m-d H:i:s'); // fecha actual
		$numDiasMesActual = date("t", strtotime($hoy)); // numero de dias que tiene el mes actual
		$mesActual = date('m',strtotime($hoy)); // mes del año actual
		$añoActual = date('Y',strtotime($hoy)); // año actual

		$fechalimite_26Mes = date('Y-m-25 23:59:59'); // fecha del fin de mes actual e igual la fecha limite de facturar
		$fechalimite_HoyMes = date('Y-m-d 23:59:59'); // fecha del fin de mes actual e igual la fecha limite de facturar

		// si un mes tiene 31 dias se le resta uno para que todos los meses sean iguales
		// if ($numDiasMesActual==31) {
		// 	$restarFechaFinMes = strtotime('-1 day', strtotime( $fechalimite_FinMes ));
		// 	$fechalimite_FinMes = date('Y-m-d 17:00:00', $restarFechaFinMes);
		// }

		$diffFin26Actual = strtotime($fechalimite_26Mes);  
		$diffFinHoy = strtotime($fechalimite_HoyMes);

		$facturas = array();

		foreach ($facturables as $key => $data) {

			if (isset($data['id_recibo'])) {
				$tipo_nota = 'recibo';
				$nota_factura = $data['id_recibo'];
				$data['id_recibo'] = $data['id_recibo'];
				$data['tipoFactura'] = 'recibo';

			}else if (isset($data['id_nota_credito'])) {
				$tipo_nota = 'credito';
				$nota_factura = $data['id_nota_credito'];
				$data['id_recibo'] = $data['id_nota_credito'];
				$data['tipoFactura'] = 'credito';

			} else if (isset($data['id_comprobante_pago'])){
				$tipo_nota = 'comprobante';
				$nota_factura = $data['id_comprobante_pago'];
				$data['id_recibo'] = $data['id_comprobante_pago'];
				$data['tipoFactura'] = 'comprobante';
				$data['id_orden_pago'] = $data['id_orden_pago'];
			}
			$mesRecibo = date("m", strtotime($data['log'])); // mes que se hizo el recibo
			$añoRecibo = date("Y", strtotime($data['log'])); // año que se hizo el recibo
			$numDiasMesRecibo = date('t',strtotime($data['log'])); // dias que tiene el mes que se hizo el recibo

			$diffFinMesRecibo = strtotime($data['log']);

			$data['puede_facturar_fecha'] = 0;
			$data['facturado'] = 0;
			$data['fecha_limite_factura'] = null;


			// si la fecha de creacion del recibo es menor a la fecha limite de fin de mes
			// si el mes de la fecha de creacion es igual al mes actual
			// si el año de la fecha de creacion es igual al año actual
			// if ($diffFinMesRecibo<$diffFin26Actual && $diffFin26Actual<=date('Y-m-d 23:59:59') && $mesRecibo==$mesActual && $añoRecibo==$añoActual && ($data['estado']=='P' || $data['estado']=='A') && $data['facturado_bd']==0) {				
			if ($diffFinMesRecibo<$diffFin26Actual && strtotime(date('Y-m-d H:i:s'))<$diffFin26Actual && $mesRecibo==$mesActual && $añoRecibo==$añoActual && ($data['estado']=='P' || $data['estado']=='A') && $data['facturado_bd']==0) {				
				// suma de 5 dias a la fecha de creacion
				// $fechalimite_cincodias = strtotime ( '+5 day' , strtotime($data['log']));
				// $fechalimite_cincodias = date('Y-m-d 23:59:59',$fechalimite_cincodias); 

				// si el recibo despues de los 5 dias permitidos es el fin de mes 30,31,28 la fecha limite sera a la 5pm del ultimo dia del mes
				// if (date('d',strtotime($fechalimite_cincodias)) == $numDiasMesActual) {
				// 	$fechalimite_cincodias = $fechalimite_FinMes;
				// }

				// si el recibo despues de los 5 dias permitidos es el siguiente mes la fecha limite sera a la 5pm del ultimo dia del mes
				// if ($mesActual < date('m',strtotime($fechalimite_cincodias))) {
				// 	$fechalimite_cincodias = $fechalimite_FinMes;
				// }

				$diffCincoDias = strtotime($fechalimite_cincodias);

				// si la fecha y hora actual es menor a la fecha limite permitida procede a facturar
				// if (strtotime($hoy)<$diffCincoDias && $data['estado']=='P') {
					$data['puede_facturar_fecha'] = 1;
					$data['fecha_limite_factura'] = date('25/m/Y 23:59:59');
					// echo $data['id_recibo'].'/////'.$data['puede_facturar_fecha']."<br>";
				// }
				
			}

			// si la fecha pasa el 25 de cada mes, solo tendra el dia para facturar
			if ($diffFinMesRecibo > $diffFin26Actual && $diffFinMesRecibo > strtotime(date('Y-m-d 00:00:00')) && $diffFinMesRecibo < $diffFinHoy && $mesRecibo==$mesActual && $añoRecibo==$añoActual && ($data['estado']=='P' || $data['estado']=='A') && $data['facturado_bd']==0) {

				$data['puede_facturar_fecha'] = 1;
				$data['fecha_limite_factura'] = date('d/m/Y 23:59:59');
				
			}
			
			// $busquedaFacturas = FeFacturasDetalle::model()->findAll('id_recibo='.$data["id_recibo"]);
			// $_SESSION['agenciaUsuario'].'A'.$recibo->id_recibo
			$referencia_agencia = '';
			// $referencia_agencia = $_SESSION['agenciaUsuario'].'A'.$data["id_recibo"];
			$referencia_agencia = 'A'.$nota_factura;
			$busquedaFacturas = FeFacturas::model()->findAll('referencia_agencia LIKE "%'.$referencia_agencia.'" AND estatus="A" AND tipo_nota="'.$tipo_nota.'"');
			if (!empty($busquedaFacturas)) {
				$data['facturado'] = 1;
				$data['puede_facturar_fecha'] = 0;
				$data['fecha_limite_factura'] = null;
			}

			$facturas[] = $data;

		}
		echo '{"row":' .CJSON::encode($facturas). ', "__count": "'.count($facturas).'"}';
	}

	public function actionFacturas(){
		
		$facturas = FeFacturas::model()->findAll('id_agencia='.$_SESSION["agenciaUsuario"].' ORDER BY folio ASC');
		$datos = array();
		foreach ($facturas as $index => $value) {
			$datos[$index]['id_factura'] = $value->id_factura;
			$datos[$index]['folio'] = $value->folio.$value->serie;
			$datos[$index]['moneda'] = $value->moneda;
			$datos[$index]['razon_social'] = $value->receptor_razon_social;
			$datos[$index]['rfc'] = $value->receptor_rfc;
			$datos[$index]['id_agencia'] = $value->id_agencia;
			$datos[$index]['nombre_agencia'] = $value->idAgencia->nombre_agencia;
			$datos[$index]['recibo'] = $value->id_nota;
			$datos[$index]['total'] = $value->total;
			$datos[$index]['estatus'] = $value->estatus;
			$datos[$index]['tipo_nota'] = $value->tipo_nota;
			$datos[$index]['log'] = $value->fecha_creacion;
		}

		echo '{"row":' .CJSON::encode($datos). ', "__count": "'.count($facturas).'"}';


	}

	public function consultaOrdenDetalles($id,$tipo){
		$add_tipo = '';
		if (!empty($tipo)) {
			$add_tipo = " AND tipo_producto='".$tipo."'";
		}
		$sql = "SELECT o.*, op.log FROM tbl_orden_pago_detalles o INNER JOIN tbl_orden_pago op USING(id_orden_pago) WHERE o.identificador='".$id."' AND op.estatus='PA'".$add_tipo;
    	$orden = Yii::app()->db->createCommand($sql)->queryAll();

    	return $orden;
	}
	
	public function cancelar($params)
	{
		$hotelApi = new HotelApi();
		$estatus = $hotelApi->estatus();
		if($estatus=="OK")
		{
			$datos = $hotelApi->bookingCancellation($params);
			return $datos;
		}
		else
		{
			return "No hubo conexión";
		}
	}
	public function actionCancelarRmt($id_reservacion)
	{
		$model=Reservacion::model()->findByPk($id_reservacion);
		$fechaSC=date("d/m/Y",strtotime($model->fecha_limite));
		$PoliticasCancelacion[0]=array('habitacion'=>6, 'fecha'=>$fechaSC, 'importe'=>'$'.number_format($model->total,2));
		echo json_encode($PoliticasCancelacion);
		
	}
	public function actionCancelarRmTours($id_reservacion)
	{
		$model=TourReservacion::model()->findByPk($id_reservacion);
		$fechaSC=date("d/m/Y",strtotime($model->fecha_limite));
		$PoliticasCancelacion[0]=array('habitacion'=>6, 'fecha'=>$fechaSC, 'importe'=>'$'.number_format($model->importe,2));
		echo json_encode($PoliticasCancelacion);
		
	}
	public function actionCancelarBooking()
	{
		$cancelar=$_POST["cancelar"];
		$code=explode(',',$_POST['code']);
		$cancelacion=array();
		foreach ($code as $key=>$codigo) {

			$codes=substr($codigo,2);
			$params= array();
			$params['bookingId']=$codes;
			$params['cancellationFlag']=$cancelar;
			$cancel= $this->cancelar(json_encode($params));
			$booking=json_decode($cancel);
			$markup = Api::model()->findByPk(1)->markup;
			
			//$this->redirect('reservacion/view',array('id'=>$id_reservacion));

			if($cancelar=='SIMULATION')
			{
				
				if($booking->booking->reference==$params['bookingId'])
				{
					$fechaSC=date('Y-m-d',strtotime($booking->booking->hotel->rooms[0]->rates[0]->cancellationPolicies[0]->from));
					$cancelacionInmediata="0";
					$importe=$booking->booking->hotel->rooms[0]->rates[0]->cancellationPolicies[0]->amount;
					if ($fechaSC > date("Y-m-d", strtotime(date("Y-m-d")."+ 1 days"))) {
						$cancelacionInmediata="1";
					}
					$cancelacion[$key]=array('habitacion'=>($key+1),'fecha'=>date('d/m/Y',strtotime($fechaSC)), 'importe'=>'$'.number_format($importe,2));
					$cancelacion["btnCancelacion"][$key]=$cancelacionInmediata;
					/*$cancelacion =	'<p>Cancelación <span class="text-success">SIN COSTO</span> hasta el <span class="text-success">'$fechaSC.' '.substr($booking->booking->hotel->rooms[0]->rates[0]->cancellationPolicies[0]->from,11,5).'</span></p>
						<p>Cancelación con costo durante las fechas:</p>
						<table class="table table-bordered table-striped table-condensed">
							<thead>
								<th>Fecha</th>
								<th>Costo</th>
							</thead>
							<tbody>';
								 
									foreach ($booking->booking->hotel->rooms[0]->rates[0]->cancellationPolicies as $fechas) 
									{
										
										$cancelacion.='<tr>
												<td>'.implode("/", array_reverse(explode("-",substr($fechas->from,0,10)))).'</td>
												<td align="right">$'.number_format($fechas->amount/$markup,2).'</td>										
											</tr>';
															
									}
								
						$cancelacion.=	'</tbody>
						</table>'*/
					
				}else{
					$cancelacion= array('error'=>"Ocurrió un error, no se puede cancelar la reserva");
					$cancelacion=$cancel;
				}		
			}
			/*else if($cancelar=='CANCELLATION')
			{
				if($booking->booking->reference==$params['bookingId'] && $booking->booking->status=="CANCELLED")
				{
					$habitacion = ReservacionDesglose::model()->findByPk($_POST["idDesglose"]);
					
					if($habitacion->id_desglose==$_POST["idDesglose"])
					{
						$habitacion->estatus=0; 
						if($habitacion->save())
							echo "<p>La habitación ha sido cancelada </p>";					
						
					}
				}else
				{
					echo "<br>Ocurrió un error al intentar cancelar la reserva.";
				}
			}*/
		}
		echo json_encode($cancelacion);	
	}
	/*public function actionActivityInf()
	{	
		if (isset($_POST['code'])) 
		{
			$codigo=$_POST['code'];
		}
		$param=array();
		$param['bookingReference']=substr($codigo, 6);
		$inf= $this->ActivityInfo(json_encode($param));
		//echo $inf;
		$markup = Api::model()->findByPk(2)->markup;
		$book= json_decode($inf);
		$cancellationPolicies=$book->booking->activities[0]->cancellationPolicies[0];
		$fechaSC=date('Y-m-d',strtotime($cancellationPolicies->dateFrom));
		$cancelacionInmediata="0";
		$importe=$booking->booking->hotel->rooms[0]->rates[0]->cancellationPolicies[0]->amount;
		if ($fechaSC > date("Y-m-d", strtotime(date("Y-m-d")."+ 1 days"))) {
			$cancelacionInmediata="1";
		}
		$hab[0]= array('habitacion'=>6,'fecha'=>date('d/m/Y',strtotime($fechaSC)), 'importe'=>'$'.number_format($cancellationPolicies->amount,2));
		$hab['btnCancelacion'][0]=$cancelacionInmediata;
		echo json_encode($hab);
	
	}*/
	public function actionActivityInf() {
		$cancelar='SIMULATION';
		$code=$_POST["code"];
		$params= array();
		$params['bookingReference']=substr($code,6);
		$params['cancellationFlag']=$cancelar;
		$actControl= Yii::app()->createController('activities')[0];
		$cancel= $actControl->activityCancelar(json_encode($params));
		$booking=json_decode($cancel);
		$markup = Api::model()->findByPk(2)->markup;
		$hab=array();
		if($booking->booking->reference==$params['bookingReference']) {								
			foreach ($booking->booking->activities[0]->cancellationPolicies as $key=>$fechas) 
			{
				$date1=date('Y-m-d');
		 		$date2=$fechas->dateFrom;
		 		$fecha_limite_activity=$fechas->dateFrom;
	    		$fecha_limite=$actControl->fechaLimiteagencia($fecha_limite_activity, $date1,$date2);
				$fechaSC=date("Y-m-d",strtotime($fecha_limite));
				$cancelacionInmediata="0";
				if($fechaSC > date("Y-m-d", strtotime($date1."+ 1 days"))) {
					$cancelacionInmediata="1";
				}
				$hab[$key]= array('habitacion'=>6,'fecha'=>date('d/m/Y',strtotime($fechaSC)),'importe'=>'$'.number_format($fechas->amount/$markup,2)." ".$booking->booking->currency);	
				$hab['btnCancelacion'][$key]=$cancelacionInmediata;			
			}				
		}else {
			$arrBooking=json_decode($cancel,true);
			$key=false;
			$codeCancel=array('ACTGTW_E_55', 'ACTGTW_E_113');
			for ($i=0; $i < count($codeCancel); $i++) { 		
				$key = array_search($codeCancel[$i], array_column($arrBooking["errors"], 'code'));
			}
			if($key===false)
			{
				echo "Ocurrio un error al intentar realizar la cancelación de la reserva <p>".$arrBooking['text']."</p>";
			}else{
				echo "<div class='alert alert-warning text-center'><strong>La reserva ya ha sido cancelada con el proveedor</strong></div>";
			}
			exit;
		}						
	
		echo json_encode($hab);
	}
	public function activityData($code)
	{	
		if (isset($code))
		{
			$param=array();
			$param['bookingReference']=substr($code, 6);
			$inf= $this->ActivityInfo(json_encode($param));			
			return $inf;
		}
	}
	public function actionTours(){
		$tour=TourReservacion::model()->with('idDesglosePersona')->findAll('t.log between" 2019-08-01" and "2019-11-04" and t.id_tour in(64,60,63,65) and idDesglosePersona.edad=12 and t.estatus!="C"');
		foreach ($tour as $value) {
			echo $value->id_tourReservacion.'<br>';
			echo $value->idDesglosePersona->edad;

		}
	}
	public function ActivityInfo($param)
	{
		$activityApi = new ActivityApi();
		$datos = $activityApi->bookingDetail($param);
		return $datos;
	}

	
}