<?php

class ReservacionesGeneralesController extends Controller
{

	public $layout='//layouts/altair';

	public function behaviors()
	{
		return array(
			'seo'=>'ext.seo.components.SeoControllerBehavior',
		);
	}
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}
	public function accessRules()
	{
		return array(
			array('allow',
				'actions'=>array('error'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('Index','GetVentas', 'BusquedaHoteles', 'BusquedaCadenas'),
				'users'=>array('@'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	public function actionIndex()
	{
		if ($_POST['dpStart'] && $_POST['dpEnd'] && $_POST['slhotel'] && $_POST['slcadena']) {
			$_SESSION['ventas']['dpStart'] = $_POST['dpStart'];
			$_SESSION['ventas']['dpEnd']= $_POST['dpEnd'];
			$_SESSION['ventas']['optionhotel'] = $_POST['optionhotel'];
			$_SESSION['ventas']['optioncadena'] = $_POST['optioncadena'];
			$_SESSION['ventas']['slhotel'] = $_POST['slhotel'];
			$_SESSION['ventas']['slcadena'] = $_POST['slcadena'];
		}else{
			$_SESSION['ventas']['dpStart'] = date("d/m/Y",strtotime('-1 week'));
			$_SESSION['ventas']['dpEnd']= date("d/m/Y");
			$_SESSION['ventas']['optionhotel'] = "";//43
			$_SESSION['ventas']['optioncadena'] = "";//33
			$_SESSION['ventas']['slhotel'] = "";//DREAMS TULUM RESORT AND SPA
			$_SESSION['ventas']['slcadena'] = ""; //AM RESORTS
		}
		$this->render('index',array('dpStart'=>$_SESSION['ventas']['dpStart'],'dpEnd'=>$_SESSION['ventas']['dpEnd'],'slhotel'=>$_SESSION['ventas']['slhotel'],'slcadena'=>$_SESSION['ventas']['slcadena'],'optionhotel'=>$_SESSION['ventas']['optionhotel'],'optioncadena'=>$_SESSION['ventas']['optioncadena']));
	}

	public function actionGetVentas(){
		header('Content-Type: application/json'); 

		$fecha_inicial = implode("-",array_reverse(explode("/",$_POST['dpStart'])));
		$fecha_final = implode("-",array_reverse(explode("/",$_POST['dpEnd'])));



		$consulta = "select R.id_reservacion, Ag.nombre_usuario, H.nombre_hotel, R.fecha_inicial, R.fecha_final, R.fecha_limite as fechalimiteA, R.fecha_limite_h as fechalimiteH, R.num_noches, R.log, R.total, R.saldo, R.saldo_h, R.tarifa_agencia, R.tarifa_neta, R.comision, R.num_habitaciones, R.num_noches*R.num_habitaciones as cuartos_noches, C.nombre, R.code, R.estatus, CONCAT(nombre_cliente ,' ', apellido_cliente) AS nombreCliente, A.nombre_agencia, H.proveedor, Ag.nombre_usuario, R.id_agente, R.id_bloqueo, H.comision as comisionHotel, R.libera_cupon
		FROM tbl_reservacion as R 
		INNER JOIN tbl_hoteles H ON H.id_hotel = R.id_hotel 
		INNER JOIN tbl_agencias A ON R.id_agencia = A.id_agencia 
		LEFT JOIN tbl_cadena_hotel C ON C.id = H.id_cadena 
		LEFT JOIN tbl_usuarios Ag ON R.id_usuario=Ag.id_usuario WHERE R.id_agencia=8 AND";
		//tbl_hoteles H ON H.id_hotel = R.id_hotel INNER JOIN tbl_cadena_hotel C ON C.id = H.id_cadena WHERE
		if (!empty($_POST['optionhotel']) && empty($_POST['optioncadena'])) {
			$consulta.=" H.id_hotel=".$_POST['optionhotel']." AND";
		}elseif (empty($_POST['optionhotel']) && !empty($_POST['optioncadena'])) {
			$consulta.=" H.id_cadena=".$_POST['optioncadena']." AND";
		}elseif (!empty($_POST['optionhotel']) && !empty($_POST['optioncadena'])) {
			$consulta.=" H.id_hotel=".$_POST['optionhotel']." AND H.id_cadena=".$_POST['optioncadena']." AND";
		}


		switch ($_POST["tipoFecha"]) {
			case 'a':
					$consulta.=" R.fecha_limite between '".$fecha_inicial." 00:00:00' AND '".$fecha_final." 23:59:59' ORDER BY R.fecha_limite DESC";
				# code...
				break;
			case 'h':
				# code...
					$consulta.=" R.fecha_limite_h between '".$fecha_inicial." 00:00:00' AND '".$fecha_final." 23:59:59' ORDER BY R.fecha_limite_h DESC";
				break;

			case 'e':
				# code...
					$consulta.=" R.fecha_inicial between '".$fecha_inicial."' AND '".$fecha_final."' ORDER BY R.fecha_inicial DESC";
				break;

			
			default:
				# code...
					$consulta.=" R.log between '".$fecha_inicial." 00:00:00' AND '".$fecha_final." 23:59:59' ORDER BY R.log DESC";
				break;
		}

		$row=Yii::app()->db->createCommand($consulta)->queryAll();										
		
		foreach($row as $key => $data){	
			$rowAll[$key]['id_reservacion'] = $data["id_reservacion"];
			$rowAll[$key]['estatus'] = $data["estatus"];
			$rowAll[$key]['code'] = $data["code"];
			$rowAll[$key]['log'] = $data["log"];
			$rowAll[$key]['fecha_inicial'] = $data["fecha_inicial"];
			$rowAll[$key]['fecha_final'] = $data["fecha_final"];
			$rowAll[$key]['fechalimiteA'] = $data["fechalimiteA"];
			$rowAll[$key]['fechalimiteH'] = $data["fechalimiteH"];
			$rowAll[$key]['nombre_hotel'] = $data["nombre_hotel"];
			$rowAll[$key]['nombre'] = $data["nombre"];
			$rowAll[$key]['nombre_agencia'] = $data["nombre_agencia"];
			$rowAll[$key]['nombreCliente'] = $data["nombreCliente"];
			$rowAll[$key]['num_noches'] = $data["num_noches"];
			$rowAll[$key]['num_habitaciones'] = $data["num_habitaciones"];
			$rowAll[$key]['cuartos_noches'] = $data["cuartos_noches"];
			$rowAll[$key]['total'] = $data["total"];
			$rowAll[$key]['tarifa_agencia'] = $data["tarifa_agencia"];
			$rowAll[$key]['tarifa_neta'] = $data["tarifa_neta"];
			$rowAll[$key]['abonado'] = $this->getAbono($data["id_reservacion"]);
			$rowAll[$key]['saldo'] = $data["saldo"];
			$rowAll[$key]['comision'] = $data["comision"];
			$rowAll[$key]['comision_pesos'] = $this->getTotalComision($data["total"],$data["comision"]);
			$rowAll[$key]['utilidad'] = $this->getUtilidad($data);
			$rowAll[$key]['proveedor'] = $data["proveedor"];
			$rowAll[$key]['manual'] = $this->getTipo($data);
			$rowAll[$key]['tipoReservacion'] = $this->showIfBloqueo($data["id_bloqueo"]);
			$rowAll[$key]['nombre_usuario'] = $data["nombre_usuario"];
			$rowAll[$key]['agente_preferido'] = Usuarios::model()->findByPk($data["id_agente"])->nombre_usuario;
			$rowAll[$key]['sucursal'] = $this->getSucursal($data["id_agente"]);
			$rowAll[$key]['libera_cupon'] = $data["libera_cupon"];
		}
		// 
		// comision $ comision->tarifa_publica

		// echo CJSON::encode($row);
		if (empty($rowAll)) {
			$rowAll=[];
		}
		echo json_encode($rowAll);
	}


	public function getTipo($reservacion){

		if ($reservacion["manual"] == 1) {
			$tipo = "Si";
		}else{
			$tipo = "No";
		}
		
		return $tipo;
	}


	public function showIfBloqueo($id_bloqueo){

		if ($id_bloqueo==null) {
			$reservacion = "/INDIVIDUAL";
		}elseif (!empty($id_bloqueo)) {
			$bloqueo = Bloqueos::model()->findByPk($id_bloqueo);

			switch ($bloqueo->tipo) {
				case 'GRUPAL':
					if ($bloqueo->idTarifa->precio=="BODA") {
						$reservacion = $id_bloqueo."/BODA";
					}else{
						$reservacion = $id_bloqueo."/GRUPAL";
					}
					break;
				case 'BLOQUEO':
						$reservacion = $id_bloqueo."/BLOQUEO";
					break;
				default:
						$reservacion = $id_bloqueo."/BLOQUEO";
					break;
			}
		}


		return $reservacion;
	}

	public function getAbono($id_reservacion){

		$recibos = ReciboDetalles::model()->findAll("id_reservacion=".$id_reservacion." AND tipo=''");
		if (!empty($recibos)) {
			foreach ($recibos as $total) {
				if ($total->idRecibo->estado!='C') {
					$totalPagado += $total->importe;
				}
			}
		}else{
			$totalPagado = 0;
		}

		return $totalPagado;
	}

	public function getTotalComision($total,$comision){
		
		$totalComision = $total*($comision/100);

		return $totalComision;
	}


	public function getUtilidad($reservacion){

		// abono a hoteles
		$importeHotel = $this->getPagosHoteles($reservacion["id_reservacion"]); 
		$totalSaldoHotel = $importeHotel + $reservacion["saldo_h"];


		// verifica si total y saldo_h son iguales
		// if ($reservaciones["total"] == $reservaciones["saldo_h"]) {
		// 	$totalSaldoHotel = $this->getSaldoReal($reservaciones["total"],$reservaciones["proveedor"],$reservaciones["comisionHotel"]) - $importeHotel;
		// }else{
		// 	$totalSaldoHotel = $importeHotel + $reservaciones->saldo_h;
		// }


		// abono de agencias
		$importeAgencia = $this->getAbono($reservacion["id_reservacion"]);
		$totalSaldoAgencia = $importeAgencia + $reservacion["saldo"];

		//totalAgencia - totalHotel
		$totalSaldoUtilidad = $totalSaldoAgencia - $totalSaldoHotel;

		return $totalSaldoUtilidad;
	}


	public function getPagosHoteles($id_reservacion){
		$comprobantes = OrdenesPagoDetalles::model()->findAll('id_reservacion='.$id_reservacion);
		if (!empty($comprobantes)) {
			foreach ($comprobantes as $total) {
				if ($total->idOrdenPago->estado!='C') {
					$totalPagado += $total->importe;
				}
			}
		}else{
			$totalPagado = 0;
		}
		return $totalPagado;
	}

	public function getSucursal($id_agente){
		$sucursal = SucursalesAgente::model()->find("id_user=".$id_agente);
		$matriz = Sucursales::model()->findByPk($sucursal->id_sucursal);
		
		return $matriz->nombre;
	}

	public function getSaldoReal($total,$proveedor,$comision_hotel){
		$reservacion = Yii::app()->createController('reservacion');
		$reservacion = $reservacion[0];
		switch ($proveedor) {
			case '0':
			$saldo_h = $reservacion->saldoHotel($total,$comision_hotel,"comision"); 
			break;
			case '1':
			$comision_hotel = Api::model()->findByPk(1)->markup;
			$saldo_h = $reservacion->saldoHotel($total,$comision_hotel,"Api");
			break;
			case '2':
			$saldo_h = $reservacion->saldoHotel($total,$comision_hotel,"comision");
			break;
			case '3':
			$comision_hotel = Api::model()->findByPk(6)->markup;
			$saldo_h = $reservacion->saldoHotel($total,$comision_hotel,"Api");
			break;
			case '4':
			$saldo_h = $reservacion->saldoHotel($total,20,"comision");
			break;
			case '5':
			$saldo_h = $reservacion->saldoHotel($total,$comision_hotel,"comision");
			break;
			case '6':
			$comision_hotel = Api::model()->findByPk(9)->markup;
			$saldo_h = $reservacion->saldoHotel($total,$comision_hotel,"Api");
			break;
			default:
				# code...
			break;
		}

		return $saldo_h;
	}

	public function actionBusquedaHoteles(){
		if(strlen($_POST["search"])>2 ){
			$criteria = new CDbCriteria;

			$criteria->select = array('id_hotel', 'nombre_hotel','proveedor');
			$arSearch=explode(" ", $_POST["search"]);

			$buscarNombreHotel=""; 
			foreach ($arSearch as $search) {
			$buscarNombreHotel .= 'and t.nombre_hotel like "%'.$search.'%" ';
				# code...
			}

			$criteria->condition = 't.estatus=1 '.$buscarNombreHotel;

			$criteria->order = 't.nombre_hotel';

			$hoteles = Hoteles::model()->findAll($criteria);

			$results = array("hoteles"=>$hoteles);
	        echo CJSON::encode($results);
		}
	}


	public function actionBusquedaCadenas(){
		if(strlen($_POST["search"])>2 ){
			$criteria = new CDbCriteria;

			$criteria->select = array('id', 'nombre');
			$arSearch=explode(" ", $_POST["search"]);

			$buscarNombreCadena="";
			foreach ($arSearch as $search) {
			$criteria->condition = 'nombre like "%'.$search.'%" ';
			}

			$criteria->order = 'nombre';

			$cadenas = CadenaHotel::model()->findAll($criteria);

			$results = array("cadenas"=>$cadenas);
	        echo CJSON::encode($results);
		}
	}

	// Uncomment the following methods and override them if needed
	/*
	public function filters()
	{
		// return the filter configuration for this controller, e.g.:
		return array(
			'inlineFilterName',
			array(
				'class'=>'path.to.FilterClass',
				'propertyName'=>'propertyValue',
			),
		);
	}

	public function actions()
	{
		// return external action classes, e.g.:
		return array(
			'action1'=>'path.to.ActionClass',
			'action2'=>array(
				'class'=>'path.to.AnotherActionClass',
				'propertyName'=>'propertyValue',
			),
		);
	}
	*/
}