<?php

class ReservacionRestController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column1';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
			array(
                'ext.starship.RestfullYii.filters.ERestFilter + 
                REST.GET, REST.PUT, REST.POST, REST.DELETE'
            ),
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow', 'actions'=>array('REST.GET', 'REST.PUT', 'REST.POST', 'REST.DELETE'),
				'users'=>array('@'),
			),
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('@'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update','GeneratePdf','GenerateExcel','reservasAgente'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	public function actions()
	{
        return array('REST.'=>'ext.starship.RestfullYii.actions.ERestActionProvider',);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	public function actionReservasAgente($id_usuario){
		$reservaciones = Reservacion::model()->findAll('id_agente='.$_GET['id_usuario'].' OR id_usuario='.$_GET['id_usuario']);
		$booking = array();
		foreach ($reservaciones as $key => $value) {
			// $hotel = Hoteles::model()->find('id_hotel='.$value->id_hotel);
			// $desglose = ReservacionDesglose::model()->findAll('id_reservacion='.$value->id_reservacion);
			// $desglosePersona = ReservacionDesglosePersona::model()->findAll('id_reservacion='.$value->id_reservacion);
			// $cancelacions = SolicitudCancelacion::model()->find('id_reserva='.$value->id_reservacion);

			// $books[$key] = array(
			// 	'idHotel'=>$hotel,
			// 	'reservacionDesgloses'=>$desglose,
			// 	'reservacionDesglosePersonas'=>$desglosePersona,
			// 	'solicitudCancelacions'=>$cancelacions
			// ); 
			
			// foreach ($value as $data) {
			// 	array_push($books[$key],$data);
			// }

		}
		echo '{"success": true,"message": "Record(s) Found","data":{"totalCount":'.count($books).',"reservacionRest":'.CJSON::encode($books).'}}';
	}
	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new ReservacionRest;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['ReservacionRest']))
		{
			$model->attributes=$_POST['ReservacionRest'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id_reservacion));
		}

		$this->render('create',array(
			'model'=>$model,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['ReservacionRest']))
		{
			$model->attributes=$_POST['ReservacionRest'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id_reservacion));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		if(Yii::app()->request->isPostRequest)
		{
			// we only allow deletion via POST request
			$this->loadModel($id)->delete();

			// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
			if(!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
		}
		else
			throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
            $session=new CHttpSession;
            $session->open();		
            $criteria = new CDbCriteria();            

                $model=new ReservacionRest('search');
                $model->unsetAttributes();  // clear any default values

                if(isset($_GET['ReservacionRest']))
		{
                        $model->attributes=$_GET['ReservacionRest'];
			
			
                   	
                       if (!empty($model->id_reservacion)) $criteria->addCondition("id_reservacion = '".$model->id_reservacion."'");
                     
                    	
                       if (!empty($model->id_agencia)) $criteria->addCondition("id_agencia = '".$model->id_agencia."'");
                     
                    	
                       if (!empty($model->id_hotel)) $criteria->addCondition("id_hotel = '".$model->id_hotel."'");
                     
                    	
                       if (!empty($model->id_usuario)) $criteria->addCondition("id_usuario = '".$model->id_usuario."'");
                     
                    	
                       if (!empty($model->id_agente)) $criteria->addCondition("id_agente = '".$model->id_agente."'");
                     
                    	
                       if (!empty($model->id_bloqueo)) $criteria->addCondition("id_bloqueo = '".$model->id_bloqueo."'");
                     
                    	
                       if (!empty($model->fecha_inicial)) $criteria->addCondition("fecha_inicial = '".$model->fecha_inicial."'");
                     
                    	
                       if (!empty($model->fecha_final)) $criteria->addCondition("fecha_final = '".$model->fecha_final."'");
                     
                    	
                       if (!empty($model->fecha_limite)) $criteria->addCondition("fecha_limite = '".$model->fecha_limite."'");
                     
                    	
                       if (!empty($model->fecha_limite_old)) $criteria->addCondition("fecha_limite_old = '".$model->fecha_limite_old."'");
                     
                    	
                       if (!empty($model->fecha_limite_h)) $criteria->addCondition("fecha_limite_h = '".$model->fecha_limite_h."'");
                     
                    	
                       if (!empty($model->fecha_liberacion)) $criteria->addCondition("fecha_liberacion = '".$model->fecha_liberacion."'");
                     
                    	
                       if (!empty($model->usuario_liberacion)) $criteria->addCondition("usuario_liberacion = '".$model->usuario_liberacion."'");
                     
                    	
                       if (!empty($model->num_noches)) $criteria->addCondition("num_noches = '".$model->num_noches."'");
                     
                    	
                       if (!empty($model->observaciones)) $criteria->addCondition("observaciones = '".$model->observaciones."'");
                     
                    	
                       if (!empty($model->estatus)) $criteria->addCondition("estatus = '".$model->estatus."'");
                     
                    	
                       if (!empty($model->log)) $criteria->addCondition("log = '".$model->log."'");
                     
                    	
                       if (!empty($model->subtotal)) $criteria->addCondition("subtotal = '".$model->subtotal."'");
                     
                    	
                       if (!empty($model->comision)) $criteria->addCondition("comision = '".$model->comision."'");
                     
                    	
                       if (!empty($model->iva)) $criteria->addCondition("iva = '".$model->iva."'");
                     
                    	
                       if (!empty($model->tipo_cambio)) $criteria->addCondition("tipo_cambio = '".$model->tipo_cambio."'");
                     
                    	
                       if (!empty($model->total)) $criteria->addCondition("total = '".$model->total."'");
                     
                    	
                       if (!empty($model->total_tc)) $criteria->addCondition("total_tc = '".$model->total_tc."'");
                     
                    	
                       if (!empty($model->saldo)) $criteria->addCondition("saldo = '".$model->saldo."'");
                     
                    	
                       if (!empty($model->saldo_h)) $criteria->addCondition("saldo_h = '".$model->saldo_h."'");
                     
                    	
                       if (!empty($model->tarifa_neta)) $criteria->addCondition("tarifa_neta = '".$model->tarifa_neta."'");
                     
                    	
                       if (!empty($model->tarifa_agencia)) $criteria->addCondition("tarifa_agencia = '".$model->tarifa_agencia."'");
                     
                    	
                       if (!empty($model->porc_com_agencia)) $criteria->addCondition("porc_com_agencia = '".$model->porc_com_agencia."'");
                     
                    	
                       if (!empty($model->num_habitaciones)) $criteria->addCondition("num_habitaciones = '".$model->num_habitaciones."'");
                     
                    	
                       if (!empty($model->nombre_cliente)) $criteria->addCondition("nombre_cliente = '".$model->nombre_cliente."'");
                     
                    	
                       if (!empty($model->apellido_cliente)) $criteria->addCondition("apellido_cliente = '".$model->apellido_cliente."'");
                     
                    	
                       if (!empty($model->tel_cliente)) $criteria->addCondition("tel_cliente = '".$model->tel_cliente."'");
                     
                    	
                       if (!empty($model->id_tarifa)) $criteria->addCondition("id_tarifa = '".$model->id_tarifa."'");
                     
                    	
                       if (!empty($model->code)) $criteria->addCondition("code = '".$model->code."'");
                     
                    	
                       if (!empty($model->factura)) $criteria->addCondition("factura = '".$model->factura."'");
                     
                    	
                       if (!empty($model->libera_cupon)) $criteria->addCondition("libera_cupon = '".$model->libera_cupon."'");
                     
                    	
                       if (!empty($model->id_tipo_plan)) $criteria->addCondition("id_tipo_plan = '".$model->id_tipo_plan."'");
                     
                    	
                       if (!empty($model->comision_bancaria)) $criteria->addCondition("comision_bancaria = '".$model->comision_bancaria."'");
                     
                    	
                       if (!empty($model->motivo)) $criteria->addCondition("motivo = '".$model->motivo."'");
                     
                    	
                       if (!empty($model->manual)) $criteria->addCondition("manual = '".$model->manual."'");
                     
                    	
                       if (!empty($model->politicas_cancelacion)) $criteria->addCondition("politicas_cancelacion = '".$model->politicas_cancelacion."'");
                     
                    	
                       if (!empty($model->desglose_rate)) $criteria->addCondition("desglose_rate = '".$model->desglose_rate."'");
                     
                    	
                       if (!empty($model->enviado_h)) $criteria->addCondition("enviado_h = '".$model->enviado_h."'");
                     
                    	
                       if (!empty($model->fecha_verificada)) $criteria->addCondition("fecha_verificada = '".$model->fecha_verificada."'");
                     
                    			
                    $session['ReservacionRest_records']=ReservacionRest::model()->findAll($criteria); 
		}
       

                $this->render('index',array(
			'model'=>$model,
		));

	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new ReservacionRest('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['ReservacionRest']))
			$model->attributes=$_GET['ReservacionRest'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model=ReservacionRest::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='reservacion-rest-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
        public function actionGenerateExcel()
	{
            $session=new CHttpSession;
            $session->open();		
            
             if(isset($session['ReservacionRest_records']))
               {
                $model=$session['ReservacionRest_records'];
               }
               else
                 $model = ReservacionRest::model()->findAll();

		
		Yii::app()->request->sendFile(date('YmdHis').'.xls',
			$this->renderPartial('excelReport', array(
				'model'=>$model
			), true)
		);
	}
        public function actionGeneratePdf() 
	{
           $session=new CHttpSession;
           $session->open();
		Yii::import('application.extensions.bootstrap.gii.*');
		require_once('bootstrap/tcpdf/tcpdf.php');
		require_once('bootstrap/tcpdf/config/lang/eng.php');

             if(isset($session['ReservacionRest_records']))
               {
                $model=$session['ReservacionRest_records'];
               }
               else
                 $model = ReservacionRest::model()->findAll();



		$html = $this->renderPartial('expenseGridtoReport', array(
			'model'=>$model
		), true);
		
		//die($html);
		
		$pdf = new TCPDF();
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor(Yii::app()->name);
		$pdf->SetTitle('ReservacionRest Report');
		$pdf->SetSubject('ReservacionRest Report');
		//$pdf->SetKeywords('example, text, report');
		$pdf->SetHeaderData('', 0, "Report", '');
		$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, "Example Report by ".Yii::app()->name, "");
		$pdf->setHeaderFont(Array('helvetica', '', 8));
		$pdf->setFooterFont(Array('helvetica', '', 6));
		$pdf->SetMargins(15, 18, 15);
		$pdf->SetHeaderMargin(5);
		$pdf->SetFooterMargin(10);
		$pdf->SetAutoPageBreak(TRUE, 0);
		$pdf->SetFont('dejavusans', '', 7);
		$pdf->AddPage();
		$pdf->writeHTML($html, true, false, true, false, '');
		$pdf->LastPage();
		$pdf->Output("ReservacionRest_002.pdf", "I");
	}
}
