<?php



class ReservacionDesglosePersonaController extends Controller

{

	/**

	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning

	 * using two-column layout. See 'protected/views/layouts/column2.php'.

	 */

	public $layout='//layouts/column1';



	/**

	 * @return array action filters

	 */

	public function filters()

	{

		return array(

			'accessControl', // perform access control for CRUD operations

		);

	}



	/**

	 * Specifies the access control rules.

	 * This method is used by the 'accessControl' filter.

	 * @return array access control rules

	 */

	public function accessRules()

	{

		return array(

			array('allow',  // allow all users to perform 'index' and 'view' actions

				'actions'=>array('index','view'),

				'users'=>array('@'),

			),

			array('allow', // allow authenticated user to perform 'create' and 'update' actions

				'actions'=>array('create','update','GeneratePdf','GenerateExcel'),

				'users'=>array('@'),

			),

			array('allow', // allow admin user to perform 'admin' and 'delete' actions

				'actions'=>array('admin','delete'),

				'users'=>array('admin'),

			),

			array('deny',  // deny all users

				'users'=>array('*'),

			),

		);

	}



	/**

	 * Displays a particular model.

	 * @param integer $id the ID of the model to be displayed

	 */

	public function actionView($id)

	{

		$this->render('view',array(

			'model'=>$this->loadModel($id),

		));

	}



	/**

	 * Creates a new model.

	 * If creation is successful, the browser will be redirected to the 'view' page.

	 */

	public function actionCreate()

	{

		$model=new ReservacionDesglosePersona;



		// Uncomment the following line if AJAX validation is needed

		// $this->performAjaxValidation($model);



		if(isset($_POST['ReservacionDesglosePersona']))

		{

			$model->attributes=$_POST['ReservacionDesglosePersona'];

			if($model->save())

//				$this->redirect(array('view','id'=>$model->id_desglose_persona));

				$this->redirect(array('reservacion/view','id'=>$model->id_reservacion));								

		}



		$this->render('create',array(

			'model'=>$model,

		));

	}



	/**

	 * Updates a particular model.

	 * If update is successful, the browser will be redirected to the 'view' page.

	 * @param integer $id the ID of the model to be updated

	 */

	public function actionUpdate($id)

	{
		$this->layout = "//layouts/ansonika_site";

		$model=$this->loadModel($id);



		// Uncomment the following line if AJAX validation is needed

		// $this->performAjaxValidation($model);



		if(isset($_POST['ReservacionDesglosePersona']))

		{

			$model->attributes=$_POST['ReservacionDesglosePersona'];

			$pax1=ReservacionDesglosePersona::model()->find('id_reservacion='.$model->id_reservacion.' ORDER BY id_desglose_persona ASC');

			

			if($model->save()){

				$reservacion = Reservacion::model()->findByPk($model->id_reservacion);

				if($pax1->id_desglose_persona == $id){

					$reservacion->nombre_cliente = $model->nombre;

					//$reservacion->save();

				}

				

				if(!empty($reservacion->id_bloqueo)){

					$adultos = ReservacionDesglosePersona::model()->findAll('id_desglose='.$model->id_desglose.' and tipo="A"');

					$nombres = "";

					foreach($adultos as $a){

						$nombres .= $a->nombre." / ";

					}

					$nombres = substr($nombres,0,-3);

					

					$menores = ReservacionDesglosePersona::model()->findAll('id_desglose='.$model->id_desglose.' and tipo="N"');

					$nombres_menores = "";

					foreach($menores as $m){

						$nombres_menores .= $m->nombre." / ";

					}

					$nombres_menores = substr($nombres_menores,0,-3);

					

					$habs = ReservacionDesglose::model()->findAll('id_reservacion='.$model->id_reservacion);

					$i = 1;

					foreach($habs as $hab){

						if($hab->id_desglose == $model->id_desglose){

							$numHab = $i;

							break;

						}

						$i++;

					}

					

					$roominglist = Roominglist::model()->findAll('id_reservacion='.$model->id_reservacion);

					$i = 1;

					foreach($roominglist as $row){

						if($i == $numHab){

							$row->nombre = $nombres;

							$row->menor = $nombres_menores;

							$row->save();

							break;

						}

						$i++;

					}

				}

				

				$this->redirect(array('reservacion/view','id'=>$model->id_reservacion));

			}

		}



		$this->render('update',array(

			'model'=>$model,

		));

	}



	/**

	 * Deletes a particular model.

	 * If deletion is successful, the browser will be redirected to the 'admin' page.

	 * @param integer $id the ID of the model to be deleted

	 */

	public function actionDelete($id)

	{

		if(Yii::app()->request->isPostRequest)

		{

			// we only allow deletion via POST request

			$this->loadModel($id)->delete();



			// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser

			if(!isset($_GET['ajax']))

				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));

		}

		else

			throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');

	}



	/**

	 * Lists all models.

	 */

	public function actionIndex()

	{

            $session=new CHttpSession;

            $session->open();		

            $criteria = new CDbCriteria();            



                $model=new ReservacionDesglosePersona('search');

                $model->unsetAttributes();  // clear any default values



                if(isset($_GET['ReservacionDesglosePersona']))

		{

                        $model->attributes=$_GET['ReservacionDesglosePersona'];

			

			

                   	

                       if (!empty($model->nombre)) $criteria->addCondition("nombre = '".$model->nombre."'");

                     

                    	

                       if (!empty($model->tipo)) $criteria->addCondition("tipo = '".$model->tipo."'");

                     

                    	

                       if (!empty($model->edad)) $criteria->addCondition("edad = '".$model->edad."'");

                     

                    	

                       if (!empty($model->int)) $criteria->addCondition("int = '".$model->int."'");

                     

                    	

                       if (!empty($model->log)) $criteria->addCondition("log = '".$model->log."'");

                     

                    	

                       if (!empty($model->id_desglose)) $criteria->addCondition("id_desglose = '".$model->id_desglose."'");

                     

                    	

                       if (!empty($model->id_desglose_persona)) $criteria->addCondition("id_desglose_persona = '".$model->id_desglose_persona."'");

                     

                    	

                       if (!empty($model->id_reservacion)) $criteria->addCondition("id_reservacion = '".$model->id_reservacion."'");

                     

                    			

                    $session['ReservacionDesglosePersona_records']=ReservacionDesglosePersona::model()->findAll($criteria); 

		}

       



                $this->render('index',array(

			'model'=>$model,

		));



	}



	/**

	 * Manages all models.

	 */

	public function actionAdmin()

	{

		$model=new ReservacionDesglosePersona('search');

		$model->unsetAttributes();  // clear any default values

		if(isset($_GET['ReservacionDesglosePersona']))

			$model->attributes=$_GET['ReservacionDesglosePersona'];



		$this->render('admin',array(

			'model'=>$model,

		));

	}



	/**

	 * Returns the data model based on the primary key given in the GET variable.

	 * If the data model is not found, an HTTP exception will be raised.

	 * @param integer the ID of the model to be loaded

	 */

	public function loadModel($id)

	{

		$model=ReservacionDesglosePersona::model()->findByPk($id);

		if($model===null)

			throw new CHttpException(404,'The requested page does not exist.');

		return $model;

	}



	/**

	 * Performs the AJAX validation.

	 * @param CModel the model to be validated

	 */

	protected function performAjaxValidation($model)

	{

		if(isset($_POST['ajax']) && $_POST['ajax']==='reservacion-desglose-persona-form')

		{

			echo CActiveForm::validate($model);

			Yii::app()->end();

		}

	}

        public function actionGenerateExcel()

	{

            $session=new CHttpSession;

            $session->open();		

            

             if(isset($session['ReservacionDesglosePersona_records']))

               {

                $model=$session['ReservacionDesglosePersona_records'];

               }

               else

                 $model = ReservacionDesglosePersona::model()->findAll();



		

		Yii::app()->request->sendFile(date('YmdHis').'.xls',

			$this->renderPartial('excelReport', array(

				'model'=>$model

			), true)

		);

	}

        public function actionGeneratePdf() 

	{

           $session=new CHttpSession;

           $session->open();

		Yii::import('application.extensions.bootstrap.gii.*');

		require_once('bootstrap/tcpdf/tcpdf.php');

		require_once('bootstrap/tcpdf/config/lang/eng.php');



             if(isset($session['ReservacionDesglosePersona_records']))

               {

                $model=$session['ReservacionDesglosePersona_records'];

               }

               else

                 $model = ReservacionDesglosePersona::model()->findAll();







		$html = $this->renderPartial('expenseGridtoReport', array(

			'model'=>$model

		), true);

		

		//die($html);

		

		$pdf = new TCPDF();

		$pdf->SetCreator(PDF_CREATOR);

		$pdf->SetAuthor(Yii::app()->name);

		$pdf->SetTitle('ReservacionDesglosePersona Report');

		$pdf->SetSubject('ReservacionDesglosePersona Report');

		//$pdf->SetKeywords('example, text, report');

		$pdf->SetHeaderData('', 0, "Report", '');

		$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, "Example Report by ".Yii::app()->name, "");

		$pdf->setHeaderFont(Array('helvetica', '', 8));

		$pdf->setFooterFont(Array('helvetica', '', 6));

		$pdf->SetMargins(15, 18, 15);

		$pdf->SetHeaderMargin(5);

		$pdf->SetFooterMargin(10);

		$pdf->SetAutoPageBreak(TRUE, 0);

		$pdf->SetFont('dejavusans', '', 7);

		$pdf->AddPage();

		$pdf->writeHTML($html, true, false, true, false, '');

		$pdf->LastPage();

		$pdf->Output("ReservacionDesglosePersona_002.pdf", "I");

	}

}

