<?php

class ReservacionDesgloseController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column1';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view','tablaDesglose'),
				'users'=>array('@'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update','GeneratePdf','GenerateExcel', 'tablaDesglose', 'tablaDesgloseAll'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new ReservacionDesglose;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['ReservacionDesglose']))
		{
			$model->attributes=$_POST['ReservacionDesglose'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id_desglose));
		}

		$this->render('create',array(
			'model'=>$model,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['ReservacionDesglose']))
		{
			$model->attributes=$_POST['ReservacionDesglose'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id_desglose));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		if(Yii::app()->request->isPostRequest)
		{
			// we only allow deletion via POST request
			$this->loadModel($id)->delete();

			// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
			if(!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
		}
		else
			throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
            $session=new CHttpSession;
            $session->open();		
            $criteria = new CDbCriteria();            

                $model=new ReservacionDesglose('search');
                $model->unsetAttributes();  // clear any default values

                if(isset($_GET['ReservacionDesglose']))
		{
                        $model->attributes=$_GET['ReservacionDesglose'];
			
			
                   	
                       if (!empty($model->id_desglose)) $criteria->addCondition("id_desglose = '".$model->id_desglose."'");
                     
                    	
                       if (!empty($model->id_reservacion)) $criteria->addCondition("id_reservacion = '".$model->id_reservacion."'");
                     
                    	
                       if (!empty($model->precio_adulto)) $criteria->addCondition("precio_adulto = '".$model->precio_adulto."'");
                     
                    	
                       if (!empty($model->precio_ninio)) $criteria->addCondition("precio_ninio = '".$model->precio_ninio."'");
                     
                    	
                       if (!empty($model->num_adultos)) $criteria->addCondition("num_adultos = '".$model->num_adultos."'");
                     
                    	
                       if (!empty($model->num_ninios)) $criteria->addCondition("num_ninios = '".$model->num_ninios."'");
                     
                    	
                       if (!empty($model->num_jrs)) $criteria->addCondition("num_jrs = '".$model->num_jrs."'");
                     
                    	
                       if (!empty($model->estatus)) $criteria->addCondition("estatus = '".$model->estatus."'");
                     
                    	
                       if (!empty($model->log)) $criteria->addCondition("log = '".$model->log."'");
                     
                    	
                       if (!empty($model->id_base_habitacion)) $criteria->addCondition("id_base_habitacion = '".$model->id_base_habitacion."'");
                     
                    	
                       if (!empty($model->id_tipo_habitacion)) $criteria->addCondition("id_tipo_habitacion = '".$model->id_tipo_habitacion."'");
                     
                    	
                       if (!empty($model->desgloseBeds)) $criteria->addCondition("desgloseBeds = '".$model->desgloseBeds."'");
                     
                    			
                    $session['ReservacionDesglose_records']=ReservacionDesglose::model()->findAll($criteria); 
		}
       

                $this->render('index',array(
			'model'=>$model,
		));

	}

	public function actionTablaDesglose()
	{
		$modelReservacion = Reservacion::model()->findAll('id_reservacion >= 32500 and id_bloqueo is null and fecha_inicial >= "2018-11-26" and estatus!="C" and manual=0');
			$resevacionController=Yii::app()->createController('reservacion');
			$resevacionController=$resevacionController[0];
			$reservaciones=array();
			foreach ($modelReservacion as $key => $reservacion) {
				if ($reservacion->hotel->proveedor==0) {
					$reservacionDesglose=$resevacionController->desgloseReservacion($reservacion);
					$reservaciones[$reservacion->id_reservacion]=$reservacionDesglose[0][0][0];
					$reservaciones[$reservacion->id_reservacion]['noches']=$reservacion->num_noches;
				}
				//$reservaciones[$reservacion->id_reservacion]=array($reservacion->);
				
			}

		
		//echo "<textarea>".CJSON::encode($reservaciones)."</textarea>";
		 $this->render('tablaDesglose',array(
			'model'=>$reservaciones,
		));

	}

	public function actionTablaDesgloseAll()
	{
		$modelReservacion = Reservacion::model()->findAll('id_reservacion >= 32500 and id_bloqueo is null and fecha_inicial >= "2018-11-26" and estatus!="C" and manual=0');
			$resevacionController=Yii::app()->createController('reservacion');
			$resevacionController=$resevacionController[0];
			$reservaciones=array();
			foreach ($modelReservacion as $key => $reservacion) {
				
					$reservacionDesglose=$resevacionController->desgloseReservacion($reservacion);
					$reservaciones[$reservacion->id_reservacion]=$reservacionDesglose[0][0][0];
					$reservaciones[$reservacion->id_reservacion]['noches']=$reservacion->num_noches;
				
				//$reservaciones[$reservacion->id_reservacion]=array($reservacion->);
				
			}

		
		//echo "<textarea>".CJSON::encode($reservaciones)."</textarea>";
		 $this->render('tablaDesglose',array(
			'model'=>$reservaciones,
		));

	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new ReservacionDesglose('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['ReservacionDesglose']))
			$model->attributes=$_GET['ReservacionDesglose'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model=ReservacionDesglose::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='reservacion-desglose-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
        public function actionGenerateExcel()
	{
            $session=new CHttpSession;
            $session->open();		
            
             if(isset($session['ReservacionDesglose_records']))
               {
                $model=$session['ReservacionDesglose_records'];
               }
               else
                 $model = ReservacionDesglose::model()->findAll();

		
		Yii::app()->request->sendFile(date('YmdHis').'.xls',
			$this->renderPartial('excelReport', array(
				'model'=>$model
			), true)
		);
	}
        public function actionGeneratePdf() 
	{
           $session=new CHttpSession;
           $session->open();
		Yii::import('application.extensions.bootstrap.gii.*');
		require_once('bootstrap/tcpdf/tcpdf.php');
		require_once('bootstrap/tcpdf/config/lang/eng.php');

             if(isset($session['ReservacionDesglose_records']))
               {
                $model=$session['ReservacionDesglose_records'];
               }
               else
                 $model = ReservacionDesglose::model()->findAll();



		$html = $this->renderPartial('expenseGridtoReport', array(
			'model'=>$model
		), true);
		
		//die($html);
		
		$pdf = new TCPDF();
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor(Yii::app()->name);
		$pdf->SetTitle('ReservacionDesglose Report');
		$pdf->SetSubject('ReservacionDesglose Report');
		//$pdf->SetKeywords('example, text, report');
		$pdf->SetHeaderData('', 0, "Report", '');
		$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, "Example Report by ".Yii::app()->name, "");
		$pdf->setHeaderFont(Array('helvetica', '', 8));
		$pdf->setFooterFont(Array('helvetica', '', 6));
		$pdf->SetMargins(15, 18, 15);
		$pdf->SetHeaderMargin(5);
		$pdf->SetFooterMargin(10);
		$pdf->SetAutoPageBreak(TRUE, 0);
		$pdf->SetFont('dejavusans', '', 7);
		$pdf->AddPage();
		$pdf->writeHTML($html, true, false, true, false, '');
		$pdf->LastPage();
		$pdf->Output("ReservacionDesglose_002.pdf", "I");
	}
}
