<?php

error_reporting(E_ALL & ~E_NOTICE);
class PaquetesGruposController extends Controller
{

	public $layout = '//layouts/ansonika_site';

	/**
	 * @return array action filters
	 */
	/*public function filters()
	{
		return array(
			'accessControl'
			array(
				'ext.starship.RestfullYii.filters.ERestFilter + 
                REST.GET, REST.PUT, REST.POST, REST.DELETE'
			),
		);
	}*/

	public function accessRules()
	{
		return array(
			/*array(
				'allow', 'actions' => array('REST.GET', 'REST.PUT', 'REST.POST', 'REST.DELETE'),
				'users' => array('@'),
			),*/
			array(
				'allow',  // allow all users to perform 'index' and 'view' actions
				'actions' => array('index', 'view', 'getPaquetesGrupos', 'getDeailPaquete', 'detalle', 'allDestinos', 'destino', 'solicitar', 'disponible', 'getPrecompraList', 'getPrecompra', 'info', 'solicitar'),
				'users' => array('*'),
			),
			array(
				'allow',  // allow all users to perform 'index' and 'view' actions
				'actions' => array(''),
				'users' => array('@'),
			),
			array(
				'allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions' => array('create', 'update', 'GeneratePdf', 'GenerateExcel'),
				'users' => array('@'),
			),
			array(
				'allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions' => array('admin', 'delete'),
				'users' => array('admin'),
			),
			array(
				'deny',  // deny all users
				'users' => array('*'),
			),
		);
	}
	/*public function actions()
	{
		return array('REST.' => 'ext.starship.RestfullYii.actions.ERestActionProvider',);
	}*/
	public function actionIndex()
	{
		$this->render('index');
	}
	public function actionAllDestinos()
	{
		$criteria = new CDbCriteria();
		$criteria->addCondition('estatus=1');
		$model_destino = Destinos::model()->findAll($criteria);
		echo CJSON::encode($model_destino);
	}

	public function actionDisponible()
	{

		$this->render('disponibles');
	}

	public function actionSolicitar()
	{
		$model = array();

		if ($_SERVER['REQUEST_METHOD'] === 'POST') {
			$encabezados  = "MIME-Version: 1.0\n";
			$encabezados .= "Content-type: text/html; charset=UTF-8\n";
			$encabezados .= "From:  Ruta Maya Travel <no-reply@rutamayatravel.com>\n";
			// $encabezados .= 'Bcc: soporte@rutamayatravel.com' . "\n";
			// $encabezados .= 'Cc: grupos@rutamayatravel.com' . "\n";
			// $encabezados .= 'Cc: grupos2@rutamayatravel.com' . "\n";
			// $encabezados .= 'Cc: bloqueos@rutamayatravel.com' . "\n";
			$subject = 'SOLICITUD DE PAQUETE DE GRUPOS';

			$nombre_paquete = '';
			if (!empty($_POST['id_paquete'])) {
				$paquete = PaquetesBoda::model()->findByPk($_POST['id_paquete']);

				$nombre_paquete = ' <br> Paquete: ' . $paquete->nombre . '<br> ';
			}
			$mensaje = ' ID: ' . $_POST["id_paquete"] . $nombre_paquete . ' <br> Nombre Hotel: ' . $_POST["nom_hotel"] . ' <br> Correo agencia: ' . $_POST["emai_agencia"] . ' <br> Teléfono agencia: ' . $_POST["tel_agencia"] . ' <br> Estancia: ' . $_POST['fecha_inicial'] . ' <br> Número de Habitaciones: ' . $_POST['num_habitaciones'] . ' <br> Mensaje de la Solicitud: ' . $_POST["mensaje_soli"];
			// mail("grupos1@rutamayatravel.com", $subject, $mensaje, $encabezados);
			mail("programador3@rutamayatravel.com", $subject, $mensaje, $encabezados);
			// mail("grupos@rutamayatravel.com", $subject, $mensaje, $encabezados);
			// mail("grupos2@rutamayatravel.com", $subject, $mensaje, $encabezados);
			// mail("bloqueos@rutamayatravel.com", $subject, $mensaje, $encabezados);

			// mail("willi754698@gmail.com", $subject, $mensaje);
			$model["estatus"] = 1;
			// header('Location: ' . '//www.rutamayatravel.com' . $_POST['url_anterior'] . $_POST['id_paquete']);
			$this->redirect(array("detalle",'id'=>$_POST['id_paquete']));
		} else {
			$model["estatus"] = 0;
		}
		echo CJSON::encode($model);
	}

	public function actionGetPaquetesGrupos($destino = null) {
		header('Access-Control-Allow-Origin: *');
		header("Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept");
		header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE');
		$criteria = new CDbCriteria();


		$criteria->addCondition('visibilidad=1 and tipo_paquete!="Bodas"');
		$criteria->order = 'id_paquete DESC';
		$model_paquetes = PaquetesBoda::model()->findAll($criteria);

		$item = array();
		foreach ($model_paquetes as $key => $data) {
			$model_hotel = Hoteles::model()->with('Destino')->find('id_hotel=' . $data['id_hotel']);
			$model_foto_hotel = HotelesFotos::model()->find("id_hotel=" . $data['id_hotel'] . " and principal = 1");
			$destination_model = Destinations::model()->find("code = '". $model_hotel->Destino->destinationsCode ."'");

			$destination_model = Destinations::model()->find("code = '". $model_hotel->Destino->destinationsCode ."'");
			$model_cadena = CadenaHotel::model()->findByPk($model_hotel->id_cadena);

			$item[$key]["id_paquete"] = $data->id_paquete;
			$item[$key]["nombre_paquete"] = $data->nombre;
			$item[$key]["info_destino"] = $destination_model;
			$item[$key]["precio"] = $data->precio;
			$item[$key]["nom_hotel"] = $model_hotel->nombre_hotel;
			$item[$key]["descripcion_larga"] = $data->info;
			$item[$key]["id_hotel"] = $data->id_hotel;
			$item[$key]["cadena_hotel"] = $model_cadena;
			$item[$key]["foto_principal"] = $model_foto_hotel->foto;
			$item[$key]["descripcion_corta"] = $data->descripcion;
			$item[$key]["moneda"] = $data->moneda;
			$item[$key]["tipo_paquete"] = $data->tipo_paquete;
			if($data->moneda == "USD") {
				$item[$key]["precio"] = $data->precio * $tasa_cambio;
				$item[$key]["precio_original"] = $data->precio;
			}

			/*if ($destino != null) {
				if ($model_hotel->id_destinoLocal == $destino) {
				}
			} else {

				$item[$key]["id_paquete"] = $data->id_paquete;
				$item[$key]["nombre_paquete"] = $data->nombre;
				$item[$key]["info_destino"] = $destination_model;
				$item[$key]["precio"] = $data->precio;
				$item[$key]["nom_hotel"] = $model_hotel->nombre_hotel;
				$item[$key]["descripcion_larga"] = $data->info;
				$item[$key]["id_hotel"] = $data->id_hotel;
				$item[$key]["foto_principal"] = $model_foto_hotel->foto;
				$item[$key]["descripcion_corta"] = $data->descripcion;
				$item[$key]["moneda"] = $data->moneda;
				$item[$key]["tipo_paquete"] = $data->tipo_paquete;
			}*/
		}
		$comparar = 'if (floatval($a[precio]) > floatval($b[precio])) {
					        return 1;
					    }
					    return (floatval($a[precio]) < floatval($b[precio])) ? -1 : 1;';
		usort($item, create_function('$a, $b', $comparar));
		
		echo CJSON::encode($item);
	}
	public function actionGetDeailPaquete($id)
	{
		$model_paquetes = PaquetesBoda::model()->findAll("id_paquete =" . $id);

		$item = array();
		foreach ($model_paquetes as $key => $data) {

			$model_hotel = Hoteles::model()->find('id_hotel=' . $data['id_hotel']);
			$model_foto_hotel = HotelesFotos::model()->findAll('id_hotel=' . $data->id_hotel);
			$model_foto_pricipal = HotelesFotos::model()->find("id_hotel=" . $data['id_hotel'] . " and principal= '1'");
			$item[$key]["id_paquete"] = $data->id_paquete;
			$item[$key]["nombre_paquete"] = $data->nombre;
			$item[$key]["id_destino"] = $model_hotel->id_destinoLocal;
			$item[$key]["precio"] = $data->precio;
			$item[$key]["nom_hotel"] = $model_hotel->nombre_hotel;
			$item[$key]["descripcion_larga"] = $data->info;
			$item[$key]["id_hotel"] = $data->id_hotel;
			$item[$key]["fotos"] = $model_foto_hotel;
			$item[$key]["foto_principal"] = $model_foto_pricipal['foto'];
			$item[$key]["descripcion_corta"] = $data->descripcion;
			$item[$key]["moneda"] = $data->moneda;
		}

		echo CJSON::encode($item);
	}
	public function actionDetalle()
	{
		$usuario = Usuarios::model()->findByPk(Yii::app()->user->id);
		$model_agencia = Agencias::model()->findByPk($usuario->id_agencia);

		$this->render('detallepaquete', array("model_agencia" => $model_agencia));
	}
	public function actionGetPaqueteGrupo($id)
	{
	}

	public function actionGeneratePdf($id)
	{
		$session = new CHttpSession;
		$session->open();

		$header = '<table><tr><td><img src="' . $_SERVER['DOCUMENT_ROOT'] . Yii::app()->request->baseUrl . '/images/pakal.jpg"></td></tr></table>';
		$footer = '';

		$mPDF1 = Yii::app()->ePdf->mpdf();
		// exit;
		$mPDF1->SetHTMLHeader($header);
		$mPDF1->SetHTMLFooter($footer);

		$model = PaquetesBoda::model()->findByPk($id);

		$agencia = Agencias::model()->findByPk($_SESSION['agenciaUsuario']);

		if ($agencia->foto != '') {
			$logo_agencia = $_SERVER['DOCUMENT_ROOT'] . "/imagenes/" . $agencia->foto;
		} else {
			$logo_agencia = $_SERVER['DOCUMENT_ROOT'] . "/reservaciones/images/sinlogo.png";
		}

		$html = $this->renderPartial('GridReportPDFGrupos', array(
			'model' => $model,
			'logo_agencia' => $logo_agencia

		), true);

		//die($html);

		$mPDF1->WriteHTML($html);
		// $mPDF1->AddPage();

		// $mPDF1->SetWatermarkText('ORIGINAL');
		// $mPDF1->showWatermarkText = true;

		// $mPDF1->WriteHTML($html);
		$mPDF1->Output();
	}
}
