<?php
header('Access-Control-Allow-Origin: *');
header("Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept");
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE');
class PaquetesCasateConmigoController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout = '//layouts/ansonika_site';
	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}
	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array(
				'allow',  // allow all users to perform 'index' and 'view' actions
				'actions' => array('index', 'first', 'getCadenasWithWeddings', 'getDestinationsWithWeddings', 'getPaquetesBoda'),
				'users' => array('*'),
			),
			array(
				'allow',  // allow all users to perform 'index' and 'view' actions
				'actions' => array('echo'),
				'users' => array('@'),
			),
			array(
				'deny',  // deny all users
				'users' => array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionIndex()
	{
		$this->render('index', array());
	}

	public function actionEcho()
	{
		echo 'http://' . $_SERVER["SERVER_NAME"] . Yii::app()->request->baseUrl . '/getTarifas/ObtenerTarifas';
	}

	public function actionGetCadenasWithWeddings()
	{
		//$query = "SELECT * FROM tbl_cadena_hotel CH WHERE CH.id IN (SELECT H.id_cadena FROM tbl_hoteles H WHERE H.id_hotel IN (SELECT PB.id_hotel FROM tbl_paquetes_boda PB WHERE CURDATE() < PB.fecha_vigencia AND PB.tipo_paquete = 'Bodas')) ORDER BY CH.id DESC;";
		$query = "SELECT * FROM tbl_cadena_hotel CH WHERE CH.id IN (SELECT H.id_cadena FROM tbl_hoteles H WHERE H.id_hotel IN (SELECT PH.id_hotel FROM tbl_paquete_hotel PH INNER JOIN tbl_paquetes_boda PB ON PB.id_paquete = PH.id_paquete_hotel WHERE PH.estatus = 1 AND CURDATE() < PB.fecha_vigencia AND PH.id_hotel != 177832)) ORDER BY CH.id DESC;";
		$model_cadenas = Yii::app()->db->createCommand($query)->queryAll();
		echo CJSON::encode($model_cadenas);
	}

	public function actionGetDestinationsWithWeddings()
	{
		//$query = "SELECT * FROM destinations D WHERE D.code IN (SELECT Z.destinationsCode FROM zonasbeds Z WHERE Z.idZona IN (SELECT H.id_destino FROM tbl_hoteles H WHERE H.id_hotel IN (SELECT PB.id_hotel FROM tbl_paquetes_boda PB WHERE CURDATE() < PB.fecha_vigencia AND PB.tipo_paquete = 'Bodas')));";
		$query = "SELECT * FROM destinations D WHERE D.code IN (SELECT Z.destinationsCode FROM zonasbeds Z WHERE Z.idZona IN (SELECT H.id_destino FROM tbl_hoteles H WHERE H.id_hotel IN (SELECT PH.id_hotel FROM tbl_paquete_hotel PH INNER JOIN tbl_paquetes_boda PB ON PB.id_paquete = PH.id_paquete_hotel WHERE PH.estatus = 1 AND CURDATE() < PB.fecha_vigencia AND PH.id_hotel != 177832)));";
		$model_cadenas = Yii::app()->db->createCommand($query)->queryAll();
		echo CJSON::encode($model_cadenas);
	}

	public function actionGetPaquetesBoda($type = null, $id = null)
	{
		header('Content-Type: application/json');
		if ($type == null)
			//$query = "SELECT * FROM tbl_hoteles H WHERE H.id_hotel IN (SELECT PB.id_hotel FROM tbl_paquetes_boda PB WHERE CURDATE() < PB.fecha_vigencia AND PB.tipo_paquete = 'Bodas');";
			$query = "SELECT * FROM tbl_hoteles H WHERE H.id_hotel IN (SELECT PH.id_hotel FROM tbl_paquete_hotel PH INNER JOIN tbl_paquetes_boda PB ON PB.id_paquete = PH.id_paquete_hotel WHERE PH.estatus = 1 AND CURDATE() < PB.fecha_vigencia AND PH.id_hotel != 177832);";
		else if ($type == "d")
			//$query = "SELECT * FROM tbl_hoteles H WHERE H.id_hotel IN (SELECT PB.id_hotel FROM tbl_paquetes_boda PB WHERE CURDATE() < PB.fecha_vigencia AND PB.tipo_paquete = 'Bodas') AND H.id_destino IN (SELECT ZB.idZona FROM zonasbeds ZB WHERE ZB.destinationsCode = '". $id ."');";
			$query = "SELECT * FROM tbl_hoteles H WHERE H.id_hotel IN (SELECT PH.id_hotel FROM tbl_paquete_hotel PH INNER JOIN tbl_paquetes_boda PB ON PB.id_paquete = PH.id_paquete_hotel WHERE PH.estatus = 1 AND CURDATE() < PB.fecha_vigencia AND PH.id_hotel != 177832) AND H.id_destino IN (SELECT ZB.idZona FROM zonasbeds ZB WHERE ZB.destinationsCode = '" . $id . "');";
		else if ($type == "c")
			//$query = "SELECT * FROM tbl_hoteles H WHERE H.id_hotel IN (SELECT PB.id_hotel FROM tbl_paquetes_boda PB WHERE CURDATE() < PB.fecha_vigencia AND PB.tipo_paquete = 'Bodas') AND H.id_cadena = ". $id .";";
			$query = "SELECT * FROM tbl_hoteles H WHERE H.id_hotel IN (SELECT PH.id_hotel FROM tbl_paquete_hotel PH INNER JOIN tbl_paquetes_boda PB ON PB.id_paquete = PH.id_paquete_hotel WHERE PH.estatus = 1 AND CURDATE() < PB.fecha_vigencia AND PH.id_hotel != 177832) AND H.id_cadena = " . $id . ";";
		else if ($type == "h")
			//$query = "SELECT * FROM tbl_hoteles H WHERE H.id_hotel IN (SELECT PB.id_hotel FROM tbl_paquetes_boda PB WHERE CURDATE() < PB.fecha_vigencia AND PB.tipo_paquete = 'Bodas') AND H.id_hotel = ". $id .";";
			$query = "SELECT * FROM tbl_hoteles H WHERE H.id_hotel IN (SELECT PH.id_hotel FROM tbl_paquete_hotel PH INNER JOIN tbl_paquetes_boda PB ON PB.id_paquete = PH.id_paquete_hotel WHERE PH.estatus = 1 AND CURDATE() < PB.fecha_vigencia AND PH.id_hotel != 177832) AND H.id_hotel = " . $id . ";";

		$model_hoteles = Yii::app()->db->createCommand($query)->queryAll();
		foreach ($model_hoteles as $key => $hotel) {
			$criteria = new CDbCriteria();
			$criteria->addCondition("visibilidad = 1 AND tipo_paquete = 'Bodas' AND id_hotel = " . $hotel["id_hotel"] . " AND CURDATE() < fecha_vigencia");
			$criteria->order = "id_paquete DESC";

			$model_hoteles[$key]["paquetes_boda"] = PaquetesBoda::model()->findAll($criteria);

			/*$model_hoteles[$key]["fotos"]["logo"] = HotelesFotos::model()->findAll("id_hotel = ". $hotel["id_hotel"]);
			$model_hoteles[$key]["fotos"]["all"] = HotelesFotos::model()->findAll("id_hotel = ". $hotel["id_hotel"] ." AND logotipo = 0");*/

			$model_hf = HotelesFotos::model()->findAll("id_hotel = " . $hotel["id_hotel"]);
			$model_hoteles[$key]["fotos"]["boda"] = array();
			$model_hoteles[$key]["fotos"]["all"] = array();
			foreach ($model_hf as $key_hf => $value_hf) {
				if ($value_hf->logotipo == "1")
					$model_hoteles[$key]["fotos"]["logo"] = $value_hf;
				else if ($value_hf->logotipo == "0" && $value_hf->boda == "1")
					array_push($model_hoteles[$key]["fotos"]["boda"], $value_hf);
				else
					array_push($model_hoteles[$key]["fotos"]["all"], $value_hf);
			}

			if ($type == "h") $model_hoteles[$key]["videos"] = HotelesVideos::model()->findAll("id_hotel = " . $hotel["id_hotel"] . " AND tipo_video = 'BODA'");

			$model_hoteles[$key]["info_categoria"] = Categorias::model()->find("id_categoria = " . $hotel["id_categoria"]);
			if ($hotel["id_cadena"] != "" || $hotel["id_cadena"] != null) $model_hoteles[$key]["info_cadena"] = CadenaHotel::model()->find("id = " . $hotel["id_cadena"]);

			$zonas_model = Zonasbeds::model()->find("idZona = '" . $hotel["id_destino"] . "'");
			$model_hoteles[$key]["info_destino"] = Destinations::model()->find("code = '" . $zonas_model->destinationsCode . "'");
			$model_hoteles[$key]["fotos_hotel"] = HotelesFotos::model()->findAll("id_hotel = " . $hotel["id_hotel"]);
		}
		echo CJSON::encode($model_hoteles);
	}

	public function actionFirst()
	{
		$this->render('first');
	}
}
