<?php

class PaquetesBodaController extends Controller
{

	public $layout = '//layouts/ansonika_site';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
			array(
				'ext.starship.RestfullYii.filters.ERestFilter + 
                REST.GET, REST.PUT, REST.POST, REST.DELETE'
			),
		);
	}

	public function accessRules()
	{
		return array(
			array(
				'allow', 'actions' => array('REST.GET', 'REST.PUT', 'REST.POST', 'REST.DELETE'),
				'users' => array('@'),
			),
			array(
				'allow',  // allow all users to perform 'index' and 'view' actions
				'actions' => array('index', 'view', 'getPaquetesBoda', 'getDeailPaquete', 'detalle', 'allDestinos', 'destino', 'solicitar', 'disponible', 'getPrecompraList', 'getPrecompra', 'info', 'test2', 'addHoteles'),
				'users' => array('*'),
			),
			array(
				'allow',  // allow all users to perform 'index' and 'view' actions
				'actions' => array(''),
				'users' => array('@'),
			),
			array(
				'allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions' => array('create', 'update', 'GeneratePdf', 'GenerateExcel'),
				'users' => array('@'),
			),
			array(
				'allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions' => array('admin', 'delete'),
				'users' => array('admin'),
			),
			array(
				'deny',  // deny all users
				'users' => array('*'),
			),
		);
	}
	public function actions()
	{
		return array('REST.' => 'ext.starship.RestfullYii.actions.ERestActionProvider',);
	}
	public function actionIndex()
	{
		$this->render('index');
	}
	public function actionAllDestinos()
	{
		$criteria = new CDbCriteria();
		$criteria->addCondition('estatus=1');
		$model_destino = Destinos::model()->findAll($criteria);
		echo CJSON::encode($model_destino);
	}
	public function actionSolicitar()
	{
		$model = array();

		if ($_SERVER['REQUEST_METHOD'] === 'POST') {
			$encabezados  = "MIME-Version: 1.0\n";
			$encabezados .= "Content-type: text/html; charset=UTF-8\n";
			$encabezados .= "From: Ruta Maya Travel <no-reply@rutamayatravel.com>\n";
			// $encabezados .= 'Bcc: soporte@rutamayatravel.com' . "\n";
			// $encabezados .= 'Cc: bodas2@rutamayatravel.com' . "\n";
			// $encabezados .= 'Cc: bodas@rutamayatravel.com' . "\n";
			$subject = 'SOLICITUD DE PAQUETE DE BODAS';

			$nombre_paquete = '';
			if (!empty($_POST['id_paquete'])) {
				$paquete = PaquetesBoda::model()->findByPk($_POST['id_paquete']);

				$nombre_paquete = ' <br> Paquete: ' . $paquete->nombre . '<br> ';
			}

			$mensaje = ' ID: ' . $_POST["id_paquete"] . $nombre_paquete . ' <br> Nombre Hotel: ' . $_POST["nom_hotel"] . ' <br> Correo agencia: ' . $_POST["emai_agencia"] . ' <br> Teléfono agencia: ' . $_POST["tel_agencia"] . ' <br> Mensaje de la Solicitud: ' . $_POST["mensaje_soli"];
			// mail("bodas1@rutamayatravel.com", $subject, $mensaje, $encabezados);
			mail("programador3@rutamayatravel.com", $subject, $mensaje, $encabezados);
			$this->redirect(array("detalle",'id'=>$_POST['id_paquete']));

			$model["estatus"] = 1;
			// header('Location: '.'//www.rutamayatravel.com' . $_POST['url_anterior'] . $_POST['id_paquete']);
		} else {
			$model["estatus"] = 0;
		}
		echo CJSON::encode($model);
	}
	public function actionAddHoteles()
	{
	}
	public function actionDisponible()
	{

		$this->render('disponibles');
	}
	public function actionGetPrecompraList()
	{
		$criteria = new CDbCriteria();
		$criteria->with = 'idTarifa';
		$criteria->addCondition('t.estatus = 1');
		$criteria->addCondition("t.id_agencia is NULL");
		$criteria->addCondition("t.tipo = 'BLOQUEO'");
		$criteria->addCondition("t.fecha_inicio >= current_date");
		$criteria->addCondition("idTarifa.precio = 'BODA'");
		$model_precomprada = Bloqueos::model()->findAll($criteria);
		$array_aux_bloqueo = array();
		foreach ($model_precomprada as $key => $precompra) {
			$model_tarifa = Tarifa::model()->findAll("id_tarifa=" . $precompra->id_tarifa . " and precio = 'BODA'");
			$model_foto_principal = HotelesFotos::model()->find('id_hotel=' . $precompra->id_hotel . ' and boda=1');
			$model_foto_logo = HotelesFotos::model()->find('id_hotel=' . $precompra->id_hotel . ' and logotipo=1');
			$model_hotel = Hoteles::model()->find('id_hotel=' . $precompra->id_hotel);
			$model_plan = TipoPlan::model()->find('id_tipo_plan=' . $precompra->id_tipo_plan);
			$model_tipo_habitaciones = TipoHabitaciones::model()->find('id_tipo_habitacion=' . $precompra->id_tipo_habitacion);
			$model_paquetes_boda = PaquetesBoda::model()->findByPk($precompra->id_paquete);
			$model_tarifa_desglose = TarifaDesglose::model()->find("id_base_habitacion=2 and id_tarifa= " . $precompra->id_tarifa);
			$array_aux_bloqueo[$key]["id_bloqueo"] = $precompra->id_bloqueo;
			$array_aux_bloqueo[$key]["id_tarifa"] = $precompra->id_tarifa;
			$array_aux_bloqueo[$key]["id_hotel"] = $precompra->id_hotel;
			$array_aux_bloqueo[$key]["id_cadena_hotel"] = $model_hotel->id_cadena;
			$array_aux_bloqueo[$key]["cadena_hotel"] = CadenaHotel::model()->findByPk($model_hotel->id_cadena)->nombre;
			$array_aux_bloqueo[$key]["tipo"] = $precompra->tipo;
			$array_aux_bloqueo[$key]["logotipo"] = $model_foto_logo->foto;
			$array_aux_bloqueo[$key]["foto_principal"] = $model_foto_principal->foto;
			$array_aux_bloqueo[$key]["hotel_nombre"] = $model_hotel->nombre_hotel;
			$array_aux_bloqueo[$key]["precio_doble"] = $model_tarifa_desglose->precio_normal;
			$array_aux_bloqueo[$key]["tipo_habitacion"] = $model_tipo_habitaciones->tipo_habitacion;
			$array_aux_bloqueo[$key]["fecha_inicio"] = $precompra->fecha_inicio;
			$array_aux_bloqueo[$key]["fecha_final"] = $precompra->fecha_final;
			$array_aux_bloqueo[$key]["estatus"] = $precompra->estatus;
			$array_aux_bloqueo[$key]["moneda"] = $precompra->idTarifa->moneda;
			$array_aux_bloqueo[$key]["tipo_plan"] = $model_plan->nombre;
			$array_aux_bloqueo[$key]["titulo_bloqueo"] = $precompra->titulo;
			$array_aux_bloqueo[$key]["visibilidad"] = $precompra->visibilidad;
			$array_aux_bloqueo[$key]["precio_neto"] = $model_tarifa_desglose->precio_neto;
			$array_aux_bloqueo[$key]["numero_habitaciones"] = $precompra->numero_habitaciones;
			$array_aux_bloqueo[$key]["nombre_paquete"] = $model_paquetes_boda->nombre;
		}

		$comparar = 'if ($a[precio_doble] > $b[precio_doble]) {
					        return 1;
					    }
					    return ($a[precio_doble] < $b[precio_doble]) ? -1 : 1;';
		usort($array_aux_bloqueo, create_function('$a, $b', $comparar));
		echo CJSON::encode($array_aux_bloqueo);
	}
	public function actionGetPaquetesBoda($destino = null)
	{
		header('Access-Control-Allow-Origin: *');
		header("Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept");
		header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE');
		$criteria = new CDbCriteria();

		$criteria->addCondition('visibilidad=1 AND tipo_paquete="Bodas"');
		$criteria->order = 'id_paquete DESC';
		$model_paquetes = PaquetesBoda::model()->findAll($criteria);

		$item = array();
		foreach ($model_paquetes as $key => $data) {
			$model_hotel = Hoteles::model()->with('Destino')->find('id_hotel=' . $data['id_hotel']);
			$model_foto_hotel = HotelesFotos::model()->find('id_hotel=' . $data['id_hotel'] . ' and boda = 1');
			$destination_model = Destinations::model()->find("code = '" . $model_hotel->Destino->destinationsCode . "'");

			if ($destino != null) {
				if ($model_hotel->id_destinoLocal == $destino) {
					$item[$key]["id_paquete"] = $data->id_paquete;
					$item[$key]["nombre_paquete"] = $data->nombre;
					$item[$key]["info_destino"] = $destination_model;
					$item[$key]["precio"] = $data->precio;
					$item[$key]["nom_hotel"] = $model_hotel->nombre_hotel;
					$item[$key]["descripcion_larga"] = $data->info;
					$item[$key]["id_hotel"] = $data->id_hotel;
					$item[$key]["foto_principal"] = $model_foto_hotel->foto;
					$item[$key]["descripcion_corta"] = $data->descripcion;
					$item[$key]["moneda"] = $data->moneda;
				}
			} else {

				$item[$key]["id_paquete"] = $data->id_paquete;
				$item[$key]["nombre_paquete"] = $data->nombre;
				$item[$key]["info_destino"] = $destination_model;
				$item[$key]["precio"] = $data->precio;
				$item[$key]["nom_hotel"] = $model_hotel->nombre_hotel;
				$item[$key]["descripcion_larga"] = $data->info;
				$item[$key]["id_hotel"] = $data->id_hotel;
				$item[$key]["foto_principal"] = $model_foto_hotel->foto;
				$item[$key]["descripcion_corta"] = $data->descripcion;
				$item[$key]["moneda"] = $data->moneda;
			}
		}
		echo CJSON::encode($item);
	}
	public function actionGetDeailPaquete($id)
	{
		$model_paquetes = PaquetesBoda::model()->findAll("id_paquete =" . $id);

		$item = array();
		foreach ($model_paquetes as $key => $data) {
			$model_hotel = Hoteles::model()->find('id_hotel=' . $data['id_hotel']);
			$model_foto_hotel = HotelesFotos::model()->findAll('id_hotel=' . $data['id_hotel'] . ' and boda = 1');
			$model_foto_pricipal = HotelesFotos::model()->find('id_hotel=' . $data['id_hotel'] . ' and boda = 1');
			$item[$key]["id_paquete"] = $data->id_paquete;
			$item[$key]["nombre_paquete"] = $data->nombre;
			$item[$key]["id_destino"] = $model_hotel->id_destinoLocal;
			$item[$key]["precio"] = $data->precio;
			$item[$key]["nom_hotel"] = $model_hotel->nombre_hotel;
			$item[$key]["descripcion_larga"] = $data->info;
			$item[$key]["id_hotel"] = $data->id_hotel;
			$item[$key]["fotos"] = $model_foto_hotel;
			$item[$key]["foto_principal"] = $model_foto_pricipal->foto;
			$item[$key]["descripcion_corta"] = $data->descripcion;
			$item[$key]["moneda"] = $data->moneda;
		}

		echo CJSON::encode($item);
	}
	public function actionDetalle()
	{
		$usuario = Usuarios::model()->findByPk(Yii::app()->user->id);
		$model_agencia = Agencias::model()->findByPk($usuario->id_agencia);
		$this->render('detallepaquete', array("model_agencia" => $model_agencia));
	}
	public function actionGetPrecompra($id)
	{
		$array_bloqueo = array();
		$model = Bloqueos::model()->findByPk($id);
		$array_bloqueo["info_bloqueo"] = $model;
		$model_hotel = Hoteles::model()->find('id_hotel=' . $array_bloqueo["info_bloqueo"]->id_hotel);
		$model_destino = Destinos::model()->findByPk($model_hotel->id_destinoLocal);
		$array_bloqueo["info_adicional"]["nombre_hotel"] = $model_hotel->nombre_hotel;
		$array_bloqueo["info_adicional"]["descripcion_hotel"] = $model_hotel->observaciones;
		$array_bloqueo["info_adicional"]["tipo_habitacion"] = TipoHabitaciones::model()->findByPk($array_bloqueo["info_bloqueo"]->id_tipo_habitacion)->descripcion;
		$array_bloqueo["info_adicional"]["plan"] = Plan::model()->findByPk($array_bloqueo["info_bloqueo"]->id_tipo_plan)->nombre;
		$array_bloqueo["info_adicional"]["destino_hotel"] = $model_destino->destino;
		$array_bloqueo["info_adicional"]["fotos"] = HotelesFotos::model()->findAll("id_hotel = " . $array_bloqueo["info_bloqueo"]->id_hotel . " and boda = 1");
		$array_bloqueo["info_adicional"]["foto_principal"] = HotelesFotos::model()->findAll("id_hotel = " . $array_bloqueo["info_bloqueo"]->id_hotel . ' and boda=1');
		$array_bloqueo["info_adicional"]["videos_hotel"] = HotelesVideos::model()->findAll("id_hotel = " . $array_bloqueo["info_bloqueo"]->id_hotel . ' and estatus=1');
		$array_bloqueo["tarifa_desglose"] = TarifaDesglose::model()->findAll("id_tarifa = " . $array_bloqueo["info_bloqueo"]->id_tarifa . ' and id_tipo_habitacion=' . $array_bloqueo["info_bloqueo"]->id_tipo_habitacion);
		$array_bloqueo["desgloseMenores"] = DesgloseMenores::model()->findAll("id_tarifa = " . $array_bloqueo["info_bloqueo"]->id_tarifa . ' and id_tipo_habitacion=' . $array_bloqueo["info_bloqueo"]->id_tipo_habitacion);
		if ($model->id_paquete) {
			$array_bloqueo["paquete"] = PaquetesBoda::model()->findByPk($model->id_paquete);
		}
		echo CJSON::encode($array_bloqueo);
	}
	public function actionInfo($id)
	{
		$this->render('view');
	}

	public function actionGeneratePdf($id)
	{
		$session = new CHttpSession;
		$session->open();

		$header = '<table><tr><td><img src="' . $_SERVER['DOCUMENT_ROOT'] . Yii::app()->request->baseUrl . '/images/pakal.jpg"></td></tr></table>';
		$footer = '';

		$mPDF1 = Yii::app()->ePdf->mpdf();
		$mPDF1->SetHTMLHeader($header);
		$mPDF1->SetHTMLFooter($footer);

		$model = PaquetesBoda::model()->findByPk($id);

		$agencia = Agencias::model()->findByPk($_SESSION['agenciaUsuario']);

		if ($agencia->foto != '') {
			$logo_agencia = $_SERVER['DOCUMENT_ROOT'] . "/imagenes/" . $agencia->foto;
		} else {
			$logo_agencia = $_SERVER['DOCUMENT_ROOT'] . "/reservaciones/images/sinlogo.png";
		}

		$html = $this->renderPartial('GridReportPDFBodas', array(
			'model' => $model,
			'logo_agencia' => $logo_agencia

		), true);

		//die($html);

		$mPDF1->WriteHTML($html);
		// $mPDF1->AddPage();

		// $mPDF1->SetWatermarkText('ORIGINAL');
		// $mPDF1->showWatermarkText = true;

		// $mPDF1->WriteHTML($html);
		$mPDF1->Output();
	}

	public function actionTest2()
	{
		$this->render('prueba2');
	}
}
