<?php
class PagosController extends Controller
{
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}
	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		$rules = AuthFuncion::model()->findAll('controlador="'.Yii::app()->controller->id.'"');
		$array = array();
		foreach($rules as $row){
			$rule = array('allow',
						'actions'=>array($row->funcion),
						'roles'=>array($row->operacion),
					);
			array_push($array,$rule);
		}
		array_push($array,
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','Revisar'),
				'roles'=>array('revisarRecibos'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('Aplicar','pagarFam'),
				'roles'=>array('finanzas','admin','Soporte'),
			),
			array('allow',
				'actions'=>array('Comisionbancaria'),
				'users'=>array('@'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			)
		);
		return $array;
	}
	/**
	 * This is the default 'index' action that is invoked
	 * when an action is not explicitly requested by users.
	 */
	public function actionIndex()
	{
		$modelComision = new Reservacion; // nueva comision
		$modelRecibo = new Recibo;
		$cuentas = Reservacion::model()->findAll('estatus !="C" and libera_cupon=1 and saldo>0 and fecha_limite >"2017-12-31" ');
		$this->render('index', array("cuentas"=>$cuentas,"modelRecibo"=>$modelRecibo,"modelComision"=>$modelComision));
	}



	public function actionCuentasxpagar()
	{
		$idAgencia=$_POST["idAgencia"];
        if(isset($_POST["idAgencia"]))
		{
            $modelCuentas=$this->reservacionesnopagadas($idAgencia);                    			
            $filas=count($modelCuentas);       
			$cat=Yii::app()->createController('Agencias');//returns array containing controller instance and action index.
			$cat=$cat[0]; //get the controller instance.
			$modelAgencia=$cat->loadModel($idAgencia); //use a public method.
			$modelRecibo = new Recibo; //nuevo recibo
		}
		$this->renderPartial('cuentasxpagar',array("idAgencia"=>$idAgencia,'modelCuentas'=>$modelCuentas,'filas'=>$filas,'modelAgencia'=>$modelAgencia,"modelRecibo"=>$modelRecibo));
	}
	public function actionComisionbancaria()
	{
		if($_POST['cuenta'] != "" && $_POST['plan'] != "")
		{
			if($_POST["id_tipo"]!=9){
			$model=Comision::model()->find("id_cuenta=".$_POST['cuenta']." AND id_planpago=".$_POST['plan']);				
			echo $model->comision;
			}
			else{
			echo 2.9;
			}
		}
		if($_POST["id_tipo"]!=9 && $_POST['plan'] == ""){
				echo 2.9;
		}
	}
	public function actionCambiarcomision()
	{		
		if(isset($_POST['comision']) && isset($_POST['cuponc']))
		{
			$clave = Yii::app()->createController('reservacion');
			$clave = $clave[0];
			$autorizacion = $clave->verificaClave($_POST['clave']);
			if(!empty($autorizacion))
			{
				$cupones = explode(',',$_POST['cuponc']);
				
				$tipo="";
				
				foreach($cupones as $cupon)
				{

					$model=Reservacion::model()->findByPk($cupon);
					if ($_POST['tipo']=="tour") {
						$model=TourReservacion::model()->findByPk($cupon);
						$tipo=' and tipo="Tour"';
					}
					$pagos = ReciboDetalles::model()->findAll('id_reservacion='.$cupon.$tipo);
					$count = 0;
					$importe = 0;

					if($_POST['tipo']=="tour")
						$idRes=$model->id_tourReservacion;							
					else
						$idRes=$model->id_reservacion;

					foreach($pagos as $row)
					{
						$recibo = Recibo::model()->findByPk($row->id_recibo);
						if($recibo->estado != 'C')
						{
							$count+= 1;
							$importe+= $row->importe;
						}
					}
					if(!empty($model->tipo_cambio)){
						$total_cambio = round($model->total_tc * $model->tipo_cambio,2);
						$saldo_nuevo = $total_cambio - ($total_cambio*($_POST['comision']/100));
					}else{
						if($_POST['tipo']=="tour")
							$saldo_nuevo = $model->importe - ($model->importe*($_POST['comision']/100));
						else
							$saldo_nuevo = $model->total - ($model->total*($_POST['comision']/100));
					}
					$model->comision = $_POST['comision'];
					$model->saldo = round($saldo_nuevo - $importe,2);
					if($model->save()){
						$mensaje = 'Se modificó la comisión de la reserva correctamente.';
						$operacion = Yii::app()->createController('operacionesLog');
						$operacion = $operacion[0];
						$operacion->Create($idRes,25);
					}else{
						$mensaje = 'Error al modificar la comisión de la reservación #'.$idRes.' !';
						break;
					}
				}
			}
			else{
				$mensaje = 'La clave introducida no existe! Por favor intente de nuevo.';
			}
			$this->renderPartial('msgcomision',array("mensaje"=>$mensaje));
		}
	}
	public function actionCargarnotas()
	{
		$radio=false;
		$famtrip=false;
		if($_POST['id_agencia'] == 0)
		{
			$model = NotaCredito::model()->findAll('estatus="A"');

		}else{
			if(!empty($_POST['bloqueo'])){
				$tipo_ref = " and tipo_ref NOT IN('BLOQUEO')";
				$radio = true;
			}
			$model = NotaCredito::model()->findAll('id_agencia='.$_POST['id_agencia'].' '.$tipo_ref.' and estatus="A"');
		}
		if ($_POST['famtrip']) {
			$famtrip=true;
			$radio=true;
		}
		$this->renderPartial('notascredito',array('model'=>$model,'radio'=>$radio, 'famtrip'=>$famtrip));
	}
	public function actionPagarFam()
	{
		$model=new Recibo;
		$detalle = new ReciboDetalles;
		$notacredito = array(); $n=1;
		if(isset($_POST['Recibo']))
		{
			
				//Pago de solo 1 cupon
				$model->attributes=$_POST['Recibo'];
				$model->id_user = Yii::app()->user->id;
				$detalle->importe = $model->importe;
				$model->importe = $_POST['total'];
				if($model->id_tipo == 11){
					$notasaplicadas = $this->Aplicarnotacredito();
					$model->observaciones = "<br>".$notasaplicadas;
				}
				if($model->save())
				{
					$detalle->id_recibo = $model->id_recibo;
					$detalle->tipo=$_POST["tipo"];
					$detalle->id_reservacion = $_POST['id_event_guest'];
					
					$invitado=EventsGuests::model()->findByPk($_POST['id_event_guest']);			
					if($_POST['saldores'] <= -0.05){
						$concepto = "Cambio por pago de Famtrip:".$invitado->idEvent->nombre_evento.'" Agencia: '.$invitado->idInvitado->nombre_agencia.', Contacto:'.$invitado->idInvitado->contacto;
						$notacredito[1] = $this->Crearnotacredito($cupon->saldo,$model,$concepto);
						$detalle->importe = $saldo;
						$cupon->saldo = 0;
					}

					$invitado=EventsGuests::model()->findByPk($_POST['id_event_guest']);
					$invitado->pagado=1;
					if($detalle->importe < $invitado->idEvent->importe)
					{
						$detalle->concepto='Pago Parcial ';
					}
					else if($_POST['saldores']==0)
					{
						$detalle->concepto='Pago Total ';
					}
					else{
						$detalle->concepto='Saldo ';
					}
					$detalle->concepto.= 'Famtrip: "'.$invitado->idEvent->nombre_evento.'" Agencia: '.$invitado->idInvitado->nombre_agencia.', Contacto:'.$invitado->idInvitado->contacto;	
					$detalle->save();
					$invitado->save();
					$this->renderPartial('listo',array('idrecibo'=>$model->id_recibo,'notacredito'=>$notacredito));
				
				}	
			}else
			throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');
		
	}
	public function actionPagarcuenta()
	{
		$model=new Recibo;
		$detalle = new ReciboDetalles;
		$notacredito = array(); $n=1;
/*		$_POST['Recibo']
		$_POST['cupon']
		$_POST['total']
		$_POST['comision']
		$_POST['saldores']
*/
		if(isset($_POST['Recibo']))
		{
			$cupones=explode(',',$_POST['cupon']);
			if(count($cupones) > 1)
			{
				$model->attributes=$_POST['Recibo'];
				$model->id_user = Yii::app()->user->id;
				$importeDividido = $model->importe / count($cupones);
				$model->importe = $_POST['total'];
				if($model->id_tipo == 11){
					$notasaplicadas = $this->Aplicarnotacredito();
					$model->observaciones = "<br>".$notasaplicadas;
				}
				$concepto = "Cambio por pago de Reservacion";
				$saldoAcumulado = 0;
				if($model->save())
				{
					for($i=0;$i<count($cupones);$i++)
					{
						$detalle = new ReciboDetalles;
						$detalle->id_recibo = $model->id_recibo;
						$detalle->id_reservacion = $cupones[$i];
						$cupon = Reservacion::model()->findByPk($cupones[$i]);
						if($_POST['pagar_todo'] == true || !empty($_POST['comision']))
						{
							$detalle->importe = empty($_POST['comision']) ? $cupon->saldo:$cupon->total;
							$saldo = empty($_POST['comision']) ? $cupon->saldo:$cupon->total;
							$cupon->saldo = 0;
							$concepto .= " #".$cupon->id_reservacion;
						}
						else
						{
							$detalle->importe = $importeDividido;
							$saldo = $cupon->saldo;
							$cupon->saldo = $cupon->saldo - $importeDividido;
							if($cupon->saldo < 0){
								$concepto .= " #".$cupon->id_reservacion;
								$saldoAcumulado += $cupon->saldo;
								$detalle->importe = $saldo;
								$cupon->saldo = 0;
							}
						}
						$hotel=Hoteles::model()->find('id_hotel='.$cupon->id_hotel);
						if($detalle->importe < $cupon->total && $cupon->saldo > 0)
						{
							$detalle->concepto='Pago Parcial ';
						}
						else if($detalle->importe == $saldo)
						{
							$detalle->concepto='Pago Total ';
						}
						else{
							$detalle->concepto='Saldo ';
						}

						$detalle->concepto.= 'Reserva #'.$cupon->id_reservacion.' Pax: '.$cupon->nombre_cliente.' - Hotel: '.$hotel->nombre_hotel.' - '.$cupon->num_habitaciones.' Hab.';

						
						$cupon->save();
						$detalle->save();
						if(!empty($_POST['comision'])){
							$comisionAgencia = $cupon->total * ($cupon->comision/100);
							$this->Crearcomisionagencia($cupon->id_reservacion,$comisionAgencia);
						}
					}
					if($saldoAcumulado <= -0.05)$notacredito[$n] = $this->Crearnotacredito($saldoAcumulado,$model,$concepto);
					if($_POST['pagar_todo'] == true && $_POST['saldores'] <= -0.05)$notacredito[$n] = $this->Crearnotacredito($_POST['saldores'],$model,$concepto);
					$this->renderPartial('listo',array('idrecibo'=>$model->id_recibo,'notacredito'=>$notacredito));
				}
				else
					throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');
			}
			else
			{
				//Pago de solo 1 cupon
				$model->attributes=$_POST['Recibo'];
				$model->id_user = Yii::app()->user->id;
				$detalle->importe = $model->importe;
				$model->importe = $_POST['total'];
				if($model->id_tipo == 11){
					$notasaplicadas = $this->Aplicarnotacredito();
					$model->observaciones = "<br>".$notasaplicadas;
				}
				if($model->save())
				{
					$detalle->id_recibo = $model->id_recibo;
					if($_POST['ordenserv'] == true)
					{
						$detalle->id_venta = $_POST['cupon'];
						$cupon = Venta::model()->findByPk($_POST['cupon']);
						$saldo = $cupon->saldo;
						$cupon->saldo = $_POST['saldores'];
						if($cupon->saldo <= -0.05){
							$concepto = "Cambio por pago de Orden de Servicio #".$cupon->id_venta;
							$notacredito[1] = $this->Crearnotacredito($cupon->saldo,$model,$concepto);
							$detalle->importe = $saldo;
							$cupon->saldo = 0;
						}
					}
					else
					{
						$detalle->tipo=$_POST["tipo"];

						switch ($_POST["tipo"]) {
							case 'Tour':
								$detalle->id_reservacion = $_POST['cupon'];

								$detalle->tipo=$_POST["tipo"];
								$cupon = TourReservacion::model()->findByPk($_POST['cupon']);
								$saldo = empty($_POST['comision']) ? $cupon->saldo:$cupon->importe;
								$cupon->saldo = $_POST['saldores'];
								if($cupon->saldo <= -0.05){
									$concepto = "Cambio por pago de Reservación #".$cupon->id_reservacion;
									$notacredito[1] = $this->Crearnotacredito($cupon->saldo,$model,$concepto);
									$detalle->importe = $saldo;
									$cupon->saldo = 0;
								}
								break;
							case 'Activ':

								$detalle->id_reservacion = $_POST['cupon'];

								$detalle->tipo=$_POST["tipo"];
								
								$cupon = ActivityReservacion::model()->findByPk($_POST['cupon']);
								$saldo = empty($_POST['comision']) ? $cupon->saldo:$cupon->total;
								$cupon->saldo = $_POST['saldores'];

								if($cupon->saldo <= -0.05){
									$concepto = "Cambio por pago de Reservación #".$cupon->id_reservacion;
									$notacredito[1] = $this->Crearnotacredito($cupon->saldo,$model,$concepto);
									$detalle->importe = $saldo;
									$cupon->saldo = 0;
								}


								break;
							
							default:
								$detalle->id_reservacion = $_POST['cupon'];
								$cupon = Reservacion::model()->findByPk($_POST['cupon']);
								$saldo = empty($_POST['comision']) ? $cupon->saldo:$cupon->total;
								$cupon->saldo = $_POST['saldores'];
								if($cupon->saldo <= -0.05){
									$concepto = "Cambio por pago de Reservación #".$cupon->id_reservacion;
									$notacredito[1] = $this->Crearnotacredito($cupon->saldo,$model,$concepto);
									$detalle->importe = $saldo;
									$cupon->saldo = 0;
								}
								break;
						}

					

							

					}
					if(!empty($cupon->id_hotel)){
						$hotel=Hoteles::model()->find('id_hotel='.$cupon->id_hotel);
					}
					if($_POST["tipo"]=="Tour"){
						$tour=Tour::model()->findByPk($cupon->id_tour);


						if($detalle->importe < $cupon->importe && $cupon->saldo > 0)
						{
							$detalle->concepto='Pago Parcial ';
						}
						else if($detalle->importe == $saldo)
						{
							$detalle->concepto='Pago Total ';
						}
						else{
							$detalle->concepto='Saldo ';
						}
					}else{

						if($detalle->importe < $cupon->total && $cupon->saldo > 0)
						{
							$detalle->concepto='Pago Parcial ';
						}
						else if($detalle->importe == $saldo)
						{
							$detalle->concepto='Pago Total ';
						}
						else{
							$detalle->concepto='Saldo ';
						}
					}
					
					if($detalle->id_venta != NULL)
					{
						$detalle->concepto.= 'Orden de Servicio #'.$cupon->id_venta.' Pax: '.$cupon->cliente.' - Hotel: '.$hotel->nombre_hotel;
					}
					else{

						switch ($_POST["tipo"]) {
							case 'Tour':
								$detalle->concepto.= 'Tour #'.$cupon->id_tourReservacion.' Pax: '.$cupon->cliente_nombre.''.$cupon->cliente_apellido.' - Tour: '.$tour->nombre;
								break;


							case 'Activ':
									$detalle->concepto.= 'Activity #'.$cupon->id_reservacion.' Pax: '.$cupon->nombre_cliente.''.$cupon->apellido_cliente.' - Activity: '.$tour->actividad;
							break;
							
							default:
								$detalle->concepto.= 'Reserva #'.$cupon->id_reservacion.' Pax: '.$cupon->nombre_cliente.' - Hotel: '.$hotel->nombre_hotel.' - '.$cupon->num_habitaciones.' Hab.';
								break;
						}

						
							

					}


					$cupon->save();
					$detalle->save();
					if(!empty($_POST['comision'])){
						if($_POST["tipo"]=="Tour")
						$comisionAgencia = $cupon->importe * ($cupon->comision/100);
						else
						$comisionAgencia = $cupon->total * ($cupon->comision/100);
						$this->Crearcomisionagencia($cupon->id_reservacion,$comisionAgencia);
					}
					$this->renderPartial('listo',array('idrecibo'=>$model->id_recibo,'notacredito'=>$notacredito));
				}
				else
					throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');
			}
		}
	}
	function Aplicarnotacredito()
	{
		$notacredito = NotaCredito::model()->findAll('estatus="A"');
		$notasaplicadas = "Notas de Crédito Aplicadas:";
		$cupones = str_replace(',',' #',$_POST['cupon']);
		foreach($notacredito as $row)
		{
			if(isset($_POST['NotaCredito'][$row->id_nota_credito]))
			{
				$row->estatus = "AP";
				$row->fecha_aplicacion = date('Y-m-d H:i:s');
				if($_POST['ordenserv'] == true){
					$row->observaciones .= "<br>Aplicado a Orden de Servicio: #".$cupones;
				}else{
					$row->observaciones .= "<br>Aplicado a Reservaciones: #".$cupones;
				}
				$row->save();
				$notasaplicadas .= " #".$row->id_nota_credito;
			}
		}
		return $notasaplicadas;
	}
	function Crearnotacredito($saldo,$model,$concepto)
	{
		$notacredito = new NotaCredito;
		$notacredito->importe = $saldo * (-1);
		$notacredito->total = $notacredito->importe;
		$notacredito->id_tipo = $model->id_tipo;
		$notacredito->id_agencia = $model->id_agencia;
		$notacredito->id_ref = $model->id_recibo;
		$notacredito->tipo_ref = "RECIBO";
		$notacredito->concepto = $concepto;
		$notacredito->estatus = "A";
		$notacredito->id_user = $model->id_user;
		$notacredito->save();
		return $notacredito->id_nota_credito;
	}
	private function Crearcomisionagencia($id_reservacion,$importe)
	{
		$comision = new ComisionAgencia;
		$comision->id_reservacion = $id_reservacion;
		$comision->importe = $importe;
		$comision->id_user = Yii::app()->user->id;
		$comision->save();
	}
	public function actionCancelar()
	{
		$model=Recibo::model()->findByPk($_POST['id_recibo']);
		$detalle=ReciboDetalles::model()->findAll('id_recibo='.$_POST['id_recibo']);
		$clave=Claves::model()->find('clave="'.$_POST['clave'].'"');
		$error=0;
		if(!empty($clave)){
			foreach($detalle as $row)
			{
				if($row->id_venta != NULL)
				{
					$cupon = Venta::model()->findByPk($row->id_venta);
					$cupon->saldo=$cupon->saldo + $row->importe;
					$concepto = "Cancelación de Recibo #".$model->id_recibo.". Importe de Orden de Servicio #".$row->id_venta;
				}
				else
				{
					$cupon = Reservacion::model()->findByPk($row->id_reservacion);
					$cupon->saldo=$cupon->saldo + $row->importe;
					$concepto = "Cancelación de Recibo #".$model->id_recibo.". Importe de Reservación #".$row->id_reservacion;
				}
				$cupon->save();
				if($model->id_tipo == 11){
					$importe = $row->importe * (-1);
					$notacredito = $this->Crearnotacredito($importe,$model,$concepto);
				}
			}
			$model->motivo = $_POST['motivo'].", Fecha: ".date('d/m/Y H:i:s');
			$model->estado = "C";
			$model->save();
			$operacion = Yii::app()->createController('operacionesLog');
			$operacion = $operacion[0];
			$operacion->Create($model->id_recibo,13);
		}else{
			$error=1;
		}
		echo CJSON::encode(array('error'=>$error));
	}
	public function actionAplicar($id)
	{
		$model=Recibo::model()->findByPk($id);
		if($model->estado == 'P'){
			$model->estado = 'AP';
		}else{
			$model->estado = 'P';
		}
		$model->save();
	}
	public function actionRevisar($id)
	{
		$model=Recibo::model()->findByPk($id);
		if($model->revisado == 0){
			$model->revisado = 1;
		}else{
			$model->revisado = 0;
		}
		$model->save();
	}
	public function reservacionesnopagadas($idAgencia)
	{
		$sql="SELECT r.*, b.titulo AS 'bloqueo' FROM tbl_reservacion r LEFT JOIN tbl_bloqueos b ON r.id_bloqueo=b.id_bloqueo
		WHERE r.id_agencia=".$idAgencia." and r.estatus!='C' and r.saldo>0 and code!=''";	
		$row=Yii::app()->db->createCommand($sql)->queryAll();
		foreach($row as $data){		
			$arreglo[] = $data;
		} 
		return $arreglo;
	}
	public function actionSubirarchivo()
	{
		$model = new Comprobantes;
		$model->id_recibo = $_POST['idrecibo'];
		if(is_uploaded_file($_FILES['file']['tmp_name']))
		{
			$fileName = $_FILES['file']['name'];
			$model->archivo = date('Y-m-d').'_'.$model->id_recibo.''.$fileName;
			if($model->save())
			{
				$dir = $_SERVER['DOCUMENT_ROOT'].Yii::app()->request->baseUrl.'/images/comprobantes/'.$model->archivo;
				if(move_uploaded_file($_FILES['file']['tmp_name'],$dir))
				{
					echo "El archivo se subio correctamente";
				}
			}
		}
	}
	public function actionBorrararchivo($id)
	{
		$model = Comprobantes::model()->findByPk($id);
		$idrecibo = $model->id_recibo;
		if(is_readable($_SERVER['DOCUMENT_ROOT'].Yii::app()->request->baseUrl.'/images/comprobantes/'.$model->archivo))
		{
			if($model->archivo!="")
			unlink($_SERVER['DOCUMENT_ROOT'].Yii::app()->request->baseUrl.'/images/comprobantes/'.$model->archivo);
			$model->delete();
			$this->redirect(array('Verarchivos','idrecibo'=>$idrecibo));
		}
	}
	public function actionVerarchivos($idrecibo)
	{
		$model = Comprobantes::model()->findAll('id_recibo='.$idrecibo);
		$this->render('archivos',array('idrecibo'=>$idrecibo,'model'=>$model));
	}
	public function actionGeneratePdf($idrecibo)
	{
		$session=new CHttpSession;
        $session->open();
		Yii::import('application.extensions.bootstrap.gii.*');
		require_once('bootstrap/tcpdf/tcpdf.php');
		//require_once('bootstrap/tcpdf/config/lang/eng.php');
		$model=Recibo::model()->find('id_recibo='.$idrecibo);
		$detalle=ReciboDetalles::model()->find('id_recibo='.$idrecibo);


		if($detalle->id_venta != NULL){
			$cupon=Venta::model()->find('id_venta='.$detalle->id_venta);
			//$outlet=$cupon->idReservacion->idTarifa->precio;
		}
		else{

				if($detalle->tipo=="Tour"){
				$cupon=TourReservacion::model()->findByPk($detalle->id_reservacion);
				$outlet=$detalle->tipo;
			}elseif($detalle->tipo=="Activ"){
				$cupon=ActivityReservacion::model()->findByPk($detalle->id_reservacion);
				$outlet=$detalle->tipo;
			}elseif($detalle->tipo=="Fam"){
				$cupon=EventsGuests::model()->findByPk($detalle->id_reservacion);
				//$outlet=$detalle->tipo;
			}else{
				$cupon=Reservacion::model()->find('id_reservacion='.$detalle->id_reservacion);
				$outlet=$cupon->idTarifa->precio;
			}
		}

		
		/*if($detalle->id_venta != NULL){
			$cupon=Venta::model()->find('id_venta='.$detalle->id_venta);
		}
		else{

			if($detalle->tipo=="Tour")
			$cupon=TourReservacion::model()->findByPk($detalle->id_reservacion);
			else
			$cupon=Reservacion::model()->find('id_reservacion='.$detalle->id_reservacion);
		}*/
		$detalle=ReciboDetalles::model()->findAll('id_recibo='.$idrecibo);
		if (empty($cupon->id_agencia)) {		
			$agencia=Agencias::model()->find('id_agencia='.$model->id_agencia);
		}else{
			$agencia=Agencias::model()->find('id_agencia='.$cupon->id_agencia);
		}

		$html = $this->renderPartial('expenseGridtoReport', array(
			'model'=>$model,'detalle'=>$detalle,'agencia'=>$agencia, 'cupon'=>$cupon
		), true);
		$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor(Yii::app()->name);
		$pdf->SetTitle('Recibo');
		$pdf->SetSubject('Recibo');
		$pdf->SetKeywords('example, text, report');
		//$pdf->SetHeaderData('logo_rutamaya.jpg', 15, "Recibo por: Ruta Maya Travel", "");
		$pdf->setHeaderFont(Array('helvetica', '', 8));
		$pdf->setFooterFont(Array('helvetica', '', 6));
		$pdf->SetMargins(15, 18, 15);
		$pdf->SetHeaderMargin(8);
		$pdf->SetFooterMargin(10);
		$pdf->SetAutoPageBreak(TRUE, 0);
		$pdf->SetFont('dejavusans', '', 9);
		$pdf->AddPage();		
		$pdf->SetAlpha(1);					
		$pdf->writeHTML($html, true, false, true, false, '');
			$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
		/*if ($cupon->idTarifa->precio=="OUTLET") {
			$pdf->SetAlpha(0.3);
			$imgUrl="https://rutamayatravel.com".Yii::app()->request->baseUrl."/images/logo_outlet2018.png";

			$pdf->Image($imgUrl, 2, 100, 210, null, '', '', '', false);
			$pdf->setFont('dejavusans', '', 60, 'default',  true);
			$pdf->Text  ( 66, 187, 'PAGADO', false, false, true, 0, 0, '', false, '', 0, false, 'T', 'M', false );	
			//$pdf->Write(10, 'PAGADO', '', 0, 'C', true, 4, false, false, 100);	
		}*/

		if ($outlet=="OUTLET") {

			$pdf->SetAlpha(0.1);
			$imgUrl="http://".$_SERVER['SERVER_NAME'].Yii::app()->baseUrl."/images/logo_outlet2019.png";
			$pdf->Image($imgUrl, 0, 30, 230, '', '', '', false);
			$pdf->setFont('dejavusans', '', 76, 'default',  true);
			$pdf->StartTransform();
			$pdf->Rotate(45, 60, 175);
			$pdf->Text(66, 140, 'P A G A D O', false, false, true, 0, 0, '', false, '', 0, false, 'T', 'M', false );	
			$pdf->StopTransform();
		}
		if($model->estado == 'AP'){
			$pdf->SetFont('helvetica', 'B', 40);
			// Start Transformation
			$pdf->StartTransform();
			// Rotate 20 degrees counter-clockwise centered by (70,110) which is the lower left corner of the rectangle
			$pdf->Rotate(45, 60, 175);
			$pdf->Text(60, 175, 'Pago Aplicado');
			// Stop Transformation
			$pdf->StopTransform();
		}
		$pdf->LastPage();
		$pdf->Output("Recibo_001.pdf", "I");
		//echo $idrecibo;
	}
	public function actionPagosjson(){
		$condAgencia = "";
		if($_SESSION["tipoUsuario"] == "Agencia")
		{
			$condAgencia = " where r.id_agencia=".$_SESSION["agenciaUsuario"]."";
		}
		$sql="select r.id_recibo, t.descripcion, r.referencia, r.tarjeta, IF(r.estado='C' OR r.id_tipo=11,0,r.importe) as importe, date_format(r.log,'%Y-%m-%d') as log, a.nombre_agencia, u.nombre_usuario, r.comision, r.estado, r.revisado
				from tbl_recibo r 
				inner join tbl_tipo_pago t on r.id_tipo=t.id_tipo 
				left join tbl_agencias a on r.id_agencia=a.id_agencia 
				inner join tbl_usuarios u on r.id_user=u.id_usuario".$condAgencia.";";
		$rows=Yii::app()->db->createCommand($sql)->queryAll();
		if(isset($_GET['$callback']))
			echo $_GET['$callback'].'({"row":' .CJSON::encode($rows). ', "__count": "'.count($rows).'"})';		
	}
	public function actionRecibos(){
		$this->render("recibos");	
	}
	public function actionScriptbd()
	{
		$detalle = ReciboDetalles::model()->findAll();
		foreach($detalle as $row)
		{
			$model = ReciboDetalles::model()->findByPk($row->id_detalle);
			$model->attributes=$row;
			if($row->id_venta != NULL){
				$cupon=Venta::model()->find('id_venta='.$row->id_venta);
			}
			else{
				$cupon=Reservacion::model()->find('id_reservacion='.$row->id_reservacion);
			}
			$hotel=Hoteles::model()->find('id_hotel='.$cupon->id_hotel);
			if($row->importe < $cupon->total && $cupon->saldo > 0)
			{
				$concepto='Pago Parcial ';
			}
			else if($row->importe == $cupon->total){
				$concepto='Pago Total ';
			}
			else{
				$concepto='Saldo ';
			}
			if($row->id_venta != NULL){
				$concepto.= 'Orden de Servicio #'.$cupon->id_venta.' Pax: '.$cupon->cliente.' - Hotel: '.$hotel->nombre_hotel;
			}
			else{
				$concepto.= 'Reserva #'.$cupon->id_reservacion.' Pax: '.$cupon->nombre_cliente.' - Hotel: '.$hotel->nombre_hotel.' - '.$cupon->num_habitaciones.' Hab.';
			}
			$model->concepto=$concepto;
			if($model->save())
			echo "<br>OK ".$concepto;
			else 
			echo "<br>Fallo ".$concepto;
		}
	}
}