<?php

class OperacionesLogController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column1';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view','GeneratePdf','GenerateExcel'),
				'roles'=>array('verOperacion'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('delete'),
				'roles'=>array('eliminarOperacion'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create'),
				'users'=>array('@'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function Create($idReferencia,$idOperaciontipo)
	{
		$model=new OperacionesLog;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		$model->id_referencia=$idReferencia;
		$model->id_operacion_tipo=$idOperaciontipo;
		if ($idOperaciontipo==3) {
			$model->descripcion="sur 4";
		}
		if (Yii::app()->user->id!=0) {
			$model->id_usuario=Yii::app()->user->id;
		}else{
			$model->id_usuario=797;
		}
		$model->save();
	}
	
	public function actionDelete($id)
	{
		if(Yii::app()->request->isPostRequest)
		{
			$this->loadModel($id)->delete();
		}
		else
			throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
            $session=new CHttpSession;
            $session->open();		
            $criteria = new CDbCriteria();
			$criteria->with='idUsuario';            

                $model=new OperacionesLog('search');
                $model->unsetAttributes();  // clear any default values

                if(isset($_GET['OperacionesLog']))
		{
                        $model->attributes=$_GET['OperacionesLog'];
			
			
                   	
                       if (!empty($model->id_operacion_log)) $criteria->addCondition("id_operacion_log = '".$model->id_operacion_log."'");
                     
                    	
                       if (!empty($model->id_referencia)) $criteria->addCondition("id_referencia = '".$model->id_referencia."'");
                     
                    	
                       if (!empty($model->id_operacion_tipo)) $criteria->addCondition("id_operacion_tipo = '".$model->id_operacion_tipo."'");
					   
					   
					   if (!empty($model->descripcion)) $criteria->addCondition("descripcion = '".$model->descripcion."'");
                     
                    	
                       if (!empty($model->nombre_usuario)) $criteria->addCondition("CONCAT(firstname,' ',lastname) LIKE '%".$model->nombre_usuario."%'");
                     
                    	
                       if (!empty($model->fecha_log)) $criteria->addCondition("fecha_log LIKE '%".$model->fecha_log."%'");
                     
                    			
                    $session['OperacionesLog_records']=OperacionesLog::model()->findAll($criteria); 
		}
       

                $this->render('index',array(
			'model'=>$model,
		));

	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new OperacionesLog('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['OperacionesLog']))
			$model->attributes=$_GET['OperacionesLog'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model=OperacionesLog::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='operaciones-log-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
    public function actionGenerateExcel()
	{
            $session=new CHttpSession;
            $session->open();		
            
             if(isset($session['OperacionesLog_records']))
               {
                $model=$session['OperacionesLog_records'];
               }
               else
                 $model = OperacionesLog::model()->findAll();

		
		Yii::app()->request->sendFile(date('YmdHis').'.xls',
			$this->renderPartial('excelReport', array(
				'model'=>$model
			), true)
		);
	}
        public function actionGeneratePdf() 
	{
           $session=new CHttpSession;
           $session->open();
		Yii::import('application.extensions.bootstrap.gii.*');
		require_once('bootstrap/tcpdf/tcpdf.php');
		require_once('bootstrap/tcpdf/config/lang/eng.php');

             if(isset($session['OperacionesLog_records']))
               {
                $model=$session['OperacionesLog_records'];
               }
               else
                 $model = OperacionesLog::model()->findAll();



		$html = $this->renderPartial('expenseGridtoReport', array(
			'model'=>$model
		), true);
		
		//die($html);
		
		$pdf = new TCPDF();
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor(Yii::app()->name);
		$pdf->SetTitle('OperacionesLog Report');
		$pdf->SetSubject('OperacionesLog Report');
		//$pdf->SetKeywords('example, text, report');
		$pdf->SetHeaderData('', 0, "Report", '');
		$pdf->SetHeaderData('logo_rutamaya.jpg', PDF_HEADER_LOGO_WIDTH, "Reporte de Operaciones por ".Yii::app()->name." - ".date('d/m/Y'), "");
		$pdf->setHeaderFont(Array('helvetica', '', 8));
		$pdf->setFooterFont(Array('helvetica', '', 6));
		$pdf->SetMargins(15, 18, 15);
		$pdf->SetHeaderMargin(5);
		$pdf->SetFooterMargin(10);
		$pdf->SetAutoPageBreak(TRUE, 15);
		$pdf->SetFont('dejavusans', '', 7);
		$pdf->AddPage();
		$pdf->writeHTML($html, true, false, true, false, '');
		$pdf->LastPage();
		$pdf->Output("OperacionesLog_002.pdf", "I");
	}
}
