<?php

class OnboardingController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column1';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
			array(
                'ext.starship.RestfullYii.filters.ERestFilter + 
                REST.GET, REST.PUT, REST.POST, REST.DELETE'
            ),
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow', 'actions'=>array('REST.GET', 'REST.PUT', 'REST.POST', 'REST.DELETE'),
				'users'=>array('@'),
			),
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('@'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update','GeneratePdf','GenerateExcel', 'actualizarPerfiles'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	public function actions()
	{
        return array('REST.'=>'ext.starship.RestfullYii.actions.ERestActionProvider',);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	public function actionActualizarPerfiles(){

		if ($_POST['ubicacion']) {
			$user = Usuarios::model()->findByPk($_POST['id_usuario']);
			$ubicacion = Agencias::model()->findByPk($user->id_agencia);
			$ubicacion->ubicacion = $_POST['ubicacion'];

			if ($ubicacion->save()) {
				$cat_onboarding = Onboarding::model()->findByPk($_POST['onboarding']);
				$this->confirmar($cat_onboarding->id_catalogo,$_POST['id_usuario'],'agencia',$ubicacion->id_agencia);
				echo "success";
			}else{
				echo "error";
			}
		}

		if ($_POST['fecha_nacimiento']) {
			$usuario = Usuarios::model()->findByPk($_POST['id_usuario']);
			$usuario->fecha_nacimiento = implode('-',array_reverse(explode('/',$_POST['fecha_nacimiento'])));
			if ($usuario->save()) {
				$this->confirmar($_POST['onboarding'],$_POST['id_usuario'],'usuario',null);
				echo "success";
			}else{
				echo "error";
			}
		}

		if ($_POST['logo']==1) {
			$user = Usuarios::model()->findByPk($_POST['id_usuario']);
			$logo = Agencias::model()->findByPk($user->id_agencia);
			$cat_onboarding = Onboarding::model()->findByPk($_POST['onboarding']);

			if(is_uploaded_file($_FILES['upload_logo']['tmp_name']))
			{
				$fileName = $_FILES['upload_logo']['name'];
				$logo->foto = date('Y-m-d').'_'.$logo->id_agencia.''.$fileName;
				if($logo->save())
				{
					$this->confirmar($cat_onboarding->id_catalogo,$_POST['id_usuario'],'agencia',$logo->id_agencia);
					$dir = $_SERVER['DOCUMENT_ROOT'] .'/imagenes/'.$logo->foto;
					if(!move_uploaded_file($_FILES['upload_logo']['tmp_name'],$dir))
					{
						echo "error";
					}
					else{
						echo "success";
					}
				}
			}else{
				if ($logo->foto==NULL || empty($logo->foto)) {
					echo "error";
				}else{
					$this->confirmar($cat_onboarding->id_catalogo,$_POST['id_usuario'],'agencia',$logo->id_agencia);
					echo "sames";
				}
			}
		}

		if ($_POST['flyer']==1) {
			$user = Usuarios::model()->findByPk($_POST['id_usuario']);
			$flyer = Agencias::model()->findByPk($user->id_agencia);
			$cat_onboarding = Onboarding::model()->findByPk($_POST['onboarding']);

			if(is_uploaded_file($_FILES['upload_flyer']['tmp_name']))
			{
				$fileName = $_FILES['upload_flyer']['name'];
				$flyer->pie_flyer = $flyer->id_agencia.''.$fileName;
				if($flyer->save())
				{
					$this->confirmar($cat_onboarding->id_catalogo,$_POST['id_usuario'],'agencia',$flyer->id_agencia);
					$dir = $_SERVER['DOCUMENT_ROOT'] .'/medios/flyers/pies_agencias/'.$flyer->pie_flyer;
					if(!move_uploaded_file($_FILES['upload_flyer']['tmp_name'],$dir))
					{
						echo "error";
					}
					else{
						echo "success";
					}
				}
			}else{
					$this->confirmar($cat_onboarding->id_catalogo,$_POST['id_usuario'],'agencia',$flyer->id_agencia);
					echo "sames";
			}
		}

		if ($_POST['no_preguntar']) {
			if ($_POST['no_preguntar']==1) {
				# code...
				$this->no_preguntar($_POST['id_onboarding'],1);
				echo "success";
				
			}else{

				$this->no_preguntar($_POST['id_onboarding'],0);
				echo "success";
			}
			
		}

		if ($_POST['no_preguntar_todo']) {
			if ($_POST['no_preguntar_todo']==1) {
				$this->no_preguntar_todo($_POST['id_usuario'],1);
				echo "success";
			}else{
				$this->no_preguntar_todo($_POST['id_usuario'],0);
				echo "success";
			}
		}


	}

	public function confirmar($id,$user,$tipo,$agencia){

		if ($tipo=='agencia') {
			$usuarios = Usuarios::model()->findAll('id_agencia='.$agencia.' AND estatus="A"');
			
			$users = array();
			foreach ($usuarios as $uss) {
				array_push($users, $uss->id_usuario);
			}

			$consulta = '';
			$i=0;
			foreach ($users as $us) {
				if ($i!=0) {
					$consulta.=',';
				}else{
					$i=1;
				}
				$consulta .= $us;
			}
			$consulta = 'id_usuario IN('.$consulta.')';

			$confirmar = Onboarding::model()->findAll($consulta.' AND id_catalogo='.$id);

			foreach ($confirmar as $k => $val) {
				$update = Onboarding::model()->findByPk($val->id_onboarding);
				$update->confirmado = 1;
				$update->save();
			}
			
		}else{
			$confirmar = Onboarding::model()->findByPk($id);
			$confirmar->confirmado = 1;
			$confirmar->save();
		}
	
	}

	public function no_preguntar($id,$valor){
		$no_preguntar = Onboarding::model()->findByPk($id);
		$no_preguntar->no_preguntar = $valor;
		$no_preguntar->save();
	}

	public function no_preguntar_todo($id,$valor){
		$search = Onboarding::model()->findAll('id_usuario='.$id);
		foreach ($search as $k => $value) {
			$onb_search = Onboarding::model()->findByPk($value->id_onboarding);
			$onb_search->no_preguntar = $valor;
			$onb_search->save();
		}
	}

	public function omitir($id,$user){
		$omitir = Onboarding::model()->findByPk($id);
		$omitir->omitir = 1;
		$omitir->save();
	}
	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new Onboarding;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Onboarding']))
		{
			$model->attributes=$_POST['Onboarding'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id_onboarding));
		}

		$this->render('create',array(
			'model'=>$model,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Onboarding']))
		{
			$model->attributes=$_POST['Onboarding'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id_onboarding));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		if(Yii::app()->request->isPostRequest)
		{
			// we only allow deletion via POST request
			$this->loadModel($id)->delete();

			// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
			if(!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
		}
		else
			throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
            $session=new CHttpSession;
            $session->open();		
            $criteria = new CDbCriteria();            

                $model=new Onboarding('search');
                $model->unsetAttributes();  // clear any default values

                if(isset($_GET['Onboarding']))
		{
                        $model->attributes=$_GET['Onboarding'];
			
			
                   	
                       if (!empty($model->id_onboarding)) $criteria->addCondition("id_onboarding = '".$model->id_onboarding."'");
                     
                    	
                       if (!empty($model->id_usuario)) $criteria->addCondition("id_usuario = '".$model->id_usuario."'");
                     
                    	
                       if (!empty($model->omitir)) $criteria->addCondition("omitir = '".$model->omitir."'");
                     
                    	
                       if (!empty($model->no_preguntar)) $criteria->addCondition("no_preguntar = '".$model->no_preguntar."'");
                     
                    	
                       if (!empty($model->confirmado)) $criteria->addCondition("confirmado = '".$model->confirmado."'");
                     
                    	
                       if (!empty($model->id_catalogo)) $criteria->addCondition("id_catalogo = '".$model->id_catalogo."'");
                     
                    	
                       if (!empty($model->log)) $criteria->addCondition("log = '".$model->log."'");
                     
                    			
                    $session['Onboarding_records']=Onboarding::model()->findAll($criteria); 
		}
       

                $this->render('index',array(
			'model'=>$model,
		));

	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Onboarding('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Onboarding']))
			$model->attributes=$_GET['Onboarding'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model=Onboarding::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='onboarding-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
        public function actionGenerateExcel()
	{
            $session=new CHttpSession;
            $session->open();		
            
             if(isset($session['Onboarding_records']))
               {
                $model=$session['Onboarding_records'];
               }
               else
                 $model = Onboarding::model()->findAll();

		
		Yii::app()->request->sendFile(date('YmdHis').'.xls',
			$this->renderPartial('excelReport', array(
				'model'=>$model
			), true)
		);
	}
        public function actionGeneratePdf() 
	{
           $session=new CHttpSession;
           $session->open();
		Yii::import('application.extensions.bootstrap.gii.*');
		require_once('bootstrap/tcpdf/tcpdf.php');
		require_once('bootstrap/tcpdf/config/lang/eng.php');

             if(isset($session['Onboarding_records']))
               {
                $model=$session['Onboarding_records'];
               }
               else
                 $model = Onboarding::model()->findAll();



		$html = $this->renderPartial('expenseGridtoReport', array(
			'model'=>$model
		), true);
		
		//die($html);
		
		$pdf = new TCPDF();
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor(Yii::app()->name);
		$pdf->SetTitle('Onboarding Report');
		$pdf->SetSubject('Onboarding Report');
		//$pdf->SetKeywords('example, text, report');
		$pdf->SetHeaderData('', 0, "Report", '');
		$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, "Example Report by ".Yii::app()->name, "");
		$pdf->setHeaderFont(Array('helvetica', '', 8));
		$pdf->setFooterFont(Array('helvetica', '', 6));
		$pdf->SetMargins(15, 18, 15);
		$pdf->SetHeaderMargin(5);
		$pdf->SetFooterMargin(10);
		$pdf->SetAutoPageBreak(TRUE, 0);
		$pdf->SetFont('dejavusans', '', 7);
		$pdf->AddPage();
		$pdf->writeHTML($html, true, false, true, false, '');
		$pdf->LastPage();
		$pdf->Output("Onboarding_002.pdf", "I");
	}
}
