<?php
// error_reporting(E_ALL ^ E_NOTICE);
header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
Yii::import('application.extensions.phpmailer.JPhpMailer');
require_once('../api/Openpay/functions.php');
require_once('../api/cfdi/FacturaApi.php');
// require_once('../api/cfdi/FacturaApiDemo.php');
class LogOpenpayController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column1';
	private $idOpenpay = 'mvdr6tqdokmbnboafexd';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
			array(
                'ext.starship.RestfullYii.filters.ERestFilter + 
                REST.GET, REST.PUT, REST.POST, REST.DELETE'
            ),
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow', 'actions'=>array('REST.GET', 'REST.PUT', 'REST.POST', 'REST.DELETE'),
				'users'=>array('@'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('index','view','create','update','GeneratePdf','GenerateExcel','bancoEnlace','echo','CancelarLiga'),
				'users'=>array('@'),
			),
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('crearPago','enviarEmailConfirmacionPago'),
				'users'=>array('*'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	public function actions()
	{
        return array('REST.'=>'ext.starship.RestfullYii.actions.ERestActionProvider',);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	public function actionEcho(){
		$model = LogOpenpay::model()->findAll('id_recibo IS NOT NULL');

		foreach ($model as $key => $value) {
			if ($value->tipo=='BODAS') {
				# code...
				echo 'Nota Credito = '.$value->id_recibo.' '.$value->idNotaCredito->concepto.'<br>';
			}else{
				echo 'Recibo = '.$value->id_recibo.' '.$value->idRecibo->observaciones.'<br>';
			}
		}
	}

	public function actionBancoEnlace(){

		$model = LogOpenpay::model()->find('id_reservacion='.$_POST['ref'].' AND (estatus="Cargo Creado" OR estatus="Pendiente") AND tipo="'.$_POST['tipoLiga'].'"');

		// echo CJSON::encode($model);
		// echo "<textarea>".json_encode($_POST)."</textarea>";
		// exit;
		$ligaUrl = 'https://www.rutamayatravel.com/reservaciones/pagoenlinea/ligaPago.php?ref=';

		switch ($_POST['tipoLiga']) {
			case 'RESERVACION':
			$reference = '1'.$_POST['ref'];
			$reservacion = Reservacion::model()->findByPk($_POST['ref']);
			$tipo_cambio = $reservacion->tipo_cambio;
			break;
			case 'ACTIVITY':
			$reference = '2'.$_POST['ref'];
			$reservacion = ActivityReservacion::model()->findByPk($_POST['ref']);
			$tipo_cambio = $reservacion->tipo_cambio;
			$booking = json_encode($reservacion->Booking);
			break;
			case 'TOUR':
			$reference = '3'.$_POST['ref'];
			$reservacion = TourReservacion::model()->findByPk($_POST['ref']);
			$tipo_cambio = $reservacion->tasa_cambio;
			break;
			case 'GRUPOS':
				
				break;
			case 'BODAS':
				# code...
				break;
		}

		$tipoLiga = $_POST['tipoLiga'];
		if(isset($_SESSION['agenciaUsuario'])){
			$agencia = Agencias::model()->findByPk($_SESSION['agenciaUsuario']);
		}else{
			$agencia = Agencias::model()->findByPk(9);
		}
		if (!empty($model)) {

			if ($model->liga_generado==0) {

				$customerData = array(
					'name' => $agencia->nombre_agencia,
					'email' => $_POST['email'],
					'phone_number' => $_POST['celular'],
				);
				$chargeRequest = array(
					'method' => 'bank_account',
					'amount' => round($_POST['importe'],2),
					'description' => $tipoLiga.' - '.$_POST['ref'],
					'order_id' => $model->id,
					'customer' => $customerData
				);

				$response = $openpay->generarFichaPago($chargeRequest);

				if ($response['status']=='in_progress') {

					$fechalimite = explode('T', $response['fecha_limite']);
					$hora = explode('-', $fechalimite[1]);

					$fecha_limite = $fechalimite[0];
					$hora_limite = $hora[0];

					$model->liga_generado = 1;
					$model->transaction = $response['id_transaction'];
					$model->fecha_limite = $fecha_limite.' '.$hora_limite;
					$model->referencia_banco = $response['referencia_banco'];
					$model->concepto_pago = $response['concepto_pago'];
					$model->clabe = $response['clabe'];

					if ($model->save()) {

						$url_liga = $ligaUrl.$model->id;
						echo json_encode(array('liga'=>$url_liga,'mensaje'=>'success'));
					}
				}else{
					echo json_encode(array('liga'=>$url_liga,'mensaje'=>'error'));
				}
			}else{
				$url_liga = $ligaUrl.$model->id;
				echo json_encode(array('liga'=>$url_liga,'mensaje'=>'pendiente','key'=>$model->id));
			}
			// $json_response = json_decode($model->response_liga);

			// $url_liga = 'https://sandbox-dashboard.openpay.mx/spei-pdf/'.$this->idOpenpay.'/'.$json_response->id;
			
		}else{
			$openpay = new Functions();

			$model = new LogOpenpay;

			if ($tipoLiga=="GRUPOS" || $tipoLiga=="BODAS") {
				$tipo_nota = 'credito';
			}else{
				$tipo_nota = 'recibo';
			}

			$model->id_reservacion = $_POST['ref'];
			$model->id_usuario = Yii::app()->user->id;
			$model->id_agencia = $_SESSION['agenciaUsuario'];
			$model->tipo = $_POST['tipoLiga'];
			$model->importe = round($_POST['importe'],2);
			$model->estatus = 'Pendiente';
			$model->liga_generado = 0;
			$model->tipo_nota = $tipo_nota;

			try {
				if ($model->save()) {

					$customerData = array(
						'name' => $agencia->nombre_agencia,
						'email' => $_POST['email'],
						'phone_number' => $_POST['celular'],
					);
					$chargeRequest = array(
						'method' => 'bank_account',
						'amount' => round($_POST['importe'],2),
						'description' => $tipoLiga.' - '.$model->id_reservacion,
						'order_id' => $model->id,
						'customer' => $customerData
					);

					$response = $openpay->generarFichaPago($chargeRequest);

					// $response = json_decode($response,true);
					if ($response['status']=='in_progress') {

						$fechalimite = explode('T', $response['fecha_limite']);
						$hora = explode('-', $fechalimite[1]);

						$fecha_limite = $fechalimite[0];
						$hora_limite = $hora[0];

						$model->liga_generado = 1;
						$model->request = json_encode($chargeRequest);
						$model->reference = $model->id;
						$model->transaction = $response['id_transaction'];
						$model->fecha_limite = $fecha_limite.' '.$hora_limite;
						$model->referencia_banco = $response['referencia_banco'];
						$model->concepto_pago = $response['concepto_pago'];
						$model->clabe = $response['clabe'];
						// $model->response_pago = json_encode($response['json']);

						if ($model->save()) {

							$url_liga = $ligaUrl.$model->id;
							$this->mailInterno($url_liga,$model->id_usuario,$model->importe,$model->id_reservacion,$tipoLiga);

							echo json_encode(array('liga'=>$url_liga,'mensaje'=>'success'));
						}
					}else{
						$model->request = json_encode($chargeRequest);
						$model->save();
						echo json_encode(array('liga'=>$url_liga,'mensaje'=>'error'));
					}

				}else{
					print_r($model->getErrors());
				}
			} catch (Exception $e) {
				$mensaje_de_error.= "<br> Mensaje: ".$e->getMessage()." <br> Codigo: ".$e->getCode()." <br> Archivo: ".$e->getFile()." <br> Linea: ".$e->getLine();
				echo $mensaje_de_error;
			}
			
			
		}
	}

	public function actionCrearPago(){
		// $model = recibo; $detalle=recibodetalles; $cupon=reserva; $json=log_openpay

		$orden = Yii::app()->request->getPost('ordenID', 0);
		// $orden = $_GET['ordenID'];
		
		try {
			
			$json = LogOpenpay::model()->find('reference='.$orden);

			$encabezados  = "MIME-Version: 1.0\n";
			$encabezados .= "Content-type: text/html; charset=UTF-8\n";
			$encabezados .= "From:  Openpay <soporte@>rutamayatravel.com\n";
			$subject2 = "Proceso de Creacion de pago";
			$message2 = '';


			if ($json->estatus=='Aceptado') {

				$this->enviarEmailConfirmacionPago($json->id);
				
				if ($json->tipo=='BODAS' || $json->tipo=='GRUPOS') {

					$facturacion = $this->crearPagoBloqueos($json,$orden);

					// echo "<textarea>".json_encode($facturacion)."</textarea>";
					
					$bandera = $facturacion['bandera'];
					$message2.= $facturacion['mensaje'];

				}else{

					$model=new Recibo;
					$detalle = new ReciboDetalles;

					switch ($json->tipo) {
						case 'RESERVACION':
						$detalle->tipo='';
						$cupon = Reservacion::model()->findByPk($json->id_reservacion);
						$id_reservacion = $cupon->id_reservacion;
						$tipoReservacion = 'Reservacion';
						break;
						case 'ACTIVITY':
						$detalle->tipo='Activ';
						$cupon = ActivityReservacion::model()->findByPk($json->id_reservacion);
						$id_reservacion = $cupon->id_reservacion;
						$tipoReservacion = 'Activity';
						break;
						case 'TOUR':
						$detalle->tipo='Tour';
						$cupon = TourReservacion::model()->findByPk($json->id_reservacion);
						$id_reservacion = $cupon->id_tourReservacion;
						$tipoReservacion = 'Tour';
						break;
					}

					if(Yii::app()->user->id==0){
						$model->id_user = 797;
					}else{
						$model->id_user=Yii::app()->user->id;
					}

					if (!empty($cupon->id_agencia)) {
						$id_agencia = $cupon->id_agencia;
					}else{
						$id_agencia = $json->id_agencia;
					}

					$model->id_agencia = $id_agencia;
					$model->id_cuenta=3;
					$model->id_tipo=6;
					$model->id_planpago=6;
					$model->importe = $json->importe;
					$model->comision=0;
					$model->id_banco = 2;
					$model->observaciones="PAGO REALIZADO EN OPENPAY A BBVA Company POR SISTEMA DE RESERVACIONES";

					if ($model->save()) {

						$detalle->id_recibo = $model->id_recibo;
						$detalle->importe =  $model->importe;

						$json->id_recibo = $model->id_recibo;

						$detalle->id_reservacion = $json->id_reservacion;


						// if($cupon->saldo <= -0.05){
						// 	$comisionAgencia=($cupon->saldo*-1);
						// 	$concepto = "Cambio por pago de Reservación #".$id_reservacion;
						// 							//$notacredito[1] = $this->Crearnotacredito($cupon->saldo,$model,$concepto);
						// 	$this->Crearcomisionagencia($id_reservacion, $comisionAgencia);
						// 	$cupon->saldo=0;										
						// }
						if(!empty($cupon->id_hotel) && isset($cupon->id_hotel)){
							$hotel=Hoteles::model()->find('id_hotel='.$cupon->id_hotel);
						}

						if($tipoReservacion=="Tour"){
							$saldo = empty($model->comision) ? $cupon->saldo:$cupon->importe;
							if($detalle->importe < $cupon->importe && $cupon->saldo > 0)
							{
								$detalle->concepto='Pago Parcial ';
							}
							else if($detalle->importe == $saldo)
							{
								$detalle->concepto='Pago Total ';
							}
							else{
								$detalle->concepto='Saldo ';
							}
						}else{
							$saldo = empty($model->comision) ? $cupon->saldo:$cupon->total;

							if($detalle->importe < $cupon->total && $cupon->saldo > 0)
							{
								$detalle->concepto='Pago Parcial ';
							}
							else if($detalle->importe == $saldo)
							{
								$detalle->concepto='Pago Total ';
							}
							else{
								$detalle->concepto='Saldo ';
							}
						}

						$cupon->saldo = ($saldo-$model->importe);

						if($detalle->id_venta != NULL)
						{
							$detalle->concepto.= 'Orden de Servicio #'.$cupon->id_venta.' Pax: '.$cupon->cliente.' - Hotel: '.$hotel->nombre_hotel;
						}
						else{

							switch ($tipoReservacion) {
								case 'Tour':
								$tour=Tour::model()->findByPk($cupon->id_tour);
								$detalle->concepto.= 'Tour #'.$id_reservacion.' Pax: '.$cupon->cliente_nombre.''.$cupon->cliente_apellido.' - Tour: '.$tour->nombre;
								break;


								case 'Activity':
								$detalle->concepto.= 'Activity #'.$id_reservacion.' Pax: '.$cupon->nombre_cliente.''.$cupon->apellido_cliente.' - Activity: '.$cupon->actividad;
								break;

								default:
								$detalle->concepto.= 'Reserva #'.$id_reservacion.' Pax: '.$cupon->nombre_cliente.' - Hotel: '.$hotel->nombre_hotel.' - '.$cupon->num_habitaciones.' Hab.';
								break;
							}

						}

						$bandera=true;

						if(!$cupon->save()){
							echo $bandera= CJSON::encode($cupon->getErrors());
							$message2.= 'Error en Cupon->save en id_log Openpay:'.$json->id.'<br> json='.$bandera;
							mail('programador3@rutamayatravel.com',$subject2,$message2,$encabezados);
							exit;
						}
						if(!$detalle->save()){
							echo $bandera=CJSON::encode($detalle->getErrors());
							$message2.= 'Error en detalle->save en id_log Openpay:'.$json->id.'<br> json='.$bandera;
							mail('programador3@rutamayatravel.com',$subject2,$message2,$encabezados);
							exit;
						}
						if(!$json->save()){
							echo $bandera=CJSON::encode($json->getErrors());
							$message2.= 'Error en json->save en id_log Openpay:'.$json->id.'<br> json='.$bandera;
							mail('programador3@rutamayatravel.com',$subject2,$message2,$encabezados);
							exit;
						}

						$facturacion = $this->facturarNota($json,$model->id_recibo,$model->importe,$cupon);
						$message2.= $facturacion['mensaje'];
						$bandera = $facturacion['bandera'];

					}else{
						$bandera= CJSON::encode($model->getErrors());
						$bandera= "model";
					}
				}
				
				

			}else{
				$bandera = false;	
			}

			mail('programador3@rutamayatravel.com',$subject2,$message2,$encabezados);
			// echo $bandera;
			return $bandera;

		} catch (Exception $e) {

			$encabezados  = "MIME-Version: 1.0\n";
			$encabezados .= "Content-type: text/html; charset=UTF-8\n";
			$encabezados .= "From:  Openpay <soporte@>rutamayatravel.com\n";
			$subject2 = "Error Try Catch - Proceso de Creacion de pago";
			$mensaje_de_error = 'Log OPENPAY con id: '.$orden;
			$mensaje_de_error.= "<br> Mensaje: ".$e->getMessage()." <br> Codigo: ".$e->getCode()." <br> Archivo: ".$e->getFile()." <br> Linea: ".$e->getLine();
			mail('programador3@rutamayatravel.com',$subject2,$mensaje_de_error,$encabezados);
			return false;
		}
	}

	public function crearPagoBloqueos($json, $ordenID){
		$model=new NotaCredito;

		if (!empty($json)) {
			$bloqueo =  Bloqueos::model()->find('id_bloqueo='.$json->id_reservacion);

			if (!empty($bloqueo->id_agencia)) {
				$id_agencia = $bloqueo->id_agencia;
			}else{
				$id_agencia = $json->id_agencia;
			}

			$model->id_tipo=6;
			$model->importe = $json->importe;
			$model->id_agencia = $id_agencia;
			$model->id_ref = $json->id_reservacion;
			$model->tipo_ref = 'BLOQUEO';
			$model->referencia = $json->id;
			$model->id_banco = 2;
			$model->tarjeta = 0;
			$model->id_cuenta = 3;
			$model->comision = 0;
			$model->total = $json->importe;
			$concepto = 'ANTICIPO BLOQUEO '.$json->id_reservacion;

			if ($json->tipo == 'BODAS') {
				$concepto.= ' NOVIOS '.$bloqueo->novios;
			}

			$concepto.= ' PAGO REALIZADO EN OPENPAY A BBVA Company POR SISTEMA DE RESERVACIONES';
			$model->concepto = $concepto;
			$model->observaciones = 'PAGO REALIZADO EN OPENPAY A BBVA Company POR SISTEMA DE RESERVACIONES';
			$model->estatus = 'A';

			if(Yii::app()->user->id==0){
				$model->id_user = 797;
			}else{
				$model->id_user=Yii::app()->user->id;
			}

			$model->revisado = 0;

			if ($model->save()) {
				// $operacion = Yii::app()->createController('operacionesLog');
				// $operacion = $operacion[0];
				// $operacion->Create($model->id_nota_credito,17);

				$json->id_recibo = $model->id_nota_credito;
				$json->save();
				$bandera = true;

				$facturacion = $this->facturarNota($json,$model->id_nota_credito,$model->importe,$bloqueo);

				$bandera = $facturacion['bandera'];
				$message2.= $facturacion['mensaje'];

				// $bandera = true;
				
			}else{
				$bandera = false;
				$message2.='Error en model->save NOTA DE CREDITO en id_log Openpay:'.$json->id.'<br> json='.CJSON::encode($model->getErrors());
			}

			return array('bandera'=>$bandera,'mensaje'=>$message2);

		}else{
			
			return array('bandera'=>false,'mensaje'=>'No existe log de openpay');
		}
	}

	public function facturarNota($json,$id_nota,$importe_pago,$cupon){
		$cfdi=new FacturaApi;
		$factura=new FeFacturas;
		$factura_detalle = new FeFacturasDetalle;
		$error = array();

		$lastId = Yii::app()->db->createCommand('SELECT id_factura,folio,serie FROM tbl_fe_facturas WHERE serie="A" ORDER BY id_factura DESC LIMIT 1')->queryAll();

		$folio = $lastId[0]['folio'];
		$newFolio = ((int) $folio) + 1;
		$referencia_agencia = $cupon->id_agencia.'A'.$id_nota;
		$cfdi_cantidad=1;

		$factura->folio = $newFolio;
		$factura->serie = 'A';
		$factura->importe = 0.00;
		$factura->subtotal = 0.00;
		$factura->iva = 0.00;
		$factura->total = 0.00;
		$factura->moneda = 'MXN';
		$factura->iva_porcentaje = 1.1600;
		$factura->estatus = 'P';
		$factura->condiciones_pago = ''; // CONTADO
		$factura->metodo_pago = 'PUE';
		$factura->tipo_comprobante = 'ingreso';
		$factura->original_monto = $importe_pago;
		$factura->tipo_cambio = '1.00';
		$factura->forma_pago = '03';
		$factura->id_agencia = $cupon->id_agencia;
		$factura->referencia_agencia = $referencia_agencia;
		$factura->id_nota = $id_nota;

		if ($json->tipo_nota=='recibo') {
			$factura->tipo_nota = 'recibo';
		}elseif ($json->tipo_nota=='credito') {
			$factura->tipo_nota = 'credito';
		}

		$factura->receptor_rfc = $cupon->idAgencia->rfc;
		$factura->receptor_razon_social = $cupon->idAgencia->razon_social;
		$factura->receptor_calle = $cupon->idAgencia->calle_fiscal;
		$factura->receptor_no_exterior = $cupon->idAgencia->num_exterior_fiscal;
		$factura->receptor_no_interior = $cupon->idAgencia->num_interior_fiscal;
		$factura->receptor_colonia = $cupon->idAgencia->id_colonia_fiscal;
		$factura->receptor_estado = $cupon->idAgencia->id_estado_fiscal;
		$factura->receptor_cp = $cupon->idAgencia->cp_fiscal;
		$factura->receptor_municipio = $cupon->idAgencia->municipio_fiscal;
		$factura->receptor_localidad = $cupon->idAgencia->municipio_fiscal;
		$factura->receptor_pais = $cupon->idAgencia->id_pais_fiscal;
		$factura->receptor_cruzamientos = $cupon->idAgencia->cruzamientos_fiscal;
		$factura->correo_fiscal = $cupon->idAgencia->email_agencia;

		if ($factura->save()) {
			$factura_detalle->id_factura = $factura->id_factura;
			$factura_detalle->cantidad = 1;
			$factura_detalle->unidad = 'SERVICIO';
			$factura_detalle->no_identificacion = $id_nota;
			$factura_detalle->cve_prod_serv = 90111500;
			$factura_detalle->descripcion = "SERVICIO DE HOSPEDAJE";
			$factura_detalle->clave_unidad = 'E48';
			$factura_detalle->valor_unitario = 0;
			$factura_detalle->importe = 0;
			$factura_detalle->id_recibo = $id_nota;
			$factura_detalle->save();


			$cfdi->rfcReceptor=$factura->receptor_rfc;
			$cfdi->razonSocialReceptor=$factura->receptor_razon_social;

			$cfdi->folio=$factura->folio;
			$cfdi->serie=$factura->serie;
			$cfdi->formaPago=$factura->forma_pago;

			$correoLiga = json_decode($json->request);

			// $cfdi->correo_receptor = $factura->correo_fiscal;
			// $cfdi->correo_receptor = 'programador3@rutamayatravel.com';
			// $cfdi->correo_receptor = $correoLiga->customer->email.';'.'josecanutl21@gmail.com';
			$cfdi->correo_receptor = $correoLiga->customer->email.';'.$factura->correo_fiscal;
			// $cfdi->correo_receptor = 'jorgevadillo@rutamayatravel.com';

			$cfdi->importeRecibo=$importe_pago;

			$response = $cfdi->facturar();

			$factura->response = json_encode($response);

			if ($response[0]==0 || $response==null || $response=='') {
				$error[0]['factura'] = $factura->id_factura;
				$error[0]['error'] = $response[3];
				$error[0]['monto'] = $importe_pago;

							// enviar correo a soporte
				$message2.= 'Error en generacion de Factura: <br><br>'. json_encode($error).'<br><br>'.json_encode($response).'<br><br>'.var_dump($response).'<br><br>'.print_r($response);
				$bandera = false;
				$factura->save();
			}

			if ($response[4]!=null || !empty($response[4])) {
				$error_envio_correo['factura'] = $factura->id_factura;
				$error_envio_correo['error'] = $response[4];
				$error_envio_correo['monto'] = $importe_pago;

				$error_envio_correo['correo'] = 'HA OCURRIDO UN ERROR CON EL ENVIO DE Correo. Por favor, verifique su correo o contacte a RUTA MAYA TRAVEL';
				$bandera = false;
				$message2.= 'Error en envio de correo de Factura: <br><br>'. json_encode($error_envio_correo).'<br><br>'.json_encode($response);
			}

			$importe=$importe_pago/1.16; 
			$iva_recibo=$importe * 0.16;
			$total = $importe * 1.16;

			if (count($error)==0 || empty($error)) {
				$json->id_factura = $factura->id_factura;

				$factura->importe = $importe;
				$factura->subtotal = $importe;
				$factura->iva = $iva_recibo;
				$factura->total = $total;
				$factura->uuid_certificacion = $response[5];
				$factura->fecha_certificacion = $response[6];
				$factura->ruta_local_pdf = "comprobantes/".$response[5].".pdf";
				$factura->ruta_local_xml = "comprobantes/".$response[5].".xml";
				$factura->estatus = "A";
				$factura_detalle->valor_unitario = $importe;
				$factura_detalle->importe = $total*$cfdi_cantidad;
				$factura->save();
				$factura_detalle->save();

				$json->save();
				$bandera=true;
				$message2.= 'Se creo una factura desde WebHook con el id_factura: '.$factura->id_factura;
			}
		}else{
			$bandera = false;
			$message2.= 'Error en factura->save desde WebHook: '.CJSON::encode($factura->getErrors());
		}

		return array('bandera'=>$bandera, 'mensaje'=>$message2);
	}

	public function enviarEmailConfirmacionPago($orden){
		$pago = LogOpenpay::model()->findByPk($orden);
		$agencia = Agencias::model()->findByPk($pago->id_agencia);

		$subject = "Orden de Compra Exitosa";

		// $this->renderPartial('emailConfirmacion', array('pago'=>$pago));
		// exit;

		$mail = new JPhpMailer;
		$mail->IsSMTP();
		$mail->Host = 'rutamayatravel.com'; 
		$mail->SMTPAuth = true;
		$mail->Username = 'no-reply@rutamayatravel.com'; 
		$mail->Port = '26'; 
		$mail->Password = 'Intelred76'; 
		$mail->SMTPKeepAlive = true;  
		$mail->Mailer = "smtp"; 
		$mail->IsSMTP();  
		$mail->SMTPAuth = true;  
		$mail->CharSet = 'utf-8';  
		$mail->SMTPDebug  = 0;
		$mail->SetFrom('no-reply@rutamayatravel.com', 'Ruta Maya Travel'); 
		$mail->Subject = $subject; 
		$mail->AltBody = 'To view the message, please use an HTML compatible email viewer!'; 
		$mail->Body = $this->renderPartial('emailConfirmacion', array('pago'=>$pago),true);
		// $mail->MsgHTML($message);
		$correoLiga = json_decode($pago->request);
		$mail->AddAddress($correoLiga->customer->email);
		$mail->addCC('soporte@rutamayatravel.com');
		$mail->addCC('facturascfdi@rutamayatravel.com');
		if (!empty($agencia->email_agencia)) {
			$mail->addCC($agencia->email_agencia);
		}
		$mail->Send();

	}
	public function mailInterno($liga_pago,$id_usuario,$importe,$ref,$tipo){
		// contabilidad@rutamayatravel.com
		// programador@rutamayatravel.com
		$fechaCreacion = date("d-m-Y H:i:s"); 
		$logusuario = Usuarios::model()->findByPk($id_usuario);
		$encabezados  = "MIME-Version: 1.0\n";
		$encabezados .= "Content-type: text/html; charset=UTF-8\n";
		$encabezados .= "From:  Ruta Maya Travel <no-reply@rutamayatravel.com>\n";
		// $encabezados .= 'Bcc: programador@rutamayatravel.com' . "\r\n";
		$encabezados .= 'cc: soporte@rutamayatravel.com' . "\r\n";
		$encabezados .= "X-Sender: <contacto web>\n";
		$encabezados .= "X-Mailer: PHP\n";
		$encabezados .= "X-Priority: 3\n";
		$encabezados .= "Return-Path: <web page>\n";
		$recipent = 'contabilidad@rutamayatravel.com';
		// $recipent = 'programador3@rutamayatravel.com';
		$subject = "Enlace de Pago Creado";
		if ($liga_pago) {
			$message = "
				<center><b>RUTA MAYA TRAVEL</b><br>
				Se generó un enlace de pago con el metodo de Transferencia InterBancaria SPEI: <br><br>
				<span><a href=".$liga_pago.">".$liga_pago."</a></span><br><br>
				Enlace generado por: ".$logusuario->nombre_usuario."<br><br>
				Por la cantidad de: $ ".number_format($importe,2)."<br><br>
				Referencia: ".$ref."<br><br>
				Tipo: ".$tipo."<br><br>
				Fecha de creacion: ".$fechaCreacion."
				</center>
				
		";
		}else{return false;} 
		mail($recipent,$subject,$message,$encabezados);
	}
	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new LogOpenpay;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['LogOpenpay']))
		{
			$model->attributes=$_POST['LogOpenpay'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}

		$this->render('create',array(
			'model'=>$model,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['LogOpenpay']))
		{
			$model->attributes=$_POST['LogOpenpay'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	public function actionCancelarLiga(){
		$model=$this->loadModel($_POST['id']);
// echo json_encode(array('estatus'=>true));exit;
		if ($model->estatus=='Cargo Creado' || $model->estatus=='Pendiente') {
			$model->estatus = 'Cancelado';
			if($model->save()){
				echo json_encode(array('estatus'=>true));
			}
		}
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		if(Yii::app()->request->isPostRequest)
		{
			// we only allow deletion via POST request
			$this->loadModel($id)->delete();

			// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
			if(!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
		}
		else
			throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');
	}

	/**
	 * Lists all models.
	 */

	public function actionIndex()
	{
            $session=new CHttpSession;
            $session->open();		
            $criteria = new CDbCriteria();            

                $model=new LogOpenpay('search');
                $model->unsetAttributes();  // clear any default values

                if(isset($_GET['LogOpenpay']))
		{
                        $model->attributes=$_GET['LogOpenpay'];
			
			
                   	
                       if (!empty($model->id)) $criteria->addCondition("id = '".$model->id."'");
                     
                    	
                       if (!empty($model->id_reservacion)) $criteria->addCondition("id_reservacion = '".$model->id_reservacion."'");
                     
                    	
                       if (!empty($model->id_recibo)) $criteria->addCondition("id_recibo = '".$model->id_recibo."'");
                     
                    	
                       if (!empty($model->tipo)) $criteria->addCondition("tipo = '".$model->tipo."'");
                     
                    	
                       if (!empty($model->importe)) $criteria->addCondition("importe = '".$model->importe."'");
                     
                    	
                       if (!empty($model->request)) $criteria->addCondition("request = '".$model->request."'");
                     
                    	
                       if (!empty($model->response_liga)) $criteria->addCondition("response_liga = '".$model->response_liga."'");
                     
                    	
                       if (!empty($model->response_pago)) $criteria->addCondition("response_pago = '".$model->response_pago."'");
                     
                    	
                       if (!empty($model->estatus)) $criteria->addCondition("estatus = '".$model->estatus."'");
                     
                    	
                       if (!empty($model->liga_generado)) $criteria->addCondition("liga_generado = '".$model->liga_generado."'");
                     
                    	
                       if (!empty($model->log)) $criteria->addCondition("log = '".$model->log."'");
                     
                    	
                       if (!empty($model->reference)) $criteria->addCondition("reference = '".$model->reference."'");
                     
                    	
                       if (!empty($model->id_factura)) $criteria->addCondition("id_factura = '".$model->id_factura."'");
                     
                    			
                    $session['LogOpenpay_records']=LogOpenpay::model()->findAll($criteria); 
		}
       

                $this->render('index',array(
			'model'=>$model,
		));

	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new LogOpenpay('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['LogOpenpay']))
			$model->attributes=$_GET['LogOpenpay'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model=LogOpenpay::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='log-openpay-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
        public function actionGenerateExcel()
	{
            $session=new CHttpSession;
            $session->open();		
            
             if(isset($session['LogOpenpay_records']))
               {
                $model=$session['LogOpenpay_records'];
               }
               else
                 $model = LogOpenpay::model()->findAll();

		
		Yii::app()->request->sendFile(date('YmdHis').'.xls',
			$this->renderPartial('excelReport', array(
				'model'=>$model
			), true)
		);
	}
        public function actionGeneratePdf($id) 
	{
           $session=new CHttpSession;
           $session->open();
		Yii::import('application.extensions.bootstrap.gii.*');
		require_once('bootstrap/tcpdf/tcpdf.php');
		require_once('bootstrap/tcpdf/config/lang/eng.php');
		$model = LogOpenpay::model()->findByPk($id);
		$html = $this->renderPartial('expenseGridtoReport', array(
			'model'=>$model
		), true);
		
		//die($html);
		
		$pdf = new TCPDF();
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor(Yii::app()->name);
		$pdf->SetTitle('LogOpenpay Report');
		$pdf->SetSubject('LogOpenpay Report');
		//$pdf->SetKeywords('example, text, report');
		$pdf->SetHeaderData('', 0, "Report", '');
		$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, "Example Report by ".Yii::app()->name, "");
		$pdf->setHeaderFont(Array('helvetica', '', 8));
		$pdf->setFooterFont(Array('helvetica', '', 6));
		$pdf->SetMargins(15, 18, 15);
		$pdf->SetHeaderMargin(5);
		$pdf->SetFooterMargin(10);
		$pdf->SetAutoPageBreak(TRUE, 0);
		$pdf->SetFont('dejavusans', '', 7);
		$pdf->AddPage();
		$pdf->writeHTML($html, true, false, true, false, '');
		$pdf->LastPage();
		$pdf->Output("LogOpenpay_002.pdf", "I");
	}
}
