<?php

class HotelesController extends Controller
{
	public $layouts = "//layouts/ansonika_site";
	public function accessRules()
	{
		return array(
			array(
				'allow',  // allow all users to perform 'index' and 'view' actions
				'actions' => array('getHoteles', 'getHotel'),
				'users' => array('*'),
			),
			array(
				'allow',  // allow all users to perform 'index' and 'view' actions
				'actions' => array('pdf'),
				'users' => array('@'),
			),
			array(
				'deny',  // deny all users
				'users' => array('*'),
			),

		);
	}
	public function actionGetHoteles($destino = null)
	{
		header('Access-Control-Allow-Origin: *');
		header("Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept");
		header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE');
		$criteria = new CDbCriteria();


		$criteria->addCondition('visibilidad=1');
		$criteria->addCondition('tipo_paquete="Bodas"');
		$criteria->addCondition('fecha_vigencia >='.date("Y-m-d"));
		$model_paquetes = PaquetesBoda::model()->findAll($criteria);

		$item = array();
		foreach ($model_paquetes as $key => $data) {
			$model_hotel = Hoteles::model()->find('id_hotel=' . $data['id_hotel']);
			$model_foto_hotel = HotelesFotos::model()->find('id_hotel=' . $data['id_hotel'] . ' and boda = 1');
		
			if($destino != null){
				if($model_hotel->id_destinoLocal == $destino){
					$item[$key]["id_paquete"] = $data->id_paquete;
					$item[$key]["nombre_paquete"] = $data->nombre;
					$item[$key]["precio"] = $data->precio;
					$item[$key]["nom_hotel"] = $model_hotel->nombre_hotel;
					$item[$key]["descripcion_larga"] = $data->info;
					$item[$key]["id_hotel"] = $data->id_hotel;
					$item[$key]["tipo_paquete"] = $data->tipo_paquete;
					$item[$key]["foto_principal"] = $model_foto_hotel['foto'];
					$item[$key]["descripcion_corta"] = $data->descripcion;
					$item[$key]["moneda"] = $data->moneda;
				}
			}else{
				
					$item[$key]["id_paquete"] = $data->id_paquete;
					$item[$key]["nombre_paquete"] = $data->nombre;
					$item[$key]["precio"] = $data->precio;
					$item[$key]["nom_hotel"] = $model_hotel->nombre_hotel;
					$item[$key]["descripcion_larga"] = $data->info;
					$item[$key]["id_hotel"] = $data->id_hotel;
					$item[$key]["foto_principal"] = $model_foto_hotel['foto'];
					$item[$key]["tipo_paquete"] = $data->tipo_paquete;
					$item[$key]["descripcion_corta"] = $data->descripcion;
					$item[$key]["moneda"] = $data->moneda;
			
			}
			
	
		}




		echo CJSON::encode($item);
	}
	public function actionGetHotel($idpaquete)
	{
		header('Access-Control-Allow-Origin: *');
		header("Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept");
		header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE');
		$criteria = new CDbCriteria();

		$criteria->addCondition('id_paquete=' . $idpaquete);
		$criteria->addCondition('visibilidad=1');
		$criteria->addCondition('fecha_vigencia >='.date("Y-m-d"));
		$model_paquetes = PaquetesBoda::model()->findAll($criteria);

		$item = array();
		foreach ($model_paquetes as $key => $data) {
			$model_hotel = Hoteles::model()->find('id_hotel=' . $data['id_hotel']);
			$model_foto_hotel = HotelesFotos::model()->findAll('id_hotel=' . $data['id_hotel'] . ' and boda = 1');
			$model_videos_hotel = HotelesVideos::model()->findAll('id_hotel=' . $data['id_hotel'] . ' and estatus = 1');
			$model_destinos = Destinos::model()->find('id_destino='.$model_hotel->id_destinoLocal.' and estatus = 1');

			
			$item[$key]["destinoLocal"] = $model_destinos->destino;	
			$item[$key]["id_destino"] = $model_hotel->id_destinoLocal;	
			$item[$key]["nombre_paquete"] = $data->nombre;
			$item[$key]["nom_hotel"] = $model_hotel->nombre_hotel;
			$item[$key]["descripcion_larga"] = $data->info;
			$item[$key]["descripcion_corta"] = $data->descripcion;
			$item[$key]["precio"] = $data->precio;
			
			$item[$key]["id_paquete"] = $data->id_paquete;
			
			$item[$key]["id_hotel"] = $data->id_hotel;
			$item[$key]["tipo_paquete"] = $data->tipo_paquete;
			$item[$key]["fotos_hotel"] = $model_foto_hotel;
			$item[$key]["video_hotel"] = $model_videos_hotel;
		}




		echo CJSON::encode($item);
	}
	
}
