<?php
Yii::import('application.extensions.phpmailer.JPhpMailer');

class GuestsWeddingsController extends Controller {
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column1';

	/**
	 * @return array action filters
	 */
	public function filters() {
		return array(
			'accessControl', // perform access control for CRUD operations
			array(
                'ext.starship.RestfullYii.filters.ERestFilter + 
                REST.GET, REST.PUT, REST.POST, REST.DELETE'
            ),
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules() {
		return array(
			array('allow', 'actions'=>array('REST.GET', 'REST.PUT', 'REST.POST', 'REST.DELETE'),
				'users'=>array('@'),
			),
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('@'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update','GeneratePdf','GenerateExcel', 'sendInvitation', 'sendAllInvitations', 'echoTest', 'importGuestsFromCSV'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	public function actions() {
        return array('REST.'=>'ext.starship.RestfullYii.actions.ERestActionProvider',);
	}

	public function actionEchoTest($id_guest_wedding) {
		$model_guest = GuestsWeddings::model()->findByPk($id_guest_wedding);
		$model_event = EventsWeddings::model()->findByPk($model_guest->id_event_wedding);
		$model_boda = Bloqueos::model()->findByPk($model_event->id_bloqueo);
		# echo $_SERVER['DOCUMENT_ROOT'] ." - baseUrl -". Yii::app()->baseUrl;

		$path_img = $_SERVER['DOCUMENT_ROOT'] ."/medios/bodas/". $model_event->invitacion_img;
		$path_info = pathinfo($path_img);
		$img_name =  'Invitacion '. $model_boda->novios .'.'. $path_info["extension"];
		echo "<p>". $path_img ."</p>";
		echo "<p>". $img_name ."</p>";
		echo "<p>". json_encode($path_info) ."</p>";

		$message = $model_event->invitacion_text;

		if(strpos($message, "##nombre##")) {
			echo "##nombre##";
			$message = str_replace("##nombre##", $model_guest->nombre ." ". $model_guest->apellidos, $message);
		}

		if(strpos($message, "##novios##")) {
			echo "##novios##";
			$message = str_replace("##novios##", $model_boda->novios, $message);
		}

		if(strpos($message, "##fecha##")) {
			echo "##fecha##";
			$str = "de ". date("d/m/yy", strtotime($model_boda->fecha_inicio))." al ". date("d/m/yy", strtotime($model_boda->fecha_final));
			$message = str_replace("##fecha##", $str, $message);
		}

		if(strpos($message, "##hotel##")) {
			echo "##hotel##";
			$message = str_replace("##hotel##", $model_boda->idHotel->nombre_hotel, $message);
		}

		if(strpos($message, "##no_invitados##")) {
			echo "##no_invitados##";
			$message = str_replace("##no_invitados##", "2", $message);
		}
		echo $message;
	}

	public function actionSendInvitation($id_guest_wedding) {
		if($this->sendInvitationEW($id_guest_wedding) == true) {
			echo json_encode(array(
				"success" => true,
			));
		} else {
			echo json_encode(array(
				"success" => false,
			));
		}
	}

	public function actionSendAllInvitations($id_event_weeding) {
		$model_guest = GuestsWeddings::model()->findAll("id_event_wedding = ". $id_event_weeding);
		$array_response = array(); $success = true;
		foreach ($model_guest as $guest) {
			if($guest->envio_invitacion == 0) {
				$response = $this->sendInvitationEW($guest->id_guest_wedding);
				if($response == false) $success = false;
				$guest_name = $guest->nombre ." ". $guest->apellidos;
				array_push($array_response, array(
					success => $response,
					guest => $guest_name
				));
			}
		}
		echo json_encode(array(
			success => $success,
			response => $array_response
		));
	}

	public function sendInvitationEW($id_guest_wedding) {
		$model_guest = GuestsWeddings::model()->findByPk($id_guest_wedding);
		$model_event = EventsWeddings::model()->findByPk($model_guest->id_event_wedding);
		$model_boda = Bloqueos::model()->findByPk($model_event->id_bloqueo);

		$mail = new JPhpMailer;
		$mail->IsSMTP();
		$mail->Host = 'rutamayatravel.com'; 
		$mail->SMTPAuth = true;
		$mail->Username = 'no-reply@rutamayatravel.com'; 
		$mail->Port = '26'; 
		$mail->Password = 'Intelred76';
		$mail->SMTPKeepAlive = true;  
		$mail->Mailer = "smtp"; 
		$mail->IsSMTP();  
		$mail->SMTPAuth = true;  
		$mail->CharSet = 'utf-8';  
		$mail->SMTPDebug  = 0;

		$mail->SetFrom('no-reply@rutamayatravel.com', 'Eventos Ruta Maya Travel');
		//$mail->AddReplyTo(Yii::app()->user->email);

		$mail->Subject = "Invitación a boda de ". $model_boda->novios; 
		$mail->AltBody = 'To view the message, please use an HTML compatible email viewer!';
		// $message = str_replace("**nombre**", $model_guest->nombre ." ". $model_guest->apellidos, $invitacion_text);
		$message = $model_event->invitacion_text;

		if(strpos($message, "##nombre##")) {
			$message = str_replace("##nombre##", $model_guest->nombre ." ". $model_guest->apellidos, $message);
		}

		if(strpos($message, "##novios##")) {
			$message = str_replace("##novios##", $model_boda->novios, $message);
		}

		if(strpos($message, "##fecha##")) {
			$str = "de ". date("d/m/yy", strtotime($model_boda->fecha_inicio))." al ". date("d/m/yy", strtotime($model_boda->fecha_final));
			$message = str_replace("##fecha##", $str, $message);
		}

		if(strpos($message, "##hotel##")) {
			$message = str_replace("##hotel##", $model_boda->idHotel->nombre_hotel, $message);
		}

		if(strpos($message, "##no_invitados##")) {
			$message = str_replace("##no_invitados##", "2", $message);
		}

		$mail->MsgHTML($message);
		$mail->AddAddress($model_guest->email, ($model_guest->nombre ." ". $model_guest->apellidos));
		// $mail->AddAddress("programador4@rutamayatravel.com", "programador");
		// $mail->AddBCC("programador4@rutamayatravel.com");
		$mail->AddBCC('jorgevadillo@rutamayatravel.com');
		
		/* $invitacion = $this->generarInvitacion($model_event->id_events_weddings);
		$mail->addStringAttachment($invitacion, 'InvitacionFamHuatulco.pdf'); */
		$path_img = $_SERVER['DOCUMENT_ROOT'] ."/medios/bodas/". $model_event->invitacion_img;
		$path_info = pathinfo($path_img);
		$img_name =  'Invitacion-'. str_replace(" ", "-", $model_boda->novios) .'.'. $path_info["extension"];
 		$mail->addAttachment($path_img, $img_name);
		if($mail->Send()) {
			$model_guest->envio_invitacion = 1;
			$model_guest->save();
			return true;
		} else {
			return false;
		}
	}

	public function generarInvitacion($id_event_weeding) {
		Yii::import('application.extensions.bootstrap.gii.*');
		require_once('bootstrap/tcpdf/tcpdf.php');
		require_once('bootstrap/tcpdf/config/lang/eng.php');
		
		/* $html = $this->renderPartial('_invitacionEvent', array(
			'model_event_guest'=>$model_event_guest,
			'model_guest'=>$model_guest,
			'model_agencia' => $model_agencia,
		), true); */
		$html = "";

		$pdf = new TCPDF();
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor(Yii::app()->name);
		$pdf->SetTitle('Invitación');
		$pdf->SetSubject('Invitación');
		$pdf->setPrintHeader(false);
		$pdf->setPrintFooter(false);
		$pdf->SetMargins(30, 55, 30);
		$pdf->SetHeaderMargin(10);
		$pdf->SetFooterMargin(10);
		$pdf->SetAutoPageBreak(TRUE, 0);
		$pdf->SetFont('dejavusans', '', 7);
		$pdf->AddPage();
		// get the current page break margin
		$bMargin = $pdf->getBreakMargin();
		// get current auto-page-break mode
		$auto_page_break = $pdf->getAutoPageBreak();
		// disable auto-page-break
		$pdf->SetAutoPageBreak(false, 0);

		// set background image
		$model_event = EventsWeddings::model()->findByPk($id_event_weeding);
		$img_file = K_PATH_IMAGES . $model_event->invitacion_img;

		//$pdf->Image($img_file, 0, 0, 210, 180, '', '', '', false, 300, '', false, false, 0);
		$pdf->Image($img_file, 0, 0, 210, 0, '', '', '', false, 300, '', false, false, 0);
		// restore auto-page-break status
		$pdf->SetAutoPageBreak($auto_page_break, $bMargin);
		// set the starting point for the page content
		$pdf->setPageMark();

		$pdf->writeHTML($html, true, false, true, false, '');
		$pdf->LastPage();
		return $pdf->Output("invitacion.pdf", "S");
	}

	public function actionImportGuestsFromCSV() {
		$array_guest = json_decode($_POST["guestsWedding_csv"], true);
		$id_event_wedding = $_POST["id_event_wedding"];
		$success = true;
		$array_respose = array(
			success => true,
			errors => array()
		);
		foreach ($array_guest as $key => $guest) {
			$model_gw = new GuestsWeddings;
			$model_gw->attributes = $guest;
			if($model_gw->save()) {
			} else {
				$array_respose->success = false;
				array_push($array_respose->errors, $model_gw->getErrors());
			}
		}
		echo json_encode($array_respose);
	}

	/**
	* Displays a particular model.
	* @param integer $id the ID of the model to be displayed
	*/
	public function actionView($id)	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate() {
		$model=new GuestsWeddings;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['GuestsWeddings'])) {
			$model->attributes=$_POST['GuestsWeddings'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id_guests_weddings));
		}

		$this->render('create',array(
			'model'=>$model,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id) {
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['GuestsWeddings'])) {
			$model->attributes=$_POST['GuestsWeddings'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id_guests_weddings));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id) {
		if(Yii::app()->request->isPostRequest) {
			// we only allow deletion via POST request
			$this->loadModel($id)->delete();

			// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
			if(!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
		}
		else
			throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex() {
		$session=new CHttpSession;
		$session->open();		
		$criteria = new CDbCriteria();            

		$model=new GuestsWeddings('search');
		$model->unsetAttributes();  // clear any default values

		if(isset($_GET['GuestsWeddings'])) {
			$model->attributes=$_GET['GuestsWeddings'];
                   	
			if (!empty($model->id_guests_weddings)) $criteria->addCondition("id_guests_weddings = '".$model->id_guests_weddings."'");
			
			if (!empty($model->nombre)) $criteria->addCondition("nombre = '".$model->nombre."'");
	
			if (!empty($model->telefono)) $criteria->addCondition("telefono = '".$model->telefono."'");
			
			if (!empty($model->email)) $criteria->addCondition("email = '".$model->email."'");
                    	
			if (!empty($model->id_events_weddings)) $criteria->addCondition("id_events_weddings = '".$model->id_events_weddings."'");
                    			
			$session['GuestsWeddings_records']=GuestsWeddings::model()->findAll($criteria); 
		}

		$this->render('index',array(
			'model'=>$model,
		));

	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin() {
		$model=new GuestsWeddings('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['GuestsWeddings']))
			$model->attributes=$_GET['GuestsWeddings'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id) {
		$model=GuestsWeddings::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model) {
		if(isset($_POST['ajax']) && $_POST['ajax']==='guests-weddings-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}

	public function actionGenerateExcel() {
		$session=new CHttpSession;
		$session->open();		
            
		if(isset($session['GuestsWeddings_records'])) {
			$model=$session['GuestsWeddings_records'];
		}
		else
			$model = GuestsWeddings::model()->findAll();
		
		Yii::app()->request->sendFile(date('YmdHis').'.xls',
			$this->renderPartial('excelReport', array(
				'model'=>$model
			), true)
		);
	}

	public function actionGeneratePdf() {
		$session=new CHttpSession;
		$session->open();
		Yii::import('application.extensions.bootstrap.gii.*');
		require_once('bootstrap/tcpdf/tcpdf.php');
		require_once('bootstrap/tcpdf/config/lang/eng.php');

		if(isset($session['GuestsWeddings_records'])) {
			$model=$session['GuestsWeddings_records'];
		}
		else
			$model = GuestsWeddings::model()->findAll();

		$html = $this->renderPartial('expenseGridtoReport', array(
			'model'=>$model
		), true);
		
		//die($html);
		
		$pdf = new TCPDF();
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor(Yii::app()->name);
		$pdf->SetTitle('GuestsWeddings Report');
		$pdf->SetSubject('GuestsWeddings Report');
		//$pdf->SetKeywords('example, text, report');
		$pdf->SetHeaderData('', 0, "Report", '');
		$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, "Example Report by ".Yii::app()->name, "");
		$pdf->setHeaderFont(Array('helvetica', '', 8));
		$pdf->setFooterFont(Array('helvetica', '', 6));
		$pdf->SetMargins(15, 18, 15);
		$pdf->SetHeaderMargin(5);
		$pdf->SetFooterMargin(10);
		$pdf->SetAutoPageBreak(TRUE, 0);
		$pdf->SetFont('dejavusans', '', 7);
		$pdf->AddPage();
		$pdf->writeHTML($html, true, false, true, false, '');
		$pdf->LastPage();
		$pdf->Output("GuestsWeddings_002.pdf", "I");
	}
}