<?php
header('Access-Control-Allow-Origin: *');
header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");

Yii::import('application.extensions.bootstrap.gii.*');
$_SESSION["timeTS"]=date("Y-m-d his");
// require_once('bootstrap/tcpdf/tcpdf.php');
// require_once('bootstrap/tcpdf/config/lang/eng.php');
require_once('../api/travelsolution/TravelSolution.php');
require_once('../api/beds/HotelApi.php');

class GetTarifasController extends Controller
{
	public function actionIndex()
	{
		$this->render('index');
	}

	public function getErrores($messageErrors,$habs,$fecha_inicial){
		$mensajeError="No hay tarifa disponible para las fechas cotizadas. ";
		switch ($messageErrors[0]) {
			case '@ERR:007':
			$caso = explode('[',$messageErrors[1]);
			// echo "2".$caso[0];
			switch ($caso[0]) {
				case 'ROOM_UNAVAILABLE':
				// Habitaciones sin disponibilidad
				$mensajeError.= "Las fechas cotizadas están cerradas.";
				break;
				case 'INVALID_ROOM_CATEGORY':
				$mensajeError.= "Categoría de cuarto es inválido.";
				break;
				case 'PROPERTY_RESTRICTED':
				// Propiedad Restringida
				$mensajeError.= "Las fechas cotizadas están cerradas.";
				break;
				case 'ROOM_RESTRICTED':
				// Habitacion restringida
				$mensajeError.= "Las fechas cotizadas están cerradas.";
				break;
				case 'NUMBER_OF_NIGHTS_MLOS_RESTRICTION':
				$mensajeError.= "Restricción de mínimo de noches.";
				break;
				case 'MAX_OCCUPANCY':
				$mensajeError.="Restricción de máximo de ocupantes.";
				break;
				default:
				$mensajeError = "No hay tarifa disponible para la fechas cotizadas. Por Favor modifique su busqueda.";
				break;
			}
			break;
			case '@ERR:004':
			$mensajeError.= "Debe tener un mínimo de 7 dias de anticipación";
			break;
			case '@err:004':
			$mensajeError.= "Debe tener un mínimo de 7 dias de anticipación";
			break;
			case 'err:004':
			$mensajeError.= "Debe tener un mínimo de 7 dias de anticipación";
			break;
			case '@ERR:000':
			$mensajeError = "No hay tarifa disponible para ".$habs." Habitaciones con el número de ocupantes cotizadas";
			break;
			default:
			$caso = explode('dia',$messageErrors[0]); 
			$fecha_iFormat = date("d/m/Y", strtotime($fecha_inicial));
			switch ($caso[0]) {
				case 'No existe Contrato o Codigo de promocion disponible para el ':
					// $mensajeError = 'No existe Contrato o Codigo de promocion disponible para el dia '.$fecha_iFormat;
				$mensajeError = 'Tiene restricción de mínimo 3 noches para poder reservar.';
				break;
				case 'No existe tarifa capturada para el ':
				$mensajeError = 'No existe tarifa capturada para el dia '.$fecha_iFormat;
				break;
				default:
				$mensajeError = "No hay tarifa disponible para las fechas cotizadas. Por Favor modifique su busqueda";
				break;
			}
			break;
		}
		return $mensajeError;
	}

	public function actionObtenerTarifas(){
		header('Access-Control-Allow-Origin: *');
		header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
		header('Content-Type: application/json; charset=utf-8');

		$session=new CHttpSession;
		$session->open();

		if (isset($_POST["proveedor"])) {
			$resultadoBusquedaHoteles = json_decode($_POST["habitacionesRQ"]);
			$session = json_decode($_POST["front_form"],true);

			if ($session["id_tipoPlan"]!=null) {
				$planHotel = Plan::model()->findByPk($session["id_tipoPlan"]);
				$session["tipoPlan"] = $planHotel;	
			}else{
				$session["tipoPlan"] = null;
			}

			$hotelesKilling = array(); //reemplaza a $_SESSION['data']
			$msgError = array(); //reemplaza a $_SESSION['msgError']
			$dataSuggestions = array(); //reemplaza a $_SESSION['dataSuggestions']
			$dataSuggestionsSames = array(); //reemplaza a $_SESSION['dataSuggestionsSames']
			$responseWs = array(); //almacenara todos los arreglos (sesiones) para su retorno de la WS

			$siteController = Yii::app()->createController('site');
			$siteController = $siteController[0];
			$busquedaController = Yii::app()->createController('busqueda');
			$busquedaController = $busquedaController[0];
			$reservacionController = Yii::app()->createController('reservacion');
			$reservacionController = $reservacionController[0];
			$outletController = Yii::app()->createController('outlet');
			$outletController = $outletController[0];
			$destacadosController = Yii::app()->createController('hotelesDestacados')[0];
			$outlet=Outlet::model()->find("estatus=1");
			$tarifaOutlet=$outletController->validacionTarifas($outlet,$session);
			$noOutletPrecios=array('PROMOGRUPOS', 'OUTLETGRUPOS', 'OUTLETBODAS', 'OUTLET');
			$hoteles = json_decode($_POST["hotelesRQ"]);

			$fecha_inicial_buen_fin = "2019-11-15";
			$fecha_final_buen_fin = "2019-11-20";
			$fecha_actual = date('Y-m-d');

			$contarHotel = $resultadoBusquedaHoteles->totalHoteles;

			$i_tarifas=0;
			$cuartospalace=0;
			$tipohab="";
			$codigosHoteles = array();
			$palaceResorts=array('BP','CZ','IM','LBC','MPS','PL','SP','MPG');

			$propios["hotels"]["hotels"]=array();

			$mapaDestinos=array();
			$hotelesOcultar=array();
			if (!empty($_POST["hotelesRQ"])) {
				switch ($_POST["proveedor"]) {
					case 0:

						try{
							$tarifaspropias = array();
							// $session = json_decode($_POST["front_form"],true);
							$resultadoBusquedaHoteles = json_decode($_POST["habitacionesRQ"],true);

							$hora = "and curtime() between hora_inicio and hora_final";
							$fecha_promo = "and (current_date between fecha_promo_inicio and fecha_promo or fecha_promo>='".date('Y-m-d')."')";
							$fecha_promo = "and current_date between fecha_promo_inicio and fecha_promo";
							$early_booking = "and(early_booking is null or DATEDIFF('".$resultadoBusquedaHoteles["fecha_inicial"]."',current_date) <= early_booking)";
							$diff_de_bloqueo = 'and "'.$resultadoBusquedaHoteles['fecha_inicial'].'" between t.fecha_inicial and t.fecha_final';

							$resultadoBusquedaHoteles["hora"] = $hora;
							$resultadoBusquedaHoteles["early_booking"] = $early_booking;
							$resultadoBusquedaHoteles["fecha_promo"] = $fecha_promo;
						
							if ($session["outlet"]=="outlet") {
								$tipoPrecio = array('OUTLET');
								
							}else if($session['outlet']=="grupos"){
								$tipoPrecio = array('OUTLETGRUPOS');
								
							}else if ($session['outlet']=="bodas") {
								$tipoPrecio = array('OUTLETBODAS');
							}else{
								$tipoPrecio = array('PROMO','NORMAL','VIP','PROMOGRUPOS','OUTLET');

								
								if (isset($session['hotelesIguales'])) {
									if ($session['hotelesIguales']==true) {
										array_push($tipoPrecio,'BLOQUEO');
									}
								}
							}

							$vip=TarifaAgencia::model()->find("id_agencia=".$session["agenciaUsuario"]);

							if($session["agenciaUsuario"] != 9 && !$vip && !isset($session['hotelesIguales'])){
								// $tarifaAgencias = 'and not exists(select NULL from tbl_tarifa_agencia tarifaAgencias where tarifaAgencias.id_tarifa=t.id_tarifa and tarifaAgencias.id_agencia!='.$session["agenciaUsuario"].')';
								// $agenciaEstadoUsuario = Agencias::model()->findByPk($session["agenciaUsuario"]);
								if(!empty($session['estadoUsuario'])){
									$tarifaEstados = 'and exists(select NULL from tbl_tarifa_estados tarifaEstados where tarifaEstados.id_tarifa=t.id_tarifa and tarifaEstados.id_estado='.$session['estadoUsuario'].')';
								}
							}

							foreach ($hoteles as $killing => $row) {
								$tarifasArray=array();
								$importesArray=array();    				
								$importesArrayUSD=array();    				
								$menorTarifa=0;
								$num_tarifas=0;
								$roomsPalace=array();
								$disponibilidadPalace=null;
								$banderaBootom=false;

								$hotelRmt = Hoteles::model()->findByPk($row->id_hotel);
								$hotelesOutlet = $outletController->hotelesOutlet($row->id_hotel,0,'');
								foreach($tipoPrecio as  $precio) {

									if ($precio=='BLOQUEO') {
										$diff_de_bloqueo = 'and "'.$resultadoBusquedaHoteles['fecha_inicial'].'" = t.fecha_inicial and "'.$resultadoBusquedaHoteles['fecha_final'].'" = t.fecha_final';
									}
									
									$todas = Tarifa::model()->with('tarifaHotel','tarifaDesgloses','tarifaDiasvalidos')->findAll(array('condition'=>'t.id_hotel='.$row->id_hotel.' '.$resultadoBusquedaHoteles['categoria'].' '.$resultadoBusquedaHoteles['tipo_precio'].' '.$resultadoBusquedaHoteles['tipo_plan'].' '.$resultadoBusquedaHoteles['fecha_promo'].' '.$resultadoBusquedaHoteles['hora'].' '.$resultadoBusquedaHoteles['early_booking'].' and "'.$resultadoBusquedaHoteles['fecha_inicial'].'" >= current_date and dia='.date("N",strtotime($resultadoBusquedaHoteles['fecha_inicial'])).' '.$diff_de_bloqueo.' and t.precio IN("'.$precio.'") and t.estatus=1 and id_base_habitacion=2 '.$tarifaAgencias.' '.$tarifaEstados.''));

									foreach($todas as $subrow) {
											// echo "<br>".$subrow->id_tarifa;
										$tipohabs = TipoHabitaciones::model()->with('tarifaDesgloses')->findAll(array('condition'=>'id_hotel='.$row->id_hotel.' and id_tarifa='.$subrow->id_tarifa.' and id_base_habitacion=2 and t.estatus=1','order'=>'precio_normal '.$resultadoBusquedaHoteles["ORDER_PRECIO"].'')); 

										foreach($tipohabs as $habs) {
											if(!empty($habs->id_tipo_habitacion)) {
													// echo "<br>____________".$habs->id_tipo_habitacion;
												$data=json_decode($busquedaController->getPrecio($habs, $subrow->id_tarifa, $row->id_hotel, $resultadoBusquedaHoteles['fecha_inicial'],$resultadoBusquedaHoteles['noches'],false,$resultadoBusquedaHoteles['fecha_final'],$disponibilidadPalace,$session,$outlet));
													// echo json_encode($data);
												if($data->menorTarifa!=0)
												{
													if(!$tarifasArray[$habs->id_tipo_habitacion])
													{
														$tarifasArray[$habs->id_tipo_habitacion]=array();
														$tarifasArray[$habs->id_tipo_habitacion]["menorTarifa"]=0;	                                        
														$tarifasArray[$habs->id_tipo_habitacion]["disponibilidad"]=$data->disponibilidad;
														
													}

													array_push($tarifasArray[$habs->id_tipo_habitacion], array('id_tarifa'=>$subrow->id_tarifa,'menorTarifa'=>$data->menorTarifa,'disponibilidad'=>$data->disponibilidad,'btnColor'=>$data->btnColor,"msgError"=>$data->errores));

													if($tarifasArray[$habs->id_tipo_habitacion]["disponibilidad"]!=true && $data->disponibilidad==true)
														$tarifasArray[$habs->id_tipo_habitacion]["disponibilidad"]=true;

														if (in_array($subrow->precio,$noOutletPrecios)) {
														
														$imagenOutlet="logo-precio-especial-sur4.png";

													}
													if ($tarifaOutlet && !in_array($subrow->precio,$noOutletPrecios) && !$hotelesOutlet) {
														$data->menorTarifa = $outletController->tarifaOutletVirtual($data->menorTarifa,0,$subrow->comision,$outlet->descuento_general);
														$data->menorTarifa_usd = $outletController->tarifaOutletVirtual($data->menorTarifa_usd,0,$subrow->comision,$outlet->descuento_general);
														$imagenOutlet="logo-outlet-verano-web-sur4.png";
													}

													if ($tarifaOutlet && $outletController->hotelesDestacados($outlet,$hotelRmt->id_hotel) == 1) {
														$imagenOutlet="logo-precio-destacado-sur4.png";
													}

													if ($subrow->precio!='PROMOGRUPOS') {
														$importesArray[$data->disponibilidad][]=$data->menorTarifa;
													}

													if ($data->moneda='USD') {
														$importesArrayUSD[$data->disponibilidad][]=$data->menorTarifa_usd;
													}
													$tipo_plan_propio = $data->id_plan;
													$num_tarifas++;
													$i_tarifas++;
												}
											}
										}
									}
								}
								// echo json_encode($importesArray);
								// exit;

								if($importesArray[true]){
									$menorTarifa=min($importesArray[true]);

									if (!empty($importesArrayUSD)) {
										$menorTarifaUSD=min($importesArrayUSD[true]);
									}
					    				//$noDisponible=true;
									$disponibilidadHotel=true;
								}else
								{
									$menorTarifa=min($importesArray[false]);

									if (!empty($importesArrayUSD)) {
										$menorTarifaUSD=min($importesArrayUSD[false]);
									}
					    				//$noDisponible=false;
									$disponibilidadHotel=false;
										// $hotelesOcultar[]=$row->id_hotel;
								}

								if($importesArray[false])
									$banderaBootom=true;

								if ($num_tarifas>0) 
								{
									$menorTarifaRMT = $menorTarifa;
									$menorTarifaUSD = $menorTarifaUSD;
									$row->precio=$menorTarifa;

									if($resultadoBusquedaHoteles["filtro_disponibilidad"]==true)
									{
										if($disponibilidadHotel!=true)
											$row->precio=0;
									}

									if (isset($session['tipoPrecioBloqueo'])) {
										if ($session['tipoPrecioBloqueo']=='BLOQUEO') {
											$contarHotel=1;
										}
									}


									if($row->precio==0 && $contarHotel>1)
									{	
										unset($hoteles->$killing);
									}else
									{
										$hotelRmt->precio = $row->precio; 
										array_push($propios["hotels"]["hotels"], array('id_hotel'=>$row->id_hotel,'menorTarifa'=>$menorTarifa,'banderaBootom'=>$banderaBootom,'num_tarifas'=>$num_tarifas,'disponibilidadHotel'=>$disponibilidadHotel,'rooms'=>$tarifasArray, 'tipo_plan'=> (int) $tipo_plan_propio));
										$planPropias[$row->id_hotel][] = (int) $tipo_plan_propio;
											// $mapaDestinos[]=$siteController->addMapDestination($hotelRmt);
									}
										// echo "<br>row->precio".$row->precio;
								}else
								{
									if (isset($session['tipoPrecioBloqueo'])) {
										if ($session['tipoPrecioBloqueo']=='BLOQUEO') {
											$contarHotel=1;
										}
									}


									if ($contarHotel>1) 
									{
										unset($hoteles->$killing);
									}else{
										array_push($propios["hotels"]["hotels"], array('id_hotel'=>$row->id_hotel,'menorTarifa'=>$menorTarifa,'banderaBootom'=>$banderaBootom,'num_tarifas'=>$num_tarifas,'disponibilidadHotel'=>$disponibilidadHotel,'rooms'=>$tarifasArray,'tipo_plan'=> (int) $tipo_plan_propio));
										$planPropias[$row->id_hotel][] = (int) $tipo_plan_propio;
									}
								}

									//////////////////////////////////////////////////////////////////////////
									// CODIGO PROGRAMADO EN COTIZACIONRAPIDA RMT E ITEMCOTIZACIONRAPIDA RMT //
									//////////////////////////////////////////////////////////////////////////

								if ($hoteles->$killing) {
									$arrHotel=$propios["hotels"]["hotels"];
									$key = array_search($row->id_hotel, array_column($arrHotel, 'id_hotel'));   
									$resultHotel=$propios["hotels"]["hotels"][$key];
									$filtro_disponibilidad = $resultadoBusquedaHoteles["filtro_disponibilidad"];
									$i_cotiza=0;
									$primeraTarifa="";
									$disponibilidadHotel = $resultHotel["disponibilidadHotel"];
									$menorTarifa = $resultHotel["menorTarifa"];
									$hotel=$hotelRmt;

									if (isset($session['tipoPrecioBloqueo'])) {
										if ($session['tipoPrecioBloqueo']=='BLOQUEO') {
											$tipo_precio='BLOQUEO';
										}
									}
									
									// exit;

									foreach ($resultHotel["rooms"] as $key => $fila)
									{ 
										uasort($resultHotel["rooms"][$key], 'sort_by_orden');
										$resultHotel["rooms"][$key]["menorTarifa"]=$resultHotel["rooms"][$key][0]["menorTarifa"];
									}

										// echo "<br>".$hotelRmt->id_hotel."????".$hotelRmt->nombre_hotel;

									$tarifaRmt[$hotelRmt->id_hotel]['id_hotel'] = $hotelRmt->id_hotel; 
									$tarifaRmt[$hotelRmt->id_hotel]['nombre_hotel'] = $hotelRmt->nombre_hotel; 
									$tarifaRmt[$hotelRmt->id_hotel]['destacado'] = $destacadosController->hotelesDestacados($hotelRmt->id_hotel); 	
									$tarifaRmt[$hotelRmt->id_hotel]['beneficio'] = $hotelRmt->Beneficios->beneficio; 
									$tarifaRmt[$hotelRmt->id_hotel]['code_hotel'] = $hotelRmt->codigo; 
									$tarifaRmt[$hotelRmt->id_hotel]['markup'] = $hotelRmt->comision; 
									$tarifaRmt[$hotelRmt->id_hotel]['observaciones'] = $hotelRmt->observaciones;
									$tarifaRmt[$hotelRmt->id_hotel]['ubicacion'] = $hotelRmt->ubicacion;
									$tarifaRmt[$hotelRmt->id_hotel]['estrellas'] = (int) $hotelRmt->id_categoria;
									$tarifaRmt[$hotelRmt->id_hotel]['proveedor'] = $hotelRmt->proveedor;
									$tarifaRmt[$hotelRmt->id_hotel]['destino']['name'] = $hotelRmt->Destino->name;
									$tarifaRmt[$hotelRmt->id_hotel]['alerta_disponibilidad'] = $hotelRmt->alerta_disponibilidad;
									$tarifaRmt[$hotelRmt->id_hotel]['destino']['destinationsCode0'] = $hotelRmt->Destino->destinationsCode0->name;
									$tarifaRmt[$hotelRmt->id_hotel]['destino']['zonasCode'] = $hotelRmt->Destino->idZona;
									$tarifaRmt[$hotelRmt->id_hotel]['foto'] = $siteController->getNameProveedor($hotelRmt->id_hotel,$hotelRmt->proveedor);
									$tarifaRmt[$hotelRmt->id_hotel]['imagenOutlet'] = $imagenOutlet;

									$tarifasHotel=json_decode(json_encode($resultHotel));

									$comparar='return $b->menorTarifa - $a->menorTarifa;';
									uasort($tarifasHotel->rooms, create_function('$a,$b', $comparar));

										// echo json_encode($tarifasHotel);
										// exit;
										
									if (isset($menorTarifa)) {
										$cuarto=0;
										// $temasFiltros = '';
										$temasFiltros = array();

										$planesArray = array();
										$hotelesPlanes = array();

										foreach ($tarifasHotel->rooms as $key => $row) {
											$tipohab = TipoHabitaciones::model()->findByPk($key);

											if($tipohab->id_tipo_habitacion)
											{

												$ocultarTarifa=false;
												if ($row->disponibilidad!=true) {
													$ocultarTarifa=true;
													$reservar=0;
													$allotment=0;
												}else{
													$reservar=1;
													$allotment=1;
												}
													// echo $key."___--";
												$tarifaRmt[$hotelRmt->id_hotel]["Habitaciones"][$cuarto]["tipo_hab"] = $tipohab->id_tipo_habitacion;
												$tarifaRmt[$hotelRmt->id_hotel]["Habitaciones"][$cuarto]["nombre_hab"] = $tipohab->tipo_habitacion;
												$tarifaRmt[$hotelRmt->id_hotel]["Habitaciones"][$cuarto]["id_tipo_habitacion"] = $tipohab->id_tipo_habitacion;
												$tarifaRmt[$hotelRmt->id_hotel]["Habitaciones"][$cuarto]["allotment"] = $allotment;
												$tarifaRmt[$hotelRmt->id_hotel]["Habitaciones"][$cuarto]["reservar"] = $reservar;
												$tarifaRmt[$hotelRmt->id_hotel]["Habitaciones"][$cuarto]["ratekey"] = "RMT";
												$tarifaRmt[$hotelRmt->id_hotel]["Habitaciones"][$cuarto]["info_habitacion"] = "";
												$tarifaRmt[$hotelRmt->id_hotel]["Habitaciones"][$cuarto]["habitaciones"] = "";
												$tarifaRmt[$hotelRmt->id_hotel]["Habitaciones"][$cuarto]["ocultarTarifa"] = $ocultarTarifa;
													// echo "<br>".$tipohab->tipo_habitacion."<br>";
												$i_room=0;
												foreach ($row as $keys => $subrow) {
													if ($subrow->id_tarifa) {
														$tarifa = Tarifa::model()->findByPk($subrow->id_tarifa);
														// $outlet=Outlet::model()->find("estatus=1 AND solo_agencias=1");
														$id_estado_agencia=Agencias::model()->findByPk($session["agenciaUsuario"])->id_estado_agencia;

														if($tarifa->precio=="OUTLET")
														{
															$in='"OUTLET","NORMAL"';
														}
														else if($tarifa->precio=="PROMO")
														{
															$in='"PROMO","NORMAL"';

														}else if($tarifa->precio=="PROMOGRUPOS")
														{
															$in='"PROMOGRUPOS"';

														}else if($tarifa->precio=="NORMAL")
														{
															$in='"NORMAL","PROMO","OUTLET","VIP"';
														}else if($tarifa->precio=="BLOQUEO"){
															$in='"BLOQUEO"';
														}

														if (!in_array((int) $tarifa->tarifaPlan->id_plan,$planesArray)) {
															array_push($planesArray,(int) $tarifa->tarifaPlan->id_plan);
															$hotelesPlanes[] = $tarifa->tarifaPlan->nombre;
														}

														if ($tarifaOutlet && !in_array($tarifa->precio,$noOutletPrecios) && !$hotelesOutlet) {
															$subrow->menorTarifa = $outletController->tarifaOutletVirtual($subrow->menorTarifa,0,$tarifa->comision,$outlet->descuento_general);
														}

														if ($menorTarifa==$subrow->menorTarifa && $primeraTarifa=="" && $disponibilidadHotel==$subrow->disponibilidad) 
														{
															$primeraTarifa="OK";

															$tarifaRmt[$hotelRmt->id_hotel]["Habitaciones"][$cuarto]["ocultarTarifa"] = false;

															$habitacionPrimeraTarifa=$tipohab->tipo_habitacion;
															$planPrimeraTarifa=$tarifa->tarifaPlan->nombre;
										
															$monedaPrimeraTarifa = ($tarifa->tipo_cambio!=0 && $tarifa->mostrar_conversion == 1) ? 'MXN': $tarifa->moneda;

															if($monedaPrimeraTarifa!="MXN"){
																$menorTarifa=$menorTarifa/$tarifa->tasa_cambio;
															}
															$tarifaRmt[$hotelRmt->id_hotel]["Desglose"]["tarifas"] = $tarifasHotel->num_tarifas;
															$tarifaRmt[$hotelRmt->id_hotel]["Desglose"]["mejorHabitacion"] = $habitacionPrimeraTarifa;
															$tarifaRmt[$hotelRmt->id_hotel]["Desglose"]["mejorPlan"] = $planPrimeraTarifa;
															$tarifaRmt[$hotelRmt->id_hotel]["Desglose"]["menorPrecio"] = number_format($menorTarifa,2);
															$tarifaRmt[$hotelRmt->id_hotel]["Desglose"]["moneda"] = $monedaPrimeraTarifa;
															$tarifaRmt[$hotelRmt->id_hotel]["Desglose"]["banderaBootom"] = $tarifasHotel->banderaBootom;
															$tarifaRmt[$hotelRmt->id_hotel]["Desglose"]["disponibilidad_hotel"] = $disponibilidadHotel;

															$tarifaRmt[$hotelRmt->id_hotel]["Filtro"]["planes"]['codigos'] = $planesArray;
															$tarifaRmt[$hotelRmt->id_hotel]["Filtro"]["planes"]['tipos'] = $hotelesPlanes;

															$filtroHotel = FiltroHoteles::model()->findAll('id_hotel='.$hotelRmt->id_hotel);

															if (count($filtroHotel)>0) {
																foreach ($filtroHotel as $ftr => $filtro) {
																	array_push($temasFiltros, $filtro->idFiltro->descripcion);
																}
															}

															$tarifaRmt[$hotelRmt->id_hotel]["Filtro"]["temas"] = $temasFiltros;

														}

														if($subrow->id_tarifa==31730 && $session['habitacion_1']['adultos']>1) {
															$mostrarsoltero="no";
														}
														else{
															$mostrarsoltero="si";
														}

														if ($mostrarsoltero!="no") 
														{
															$tarifaAux=$tarifa;
															$id_tipo_plan = $tarifa->id_tipo_plan;
															$moneda=$tarifa->moneda;

															// $outlet=Outlet::model()->find("estatus=1 AND solo_agencias=1");
																// echo $key."____";
															$dataRmt = $siteController->itemCotizacionRapida($tipohab,$subrow->id_tarifa,$hotelRmt->id_hotel,$resultadoBusquedaHoteles["fecha_inicial"],$resultadoBusquedaHoteles["fecha_final"],$resultadoBusquedaHoteles["noches"],$i_cotiza,$primeraTarifa,$subrow->disponibilidad,$session,$i_room,$resultadoBusquedaHoteles);


															if (strtotime($fecha_actual)>=strtotime($fecha_inicial_buen_fin) && strtotime($fecha_actual)<=strtotime($fecha_final_buen_fin) && $dataRmt["plan"][0]["activarLogoBuenFin"]==true) {
																	$tarifaRmt[$hotelRmt->id_hotel]['activarLogoBuenFin'] = true;
															}

															if ($menorTarifa==0) {
																$menorTarifa = $dataRmt["plan"][0]["precio"];
															}

															if($monedaPrimeraTarifa!="MXN") {
																$tarifaRmt[$hotelRmt->id_hotel]["Desglose"]["menorPrecio"] = number_format($menorTarifaUSD,2);
																$tarifaRmt[$hotelRmt->id_hotel]["Desglose"]["menorPrecio_mxn"] = number_format($menorTarifaRMT,2);
																$tarifaRmt[$hotelRmt->id_hotel]["Desglose"]["moneda"] = $monedaPrimeraTarifa;
															}

															$tarifaRmt[$hotelRmt->id_hotel]["Habitaciones"][$cuarto]["Planes"][$i_room] = $dataRmt;

															$tarifaRmt[$hotelRmt->id_hotel]["Habitaciones"][$cuarto]["Planes"][$i_room]["ocultarTarifa"] = $dataRmt["plan"][0]["ocultarTarifa"];

																##################################
															$i_room++;
																// echo "<br>".$politicasDeCancelacion;
														}

														if ($primeraTarifa=="OK") {
															$primeraTarifa="NULL";
														}

														$i_cotiza++;
													}
												}

												$cuarto++;
											}
										}
									}else{
										$tarifaRmt[$hotelRmt->id_hotel]["Habitaciones"] = null;
										$tarifaRmt[$hotelRmt->id_hotel]["Desglose"] = null;
										$tarifaRmt[$hotelRmt->id_hotel]["Filtro"] = null;

										if($i_tarifas>0)
										{
											$tarifaspropias["tarifaspropias"]=$propios;
										}
										else 
										{
											if (!empty($session["outlet"]))
											{
												$tarifaspropias["tarifaspropias"]="tarifaOutlet";
											}else
											{
												$tarifaspropias["tarifaspropias"]=null;				
											}
										}

										if ($tarifaspropias["tarifaspropias"]=="tarifaOutlet" && $_SESSION["msgError"]=="") {
											$tarifaRmt[$row->id_hotel]["Warning"]["mensaje"] = "<p><strong>¡El hotel no cuenta con tarifas Outlet por el momento!</strong>.<br> Si desea ver otras tarifas del hotel presione el el siguiente botón</p>";
											$tarifaRmt[$row->id_hotel]["Warning"]["warning"] = true;
										}else{
											$tarifaRmt[$row->id_hotel]["Warning"]["warning"] = true;
											$tarifaRmt[$row->id_hotel]["Warning"]["mensaje"] = "<p><strong>¡El hotel no cuenta con tarifas disponibles!</strong> ".$_SESSION["msgError"]."</p>";

											if ($session['tipoPrecioBloqueo']=='BLOQUEO') {
												unset($tarifaRmt[$row->id_hotel]);
											}

											if ($contarHotel > 1) {
												unset($tarifaRmt[$row->id_hotel]);
											}
										}
									}
										#### fin de if hoteles->killing
								}
							}

							function sort_by_orden($a, $b) 
							{
								return $a['menorTarifa'] - $b['menorTarifa'];
							}

							$responseWs = $tarifaRmt;

								// 
						}catch(Exception $e){
							$mensaje_de_error["500_0"]["Error"]["Proveedor_0"] = "Mensaje: ".$e->getMessage()." <br> Codigo: ".$e->getCode()." <br> Archivo: ".$e->getFile()." <br> Linea: ".$e->getLine();
							$responseWs = $mensaje_de_error;
						}
					break;

					case 1:
						try {
							$tarifasbeds = array();
							$api = Api::model()->findByPk(1);
							$hbedsController = Yii::app()->createController('hbeds');
							$hbedsController = $hbedsController[0];

							foreach ($hoteles as $killing => $row) {
								$code=explode("/", $row->codigo);
								$codigosHoteles[]=$code[0];
							} 

							$resultado["hotels"]["hotels"]=array();
							$resultado=json_encode($resultado);
							$resultado=json_decode($resultado);
							if(count($codigosHoteles)>0)
							{	
								$codigosHotelAgrupados=array_chunk($codigosHoteles, 500);
								foreach ($codigosHotelAgrupados as $key => $value) 
								{
									$response=json_decode($siteController->tarifasBeds($value, $session));

									$resultHoteles = array_merge($resultado->hotels->hotels, $response->hotels->hotels);

									$resultado->hotels->hotels=$resultHoteles;

								}
							}

							$mealplanArray=array( 1=>'AI', 2=>'RO', 36 => 'AS', 39 => 'BB', 35 => 'AS', 5 => 'AB', 4 => 'DB', 3 => 'CB');

							$jsonHotel=json_encode($resultado);
							$tarifasbeds=$resultado;

								// echo $jsonHotel;
								// exit;
								// $tarifasbeds=$resultado;
							$hotelHB=json_decode($jsonHotel);         
							$ahotelHB=json_decode($jsonHotel,true);         			
							$arrHotel=$ahotelHB["hotels"]["hotels"];
							$markup=$api->markup;
							foreach ($codigosHoteles as $codigoHotel) 
							{
								$keyHotel=false;
								$menorTarifaBeds=0;	
								if($arrHotel!=NULL){
									$keyHotel = array_search($codigoHotel, array_column($arrHotel, 'code'));
								}
								$hotelBeds = Hoteles::model()->find('codigo LIKE "'.$codigoHotel.'/%" and proveedor=1');

								if($keyHotel!==false)
								{
			            				// echo $hotelBeds->nombre_hotel."<br>";
			            				############## CODIGO QUE SE PROGRAMO EN LA INTERFAZ COTIZACIONRAPIDA BEDS #################

										$precioBeds=(($hotelHB->hotels->hotels[$keyHotel]->minRate)*19.1358261);//*1.1733;
										$resultHotel=$hotelHB->hotels->hotels[$keyHotel];

										$tarifaHB[$hotelBeds->id_hotel]['id_hotel'] = $hotelBeds->id_hotel; 
										$tarifaHB[$hotelBeds->id_hotel]['nombre_hotel'] = $hotelBeds->nombre_hotel; 
										$tarifaHB[$hotelBeds->id_hotel]['destacado'] = $outletController->hotelesDestacados($outlet,$hotelBeds->id_hotel);
										$tarifaHB[$hotelBeds->id_hotel]['beneficio'] = $hotelBeds->Beneficios->beneficio; 
										$tarifaHB[$hotelBeds->id_hotel]['code_hotel'] = $codigoHotel; 
										$tarifaHB[$hotelBeds->id_hotel]['markup'] = $markup; 
										$tarifaHB[$hotelBeds->id_hotel]['observaciones'] = $hotelBeds->observaciones;
										$tarifaHB[$hotelBeds->id_hotel]['ubicacion'] = $hotelBeds->ubicacion;
										$tarifaHB[$hotelBeds->id_hotel]['proveedor'] = $hotelBeds->proveedor;
										$tarifaHB[$hotelBeds->id_hotel]['destino']['name'] = $hotelBeds->Destino->name;
										$tarifaHB[$hotelBeds->id_hotel]['destino']['destinationsCode0'] = $hotelBeds->Destino->destinationsCode0->name;
										$tarifaHB[$hotelBeds->id_hotel]['destino']['zonasCode'] = $hotelBeds->Destino->idZona;
										$tarifaHB[$hotelBeds->id_hotel]['foto'] = $siteController->getNameProveedor($hotelBeds->id_hotel,$hotelBeds->proveedor);

										$roomCode=$hotelHB->hotels->hotels[$keyHotel]->rooms[0]->code;
										$tipohab = $roomCode;
										$id_tarifa=0;
										$combinar=false;
										$rateKey=$hotelHB->hotels->hotels[$keyHotel]->rooms[0]->rates[0]->rateKey;
										$desdeBeds="$".number_format($precioBeds,2);
										$fecha_inicial = $resultadoBusquedaHoteles->fecha_inicial;

										$estrella=substr($resultHotel->categoryCode, 1);
										$numeroEst=explode(' ',$resultHotel->categoryName);

										if ($estrella=='EST')
										{ 
											$categoria=(int) $numeroEst[0];
										}else
										{ 
											$categoria = $resultHotel->categoryName;
										}

										$tarifaHB[$hotelBeds->id_hotel]['estrellas'] = $categoria;

										
										$noReembolsableMsg="Tarifa No Reembolsable";
										$alerta_disponibilidad=1;
										$id_tipo_plan=0;
										$primeraTarifa="";  
										$menorPrecio=0;        
										$tipoCambio=1;
										$tarifas_diaria=array();
										$desglosePersonas = array();
										$mejorHabitacion="";
										$mejorPlan="";
										$num_tarifas=0;
										// $temasFiltros = '';
										$temasFiltros = array();

										$hotelHBeds = $resultHotel;
										$rooms=count($hotelHBeds->rooms);

			            				//CICLO ROOMS

										$cuartosParaRatesKeys=$session['cuartosParaRatesKeys'];
										$ratesKeys=array();
										$totalRatekey = 0;

										foreach ($hotelHBeds->rooms as $room) {
											foreach ($room->rates as $rate) 
											{
												if($rate->rateKey)
													$totalRatekey++;
											}
										}

										$descripcionHabAux="";

										$imprimePrimera=true;
			            				// echo "<br>#######".$totalRatekey."<br>";
			            				// echo json_encode($hotelHBeds->rooms);
			            				// exit;
			            				$planesArray = array();
										$hotelesPlanes = array();
										for ($numRK=0; $numRK < $totalRatekey; $numRK++) { 

											$cuartos=array();
											$tiposCuartos=array();
											$ratesKeys_primeraTarifa=array();
											$tarifas_diaria=array();
											$promos="";
											$ofertas="";
											$desglose="";
											$rateClass="";
											$boardCode="";
											$descripcionHab="";
											$politicasCancelacion="";
											$tipoHabs="";
											$r=0;
											$total=0;
											$bandera=1;
											$allotment=0;
											$fecha_limite=date("d/m/Y 20:00");

											$numCuarto=0;

											$total=0;
											$total_neto=0;
											$totalMxn=0;
											$dailyNet_A_MXN=0;
											$dailyNet_M_MXN=0;
											$promos = array();
											$ofertas = array();
											foreach ($hotelHBeds->rooms as $roomCode => $room) {

												foreach ($room->rates as $planRate => $rate) {

													if ($rate->rateKey && !in_array($rate->rateKey, $ratesKeys)) {
														$rateKey_explode=explode("|", $rate->rateKey);
														$condicion_hab=$rateKey_explode[9]."|".$rateKey_explode[10];
														$condicion_rateKey=$rateKey_explode[6]."|".$rateKey_explode[7]."|".$rateKey_explode[8];

														if($r < $session['habs'] && count($ratesKeys_primeraTarifa)<=$session['habs']){

															$rowTipoCuarto=$cuartosParaRatesKeys['tipos'][$r];

															$cantidadDeHabs=$cuartosParaRatesKeys['cantidad'][$rowTipoCuarto];

															if($rowTipoCuarto==$condicion_hab && $rate->allotment>=$cantidadDeHabs && !in_array($rowTipoCuarto, $cuartos) && ($rateClass=="" || $rateClass==$rate->rateClass) && ($boardCode=="" || $boardCode==$rate->boardCode))
															{

																$tipohab = TipoHabitaciones::model()->find('codigo="'.$room->code.'" AND id_hotel='.$hotelBeds->id_hotel);

																if (count($tipohab)>0) {
																	$imprime=1;
																}else{
																	$habitacion=Rooms::model()->find('codigo="'.$room->code.'"');
																	$tipohab = new TipoHabitaciones;

																	$tipohab->tipo_habitacion=$habitacion->tipo_habitacion;
																	$tipohab->descripcion=$habitacion->descripcion;
																	$tipohab->codigo=$habitacion->codigo;
																	$tipohab->max_adultos=$habitacion->max_adultos;
																	$tipohab->max_menores=$habitacion->max_menores;
																	$tipohab->max_juniors=$habitacion->max_juniors;
																	$tipohab->paxextra=$habitacion->paxextra;
																	$tipohab->estatus=1;
																	$tipohab->id_hotel=$hotelBeds->id_hotel;
																	$tipohab->orden=$habitacion->orden;
																	$tipohab->activa_validacion=0;

																	if($tipohab->save())
																	{
																		$imprime=1;
																	}
																}

																if ($imprime>0) {

																	$descripcionHabitacion=(strlen($tipohab->descripcion)>0)?$tipohab->descripcion:$tipohab->tipo_habitacion;
																	$NRF=$rate->rateClass=="NRF"?$noReembolsableMsg:'';

																	if($allotment==0){
																		$allotment=$rate->allotment;                                   
																	}else if($allotment>$rate->allotment)
																	{
																		$allotment=$rate->allotment;
																	}


																	for ($cantidad=0; $cantidad < $cantidadDeHabs; $cantidad++) { 
																		$total+=($rate->net*$tipoCambio)/$markup;
																		$total_neto+=$rate->net*$tipoCambio;
																		$totalMxn=number_format($total, 2); 
																		// echo $totalMxn."####";

																		$tarifadiaria="";                                
																		if($rate->dailyRates)
																		{
																			foreach ($rate->dailyRates as $dailyRates)
																			{
																				$dailyNet_A_MXN=($dailyRates->dailyNet*$tipoCambio)/$markup;
																				$dailyNet_M_MXN=(0*$tipoCambio);
																				$dailyNetMXN=$dailyNet_A_MXN+$dailyNet_M_MXN;
																				$tarifadiaria.=(float)$dailyNet_A_MXN.',';
																			}
																			array_push($tarifas_diaria, $tarifadiaria);
																		}

																		$tipoHabs.=$tipohab->id_tipo_habitacion.",";

																		$responsePoliticasHB=$hbedsController->politicasCancelacion($rate->cancellationPolicies,$fecha_inicial,$markup,$descripcionHabitacion,$r,$hotelHBeds->currency,true);

																		$tablaPoliticasCancelacion[$r+1] = $responsePoliticasHB['cancelPenalties'];

																		$politicasCancelacion=$responsePoliticasHB["cancelPenalties"];


																		if($rate->dailyRates)
																			$desglosePersonas['habitacion'][$r+1]=$busquedaController->desglosePersonas($rate->dailyRates,$fecha_inicial,$markup,$hotelHBeds->currency,$r+1,$condicion_hab,$_POST["front_form"]);

																		if($rate->offers)
																			$ofertas[$r+1]=$busquedaController->offersHB($rate->offers,$markup,$descripcionHabitacion,$r,$hotelHBeds->currency);

																		if($rate->promotions)
																			$promos[$r+1]=$busquedaController->promocionesHB($rate->promotions,$descripcionHabitacion,$r);


																		array_push($ratesKeys_primeraTarifa, $rate->rateKey);
																		array_push($ratesKeys, $rate->rateKey);
																		array_push($tiposCuartos, $descripcionHabitacion);

																		$r++;


																	}


																	if ($rate->cancellationPolicies) {
																		$fecha_limite=$responsePoliticasHB["fecha_limite"];
																		$fecha_limite_h=$responsePoliticasHB["fecha_limite_h"];
																	}

																	if($fecha_limite=="")
																		$fecha_limite=date("d/m/Y 20:00"); 


																	if ($fecha_limite_h=="")               
																		$fecha_limite_h=date("d/m/Y 20:00");                    


																	if($ofertas!="")
																		$offers=$ofertas;

																	if($promos!="")
																		$promociones=$promos;                 

																	if($rate->allotment==1) $colorAllotment="warning"; else $colorAllotment="info";            


																	if($session['tipoUsuario'] != "Agencia")
																		$allots=$allotment;
																	else
																		$allots="";


																	if ($r==$session['habs']) {

																		###### definir habitaciones
																		$tarifaHB[$hotelBeds->id_hotel]["Habitaciones"][$numCuarto]["tipo_hab"] = $room->code;
																		$tarifaHB[$hotelBeds->id_hotel]["Habitaciones"][$numCuarto]["allotment"] = 1;
																		$tarifaHB[$hotelBeds->id_hotel]["Habitaciones"][$numCuarto]["reservar"] = 1;
																		$tarifaHB[$hotelBeds->id_hotel]["Habitaciones"][$numCuarto]["ratekey"] = 'BEDS';
																		$tarifaHB[$hotelBeds->id_hotel]["Habitaciones"][$numCuarto]["info_habitacion"] = "";
																		$tarifaHB[$hotelBeds->id_hotel]["Habitaciones"][$numCuarto]["habitaciones"] = "";

																		if ($mejorPlan=="") {
																			$mejorPlan=$rate->boardName;
																			// echo $total."####";
																		}
																		$tiposRooms=$busquedaController->agrupaCantidad($tiposCuartos);
																		foreach ($tiposRooms['tipos'] as $tipoC => $tipoCuarto) 
																		{
																			if($tipoC!=0)
																				$descripcionHab.=" + ";
																			$descripcionHab.=($tiposRooms['cantidad'][$tipoCuarto]>1)?$tiposRooms['cantidad'][$tipoCuarto]." x ":"";
																			$descripcionHab.=$tipoCuarto;
																		}

																		if($descripcionHabAux!=$descripcionHab)
																		{   
																			$descripcionHabAux=$descripcionHab; 
																		}
																		
																		################### Checar
																		$tarifaHB[$hotelBeds->id_hotel]["Habitaciones"][$numCuarto]["nombre_hab"] = $descripcionHab;
																		###################
																		$planBeds = array_search($rate->boardCode,$mealplanArray);


																		if (!in_array((int) $planBeds,$planesArray)) {
																			array_push($planesArray,(int) $planBeds);
																			$hotelesPlanes[] =  $rate->boardName;
																		}

																		### primeras tarifas
																		if ($imprimePrimera===true) {

			            													// echo $totalMxn."?".$hotelBeds->nombre_hotel."<br>";
																			$tarifaHB[$hotelBeds->id_hotel]["Habitaciones"][$numCuarto]["Planes"][$planRate]["primeraTarifa"]=true;
																			$menorPrecio=$totalMxn;
																			$mejorPlan=$mejorPlan;
																			$primeramoneda=$hotelHBeds->currency;
																			$mejorHabitacion=$descripcionHab;
																			$banderaBootom=false;

																			

																			$filtroHotel = FiltroHoteles::model()->findAll('id_hotel='.$hotelBeds->id_hotel);

																			if (count($filtroHotel)>0) {
																				foreach ($filtroHotel as $ftr => $filtro) {
																					array_push($temasFiltros, $filtro->idFiltro->descripcion);
																				}
																			}

																			$tarifaHB[$hotelBeds->id_hotel]["Filtro"]["temas"] = $temasFiltros;

																		}else{
																			$tarifaHB[$hotelBeds->id_hotel]["Habitaciones"][$numCuarto]["Planes"][$planRate]["primeraTarifa"]=false;
																		}

																		$tarifaHB[$hotelBeds->id_hotel]["Filtro"]["planes"]['codigos'] = $planesArray;
																		$tarifaHB[$hotelBeds->id_hotel]["Filtro"]["planes"]['tipos'] = $hotelesPlanes;

																		$tarifaHB[$hotelBeds->id_hotel]["Habitaciones"][$numCuarto]["id_tipo_habitacion"] = $tipohab->id_tipo_habitacion;
																		#########

																		#### definir planes en las habitaciones
																		$tarifaHB[$hotelBeds->id_hotel]["Habitaciones"][$numCuarto]["Planes"][$planRate]["botonReservar"]=true;
																		$tarifaHB[$hotelBeds->id_hotel]["Habitaciones"][$numCuarto]["Planes"][$planRate]["tipo_boton"]="NORMAL";
																		$tarifaHB[$hotelBeds->id_hotel]["Habitaciones"][$numCuarto]["Planes"][$planRate]["hasAllotment"]=$alerta_disponibilidad;
																		$tarifaHB[$hotelBeds->id_hotel]["Habitaciones"][$numCuarto]["Planes"][$planRate]["btnHtml"]["color"]="green";
																		$tarifaHB[$hotelBeds->id_hotel]["Habitaciones"][$numCuarto]["Planes"][$planRate]["num_habs"]=$session['habs'];
																		$tarifaHB[$hotelBeds->id_hotel]["Habitaciones"][$numCuarto]["Planes"][$planRate]["id_plan"]=$planBeds;
																		$tarifaHB[$hotelBeds->id_hotel]["Habitaciones"][$numCuarto]["Planes"][$planRate]["id_habitacion"]=$tipohab->id_tipo_habitacion;
																		$tarifaHB[$hotelBeds->id_hotel]["Habitaciones"][$numCuarto]["Planes"][$planRate]["Total_planes"]=null;
																		#######
																		#
																		##### definir planes para iconos y precio
																		$tarifaHB[$hotelBeds->id_hotel]["Habitaciones"][$numCuarto]["Planes"][$planRate]["plan"][0]["tipo_plan"]=$rate->boardName;
																		$tarifaHB[$hotelBeds->id_hotel]["Habitaciones"][$numCuarto]["Planes"][$planRate]["plan"][0]["id_plan"]=$planBeds;
																		$tarifaHB[$hotelBeds->id_hotel]["Habitaciones"][$numCuarto]["Planes"][$planRate]["plan"][0]["habitaciones_disponibles"]=$allotment;
																		$tarifaHB[$hotelBeds->id_hotel]["Habitaciones"][$numCuarto]["Planes"][$planRate]["plan"][0]["mealPlanCode"]=$rate->boardCode;
																		$tarifaHB[$hotelBeds->id_hotel]["Habitaciones"][$numCuarto]["Planes"][$planRate]["plan"][0]["ratePlan"]="";
																		$tarifaHB[$hotelBeds->id_hotel]["Habitaciones"][$numCuarto]["Planes"][$planRate]["plan"][0]["fecha_limite"]=$fecha_limite;
																		$tarifaHB[$hotelBeds->id_hotel]["Habitaciones"][$numCuarto]["Planes"][$planRate]["plan"][0]["fecha_limiteH"]=$fecha_limite_h;
																		$tarifaHB[$hotelBeds->id_hotel]["Habitaciones"][$numCuarto]["Planes"][$planRate]["plan"][0]["roomType"]=$room->code;
																		$tarifaHB[$hotelBeds->id_hotel]["Habitaciones"][$numCuarto]["Planes"][$planRate]["plan"][0]["tarifadiaria"]=base64_encode(json_encode($tarifas_diaria));
																		$tarifaHB[$hotelBeds->id_hotel]["Habitaciones"][$numCuarto]["Planes"][$planRate]["plan"][0]["roomrates"]=base64_encode(json_encode($tarifas_diaria));
																		$tarifaHB[$hotelBeds->id_hotel]["Habitaciones"][$numCuarto]["Planes"][$planRate]["plan"][0]["rate_class"]=$rate->rateClass;
																		$tarifaHB[$hotelBeds->id_hotel]["Habitaciones"][$numCuarto]["Planes"][$planRate]["plan"][0]["moneda"]=$hotelHBeds->currency;
																		$tarifaHB[$hotelBeds->id_hotel]["Habitaciones"][$numCuarto]["Planes"][$planRate]["plan"][0]["icon_politicas_cancelacion"]=$tablaPoliticasCancelacion;
																		$tarifaHB[$hotelBeds->id_hotel]["Habitaciones"][$numCuarto]["Planes"][$planRate]["plan"][0]["politicas_cancelacion"]=$tablaPoliticasCancelacion;
																		$tarifaHB[$hotelBeds->id_hotel]["Habitaciones"][$numCuarto]["Planes"][$planRate]["plan"][0]["calendario"]=$desglosePersonas;
																		$tarifaHB[$hotelBeds->id_hotel]["Habitaciones"][$numCuarto]["Planes"][$planRate]["plan"][0]["offers"]=$offers;
																		$tarifaHB[$hotelBeds->id_hotel]["Habitaciones"][$numCuarto]["Planes"][$planRate]["plan"][0]["promociones"]=$promociones;
																		$tarifaHB[$hotelBeds->id_hotel]["Habitaciones"][$numCuarto]["Planes"][$planRate]["plan"][0]["precio"]=$totalMxn;
																		$tarifaHB[$hotelBeds->id_hotel]["Habitaciones"][$numCuarto]["Planes"][$planRate]["plan"][0]["precio_neto"]=$total_neto;
																		$tarifaHB[$hotelBeds->id_hotel]["Habitaciones"][$numCuarto]["Planes"][$planRate]["plan"][0]["reembolsable"]=$NRF;
																		$tarifaHB[$hotelBeds->id_hotel]["Habitaciones"][$numCuarto]["Planes"][$planRate]["plan"][0]["categoria"]=$categoria;
																		$tarifaHB[$hotelBeds->id_hotel]["Habitaciones"][$numCuarto]["Planes"][$planRate]["plan"][0]["hab"]=$tipoHabs;
																		$tarifaHB[$hotelBeds->id_hotel]["Habitaciones"][$numCuarto]["Planes"][$planRate]["plan"][0]["tarifa"]=0;
																		$tarifaHB[$hotelBeds->id_hotel]["Habitaciones"][$numCuarto]["Planes"][$planRate]["plan"][0]["allotment"]=$alerta_disponibilidad;
																		$tarifaHB[$hotelBeds->id_hotel]["Habitaciones"][$numCuarto]["Planes"][$planRate]["plan"][0]["rateKey"]=json_encode($ratesKeys_primeraTarifa);
																		#########
																		
																		$tarifaHB[$hotelBeds->id_hotel]["Habitaciones"][$numCuarto]["Planes"][$planRate]["warning"]["tarifaVacia"]=false;
																		$tarifaHB[$hotelBeds->id_hotel]["Habitaciones"][$numCuarto]["Planes"][$planRate]["warning"]["mensaje"]="";


																		$imprimePrimera=false;
																		$num_tarifas++;
			            											
																	}
																	array_push($cuartos,$rowTipoCuarto);
																	$rateClass=$rate->rateClass;                           
																	$boardCode=$rate->boardCode;

																}


															}

														}



													}


												}

												$numCuarto++;

											}
										}


										if($menorPrecio>0)
										{
											$tarifaHB[$hotelBeds->id_hotel]["Desglose"]["tarifas"] =$num_tarifas;
											$tarifaHB[$hotelBeds->id_hotel]["Desglose"]["mejorHabitacion"] =$mejorHabitacion;
											$tarifaHB[$hotelBeds->id_hotel]["Desglose"]["mejorPlan"] = $mejorPlan;
											$tarifaHB[$hotelBeds->id_hotel]["Desglose"]["menorPrecio"] = $menorPrecio;
											$tarifaHB[$hotelBeds->id_hotel]["Desglose"]["moneda"] =$primeramoneda;
											$tarifaHB[$hotelBeds->id_hotel]["Desglose"]["banderaBootom"] =$banderaBootom;

											if($primeramoneda=="USD") {
												$tarifaHB[$hotelBeds->id_hotel]["Desglose"]["menorPrecio"] = $menorPrecio;
												$menorTarifaMXN = 19.5000*$menorPrecio;
												$tarifaHB[$hotelBeds->id_hotel]["Desglose"]["menorPrecio_mxn"] = number_format($menorTarifaMXN,2);
											}
										}else{
											$tarifaHB[$hotelBeds->id_hotel]['Warning']['warning'] = true;
											$tarifaHB[$hotelBeds->id_hotel]['Warning']['mensaje'] = "<p></strong> No hay disponibilidad para <strong>".$hotelBeds->nombre_hotel."</strong> del <strong>".date("d/m/Y",strtotime($resultadoBusquedaHoteles->fecha_inicial))."</strong> al <strong>".date("d/m/Y",strtotime($resultadoBusquedaHoteles->fecha_final))."</strong></p>";
											if ($contarHotel>1) {
												unset($tarifaHB[$hotelBeds->id_hotel]);
											}
										}

										$searchMenorTarifaBeds=$busquedaController->menorTarifaBeds(json_encode($arrHotel[$keyHotel]),$_POST['front_form'],$mealplanArray);
										$menorTarifaBeds = $searchMenorTarifaBeds['menorPrecio'];
										
										if($menorTarifaBeds>0)
										{
											$hotelBeds->precio = $menorTarifaBeds;
										}else{
											if ($contarHotel>1) {
												unset($tarifaHB[$hotelBeds->id_hotel]);
											}
										}
									}
									else
									{
										$errorMax = 0;
										$tarifaHB[$hotelBeds->id_hotel]['id_hotel'] = $hotelBeds->id_hotel; 
										$tarifaHB[$hotelBeds->id_hotel]['nombre_hotel'] = $hotelBeds->nombre_hotel; 
										$tarifaHB[$hotelBeds->id_hotel]['beneficio'] = $hotelBeds->Beneficios->beneficio; 
										$tarifaHB[$hotelBeds->id_hotel]['destacado'] = $outletController->hotelesDestacados($outlet,$hotelBeds->id_hotel);  
										$tarifaHB[$hotelBeds->id_hotel]['code_hotel'] = $codigoHotel; 
										$tarifaHB[$hotelBeds->id_hotel]['markup'] = $markup; 
										$tarifaHB[$hotelBeds->id_hotel]['observaciones'] = $hotelBeds->observaciones;
										$tarifaHB[$hotelBeds->id_hotel]['ubicacion'] = $hotelBeds->ubicacion;
										$tarifaHB[$hotelBeds->id_hotel]['proveedor'] = $hotelBeds->proveedor;
										$tarifaHB[$hotelBeds->id_hotel]['destino']['name'] = $hotelBeds->Destino->name;
										$tarifaHB[$hotelBeds->id_hotel]['destino']['destinationsCode0'] = $hotelBeds->Destino->destinationsCode0->name;
										$tarifaHB[$hotelBeds->id_hotel]['destino']['zonasCode'] = $hotelBeds->Destino->idZona;
										$tarifaHB[$hotelBeds->id_hotel]['foto'] = $siteController->getNameProveedor($hotelBeds->id_hotel,$hotelBeds->proveedor);
										$tarifaHB[$hotelBeds->id_hotel]['estrellas'] = ($hotelBeds->id_categoria!==null) ? (int) $hotelBeds->id_categoria : (int) $hotelBeds->estrellas;
										$tarifaHB[$hotelBeds->id_hotel]['Warning']['warning'] = true;
										$tarifaHB[$hotelBeds->id_hotel]['Warning']['mensaje'] = "<p></strong> No hay disponibilidad para <strong>".$hotelBeds->nombre_hotel."</strong> del <strong>".date("d/m/Y",strtotime($resultadoBusquedaHoteles->fecha_inicial))."</strong> al <strong>".date("d/m/Y",strtotime($resultadoBusquedaHoteles->fecha_final))."</strong></p>";

										if ($contarHotel>1) {
											unset($tarifaHB[$hotelBeds->id_hotel]);
										}
									}
								}

								// echo json_encode($responsePoliticasHB);
								// exit;
								$responseWs = $tarifaHB;

							} catch (Exception $e) {
								$mensaje_de_error["500_1"]["Error"]["Proveedor_1"] = "Mensaje: ".$e->getMessage()." <br> Codigo: ".$e->getCode()." <br> Archivo: ".$e->getFile()." <br> Linea: ".$e->getLine();
								$responseWs = $mensaje_de_error;
							}
					break;

					case 2:
						try {
								$resultadoBusquedaHoteles = json_decode($_POST["habitacionesRQ"],true);

								$tarifasOmniBees = array();
								$PlanOB=array();
								$omniBeesController = Yii::app()->createController('omniBees');
								$omniBeesController = $omniBeesController[0];
								$mealplanArray=array( 1=>'AllInclusive', 2=>'SoloHabitacion', 3=>'BedBreakfast', 51=>'HalfBoard', 37=>'FullBoard');

								$api = Api::model()->findByPk(4);
								$availRatesOnly = true;
								if ($contarHotel==1) {
									$availRatesOnly = false;
								}

								$hotelesAvail = array();
								foreach ($hoteles as $hotelAvail) {
									$codeAvail=explode("/", $hotelAvail->codigo);
									$codigoHotelAvail=$codeAvail[0];

									$hotelesAvail[]['HotelCode'] = (int) $codigoHotelAvail;
								}

								$resultAvail=$omniBeesController->hotelOmnibeesLote($hotelesAvail,true,$hoteles,$session);
								$resultAvail = json_decode($resultAvail);

								if ($resultAvail!=null) {

									$HotelStaysType = $resultAvail->GetHotelAvailResult->HotelStaysType->HotelStays->HotelStay;

									$warningOB = $resultAvail->GetHotelAvailResult->WarningsType->Warnings->Warning;
									$roomsRateBees=$resultAvail->GetHotelAvailResult->RoomStaysType->RoomStays->RoomStay;
									$searchKeys = json_decode(json_encode($roomsRateBees), true);

									if ($contarHotel>1) {
										foreach ($HotelStaysType as $row) {
											$codigoHotel=$row->BasicPropertyInfo->HotelRef->HotelCode;
											$destinoHotel = Hoteles::model()->find('codigo LIKE "'.$codigoHotel.'/OB" and proveedor=2  AND estatus=1');
											$countryCode=$destinoHotel->Destino->destinationsCode0->countryCode;
											$RoomStayRPH = $row->RoomStayRPH;

											$keyHotel = false;
											$keyHotel = array_search($RoomStayRPH, array_column($searchKeys, 'RPH'));

											if($keyHotel!==false)
											{
												$result = $resultAvail->GetHotelAvailResult->RoomStaysType->RoomStays->RoomStay[$keyHotel];
												$dataOB[$destinoHotel->id_hotel] = $omniBeesController->tarifasOBB($codigoHotel,$destinoHotel->id_hotel,$resultadoBusquedaHoteles["fecha_inicial"],0,$countryCode,$session,$result,$mealplanArray,$warningOB,$contarHotel);

												$hotelesOB = $dataOB[$destinoHotel->id_hotel];
												$menorPrecioOmniBees = $hotelesOB["menorPrecioOmniBees"];
												if ($menorPrecioOmniBees>0) {
													$tarifaOB[$destinoHotel->id_hotel] = $omniBeesController->construirTarifas($destinoHotel,$hotelesOB,false,$codigoHotel,$countryCode,$session,$resultadoBusquedaHoteles,$outlet);
												}

											}
										}

									}else{

										$codigoHotel=$resultAvail->GetHotelAvailResult->Criteria->Criterion->HotelRefs->HotelRef->HotelCode;

										$destinoHotel = Hoteles::model()->find('codigo LIKE "'.$codigoHotel.'/OB" and proveedor=2  AND estatus=1');
										$countryCode=$destinoHotel->Destino->destinationsCode0->countryCode;
										$RoomStayRPH = $HotelStaysType->RoomStayRPH;

										$NotAvailRoomStaysType = false;

											###### si no hay disponibilidad
										if($resultAvail->GetHotelAvailResult->RoomStaysType==null){
											$result=$omniBeesController->hotelOmnibees($codigoHotel,false,$destinoHotel->id_hotel,$countryCode,$session);
												// No hay disponibilidad por 'x' razon
											$NotAvailRoomStaysType = true;
											$resultAvail = json_decode($result);
										}

										$roomsRateBees=$resultAvail->GetHotelAvailResult->RoomStaysType->RoomStays->RoomStay->RoomRates->RoomRate;

										$onlyResult = $resultAvail->GetHotelAvailResult->RoomStaysType->RoomStays->RoomStay;
										$dataOB[$destinoHotel->id_hotel] = $omniBeesController->tarifasOBB($codigoHotel,$destinoHotel->id_hotel,$resultadoBusquedaHoteles["fecha_inicial"],0,$countryCode,$session,$onlyResult,$mealplanArray,$warningOB,$contarHotel);

										$hotelesOB = $dataOB[$destinoHotel->id_hotel];
										$menorPrecioOmniBees = $hotelesOB["menorPrecioOmniBees"];

										$tarifaOB[$destinoHotel->id_hotel] = $omniBeesController->construirTarifas($destinoHotel,$hotelesOB,$NotAvailRoomStaysType,$codigoHotel,$countryCode,$session,$resultadoBusquedaHoteles,$outlet);

									}
									$responseWs = $tarifaOB;
								}

							} catch (Exception $e) {

								$mensaje_de_error["500_2"]["Error"]["Proveedor_2"] = "Mensaje: ".$e->getMessage()." <br> Codigo: ".$e->getCode()." <br> Archivo: ".$e->getFile()." <br> Linea: ".$e->getLine();
								$responseWs = $mensaje_de_error;
							}
					break;

					case 3:
						try {
							$tarifasTravelSolution = array();
							$informationHotelesTS = array();
							$travelSolutionController = Yii::app()->createController('travelSolution');
							$travelSolutionController = $travelSolutionController[0];

							$mealplanArrayDO=array( 1=>'AI', 2=>'EP', 3 => 'CP', 4 => 'DB', 37 => 'SA', 64 => 'BB', 61 => 'ZZ', 65 => 'BI', 68 => 'BD');


							foreach ($hoteles as $killing => $row) {
								$code=explode("/", $row->codigo);
								$codigosHotelTravelSolution[]=$code[0];
								$row->codigo = $code[0];
							}

							$resultadoTS["hotels"]["hotels"]=array();
							$resultadoTS=json_encode($resultadoTS);
							$resultadoTS=json_decode($resultadoTS);

							// sort($codigosHotelTravelSolution);

							if(count($codigosHotelTravelSolution)>0)
							{
								$codigosHotelAgrupados=array_chunk($codigosHotelTravelSolution, 500);
								foreach ($codigosHotelAgrupados as $key => $value) 
								{
									$response=$siteController->tarifasTravelSolution($value,true,$session);				
									$response=json_decode($response);

									if(count($response->Hotels->Hotel)==1)
									{	
										$jsonHotel=json_encode($resultadoTS);
										$resultadoTS = json_decode($jsonHotel, true);

										$h=(array)$response->Hotels->Hotel;
										$resultadoTS["hotels"]["hotels"][]=$h;
									}else
									{							
										$resultHotelesTS = array_merge($resultadoTS->hotels->hotels, $response->Hotels->Hotel);
										$resultadoTS->hotels->hotels=$resultHotelesTS;

									}

								}
							}


							$jsonHotelTS=json_encode($resultadoTS);
							// echo $jsonHotelTS;
							// exit;
							$tarifasTravelSolution=$resultadoTS;

							$api = Api::model()->findByPk(6);
							$markup=$api->markup;
							
							// echo json_encode($hoteles);
							// array_push($hotelesKilling,$hoteles);
							$ahotelTS=json_decode($jsonHotelTS,true);         
							$hotelTS=json_decode($jsonHotelTS);         
							$arrHotel=$ahotelTS["hotels"]["hotels"];

							foreach ($hoteles as $hoteltravelS => $ts) {

								$key = false;
								$menorTarifaTS = 0;

								$hotelTSInformation = Hoteles::model()->findByPk($ts->id_hotel);
								$key = array_search($ts->codigo, array_column($arrHotel, 'Id'));

								if ($key===false) {
									$_SESSION["responseTS"]=false;
									$msgError = "Ocurrió un error en la busqueda de tarifas";

								}else{
									$_SESSION["responseTS"]=$hotelTS->hotels->hotels[$key];
									$searchMenorTarifaTS=$travelSolutionController->menorTarifaTravelSolutionWS($ts->codigo,$markup,$mealplanArrayDO,$hotelTSInformation->id_hotel);
									$menorTarifaTS = $searchMenorTarifaTS['menorTarifa'];
								}

								if ($menorTarifaTS>0) {

									/////////////////////////////////////////////////////////
									// CODIGO PROGRAMADO EN cotizacionrapidaTravelSolution //
									/////////////////////////////////////////////////////////
									

									$num_habs=$session['habs'];
									$alerta_disponibilidad=1;
									$primeraTarifa="";  
									$menorPrecio=0;
									$tipoCambio=1;
									$markup=$api->markup;
									$mejorHabitacion="";
									$mejorPlan="";
									$num_tarifas=0;
									$hotelRate = $hotelTS->hotels->hotels[$key];
									$roomTypes=$hotelRate->Rooms->Room;
									// $temasFiltros = '';
									$temasFiltros = array();

									$rooms=count($roomTypes);

									if($hotelRate->CategoryId!="Array")
									{
										$countCategoria=strlen($hotelRate->CategoryId);
										if($countCategoria==2)
										{
											$estrellas=substr($hotelRate->CategoryId, 1);
										}else
										{
											$estrellas=substr($hotelRate->CategoryId, 1,-1);                                               
										}
									}

									$id_hotel = $hotelTSInformation->id_hotel;
									$description = '';

									$description.= strip_tags($hotelRate->Description);

									if(!is_object($hotelRate->AdditionalCharges))
									{
										$hotelRate->AdditionalCharges=strip_tags($hotelRate->AdditionalCharges);
										$description.= "<hr>";
										$description.= "<strong>Nota del Hotel</strong><br>".ucfirst($hotelRate->AdditionalCharges);
									}


									$tarifaTS[$id_hotel]['id_hotel'] = $hotelTSInformation->id_hotel; 
									$tarifaTS[$id_hotel]['nombre_hotel'] = $hotelTSInformation->nombre_hotel; 
									$tarifaTS[$id_hotel]['beneficio'] = $hotelTSInformation->Beneficios->beneficio;
									$tarifaTS[$id_hotel]['destacado'] = $outletController->hotelesDestacados($outlet,$id_hotel); 
									$tarifaTS[$id_hotel]['code_hotel'] = $ts->codigo; 
									$tarifaTS[$id_hotel]['markup'] = $api->markup; 
									$tarifaTS[$id_hotel]['observaciones'] = $description;
									$tarifaTS[$id_hotel]['ubicacion'] = $hotelRate->Longitude."/".$hotelRate->Latitude;
									$tarifaTS[$id_hotel]['estrellas'] =(int) $estrellas;
									$tarifaTS[$id_hotel]['proveedor'] = $hotelTSInformation->proveedor;
									$tarifaTS[$id_hotel]['destino']['name'] = $hotelTSInformation->Destino->name;
									$tarifaTS[$id_hotel]['destino']['destinationsCode0'] = $hotelTSInformation->Destino->destinationsCode0->name;
									$tarifaTS[$id_hotel]['destino']['zonasCode'] = $hotelTSInformation->Destino->idZona;
									$tarifaTS[$id_hotel]['destino']['datos_search'] = base64_encode($hotelRate->Currency."|".$hotelRate->Destination->Id."|".$hotelRate->Id."|".$hotelRate->InterfaceInfo->Id);

									$linkImage = $siteController->getNameProveedor($hotelTSInformation->id_hotel,$hotelTSInformation->proveedor);
									$linkImage["rutaImage"] = $hotelRate->Image;

									$tarifaTS[$id_hotel]['foto'] = $linkImage;


									if ($menorTarifaTS>0) {
										
										$tarifaTS[$id_hotel]["Filtro"]["planes"]['codigos']= $searchMenorTarifaTS['planHDO'];
										$tarifaTS[$id_hotel]["Filtro"]["planes"]['tipos']= $searchMenorTarifaTS['nombrePlanes'];
										$tarifaTS[$id_hotel]["Desglose"] = $searchMenorTarifaTS["desgloseTS"];

										$filtroHotel = FiltroHoteles::model()->findAll('id_hotel='.$hotelTSInformation->id_hotel);

										if (count($filtroHotel)>0) {
											foreach ($filtroHotel as $ftr => $filtro) {
												array_push($temasFiltros, $filtro->idFiltro->descripcion);
											}
										}

										$tarifaTS[$hotelTSInformation->id_hotel]["Filtro"]["temas"] = $temasFiltros;

									}else{

										if ($contarHotel>1) {
											unset($tarifaTS[$id_hotel]);
										}else{
											$tarifaTS[$id_hotel]["Warning"]["warning"] = true;
											$tarifaTS[$id_hotel]["Warning"]["mensaje"] = "No hay disponibilidad para la fecha solicitada";
										}
									}

								
								}else{ ###fin de if menortarifaTS

									$id_hotel = $hotelTSInformation->id_hotel;

									$tarifaTS[$id_hotel]['id_hotel'] = $hotelTSInformation->id_hotel; 
									$tarifaTS[$id_hotel]['nombre_hotel'] = $hotelTSInformation->nombre_hotel; 
									$tarifaTS[$id_hotel]['beneficio'] = $hotelTSInformation->Beneficios->beneficio; 
									$tarifaTS[$id_hotel]['destacado'] = $outletController->hotelesDestacados($outlet,$id_hotel);
									$tarifaTS[$id_hotel]['code_hotel'] = $ts->codigo; 
									$tarifaTS[$id_hotel]['markup'] = $api->markup; 
									$tarifaTS[$id_hotel]['observaciones'] = $hotelTSInformation->observaciones;
									$tarifaTS[$id_hotel]['ubicacion'] = $hotelTSInformation->ubicacion;
									$tarifaTS[$id_hotel]['estrellas'] = $hotelTSInformation->id_categoria;
									$tarifaTS[$id_hotel]['proveedor'] = $hotelTSInformation->proveedor;
									$tarifaTS[$id_hotel]['destino']['name'] = $hotelTSInformation->Destino->name;
									$tarifaTS[$id_hotel]['destino']['destinationsCode0'] = $hotelTSInformation->Destino->destinationsCode0->name;
									$tarifaTS[$id_hotel]['destino']['zonasCode'] = $hotelTSInformation->Destino->idZona;

									$linkImage = $siteController->getNameProveedor($hotelTSInformation->id_hotel,$hotelTSInformation->proveedor);
									// $linkImage["rutaImage"] = $hotelRate->Image;

									$tarifaTS[$id_hotel]['foto'] = $linkImage;

									if ($contarHotel>1)
									{
										unset($tarifaTS[$id_hotel]);

									}else{

										$tarifaTS[$id_hotel]["Warning"]["warning"] = true;
										$tarifaTS[$id_hotel]["Warning"]["mensaje"] = "No hay disponibilidad para la fecha solicitada";
									}
								
								} ### fin de else

									

								
							} 
							$responseWs = $tarifaTS;
							unset($_SESSION["responseWs"]);
							// exit;
						} catch (Exception $e) {

							$mensaje_de_error["500_3"]["Proveedor_3"] = "Mensaje: ".$e->getMessage()." <br> Codigo: ".$e->getCode()." <br> Archivo: ".$e->getFile()." <br> Linea: ".$e->getLine();
							$responseWs = $mensaje_de_error;
						}
					break;

					case 4:
						try {
							$riuController = Yii::app()->createController('riu');
							$riuController = $riuController[0];

							$riuController->login();
							$api= Api::model()->findByPk('7');
							// $markup=$api->markup;
							$markup = 1; //comision


							if ($contarHotel>0) {
								foreach ($hoteles as $killing => $row) {
									$code=explode("/", $row->codigo);
									$hotelID = Hoteles::model()->findByPk($row->id_hotel);

									$avail = $riuController->hotelAvail($code[0],$session);
									$hotelAvail = json_decode($avail,true);
									$hotelAvails = json_decode($avail);


									$AvailabilityGroup = $hotelAvail[0]['HotelAvailResponse']['HotelAvailResponse']['availabilityList']['AvailabilityGroup'];
									$riuAvail['riuAvail'][$row->id_hotel]=$hotelAvail;
									$bookingRule= $riuController->sortBookingRule($AvailabilityGroup,$session);

									$hotelRooms=json_decode(json_encode($bookingRule));

									$tarifa[$row->id_hotel]['id_hotel'] = $hotelID->id_hotel; 
									$tarifa[$row->id_hotel]['nombre_hotel'] = $hotelID->nombre_hotel; 
									$tarifa[$row->id_hotel]['beneficio'] = $hotelID->Beneficios->beneficio;
									$tarifa[$row->id_hotel]['destacado'] = $destacadosController->hotelesDestacados($row->id_hotel);  
									$tarifa[$row->id_hotel]['code_hotel'] = $code[0]; 
									$tarifa[$row->id_hotel]['markup'] = $markup; 
									$tarifa[$row->id_hotel]['observaciones'] = $hotelID->observaciones;
									$tarifa[$row->id_hotel]['ubicacion'] = $hotelID->ubicacion;
									$tarifa[$row->id_hotel]['estrellas'] = (int) $hotelID->id_categoria;
									$tarifa[$row->id_hotel]['proveedor'] = $hotelID->proveedor;
									$tarifa[$row->id_hotel]['destino']['name'] = $hotelID->Destino->name;
									$tarifa[$row->id_hotel]['destino']['destinationsCode0'] = $hotelID->Destino->destinationsCode0->name;
									$tarifa[$row->id_hotel]['destino']['zonasCode'] = $hotelID->Destino->idZona;
									$tarifa[$row->id_hotel]['foto'] = $siteController->getNameProveedor($hotelID->id_hotel,$hotelID->proveedor);

										$outlet_image="logo-outlet-verano-web-sur4.png";
									if ($outletController->hotelesOutlet($row->id_hotel,4,'')) {
										$outlet_image="logo-precio-especial-sur4.png";
									}
									if ($tarifaOutlet && $outletController->hotelesDestacados($outlet,$hotelID->id_hotel) == 1) {
										$outlet_image="logo-precio-destacado-sur4.png";
									}

									$tarifa[$row->id_hotel]['imagenOutlet']=$outlet_image;
									if (strtotime($fecha_actual)>=strtotime($fecha_inicial_buen_fin) && strtotime($fecha_actual)<=strtotime($fecha_final_buen_fin)) {
										$tarifa[$row->id_hotel]["activarLogoBuenFin"] = true;
									}


									############## CODIGO PROGRAMADO EN VISTA 'COTIZACIONRAPIDARIU' #################

									if (empty($hotelAvails)) {
										$riuController->login();
									}
									$countRooms=count((array)$hotelRooms);

									$errorMsj = '';
									if (empty((array)$hotelAvails[0]->HotelAvailResponse->HotelAvailResponse->availabilityList)) {

										$errorMsj = 'No hay tarifa disponible para la fecha cotizada';
									}

									$hotelRo=(array)$hotelRooms;

									if ($hotelRo[_empty_]->errores->ns1ErroresDto->campo){
										$errorMsj = 'No hay tarifa disponible '.$hotelRo[_empty_]->errores->ns1ErroresDto->campo;
									}

									if ($hotelAvails[0]->soapFault->faultstring) {
										$faultstring=explode('/',$hotelAvails[0]->soapFault->faultstring);
										$errorMsj = $faultstring[1];
									}

									if ($hotelAvails[0]->soapFault->detail->ExcepcionesNegocio->errores->ErroresDto[0]->codigoError=="EX005") {
										$errorMsj = 'La fecha de reserva debe tener almenos 7 dias de anticipación';
									}


									if (empty($errorMsj)) {

										$total = 0;
										// $temasFiltros ='';
										$temasFiltros = array();
										$desglosePersona = array();
										$planesArray = array();
										$hotelesPlanes = array();

										$imprimePrimera=true;
										$cuartosRiu=0;
										foreach ($hotelRooms as $roomKey => $rooms){

											foreach ($rooms->translationTHabs->listTHabs->THabsDto->listTranslation->TranslationDto as $key => $description) {

												if ($description->language=="E") {
													$descripcion =  $description->description;
												}
											}

											$keys = array_keys((array)$rooms->bookingRule->roomStayList->RoomStay);

											if (is_numeric($keys[0])) {
												foreach ($rooms->bookingRule->roomStayList->RoomStay as $key => $room) {
													$response[$key]=$room;
													$total=$room->roomAmount;
													$roomTypeCode=$room->roomTypeCode;
												}
											}else{
												$response=$rooms->bookingRule->roomStayList->RoomStay;
												$total=$rooms->bookingRule->bookingAmount;
												$roomTypeCode=$rooms->bookingRule->roomStayList->RoomStay->roomTypeCode;
											}

											$releaseDays=$rooms->bookingRule->bookingRulePenalties->cancelPenalties->releaseDays;
											$modificationDays=$rooms->bookingRule->bookingRulePenalties->modificationPenalties->releaseDays;
											$datetime_hoy= strtotime(date("Y-m-d"));

											$fecha_limite_h= date('Y-m-d', strtotime($rooms->bookingRule->stayDateStart.' -'.($releaseDays+1).' day'));
											$fechaCan=  strtotime($rooms->bookingRule->stayDateStart.' -'.($releaseDays+5).' day');
											$fechaCancelacion= date('d/m/Y', strtotime($rooms->bookingRule->stayDateStart.' -'.($releaseDays+7).' day'));
											$fechalimiteRiu= date('Y-m-d', strtotime($rooms->bookingRule->stayDateStart.' -'.($releaseDays+7).' day'));
											$fechaModificacion= date('d/m/Y', strtotime($rooms->bookingRule->stayDateStart.' -'.($modificationDays+3).' day'));

											if ($fechaCan<=$datetime_hoy) {
												$fecha_limite_h= date('Y-m-d');
												$fechaCancelacion= date('d/m/Y');	
												$fechaModificacion= date('d/m/Y');
											}

											$cancelPenalties= "A partir del ".$fechaCancelacion." Tiene costo de cancelacion de: $".number_format(($rooms->bookingRule->bookingRulePenalties->cancelPenalties->totalAmount/$markup),2).$currencyCode;
											if($outlet->estatus==1 && (date('Y-m-d') >= $outlet->fecha_inicio && date('Y-m-d') <= $outlet->fecha_final) ){
												$fechaCancelacionOutlet=$outletController->fechalimiteOutlet($row->id_hotel,date('Y-m-d',strtotime($rooms->bookingRule->stayDateStart)),4,null,$fechalimiteRiu);
												$cancelPenalties=  "Fecha limite de pago: ".$fechaCancelacionOutlet." . No transferible, no reembolsable, no se aceptan modificaciones, cancelaciones, ni devoluciones.";
												$fechaCancelacion=$fechaCancelacionOutlet;
											}
											$currencyCode = $rooms->bookingRule->currencyCode;
											switch ($rooms->bookingRule->mealPlan) {
												case 'AI':
												$mealPlan='AI';
												break;
												case 'SH':
												$mealPlan = 'RO';
												break;
												case 'MP':
												$mealPlan='HB';
												break;
												case 'PC':
												$mealPlan='FB';
												break;
												case 'HD':
												$mealPlan= 'HD';
												break;
												default:

												break;
											}

											$rateReference="";
											$idhabitacion="";

											$tipoHabitacion= TipoHabitaciones::model()->find('codigo="'.$roomTypeCode.'" AND id_hotel='.$row->id_hotel);

											if (!$tipoHabitacion->codigo) {
												$tipoHab = new TipoHabitaciones();
												$tipoHab->tipo_habitacion=$descripcion;
												$tipoHab->descripcion=$descripcion;
												$tipoHab->codigo=$roomTypeCode;
												$tipoHab->id_hotel=$row->id_hotel;

												if($tipoHab->save()){	
													$idhabitacion=$tipoHab->id_tipo_habitacion;
													$idtipoHabitacion = $tipoHab->id_tipo_habitacion;
												}

											}else{
												$idhabitacion=$tipoHabitacion->id_tipo_habitacion;
												$idtipoHabitacion = $tipoHabitacion->id_tipo_habitacion;
											}


											if (!is_array($rooms->bookingRule->rateReference)) {
												$rateReference=$rooms->bookingRule->rateReference;
											}
											$plan=Plan::model()->find('code="'.$mealPlan.'"');
											$tipoHab=$roomTypeCode;
											$roomDescription=$roomTypeCode; 


											$totales=0;

											if (!in_array((int) $plan->id_plan,$planesArray)) {
												array_push($planesArray,(int) $plan->id_plan);
												$hotelesPlanes[] = $plan->nombre;
											}
											$sindescuento=0;

											if ($imprimePrimera===true) {
												$mejorHabitacion=$descripcion;
												$totales=($rooms->bookingRule->bookingAmount/$markup);
												$mejorPlan=$plan->nombre;

												if ($tarifaOutlet) {
													$sindescuento=$totales;
													$descuento=$outletController->descuentoOutlet($outlet->descuento_general,$row->id_hotel,4);
													$totales = $outletController->tarifaOutletVirtual($totales,0,20,$descuento);
												}

												$tarifa[$row->id_hotel]['Desglose']['tarifas'] = $countRooms;
												$tarifa[$row->id_hotel]['Desglose']['mejorHabitacion'] = $mejorHabitacion;
												$tarifa[$row->id_hotel]['Desglose']['mejorPlan'] = $mejorPlan;
												$tarifa[$row->id_hotel]['Desglose']['menorPrecio'] = number_format($totales,2);
												$tarifa[$row->id_hotel]['Desglose']['menorPrecioSinDescuento'] = 0; //number_format($sindescuento,2);
												$tarifa[$row->id_hotel]['Desglose']['moneda'] = $currencyCode;
												$tarifa[$row->id_hotel]['Desglose']['banderaBootom'] = false;
												$tarifa[$row->id_hotel]["Desglose"]["imagenOutlet"]=$outlet_image;

												if($currencyCode=="USD") {
													$tarifa[$row->id_hotel]['Desglose']["menorPrecio"] = number_format($totales,2);
													$menorTarifaMXN = 19.5000*$totales;
													$tarifa[$row->id_hotel]['Desglose']["menorPrecio_mxn"] = number_format($menorTarifaMXN,2);
												}

											}

											$numDias = $rooms->bookingRule->numDays;
											$quoteType = $rooms->bookingRule->quoteType;
											$infants = $rooms->bookingRule->infantsCount;
											$adults = $rooms->bookingRule->adultsCount;
											$childs = $rooms->bookingRule->childCount;
											$rate_Plan = $rooms->bookingRule->rateHotel;
											$precio_neto = $rooms->bookingRule->bookingAmount;
											$fecha_inicio = $rooms->bookingRule->stayDateStart;
											$fecha_final = $rooms->bookingRule->stayDateEnd;
											$fecha_limite = $fechaCancelacion;
											$fecha_limiteH = $fecha_limite_h;
											$roomrates = base64_encode(json_encode($response)); 

											// $precio_neto = $reservacionController->saldoHotel($precio_neto,20,"comision");

											$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["nombre_hab"] = $descripcion;
											$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["id_tipo_habitacion"] = $idtipoHabitacion;
											$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["allotment"] = 1;
											$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["reservar"] = 1;
											$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["ratekey"] = 'RIU';
											$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["info_habitacion"] = $roomDescription;
											$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["habitaciones"] = "";

											$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["botonReservar"]=true;
											$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["tipo_boton"]="NORMAL";
											$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["hasAllotment"]=1;
											$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["btnHtml"]["color"]="green";

											$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["id_habitacion"]=$idtipoHabitacion;
											$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["id_plan"]=$plan->id_plan;
											$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["num_habs"]=$session["habs"];

											$activarLogoBuenFin = false;
											if ($imprimePrimera===true) {
												$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["primeraTarifa"] = true;
												$filtroHotel = FiltroHoteles::model()->findAll('id_hotel='.$row->id_hotel);

												if (count($filtroHotel)>0) {
													foreach ($filtroHotel as $ftr => $filtro) {
														array_push($temasFiltros, $filtro->idFiltro->descripcion);
													}
												}

												if (strtotime($fecha_actual)>=strtotime($fecha_inicial_buen_fin) && strtotime($fecha_actual)<=strtotime($fecha_final_buen_fin)) {
													$activarLogoBuenFin = true;
												}

												$tarifa[$row->id_hotel]["Filtro"]["temas"] = $temasFiltros;


											}else{
												$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["primeraTarifa"] = false;
											}

											if (is_numeric($keys[0])) {
												####### mas de 1 habs
												foreach ($rooms->bookingRule->roomStayList->RoomStay as $key => $cuarto) {

													$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["tipo_hab"] = $cuarto->roomTypeCode;
													$montoPagar=$roomKey/$markup;

													$sindescuento=0;

													if ($rooms->bookingRule->roomStayList->RoomStay[0]->roomTypeCode==$cuarto->roomTypeCode) {

														$montoRiu = ($cuarto->roomAmount/$markup);
														$sindescuento=$montoRiu;

														if ($tarifaOutlet) {
															$descuento=$outletController->descuentoOutlet($outlet->descuento_general,$row->id_hotel,4);
															$montoRiu = $outletController->tarifaOutletVirtual($montoRiu,0,20,$descuento);
															$montoPagar = $outletController->tarifaOutletVirtual($montoPagar,0,20,$descuento);
														}

														$roomNumber = (int) $cuarto->roomNumber-1;

														$desglosePersona = array();

														$desglosePersona['habitacion'][$cuarto->roomNumber] = $riuController->desglosePersonas($cuarto->roomGuestsList->RoomGuests, $rooms->bookingRule->numDays, $adultos=null, $rooms->bookingRule->childCount, $cuarto->roomNumber, $markup, $row->id_hotel,$session,$currencyCode,$outlet,$tarifaOutlet);

														if (strtotime($fecha_actual)>=strtotime($fecha_inicial_buen_fin) && strtotime($fecha_actual)<=strtotime($fecha_final_buen_fin) && $activarLogoBuenFin==true) {
															$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][$roomNumber]["activarLogoBuenFin"] = $activarLogoBuenFin;
														}

														$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][$roomNumber]["id_plan"]=$plan->id_plan;
														$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][$roomNumber]["tipo_plan"]=$plan->nombre;
														$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][$roomNumber]["nombrePlan"]=$plan->nombre;
														$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][$roomNumber]["mealplan"]=$rooms->bookingRule->mealPlan;
														$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][$roomNumber]["alerta_disponibilidad"]=1;
														$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][$roomNumber]["ratePlanDescription"]="";
														$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][$roomNumber]["icon_politicas_cancelacion"]=$cancelPenalties;
														$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][$roomNumber]["politicas_cancelacion"]=$cancelPenalties;
														$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][$roomNumber]["fecha_limite"]=$fechaCancelacion;
														$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][$roomNumber]["fecha_limiteH"]=$fecha_limite_h;
														$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][$roomNumber]["tarifadiaria"]=0;
														$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][$roomNumber]["tarifa"]=0;
														$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][$roomNumber]["calendario"]=$desglosePersona;
														$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][$roomNumber]["precio"]= number_format($montoRiu,2);
														$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][$roomNumber]["precioSinDescuento"]= number_format($sindescuento,2);

														$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][$roomNumber]["precio_neto"]=$precio_neto;
														$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][$roomNumber]["moneda"]=$currencyCode;
														$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][$roomNumber]["offers"]="";
														$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][$roomNumber]["roomrates"]=$roomrates;
														$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][$roomNumber]["roomType"]=base64_encode($roomTypeCode);
														$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][$roomNumber]["ratePlan"]=base64_encode($rate_Plan);
														$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][$roomNumber]["reembolsable"]="";

														$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][$roomNumber]["num_cuarto"]=$cuarto->roomNumber;
														$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][$roomNumber]["numDias"]=$numDias;
														$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][$roomNumber]["quoteType"]=$quoteType;
														$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][$roomNumber]["infants"]=$infants;
														$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][$roomNumber]["adults"]=$adults;
														$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][$roomNumber]["childs"]=$childs;
														$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][$roomNumber]["fecha_inicio"]=$fecha_inicio;
														$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][$roomNumber]["fecha_final"]=$fecha_final;
														$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][$roomNumber]["rateReference"]=$rateReference;


														####### se crea cuando se tiene mas de 2 habitaciones
														$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["Total_planes"]["precio"]=number_format($montoPagar,2);
														$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["Total_planes"]["precio_neto"]=$precio_neto;
														$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["Total_planes"]["moneda"]=$currencyCode;

														$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["Total_planes"]["id_plan"]=$plan->id_plan;
														$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["Total_planes"]["tipo_plan"]=$plan->nombre;

														$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["Total_planes"]["mealplan"]=$rooms->bookingRule->mealPlan;
														$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["Total_planes"]["politicas_cancelacion"]=$cancelPenalties;
														$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["Total_planes"]["fecha_limite"]=$fechaCancelacion;
														$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["Total_planes"]["fecha_limiteH"]=$fecha_limite_h;
														$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["Total_planes"]["roomrates"]=$roomrates;
														$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["Total_planes"]["roomType"]=base64_encode($roomTypeCode);
														$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["Total_planes"]["ratePlan"]=base64_encode($rate_Plan);
														$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["Total_planes"]["quoteType"]=$quoteType;
														$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["Total_planes"]["infants"]=$infants;
														$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["Total_planes"]["adults"]=$adults;
														$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["Total_planes"]["childs"]=$childs;
														$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["Total_planes"]["rateReference"]=$rateReference;

														######

													}

												}

											}else{
												##### 1 habitacion
												$y=0;
												$roomTypeCodes = $rooms->bookingRule->roomStayList->RoomStay->roomTypeCode;

												$desglosePersona['habitacion'][1] = $riuController->desglosePersonas($rooms->bookingRule->roomStayList->RoomStay->roomGuestsList->RoomGuests, $rooms->bookingRule->numDays, $rooms->bookingRule->adultsCount, $rooms->bookingRule->childCount, $rooms->bookingRule->roomsCount, $markup, $row->id_hotel,$session,$currencyCode,$outlet,$tarifaOutlet);
												$sindescuento=0;

												if (strtotime($fecha_actual)>=strtotime($fecha_inicial_buen_fin) && strtotime($fecha_actual)<=strtotime($fecha_final_buen_fin) && $activarLogoBuenFin==true) {
													$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][0]["activarLogoBuenFin"] = $activarLogoBuenFin;
												}

												$montoRiu = ($rooms->bookingRule->bookingAmount/$markup);
												$sindescuento= $montoRiu;

												if ($tarifaOutlet) {
													$descuento=$outletController->descuentoOutlet($outlet->descuento_general,$row->id_hotel,4);
													$montoRiu = $outletController->tarifaOutletVirtual($montoRiu,0,20,$descuento);
												}

												$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["tipo_hab"] = $roomTypeCodes;

												$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["Total_planes"]=null;

												$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][0]["id_plan"]=$plan->id_plan;
												$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][0]["tipo_plan"]=$plan->nombre;
												$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][0]["mealplan"]=$rooms->bookingRule->mealPlan;
												$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][0]["nombrePlan"]=$plan->nombre;
												$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][0]["alerta_disponibilidad"]=1;
												$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][0]["ratePlanDescription"]="";
												$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][0]["icon_politicas_cancelacion"]=$cancelPenalties;
												$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][0]["politicas_cancelacion"]=$cancelPenalties;
												$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][0]["fecha_limite"]=$fechaCancelacion;
												$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][0]["fecha_limiteH"]=$fecha_limite_h;
												$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][0]["tarifadiaria"]=0;
												$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][0]["tarifa"]=0;
												$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][0]["calendario"]= $desglosePersona;
												$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][0]["precio"]= number_format($montoRiu,2);
												$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][0]["precioSinDescuento"]= number_format($sindescuento,2);
												$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][0]["precio_neto"]=$precio_neto;
												$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][0]["moneda"]=$currencyCode;
												$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][0]["offers"]="";
												$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][0]["roomrates"]=$roomrates;
												$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][0]["roomType"]=base64_encode($roomTypeCode);
												$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][0]["ratePlan"]=base64_encode($rate_Plan);
												$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][0]["reembolsable"]="";

												$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][0]["num_cuarto"]=1;
												$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][0]["numDias"]=$numDias;
												$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][0]["quoteType"]=$quoteType;
												$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][0]["infants"]=$infants;
												$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][0]["adults"]=$adults;
												$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][0]["childs"]=$childs;
												$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][0]["fecha_inicio"]=$fecha_inicio;
												$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][0]["fecha_final"]=$fecha_final;
												$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["plan"][0]["rateReference"]=$rateReference;

											}


											$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["warning"]["tarifaVacia"]=false;
											$tarifa[$row->id_hotel]["Habitaciones"][$cuartosRiu]["Planes"][0]["warning"]["mensaje"]="";

											$tarifa[$row->id_hotel]["Filtro"]["planes"]['codigos']=$planesArray;
											$tarifa[$row->id_hotel]["Filtro"]["planes"]['tipos']=$hotelesPlanes;

											$imprimePrimera=false;
											$cuartosRiu++;

										}

									####### FIN IF
									}else{

										if ($contarHotel>1) {
											unset($tarifa[$row->id_hotel]);
										}else{
											$tarifa[$row->id_hotel]["Warning"]["warning"]=true;
											$tarifa[$row->id_hotel]["Warning"]["mensaje"]=$errorMsj;
										}

									}

									if ($contarHotel>1) {
										if(empty($hotelAvail[0]['HotelAvailResponse']['HotelAvailResponse']['availabilityList'])){
											unset($tarifa[$row->id_hotel]);
										}

										if ($hotelAvail[0]['soapFault']['detail']['ExcepcionesNegocio']['errores']['ErroresDto'][0]['codigoError']=="EX005"){
											unset($tarifa[$row->id_hotel]);
										}
									}
								}
							}

							// echo json_encode($desglosePersona);
							// exit;

							$responseWs = $tarifa;
						} catch (Exception $e) {
							$mensaje_de_error["500_4"]["Proveedor_4"] = "Mensaje: ".$e->getMessage()." <br> Codigo: ".$e->getCode()." <br> Archivo: ".$e->getFile()." <br> Linea: ".$e->getLine();
							$responseWs = $mensaje_de_error;
						}
					break;

					case 5:
						try {
							$dingusController = Yii::app()->createController('dingus');
							$dingusController = $dingusController[0];
							$planDingusArray = array();

							foreach ($hoteles as $killing => $row) {
								$ninios = 0;
								$errorMsj="";
								$code=explode("/", $row->codigo);
								$mealplanArray=array(1=>'AI', 2=>'SC', 3=>'BB', 51=>'HB', 37=>'FB');

								$hotel= Hoteles::model()->findByPk($row->id_hotel);
								$hotelAvail=$dingusController->hotelAvail($code[0], $hotel->Cadena->url_dingus, $row->id_hotel, $session);
								$hotelAvails=json_decode($hotelAvail,true);
								$markup=((100-$hotel->comision)/100);
								$hotelesOutlet = $outletController->hotelesOutlet($row->id_hotel,5,$session['outlet']);
									$outletImg="logo-precio-especial-sur4.png";
								if ($hotelesOutlet) {
									$outletImg="logo-outlet-verano-web-sur4.png";
								}
								if ($tarifaOutlet && $outletController->hotelesDestacados($outlet,$row->id_hotel) == 1) {
									$outletImg="logo-precio-destacado-sur4.png";
								}
								$tarifaDingus[$row->id_hotel]['id_hotel'] = $hotel->id_hotel; 
								$tarifaDingus[$row->id_hotel]['nombre_hotel'] = $hotel->nombre_hotel; 
								$tarifaDingus[$row->id_hotel]['beneficio'] = $hotel->Beneficios->beneficio;
								$tarifaDingus[$row->id_hotel]['destacado'] = $destacadosController->hotelesDestacados($row->id_hotel); 
								$tarifaDingus[$row->id_hotel]['code_hotel'] = $code[0]; 
								$tarifaDingus[$row->id_hotel]['markup'] = $markup; 
								$tarifaDingus[$row->id_hotel]['imagenOutlet'] = $outletImg;
								$tarifaDingus[$row->id_hotel]['observaciones'] = $hotel->observaciones;
								$tarifaDingus[$row->id_hotel]['ubicacion'] = $hotel->ubicacion;
								$tarifaDingus[$row->id_hotel]['estrellas'] =(int) $hotel->id_categoria;
								$tarifaDingus[$row->id_hotel]['proveedor'] = $hotel->proveedor;
								$tarifaDingus[$row->id_hotel]['destino']['name'] = $hotel->Destino->name;
								$tarifaDingus[$row->id_hotel]['destino']['destinationsCode0'] = $hotel->Destino->destinationsCode0->name;
								$tarifaDingus[$row->id_hotel]['destino']['zonasCode'] = $hotel->Destino->idZona;
								$tarifaDingus[$row->id_hotel]['foto'] = $siteController->getNameProveedor($hotel->id_hotel,$hotel->proveedor);

								#################### CODIGO QUE SE PROGRAMO EN 'COTIZACIONRAPIDADINGUS' ###########################

								for ($i=1; $i < $session['habs'] ; $i++) { 
									$niños += $session['habitacion_'.$i]['num_ninios'];
								}

								if (empty($hotelAvails) && $niños>0 && $errorMsj=='') {
									$errorMsj = "Tal vez el hotel no acepte niños o Se considere a menores de mas de 12 años como adultos. Intente con un hotel diferente.";
								}
								if (empty($hotelAvails) && $errorMsj=='') {
									$errorMsj = "No hay tarifa para la fecha solicitada. Por favor Modifique su busqueda.";
								}
								$roomstype = '';
								$roomstype = $dingusController->roomsrates($hotelAvails,$session["habs"]);

								if (empty($roomstype) && $errorMsj=='') {
									$errorMsj = 'Al parecer no hay tarifas validas para la estancia que solicito, intente con otras fechas';
								}

								if (empty($errorMsj)) {
									$firstKey = '';
									$countRooms=count($hotelAvails);
									$countRates=count($hotelAvails['RoomStay']['RoomRates']['RoomRate']);
									// $temasFiltros = '';
									$temasFiltros = array();

									if ($countRooms>1) {
										$firstKey=0;
									}else{
										$firstKey='RoomStay';
									}

									$hotelCode=$hotelAvails[$firstKey]['BasicPropertyInfo']['@attributes']['HotelCode'];
									$hotelName=$hotelAvails[$firstKey]['BasicPropertyInfo']['@attributes']['HotelName'];
									$chainCode=$hotelAvails[$firstKey]['BasicPropertyInfo']['@attributes']['ChainCode'];
									$hotelCityCode=$hotelAvails[$firstKey]['BasicPropertyInfo']['@attributes']['HotelCityCode'];

									$imprimePrimera=true;
									$countRoomType=count($roomstype);
									$cuartosDingus=0;
									$planesArray = array();
									$hotelesPlanes = array();
									foreach ($roomstype as $keys => $value) {
										$roomDescription=$keys;  
										$descripcion=$dingusController->roomstypecode($hotelAvails, $keys);
										$allotment=$descripcion[1]; 

										$tipoHabitacion= TipoHabitaciones::model()->find('codigo="'.$keys.'" AND id_hotel='.$row->id_hotel);

										if (!$tipoHabitacion->codigo) {
											$tipoHab = new TipoHabitaciones();
											$tipoHab->tipo_habitacion=$descripcion[0];
											$tipoHab->descripcion=$descripcion[0];
											$tipoHab->codigo=$keys;
											$tipoHab->id_hotel=$row->id_hotel;

											if($tipoHab->save())
												$idhabitacion=$tipoHabitacion->id_tipo_habitacion;
											$idtipoHab = $tipoHabitacion->id_tipo_habitacion;

										}else{
											$idhabitacion=$tipoHabitacion->id_tipo_habitacion;
											$idtipoHab = $tipoHabitacion->id_tipo_habitacion;
										}


										$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["tipo_hab"]=$keys;
										$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["nombre_hab"]=$descripcion[0];
										$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["id_tipo_habitacion"]=$idtipoHab;
										$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["allotment"]= $allotment;
										$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["reservar"]= 1;
										$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["ratekey"]= "DI";
										$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["info_habitacion"]=$roomDescription;
										$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["habitaciones"]=$descripcion[1];

										$primerMeal=true;

										$i=0;
										$totalneto=0;
										foreach ($value as $meal => $room) {

											$totalAmount=0;
											$totalneto=0;

											foreach ($room as $rateCode => $cuartos){

												ksort($cuartos);

												$totalAmount=0;
												$totalneto=0;
												
												$amountAfterTax=0;
										
												foreach ($cuartos as $room => $cuarto) {
													$keysArray=array_keys($cuarto['Rates']['Rate']);
													$fechainicio = $cuarto['Rates']['Rate']['@attributes']['EffectiveDate'];
													if (is_numeric($keysArray[0])) {
														$fechainicio=$cuarto['Rates']['Rate'][0]['@attributes']['EffectiveDate'];
													}
													$fechafinal = $cuarto['Rates']['Rate']['@attributes']['ExpireDate'];
													$rph=$room;
													$rphPlan = $rph-1;
													$tableCancelPenalties = array();

													$impfirst=true;
													$twInicio="2020-10-01";
													$twFinal="2020-10-30";
													$pInicio="2020-08-19";
													$pFinal="2020-09-10";
													
													$fechasTarifa=false;
													// && ($pInicio>=date('Y-m-d') && $pFinal>=date('Y-m-d'))
													if((strtotime($fechainicio) >= strtotime($twInicio) && strtotime($fechainicio) < strtotime($twFinal) && strtotime($fechafinal) >= strtotime($twInicio) && strtotime($twFinal)>=strtotime($fechafinal)) && ((date('Y-m-d')>=$pInicio && date('Y-m-d')<=$pFinal))){
														$fechasTarifa=true;
													}


													foreach ($cuarto['CancelPenalty'] as $key => $cancel) {
														if ($hotel->id_cadena==18 || $hotel->id_cadena==37) {
															$dateDif=$dingusController->dateDifference(date('Y-m-d'), $fechainicio);
															if (($hotel->id_cadena==18 && $dateDif<=18)||($hotel->id_cadena==37 && $dateDif<=10)) {
																	$fechalimite=date('Y-m-d H:i:s');
																	$fechali=date('d/m/Y H:i:s');
																if (($hotel->id_cadena==18 && $dateDif<15)||($hotel->id_cadena==37 && $dateDif<7))
																{
																	$fechalimite_h=date('Y-m-d');
																}else{
																	if ($hotel->id_cadena==18) {
																		
																		$fechalimite_h=date('Y-m-d', strtotime($fechainicio.' -15 day'));
																	}else{

																		$fechalimite_h=date('Y-m-d', strtotime($fechainicio.' -7 day'));
																	}
																}
																
															}else {
																if ($impfirst==true) {
																	if ($hotel->id_cadena==18) {
																		$fechalimite=date('Y-m-d', strtotime($fechainicio.' - 18 day'));
																		$fechalimite_h=date('Y-m-d', strtotime($fechainicio.' - 15 day'));	
																		$fechali=date('d/m/Y', strtotime($fechainicio.' - 19 day'));
																	}else{
																		$fechalimite=date('Y-m-d', strtotime($fechainicio.' - 10 day'));
																		$fechalimite_h=$fechalimite=date('Y-m-d', strtotime($fechainicio.' - 7 day'));
																		$fechali=date('d/m/Y', strtotime($fechainicio.' - 11 day'));
																	}
																}
															}
														}else{
															$dateDif=$dingusController->dateDifference(date('Y-m-d'), $cancel['@attributes']['Start']);
															$dateCancelm5=strtotime($cancel['@attributes']['Start']." -6 day");
															$dateCancelm6=strtotime($cancel['@attributes']['Start']." -5 day");
															$dateCancelm1=strtotime($cancel['@attributes']['Start']." -1 day");

															;
															$hoy=strtotime(date('Y-m-d'));
															if ($impfirst==true) {
																if ($dateDif<5) {
																	$fechalimite=date('Y-m-d H:i:s');
																	$fechali=date('d/m/Y H:i:s');

																}else{
																	$fechalimite=date('Y-m-d H:i:s', $dateCancelm5);
																	$fechali=date('d/m/Y', $dateCancelm6);
																}
																$fechalimite_h=date('Y-m-d H:i:s',$dateCancelm1);
																if ($dateCancelm1<=$hoy){
																	$fechalimite_h=date('Y-m-d H:i:s');
																	$fechalimite=date('Y-m-d H:i:s');
																	$fechali=date('d/m/Y H:i:s');
																}
															}
														}

														$cancelPenalty= " Apartir del: ".$fechali." tendra un  monto de cancelacion del ".$cancel['PenaltyDescription']." un monto total de: ".number_format(($cancel['AmountPercent']/$markup),2).".";
														
														$tableCancelPenalties[$room]['descripcion'] = $cancel['PenaltyDescription'];
														$tableCancelPenalties[$room]['fecha_limite_inicial'] = $fechali;
														$tableCancelPenalties[$room]['precio'] = number_format(($cancel['AmountPercent']/$markup),2).' '.$cuarto['Total']['@attributes']['CurrencyCode'];
														
														if($cancel['@attributes']['NonRefundable']=="false" || $cancel['@attributes']['NonRefundable']==""){
															$reembolsable="";
														}else{
															$reembolsable=" No reembolsable ";
															$tableCancelPenalties[$room]['nota'] = $reembolsable;
														}
														if($outlet->estatus==1 && (date('Y-m-d') >= $outlet->fecha_inicio && date('Y-m-d') <= $outlet->fecha_final) ){
															$fechalimite=$outletController->fechalimiteOutlet($row->id_hotel,date('Y-m-d',strtotime($fechainicio)),5,null,$fechalimite);
															$cancelPenalty= " Apartir del: ".date('d/m/Y',strtotime($fechalimite.'-1 days'))." tendra un  monto de cancelacion del ".$cancel['PenaltyDescription']." un monto total de: ".number_format(($cancel['AmountPercent']/$markup),2).".";
															$tableCancelPenalties[$room]['fecha_limite_inicial']=date('d/m/Y',strtotime($fechalimite));
														
														}
														$impfirst=false;		
													}

													$habitacion=$cuarto['@attributes']['NumberOfUnits'];
													$mealPlanCode = $cuarto['@attributes']['MealPlanCodes'];
													$mealPlanCodeD = $cuarto['@attributes']['MealPlanCodes'];
													$mealPlanDescription = $meal;
													$roomTypeCode = $cuarto['@attributes']['RoomTypeCode'];
													$allotmen=$cuarto['@attributes']['NumberOfUnits'];
													$ratePlancode=$cuarto['@attributes']['RatePlanCode'];
													$ratePlanID=$cuarto['@attributes']['RatePlanID'];
													$ratePlanCode=$cuarto['@attributes']['RatePlanCode'];
													$roomAmountBeforeTax = $cuarto['Rates']['Rate']['Base']['@attributes']['AmountBeforeTax'];
													$fechainicio = $cuarto['Rates']['Rate']['@attributes']['EffectiveDate'];
													$fechafinal = $cuarto['Rates']['Rate']['@attributes']['ExpireDate'];
													$amountAfterTax= $cuarto['Total']['@attributes']['AmountAfterTax'];
													$amountTotal=$amountAfterTax/$markup;
													$totalneto+=$amountAfterTax;
													$totalAmount+=$amountTotal;
													$currencyCode=$cuarto['Total']['@attributes']['CurrencyCode'];
													$tipoTarifa=$cuarto['Rates']['Rate']['RateDescription'];
													$tipoHab=$roomTypeCode;
													switch ($mealPlanCode) {
														case 'TI':
														$mealPlanCode="AI";
														break;
														case 'SA':
														$mealPlanCode="SC";
														break;
														case 'AD':
														$mealPlanCode="BB";
														break;
														case 'MP':
														$mealPlanCode="HB";
														break;
														case 'PC':
														$mealPlanCode="FB";
														break;

														default:
														break;
													}
													$ratesRoom[$room]=$cuarto['Rates']['Rate'];

													$plan=Plan::model()->find('code="'.$mealPlanCode.'"');

													$tablaDesglose=array();
													$tablaDesglose['habitacion'][$rphPlan+1]= $dingusController->desglosePersonas($ratesRoom[$room], $markup,$session['fecha_ini'],$session['fecha_fin'],$session,$rphPlan+1,$tarifaOutlet,$outlet,$hotelesOutlet,$fechasTarifa,$hotel->id_hotel);

													$activarLogoBuenFin = false;

													if ($tarifaOutlet && !$hotelesOutlet) {
														$totalAmount = $outletController->tarifaOutletVirtual($totalAmount,$totalneto,$hotel->comision,$outlet->descuento_general);
													}

													if ($imprimePrimera==true && $primerMeal==true) {
														$primerasindescuento=0;
														if($row->id_hotel==177912 && $fechasTarifa){
															$primerasindescuento=$totalAmount;
															$totalAmount = $dingusController->descuentoTemporal($totalAmount,$totalneto,$hotel->comision,10);
														}

														$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["primeraTarifa"]=true;
														$mejorHabitacion=$descripcion[0];
														$menorPrecio=$totalAmount;
														$mejorPlan=$meal;
														$monedaPrimeraTarifa=$currencyCode;
														$primerPlanFiltro=array_search($mealPlanCode,$mealplanArray);

														$filtroHotel = FiltroHoteles::model()->findAll('id_hotel='.$row->id_hotel);

														if (count($filtroHotel)>0) {
															foreach ($filtroHotel as $ftr => $filtro) {
																array_push($temasFiltros, $filtro->idFiltro->descripcion);
															}
														}

														if (strtotime($fecha_actual)>=strtotime($fecha_inicial_buen_fin) && strtotime($fecha_actual)<=strtotime($fecha_final_buen_fin) && $mealPlanCode=="AI") {
															$activarLogoBuenFin = true;
															$tarifaDingus[$row->id_hotel]["activarLogoBuenFin"] = true;
														}

														$tarifaDingus[$row->id_hotel]["Filtro"]["temas"] = $temasFiltros;

													}else{
														$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["primeraTarifa"]=false;

													}

													if (!in_array((int) $plan->id_plan,$planesArray)) {
														array_push($planesArray,(int) $plan->id_plan);
														$hotelesPlanes[] =  $meal;
													}

													$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["botonReservar"]=true;
													$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["num_habs"]=$session["habs"];
													$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["tipo_boton"]="NORMAL";
													$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["hasAllotment"]=$allotment;
													$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["id_plan"]=$plan->id_plan;
													$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["id_habitacion"]=$idtipoHab;
													$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["btnHtml"]["color"]="green";
													if ($session['outlet']=='grupos' && $hotelesOutlet && $outlet) {
															//$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["botonReservar"]=false;
															$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["tipo_boton"]="OUTLETGRUPOS";
															$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["btnHtml"]=$link=Yii::app()->createUrl("admin/gruposCotizaciones/create/idTarifa/".$rateCode."/idHotel/".$row->id_hotel."/idHabitacion/".$idtipoHab);
													}	
													if (strtotime($fecha_actual)>=strtotime($fecha_inicial_buen_fin) && strtotime($fecha_actual)<=strtotime($fecha_final_buen_fin)) {
															$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["plan"][$rphPlan]["activarLogoBuenFin"]=$activarLogoBuenFin;
													}

													$sindescuento=0;
													if ($tarifaOutlet && !$hotelesOutlet) {
														$sindescuento=$amountTotal;
														$amountTotal = $outletController->tarifaOutletVirtual($amountTotal,$amountAfterTax,$hotel->comision,$outlet->descuento_general);
													}

													if($row->id_hotel==177912  && $fechasTarifa ){
														$sindescuento=$amountTotal;
														$amountTotal = $dingusController->descuentoTemporal($amountTotal,$amountAfterTax,$hotel->comision,10);
													}


													$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["plan"][$rphPlan]["tipo_plan"]=$meal;
													$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["plan"][$rphPlan]["id_plan"]=$plan->id_plan;
													$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["plan"][$rphPlan]["nombrePlan"]=$meal;
													$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["plan"][$rphPlan]["codehotel"]=base64_encode($hotelCode);
													$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["plan"][$rphPlan]["alerta_disponibilidad"]=1;
													$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["plan"][$rphPlan]["ratePlanDescription"]="";
													$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["plan"][$rphPlan]["icon_politicas_cancelacion"]=$tableCancelPenalties;
													$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["plan"][$rphPlan]["politicas_cancelacion"]=$cancelPenalty;
													$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["plan"][$rphPlan]["fecha_limite"]=$fechalimite;
													$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["plan"][$rphPlan]["fecha_limiteH"]=$fechalimite_h;
													$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["plan"][$rphPlan]["tarifadiaria"]="";
													$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["plan"][$rphPlan]["tarifa"]=0;
													$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["plan"][$rphPlan]["calendario"]=$tablaDesglose;
													$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["plan"][$rphPlan]["precio"]=number_format($amountTotal,2);
													$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["plan"][$rphPlan]["precioSinDescuento"]=number_format($sindescuento,2);

													$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["plan"][$rphPlan]["precio_neto"]=$totalneto;
													$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["plan"][$rphPlan]["moneda"]=$currencyCode;
													$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["plan"][$rphPlan]["offers"]="";
													$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["plan"][$rphPlan]["roomrates"]=json_encode($ratesRoom);
													$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["plan"][$rphPlan]["ratePlan"]=base64_encode($ratePlancode);
													$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["plan"][$rphPlan]["roomtype"]=$roomTypeCode;
													$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["plan"][$rphPlan]["totalRate"]="";
													$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["plan"][$rphPlan]["reembolsable"]=$reembolsable;
													$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["plan"][$rphPlan]["rateCode"]=$rateCode;

													$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["plan"][$rphPlan]["num_cuarto"]=$rph;
													$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["plan"][$rphPlan]["mealPlanCode"]=$mealPlanCodeD;
													$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["plan"][$rphPlan]["idhabitacion"]=$idhabitacion;
													$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["plan"][$rphPlan]["chaincode"]=$chainCode;

													// SI SON MAS DE 1 Habitacion
													if ($session["habs"]>1) {
														$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["Total_planes"]["tipo_plan"]=$meal;
														$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["Total_planes"]["id_plan"]=$plan->id_plan;
														$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["Total_planes"]["codehotel"]=base64_encode($hotelCode);
														$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["Total_planes"]["precio"]=number_format($totalAmount,2);
														$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["Total_planes"]["precioSinDescuento"]=number_format($sindescuento,2);
														$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["Total_planes"]["moneda"]=$currencyCode;
														$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["Total_planes"]["precio_neto"]=$totalneto;
														$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["Total_planes"]["roomrates"]=json_encode($ratesRoom);
														$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["Total_planes"]["ratePlan"]=base64_encode($ratePlancode);
														$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["Total_planes"]["roomtype"]=$roomTypeCode;
														$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["Total_planes"]["fecha_limite"]=$fechalimite;
														$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["Total_planes"]["fecha_limiteH"]=$fechalimite_h;
														$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["Total_planes"]["politicas_cancelacion"]=$cancelPenalty;
														// $tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["Total_planes"]["tipo_plan"]=$meal;
														$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["Total_planes"]["chaincode"]=$chainCode;
														$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["Total_planes"]["mealPlanCode"]=$mealPlanCodeD;

														$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["Total_planes"]["reembolsable"]=$reembolsable;
													}else{
														$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["Total_planes"]=null;

													}


													$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["warning"]["tarifaVacia"]=false;
													$tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]["warning"]["mensaje"]="";

													if ($session['habs']>$descripcion[1]){
														unset($tarifaDingus[$row->id_hotel]["Habitaciones"][$cuartosDingus]["Planes"][$i]);
													}

												}

												$i++;
												$primerMeal=false;
											}
										}

									######################
										$cuartosDingus++;
										$imprimePrimera=false;
									}

									if ($countRooms>1 || $countRoomType>1 || $countRates>1) {
										$tarifas=$countRooms;
									}else{
										$tarifas=$countRooms;
									}

									$tarifaDingus[$row->id_hotel]["Desglose"]["tarifas"]= $tarifas;
									$tarifaDingus[$row->id_hotel]["Desglose"]["mejorHabitacion"]= $mejorHabitacion;
									$tarifaDingus[$row->id_hotel]["Desglose"]["mejorPlan"]= $mejorPlan;
									$tarifaDingus[$row->id_hotel]["Desglose"]["menorPrecio"]= number_format($menorPrecio,2);
									$tarifaDingus[$row->id_hotel]["Desglose"]["menorPrecioSinDescuento"]= number_format($primerasindescuento,2);
									$tarifaDingus[$row->id_hotel]["Desglose"]["diferenciaDescuento"]= number_format($menorPrecio-$primerasindescuento,2);
									$tarifaDingus[$row->id_hotel]["Desglose"]["moneda"]= $monedaPrimeraTarifa;
									$tarifaDingus[$row->id_hotel]["Desglose"]["banderaBootom"]= false;

									if($monedaPrimeraTarifa=="USD") {
										$tarifaDingus[$row->id_hotel]["Desglose"]["menorPrecio"] = number_format($menorPrecio,2);
										$menorTarifaMXN = 19.5000*$menorPrecio;
										$tarifaDingus[$row->id_hotel]["Desglose"]["menorPrecio_mxn"] = number_format($menorTarifaMXN,2);
									}

									$tarifaDingus[$row->id_hotel]["Filtro"]["planes"]['codigos']= $planesArray;
									$tarifaDingus[$row->id_hotel]["Filtro"]["planes"]['tipos']= $hotelesPlanes;


								}else{

									if ($contarHotel>1) {
										unset($tarifaDingus[$row->id_hotel]);
									}else{

										$tarifaDingus[$row->id_hotel]["Warning"]["warning"]= true;
										$tarifaDingus[$row->id_hotel]["Warning"]["mensaje"] = $errorMsj;
									}

									if (empty(json_decode($hotelAvail)) && $contarHotel>1) {
										unset($tarifaDingus[$row->id_hotel]);
									}

								}

							}
							// echo json_encode($tablaDesglose);
							// exit;
							$responseWs = $tarifaDingus;
						} catch (Exception $e) {
							$mensaje_de_error["500_5"]["Proveedor_5"] = "Mensaje: ".$e->getMessage()." <br> Codigo: ".$e->getCode()." <br> Archivo: ".$e->getFile()." <br> Linea: ".$e->getLine();
							$responseWs = $mensaje_de_error;
						}
					break;

					case 6:
						try {
							$tarifasPalace = array(); 

							$palaceController = Yii::app()->createController('palace');
							$palaceController = $palaceController[0];

							$apiPalace = Api::model()->findByPk(9);
							$markupPalace = $apiPalace->markup;

							$costoHabitacion=array();
							$m=0;
							$availability_exists = "";

							foreach ($hoteles as $killing => $row) {
								$code=explode("/", $row->codigo);
								$codigoHotelPalace=$code[0];
								$hotelID = Hoteles::model()->findByPk($row->id_hotel);


								$AvailabilityPalace = $palaceController->ObtenerDisponibilidad($resultadoBusquedaHoteles->fecha_inicial,$resultadoBusquedaHoteles->noches,$codigoHotelPalace,$session);

								// echo $AvailabilityPalace;
								// exit;
								$tarifasPalace[$row->id_hotel]=json_decode($AvailabilityPalace);
								$hotelRooms=json_decode($AvailabilityPalace,true);

								$availPalace=array();
								$errormsj=array();
								$tarifa[$hotelID->id_hotel]['id_hotel'] = $hotelID->id_hotel; 
								$tarifa[$hotelID->id_hotel]['nombre_hotel'] = $hotelID->nombre_hotel;
								$tarifa[$hotelID->id_hotel]['beneficio'] = $hotelID->Beneficios->beneficio;
								$tarifa[$hotelID->id_hotel]['code_hotel'] = $row->codigo; 
								$tarifa[$hotelID->id_hotel]['markup'] = $apiPalace->markup; 
								$tarifa[$hotelID->id_hotel]['observaciones'] = $hotelID->observaciones;
								$tarifa[$hotelID->id_hotel]['ubicacion'] = $hotelID->ubicacion;
								$tarifa[$hotelID->id_hotel]['estrellas'] = (int) $hotelID->id_categoria;
								$tarifa[$hotelID->id_hotel]['proveedor'] = $hotelID->proveedor;
								$tarifa[$hotelID->id_hotel]['destino']['name'] = $hotelID->Destino->name;
								$tarifa[$hotelID->id_hotel]['destino']['destinationsCode0'] = $hotelID->Destino->destinationsCode0->name;
								$tarifa[$hotelID->id_hotel]['foto'] = $siteController->getNameProveedor($hotelID->id_hotel,$hotelID->proveedor);

								if (strtotime($fecha_actual)>=strtotime($fecha_inicial_buen_fin) && strtotime($fecha_actual)<=strtotime($fecha_final_buen_fin)) {
										$tarifa[$hotelID->id_hotel]["activarLogoBuenFin"] = true;
								}

								foreach ($hotelRooms[0]["Habitaciones"] as $habitacion) {
									if (count($habitacion["Ws"])==$session["habs"]) {
										foreach ($habitacion["Ws"] as $value) {
											if ($value["Data"]["Availability_Exists"] == "true") {
												$availableRooms[$y] = "true";
												$y++; 
											}else{
												$errormsj['Errores']=$value["ExceptionInfo"]["Message"];
											}
										}
										if (count($availableRooms)==$session["habs"]) {
											$availPalace[$habitacion["tipoHab"]]=$habitacion;
										}
										unset($availableRooms);
										$y=0;
									}else{
										$errormsj['Errores'] = "@ERR:000|No hay Tarifa disponible para el numero de ocupantes.";
									}
								}

								$contAvail=count($availPalace);
								$erroresMsj = count($errormsj);
								$habnull=0;
								$habcount=count($availPalace);
								$messageErrors=explode('|',$errormsj["Errores"]);

								if ($contAvail>$erroresMsj) {

								}elseif ($contAvail==$erroresMsj) {
									$mensajeError = $this->getErrores($messageErrors);
								}else{
									$mensajeError = $this->getErrores($messageErrors);
								}

								if ($contAvail>0) {
									$i=0;
									$politicasDeCancelacion='';
									$ratecodePalace = '';
									$botonReservar=true;
									$primeraTarifa=true;
									// $temasFiltros = '';
									$temasFiltros = array();
									$desglosePersonas = array();

									$contHabs = 0;
									foreach ($availPalace as $key => $value) {
										if ($value['Ws'][0]["TotalAmount"]>0) {
											$roomrates = array();
											$roomRate = array();
											$rates = array();
											$rate = array();

											$ratecodePalace='';
											$ratecodePalacexDia='';
											$tablaFechasDisponibles='';
											$tituloFechasDisponibles='';
											$iconTablaFechasDisponibles='';

											$idtipoHab = TipoHabitaciones::model()->find('codigo="'.$value["tipoHab"].'" and id_hotel='.$hotelID->id_hotel);

											$tarifa[$hotelID->id_hotel]["Habitaciones"][$contHabs]["tipo_hab"]=$value["tipoHab"];
											$tarifa[$hotelID->id_hotel]["Habitaciones"][$contHabs]["nombre_hab"]=$value["descripHab"];
											$tarifa[$hotelID->id_hotel]["Habitaciones"][$contHabs]["id_tipo_habitacion"]=$idtipoHab->id_tipo_habitacion;
											$tarifa[$hotelID->id_hotel]["Habitaciones"][$contHabs]["allotment"]= 1;
											$tarifa[$hotelID->id_hotel]["Habitaciones"][$contHabs]["reservar"]= 1;
											$tarifa[$hotelID->id_hotel]["Habitaciones"][$contHabs]["ratekey"]= "PALACE";
											$tarifa[$hotelID->id_hotel]["Habitaciones"][$contHabs]["info_habitacion"]="";
											$tarifa[$hotelID->id_hotel]["Habitaciones"][$contHabs]["habitaciones"]=0;


											$cancelaciones = $palaceController->cancelaciones($hotelID->id_hotel,$resultadoBusquedaHoteles->fecha_inicial);

											$tableRatecode = array();
											$desgloseFechas = array();

											$precioTotalHab=0;
											$precioNetoHab=0;
											for ($j=0; $j < $session['habs'] ; $j++) { 
												$rate[$j]=$value['Ws'][$j]['Data']['Availability']['dayAvailable'];
												$precioTotalHab += $value["Ws"][$j]["TotalAmount"]/$markupPalace;
												$precioNetoHab += $value["Ws"][$j]["TotalAmount"];

												if ($value['Ws'][$j]['Moneda']=="MXN") {
													$tipomoneda="MXN";
												}else{
													$tipomoneda="USD";
												}
											}

											$roomRate = $rate;
											$rate = $rate[0];
											if (count($rate) >= $resultadoBusquedaHoteles->noches) {
												for ($habRate = 0; $habRate < $session["habs"] ; $habRate++) {
													$rateCodeTarifa = $roomRate[$habRate];

													for ($dia = 0; $dia < $resultadoBusquedaHoteles->noches; $dia++) {
														$row = $rateCodeTarifa[$dia];

														if ($habRate==0) {

															$fecha = date("Y-m-d", strtotime($resultadoBusquedaHoteles->fecha_inicial." +".$dia." days"));

															$desgloseFechas['Fechas'][$dia]['fecha'] = date('d/m/Y',strtotime($fecha));

															if ($dia==0) {
																$ratecodePalace.= $row['RateCode'];
																$ratecodePalacexDia = $row['RateCode']; 
															}else{
																$ratecodePalace.= ",".$row['RateCode'];
															}

															$desgloseFechas['Fechas'][$dia]['estatus'] = 'success';
															$desgloseFechas['Fechas'][$dia]['disponible'] = true;
														}

														$tableRatecode['habitacion'][$habRate+1][$dia]['Fecha'] = date('d-m-Y',strtotime($resultadoBusquedaHoteles->fecha_inicial.'+'.$dia.' day'));
														$tableRatecode['habitacion'][$habRate+1][$dia]['Codigo'] = $ratecodePalacexDia;
													}

												}
												$boolfechasIncompletas = true;

											}else{
												$tarifa[$hotelID->id_hotel]['Habitaciones'][$contHabs]["Error"] = "No hay disponibilidad para ".$resultadoBusquedaHoteles->noches;
												$tarifa[$hotelID->id_hotel]['Habitaciones'][$contHabs]["NoDisponible"] = true;
											}

											if ($hotelRooms[0]["Disponibilidad2noches"]==true) {
												$precioTotalHab = $palaceController->disponibilidadPrecioEspecial($resultadoBusquedaHoteles->noches,$apiPalace->markup,$value['Ws'],$session);
												$precioNetoHab = $reservacionController->saldoHotel($precioTotalHab,$apiPalace->markup,"Api");
												$botonReservar = false;
												$tarifa[$hotelID->id_hotel]['Habitaciones'][$contHabs]["Planes"][0]['tipo_boton'] = "PROMOCION2NOCHES";
												$tarifa[$hotelID->id_hotel]['Habitaciones'][$contHabs]["Planes"][0]['btnHtml']["color"] = "orange";
												$tarifa[$hotelID->id_hotel]['Habitaciones'][$contHabs]["Planes"][0]['hasAllotment'] = 0;
											}else{
												$tarifa[$hotelID->id_hotel]['Habitaciones'][$contHabs]["Planes"][0]['tipo_boton'] = "NORMAL";
												$tarifa[$hotelID->id_hotel]['Habitaciones'][$contHabs]["Planes"][0]['btnHtml']["color"] = "green";
												$tarifa[$hotelID->id_hotel]['Habitaciones'][$contHabs]["Planes"][0]['hasAllotment'] = 1;
											}

											$activarLogoBuenFin = false;

											#### primeras tarifas
											if ($primeraTarifa==true) {
												$tarifa[$hotelID->id_hotel]['Habitaciones'][$contHabs]["Planes"][0]['primeraTarifa'] = true; 
												$tarifa[$hotelID->id_hotel]['Filtro']['planes'][0] = 1; 
												$menorPrecio = $precioTotalHab;
												$monedaPrimeraTarifa = $tipomoneda;
												$mejorHabitacion = $value["descripHab"];
												$mejorPlan = $hotelRooms[0]["tipoPlan"];
												$primeraTarifa=false;

												$filtroHotel = FiltroHoteles::model()->findAll('id_hotel='.$hotelID->id_hotel);

												if (count($filtroHotel)>0) {
													foreach ($filtroHotel as $ftr => $filtro) {
														array_push($temasFiltros, $filtro->idFiltro->descripcion);
													}
												}

												if (strtotime($fecha_actual)>=strtotime($fecha_inicial_buen_fin) && strtotime($fecha_actual)<=strtotime($fecha_final_buen_fin)) {
													$activarLogoBuenFin = true;
												}

												$tarifa[$hotelID->id_hotel]["Filtro"]["temas"] = $temasFiltros;

											}else{
												$tarifa[$hotelID->id_hotel]['Habitaciones'][$contHabs]["Planes"][0]['primeraTarifa'] = false; 
											}

											$tarifa[$hotelID->id_hotel]['Habitaciones'][$contHabs]["Planes"][0]['botonReservar'] = $botonReservar;
											$tarifa[$hotelID->id_hotel]['Habitaciones'][$contHabs]["Planes"][0]['id_habitacion'] = $idtipoHab->id_tipo_habitacion;;
											$tarifa[$hotelID->id_hotel]['Habitaciones'][$contHabs]["Planes"][0]['id_plan'] = 1;
											$tarifa[$hotelID->id_hotel]['Habitaciones'][$contHabs]["Planes"][0]['num_habs'] = $session["habs"];
											$tarifa[$hotelID->id_hotel]['Habitaciones'][$contHabs]["Planes"][0]['Total_planes'] = null;

											$desglosePersonas['habitacion'] = $palaceController->desglosePersonas($resultadoBusquedaHoteles->noches,$markupPalace,$resultadoBusquedaHoteles->fecha_inicial,$roomRate,$tipomoneda,$session);
											//planes
											//
											if (strtotime($fecha_actual)>=strtotime($fecha_inicial_buen_fin) && strtotime($fecha_actual)<=strtotime($fecha_final_buen_fin)) {
												$tarifa[$hotelID->id_hotel]['Habitaciones'][$contHabs]["Planes"][0]['plan'][0]['activarLogoBuenFin'] = $activarLogoBuenFin;
											}

											$tarifa[$hotelID->id_hotel]['Habitaciones'][$contHabs]["Planes"][0]['plan'][0]["id_plan"] = 1;
											$tarifa[$hotelID->id_hotel]['Habitaciones'][$contHabs]["Planes"][0]['plan'][0]["tipo_plan"] = $hotelRooms[0]["tipoPlan"];
											$tarifa[$hotelID->id_hotel]['Habitaciones'][$contHabs]["Planes"][0]['plan'][0]["nombrePlan"] = $hotelRooms[0]["tipoPlan"];
											$tarifa[$hotelID->id_hotel]['Habitaciones'][$contHabs]["Planes"][0]['plan'][0]["alerta_disponibilidad"] = 1;
											$tarifa[$hotelID->id_hotel]['Habitaciones'][$contHabs]["Planes"][0]['plan'][0]["ratePlanDescription"] = "";
											$tarifa[$hotelID->id_hotel]['Habitaciones'][$contHabs]["Planes"][0]['plan'][0]["icon_politicas_cancelacion"] = $cancelaciones['avisoCancelacion'];
											$tarifa[$hotelID->id_hotel]['Habitaciones'][$contHabs]["Planes"][0]['plan'][0]["politicas_cancelacion"] = $cancelaciones['avisoCancelacion'];
											$tarifa[$hotelID->id_hotel]['Habitaciones'][$contHabs]["Planes"][0]['plan'][0]["fecha_limite"] = $cancelaciones["fecha_cancelacion"];
											$tarifa[$hotelID->id_hotel]['Habitaciones'][$contHabs]["Planes"][0]['plan'][0]["fecha_limiteH"] = $cancelaciones["fecha_limiteH"];
											$tarifa[$hotelID->id_hotel]['Habitaciones'][$contHabs]["Planes"][0]['plan'][0]["tarifadiaria"] = 0;
											$tarifa[$hotelID->id_hotel]['Habitaciones'][$contHabs]["Planes"][0]['plan'][0]["tarifa"] = 0;
											$tarifa[$hotelID->id_hotel]['Habitaciones'][$contHabs]["Planes"][0]['plan'][0]["calendario"] = $desglosePersonas;
											$tarifa[$hotelID->id_hotel]['Habitaciones'][$contHabs]["Planes"][0]['plan'][0]["precio"] = number_format($precioTotalHab,2);
											$tarifa[$hotelID->id_hotel]['Habitaciones'][$contHabs]["Planes"][0]['plan'][0]["precio_neto"] = $precioNetoHab;
											$tarifa[$hotelID->id_hotel]['Habitaciones'][$contHabs]["Planes"][0]['plan'][0]["moneda"] = $tipomoneda;
											$tarifa[$hotelID->id_hotel]['Habitaciones'][$contHabs]["Planes"][0]['plan'][0]["roomrates"] = base64_encode(json_encode($roomRate));
											$tarifa[$hotelID->id_hotel]['Habitaciones'][$contHabs]["Planes"][0]['plan'][0]["ratePlan"] = $cancelaciones["fecha_cancelacion"];
											$tarifa[$hotelID->id_hotel]['Habitaciones'][$contHabs]["Planes"][0]['plan'][0]["reembolsable"] = "";
											$tarifa[$hotelID->id_hotel]['Habitaciones'][$contHabs]["Planes"][0]['plan'][0]["codigos_tarifa"] = $tableRatecode;
											$tarifa[$hotelID->id_hotel]['Habitaciones'][$contHabs]["Planes"][0]['plan'][0]["fechas_disponibles"] = $desgloseFechas;
											$tarifa[$hotelID->id_hotel]['Habitaciones'][$contHabs]["Planes"][0]['plan'][0]["roomType"] = $ratecodePalace;
											$tarifa[$hotelID->id_hotel]['Habitaciones'][$contHabs]["Planes"][0]['plan'][0]["ofertas"] = "";
											$tarifa[$hotelID->id_hotel]['Habitaciones'][$contHabs]["Planes"][0]['plan'][0]["promociones"] = ""; 
											$tarifa[$hotelID->id_hotel]['Habitaciones'][$contHabs]["Planes"][0]['plan'][0]["Disponibilidad2noches"] = $hotelRooms[0]["Disponibilidad2noches"]; 


											$tarifa[$hotelID->id_hotel]['Habitaciones'][$contHabs]["Planes"][0]["warning"]["tarifaVacia"]=false;
											$tarifa[$hotelID->id_hotel]['Habitaciones'][$contHabs]["Planes"][0]["warning"]["mensaje"]="";

											$contHabs++;
											$i++;

										}

									}

									$tarifa[$hotelID->id_hotel]["Desglose"]["tarifas"]= $contHabs;
									$tarifa[$hotelID->id_hotel]["Desglose"]["mejorHabitacion"]= $mejorHabitacion;
									$tarifa[$hotelID->id_hotel]["Desglose"]["mejorPlan"]= $mejorPlan;
									$tarifa[$hotelID->id_hotel]["Desglose"]["menorPrecio"]= number_format($menorPrecio,2);
									$tarifa[$hotelID->id_hotel]["Desglose"]["moneda"]= $monedaPrimeraTarifa;
									$tarifa[$hotelID->id_hotel]["Desglose"]["banderaBootom"]= false;

									if($monedaPrimeraTarifa=="USD") {
										$tarifa[$hotelID->id_hotel]["Desglose"]["menorPrecio"] = number_format($menorPrecio,2);
										$menorTarifaMXN = 19.5000*$menorPrecio;
										$tarifa[$hotelID->id_hotel]["Desglose"]["menorPrecio_mxn"] = number_format($menorTarifaMXN,2);
									}


								}else{
									$habnull++;
									$tarifa[$hotelID->id_hotel]["Warning"]["warning"]= true;
									$tarifa[$hotelID->id_hotel]["Warning"]["mensaje"] = $mensajeError;
								}

								if ($contarHotel>1) {
									if ($habnull>$habcount) {
										unset($tarifa[$hotelID->id_hotel]);
									}
								}

		        				#### Para Destinos
								if ($hotelRooms[0]['Disponibilidad2noches']==true && $contarHotel>1) {
									unset($tarifa[$hotelID->id_hotel]);
								}
		        			#

							}
							// echo $ratecodePalace."<br>";
							// echo $ratecodePalacexDia;
							// exit;
							$responseWs = $tarifa;
						} catch (Exception $e) {
							$mensaje_de_error["500_6"]["Proveedor_6"] = "Mensaje: ".$e->getMessage()." <br> Codigo: ".$e->getCode()." <br> Archivo: ".$e->getFile()." <br> Linea: ".$e->getLine();
							$responseWs = $mensaje_de_error;
						}
					break;

					default:
					break;
				}

				if ($responseWs["500_".$_POST["proveedor"]] && $session["request_url"]==0) {
					$responseWs = [];
				}

				echo json_encode($responseWs);
			
			}
		}
	}

			public function array_sort_by_OB(&$arrIni, $col, $order = SORT_ASC) 
			{
				$arrAux = array();
				foreach ($arrIni as $key=> $row) 
				{
					$arrAux[$key] = is_object($row) ? $arrAux[$key] = $row->$col : $row[$col];
					$arrAux[$key] = strtolower($arrAux[$key]);
				}
				array_multisort($arrAux, $order, $arrIni);
			}

			public function tipoHabOB($ratePlanID,$ratePlanType,$plans){
				for($p=0; $p<$plans; $p++) 
				{
					if($plans>1)
					{
						$tipo=$ratePlanType[$p];
					}else
					{
						$tipo=$ratePlanType;
					}
					if($tipo->RatePlanID==$ratePlanID)
					{
						$tipoHab=$tipo->MealsIncluded->Name;
						$mealPlanCode=$tipo->MealsIncluded->MealPlanCode;
					}
				}
				return array("tipoHab"=>$tipoHab, "mealPlanCode"=>$mealPlanCode);
			}

			public function ratePlanDescriptionOB($ratePlanID,$ratePlanType,$plans){
				for($p=0; $p<$plans; $p++) 
				{
					if($plans>1)
					{
						$tipo=$ratePlanType[$p];
					}else
					{
						$tipo=$ratePlanType;
					}
					if($tipo->RatePlanID==$ratePlanID)
					{
						$ratePlanDescription=$tipo->RatePlanDescription->Description;
					}
				}
				return $ratePlanDescription;
			}

			public function noReembolsableOB($ratePlanID,$ratePlanType,$plans){
				for($p=0; $p<$plans; $p++) 
				{
					if($plans>1)
					{
						$tipo=$ratePlanType[$p];
					}else
					{
						$tipo=$ratePlanType;
					}   
					if($tipo->RatePlanID==$ratePlanID)
					{
						$ratePlanDescription=$tipo->CancelPenalties->CancelPenalty->NonRefundable;
					}             

				}
				return $ratePlanDescription;
			}


			function desgloseOB($rateDailyRates,$fecha_inicial,$markup,$countRate,$r,$ratePlanType,$session)
			{
				$tipoCambio=1;
				$iva=1;
				$taxvalue=0;

				if(count($ratePlanType)>1){
					$RateplanType=$ratePlanType[0];
				}else{
					$RateplanType=$ratePlanType;
				}

				$taxkey=array_keys($RateplanType->TaxPolicies->TaxPolicy);
				if(is_numeric($taxkey[0])){
					foreach ($RateplanType->TaxPolicies->TaxPolicy as $key => $tax) {
						$taxvalue+=(int)$tax->Value;
					}
				}else{
					$taxvalue=$RateplanType->TaxPolicies->TaxPolicy->Value;
				}

				if($RateplanType->TaxPolicies!=NULL)
				{
					$iva=($taxvalue/100)+1;
				}else{
					$iva=1;
				}

				$desglosePersona = array();

				$desglosePersona['resumen']['adultos'] = $session['habitacion_'.$r]['adultos'];
				$desglosePersona['resumen']['menores'] = $session['habitacion_'.$r]['num_ninios'];

				for($i=0; $i<$countRate; $i++)
				{
					$precioAdulto=0;
					$precioMenor=0;

					if($countRate>1)
					{
						$dailyRates=$rateDailyRates[$i];
					}else
					{
						$dailyRates=$rateDailyRates;
					}

					$rates=$dailyRates->Total->TPA_Extensions->Rates->Rate;

					for ($j=0; $j < count($rates); $j++)
					{ 
						if(count($rates)>1)
						{
							$rate=$rates[$j];
						}else
						{
							$rate=$rates;
						}


						if($rate->AgeQualifyingCode=='Adult')
						{
							$precioAdulto+=($rate->Total->AmountBeforeTax*$rate->MaxGuestApplicable)*$iva;
						}else if($rate->AgeQualifyingCode=='Child')
						{
							$precioMenor+=($rate->Total->AmountBeforeTax*$rate->MaxGuestApplicable)*$iva;
						}

					}

					$dailyNet_A_MXN=($dailyRates->Total->AmountBeforeTax*$tipoCambio)/$markup*$iva;

					$dailyNet_M_MXN=(0*$tipoCambio);
					$dailyNetMXN +=$dailyNet_A_MXN+$dailyNet_M_MXN;

					$precioAdulto=$precioAdulto/$markup;
					$precioMenor=$precioMenor/$markup; 
					$moneda = $dailyRates->Total->CurrencyCode;

					$desglosePersona['Fechas'][($i+1)]['Fecha'] = date('d/m/Y',strtotime($fecha_inicial.'+'.($i).' day'));
					$desglosePersona['Fechas'][($i+1)]['Adultos'] = number_format($precioAdulto,2);
					$desglosePersona['Fechas'][($i+1)]['Menores'] = number_format($precioMenor,2);
					$desglosePersona['Fechas'][($i+1)]['total'] = number_format($dailyNet_A_MXN,2);
					$desglosePersona['Fechas'][($i+1)]['moneda'] = $dailyRates->Total->CurrencyCode;        
				}

				$desglosePersona['Total']['total'] = number_format($dailyNetMXN,2);
				$desglosePersona['Total']['moneda'] = $moneda;
				
				return $desglosePersona;
			}

			function politicasCancelacionOB($ratePlanID,$ratePlanType,$plans,$fecha_inicial)
			{
				$politicasCancelacion="Gastos de cancelacion. ";
				$hoy=date("Y-m-d");
				$cadena_noches="";

				for($p=0; $p<$plans; $p++) 
				{
					if($plans>1)
					{
						$cancelacion=$ratePlanType[$p];
					}else
					{
						$cancelacion=$ratePlanType;
					}

					if($cancelacion->RatePlanID==$ratePlanID)
					{


						$costo="";
						$cancelPenalty=$cancelacion->CancelPenalties->CancelPenalty;
						$penaltyDescription=$cancelPenalty->PenaltyDescription->Description;
						if($cancelPenalty->AmountPercent->Amount)
						{
							$costo="Importe: $".number_format($cancelPenalty->AmountPercent->Amount);
						}else if($cancelPenalty->AmountPercent->Percent)
						{
							$costo="Importe: %".number_format($cancelPenalty->AmountPercent->Percent);
						} 

						if($cancelPenalty->AmountPercent->NmbrOfNights>1)
							$cadena_noches="s";                   

						$datetime_hoy=new DateTime($hoy);
						$datetime_cancelacion=new DateTime(date("Y-m-d",strtotime($fecha_inicial)));

						$diferencia = $datetime_cancelacion->diff($datetime_hoy);

						$resultado_diferencia_dias=$diferencia->format('%a');
						$dias_fecha_limite=$cancelPenalty->DeadLine->OffsetUnitMultiplier+6;
			//echo "<textarea>".json_encode($cancelPenalty)."</textarea>";

						if($dias_fecha_limite<=$resultado_diferencia_dias && (!is_null($cancelPenalty->DeadLine->OffsetUnitMultiplier)))
						{
							$fecha_limite_amount=date("d/m/Y H:i",strtotime($fecha_inicial.' -'.($dias_fecha_limite-1).' days'));
							$fecha_limite=date("d/m/Y H:i",strtotime($fecha_inicial.' -'.($dias_fecha_limite).' days'));                        	
							$politicasCancelacion.= "A partir del ".$fecha_limite_amount.". Penalidad ".$cancelPenalty->AmountPercent->NmbrOfNights." noche".$cadena_noches.'. Descripción: '.$penaltyDescription;

							if ($cancelPenalty->DeadLine->OffsetUnitMultiplier)
								$fecha_limite_h = date("Y-m-d H:i:s",strtotime($fecha_inicial.' -'.($cancelPenalty->DeadLine->OffsetUnitMultiplier).' days'));

						}else
						{

							$fecha_limite=date("d/m/Y H:i");
							$fecha_limite_h=date("Y-m-d H:i:s");
							if (is_null($cancelPenalty->AmountPercent->NmbrOfNights)) {
								$politicasCancelacion.=" Aplica cargo inmediato. Descripción: ".$penaltyDescription;
							}else{

								$politicasCancelacion.= "Aplica cargo inmediato. Penalidad:  ".$cancelPenalty->AmountPercent->NmbrOfNights." noche".$cadena_noches;
							}

						}


					}

				}

				return json_encode(array('politicasCancelacion'=>nl2br($politicasCancelacion),'fecha_limite'=>$fecha_limite,'fecha_limite_h'=>$fecha_limite_h));
			}

			public function sinDisponibilidadOB($rateDailyRates,$roomRateAvailability,$warningsType,$fecha_inicial,$countRate)
			{
				$desgloseFechas = array();
				$arrayNotAvailable = array(427,507,575,346,563,51,169,569,536,397,138,409,142,411,441,404,109,560);	
				for($dia=0;$dia<$countRate;$dia++)
				{ 
					$fecha = date("Y-m-d", strtotime($fecha_inicial." +".$dia." days"));
					$desgloseFechas['Fechas'][$dia]['fecha'] = date('d/m/Y',strtotime($fecha));
				} 			    

				$ok=0;
				$minLos=0;
				for($dia=0; $dia<$countRate; $dia++)
				{
					if($countRate>1)
					{
						$dailyRates=$rateDailyRates[$dia];
					}else
					{
						$dailyRates=$rateDailyRates;
					}

					if($dailyRates->Status=="Close")
					{
						$desgloseFechas['Fechas'][$dia]['estatus'] = 'danger';
						$desgloseFechas['Fechas'][$dia]['disponible'] = false;

					}
					else if(in_array($roomRateAvailability->WarningRPH, $arrayNotAvailable) && $dailyRates->Status==null)
					{
						$desgloseFechas['Fechas'][$dia]['estatus'] = 'warning';
						$desgloseFechas['Fechas'][$dia]['disponible'] = false;
						$ok++;

					}else
					{
						$desgloseFechas['Fechas'][$dia]['estatus'] = 'success';
						$desgloseFechas['Fechas'][$dia]['disponible'] = true;
						$ok++;
					}

					if($minLos<$dailyRates->MinLOS)
					{
						$minLos=$dailyRates->MinLOS;
					}
				}

				$fa_color=($ok==$countRate)?'warning':'danger';
				$error = '';
				for ($i=0; $i < count($roomRateAvailability); $i++)
				{ 
					if(count($roomRateAvailability)>1)
					{
						$status=$roomRateAvailability[$i];
					}else
					{
						$status=$roomRateAvailability;
					}

					if($warningsType[000] && $status->WarningRPH!=null)
						$status->WarningRPH=000;

					$error.= $warningsType[$status->WarningRPH];

					if($status->WarningRPH==411)
					{
						$error.='Restricción mínima de la estancia '.$minLos." noches";
					}
				}

				$desgloseFechas["error"] = $error;
				$desgloseFechas["status"] = $fa_color;


				return $desgloseFechas;
			}

	// Uncomment the following methods and override them if needed
	/*
	public function filters()
	{
		// return the filter configuration for this controller, e.g.:
		return array(
			'inlineFilterName',
			array(
				'class'=>'path.to.FilterClass',
				'propertyName'=>'propertyValue',
			),
		);
	}

	public function actions()
	{
		// return external action classes, e.g.:
		return array(
			'action1'=>'path.to.ActionClass',
			'action2'=>array(
				'class'=>'path.to.AnotherActionClass',
				'propertyName'=>'propertyValue',
			),
		);
	}
	*/
}