<?php
class FlyersController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column1';
	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}
	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view','flyer', 'creaFlyer'),
				'users'=>array('@'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update','GeneratePdf','GenerateExcel','createFlyerTipo','delete'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin',),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}
	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}
	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
			$model=new Flyers;
			// Uncomment the following line if AJAX validation is needed
			// $this->performAjaxValidation($model);
			if(isset($_POST['Flyers']))
			{
				$model->attributes=$_POST['Flyers'];
				 $model->nombreimagen=CUploadedFile::getInstance($model,'nombreimagen');	
				 $idh=$_POST['Flyers']['id_hotel'];
				 $id_cadena=Hoteles::model()->findByPk($idh)->id_cadena;
				 $model->id_cadena_hotel=$id_cadena;
				if($model->save() && $model->validate()){
						if($model->nombreimagen)
					 $model->nombreimagen->saveAs($_SERVER['DOCUMENT_ROOT'].'/medios/flyers/'.$model->id_flyer."_".$model->nombreimagen);
						else
							echo '<script>alert("hubo un error al agregar la imagen")</script>';
					$this->redirect(array('view','id'=>$model->id_flyer));
			}else{
				// print_r($model->getErrors());
			}
		}
		$this->render('create',array(
				'model'=>$model,
			));
	}
	public function actionCreaFlyer($img, $idAgencia){
		$model_agencia = Agencias::model()->findByPk($idAgencia);
		if(empty($model_agencia->pie_flyer)) {
			echo $flyer = $this->Flyer($img, $model_agencia->id_agencia);
		} else {
			echo $flyer = $this->FlyerWithFile($img, $model_agencia);
		}
	}

	public function FlyerWithFile($img, $model_agencia) {
		header('Content-type: image/png');

		$id_flyer = explode('_', $img);
		$model_flyer = Flyers::model()->findByPk($id_flyer);

		$url_flyer = "../medios/flyers/". $img;
		$flyer = imagecreatefromjpeg($url_flyer);
		$url_pie_agencia = "../medios/flyers/pies_agencias/". $model_agencia->pie_flyer;

		$formato_pie_agencia = pathinfo($url_pie_agencia);
		switch ($formato_pie_agencia["extension"]) {
			case 'jpg':
				$pie_flyer = imagecreatefromjpeg($url_pie_agencia);
				break;
			
			case 'png':
				$pie_flyer = imagecreatefrompng($url_pie_agencia);
				break;

			default:
				$pie_flyer = imagecreatefromjpeg($url_pie_agencia);
				break;
		}
			
		list($width_flyer, $heigth_flyer) = getimagesize($url_flyer);
		list($width_pie_agencia, $heigth_pie_agencia) = getimagesize($url_pie_agencia);

		$width_footer = $width_flyer;//620;
		//$heigth_footer = 180;
		$heigth_footer = 140;

		$footer = imagecreatetruecolor($width_footer, $heigth_footer);
		$fondo_blanco_footer = imagecolorallocate($footer, 255,255,255);
		imagefilledrectangle($footer, 0, 0, $width_footer, $heigth_footer, $fondo_blanco_footer);
		imagefill($footer, 0, 0, $fondo_blanco_footer);
		imagecopyresampled($footer, $pie_flyer, 0, 0, 0, 0, $width_footer, $heigth_footer, $width_pie_agencia, $heigth_pie_agencia);

		switch ($model_flyer->tipo_flyer) {
			case '6':
				$centrar = $width_flyer / 4;
			break;

			default:
				$centrar = 0;
			break;
		}

		$flyer_final = imagecreatetruecolor($width_flyer, ($heigth_flyer + $heigth_footer));
		$fondo_blanco = imagecolorallocate($flyer_final, 255,255,255);
		imagefilledrectangle($flyer_final, 0, 0, $width_flyer, ($heigth_flyer + $heigth_footer), $fondo_blanco);
		imagecopyresampled($flyer_final, $flyer, 0, 0, 0, 0, $width_flyer, $heigth_flyer, $width_flyer, $heigth_flyer);
		imagecopyresampled($flyer_final, $footer, $centrar, $heigth_flyer, 0, 0, $width_footer, $heigth_footer, $width_footer, $heigth_footer);

		imagejpeg($flyer_final, NULL);
		imagedestroy($flyer_final);
		return $flyer_final;
   	}

	public function Flyer($img, $idAgencia) {
	 	//".$_SERVER['SERVER_NAME']."/medios/demoflyers/".$img;
        $id_flyer = explode('_', $img);
	 	$urlimagen = "../medios/flyers/". $img;
	 	$modeluser = Agencias::model()->findByPk($idAgencia);
		$tipoflyer = Flyers::model()->findByPk($id_flyer);
		$formato = explode('.', $modeluser->foto);
	 	$helvetica = "../medios/flyers/fonts/helvetica.ttf";
	 	$helvetica_bold = "../medios/flyers/fonts/helvetica-bold.ttf";
	 	$roboto = "../medios/flyers/fonts/Roboto-Light.ttf";
	 	$roboto_bold = "../medios/flyers/fonts/Roboto-Medium.ttf";
		$mail = "". $modeluser->email_agencia;
		$agencia = $modeluser->nombre_agencia;
		$url = $modeluser->url_agencia;
	 	header('Content-Type: image/jpeg');
		$urlLogo = "../imagenes/". $modeluser->foto; 
		if (!$modeluser->foto) {
			$urlLogo = "../reservaciones/rutamayav3/images/sinlogo.jpg";
		}

		$info_img = pathinfo($urlimagen);
		if($info_img["extension"] == "jpg") {
			$fondo = imagecreatefromjpeg($urlimagen);
		} else {
			$fondo = imagecreatefrompng($urlimagen);
		}
	 		
		//echo '<img src="'.$PNG_WEB_DIR.basename($filename).'" />';
		switch ($formato[1]) {
			case 'jpg':
				if (!$modeluser->foto) {
					$urlLogo = "../reservaciones/rutamayav3/images/sinlogo.jpg";
				}
				$logo = imagecreatefromjpeg($urlLogo);
			break;
			case 'png':
				if (!$modeluser->foto) {
					$urlLogo = "../reservaciones/rutamayav3/images/sinlogo.png";
				}
				$logo = imagecreatefrompng($urlLogo);
			break;
		}
		//$im = imagecreatetruecolor(120, 20); //crea un rectangulo color negro
		/* redimensionar logo */
		$r = 1; $h = 140;
		$original_w = imagesx($logo);
		$original_h = imagesy($logo);	
		// Es resampleo vertical(por altura)
		if($r == 1) {
			if($w == 0 && $h != 0) {
				$img_nueva_altura = $h;
				$img_nueva_anchura = intval(($original_w / $original_h) * $h);
			} else {
				if($w != 0 && $h == 0) {
					$img_nueva_altura = intval(($original_h / $original_w) * $w);
					$img_nueva_anchura = $w;
				} else if($w != 0 && $h != 0) {
					$img_nueva_altura = $h;			
					$img_nueva_anchura = $w;
				}
			}
		} else {
			$img_nueva_altura = $original_h;			
			$img_nueva_anchura = $original_w;
		}
		$newwidth = $img_nueva_anchura;
		$newheigth = $img_nueva_altura;
		list($ancho, $alto) = getimagesize($urlLogo);
		/*$logout = imagecreatetruecolor($newwidth, $newheigth);
		$fTransparente=imagecolorallocate($logout, 255, 255, 255);
		imagefill($logout, 0, 0, $fTransparente);
		imagecopyresized($logout, $logo, 0, 0, 0, 0, $newwidth, $newheigth, $ancho, $alto);*/

		list($width, $height, $type, $attr) = getimagesize($urlimagen);
		if($width > 620) {
			$fs_small = 28;
			$fs_medium = 35;
		} else {
			$fs_small = 14;
			$fs_medium = 20;
		}
		$w = $width;
		$h = 190;
		$textWidth = $newwidth + 38;
		$footer = imagecreatetruecolor($w, $h);  
		$fondo_B = imagecolorallocate($footer, 255,255,255);
		imagefilledrectangle($footer, 0, 0, $w, $h, $fondo_B);
		imagefill($footer, 0, 0, $fondo_B);
		if(strlen($modeluser->tel_agencia) == 10) $modeluser->tel_agencia = "(". substr($modeluser->tel_agencia, 0,3) .") ". substr($modeluser->tel_agencia, 3, 10);
		imagecopyresampled($footer, $logo, 0, 26, 0, 0, $newwidth, $newheigth, $ancho, $alto);
		imagefttext($footer, $fs_small, 0, $textWidth, 30, $color_negro, $helvetica_bold, $agencia);
		imagefttext($footer, $fs_medium, 0, $textWidth, 80, $color_negro, $helvetica_bold, 'Tel: '. $modeluser->tel_agencia);
		imagefttext($footer, $fs_small, 0, $textWidth, 130, $color_negro, $helvetica, $mail);
		imagefttext($footer, $fs_small-10, 0, $textWidth, 170, $color_negro, $helvetica, $url);

		list($f_ancho, $f_alto) = getimagesize($urlimagen);
		$f_alto1 = $f_alto + $h;
		
		switch ($tipoflyer->tipo_flyer) {
			case '6':
				$centrar = $f_ancho / 4;
			break;
			default:
				$centrar = 0;
			break;
		}
		$img = imagecreatetruecolor($f_ancho, $f_alto1);
		$fondo_blanco = imagecolorallocate($img, 255, 255, 255);
		imagefilledrectangle($img, 0, 0, $f_ancho-1, $f_alto1 - 1, $fondo_blanco);
		imagecopyresampled($img, $fondo, 0, 0, 0, 0, $f_ancho, $f_alto, $f_ancho, $f_alto);
		imagecopyresampled($img, $footer, $centrar, $f_alto, 0, 0, $w, $h, $w, $h);

		imagejpeg($img, NULL);
		imagedestroy($img);
		return $img;
	}

	public function actionCreateFlyerTipo()
	{
		$model=new FlyersTipo;
		if (isset($_POST['FlyersTipo'])) {
			$model->attributes=$_POST['FlyersTipo'];
			if($model->save){
			$this->redirect('flyers/create');
			}
		}
	}
	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);
		if(isset($_POST['Flyers']))
		{
			/*$model->titulo=$_POST['Flyers']['titulo'];
			$model->id_hotel=$_POST['Flyers']['id_hotel'];
			$model->id_tipo_promocion=$_POST['Flyers']['id_tipo_promocion'];
			$model->fechainicial=$_POST['Flyers']['fechainicial'];
			$model->fechafinal=$_POST['Flyers']['fechafinal'];*/
			$model->attributes = $_POST['Flyers'];
							$ruta=CUploadedFile::getInstance($model,'nombreimagen');
						if ($ruta!="") 
				 		$model->nombreimagen=CUploadedFile::getInstance($model,'nombreimagen');
						else
						$model->nombreimagen=$model->nombreimagen;					
				 $idh=$_POST['Flyers']['id_hotel'];
				 $id_cadena=Hoteles::model()->findByPk($idh)->id_cadena;
				 $model->id_cadena_hotel=$id_cadena;
				if($model->save() ){
						if($ruta!="") 
							$model->nombreimagen->saveAs($_SERVER['DOCUMENT_ROOT'].'/medios/flyers/'.$model->id_flyer."_".$model->nombreimagen);
						$this->redirect(array('view','id'=>$model->id_flyer));
				}else{print_r($model->getErrors());}
		}
		$this->render('update',array(
			'model'=>$model,
		));
	}
	/*public function actionUpdate($id)
	{
		$model=$this->loadModel($id);
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);
		if(isset($_POST['Flyers']))
		{
			$model->titulo=$_POST['Flyers']['titulo'];
			$model->id_hotel=$_POST['Flyers']['id_hotel'];
			$model->id_tipo_promocion=$_POST['Flyers']['id_tipo_promocion'];
			$model->fechainicial=$_POST['Flyers']['fechainicial'];
			$model->fechafinal=$_POST['Flyers']['fechafinal'];
				 //$subirimagen=CUploadedFile::getInstance($model,'nombreimagen');
				 $id_cadena=Hoteles::model()->findByPk($model->id_hotel)->id_cadena;
				 $model->id_cadena_hotel=$id_cadena;
				if($model->save() && $model->validate())
					$this->redirect(array('view','id'=>$model->id_flyer));
		}
		$this->render('update',array(
			'model'=>$model,
		));
	}
*/
	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		//if(Yii::app()->request->isPostRequest)
			// we only allow deletion via POST request
			$this->loadModel($id)->delete();
			// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
			if(!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('index'));
		/*else
			throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');*/
	}
	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
        $session=new CHttpSession;
        $session->open();		
        $criteria = new CDbCriteria();  
        $modeluser=Agencias::model()->findByPk($_SESSION["agenciaUsuario"]);
        $modelAgencia=new Agencias;
        $idAgencia="";
        if($_POST['Agencias']){
        	$idAgencia=$_POST['Agencias']['id_agencia'];
       		$modelAgencia->id_agencia=$_POST['Agencias']['id_agencia'];       
        }
        $model=new Flyers('search');
        $model->unsetAttributes();  // clear any default values
        if(isset($_GET['Flyers']))
		{
                        $model->attributes=$_GET['Flyers'];			
                       if (!empty($model->id_flyer)) $criteria->addCondition("id_flyer = '".$model->id_flyer."'");                     
                       if (!empty($model->nombreimagen)) $criteria->addCondition("nombreimagen = '".$model->nombreimagen."'");
                       if (!empty($model->id_hotel)) $criteria->addCondition("id_hotel = '".$model->id_hotel."'");
                       if (!empty($model->id_cadena_hotel)) $criteria->addCondition("id_cadena_hotel = '".$model->id_cadena_hotel."'");
                      // if (!empty($model->fechafinal))   $criteria->addCondition("fechafinal >= '".date("Y-m-d")."'");
                       if (!empty($model->id_tipo_promocion)) $criteria->addCondition("id_tipo_promocion = '".$model->id_tipo_promocion."'");
                       if (!empty($model->titulo)) $criteria->addCondition("titulo = '".$model->titulo."'");
                       if (!empty($model->tipo_flyer)) $criteria->addCondition("tipo_flyer = '".$model->tipo_flyer."'");
                    $session['Flyers_records']=Flyers::model()->findAll($criteria); 
                    //$session['Flyers_records']=Flyers::model()->findAll('fechafinal>="'.$hoy.'"  and fechainicial<="'.$hoy.'" AND '.$criteria); 
		}
        $this->render('index',array(
			'model'=>$model,'modeluser'=>$modeluser, 'modelAgencia'=>$modelAgencia, 'idAgencia'=>$idAgencia
		));
	}
	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model=Flyers::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}
}
