<?php
require_once('../api/cfdi/FacturaApi.php');

class FeFacturasController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column1';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
			array(
				'ext.starship.RestfullYii.filters.ERestFilter + 
				REST.GET, REST.PUT, REST.POST, REST.DELETE'
			),
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow', 'actions'=>array('REST.GET', 'REST.PUT', 'REST.POST', 'REST.DELETE'),
				'users'=>array('@'),
			),
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('@'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update','GeneratePdf','GenerateExcel','getFacturas','desgloseFactura','facturarLote'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	public function actions()
	{
		return array('REST.'=>'ext.starship.RestfullYii.actions.ERestActionProvider',);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate($idRecibo)
	{
		$operacion = Yii::app()->createController('operacionesLog');
		$operacion = $operacion[0];

		if ($_POST['FeFacturas']) {

			$serie = '';
			$cfdi=new FacturaApi;

			if ($_POST['FeFacturas']['serie']) {
				$serie = 'WHERE serie="'.$_POST['FeFacturas']['serie'].'"';
			}

			switch ($_POST['tipo_nota']) {
				case 'comprobante':
				$tipo_nota = 'comprobante';
				break;
				case 'credito':
				$tipo_nota = 'credito';
				break;
				case 'recibo':
				default:
				$tipo_nota = 'recibo';
				// code...
				break;
			}

			$countFacturas = count($_POST['Importes']);
			$referencia_agencia = $_POST['id_agencia'].'A'.$_POST['id_recibo'];
			// $referencia_agencia = 'A'.$_POST['id_recibo'];
			$existFactura = FeFacturas::model()->findAll('referencia_agencia LIKE "%'.'A'.$_POST['id_recibo'].'" AND tipo_nota="'.$tipo_nota.'" AND estatus!="C"');
			
			$existFacturaDetalle = array();

			if (count($existFactura)>0) {
				$existFacturaDetalle = FeFacturasDetalle::model()->findAll('id_recibo='.$_POST['id_recibo']);
			}

			$error = array();
			$facturasExistosas = array();
			$cfdi_cantidad = 1;
			$existe = 'ko';

			$feFacturasDetalle = Yii::app()->createController('feFacturasDetalle');
			$feFacturasDetalle = $feFacturasDetalle[0];

			for ($i=0; $i < $countFacturas; $i++) {
				
				$model=new FeFacturas;
				$factura_detalle = new FeFacturasDetalle;

				if (count($existFactura)>0) {

					if ($existFactura[$i]!=null || !empty($existFactura[$i])) {
						$idFactura = $existFactura[$i];
						$idFacturaDetalle = $existFacturaDetalle[$i];
						$model=$this->loadModel($idFactura->id_factura);
						$factura_detalle = $feFacturasDetalle->loadModel($idFacturaDetalle->id_factura_detalle);
						$model->attributes=$_POST['FeFacturas'];
						$existe = 'ok';
					}else{
						$existe = 'ko';
					} 
				}

				if ($existe=='ko') {


					$lastId = Yii::app()->db->createCommand('SELECT id_factura,folio,serie FROM tbl_fe_facturas '.$serie.' ORDER BY id_factura DESC LIMIT 1')->queryAll();
					if (empty($lastId[0]['folio']) || empty($lastId)) {
						$lastId[0]['folio'] = 0;
					}

					$folio = $lastId[0]['folio'];
					$newFolio = ((int) $folio) + 1;

					$model->attributes=$_POST['FeFacturas'];

					if ($_POST['correos_destinatarios']!='' || !empty($_POST['correos_destinatarios'])) {
						$model->correo_fiscal = $_POST['correos_destinatarios'];	
					}

					$model->folio = $newFolio;
					$model->serie = 'A';
					$model->importe = 0.00;
					$model->subtotal = 0.00;
					$model->iva = 0.00;
					$model->total = 0.00;
					$model->iva_porcentaje = 1.1600;
					$model->estatus = 'P';
					$model->condiciones_pago = 'CONTADO';
					$model->metodo_pago = 'PUE';
					$model->tipo_comprobante = 'ingreso';
					$model->original_monto = $_POST['suma_total_total'];
					$model->id_agencia = $_POST['id_agencia'];
					$model->referencia_agencia = $referencia_agencia;
					$model->id_nota = $_POST['id_recibo'];
					$model->tipo_nota = $tipo_nota;
					if ($model->save()) {
						$factura_detalle->id_factura = $model->id_factura;
						$factura_detalle->cantidad = $cfdi_cantidad;
						$factura_detalle->unidad = 'SERVICIO';
						$factura_detalle->no_identificacion = $_POST['id_recibo'];
						$factura_detalle->cve_prod_serv = 90111500;
						$factura_detalle->descripcion = $_POST['descripcion'];
						$factura_detalle->clave_unidad = 'E48';
						$factura_detalle->valor_unitario = 0;
						$factura_detalle->importe = 0;
						$factura_detalle->id_recibo = $_POST['id_recibo'];
						$factura_detalle->save();
					}else{
						$errorSave = $model->getErrors();
						$this->sendEmailErrors($errorSave);
						// exit;
					}

				}

				if (!empty($model->id_factura) && $model->estatus == 'P') {
					# code...
					$cfdi->rfcReceptor=$model->receptor_rfc;
					$cfdi->razonSocialReceptor=$model->receptor_razon_social;

					$cfdi->folio=$model->folio;
					$cfdi->serie=$model->serie;
					$cfdi->formaPago=$model->forma_pago;

					$cfdi->correo_receptor = $model->correo_fiscal;

					$total_ind = $_POST['Totales'][$i];
					$importe_ind = $_POST['Importes'][$i];
					$iva_ind = $_POST['IVA'][$i];

					$cfdi->importeRecibo=$total_ind;

					$response = $cfdi->facturar();

					$model->response = json_encode($response);
					/*if($_SESSION['agenciaUsuario']==9)
						echo json_encode($response);*/
					
					if ($response[0]==0 || $response==null || $response=='') {
						$error[$i]['error'] = $response[3];
						$error[$i]['monto'] = $total_ind;
						$model->save();
					}

					if ($response[4]!=null || !empty($response[4])) {
						if ($countFacturas>1) {
							$ftras = 'UNO DE SUS FACTURAS'; 
						}else{
							$ftras = 'SU FACTURA'; 
						}
						$error_envio_correo[0]['error'] = 'HA OCURRIDO UN ERROR CON EL ENVIO DE '.$ftras.'. Por favor, verifique su correo o contacte a RUTA MAYA TRAVEL';
						$this->sendEmailErrors($response);
					}

					if (count($error)==0 || empty($error)) {
						$model->importe = $importe_ind;
						$model->subtotal = $importe_ind;
						$model->iva = $iva_ind;
						$model->total = $total_ind;
						$model->uuid_certificacion = $response[5];
						$model->fecha_certificacion = $response[6];
						$model->ruta_local_pdf = "comprobantes/".$response[5].".pdf";
						$model->ruta_local_xml = "comprobantes/".$response[5].".xml";
						$model->estatus = "A";
						$factura_detalle->valor_unitario = $importe_ind;
						$factura_detalle->importe = $total_ind*$cfdi_cantidad;
						$model->save();
						$factura_detalle->save();
						$operacion->Create($model->id_factura,59);
					}

					

				}else{
						$error_facturas[$i] = $errorSave;
				}
			}
				
				$this->renderPartial('create',array(
					'response'=>$response,
					'error' => $error,
					'error_facturas'=>$error_facturas,
					'facturasExistosas' => $facturasExistosas,
					'countFacturas'=>$countFacturas,
					'datos_formulario'=>$_POST,
					'error_envio_correo' => $error_envio_correo,
					'tipo_nota' => $tipo_nota
				));

			}

	}

	public function sendEmailErrors($error){
		$encabezados  = "MIME-Version: 1.0\n";
		$encabezados .= "Content-type: text/html; charset=UTF-8\n";
		$encabezados .= "From:  Ruta Maya Travel <soporte@rutamayatravel.com>\n";
		$subject2 = "Proceso de facturacion";
		$message2 = 'Error al generar la factura: <br> json='.json_encode($error);
		mail('programador3@rutamayatravel.com',$subject2,$message2,$encabezados);
		mail('jorgevadillo@rutamayatravel.com',$subject2,$message2,$encabezados);
		echo json_encode($error);

	}

	public function actionFacturarLote(){
		if ($_POST['recibos']) {
			$recibos = explode(',',$_POST['recibos']);

			$feFacturasDetalle = Yii::app()->createController('feFacturasDetalle');
			$feFacturasDetalle = $feFacturasDetalle[0];

			$tipo_nota = $_POST['tipo_nota'];

			$cfdi=new FacturaApi;

			foreach ($recibos as $key => $value) {
				
				if ($tipo_nota=='recibo') {
					$recibo = Recibo::model()->findByPk($value);
					$idRecibo = $recibo->id_recibo;
				}else if ($tipo_nota=='credito') {
					$recibo = NotaCredito::model()->findByPk($value);
					$idRecibo = $recibo->id_nota_credito;
				}

				$referencia_agencia = $recibo->id_agencia.'A'.$value;
				// $referencia_agencia = 'A'.$value;
				
				$existFactura = FeFacturas::model()->find('referencia_agencia LIKE "%'.'A'.$value.'" AND tipo_nota="'.$tipo_nota.'" AND estatus!="C"');
				
				$existFacturaDetalle = array();
				if (count($existFactura)>0) {
					$existFacturaDetalle = FeFacturasDetalle::model()->find('id_recibo='.$value);
				}

				$cfdi_cantidad = 1;
				$existe = 'ko';

				$model=new FeFacturas;
				$factura_detalle = new FeFacturasDetalle;


				if ($existFactura!=null || !empty($existFactura)) {
					$idFactura = $existFactura;
					$idFacturaDetalle = $existFacturaDetalle;
					$model=$this->loadModel($idFactura->id_factura);
					$factura_detalle = $feFacturasDetalle->loadModel($idFacturaDetalle->id_factura_detalle);
					$existe = 'ok';
				}else{
					$existe = 'ko';
				} 

				$model->receptor_rfc = $recibo->idAgencia->rfc;
				$model->receptor_razon_social = $recibo->idAgencia->razon_social;
				$model->receptor_calle = $recibo->idAgencia->calle_fiscal;
				$model->receptor_no_exterior = $recibo->idAgencia->num_exterior_fiscal;
				$model->receptor_no_interior = $recibo->idAgencia->num_interior_fiscal;
				$model->receptor_colonia = $recibo->idAgencia->id_colonia_fiscal;
				$model->receptor_estado = $recibo->idAgencia->id_estado_fiscal;
				$model->receptor_cp = $recibo->idAgencia->cp_fiscal;
				$model->receptor_municipio = $recibo->idAgencia->municipio_fiscal;
				$model->receptor_localidad = $recibo->idAgencia->municipio_fiscal;
				$model->receptor_pais = $recibo->idAgencia->id_pais_fiscal;
				$model->receptor_cruzamientos = $recibo->idAgencia->cruzamientos_fiscal;
				$model->correo_fiscal = $recibo->idAgencia->email_agencia;
				$model->moneda = "MXN";
				$model->tipo_cambio = '1.00';
				$model->forma_pago = '03';

				if ($existe=='ko') {
					$lastId = Yii::app()->db->createCommand('SELECT id_factura,folio,serie FROM tbl_fe_facturas WHERE serie="A" ORDER BY id_factura DESC LIMIT 1')->queryAll();
					if (empty($lastId[0]['folio']) || empty($lastId)) {
						$lastId[0]['folio'] = 0;
					}

					$folio = $lastId[0]['folio'];
					$newFolio = ((int) $folio) + 1;

					$model->folio = $newFolio;
					$model->serie = 'A';
					$model->importe = 0.00;
					$model->subtotal = 0.00;
					$model->iva = 0.00;
					$model->total = 0.00;
					$model->iva_porcentaje = '1.1600';
					$model->estatus = 'P';
					$model->condiciones_pago = 'CONTADO';
					$model->metodo_pago = 'PUE';
					$model->tipo_comprobante = 'ingreso';
					$model->original_monto = $recibo->importe;
					$model->id_agencia = $recibo->id_agencia;
					$model->referencia_agencia = $referencia_agencia;
					$model->tipo_nota = $tipo_nota;

					if ($model->save()) {
						$factura_detalle->id_factura = $model->id_factura;
						$factura_detalle->cantidad = $cfdi_cantidad;
						$factura_detalle->unidad = 'SERVICIO';
						$factura_detalle->no_identificacion = $idRecibo;
						$factura_detalle->cve_prod_serv = 90111500;
						$factura_detalle->descripcion = "SERVICIO DE HOSPEDAJE";
						$factura_detalle->clave_unidad = 'E48';
						$factura_detalle->valor_unitario = 0;
						$factura_detalle->importe = 0;
						$factura_detalle->id_recibo = $idRecibo;
						$factura_detalle->save();
					}else{
						$errorDatabase = $model->getErrors();
					}
				}

				if (!empty($model->id_factura) && $model->estatus == 'P') {
					$error = array();

					$cfdi->rfcReceptor=$model->receptor_rfc;
					$cfdi->razonSocialReceptor=$model->receptor_razon_social;

					$cfdi->folio=$model->folio;
					$cfdi->serie=$model->serie;
					$cfdi->formaPago=$model->forma_pago;

					$copiaCorreo='';
					if ($_POST['destinos']!='' || !empty($_POST['destinos'])) {
						$copiaCorreo = ";".$_POST['destinos'];
					}
					$cfdi->correo_receptor = $model->correo_fiscal.$copiaCorreo;

					$cfdi->importeRecibo=$recibo->importe;

					$response = $cfdi->facturar();

					$model->response = json_encode($response);
					// echo "<textarea>".$model->response."</textarea>";
					
					if ($response[0]==0 || $response==null || $response=='') {
						$estatusRecibo[$idRecibo]['error']['response'] = $response[3];
						$error['error'] = $response[3];
						$estatusRecibo[$idRecibo]['error']['monto'] = $total_ind;
						$error['monto'] = $response[3];

						$estatusRecibo[$idRecibo]['estatus'] = 0;
						$model->save();
					}

					if ($response[4]!=null || !empty($response[4])) {
						$ftras = 'SU FACTURA'; 
						$error[$idRecibo]['error']['correo'] = 'HA OCURRIDO UN ERROR CON EL ENVIO DE '.$ftras.'. Por favor, verifique su correo o contacte a RUTA MAYA TRAVEL';
						$estatusRecibo[$idRecibo]['estatus'] = 0;
					}

					$importe=$recibo->importe/1.16; 
					$iva_recibo=$importe * 0.16;
					$total = $importe * 1.16;

					// echo "<textarea>".CJSON::encode($model)."</textarea>";
					
					if (count($error)==0 || empty($error)) {
						$model->importe = $importe;
						$model->subtotal = $importe;
						$model->iva = $iva_recibo;
						$model->total = $total;
						$model->uuid_certificacion = $response[5];
						$model->fecha_certificacion = $response[6];
						$model->ruta_local_pdf = "comprobantes/".$response[5].".pdf";
						$model->ruta_local_xml = "comprobantes/".$response[5].".xml";
						$model->estatus = "A";
						$factura_detalle->valor_unitario = $importe;
						$factura_detalle->importe = $total*$cfdi_cantidad;
						$recibo->efectivo_facturable = 1;

						$model->save();
						$factura_detalle->save();
						$recibo->save();

						$estatusRecibo[$idRecibo]['estatus'] = 1;
						$estatusRecibo[$idRecibo]['success']['folio'] = $model->folio;
						$estatusRecibo[$idRecibo]['success']['serie'] = $model->serie;
						$estatusRecibo[$idRecibo]['success']['ruta_pdf'] = $model->ruta_local_pdf;
						$estatusRecibo[$idRecibo]['success']['ruta_xml'] = $model->ruta_local_xml;
					}

				}else{
					$estatusRecibo[$idRecibo]['estatus'] = 0;
					$estatusRecibo[$idRecibo]['error']['database'] = $errorDatabase;
				}
		
			}

			$this->renderPartial('_response_factura',array(
				'estatusRecibo'=>$estatusRecibo,
				'recibos' => $recibos,
				'tipo_nota' => $tipo_nota
			));

			
		}
	}
	public function actionDesgloseFactura(){
		// $Desglosefacturas = FeFacturaRecibo::model()->findAll('id_recibo='.$_POST['idRecibo']);
		$agencia = $_SESSION['agenciaUsuario'].'A'.$_POST['idRecibo'];
		$Desglosefacturas = Yii::app()->db->createCommand("SELECT fr.* FROM `tbl_fe_facturas` fr WHERE fr.referencia_agencia='".$_POST['idRecibo']."' AND tipo_nota='recibo'")->queryAll();
		$Desglosefacturas = json_decode(json_encode($Desglosefacturas));

		$this->renderPartial('facturas',array('facturas'=>$facturas));
	}

	public function actionGetFacturas(){
		// $agencia = $_SESSION['agenciaUsuario'].'A'.$_POST['recibo'];
		$agencia = 'A'.$_POST['recibo'];
		// $facturas = FeFacturaRecibo::model()->findAll('id_factura='.$_POST['id_factura']);
		// $facturas = Yii::app()->db->createCommand("SELECT fr.* FROM `tbl_fe_facturas` fr WHERE fr.referencia_agencia LIKE '%".$agencia."' AND tipo_nota='".$_POST['tipo_nota']."' AND estatus!='C'")->queryAll();
		$facturas = Yii::app()->db->createCommand("SELECT fr.* FROM `tbl_fe_facturas` fr WHERE fr.referencia_agencia LIKE '%".$agencia."' AND tipo_nota='".$_POST['tipo_nota']."'")->queryAll();
		$facturas = json_decode(json_encode($facturas));

		// echo "SELECT fr.* FROM `tbl_fe_facturas` fr WHERE fr.referencia_agencia='".$agencia."' AND tipo_nota='".$_POST['tipo_nota']."'";
		// echo "<textarea>".CJSON::encode($facturas)."</textarea>";
		
		$this->renderPartial('facturas',array('facturas'=>$facturas));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['FeFacturas']))
		{
			$model->attributes=$_POST['FeFacturas'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id_factura));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		if(Yii::app()->request->isPostRequest)
		{
			// we only allow deletion via POST request
			$this->loadModel($id)->delete();

			// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
			if(!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
		}
		else
			throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$session=new CHttpSession;
		$session->open();		
		$criteria = new CDbCriteria();            

		$model=new FeFacturas('search');
                $model->unsetAttributes();  // clear any default values

                if(isset($_GET['FeFacturas']))
                {
                	$model->attributes=$_GET['FeFacturas'];



                	if (!empty($model->id_factura)) $criteria->addCondition("id_factura = '".$model->id_factura."'");


                	if (!empty($model->fecha_creacion)) $criteria->addCondition("fecha_creacion = '".$model->fecha_creacion."'");


                	if (!empty($model->folio)) $criteria->addCondition("folio = '".$model->folio."'");


                	if (!empty($model->serie)) $criteria->addCondition("serie = '".$model->serie."'");


                	if (!empty($model->fecha)) $criteria->addCondition("fecha = '".$model->fecha."'");


                	if (!empty($model->moneda)) $criteria->addCondition("moneda = '".$model->moneda."'");


                	if (!empty($model->forma_pago)) $criteria->addCondition("forma_pago = '".$model->forma_pago."'");


                	if (!empty($model->metodo_pago)) $criteria->addCondition("metodo_pago = '".$model->metodo_pago."'");


                	if (!empty($model->tipo_cambio)) $criteria->addCondition("tipo_cambio = '".$model->tipo_cambio."'");


                	if (!empty($model->condiciones_pago)) $criteria->addCondition("condiciones_pago = '".$model->condiciones_pago."'");


                	if (!empty($model->emisor_rfc)) $criteria->addCondition("emisor_rfc = '".$model->emisor_rfc."'");


                	if (!empty($model->emisor_razon_social)) $criteria->addCondition("emisor_razon_social = '".$model->emisor_razon_social."'");


                	if (!empty($model->emisor_calle)) $criteria->addCondition("emisor_calle = '".$model->emisor_calle."'");


                	if (!empty($model->emisor_no_exterior)) $criteria->addCondition("emisor_no_exterior = '".$model->emisor_no_exterior."'");


                	if (!empty($model->emisor_no_interior)) $criteria->addCondition("emisor_no_interior = '".$model->emisor_no_interior."'");


                	if (!empty($model->emisor_colonia)) $criteria->addCondition("emisor_colonia = '".$model->emisor_colonia."'");


                	if (!empty($model->emisor_referencia)) $criteria->addCondition("emisor_referencia = '".$model->emisor_referencia."'");


                	if (!empty($model->emisor_estado)) $criteria->addCondition("emisor_estado = '".$model->emisor_estado."'");


                	if (!empty($model->emisor_cp)) $criteria->addCondition("emisor_cp = '".$model->emisor_cp."'");


                	if (!empty($model->emisor_municipio)) $criteria->addCondition("emisor_municipio = '".$model->emisor_municipio."'");


                	if (!empty($model->emisor_localidad)) $criteria->addCondition("emisor_localidad = '".$model->emisor_localidad."'");


                	if (!empty($model->emisor_pais)) $criteria->addCondition("emisor_pais = '".$model->emisor_pais."'");


                	if (!empty($model->id_receptor)) $criteria->addCondition("id_receptor = '".$model->id_receptor."'");


                	if (!empty($model->importe)) $criteria->addCondition("importe = '".$model->importe."'");


                	if (!empty($model->descuento_porcentaje)) $criteria->addCondition("descuento_porcentaje = '".$model->descuento_porcentaje."'");


                	if (!empty($model->descuento_importe)) $criteria->addCondition("descuento_importe = '".$model->descuento_importe."'");


                	if (!empty($model->iva_porcentaje)) $criteria->addCondition("iva_porcentaje = '".$model->iva_porcentaje."'");


                	if (!empty($model->subtotal)) $criteria->addCondition("subtotal = '".$model->subtotal."'");


                	if (!empty($model->iva)) $criteria->addCondition("iva = '".$model->iva."'");


                	if (!empty($model->total)) $criteria->addCondition("total = '".$model->total."'");


                	if (!empty($model->descuento_motivo)) $criteria->addCondition("descuento_motivo = '".$model->descuento_motivo."'");


                	if (!empty($model->importe_letras)) $criteria->addCondition("importe_letras = '".$model->importe_letras."'");


                	if (!empty($model->ruta_local_xml)) $criteria->addCondition("ruta_local_xml = '".$model->ruta_local_xml."'");


                	if (!empty($model->ruta_local_pdf)) $criteria->addCondition("ruta_local_pdf = '".$model->ruta_local_pdf."'");


                	if (!empty($model->ruta_ftp_xml)) $criteria->addCondition("ruta_ftp_xml = '".$model->ruta_ftp_xml."'");


                	if (!empty($model->ruta_ftp_pdf)) $criteria->addCondition("ruta_ftp_pdf = '".$model->ruta_ftp_pdf."'");


                	if (!empty($model->estatus)) $criteria->addCondition("estatus = '".$model->estatus."'");


                	if (!empty($model->uuid_certificacion)) $criteria->addCondition("uuid_certificacion = '".$model->uuid_certificacion."'");


                	if (!empty($model->fecha_certificacion)) $criteria->addCondition("fecha_certificacion = '".$model->fecha_certificacion."'");


                	if (!empty($model->lugar_expedicion)) $criteria->addCondition("lugar_expedicion = '".$model->lugar_expedicion."'");


                	if (!empty($model->num_cta_pago)) $criteria->addCondition("num_cta_pago = '".$model->num_cta_pago."'");


                	if (!empty($model->original_folio)) $criteria->addCondition("original_folio = '".$model->original_folio."'");


                	if (!empty($model->original_serie)) $criteria->addCondition("original_serie = '".$model->original_serie."'");


                	if (!empty($model->original_fecha)) $criteria->addCondition("original_fecha = '".$model->original_fecha."'");


                	if (!empty($model->original_monto)) $criteria->addCondition("original_monto = '".$model->original_monto."'");


                	if (!empty($model->emisor_regimen)) $criteria->addCondition("emisor_regimen = '".$model->emisor_regimen."'");


                	if (!empty($model->tipo_comprobante)) $criteria->addCondition("tipo_comprobante = '".$model->tipo_comprobante."'");


                	$session['FeFacturas_records']=FeFacturas::model()->findAll($criteria); 
                }


                $this->render('index',array(
                	'model'=>$model,
                ));

            }

            public function xml_to_json($url)
            {
            	$simpleXml = simplexml_load_string($url);

            	$json = json_encode($simpleXml);

            	return $json;
            }

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new FeFacturas('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['FeFacturas']))
			$model->attributes=$_GET['FeFacturas'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model=FeFacturas::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='fe-facturas-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
	public function actionGenerateExcel()
	{
		$session=new CHttpSession;
		$session->open();		

		if(isset($session['FeFacturas_records']))
		{
			$model=$session['FeFacturas_records'];
		}
		else
			$model = FeFacturas::model()->findAll();

		
		Yii::app()->request->sendFile(date('YmdHis').'.xls',
			$this->renderPartial('excelReport', array(
				'model'=>$model
			), true)
		);
	}
	public function actionGeneratePdf() 
	{
		$session=new CHttpSession;
		$session->open();
		Yii::import('application.extensions.bootstrap.gii.*');
		require_once('bootstrap/tcpdf/tcpdf.php');
		require_once('bootstrap/tcpdf/config/lang/eng.php');

		if(isset($session['FeFacturas_records']))
		{
			$model=$session['FeFacturas_records'];
		}
		else
			$model = FeFacturas::model()->findAll();



		$html = $this->renderPartial('expenseGridtoReport', array(
			'model'=>$model
		), true);
		
		//die($html);
		
		$pdf = new TCPDF();
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor(Yii::app()->name);
		$pdf->SetTitle('FeFacturas Report');
		$pdf->SetSubject('FeFacturas Report');
		//$pdf->SetKeywords('example, text, report');
		$pdf->SetHeaderData('', 0, "Report", '');
		$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, "Example Report by ".Yii::app()->name, "");
		$pdf->setHeaderFont(Array('helvetica', '', 8));
		$pdf->setFooterFont(Array('helvetica', '', 6));
		$pdf->SetMargins(15, 18, 15);
		$pdf->SetHeaderMargin(5);
		$pdf->SetFooterMargin(10);
		$pdf->SetAutoPageBreak(TRUE, 0);
		$pdf->SetFont('dejavusans', '', 7);
		$pdf->AddPage();
		$pdf->writeHTML($html, true, false, true, false, '');
		$pdf->LastPage();
		$pdf->Output("FeFacturas_002.pdf", "I");
	}
}
