<?php

class FacturacionCfdiController extends Controller
{

	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}
	public function accessRules()
	{
		return array(
			array('allow',
				'actions'=>array('error'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('index','factura','buscarAgencia'),
				'users'=>array('@'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}
	public function actionIndex()
	{
		$this->render('index');
	}
	public function actionFactura($idrecibo){
		$this->layout = "//layouts/ansonika_site";

		$recibo = Recibo::model()->findByPk($idrecibo);
		$this->render('factura', array('recibo'=>$recibo));
	}
	public function actionBuscarAgencia(){
		$rfc = $_POST['search'];

		$sql = "SELECT * FROM tbl_fe_facturas WHERE receptor_rfc LIKE '".strtoupper($rfc)."' AND estatus='A'";
		$row = Yii::app()->db->createCommand($sql)->queryAll();
		$row = $row[0];
		echo json_encode($row);
	}
	// Uncomment the following methods and override them if needed
	/*
	public function filters()
	{
		// return the filter configuration for this controller, e.g.:
		return array(
			'inlineFilterName',
			array(
				'class'=>'path.to.FilterClass',
				'propertyName'=>'propertyValue',
			),
		);
	}

	public function actions()
	{
		// return external action classes, e.g.:
		return array(
			'action1'=>'path.to.ActionClass',
			'action2'=>array(
				'class'=>'path.to.AnotherActionClass',
				'propertyName'=>'propertyValue',
			),
		);
	}
	*/
}