<?php

class FacturacionCfdiController extends Controller
{

	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}
	public function accessRules()
	{
		return array(
			array('allow',
				'actions'=>array('error'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('index','factura','buscarAgencia'),
				'users'=>array('@'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}
	public function actionIndex()
	{
		$this->render('index');
	}
	public function actionFactura($idrecibo,$tipo){
		$this->layout = "//layouts/ansonika_site";

		switch ($tipo) {
			case 'comprobante':
				$recibo = ComprobantesPago::model()->findByPk($idrecibo);
				$estatus = $recibo->estatus;
				$fechaCreacion = $recibo->log;
				break;
			case 'credito':
				$recibo = NotaCredito::model()->findByPk($idrecibo);
				$estatus = $recibo->estatus;
				$fechaCreacion = $recibo->fecha;

				break;
			case 'recibo':
			default:
				$recibo = Recibo::model()->findByPk($idrecibo);
				$estatus = $recibo->estado;
				$fechaCreacion = $recibo->log;
				// code...
				break;
		}

		// $referencia_agencia = $_SESSION['agenciaUsuario'].'A'.$idrecibo;
		$referencia_agencia = 'A'.$idrecibo;
		$facturado = FeFacturas::model()->findAll('referencia_agencia LIKE "%'.$referencia_agencia.'" AND estatus="A" AND tipo_nota="'.$tipo.'"');

		if (empty($facturado)) {
		$hoy = date('Y-m-d H:i:s'); // fecha actual
		$numDiasMesActual = date("t", strtotime($hoy)); // numero de dias que tiene el mes actual
		$mesActual = date('m',strtotime($hoy)); // mes del año actual
		$añoActual = date('Y',strtotime($hoy)); // año actual

		$fechalimite_26Mes = date('Y-m-25 23:59:59'); 
		$fechalimite_HoyMes = date('Y-m-d 23:59:59');

		// if ($numDiasMesActual==31) {
		// 	$restarFechaFinMes = strtotime('-1 day', strtotime( $fechalimite_FinMes ));
		// 	$fechalimite_FinMes = date('Y-m-d 17:00:00', $restarFechaFinMes);
		// }

		$diffFin26Actual = strtotime($fechalimite_26Mes);  
		$diffFinHoy = strtotime($fechalimite_HoyMes); 

		$mesRecibo = date("m", strtotime($fechaCreacion)); // mes que se hizo el recibo
		$añoRecibo = date("Y", strtotime($fechaCreacion)); // año que se hizo el recibo
		$numDiasMesRecibo = date('t',strtotime($fechaCreacion)); // dias que tiene el mes que se hizo el recibo

		$diffFinMesRecibo = strtotime($fechaCreacion);

		if ($diffFinMesRecibo<$diffFin26Actual && $mesRecibo==$mesActual && $añoRecibo==$añoActual && ($estatus=='P' || $estatus=='A')) {

			// $fechalimite_cincodias = strtotime ( '+5 day' , strtotime($recibo->log));
			// $fechalimite_cincodias = date('Y-m-d 23:59:59',$fechalimite_cincodias); 

			// if (date('d',strtotime($fechalimite_cincodias)) == $numDiasMesActual) {
			// 	$fechalimite_cincodias = $fechalimite_FinMes;
			// }

			// if ($mesActual < date('m',strtotime($fechalimite_cincodias))) {
			// 	$fechalimite_cincodias = $fechalimite_FinMes;
			// }

			$diffCincoDias = strtotime($fechalimite_cincodias);

			// if (strtotime($hoy)<$diffCincoDias) {
			
				$this->render('factura', array('recibo'=>$recibo,'tipo_nota'=>$tipo));
				
			// }else{
			// 	if ($_SESSION['tipoUsuario']=="Admin") {
			// 		$this->render('factura', array('recibo'=>$recibo));
			// 	}else{
			// 		$this->redirect(array('reservas/reservaciones'));
			// 	}
			// }
		}else if ($diffFinMesRecibo > $diffFin26Actual && $diffFinMesRecibo < $diffFinHoy && $mesRecibo==$mesActual && $añoRecibo==$añoActual && ($estatus=='P' || $estatus=='A')) {
			
			$this->render('factura', array('recibo'=>$recibo,'tipo_nota'=>$tipo));
			# code...
		}else{
			if ($_SESSION['agenciaUsuario'] == 9) {
				$this->render('factura', array('recibo'=>$recibo,'tipo_nota'=>$tipo));
			}else{
				$this->redirect(array('reservas/reservaciones'));
			}
			// $this->redirect(array('reservas/reservaciones'));
		}

	}else{
		$this->render('factura', array('recibo'=>$recibo,'tipo_nota'=>$tipo));
	}
}
public function actionBuscarAgencia(){
	$rfc = $_POST['search'];

	$sql = "SELECT * FROM tbl_fe_facturas WHERE receptor_rfc LIKE '".strtoupper($rfc)."' AND estatus='A'";
	$row = Yii::app()->db->createCommand($sql)->queryAll();
	$row = $row[0];
	echo json_encode($row);
}
	// Uncomment the following methods and override them if needed
	/*
	public function filters()
	{
		// return the filter configuration for this controller, e.g.:
		return array(
			'inlineFilterName',
			array(
				'class'=>'path.to.FilterClass',
				'propertyName'=>'propertyValue',
			),
		);
	}

	public function actions()
	{
		// return external action classes, e.g.:
		return array(
			'action1'=>'path.to.ActionClass',
			'action2'=>array(
				'class'=>'path.to.AnotherActionClass',
				'propertyName'=>'propertyValue',
			),
		);
	}
	*/
}