<?php
/*require_once('../api/banxico/tipocambio.php');
require_once('../api/banxico/BanamexApi.php');*/

class DashboardController extends Controller
{
	public $layout='//layouts/altair';
	

	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}
	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
/*			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('buscarDestinos', 'buscarZonas','buscarCadenas'),
				'users'=>array('*'),
			),*/
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','contabilidad','reservaciones','ejecutivo','comercial','tipocambioUSD','tipocambioUSDBanamex','proximasCancelar','verificadas','fechaLimiteAgencia','tiempoLimiteApi'),
				'users'=>array('@'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	public function actionBodas()
	{
		$this->render('bodas');
	}

	public function actionComercial()
	{
		$cobrar=$this->ReservasProximasVencer();
		
		$this->render('comercial',array('cobrar'=>$cobrar));
	}

	public function actionContabilidad()
	{

		
		$cobrar=$this->ReservasProximasVencer();
		$pagos=$this->ReservasProximasPagosHotel();
		$activitysCobrar=$this->ActividadesProximasVencer();
		
		$this->render('contabilidad',array(
			"cobrar"=>$cobrar,
			"pagos"=>$pagos,
			"activitysCobrar"=>$activitysCobrar,
			
		));
	}



	public function actionEjecutivo()
	{
		$this->render('ejecutivo');
	}

	public function actionGrupos()
	{
		$this->render('grupos');
	}

	public function actionIndex()
	{
		$this->render('index');
	}

	public function actionReservaciones()
	{
		$cobrar=$this->ReservasProximasVencer();
		$this->render('reservaciones',array('cobrar'=>$cobrar));
	}

	public function actionSistemas()
	{
		$this->render('sistemas');
	}
	public function actionTiempoLimiteApi()
	{
		$this->render('tiempoLimiteApi');
	}

	public function actionTarifas()
	{
		$this->render('tarifas');
	}

	public function actionProximasCancelar()
	{
		$pCancelar=$this->ReservasProximasCancelar();
		$this->render('proximasCancelar', array('model'=>$pCancelar));
	}


	public function actionFechaLimiteAgencia()
	{
		$pCancelar=$this->ReservasFechaLimiteAgencia();
		$this->render('proximasCancelar', array('model'=>$pCancelar));
	}
	public function actionVerificadas()
	{
		$ids=json_decode($_POST['data'],true);
		if ($ids[0]=="on") {
			unset($ids[0]);
		}
		echo $idsim=implode(',',$ids);
		$model=Reservacion::model()->findAll('id_reservacion IN ('.$idsim.')');
		foreach ($model as  $value) {
			$value->fecha_verificada=1;
			if(!$value->save())
				echo CJSON::encode($value->getErrors());
		}
		
	}

	// Uncomment the following methods and override them if needed
	/*
	public function filters()
	{
		// return the filter configuration for this controller, e.g.:
		return array(
			'inlineFilterName',
			array(
				'class'=>'path.to.FilterClass',
				'propertyName'=>'propertyValue',
			),
		);
	}

	public function actions()
	{
		// return external action classes, e.g.:
		return array(
			'action1'=>'path.to.ActionClass',
			'action2'=>array(
				'class'=>'path.to.AnotherActionClass',
				'propertyName'=>'propertyValue',
			),
		);
	}
	*/

	public function ReservasProximasVencer(){
		$hoy=date("Y-m-d");
		$fechaDe=date("Y-m-d",strtotime($hoy."-180 days"));
		$fechaHasta=date("Y-m-d",strtotime($hoy."+3 days"));
		$cobrar = Reservacion::model()->findAll(array(
			"condition"=>"saldo>0 and id_bloqueo is NULL and estatus!='C'  and fecha_limite between '".$fechaDe."' and '".$fechaHasta."'",
			"order"=>"fecha_limite"
		));

		return $cobrar;
	}

	public function ActividadesProximasVencer(){
		$hoy=date("Y-m-d");
		$fechaDe=date("Y-m-d",strtotime($hoy."-180 days"));
		$fechaHasta=date("Y-m-d",strtotime($hoy."+3 days"));
		$cobrar = ActivityReservacion::model()->findAll(array(
			"condition"=>"saldo>0 and estatus!='C'  and fecha_limite between '".$fechaDe."' and '".$fechaHasta."'",
			"order"=>"fecha_limite"
		));
		
		return $cobrar;
	}
	public function ReservasProximasPagosHotel(){
		$hoy=date("Y-m-d");
		$fechaDe=date("Y-m-d",strtotime($hoy."-7 days"));
		$fechaHasta=date("Y-m-d",strtotime($hoy."+3 days"));
		$cobrar = Reservacion::model()->findAll(array(
			"condition"=>"saldo_h>0 and id_bloqueo is NULL and estatus!='C'  and fecha_limite_h between '".$fechaDe."' and '".$fechaHasta."'",
			"order"=>"fecha_limite_h"
		));

		return $cobrar;
	}



	public function SaldoBloqueo($bloqueo, $noches){

		/*$bloqueo = Roominglist::model()->find(array(
			 'select'=>'SUM(importe) as total',
			'condition'=>'id_bloqueo='.$idBloqueo
		));
*/

		$total=0;
		$abonos=0;
		$saldo=0;
		$rooms = Roominglist::model()->findAll(array(
			'condition'=>'id_bloqueo='.$bloqueo->id_bloqueo
		));


		foreach ($rooms as $room) {
			$abonos+=$this->abonosBloqueo($room);	
			$total+=$this->cargarimporteHabBloqueo($bloqueo, $room, $noches);
			$fecha_inicio=$bloqueo->fecha_inicio;

			if (!empty($room->id_reservacion)){
				$saldoTotal += (int)$room->idReservacion->saldo;
			//echo $saldoTotal."-A-".$hab->id_roominglist."S,  ";

			}
			
		}

		
			$comision = ($bloqueo->comision)? $bloqueo->comision:$bloqueo->idAgencia->porcentaje_comision;
		
			 
		
		 $total= $total-($total*($comision/100));
		$notasCredito=$this->creditoBloqueo($bloqueo->id_bloqueo);
		$abonos+=$notasCredito;
		$saldoTotal = $total-$abonos;
		
		$importe=array(
			"total"=>$total, 
			"abonos"=>$abonos, 
			"saldo"=>$saldoTotal
		);


		//$bloqueo=$total+$model->idPaquete->precio+$totalServicios
		return $importe;

	}


	function cargarimporteHabBloqueo($bloqueo,$hab,$noches)
	{
	    if(!empty($hab["id_reservacion"]))
	    {
	        $precio = Reservacion::model()->findByPk($hab->id_reservacion);
	        $importe = $precio->comision==100? 0:$precio->total;
	    }
	    else if(empty($hab->importe))
	    {
	        $precio = TarifaDesglose::model()->find('id_tarifa='.$bloqueo->id_tarifa.' and id_tipo_habitacion='.$bloqueo->id_tipo_habitacion.' and id_base_habitacion=2');
	        $importe = $precio->precio_normal*$noches;
	    }
	    else{
	        $importe = $hab->importe;
	    }
	    return $importe;
	}


	public function nochesBloqueo($fecha_inicio,$fecha_final)
	{
		$datetime1 = new DateTime($fecha_inicio);
		$datetime2 = new DateTime($fecha_final);
		$interval = $datetime1->diff($datetime2);
		$noches= $interval->format('%a');
		return $noches;
	}

	public function abonosBloqueo($hab)
	{
			$credito = 0;
            $anticipos = 0;
            if($hab->id_agencia){
            	if (empty($hab->id_reservacion)) {
            		$anticipos=$hab->anticipo;
            	}else{
                	$anticipos = 0;
            	}
                $roomingAnticipo = RoominglistAnticipo::model()->with('idNotaCredito')->findAll('id_roominglist='.$hab->id_roominglist.' and id_agencia='.$hab->id_agencia.' and estatus="A"');
                foreach($roomingAnticipo as $row){
                    $anticipos += $row->importe;
                }
            }
            if($hab->id_reservacion){
                $roomingAnticipo = ReciboDetalles::model()->with('idRecibo')->findAll('id_reservacion='.$hab->id_reservacion.' and estado!="C"');
                foreach($roomingAnticipo as $row){
                    $anticipos += $row->importe;
                }
            }
          	  
				
          return $anticipos;
	}

	public function creditoBloqueo($idBloqueo){

			$notas = NotaCredito::model()->findAll('id_ref='.$idBloqueo.' and tipo_ref="BLOQUEO"  and estatus="A"');

			 	$credito = 0;

				foreach($notas as $row){

					$credito += $row->importe;

				}
			return $credito;		
	}	


 	public function actionTipocambioUSD(){
		/*$tc= new Banxico;
		echo $tc->getExRate();*/
	}

 	public function actionTipocambioUSDBanamex(){

		// $api = new BanamexApi;

	 //  	$html=  $api->divisas(); 

		// $buscar='<table';

		// $buscarfin='</table>';

		// $html=str_replace('<img src="/image_bin/economia_y_finanzas/ico-monedas.png" alt="Moneda" />', '', $html);
		// $html = str_replace('</div>
		// 			</div>
		// 			<div id="xDomainScriptContainer" style="display:none;"></div>
		// 		</body>
		// </html>', '', $html);

		// echo substr($html,strpos($html, $buscar));


 	}
 	public function tasaCambioActual()
	{
		$criteria = new CDbCriteria();
		$criteria->order = "id_tasa_cambio DESC";
		$tasa = TasaCambio::model()->find($criteria);
		if ($tasa) {
			$tasaArray=array('importe'=>($tasa->importe),'usuario'=>($tasa->idUser->nombre_usuario),'fecha'=>(date('d/m/y H:i', strtotime($tasa->log))));
		}else{
			$tasaArray=false;
		}
		return $tasaArray;
	}
	
 	public function ReservasProximasCancelar(){
		//$model = Reservacion::model()->with("idHotel")->findAll(' id_bloqueo is null and  (CURRENT_DATE+ INTERVAL 1 DAY) >= fecha_limite_h and idHotel.proveedor!=0 and fecha_verificada!=1 and saldo_h!=0  and t.log>"2019-01-01 00:00:00" ' );	

			$model = Reservacion::model()->with("idHotel")->findAll("id_bloqueo is null and t.estatus!='C' and (fecha_limite_h IS NULL or  fecha_limite_h < '2018-01-01 00:00:00') and t.log  >'2018-01-01 00:00:00' and saldo_h!=0  ");	


		
		/*foreach ($model as $key=>$value) {
			$reservacionDesglose=ReservacionDesglose::model()->findAll('id_reservacion='.$value->id_reservacion);
			$countHab=count($reservacionDesglose);
			$arrayEstatus=array();
			foreach ($reservacionDesglose as $desglose) {
				array_push($arrayEstatus,$desglose->estatus);
			}
			$countestatus=count($arrayEstatus);
			if ($countHab==) {
				# code...
			}
			unset($model->$key);
		}*/
		return $model;
	}
	public function ReservasFechaLimiteAgencia(){
	

			$model = Reservacion::model()->with("idHotel")->findAll("id_bloqueo is null and t.estatus!='C' and (fecha_limite IS NULL or  fecha_limite < '2018-01-01 00:00:00') and t.log  >'2018-01-01 00:00:00'   ");	


		return $model;
	}
 		
}