<?php

class CuponesAgenciasController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column1';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
			array(
                'ext.starship.RestfullYii.filters.ERestFilter + 
                REST.GET, REST.PUT, REST.POST, REST.DELETE'
            ),
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('@'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update','GeneratePdf','GenerateExcel','GenerarCupon','EchoTest','verificarCupon','aplicarCuponBook'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	public function actions()
	{
        return array('REST.'=>'ext.starship.RestfullYii.actions.ERestActionProvider',);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new CuponesAgencias;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['CuponesAgencias']))
		{
			$model->attributes=$_POST['CuponesAgencias'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id_cupon));
		}

		$this->render('create',array(
			'model'=>$model,
		));
	}

	public function generarCupon($agencia,$comision){

		$fecha = date('d/m/Y');
		$fecha_limite = implode('-',array_reverse(explode('/',$fecha)));
		$fecha_limite = date('Y-m-d 23:59:59', strtotime($fecha_limite.' + 30 days'));
		$model = new CuponesAgencias;

		$codigo = $this->generarRandom(6);
		$model->id_agencia = $agencia;
		$model->codigo = $codigo;
		$model->fecha_limite = $fecha_limite;
		if ($comision>0) {
			$model->comision = $comision;
		}
		$model->estatus = 0;

		// echo "<textarea>".CJSON::encode($model)."</textarea>";
		// exit;

		if ($model->save()) {
			return array('codigo'=>$model->codigo,'vigencia'=>$model->fecha_limite);
			// echo "Hecho";
			// exit;
		}
		// else{
		// 	echo CJSON::encode($model->getErrors());
		// }

		return false;
	}

	public function actionEchoTest(){
		$date = "2019-12-25 23:59:59";
		echo date("d/m/Y H:i:s", strtotime($date));
	}

	public function generarRandom($length = 6) { 
		$bandera = false;

		do {
			$codigo = substr(str_shuffle("ABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, $length);	
			$existCode = CuponesAgencias::model()->find('codigo="'.$codigo.'"');
			if (empty($existCode)) {
				$bandera = true;
			}
			
		} while ( $bandera == false);

    	return $codigo;
	}

	public function actionVerificarCupon(){
		if ($_POST) {
			$codigo = trim($_POST['cupon']);
			$id_agencia = $_POST['id_agencia'];
			$subtotal = $_POST['total'];
			$id_hotel = $_POST['id_hotel'];
			$proveedor = $_POST['proveedor'];
			$tarifa_neta = $_POST['tarifa_neta'];
			$moneda = (string)$_POST['moneda'];
			$subtotal_tc = 0;
			
			$existe_cupon_bandera = true;
			$buscar_cupon = CuponesAgencias::model()->find('codigo="'.$codigo.'" AND id_agencia='.$id_agencia.' AND id_reservacion IS NULL AND estatus=0');
			$mensaje = '';
			$comision = 0;
			$total = 0;
			$estatus = 0;
			$fecha_actual = date('Y-m-d H:i:s');
			$cupon_aplicado = 0;
			$color = '';

			if (empty($buscar_cupon)) { ## No hay cupon
				$color = 'danger';
				$existe_cupon_agencia = CuponesAgencias::model()->find('codigo="'.$codigo.'" AND id_agencia='.$id_agencia.' AND id_reservacion IS NOT NULL');
				
				if (!empty($existe_cupon_agencia)) { ### existe pero ya fue aplicado
					$mensaje = 'Lo sentimos, este cupón ya fue aplicado con anterioridad en la reservación: <a href="'.Yii::app()->createUrl('reservacion/view',array('id'=>$existe_cupon_agencia->id_reservacion)).'" style="color:maroon;">'.$existe_cupon_agencia->id_reservacion.'</a>';
				}else{
					$existe_cupon_bd = CuponesAgencias::model()->find('codigo="'.$codigo.'"');

					if (empty($existe_cupon_bd)) {
						#### no existe el cupon en la base de datos
						$mensaje = 'Lo sentimos, este cupón no es válido o es inexistente.';
					}else{
						### cupon existente pero en otra agencia
						$mensaje = 'Lo sentimos, este cupón no es válido para ti.';
					}
				}				
			}else{
				if (strtotime($fecha_actual) < strtotime($buscar_cupon->fecha_limite)) {
					$color = "info";
					$estatus = 1;
					$reservacionController = Yii::app()->createController('reservacion');
					$reservacionController = $reservacionController[0];
					$total = $tarifa_neta;
					$cupon_aplicado = $buscar_cupon->id_cupon;

					if ($buscar_cupon->comision==NULL) {
						$comision = "Tarifa Neta";
						$comision_hotel = Hoteles::model()->findByPk($id_hotel);
						$mensaje = 'Código valido aplicando el total de la comisión sobre la reserva. Se reflejará al generar la reserva e ingresar al cupón.';
						
						if (empty($tarifa_neta)) {
							# code...
							if ($proveedor==0) {
							
								$comisionHotel = $comision_hotel->comision;
								$total = $subtotal - ($subtotal*($comisionHotel/100)); ## proveedor 0
							
							}else{
								switch ($proveedor) {
									case 1:
									$comisionHotel = Api::model()->findByPk(1)->markup;
									$total = $reservacionController->saldoHotel($subtotal,$comisionHotel,"Api");
									break;
									case 2:
									$comisionHotel=$comision_hotel->comision;
									$total=$reservacionController->saldoHotel($subtotal, $comisionHotel,"comision");
									break;
									case 3:
									$comisionHotel = Api::model()->findByPk(6)->markup;
									$total = $reservacionController->saldoHotel($subTotal,$comisionHotel,"Api");
									break;
									case 4:
									// $comisionHotel = Api::model()->findByPk(7)->markup;
									$comisionHotel = 20;
									$total = $reservacionController->saldoHotel($subtotal,20,"comision");
									break;
									case 5:
									$comisionHotel = $comision_hotel->comision;
									$total = $reservacionController->saldoHotel($subtotal,$comisionHotel,"comision");
									break;
									case 6:
									$comisionHotel = Api::model()->findByPk(9)->markup;
									$total = $reservacionController->saldoHotel($subtotal,$comisionHotel,"Api");
									break;
									default:

									break;
								}
							}

						}
						
						// $total = $reservacionController->saldoHotel($subTotal,$comision_hotel,"Api"); ## dependiendo el proveedor
					}else{
						$comision = $buscar_cupon->comision.'%';
						$comisionHotel = $buscar_cupon->comision;
						$total = $subtotal-($subtotal*($comisionHotel/100));
						$mensaje = 'Código valido aplicando una comisión del '.$comision.' sobre la reserva. Se reflejará al generar la reserva e ingresar al cupón.';
					}

					if ($moneda=="USD") {
						$subtotal_tc = ($total*19.5);
					}

					
				}else{
					$color = 'danger';
					$mensaje = 'Lo sentimos, la fecha límite del código ingresado ya venció. Fecha de vencimiento: '.date('d/m/Y H:i:s', strtotime($buscar_cupon->fecha_limite));
				}
			}

			echo json_encode(array('estatus'=>$estatus, 'mensaje'=>$mensaje, 'comision'=>$comision, 'total'=>$total,'comision_aplicable'=>$comisionHotel,'total_tc'=>$subtotal_tc,'moneda'=>$moneda,'folio_aplicado'=>$cupon_aplicado,'color'=>$color));
		}
	}

	public function actionAplicarCuponBook(){
		if ($_POST['id']) {
			$codigo = trim($_POST['cupon']);
			$id_agencia = $_POST['id_agencia'];
			$id_reservacion = $_POST['id'];
			$reservacion = Reservacion::model()->findByPk($id_reservacion);
			
			$existe_cupon_bandera = true;
			$buscar_cupon = CuponesAgencias::model()->find('codigo="'.$codigo.'" AND id_agencia='.$id_agencia.' AND id_reservacion IS NULL AND estatus=0');

			$mensaje = '';
			$comision = 0;
			$estatus = 0;
			$fecha_actual = date('Y-m-d H:i:s');
			$cupon_aplicado = 0;
			$color = '';

			if (empty($buscar_cupon)) { ## No hay cupon

				$color = "danger";
				$existe_cupon_agencia = CuponesAgencias::model()->find('codigo="'.$codigo.'" AND id_agencia='.$id_agencia.' AND id_reservacion IS NOT NULL');
				
				if (!empty($existe_cupon_agencia)) { ### existe pero ya fue aplicado
					// $mensaje = 'Lo sentimos, este cupón ya fue aplicado con anterioridad en la reservación: '.$existe_cupon_agencia->id_reservacion;
					$mensaje = 'Lo sentimos, este cupón ya fue aplicado con anterioridad en la reservación: <a href="'.Yii::app()->createUrl('reservacion/view',array('id'=>$existe_cupon_agencia->id_reservacion)).'" style="color:maroon;">'.$existe_cupon_agencia->id_reservacion.'</a>';
				}else{
					$existe_cupon_bd = CuponesAgencias::model()->find('codigo="'.$codigo.'"');

					if (empty($existe_cupon_bd)) {
						#### no existe el cupon en la base de datos
						$mensaje = 'Lo sentimos, este cupón no es válido o es inexistente.';
					}else{
						### cupon existente pero en otra agencia
						$mensaje = 'Lo sentimos, este cupón no es válido para ti.';
					}
				}				
			}else{

				$reservacion_aplicado = CuponesAgencias::model()->find('id_reservacion='.$id_reservacion);

				if (empty($reservacion_aplicado)) {
					if (empty($reservacion->id_bloqueo)) {
						if (strtotime($fecha_actual) <= strtotime($buscar_cupon->fecha_limite)) {

							$color = "info";

							$estatus = 1;
							$reservacionController = Yii::app()->createController('reservacion');
							$reservacionController = $reservacionController[0];
							$total = $tarifa_neta;
							$cupon_aplicado = $buscar_cupon->id_cupon;

							if ($buscar_cupon->comision==NULL) {
								$comision = "Tarifa Neta";
								$comision_hotel = Hoteles::model()->findByPk($reservacion->id_hotel);
								$mensaje = 'Código valido aplicando el total de la comisión sobre la reserva.';

								if ($reservacion->idHotel->proveedor==0) {

									$comisionHotel = $comision_hotel->comision;

								}else{
									switch ($reservacion->idHotel->proveedor) {
										case 1:
										// $comisionHotel = Api::model()->findByPk(1)->markup;
										$comisionHotel = Api::model()->findByPk(1)->markup;
										$comisionHotel = 100 - ($comisionHotel * 100);
										break;
										case 2:
										$comisionHotel=$comision_hotel->comision;
										break;
										case 3:
										$comisionHotel = Api::model()->findByPk(6)->markup;
										$comisionHotel = 100 - ($comisionHotel * 100);
										break;
										case 4:
										$comisionHotel = 20;
										break;
										case 5:
										$comisionHotel = $comision_hotel->comision;
										break;
										case 6:
										$comisionHotel = Api::model()->findByPk(9)->markup;
										break;
										default:

										break;
									}
								}
							}else{
								$comision = $buscar_cupon->comision.'%';
								$comisionHotel = $buscar_cupon->comision;
								$mensaje = 'Código valido aplicando una comisión del '.$comision.' sobre la reserva.';
							}

							$pagos = ReciboDetalles::model()->findAll('id_reservacion='.$reservacion->id_reservacion.' and tipo="" ');
							$count = 0;
							$importe = 0;

							foreach($pagos as $row)
							{
								$recibo = Recibo::model()->findByPk($row->id_recibo);
								if($recibo->estado != 'C')
								{
									$count+= 1;
									$importe+= $row->importe;
								}
							}

							if(!empty($reservacion->tipo_cambio)){
								$total_cambio = round($reservacion->total_tc * $reservacion->tipo_cambio,2);
								$saldo_nuevo = $total_cambio - ($total_cambio*($comisionHotel/100));
							}else{
								$saldo_nuevo = $reservacion->total - ($reservacion->total*($comisionHotel/100));
							}

							if ($reservacion->moneda == "USD" && $reservacion->idHotel->proveedor != 0) {
								$total_cambio = round($reservacion->total * 19.500,2);
								$saldo_nuevo = $total_cambio - ($total_cambio*($comisionHotel/100));
							}

							$reservacion->comision = $comisionHotel;
							$reservacion->saldo = round($saldo_nuevo - $importe,2);

							if($reservacion->save()){

								$buscar_cupon->id_reservacion = $reservacion->id_reservacion;
								$buscar_cupon->estatus = 1;

								if (!$buscar_cupon->save()) {
									print_r($buscar_cupon->getErrors());
								}

								$mensajeComision = 'Se modificó la comisión de la reserva correctamente.';
								$operacion = Yii::app()->createController('operacionesLog');
								$operacion = $operacion[0];
								$operacion->Create($reservacion->id_reservacion,25);
							}else{
								$mensajeComision = 'Error al modificar la comisión de la reservación #'.$reservacion->id_reservacion.' !';
							}

						}else{

							$color = "danger";

							$mensaje = 'Lo sentimos, la fecha límite del código ingresado ya venció. Fecha de vencimiento: '.date('d/m/Y H:i:s', strtotime($buscar_cupon->fecha_limite));
						}

					}else{

						$color = "danger";

						$mensaje = 'Lo sentimos, no puede aplicar el código en un bloqueo.';
					}

				}else{

					$color = "danger";

					$mensaje = 'Lo sentimos, la reservación actual ya tiene un código de promoción aplicado.';

				}
				
			}

			echo json_encode(array('estatus'=>$estatus, 'mensaje'=>$mensaje, 'comision'=>$comision, 'mensajeComision'=>$mensajeComision,'comision_aplicable'=>$comisionHotel,'folio_aplicado'=>$cupon_aplicado,'color'=>$color));

		}
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['CuponesAgencias']))
		{
			$model->attributes=$_POST['CuponesAgencias'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id_cupon));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		if(Yii::app()->request->isPostRequest)
		{
			// we only allow deletion via POST request
			$this->loadModel($id)->delete();

			// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
			if(!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
		}
		else
			throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
            $session=new CHttpSession;
            $session->open();		
            $criteria = new CDbCriteria();            

                $model=new CuponesAgencias('search');
                $model->unsetAttributes();  // clear any default values

                if(isset($_GET['CuponesAgencias']))
		{
                        $model->attributes=$_GET['CuponesAgencias'];
			
			
                   	
                       if (!empty($model->id_cupon)) $criteria->addCondition("id_cupon = '".$model->id_cupon."'");
                     
                    	
                       if (!empty($model->id_agencia)) $criteria->addCondition("id_agencia = '".$model->id_agencia."'");
                     
                    	
                       if (!empty($model->codigo)) $criteria->addCondition("codigo = '".$model->codigo."'");
                     
                    	
                       if (!empty($model->id_reservacion)) $criteria->addCondition("id_reservacion = '".$model->id_reservacion."'");
                     
                    	
                       if (!empty($model->fecha_limite)) $criteria->addCondition("fecha_limite = '".$model->fecha_limite."'");
                     
                    	
                       if (!empty($model->comision)) $criteria->addCondition("comision = '".$model->comision."'");
                     
                    	
                       if (!empty($model->estatus)) $criteria->addCondition("estatus = '".$model->estatus."'");
                     
                    	
                       if (!empty($model->log)) $criteria->addCondition("log = '".$model->log."'");
                     
                    			
                    $session['CuponesAgencias_records']=CuponesAgencias::model()->findAll($criteria); 
		}
       

                $this->render('index',array(
			'model'=>$model,
		));

	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new CuponesAgencias('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['CuponesAgencias']))
			$model->attributes=$_GET['CuponesAgencias'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model=CuponesAgencias::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='cupones-agencias-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
        public function actionGenerateExcel()
	{
            $session=new CHttpSession;
            $session->open();		
            
             if(isset($session['CuponesAgencias_records']))
               {
                $model=$session['CuponesAgencias_records'];
               }
               else
                 $model = CuponesAgencias::model()->findAll();

		
		Yii::app()->request->sendFile(date('YmdHis').'.xls',
			$this->renderPartial('excelReport', array(
				'model'=>$model
			), true)
		);
	}
        public function actionGeneratePdf() 
	{
           $session=new CHttpSession;
           $session->open();
		Yii::import('application.extensions.bootstrap.gii.*');
		require_once('bootstrap/tcpdf/tcpdf.php');
		require_once('bootstrap/tcpdf/config/lang/eng.php');

             if(isset($session['CuponesAgencias_records']))
               {
                $model=$session['CuponesAgencias_records'];
               }
               else
                 $model = CuponesAgencias::model()->findAll();



		$html = $this->renderPartial('expenseGridtoReport', array(
			'model'=>$model
		), true);
		
		//die($html);
		
		$pdf = new TCPDF();
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor(Yii::app()->name);
		$pdf->SetTitle('CuponesAgencias Report');
		$pdf->SetSubject('CuponesAgencias Report');
		//$pdf->SetKeywords('example, text, report');
		$pdf->SetHeaderData('', 0, "Report", '');
		$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, "Example Report by ".Yii::app()->name, "");
		$pdf->setHeaderFont(Array('helvetica', '', 8));
		$pdf->setFooterFont(Array('helvetica', '', 6));
		$pdf->SetMargins(15, 18, 15);
		$pdf->SetHeaderMargin(5);
		$pdf->SetFooterMargin(10);
		$pdf->SetAutoPageBreak(TRUE, 0);
		$pdf->SetFont('dejavusans', '', 7);
		$pdf->AddPage();
		$pdf->writeHTML($html, true, false, true, false, '');
		$pdf->LastPage();
		$pdf->Output("CuponesAgencias_002.pdf", "I");
	}
}
