<?php
error_reporting(E_ERROR | E_WARNING | E_PARSE);
Yii::import('application.extensions.phpmailer.JPhpMailer');
Yii::import('application.extensions.bootstrap.gii.*');
require_once('bootstrap/tcpdf/tcpdf.php');
require_once('bootstrap/tcpdf/config/lang/eng.php');

class MYPDF extends TCPDF {
	public $footer = "";
	public $model_contract = "";
	public $tipo_bloqueo = "";
	private $last_page = false;

	public function Close() {
		$this->last_page = true;
		parent::Close();
	}
	
	function setParams($contacto, $model_c, $tipo) {
		$this->contacto_agencia = $contacto;
		$this->model_contract = $model_c;
		$this->tipo_bloqueo = $tipo;
	}

	//Page header
    public function Header() {
        // Logo
    	$this->Image(($_SERVER['DOCUMENT_ROOT'] ."/archivos/contratos/logo-rmt.PNG"), 20, 5, 30, '', 'PNG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        if($this->tipo_bloqueo == "GRUPAL")
        	$this->Image(($_SERVER['DOCUMENT_ROOT'] ."/archivos/contratos/logo-grupos.PNG"), 155, 5, 30, '', 'PNG', '', 'T', false, 300, '', false, false, 0, false, false, false);
		else if($this->tipo_bloqueo="BODA")
			$this->Image(($_SERVER['DOCUMENT_ROOT'] ."/archivos/contratos/logo-casate-conmigo.png"), 155, 10, 30, '', 'PNG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        // Set font
        $this->SetFont('helvetica', 'B', 20);
        // Title
        $this->Cell(0, 15, "", 0, false, 'C', 0, '', 0, false, 'M', 'M');
		//$this->writeHTML("AAAAAAAAAAAAAAAAAAA", true, false, false, false, "");
    }

    // Page footer
    public function Footer() {
    	$contacto="";
    	if (!$this->last_page) {
    		$contacto= $this->contacto_agencia;
    	}
			$this->footer = "
			<table>
				<tr>
					<td>Av. Cupúles # 236 por 20 y 22 Col. García Ginerés C.P. 97070,</td>
					<td></td>
					<td></td>
					<td></td>
				</tr>
				<tr>
					<td>Mérida, Yucatán Tels. (999) 925 5443</td>
					<td></td>
					<td>". $contacto."</td>
					<td></td>
				</tr>
				<tr>
					<td>www.rutamayatravel.com</td>
					<td>Página ". $this->getAliasNumPage()." de ".$this->getAliasNbPages() ."</td>
					<td></td>
					<td><img src='".$_SERVER['DOCUMENT_ROOT'] ."/archivos/contratos/negrogarantia.png' with='50'></td>
				</tr>
			</table>";
			// Position at 15 mm from bottom
			$this->SetY(-20);
			// Set font
			$this->SetFont('helvetica', 'I', 8);
			// Page number
			//$this->Cell(0, 10, 'Page '.$this->getAliasNumPage().' of '.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
			//$this->Cell(0, 10, $this->footer, 0, false, 'C', 0, '', 0, false, 'T', 'M');
			//$this->writeHTML($this->footer, false, true, false, true); //ORIGINAL
			if(!$this->last_page) {
				if($this->model_contract->status == "S")
					$this->Image(($_SERVER['DOCUMENT_ROOT'] ."/archivos/contratos/firmas/". $this->model_contract->id_user_signed ."-signature.jpg"), 105, 268, 60, 20, 'JPG', '', '', true, 150, '', false, false, 0, false, false, false);
			} 
			$this->writeHTML($this->footer, true, false, false, false, "");
			$this->Image(($_SERVER['DOCUMENT_ROOT'] ."/archivos/contratos/negrogarantia.png"), 170, 270, 30, '', 'PNG', '', 'T', false, 100, '', false, false, 0, false, false, false);
			//$this->writeHTMLCell(0, 0, '', '', $this->footer, 0, 0, false,true, "L", true);
    }
}

class ContractsController extends Controller {
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/ansonika_site';
	/**
	 * @return array action filters
	 */
	/*public function filters() {
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}*/
	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	/*public function accessRules() {
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index', 'getCadenasWithWeddings', 'getPaquetesBoda', 'first', 'cropImage', 'signature', 'signContract', 'uploadImgBase64', 'getSignatureBase64', 'signaturePDF', 'viewContract','mailEnlaceContratos'),
				'users'=>array('*'),
			),
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('echo'),
				'users'=>array('@'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}*/

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionIndex() {
		$this->render("index");
	}

	public function actionCropImage() {
		$this->render("cropImage");
	}

	public function actionSignature() {
		$this->render("signature");
	}

	public function actionViewContract($id, $us) {
		$this->layout='//layouts/homey_blanco';
		
		$id_us = base64_decode($us);
		$model_user = User::model()->findByPk($id_us);
		$model_contract = Contracts::model()->find("id_bloqueo = ". $id);

		if(is_null($model_user->id)) {
			$this->render("errorPDF", array(
				"error" => "NO SE HA ENCONTRADO NINGÚN USUARIO QUE COINCIDA CON ESTE CONTRATO."
			));
		} else if(is_null($model_contract->id_contract)) {
			$this->render("errorPDF", array(
				"error" => "NO SE CREÓ NINGÚN CONTRATO PARA ESTE GRUPO."
			));
		}  else if($model_contract->status == "S") {
			$this->render("errorPDF", array(
				"error" => "ESTE CONTRATO YA HA SIDO FIRMADO PREVIAMENTE."
			));
		} else {
			$this->render("viewContract");
		}
	}

	public function actionUploadImgBase64() {
		$data = $_POST["base64img"];
		list($type, $data) = explode(';', $data);
		list(, $data) = explode(',', $data);
		$data = base64_decode($data);
		$url = $_POST["type"] == "signature" ? "firmas" : "logos";
		/*echo $_SERVER['DOCUMENT_ROOT'] ."/archivos/contratos/". $url ."/image.png";
		exit;*/

		$id_user = Yii::app()->user->id;
		$model_signature = Signatures::model()->find("id_user = ". $id_user);
		$model_signature->signature = $id_user ."-signature.jpg";
		if(!isset($model_signature->id_signature)) {
			$model_signature = new Signatures;
			$model_signature->id_user = $id_user;
			$model_signature->save();
		}
		
		echo file_put_contents($_SERVER['DOCUMENT_ROOT'] ."/archivos/contratos/". $url ."/". $model_signature->signature, $data);
	}

	public function uploadSignatureBase64($base64img, $id_usuario) {
		//$data = $_POST["base64img"];
		$data = $base64img;
		list($type, $data) = explode(';', $data);
		list(, $data) = explode(',', $data);
		$data = base64_decode($data);
		//$url = $_POST["type"] == "signature" ? "firmas" : "logos";
		$url = "firmas";
		/*echo $_SERVER['DOCUMENT_ROOT'] ."/archivos/contratos/". $url ."/image.png";
		exit;*/
		//$id_user = Yii::app()->user->id;
		$id_user = $id_usuario;
		$model_signature = Signatures::model()->find("id_user = ". $id_user);
		if(is_null($model_signature->id_signature)) {
			$model_signature = new Signatures;
			$model_signature->signature = $id_user ."-signature.jpg";
			$model_signature->id_user = $id_user;
			$model_signature->save();
		}
		
		return file_put_contents($_SERVER['DOCUMENT_ROOT'] ."/archivos/contratos/". $url ."/". $model_signature->signature, $data);
	}

	public function actionSignContract() {
		$params = $_POST;
		$id_usuario = base64_decode($_POST["id_us"]);

		$model_signature = Signatures::model()->find("id_user = ". $id_usuario);
		$model_contract = Contracts::model()->find("id_bloqueo = ". $params["id_bloqueo"]);

		if($model_contract->status == "S") {
			echo "El contrato ya ha sido firmado con anterioridad.";
			exit;
		}
		

		if(is_null($model_signature->id_signature) || $_POST["edited"]) {
			$this->uploadSignatureBase64($params["base64img"], $id_usuario);
		}

		//$model_contract->id_user_signed = Yii::app()->user->id;
		$model_contract->id_user_signed = $id_usuario;
		$model_contract->status = "S";
		$model_contract->time = date("H:i:s");
		$model_contract->date = date("Y-m-d");
		$model_contract->ip = $_SERVER['REMOTE_ADDR'];
		$model_contract->save();
		$this->sendAdviceSignedContract($model_contract);
		echo CJSON::encode($model_contract);
	}	

	public function actionEcho() {
		//echo 'http://'.$_SERVER["SERVER_NAME"].Yii::app()->request->baseUrl.'/getTarifas/ObtenerTarifas';
		//echo date("H:i:s");
		$rmt_url = Yii::app()->baseUrl ."/admin";
      	$rmt_url = substr($rmt_url, 0, -5);
      	echo $rmt_url;
	}

	public function sendAdviceSignedContract($model_contract) {
		$model_bloqueo=Bloqueo::model()->findByPk($model_contract->id_bloqueo);
		$message = "Buenas tardes. Es un gusto saludarle. <br>Por este medio le confirmamos que su contrato del grupo: <b>". $model_contract->id_bloqueo  .", ". $model_bloqueo->titulo_evento ."</b> ha sido firmado con éxito.
		<p>Sin más por el momento, quedo a sus órdenes.</p>
		<p>Saludos cordiales.</p>";
		$mail = new JPhpMailer;
		$mail->IsSMTP();
		$mail->Host = 'rutamayatravel.com'; 
		$mail->SMTPAuth = true;
		$mail->Username = 'no-reply@rutamayatravel.com'; 
		$mail->Port = '26'; 
		$mail->Password = 'Intelred76'; 
		$mail->SMTPKeepAlive = true;  
		$mail->Mailer = "smtp"; 
		$mail->IsSMTP();  
		$mail->SMTPAuth = true;  
		$mail->CharSet = 'utf-8';  
		$mail->SMTPDebug  = 0;
		//$mail->SetFrom('no-reply@rutamayatravel.com', 'Sistema Ruta Maya Travel'); 
		$mail->Subject = "Contrato firmado"; 
		$mail->AltBody = 'To view the message, please use an HTML compatible email viewer!'; 
		$mail->MsgHTML($message);

		$model_user = Usuarios::model()->findByPk($model_contract->id_user_created);
		$model_user_agencia = Usuarios::model()->findByPk($model_contract->id_user_signed);
		$mail->SetFrom($model_user->email_usuario, $model_user->nombre_usuario); 
		$mail->AddAddress($model_user_agencia->email_usuario, $model_user_agencia->nombre_usuario);
		//$mail->AddAddress("programador4@rutamayatravel.com", $model_user_agencia->nombre_usuario);
		//$mail->AddAddress($model_user->email_usuario, $model_user->nombre_usuario);
		//$mail->AddBCC("grupos1@rutamayatravel.com");
		//$mail->AddBCC("grupos2@rutamayatravel.com");
		//
		if ($model_bloqueo->idTarifa->precio=="BODA") {
			$mail->AddBCC("bodas@rutamayatravel.com");
			$mail->AddBCC("sugely.lizama@rutamayatravel.com");
			
		}else{
			$mail->AddBCC("leticiavarguez@rutamayatravel.com");

		}
		//$mail->AddBCC("programador4@rutamayatravel.com");
		$mail->AddBCC("jorgevadillo@rutamayatravel.com");
		//$mail->AddBCC($model_user->email_usuario);
		$mail->Send();
	}

	public function actionGetSignatureBase64($id_us) {
		//$id_user = Yii::app()->user->id;
		$id_user = base64_decode($id_us);
		//$id_user = 1432;
		$signature = Signatures::model()->find("id_user = ". $id_user);
		if(is_null($signature->id_signature)) {
			echo "not found";
		} else {
			echo base64_encode(file_get_contents($_SERVER['DOCUMENT_ROOT'] ."/archivos/contratos/firmas/". $id_user ."-signature.jpg"));
		}
	}

	public function actionSignaturePDF($id_bloqueo) {
		$model_contract = Contracts::model()->find("id_bloqueo = ". $id_bloqueo);
		$model_bloqueo = Bloqueos::model()->findByPk($id_bloqueo);
		$model_agencia = Agencias::model()->findByPk($model_bloqueo->id_agencia);
		$model_user_created = Usuarios::model()->findByPk($model_contract->id_user_created);
		$model_hotel = Hoteles::model()->findByPk($model_bloqueo->id_hotel);
		$model_plan = Plan::model()->findByPk($model_bloqueo->id_tipo_plan);
		$model_tipo_hab = TipoHabitaciones::model()->findByPk($model_bloqueo->id_tipo_habitacion);
		$model_tarifa = Tarifa::model()->findByPk($model_bloqueo->id_tarifa);
		$model_tarifa_desglose = TarifaDesglose::model()->findAll("id_tarifa = ". $model_bloqueo->id_tarifa);
		$model_desglose_menores = DesgloseMenores::model()->findAll("id_tarifa = ". $model_bloqueo->id_tarifa);
		$model_cortesias = Roominglist::model()->findAll("id_bloqueo = ". $id_bloqueo ." AND cortesia = 1");
		$model = Roominglist::model()->findAll("id_bloqueo = ". $id_bloqueo);

		$desglose=$this->desgloseReservacion($model[0]);
		//echo json_encode($desglose);
		if(!is_null($model_contract->id_user_signed)) {
			$model_signature_signed = Signatures::model()->find("id_user = ". $model_contract->id_user_signed);
		}
		$model_signature_rmt = Signatures::model()->find("id_user = ". $model_contract->id_user_created);

		$model_politica_pago = GruposPoliticasPagos::model()->find("id_bloqueo = ". $id_bloqueo);
		if(count($model_politica_pago) == 0) {
			$this->render("errorPDF", array(
				"error" => "NO DIO DE ALTA UNA POLÍTICA DE PAGO, POR FAVOR AGREGUE UNA E INTENTE DE NUEVO."
			));
		} else {
			$model_pagos_desglose = GruposPoliticasPagosDesglose::model()->findAll("id_politicas_pagos = ". $model_politica_pago->id_politicas_pagos);
			if(count($model_pagos_desglose) == 0) {
				$this->render("errorPDF", array(
					"error" => "NO DIO DE ALTA NINGUNA FECHA DE PAGO, POR FAVOR AGREGUE AL MENOS UNA E INTENTE DE NUEVO."
				));
			}
		}

		$html = $this->renderPartial("contractHtmlToPdf", array(
			"model_contract" => $model_contract,
			"model_bloqueo" => $model_bloqueo,
			"model_agencia" => $model_agencia,
			"model_user_created" => $model_user_created,
			"model_hotel" => $model_hotel,
			"model_plan" => $model_plan,
			"model_tipo_hab" => $model_tipo_hab,
			"model_tarifa" => $model_tarifa,
			"model_tarifa_desglose" => $model_tarifa_desglose,
			"model_desglose_menores" => $model_desglose_menores,
			"model_cortesias" => $model_cortesias,
			"model_politica_pago" => $model_politica_pago,
			"model_pagos_desglose" => $model_pagos_desglose,
			"model_signature_signed" => $model_signature_signed,
			"model_signature_rmt" => $model_signature_rmt,
			"desglose"=>$desglose,
		), true);

		/* echo $html_footer;
		exit; */

		$pdf = new MYPDF();
		//$pdf->setParams($html_footer, $model_contract, "0");
		$contacto = is_null($model_agencia->representante_legal) || empty($model_agencia->representante_legal) ? $model_agencia->contacto : $model_agencia->representante_legal;
		$pdf->setParams($contacto, $model_contract, $model_tarifa->precio);
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor(Yii::app()->name);
		$pdf->SetTitle("Contrato");
		$pdf->SetSubject("Contrato");
		$pdf->SetMargins(20, 35, 20);

		$pdf->setPrintHeader(true);
		$pdf->SetHeaderMargin(10);

		$pdf->setPrintFooter(true);
		$pdf->SetFooterMargin(10);

		$pdf->SetAutoPageBreak(TRUE, 30); //SEGUNDO PARAMETRO PARA MARGIN BOTTOM
		$pdf->SetFont('dejavusans', '', 10);
		// $pdf->setPageOrientation('L');
		$pdf->AddPage();
		// get the current page break margin
		$bMargin = $pdf->getBreakMargin();
		// get current auto-page-break mode
		$auto_page_break = $pdf->getAutoPageBreak();
		// disable auto-page-break
		$pdf->SetAutoPageBreak(false, 0);

		// set bacground image
		//$img_file = K_PATH_IMAGES . $model_event->flyer;

		//$pdf->Image($img_file, 0, 10, 210, 277, '', '', '', false, 300, '', false, false, 0);
		// restore auto-page-break status
		$pdf->SetAutoPageBreak($auto_page_break, $bMargin);
		// set the starting point for the page content
		$pdf->setPageMark();

		$pdf->writeHTML($html, true, false, true, false, '');
		$pdf->LastPage();

		$pdf->Output("contrato.pdf", "I");
		if ($model_contract->status=="S") {
			if (!file_exists($_SERVER['DOCUMENT_ROOT'] ."/archivos/contratos/contratosFirmados/contrato_firmado_".$model_bloqueo->id_bloqueo.'.pdf')) {
				$pdf->Output($_SERVER['DOCUMENT_ROOT'] ."/archivos/contratos/contratosFirmados/contrato_firmado_".$model_bloqueo->id_bloqueo.'.pdf', "F");
			}
		}
	}

	public function getActions() {
        $path = Yii::app()->controllerPath;
        $data = array();
        $files = CFileHelper::findFiles($path, array("fileTypes" => array("php")));
        //echo json_encode($files);
        $index = array_search("/home/rutamayatravel/public_html/sur4/protected/controllers/ContractsController.php", $files);
        $filename = basename($files[$index], '.php');
        if (($pos = strpos($filename, 'Controller')) > 0) {
            $class_name = $controllers[] = substr($filename, 0, $pos);
            $f = new ReflectionClass($filename);
            $methods = array();
            foreach ($f->getMethods() as $m) {
                if ($m->class == $class_name . "Controller" && preg_match('/^action+\w{2,}/', $m->name)) {
                    $methods[] = str_replace("action", "", $m->name);
                }
            }
            //$data[$filename] = $methods;
        }
        return $methods;
    }

    // Metodo orignial de getActions
    public function getControllers() {
        $path = Yii::app()->controllerPath;
        $data = array();
        $files = CFileHelper::findFiles($path, array("fileTypes" => array("php")));
        foreach ($files as $file) {
            include_once $file;
            $filename = basename($file, '.php');
            if (($pos = strpos($filename, 'Controller')) > 0) {
                $class_name = $controllers[] = substr($filename, 0, $pos);
                $f = new ReflectionClass($filename);
                $methods = array();
                foreach ($f->getMethods() as $m) {
                    if ($m->class == $class_name . "Controller" && preg_match('/^action+\w{2,}/', $m->name)) {
                        $methods[] = str_replace("action", "", $m->name);
                    }
                }
                $data[$filename] = $methods;
            }
        }
        return $data;
    }

	public function actionTest() {
		/*$model=Bloqueos::model()->findByPk(1758);
		$this->renderPartial('//bloqueos/_informacionEvento',array('model'=>$model));*/
		echo "test";
	}

	public function actionMailEnlaceContratos() {
		$id=explode('id=', $_POST['email_enlace']);
		$emailrmt=Yii::app()->user->email;
		if (Yii::app()->user->id==51) {
			$emailrmt="bodas@rutamayatravel.com";
		}
		$model=Bloqueos::model()->findByPk($id[1]);
		/*$encabezados  = "MIME-Version: 1.0\n";
		$encabezados .= "Content-type: text/html; charset=UTF-8\n";
		$encabezados .= "From:  Ruta Maya Travel <".$emailrmt.">\n";
		$encabezados .= 'Cc: '.$emailrmt. "\r\n";
		$encabezados .= "X-Sender: <contacto web>\n";
		$encabezados .= "X-Mailer: PHP\n";
		$encabezados .= "X-Priority: 3\n";
		$encabezados .= "Return-Path: <web page>\n";
		$fecha = date("d-m-Y H:i:s");
		$recipent = $_POST["email_enlace"];
		$subject = "Enlace de Contrato de grupo: ".$model->titulo;*/
		$message = "
				<center><b>RUTA MAYA TRAVEL</b><br>
				Buenas tardes por este medio le envío el siguiente enlace para la revisión del convenio ".$model->idTarifa->precio.", y estando todo en orden pido por favor firmar el documento<br><br>";
		//$message.=$this->renderPartial('//bloqueos/_informacionEvento',array('model'=>$model),true);
		$message.="<a href=".$_POST['enlace'].">Firma en linea</a></center>";
		$mail = new JPhpMailer;
		$mail->IsSMTP();
		$mail->Host = 'rutamayatravel.com'; 
		$mail->SMTPAuth = true;
		$mail->Username = 'no-reply@rutamayatravel.com'; 
		$mail->Port = '26'; 
		$mail->Password = 'Intelred76'; 
		$mail->SMTPKeepAlive = true;  
		$mail->Mailer = "smtp"; 
		$mail->IsSMTP();  
		$mail->SMTPAuth = true;  
		$mail->CharSet = 'utf-8';  
		$mail->SMTPDebug  = 0;
		//$mail->SetFrom('no-reply@rutamayatravel.com', 'Sistema Ruta Maya Travel'); 
		$mail->Subject = "Enlace de Contrato de grupo: ".$model->titulo;
		$mail->AltBody = 'To view the message, please use an HTML compatible email viewer!'; 
		$mail->MsgHTML($message);

		
		$mail->SetFrom($emailrmt, "Ruta Maya Travel"); 
		$mail->AddAddress($_POST["email_enlace"],$_POST["email_enlace"]);
		//$mail->AddAddress("programador4@rutamayatravel.com", $model_user_agencia->nombre_usuario);
		//$mail->AddAddress($model_user->email_usuario, $model_user->nombre_usuario);
		//$mail->AddBCC("grupos1@rutamayatravel.com");
		//$mail->AddBCC("grupos2@rutamayatravel.com");
		//
		if ($model_bloqueo->idTarifa->precio=="BODA") {
			$mail->AddBCC("bodas@rutamayatravel.com");
			$mail->AddBCC("sugely.lizama@rutamayatravel.com");
			
		}else{
			$mail->AddBCC("leticiavarguez@rutamayatravel.com");

		}
		//$mail->AddBCC("programador4@rutamayatravel.com");
		$mail->AddBCC("jorgevadillo@rutamayatravel.com");
		//$mail->AddBCC($model_user->email_usuario);
		$mail->Send();
		
		
		
		// message lines should not exceed 70 characters (PHP rule), so wrap it
		// send mail
		/*if(mail($recipent,$subject,$message,$encabezados)){

			echo 'Mensaje Enviado!';
		}else{
			echo "Mensaje No enviado. Intente de nuevo";
		}*/
	}
}