<?php
Yii::import('application.extensions.bootstrap.gii.*');
require_once('bootstrap/tcpdf/tcpdf.php');
require_once('bootstrap/tcpdf/config/lang/eng.php');

class CarritoController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout = '//layouts/column1';

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array(
				'allow', 'actions' => array('REST.GET', 'REST.PUT', 'REST.POST', 'REST.DELETE'),
				'users' => array('@'),
			),
			array(
				'allow',  // allow all users to perform 'index' and 'view' actions
				'actions' => array('index', 'view', 'imprimircotizacion', 'addCarrito', 'deleteCarrito', 'emptyCarrito', 'echoCarrito', 'getCarrito', 'getInfoCotiz', 'test', 'fotosHotel'),
				'users' => array('@'),
			),
			array(
				'allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions' => array('create', 'update'),
				'users' => array('@'),
			),
			array(
				'allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions' => array('admin', 'delete'),
				'users' => array('admin'),
			),
			array(
				'deny',  // deny all users
				'users' => array('*'),
			),
		);
	}
	/*public function actionDestino()
	{
		
	}*/
	public function actionIndex()
	{
		$this->layout = '//layouts/ansonika_site';
		$this->render("index");
	}

	public function actionTest()
	{
		$ch = curl_init("https://photos.hotelbeds.com/giata/medium/33/330664/330664a_hb_ro_015.JPG");
		curl_setopt($ch, CURLOPT_NOBODY, true);
		curl_exec($ch);
		$response = curl_getinfo($ch, CURLINFO_HTTP_CODE);
		curl_close($ch);
		if ($response == 200) {
			echo "file exists";
		} else {
			echo $response;
		}
	}

	public function actionFotosHotel($id_hotel)
	{
		echo $_SERVER["DOCUMENT_ROOT"];
		/*$model_hoteles_fotos = HotelesFotos::model()->findAll("id_hotel = ". $id_hotel);
		echo CJSON::encode($model_hoteles_fotos);*/
	}

	public function actionGetInfoCotiz($request)
	{
		session_start();
		switch ($request) {
			case "hotel":
				$json = array();
				$json["front_form"] = $_SESSION["front_form"];
				$json["info_search"] = $_SESSION["info_search"];
				echo json_encode($json);
				break;

			case "activity":
				echo json_encode($_SESSION["searchAct"]);
				break;

			case "tour":
				echo json_encode($_SESSION["search_tour"]);
				break;
		}
	}

	public function actionGetCarrito()
	{
		session_start();
		if (empty($_SESSION['carrito'])) {
			$_SESSION['carrito'] = array();
		}
		echo json_encode($_SESSION['carrito']);
	}

	public function actionAddCarrito()
	{
		session_start();
		if (empty($_SESSION['carrito'])) {
			$_SESSION['carrito'] = array();
		}

		$request = json_decode($_POST["info"], true);
		/*print_r($_POST["info"]);
		exit;*/
		if ($request["tipo"] == "reserva") {
			$request["info_search"] = $_SESSION["info_search"];
		} else {
			if ($request["tipo"] == "activity") {
				$request["info_search"] = $_SESSION["searchAct"];
			} else {
				$request["info_search"] = $_SESSION["search_tour"];
			}
		}
		array_push($_SESSION['carrito'], $request);
		echo json_encode($_SESSION['carrito']);
	}

	public function actionDeleteCarrito()
	{
		session_start();
		array_splice($_SESSION['carrito'], $_POST["index"], 1);
		//unset($_SESSION['carrito'][$_POST["index"]]);
	}

	public function actionEmptyCarrito()
	{
		session_start();
		$_SESSION['carrito'] = array();
	}

	public function actionEchoCarrito()
	{
		session_start();
		//echo json_encode($_SESSION);
		echo json_encode($_SESSION["carrito"]);
		/*foreach ($_SESSION['carrito'] as $key => $value) {
			echo json_encode($value["item"][$value["item"]["idHotel"]]["Habitaciones"][$value["hab"]]["Planes"][$value["plan_tarifa"]]["plan"]);
		}*/
	}

	public function actionImprimircotizacion($fotos = false, $observacion = false)
	{
		session_start();
		$nota = Politica::model()->findByPk(3);
		$html = $this->renderPartial('cotizacion', array(
			'model' => $_SESSION["carrito"],
			'nota' => $nota->descripcion,
			'fotos' => $fotos,
			'observacion' => $observacion
		), true);
		$pdf = new MYPDF();
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor(Yii::app()->name);
		$pdf->SetTitle('Cotizacion');
		$pdf->SetSubject('Cotizacion');
		$pdf->SetHeaderData('', 0, "Report", '');
		$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);
		$pdf->setHeaderFont(array('helvetica', '', 8));
		$pdf->setFooterFont(array('helvetica', '', 6));
		$pdf->SetMargins(15, 35, 15);
		$pdf->SetHeaderMargin(25);
		$pdf->SetFooterMargin(10);
		$pdf->SetAutoPageBreak(TRUE, 20);
		$pdf->SetFont('dejavusans', '', 7);
		$pdf->AddPage();
		$pdf->writeHTML($html, true, false, true, false, '');
		$pdf->LastPage();
		$pdf->Output("Cotizacion_001.pdf", "I");
	}
}

class MYPDF extends TCPDF
{
	//Page header
	public function Header()
	{
		// get the current page break margin
		$bMargin = $this->getBreakMargin();
		// get current auto-page-break mode
		$auto_page_break = $this->AutoPageBreak;
		// disable auto-page-break
		$this->SetAutoPageBreak(false, 0);
		// set bacground image
		$img_file = $_SERVER['DOCUMENT_ROOT'] . '' . Yii::app()->baseUrl . '/images/pakal.jpg';
		$this->Image($img_file, 60, 50, 95, 135, '', '', '', false, 300, '', false, false, 0);
		// restore auto-page-break status
		$this->SetAutoPageBreak($auto_page_break, $bMargin);
		// set the starting point for the page content
		$this->setPageMark();
		// Logo
		$agencia = Agencias::model()->findByPk($_SESSION["agenciaUsuario"]);
		$estado = Estadosmex::model()->findByPk($agencia->id_estado_agencia);
		$pais = Pais::model()->findByPk($agencia->id_pais_agencia);
		$image_file = $_SERVER['DOCUMENT_ROOT'] . '/imagenes/' . $agencia->foto;
		if (!empty($agencia->foto) && is_readable($image_file)) {
			$this->Image($image_file, 20, 8, '', 15, '', '', 'T', false, 300, '', false, false, 0, false, false, false);
		}
		$this->Ln(4);
		$this->writeHTMLCell($w = 50, $h = 20, 120, 8, $agencia->nombre_agencia . '<br>
							Calle ' . $agencia->calle_agencia . ' No. ' . $agencia->num_exterior_agencia . ' Colonia ' . $agencia->id_colonia_agencia . '<br>
							' . $agencia->id_ciudad_agencia . ', ' . $estado->nombreestado . ' ' . $pais->nombre_pais . '<br>
							Tel. ' . $agencia->tel_agencia, $border = 0, $ln = 0, $fill = 0, $reseth = true, $align = '', $autopadding = true);
		// Set font
		$this->SetFont('helvetica', 'B', 12);
		// Title
		$this->Ln(22);
		//$this->Cell(0, 15, 'Cotización Generada por Sistema de Reservaciones de RutaMayaTravel al '.date('d/m/Y').' *', 0, false, 'C', 0, '', 0, false, 'M', 'M');
		$this->Cell(0, 15, 'Cotización Generada al ' . date('d/m/Y') . ' *', 0, false, 'C', 0, '', 0, false, 'M', 'M');
		$this->Line(15, 33, 195, 33);
	}
}
