<?php

class BloqueosRestController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column1';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
			array(
                'ext.starship.RestfullYii.filters.ERestFilter + 
                REST.GET, REST.PUT, REST.POST, REST.DELETE'
            ),
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow', 'actions'=>array('REST.GET', 'REST.PUT', 'REST.POST', 'REST.DELETE'),
				'users'=>array('@'),
			),
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('@'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update','GeneratePdf','GenerateExcel'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	public function actions()
	{
        return array('REST.'=>'ext.starship.RestfullYii.actions.ERestActionProvider',);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new BloqueosRest;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['BloqueosRest']))
		{
			$model->attributes=$_POST['BloqueosRest'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id_bloqueo));
		}

		$this->render('create',array(
			'model'=>$model,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['BloqueosRest']))
		{
			$model->attributes=$_POST['BloqueosRest'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id_bloqueo));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		if(Yii::app()->request->isPostRequest)
		{
			// we only allow deletion via POST request
			$this->loadModel($id)->delete();

			// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
			if(!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
		}
		else
			throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
            $session=new CHttpSession;
            $session->open();		
            $criteria = new CDbCriteria();            

                $model=new BloqueosRest('search');
                $model->unsetAttributes();  // clear any default values

                if(isset($_GET['BloqueosRest']))
		{
                        $model->attributes=$_GET['BloqueosRest'];
			
			
                   	
                       if (!empty($model->id_bloqueo)) $criteria->addCondition("id_bloqueo = '".$model->id_bloqueo."'");
                     
                    	
                       if (!empty($model->titulo)) $criteria->addCondition("titulo = '".$model->titulo."'");
                     
                    	
                       if (!empty($model->id_hotel)) $criteria->addCondition("id_hotel = '".$model->id_hotel."'");
                     
                    	
                       if (!empty($model->tipo)) $criteria->addCondition("tipo = '".$model->tipo."'");
                     
                    	
                       if (!empty($model->id_agencia)) $criteria->addCondition("id_agencia = '".$model->id_agencia."'");
                     
                    	
                       if (!empty($model->comision)) $criteria->addCondition("comision = '".$model->comision."'");
                     
                    	
                       if (!empty($model->id_paquete)) $criteria->addCondition("id_paquete = '".$model->id_paquete."'");
                     
                    	
                       if (!empty($model->novios)) $criteria->addCondition("novios = '".$model->novios."'");
                     
                    	
                       if (!empty($model->fecha_inicio)) $criteria->addCondition("fecha_inicio = '".$model->fecha_inicio."'");
                     
                    	
                       if (!empty($model->fecha_final)) $criteria->addCondition("fecha_final = '".$model->fecha_final."'");
                     
                    	
                       if (!empty($model->numero_habitaciones)) $criteria->addCondition("numero_habitaciones = '".$model->numero_habitaciones."'");
                     
                    	
                       if (!empty($model->id_tipo_plan)) $criteria->addCondition("id_tipo_plan = '".$model->id_tipo_plan."'");
                     
                    	
                       if (!empty($model->id_tipo_habitacion)) $criteria->addCondition("id_tipo_habitacion = '".$model->id_tipo_habitacion."'");
                     
                    	
                       if (!empty($model->id_tarifa)) $criteria->addCondition("id_tarifa = '".$model->id_tarifa."'");
                     
                    	
                       if (!empty($model->tiempo_limite)) $criteria->addCondition("tiempo_limite = '".$model->tiempo_limite."'");
                     
                    	
                       if (!empty($model->id_contrato)) $criteria->addCondition("id_contrato = '".$model->id_contrato."'");
                     
                    	
                       if (!empty($model->fecha_creacion)) $criteria->addCondition("fecha_creacion = '".$model->fecha_creacion."'");
                     
                    	
                       if (!empty($model->id_usuario)) $criteria->addCondition("id_usuario = '".$model->id_usuario."'");
                     
                    	
                       if (!empty($model->observaciones)) $criteria->addCondition("observaciones = '".$model->observaciones."'");
                     
                    	
                       if (!empty($model->observaciones2)) $criteria->addCondition("observaciones2 = '".$model->observaciones2."'");
                     
                    	
                       if (!empty($model->estatus)) $criteria->addCondition("estatus = '".$model->estatus."'");
                     
                    	
                       if (!empty($model->visibilidad)) $criteria->addCondition("visibilidad = '".$model->visibilidad."'");
                     
                    	
                       if (!empty($model->es_promo)) $criteria->addCondition("es_promo = '".$model->es_promo."'");
                     
                    			
                    $session['BloqueosRest_records']=BloqueosRest::model()->findAll($criteria); 
		}
       

                $this->render('index',array(
			'model'=>$model,
		));

	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new BloqueosRest('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['BloqueosRest']))
			$model->attributes=$_GET['BloqueosRest'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model=BloqueosRest::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='bloqueos-rest-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
        public function actionGenerateExcel()
	{
            $session=new CHttpSession;
            $session->open();		
            
             if(isset($session['BloqueosRest_records']))
               {
                $model=$session['BloqueosRest_records'];
               }
               else
                 $model = BloqueosRest::model()->findAll();

		
		Yii::app()->request->sendFile(date('YmdHis').'.xls',
			$this->renderPartial('excelReport', array(
				'model'=>$model
			), true)
		);
	}
        public function actionGeneratePdf() 
	{
           $session=new CHttpSession;
           $session->open();
		Yii::import('application.extensions.bootstrap.gii.*');
		require_once('bootstrap/tcpdf/tcpdf.php');
		require_once('bootstrap/tcpdf/config/lang/eng.php');

             if(isset($session['BloqueosRest_records']))
               {
                $model=$session['BloqueosRest_records'];
               }
               else
                 $model = BloqueosRest::model()->findAll();



		$html = $this->renderPartial('expenseGridtoReport', array(
			'model'=>$model
		), true);
		
		//die($html);
		
		$pdf = new TCPDF();
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor(Yii::app()->name);
		$pdf->SetTitle('BloqueosRest Report');
		$pdf->SetSubject('BloqueosRest Report');
		//$pdf->SetKeywords('example, text, report');
		$pdf->SetHeaderData('', 0, "Report", '');
		$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, "Example Report by ".Yii::app()->name, "");
		$pdf->setHeaderFont(Array('helvetica', '', 8));
		$pdf->setFooterFont(Array('helvetica', '', 6));
		$pdf->SetMargins(15, 18, 15);
		$pdf->SetHeaderMargin(5);
		$pdf->SetFooterMargin(10);
		$pdf->SetAutoPageBreak(TRUE, 0);
		$pdf->SetFont('dejavusans', '', 7);
		$pdf->AddPage();
		$pdf->writeHTML($html, true, false, true, false, '');
		$pdf->LastPage();
		$pdf->Output("BloqueosRest_002.pdf", "I");
	}
}
