<?php
 $usuario=Profiles::model()->findByPk(Yii::app()->user->id); 
 $tipoUsuario=$usuario->tipo;
 $_SESSION["tipoUsuario"]=$tipoUsuario;
 $uss=Usuarios::model()->findByPk(Yii::app()->user->id);
 $_SESSION["agenciaUsuario"]=$uss->id_agencia;
 $agencia=Agencias::model()->findByPk($uss->id_agencia);
Yii::import('application.extensions.phpmailer.JPhpMailer');
class BloqueosController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column1';
	public $baseHab = array(1=>'SGL',2=>'DBL',3=>'TPL',4=>'CPL');
	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}
	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		$rules = AuthFuncion::model()->findAll('controlador="'.Yii::app()->controller->id.'"');
		$array = array();
		foreach($rules as $row){
			$rule = array('allow',
						'actions'=>array($row->funcion),
						'roles'=>array($row->operacion),
					);
			array_push($array,$rule);
		}
		array_push($array,
			array('allow',
				'actions'=>array('getLista','getBloqueo'),
				'users'=>array('*'),
			),
			array('allow',
				'actions'=>array('Buscarhabitacion','Buscartarifa','Buscarcontrato','Buscarpaquete',"tablaProductoHab", 'comision','Cambiarcomision','NotasCreditoBloqueos', 'reservacionBloqueos'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('Admon','Sistemas','mercichan@rutamayatr'),
			),
			array('allow',
				'actions'=>array('Validarhabitaciones','movil'),
				'users'=>array('*'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			)
		);
		return $array;
	}
	private function noches($fecha_inicio,$fecha_final)
	{
		/*$startTimeStamp = strtotime($fecha_inicio);
		$endTimeStamp = strtotime($fecha_final);
		$timeDiff = abs($endTimeStamp - $startTimeStamp);
		$numberDays = ceil($timeDiff/86400);
		$noches = intval($numberDays);*/
		$datetime1 = new DateTime($fecha_inicio);
		$datetime2 = new DateTime($fecha_final);
		$interval = $datetime1->diff($datetime2);
		$noches= $interval->format('%a');
		return $noches;
	}
	public function verificaClave($clave)
	{
		$clave = Claves::model()->find('clave="'.$clave.'"');
		if(!empty($clave)){
			return $clave;
		}else{
			return NULL;
		}
	}
	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionReservacionBloqueos()
	{
		$id_bloqueo=$_POST['id_bloqueo'];
		$id_agencia=$_POST['id_agencia'];
		$hab=implode(',',$_POST['hab']);
		$roominglist=Roominglist::model()->findAll('id_bloqueo='.$id_bloqueo.' and habitacion IN('.$hab.')');
		//echo "<textarea>".CJSON::encode($roominglist)."</textarea>";
		$reservaBancoControl= Yii::app()->createController('reservaBanco')[0];
		$reservado=array();
		$countMenor=0;
		$nameMenor="";
		$ninio=array();	
		$reservasArray=array();
		$error=array();
		$reservAux=array();
		foreach ($roominglist as $room => $rooming) {
			$model= new Reservacion;
			if ($rooming->nombre) {
				$nombre=explode('/',stripslashes($rooming->nombre));
				$count=count($nombre);
				$reservAux=array(
								'Reservacion'=>array(
									'Reservacion'=>array(
									  "id_hotel"=>$rooming->idBloqueo->id_hotel,
									  "id_bloqueo"=>$id_bloqueo,
								      "id_agente"=> Yii::app()->user->id,
								      "id_agencia"=>$rooming->id_agencia,
								      "id_usuario"=>Yii::app()->user->id,
								      "tel_cliente"=>"",
								      "estatus"=>"",
								      "log"=>"",
								      "subtotal"=>"0",
								      "comision"=>"0",
								      "iva"=>"0",
								      "id_tipo_plan"=>$rooming->idBloqueo->id_tipo_plan,
								      "num_habitaciones"=>"1",
								      "fecha_inicial"=>$rooming->fecha_inicio,
								      "num_noches"=>$rooming->noches,
								      "fecha_final"=>$rooming->fecha_final,
								      "observaciones"=>$rooming->observaciones,
								      "total"=>$rooming->importe,
								      "total_tc"=>$rooming->importe,
								      "id_tarifa"=>$rooming->idBloqueo->id_tarifa,
								      "code"=>"",
								      "factura"=>"",
								      "libera_cupon"=>"0",
								      "comision_bancaria"=>"0.00",
								      "saldo"=>"0",
								      "porc_com_agencia"=>"0.00"
									),
								    'Habitacion_1'=>array(
								      'id_tipo_habitacion'=>$rooming->idBloqueo->id_tipo_habitacion,
								      'id_base_habitacion'=>$rooming->id_base_habitacion,
								      'num_adultos'=>$count,							      
								    ),
								    'num_hab'=>$rooming->habitacion,
								    'referencia'=>"",
								    'carrito'=>0,
								    'condiciones'=>"",
								    'tipo_pago'=>"",
								    'tarifaCliente'=>"",
								    'comisionPago'=>""
								),
								'Datos'=>array(
									'rateKey'=>"",		   
							  	 ),
								 'carrito'=>array(),
								 'TotalCotiz'=>array(),
								 'ecomerce'=>array()
							);
					$reservAux['Reservacion']['Habitacion_1']['num_ninios']=0;
				if ($rooming->menor) {
					$nombreMenor=explode('/',$rooming->menor);
					$edadMenor=explode(',',$rooming->edad);
					$countMenor=count($nombreMenor);
					for ($i=0; $i < $countMenor ; $i++) { 				
						$reservAux['Reservacion']['Ninio_'.($i+1).'_1']['nombre']=$nombreMenor[$i];
						$reservAux['Reservacion']['Ninio_'.($i+1).'_1']['edad']=$edadMenor[$i];
					}
						$reservAux['Reservacion']['Habitacion_1']['num_ninios']=$countMenor;
				}
				for ($i=0; $i < $count ; $i++) { 
					$name=array();
					for ($j=0; $j < 2 ; $j++) {
						//$nombre=trim($nombre[$j]); 
						array_push($name,explode(' ', trim($nombre[$j])));											
					}
					$reservAux['Reservacion']['Adulto_'.($i+1).'_1']['nombre']=$name[$i][1];				
					$reservAux['Reservacion']['Adulto_'.($i+1).'_1']['apellido']=$name[$i][0];		
					$reservAux['Reservacion']['Reservacion']['nombre_cliente']=$name[0][1];	
					$reservAux['Reservacion']['Reservacion']['apellido_cliente']=$name[0][0];				
				}
				///array_push($reserva, $reservAux);
				$vtarifa= $this->validaTarifa($reservAux['Reservacion']);
				if ($vtarifa!=true) {
					array_push($error, array('hab'=>$rooming->habitacion, 'motivo'=>$vtarifa));
				}else{
					$reservaBloqueo=$reservaBancoControl->guardarReservacionBanco($model, $reservAux['Reservacion'], $reservAux['Datos'], $reservAux['carrito'], $reservAux['TotalCotiz'], $reservAux['ecomerce']);
				  if ($reservaBloqueo) {					
					$this->actualizarHabitacion($reservaBloqueo, $id_bloqueo, $rooming->habitacion, $rooming->id_agencia );
				  }
					array_push($reservado, array('hab'=>$rooming->habitacion, 'motivo'=>'aceptado'));
				}
			}else{
				array_push($error, array('hab'=>$rooming->habitacion, 'motivo'=>'Sin Pasajeros'));
			}
			//array_push($reservasArray, $reservaBloqueo );
		}
		echo $data=CJSON::encode(array('error'=>$error, 'reservado'=>$reservado));
		//echo "<textarea>".CJSON::encode($reserva)."</textarea>";
		//echo "<textarea>".CJSON::encode($error)."</textarea>";
		/*echo "<textarea>".CJSON::encode($name)."</textarea>";
		/*
			echo $model = $guardarReservacionBanco->guardarReservacionBanco($model, $reserva['Reservacion'], $reservAux['Datos'], $reservAux['carrito'], $reservAux['TotalCotiz'], $reservAux['ecomerce']);
		*/
			/* 'total'=>$roominglist,
					    'total_neto'=>$roominglist,
					    'id_hotel'=>$roominglist,
					    'hotel'=>$roominglist,
					    'id_plan'=>$roominglist,
					    'fecha_limite'=>$roominglist,
					    'fecha_limite_h'=>$roominglist,
					    'fecha_inicio'=>$roominglist,
					    'fecha_final'=>$roominglist,
					    'noches'=>$roominglist,
					    'politicas_cancelacion'=>"",
					    'front_form'=>array(
					      'habs'=>$roominglist,
					      'solo_adultos'=>"",
					      'habitacion_1'=>array(
					        'adultos'=>$roominglist,
					        'num_ninios'=>$roominglist,
					        'adulto_1'=>$roominglist,
					        'adulto_apellido_1'=>$roominglist,
					        'adulto_2'=>$roominglist,
					        'adulto_apellido_2'=>$roominglist
					      ),
					      'fecha_ini'=>$roominglist,
					      'fecha_fin'=>$roominglist,
					      'destino'=>$roominglist,
					      'tipoPrecio'=>$roominglist,
					      'tipoPlan'=>$roominglist,
					      'id_tipoPlan'=>$roominglist,
					      'categoria'=>$roominglist,
					      'agenciaUsuario'=>$roominglist,
					      'agencia'=>$roominglist
					    ),
					    'id_agencia'=>$roominglist,
					    'id_agente'=>$roominglist,
					    'nombre_cliente'=>$roominglist,
					    'apellido_cliente'=>$roominglist,
					    'tel_cliente'=>$roominglist*/
	}

	public function actionCancelacionBloqueos() {
		$idBloqueo=$_POST['id_bloqueo'];
		$idAgencia=$_POST['id_agencias'];
		$habitaciones=$_POST['hab'];
		$reservas=array();
		foreach ($habitaciones as $key => $hab) {
			$reservas[$key]=$this->actualizarHabitacion('', $idBloqueo, $hab, $idAgencia);

		}
		$id_reservas=implode(',',$idReservas);
		$reservas= Reservacion::model()->findAll('IN id_reservacion('.$id_reservas.')');
		foreach ($reservas as $key => $val) {
			$val->estatus="C";
			if($val->save())
				array_push($reservado, array('hab'=>$hab, 'motivo'=>'aceptado'));
			else
				array_push($error, array('hab'=>$rooming->habitacion, 'motivo'=>json_encode($val->getErrors())));
		}

		echo $data=CJSON::encode(array('error'=>$error, 'reservado'=>$reservado));

	}

	public function actualizarHabitacion($id_reservacion, $id_bloqueo, $hab, $id_agencia) {
		$roomlistRow = Roominglist::model()->find('id_bloqueo='.$id_bloqueo.' and habitacion='.$hab);
		$roomlistRow->id_reservacion = $id_reservacion;
		$roomlistRow->id_agencia = $id_agencia;
		$roomlistRow->save();
	}

	public function validaTarifa($reserva) {
		$reservaControl=Yii::app()->createController('reservacion')[0];
		$model=new Reservacion;
		$model->attributes=$reserva['Reservacion'];
		$datos=array(); $menores=array();
		$error=NULL; $ocultaT = array();
		$Total = array();
		$maxT = 0;
		$hora = "and curtime() between hora_inicio and hora_final";
		$fecha_promo = "and current_date between fecha_promo_inicio and fecha_promo";
		$early_booking = "and (early_booking is null or DATEDIFF('".implode("-", array_reverse(explode("-", $model->fecha_inicial)))."',current_date) <= early_booking)";
		$release = "and (t.release is null or DATEDIFF('".implode("-", array_reverse(explode("-", $model->fecha_inicial)))."',current_date) >= t.release)";
		if($_SESSION["agenciaUsuario"] != 9){
			$tarifaAgencias = 'and not exists(select NULL from tbl_tarifa_agencia tarifaAgencias where tarifaAgencias.id_tarifa=t.id_tarifa and tarifaAgencias.id_agencia!='.$_SESSION["agenciaUsuario"].')';
			$agenciaUsuario = Agencias::model()->findByPk($_SESSION["agenciaUsuario"]);
			$tarifaEstados = 'and exists(select NULL from tbl_tarifa_estados tarifaEstados where tarifaEstados.id_tarifa=t.id_tarifa and tarifaEstados.id_estado='.$agenciaUsuario->id_estado_agencia.')';
		}
		for($dia=0;$dia<$model->num_noches;$dia++) {
			$fecha = date("Y-m-d", strtotime(implode("-", array_reverse(explode("-", $model->fecha_inicial))))+$dia*24*60*60);
			$fechadia = strtotime(implode("-", array_reverse(explode("-", $model->fecha_inicial))))+$dia*24*60*60;
			if($model->id_bloqueo != "")
			{
				$bloqueo = Bloqueos::model()->findByPk($model->id_bloqueo);
				$tipo_precio = $bloqueo->idTarifa->precio;
				$tarifa = Tarifa::model()->with('tarifaDiasvalidos')->findAll(array('condition'=>'t.id_tarifa='.$bloqueo->id_tarifa.' and id_tipo_plan='.$model->id_tipo_plan.' '.$fecha_promo.' '.$hora.' and precio="'.$tipo_precio.'" and estatus=1 and dia='.date("N",$fechadia).' and "'.$fecha.'" between t.fecha_inicial and t.fecha_final '.$tarifaAgencias.' '.$tarifaEstados.' and not exists(select NULL from tbl_fechas_bloqueadas tarifaFechasbloqueadas where "'.$fecha.'" between tarifaFechasbloqueadas.fecha_inicio and tarifaFechasbloqueadas.fecha_final and tarifaFechasbloqueadas.id_tipo_habitacion is null and tarifaFechasbloqueadas.id_tarifa=t.id_tarifa)', 'order'=>'precio'));
			}
			if($maxT > count($tarifa))
			{
				$tarifaComb = Tarifa::model()->with('tarifaDiasvalidos')->findAll(array('condition'=>'id_hotel='.$model->id_hotel.' and id_tipo_plan='.$model->id_tipo_plan.' '.$fecha_promo.' '.$hora.' '.$early_booking.' '.$release.' and precio="NORMAL" and promocontigua=1 and estatus=1 and dia='.date("N",$fechadia).' and "'.$fecha.'" between t.fecha_inicial and t.fecha_final '.$tarifaAgencias.' '.$tarifaEstados.' and not exists(select NULL from tbl_fechas_bloqueadas tarifaFechasbloqueadas where "'.$fecha.'" between tarifaFechasbloqueadas.fecha_inicio and tarifaFechasbloqueadas.fecha_final and tarifaFechasbloqueadas.id_tipo_habitacion is null and tarifaFechasbloqueadas.id_tarifa=t.id_tarifa)', 'limit'=>1));
				if(!empty($tarifaComb)){
					$tarifa = (object) array_merge((array) $tarifa, (array) $tarifaComb);
					$combinada = true;
					$combT = $maxT - 1;
				}else{
					$tarifa = (object) array_merge((array) $tarifa, (array) $tarifa);
					$combinada = true;
					$combT = $maxT - 1;
				}
			}
			else if($maxT < count($tarifa)){
				$datos[$dia-1][$maxT] = $datos[$dia-1][$maxT-1];
				if(!empty($menores[$dia-1][$maxT-1]))$menores[$dia-1][$maxT] = $menores[$dia-1][$maxT-1];
				$Total[$maxT]['total'] += $Total[$maxT-1]['total'];
				$Total[$maxT]['total_tc'] += $Total[$maxT-1]['total_tc'];
				/*$hide = count($tarifa) - $maxT;
				if($hide==1){
					if(count($tarifa)==3)$ocultaT[2] = true;
					if(count($tarifa)==2)$ocultaT[1] = true;
				}else if($hide == 2){
					if(count($tarifa)==3){
						$ocultaT[2] = true;
						$ocultaT[1] = true;
					}
					if(count($tarifa)==4){
						$ocultaT[2] = true;
						$ocultaT[3] = true;
					}
				}	*/			
			}
			if(empty($tarifa))
			{
				$result = "Actualmente este hotel no dispone de tarifas para la fecha ".$fecha.". Le sugerimos modificar e intentar de nuevo, o le invitamos a contactar a nuestros ejecutivos vía telefónica o chat para la generación de una cotización.";
			}else{
				$result=true;
			}
			$t = 0;
			foreach($tarifa as $row)
			{
				$costoTotal = 0; $costoTotalTC = 0;
				$habs = 1;
				for($i=1;$habs<=$model->num_habitaciones;$i++)
				{
					if(($reserva["Habitacion_".$i.""]) != NULL)
					{
						$habBloqueada = FechasBloqueadas::model()->find('id_tarifa='.$row->id_tarifa.' and id_tipo_habitacion='.$reserva["Habitacion_".$i.""]["id_tipo_habitacion"].' and "'.$fecha.'" between fecha_inicio and fecha_final');
						if(empty($habBloqueada)){							
							$tarifaDesglose = TarifaDesglose::model()->find('id_tarifa='.$row->id_tarifa.' and id_tipo_habitacion='.$reserva["Habitacion_".$i.""]["id_tipo_habitacion"].' and id_base_habitacion='.$reserva["Habitacion_".$i.""]["id_base_habitacion"].' and '.$reserva["Habitacion_".$i.""]["num_ninios"].' <= max_menores and estatus=1');
						}
						if(empty($tarifaDesglose)){
							if(count($tarifa) > 1 && count($ocultaT) < count($tarifa)){
								$ocultaT[$t] = true;
							}else{
								$result = "No se encontró una tarifa de ".$reserva["Habitacion_".$i.""]["id_base_habitacion"]." adultos que acepte un máximo numero de menores de ".$reserva["Habitacion_".$i.""]["num_ninios"]." para la habitación ".$i.". O la habitación está bloqueada para la fecha ".$fecha;
							}
						}
						$nocheGratis = NochesGratis::model()->find('id_tarifa='.$row->id_tarifa.' and (id_tipo_habitacion is null or id_tipo_habitacion='.$reserva["Habitacion_".$i.""]["id_tipo_habitacion"].')');
						$suplemento = 0;
						if(!empty($nocheGratis) && (($dia+1) % $nocheGratis->noche == 0)){
							if(($dia+1) > $nocheGratis->noche && $nocheGratis->acumulable != 1){
								$nocheGratis = false;
							}else{
								$tarifaDesglose->precio_normal = 0;
								$nocheGratis = true;
							}
						}
						$suplemento = $reservaControl->Sumarsuplemento($row->id_tarifa,$fecha,$tarifaDesglose->id_base_habitacion,'A',NULL);
						$costoAdultos = $tarifaDesglose->precio_normal + $suplemento;
						$costoAdultosTC = $row->tipoCambio($tarifaDesglose->precio_normal) + $row->tipoCambio($suplemento);
						if($suplemento > 0){
							$datos[$dia][$t][$i]['adultos'] = number_format($row->tipoCambio($tarifaDesglose->precio_normal),'2')." + ".number_format($row->tipoCambio($suplemento),'2')." SUP.";
						}else{
							$datos[$dia][$t][$i]['adultos'] = number_format($costoAdultosTC,'2');
						}
						$costoMenores = 0; $costoMenoresTC = 0;
						$menorgratis = 0; $niniopaga = 1;
						$precompraMenor = "fecha_inicio_precompra is null or current_date between fecha_inicio_precompra and fecha_final_precompra";
						for($n=1;$n<=$_POST["Habitacion_".$i.""]["num_ninios"];$n++){ //Ordenar edades menores mayor a menor
							if($_POST["Ninio_".$n."_".$i.""]["edad"] < $_POST["Ninio_".($n+1)."_".$i.""]["edad"]){
								$aux = $_POST["Ninio_".$n."_".$i.""]["edad"];
								$_POST["Ninio_".$n."_".$i.""]["edad"] = $_POST["Ninio_".($n+1)."_".$i.""]["edad"];
								$_POST["Ninio_".($n+1)."_".$i.""]["edad"] = $aux; 
								$n=0;
							}
						}
						for($n=1;$n<=$_POST["Habitacion_".$i.""]["num_ninios"];$n++)
						{
							$tarifaMenor=DesgloseMenores::model()->find("id_tarifa=".$row->id_tarifa." and id_tipo_habitacion=".$_POST["Habitacion_".$i.""]["id_tipo_habitacion"]." and ".$_POST["Ninio_".$n."_".$i.""]["edad"]." <= edad_max_menor and num_evaluar=".$niniopaga." and es_junior=0 and(".$precompraMenor.") and(fecha_inicio is null or '".$fecha."' between fecha_inicio and fecha_final) ORDER BY precio ASC");
							if(empty($tarifaMenor)){
								$tarifaMenor=DesgloseMenores::model()->find("id_tarifa=".$row->id_tarifa." and id_tipo_habitacion=".$_POST["Habitacion_".$i.""]["id_tipo_habitacion"]." and ".$_POST["Ninio_".$n."_".$i.""]["edad"]." between edad_min_menor and edad_max_menor and es_junior=1 and(".$precompraMenor.") and(fecha_inicio is null or '".$fecha."' between fecha_inicio and fecha_final) ORDER BY precio ASC");
								if(empty($tarifaMenor)){
									if(count($tarifa) > 1 && count($ocultaT) < count($tarifa)){
										$ocultaT[$t] = true;
									}else{
										$result = "El menor con edad ".$_POST["Ninio_".$n."_".$i.""]["edad"]." de la habitación ".$i." no tiene una tarifa definida para la fecha ".$fecha;
									}
								}
							}
							if($tarifaMenor->es_junior != 1)$niniopaga++;
							if($_POST["Ninio_".$n."_".$i.""]["edad"] < $tarifaMenor->edad_min_menor || $nocheGratis == true)$tarifaMenor->precio = 0;
							$suplemento = $reservaControl->Sumarsuplemento($row->id_tarifa,$fecha,0,'N',$_POST["Ninio_".$n."_".$i.""]["edad"]);
							$precioMenor = $tarifaMenor->precio + $suplemento;
							$costoMenores += $precioMenor;
							$precioMenorTC = $row->tipoCambio($tarifaMenor->precio) + $row->tipoCambio($suplemento);
							$costoMenoresTC += $precioMenorTC;
							$menores[$dia][$t][$i] .= "Menor ".$n.": $ ".number_format($precioMenorTC,'2','.',',')." / ";
						}
						$datos[$dia][$t][$i]['menores'] = number_format($costoMenoresTC,'2','.',',');
						$costoHabitacion = $costoAdultos + $costoMenores;
						$costoTotal += $costoHabitacion;
						$costoHabitacionTC = $costoAdultosTC + $costoMenoresTC;
						$costoTotalTC += $costoHabitacionTC;
						$datos[$dia][$t][$i]['fecha'] = implode("-", array_reverse(explode("-", $fecha)));
						$datos[$dia][$t][$i]['total'] = number_format($costoHabitacionTC,'2','.',',');
						$minNoches = MinNoches::model()->find('id_tarifa='.$row->id_tarifa.' and id_tipo_habitacion='.$tarifaDesglose->id_tipo_habitacion.' and "'.$fecha.'" between fecha_inicio and fecha_final');
						if(!empty($minNoches) && $minNoches->minimo > $Total[$t]['min_noches']){
							$Total[$t]['min_noches'] = $minNoches->minimo;
						}else if($row->min_noches > $Total[$t]['min_noches']){
							$Total[$t]['min_noches'] = $row->min_noches;
						}
						$habs++;
					}
				}
				if($combinada == true && $Total[$t]['codigo'] != $row->codigo)
				{
					if(strpos($Total[$t]['nombre'], $row->nombre_tarifa) === FALSE){
						$Total[$t]['nombre'] .= " + ".$row->nombre_tarifa;
					}
					if($row->restricciones != ""){
						$Total[$t]['restricciones'] .= "<br><br>Otras Restricciones: ".$row->restricciones;
					}
					$Total[$t]['codigo'] = $row->codigo;
				}
				else{
					if(empty($Total[$t]['tarifa']))$Total[$t]['tarifa'] = $row->id_tarifa;
					$Total[$t]['nombre'] = $row->precio." ".$row->nombre_tarifa;
					if($row->restricciones != "" && "<p>".$row->restricciones."</p>" != $Total[$t]['restricciones'])
						$Total[$t]['restricciones'] .= "<p>".$row->restricciones."</p>";
					$Total[$t]['moneda'] = $row->mostrar_conversion == 0 ? $row->moneda:'MXN';
					$Total[$t]['codigo'] = $row->codigo;
				}
				$Total[$t]['total'] += $costoTotal;
				$Total[$t]['total_tc'] += $costoTotalTC;
				$t++;
				if($maxT < $t) $maxT = $t;
			}
		}
		return $result;
		/*echo CJSON::encode(array(
			'error'=>$error,
			'oculta'=>$ocultaT,
			'tarifas'=>$maxT,
			'noches'=>$model->num_noches,
			'habs'=>$model->num_habitaciones,
			'resul'=>$datos,
			'menores'=>$menores,
			'total'=>$Total
		));*/
	}

	public function actionView($id) {
		$model=$this->loadModel($id);
		$model->fecha_inicio = implode("-", array_reverse(explode("-", $model->fecha_inicio)));
		$model->fecha_final = implode("-", array_reverse(explode("-", $model->fecha_final)));
		$noches = $this->noches($model->fecha_inicio,$model->fecha_final);
		$id_paquete = $model->idPaquete->id_paquete;
		$paquete = PaquetesBoda::model()->findByPk($id_paquete);
		$reservas = Reservacion::model()->findAll('id_bloqueo='.$id);
		$notacredito = new NotaCredito;
		$notacredito->id_ref = $id;
		$notacredito->tipo_ref = "BLOQUEO";
		$notacredito->id_agencia = $model->id_agencia;
		if($_SESSION["tipoUsuario"] == "Agencia")
			$condAgencia = "and id_agencia=".$_SESSION["agenciaUsuario"];
		$notas = NotaCredito::model()->findAll('id_ref='.$id.' and tipo_ref="BLOQUEO" '.$condAgencia.' and estatus="A"');
		$credito = 0;
		foreach($notas as $row){
			$credito += $row->importe;
		}
		$session=new CHttpSession;
        $session->open();		
		$_SESSION['id_view']=$id;
		$this->render('view',array(
			'model'=>$model,'noches'=>$noches,'reservas'=>$reservas,'notacredito'=>$notacredito,'notas'=>$notas,'credito'=>$credito,'paquete'=>$paquete,
		));
	}
	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionComision() {
		if($_POST['idAgencia']) {
			$comisionAgencia = Agencias::model()->findByPk($_POST['idAgencia']);
			echo $comisionAgencia->porcentaje_comision;
		}
	}
	public function actionNotasCreditoBloqueos(){
		$model = Bloqueos::model()->findAll("tipo='BLOQUEO' and estatus=1");
		// $model = NotaCredito::model()->findAll('tipo_ref="BLOQUEO" and estatus="A"');
		$this->render('notasCreditoBloqueos',array(
				'model'=>$model,
			));
	}

	public function actionCreate() {
		$model=new Bloqueos;
		$model->id_usuario = Yii::app()->user->id;
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);
		if(isset($_POST['Bloqueos'])) {
			$model->attributes=$_POST['Bloqueos'];
			$model->fecha_inicio = implode("-", array_reverse(explode("-", $model->fecha_inicio)));
			$model->fecha_final = implode("-", array_reverse(explode("-", $model->fecha_final)));
			if($model->save()) {
				for($a=1;$a<=$model->numero_habitaciones;$a++) {
					$roominglist = new Roominglist;
					$roominglist->habitacion = $a;
					$roominglist->id_bloqueo = $model->id_bloqueo;
					$roominglist->fecha_inicio = $model->fecha_inicio;
					$roominglist->fecha_final = $model->fecha_final;
					$roominglist->noches = $this->noches($model->fecha_inicio,$model->fecha_final);
					$roominglist->estatus = "D";
					$roominglist->save();	
				}
				$operacion = Yii::app()->createController('operacionesLog');
				$operacion = $operacion[0];
				$operacion->Create($model->id_bloqueo,6);
				$notificar = Usuarios::model()->findAll('aviso LIKE "%b%"');
				foreach($notificar as $user){
					$notificacion = new Notificacion;
					$notificacion->id_item = $model->id_bloqueo;
					$notificacion->tipo = 4;
					$notificacion->id_users = $user->id_usuario;
					$notificacion->visto = 0;
					$notificacion->save();
				}
				$this->redirect(array('view','id'=>$model->id_bloqueo));
			}
		}
		if($_GET["bodas"] == 1){	
			$this->render('createBoda',array(
				'model'=>$model,
			));
		}else{
			$this->render('create',array(
				'model'=>$model,
			));
		}
	}
	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id) {
		$model=$this->loadModel($id);
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);
		if(isset($_POST['Bloqueos']))
		{
			if($_POST['Bloqueos']['numero_habitaciones'] < $model->numero_habitaciones){
				$_POST['Bloqueos']['numero_habitaciones'] = $model->numero_habitaciones;
			}
			$estatus = $model->estatus;
			$tiempoLimite = $model->tiempo_limite;
			$model->attributes=$_POST['Bloqueos'];
			$model->fecha_inicio = implode("-", array_reverse(explode("-", $model->fecha_inicio)));
			$model->fecha_final = implode("-", array_reverse(explode("-", $model->fecha_final)));
			if($estatus != $model->estatus){
				$clave = $this->verificaClave($_POST['clave']);
				if(empty($clave)){
					if($_GET["bodas"] == 1){
						$this->redirect(array('update','id'=>$model->id_bloqueo,'bodas'=>1,'error_clave'=>1));
					}else{
						$this->redirect(array('update','id'=>$model->id_bloqueo,'error_clave'=>1));
					}
				}
			}
			if($model->save())
			{
				$habitaciones = Roominglist::model()->findAll('id_bloqueo='.$model->id_bloqueo.' ORDER BY habitacion DESC');
				if($model->numero_habitaciones > count($habitaciones))
				{	
					$nuevas = $model->numero_habitaciones - count($habitaciones);
					$nuevo = $habitaciones[0]->habitacion+1;
					for($a=1;$a<=$nuevas;$a++) {
						$roominglist = new Roominglist;
						$roominglist->habitacion = $nuevo;
						$roominglist->id_bloqueo = $model->id_bloqueo;
						$roominglist->fecha_inicio = $model->fecha_inicio;
						$roominglist->fecha_final = $model->fecha_final;
						$roominglist->noches = $this->noches($model->fecha_inicio,$model->fecha_final);
						$roominglist->estatus = "D";
						$roominglist->save();
						$nuevo++;	
					}
				}
				$operacion = Yii::app()->createController('operacionesLog');
				$operacion = $operacion[0];
				$operacion->Create($model->id_bloqueo,7);
				if($tiempoLimite != $model->tiempo_limite){
					$habitaciones = Roominglist::model()->findAll(array('condition'=>'id_bloqueo='.$model->id_bloqueo.' and id_agencia is not null','group'=>'id_agencia','distinct'=>true));
					foreach($habitaciones as $hab){
						$this->emailAviso($hab);
					}
				}
				$this->redirect(array('view','id'=>$model->id_bloqueo));
			}
		}
		$model->fecha_inicio = implode("-", array_reverse(explode("-", $model->fecha_inicio)));
		$model->fecha_final = implode("-", array_reverse(explode("-", $model->fecha_final)));
		if($_GET["bodas"] == 1){	
			$this->render('updateBoda',array(
				'model'=>$model,
			));
		}else{
			$this->render('update',array(
				'model'=>$model,
			));
		}
	}
	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id) {
		if(Yii::app()->request->isPostRequest)
		{
			// we only allow deletion via POST request
			$this->loadModel($id)->delete();
			// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
			if(!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
		}
		else
			throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');
	}
	/**
	 * Lists all models.
	 */
	public function actionIndex() {
		$session=new CHttpSession;
		$session->open();		

		$criteria = new CDbCriteria();  
			if ($_GET['mega']==1)          
				$model=new MegaGrupos('search');
			else
				$model=new Bloqueos('search');
			$model->unsetAttributes();  // clear any default values
			$megaControl=Yii::app()->createController('megaGrupos')[0];
		if(isset($_POST['Bloqueos'])){
			   $session['Bloqueos']=$_POST['Bloqueos'];
		}
        if(isset($session['Bloqueos']))
		{
			  
			   if ($_GET['mega']==1) {
			   	 $criteria->with=array('megaGruposBloqueoses.idBloqueo','megaGruposBloqueoses.idBloqueo.idTarifa');
			   	 $criteria->condition='estatus=0';
			   }else{
			   		 $model->attributes=$session['Bloqueos'];
			   }
			   $criteria->with = 'idTarifa';
			   if (!empty($model->tipo)) $criteria->addCondition("tipo = '".$model->tipo."'");
			   if(!empty($model->fecha_inicio) && !empty($model->fecha_final)){
					$fecha_inicio = implode("-", array_reverse(explode("/", $model->fecha_inicio)));
					$fecha_final = implode("-", array_reverse(explode("/", $model->fecha_final)));
					$criteria->addBetweenCondition('fecha_inicio',$fecha_inicio,$fecha_final);
			   }
			   if (!empty($model->estatus)) $criteria->addCondition("t.estatus = ".$model->estatus."");
			   if (!empty($model->es_promo)) $criteria->addCondition("es_promo = ".$model->es_promo."");
			   if($_GET["history"] != 1) $criteria->addCondition('current_date<=fecha_inicio and t.estatus=1');
			   if($_GET["bodas"] == 1){
					$criteria->addCondition('precio="BODA"');
			   }else{
				    $criteria->addCondition('precio!="BODA"');
			   }
			$criteria->order = "fecha_inicio ASC";
			if($_GET['mega']==1)
			{	
			
				$session['Bloqueos_records']=$megaControl->megaArray();
				
				
			}
			else{
				$session['Bloqueos_records']=Bloqueos::model()->findAll($criteria);
			}

		}
		if($_GET['mega']==1)
			{	
				
				$session['Bloqueos_records']=$megaControl->megaArray();
				
			}
		if($_GET["bodas"] == 1){
			$this->render('bodas',array(
				'model'=>$model,
			));
		}else{
			$this->render('index',array(
				'model'=>$model,
			));
		}
	}
	public function actionApartadas() {
		if(isset($_GET['id_bloqueo'])){
			$idBloqueo = $_GET['id_bloqueo'];
			$model = Roominglist::model()->with('idBloqueo')->findAll(array('condition'=>'t.estatus="ND" and id_reservacion is null and t.id_bloqueo='.$idBloqueo.' and current_date<=idBloqueo.fecha_final and idBloqueo.estatus=1','order'=>'fecha_apartado DESC'));
		}else{
			$model = Roominglist::model()->with('idBloqueo')->findAll(array('condition'=>'t.estatus="ND" and id_reservacion is null and tipo="BLOQUEO" and current_date<=idBloqueo.fecha_final and idBloqueo.estatus=1','order'=>'fecha_apartado DESC'));
		}
		$this->render('apartadas',array('model'=>$model));
	}
	public function actionModificarapartado()
	{
		if(isset($_POST['opcion'])){
			switch($_POST['opcion']){
				case 0:
					$opcion = '+12 hours';
				break;
				case 1:
					$opcion = '+24 hours';
				break;
				case 2:
					$opcion = '+48 hours';
				break;
				case 3:
					$opcion = '+72 hours';
				break;
				case 4:
					$opcion = '-24 hours';
				break;
				case 5:
					$opcion = '-48 hours';
				break;
				case 6:
					$opcion = NULL;
				break;
				case 7:
					$opcion = 'now +24 hours';
				break;
			}
			$respuesta = array();
			foreach($_POST['habs'] as $row){
				$roominglist = Roominglist::model()->findByPk($row);
				if($opcion == NULL){
					$roominglist->fecha_apartado = NULL;
				}
				else if($_POST['opcion'] == 7){
					$roominglist->fecha_apartado = date('Y-m-d H:i:s',strtotime($opcion));
				}
				else{
					$roominglist->fecha_apartado = date('Y-m-d H:i:s',strtotime($roominglist->fecha_apartado." ".$opcion));
				}
				if($roominglist->save()){
					array_push($respuesta,
						array('hab'=>$row,'hora'=>$roominglist->fecha_apartado != NULL ? date('H:i:s',strtotime($roominglist->fecha_apartado)):NULL,
							'fecha'=>$roominglist->fecha_apartado != NULL ? date('d/m/Y',strtotime($roominglist->fecha_apartado)):NULL
						));
					$operacion=new OperacionesLog;
					$operacion->id_referencia=$row;
					$operacion->id_operacion_tipo=21;
					$operacion->descripcion="BLOQUEO ".$roominglist->id_bloqueo." Habitación ".$roominglist->habitacion;
					$operacion->id_usuario=Yii::app()->user->id;
					$operacion->save();
					if($roominglist->fecha_apartado != NULL)
						$this->emailAviso($roominglist);
				}
			}
			echo CJSON::encode($respuesta);
		}
	}
	public function actionBuscarhabitacion()
	{
		if($_POST['id_hotel'] != "")
		{
			$habitacion = TipoHabitaciones::model()->findAll('id_hotel='.$_POST['id_hotel'].' and estatus=1');
			echo CJSON::encode($habitacion);
		}
	}
	public function actionBuscartarifa()
	{
		if(isset($_POST['id_hotel'],$_POST['tipo_bloqueo']) && !empty($_POST['id_tipo_plan']))
		{
			$tarifa = Tarifa::model()->findAll('id_hotel='.$_POST['id_hotel'].' and precio="'.$_POST['tipo_bloqueo'].'" and id_tipo_plan='.$_POST['id_tipo_plan'].' and estatus=1 and current_date<=fecha_final');
		}
		echo CJSON::encode($tarifa);
	}
	public function actionBuscarcontrato()
	{
		if($_POST['id_hotel'] != "")
		{
			$contrato = Contratos::model()->findAll('id_hotel='.$_POST['id_hotel'].' and current_date<=fecha_final');
			echo CJSON::encode($contrato);
		}
	}
	public function actionBuscarpaquete()
	{
		if($_POST['id_hotel'] != "")
		{
			$paquete = PaquetesBoda::model()->findAll('id_hotel='.$_POST['id_hotel']);
			echo CJSON::encode($paquete);
		}
	}
	public function actionApartarhabitacion()
	{
		if(isset($_POST['id_agencia'])){
			$agencia = Agencias::model()->findByPk($_POST['id_agencia']);
			foreach($_POST['habs'] as $row)
			{
				$roominglist = Roominglist::model()->find('habitacion='.$row.' and id_bloqueo='.$_POST['id_bloqueo']);
				if(empty($roominglist))
				{					
					$roominglist = new Roominglist;
					$roominglist->habitacion = $row;
					$roominglist->id_bloqueo = $_POST['id_bloqueo'];
				}
				else if(!empty($roominglist->id_agencia)){
					throw new CHttpException(400,'La habitación '.$row.' ya está apartada. Por favor, seleccione otra habitación.');
				}
				//checar si ya fue apartada
				if($_SESSION['tipoUsuario'] == "Agencia"):
				$apartados = OperacionesLog::model()->findAll('id_operacion_tipo=1 and id_referencia='.$roominglist->id_roominglist.' ORDER BY fecha_log DESC LIMIT 2');
				if(count($apartados) > 0){
					$num_veces = 0;
					foreach($apartados as $log){
						$usuario = Usuarios::model()->findByPk($log->id_usuario);
						if($_POST['id_agencia'] == $usuario->id_agencia){
							$num_veces++;
						}
					}
					if($num_veces > 1 && $roominglist->idBloqueo->tiempo_limite > 24){
						$date1 = new DateTime($apartados[0]->fecha_log);
						$date2 = new DateTime('now');
						$diff = $date2->diff($date1);
						$hours = $diff->h;
						$hours = $hours + ($diff->days*24);
						if($hours < 48){
							throw new CHttpException(400,'La habitación ya fue apartada 2 veces seguidas por su agencia. Debe esperar 48 hrs. para volver a apartarla.');
						}
					}
					else if($num_veces == 1 && $roominglist->idBloqueo->tiempo_limite <= 24){
						throw new CHttpException(400,'Lo sentimos, su agencia no puede volver a apartar esta habitación.');
					}
				}
				endif;
				$roominglist->id_agencia = $_POST['id_agencia'];
				if($roominglist->idBloqueo->tipo == "BLOQUEO")$roominglist->fecha_apartado = date('Y-m-d H:i:s',strtotime('now +'.$roominglist->idBloqueo->tiempo_limite.' hours'));
				$roominglist->estatus = "ND";
				if($roominglist->save()){
					$notificar = Usuarios::model()->findAll('aviso LIKE "%h%"');
					foreach($notificar as $user){
						$notificacion = new Notificacion;
						$notificacion->id_item = $roominglist->id_roominglist;
						$notificacion->tipo = 3;
						$notificacion->id_users = $user->id_usuario;
						$notificacion->visto = 0;
						$notificacion->save();
					}
					$operacion=new OperacionesLog;
					$operacion->id_referencia=$roominglist->id_roominglist;
					$operacion->id_operacion_tipo=1;
					$operacion->descripcion="BLOQUEO ".$roominglist->id_bloqueo." Habitación ".$roominglist->habitacion;
					$operacion->id_usuario=Yii::app()->user->id;
					$operacion->save();
					if($roominglist->idBloqueo->tipo == "BLOQUEO")
						$this->emailAviso($roominglist);
				}
			}
			echo CJSON::encode(
				array('idagencia'=>$agencia->id_agencia,'agencia'=>$agencia->nombre_agencia)
			);
		}
	}
	public function actionDesapartarhabitacion()
	{
		if(isset($_POST['id_bloqueo'])){
			if(!empty($_POST['clave'])){
				if($this->verificaClave($_POST['clave']) == NULL){
					throw new CHttpException(400,"La clave es incorrecta, por favor intente de nuevo.");
				}else{
					$motivo = $_POST['motivo'];
				}
			}
			foreach($_POST['habs'] as $row){
				$roominglist = Roominglist::model()->find('habitacion='.$row.' and id_bloqueo='.$_POST['id_bloqueo']);
				if(!empty($roominglist)){
					$productosBloqueo = BloqueosProductos::model()->findAll('id_bloqueo='.$_POST['id_bloqueo'].' and id_roominglist='.$roominglist->id_roominglist);
					$roominglist->id_agencia = NULL;
					$roominglist->nombre = NULL;
					$roominglist->menor = NULL;
					$roominglist->edad = NULL;
					$roominglist->id_base_habitacion = NULL;
					$roominglist->fecha_inicio = $roominglist->idBloqueo->fecha_inicio;
					$roominglist->fecha_final = $roominglist->idBloqueo->fecha_final;
					$roominglist->noches = $this->noches($roominglist->idBloqueo->fecha_inicio,$roominglist->idBloqueo->fecha_final);
					$roominglist->anticipo = NULL;
					$roominglist->importe = NULL;
					$roominglist->fecha_apartado = NULL;
					$roominglist->fecha_limite = NULL;
					$roominglist->estatus = "D";
					$roominglist->observaciones = empty($motivo) ? NULL:$motivo;
					if($roominglist->save()){
						$notificar = Usuarios::model()->findAll('aviso LIKE "%h%"');
						foreach($notificar as $user){
							$notificacion = new Notificacion;
							$notificacion->id_item = $roominglist->id_roominglist;
							$notificacion->tipo = 5;
							$notificacion->id_users = $user->id_usuario;
							$notificacion->visto = 0;
							$notificacion->save();
						}
							if($productosBloqueo)
					{
						foreach($productosBloqueo as $producto)
						{
							$producto->estatus=0;
							$producto->fechaCancelacion=date('Y-m-d');
							$producto->motivoCancelacion='Cuarto Desapartado';
							if(!$producto->save())
								print_r($producto->getErrors());
						}
					}
						$operacion=new OperacionesLog;
						$operacion->id_referencia=$roominglist->id_roominglist;
						$operacion->id_operacion_tipo=2;
						$operacion->descripcion="BLOQUEO ".$roominglist->id_bloqueo." Habitación ".$roominglist->habitacion;
						$operacion->id_usuario=Yii::app()->user->id;
						$operacion->save();
						$this->emailAviso($roominglist);
					}
				}
			}		
		}
	}
	public function actionEliminarhabitacion()
	{
		if(isset($_POST['id_bloqueo'])){
			$bloqueo = $this->loadModel($_POST['id_bloqueo']);
			foreach($_POST['habs'] as $row){
				$roominglist = Roominglist::model()->find('habitacion='.$row.' and id_bloqueo='.$_POST['id_bloqueo']);
				if(empty($roominglist->id_agencia)){
					$roominglist->delete();
					$bloqueo->numero_habitaciones -= 1;
					$bloqueo->save();
					$operacion=new OperacionesLog;
					$operacion->id_referencia=$roominglist->id_roominglist;
					$operacion->id_operacion_tipo=22;
					$operacion->descripcion="BLOQUEO ".$roominglist->id_bloqueo." Habitación ".$roominglist->habitacion;
					$operacion->id_usuario=Yii::app()->user->id;
					$operacion->save();
				}
			}
		}
	}
	public function actionUpdateroominglist()
	{
		$bloqueo = Bloqueos::model()->findByPk($_POST['id_bloqueo']);
		$roominglist = Roominglist::model()->find('habitacion='.$_POST['id_hab'].' and id_bloqueo='.$_POST['id_bloqueo']);
		if(empty($roominglist))
		{
			$roominglist = new Roominglist;
			$roominglist->habitacion = $_POST['id_hab'];
			$roominglist->id_bloqueo = $_POST['id_bloqueo'];
		}
		if(isset($_POST['nombre']))$roominglist->nombre = $_POST['nombre'];
		if(isset($_POST['menor']))$roominglist->menor = $_POST['menor'];
		if(isset($_POST['edad']))$roominglist->edad = $_POST['edad'];
		if(isset($_POST['fecha_limite'])){
			$aux_fl = $roominglist->fecha_limite;
			$roominglist->fecha_limite = implode('-',array_reverse(explode('/',$_POST['fecha_limite'])));
		}
		if(isset($_POST['fecha_inicio']) && isset($_POST['fecha_final'])){
			$roominglist->fecha_inicio = implode('-',array_reverse(explode('/',$_POST['fecha_inicio'])));
			$roominglist->fecha_final = implode('-',array_reverse(explode('/',$_POST['fecha_final'])));
			$roominglist->noches = $this->noches($roominglist->fecha_inicio,$roominglist->fecha_final);
			if($roominglist->noches < $bloqueo->getNoches() && $_SESSION['tipoUsuario'] == 'Agencia'){
				throw new CHttpException(403,'Debe cumplirse el mínimo de noches del bloqueo, por favor seleccione otra fecha.');
			}
		}
		if(isset($_POST['request']))$roominglist->observaciones = $_POST['request'];
		if(isset($_POST['confirmado']))$roominglist->confirmado = 1;
		if(!empty($roominglist->nombre))$base = count(explode('/',$roominglist->nombre));
		$menores = count(explode('/',$roominglist->menor));
		if(!empty($roominglist->edad))$edades = explode(',',$roominglist->edad);
		if($base > 0 && $base <= 4)
		{
			$precio = TarifaDesglose::model()->find('id_tarifa='.$bloqueo->id_tarifa.' and id_tipo_habitacion='.$bloqueo->id_tipo_habitacion.' and id_base_habitacion='.$base);
			if(!empty($precio)){
				$roominglist->id_base_habitacion = $base;
				$roominglist->importe = $precio->precio_normal;
			}else
				$error = "La tarifa no acepta ".$base." adultos.";
			if((!empty($edades)) && count($edades) <= $precio->max_menores){
				$ninio = 1;
				for($i=0;$i<count($edades);$i++)
				{
					$precio_menor = DesgloseMenores::model()->find('id_tarifa='.$bloqueo->id_tarifa.' and id_tipo_habitacion='.$bloqueo->id_tipo_habitacion.' and id_base_habitacion=2 and '.$edades[$i].' <= edad_max_menor and num_evaluar='.$ninio.' and es_junior=0');
					if(empty($precio_menor)){
						$precio_menor = DesgloseMenores::model()->find('id_tarifa='.$bloqueo->id_tarifa.' and id_tipo_habitacion='.$bloqueo->id_tipo_habitacion.' and id_base_habitacion=2 and '.$edades[$i].' between edad_min_menor and edad_max_menor and es_junior=1');
						if(empty($precio_menor)){
							$error = "No se encontro tarifa para el menor ".($i+1)." con edad ".$edades[$i].".";
							break;
						}
					}
					if($edades[$i] >= $precio_menor->edad_min_menor){
						if($precio_menor->es_junior != 1) $ninio++;
						$roominglist->importe += $precio_menor->precio;
					}
				}
			}else if(count($edades) > $precio->max_menores){
				$error = "La tarifa no acepta mas de ".$precio->max_menores." menores por habitación base ".$roominglist->idBaseHabitacion->base_habitacion.".";
			}
			$roominglist->importe *= $roominglist->noches;
		}else if(isset($_POST['nombre']) && $_POST['nombre'] == ""){
			$roominglist->nombre = NULL;
			$roominglist->menor = NULL;
			$roominglist->edad = NULL;
			$roominglist->id_base_habitacion = NULL;
			$roominglist->fecha_inicio = $bloqueo->fecha_inicio;
			$roominglist->fecha_final = $bloqueo->fecha_final;
			$roominglist->noches = $this->noches($bloqueo->fecha_inicio,$bloqueo->fecha_final);
			$roominglist->importe = NULL;
		}else{
			$error = "Por favor, ingrese primero los adultos de la habitación.";
		}
		if($error == NULL){
			$roominglist->save();
			if(isset($_POST['noches'])){
				$operacion=new OperacionesLog;
				$operacion->id_referencia=$roominglist->id_roominglist;
				$operacion->id_operacion_tipo=27;
				$operacion->descripcion="BLOQUEO ".$roominglist->id_bloqueo." Habitación ".$roominglist->habitacion;
				$operacion->id_usuario=Yii::app()->user->id;
				$operacion->save();
			}
			if(isset($_POST['fecha_limite']) && $aux_fl != $roominglist->fecha_limite){
				$this->emailAviso($roominglist);
				$envioEmail = 1;
			}
		}
		echo CJSON::encode(array('base'=>$this->baseHab[$roominglist->id_base_habitacion],'importe'=>$roominglist->importe,'error'=>$error,'envio'=>$envioEmail));
	}
	public function actionValidarhabitaciones()
	{
		//if($_SERVER['REMOTE_ADDR'] != '108.179.229.76')
		if($_SERVER['REMOTE_ADDR'] != '173.213.96.108')
    		throw new CHttpException(403,'Access denied.');
		$habs = Roominglist::model()->with('idBloqueo')->findAll('t.estatus="ND" and fecha_apartado is not null and id_reservacion is null and tipo="BLOQUEO" and current_date<=idBloqueo.fecha_final and idBloqueo.estatus=1');
		foreach($habs as $row)
		{
			$fecha_maxima = strtotime($row->fecha_apartado);
			if($fecha_maxima <= strtotime('now'))
			{
				$row->id_agencia = NULL;
				$row->nombre = NULL;
				$row->menor = NULL;
				$row->edad = NULL;
				$row->id_base_habitacion = NULL;
				$row->fecha_inicio = $row->idBloqueo->fecha_inicio;
				$row->fecha_final = $row->idBloqueo->fecha_final;
				$row->noches = $this->noches($row->idBloqueo->fecha_inicio,$row->idBloqueo->fecha_final);
				$row->importe = NULL;
				$row->fecha_apartado = NULL;
				$row->fecha_limite = NULL;
				$row->estatus = "D";
				$row->observaciones = NULL;
				if($row->save())
				{
					$notificar = Usuarios::model()->findAll('aviso LIKE "%h%"');
					foreach($notificar as $user){
						$notificacion = new Notificacion;
						$notificacion->id_item = $row->id_roominglist;
						$notificacion->tipo = 5;
						$notificacion->id_users = $user->id_usuario;
						$notificacion->visto = 0;
						$notificacion->save();
					}
					$operacion=new OperacionesLog;
					$operacion->id_referencia=$row->id_roominglist;
					$operacion->id_operacion_tipo=2;
					$operacion->descripcion="BLOQUEO ".$row->id_bloqueo." Habitación ".$row->habitacion;
					$operacion->id_usuario=797;
					$operacion->save();
					$this->emailAviso($row);
				}
			}
		}
	}
	private function emailAviso($hab)
	{
		/*$encabezados  = "MIME-Version: 1.0\n";
		$encabezados .= "Content-type: text/html; charset=UTF-8\n";
		$encabezados .= "From:  Ruta Maya Travel <no-reply@rutamayatravel.com>\n";
		$encabezados .= "X-Sender: <contacto web>\n";
		$encabezados .= "X-Mailer: PHP\n";
		$encabezados .= "X-Priority: 3\n";
		$encabezados .= "Return-Path: <web page>\n";
		$log = OperacionesLog::model()->find('id_referencia='.$hab->id_roominglist.' and id_operacion_tipo=1 ORDER BY fecha_log DESC');
		$recipent_email = $log->idUsuario->email;
		$recipent_name = $log->idUsuario->profiles->firstname;
		if($hab->id_agencia != NULL){
			if(isset($_POST['fecha_limite'])){
				$subject = "Fecha Límite de Habitación Asignada";
				$message = "<div align='center' width='400' style='border:1px solid black'>
								<img src='http://".$_SERVER['SERVER_NAME']."".Yii::app()->baseUrl."/images/logo_rutamaya.jpg'>
								<p>Fecha: ".date('d/m/Y')."</p>
								<h4>SU HABITACIÓN CON ANTICIPO TIENE FECHA LÍMITE DE ".date('d/m/Y',strtotime($hab->fecha_limite))."</h4><hr>
								<p>La habitación #".$hab->habitacion." del bloqueo de ".$hab->idBloqueo->idHotel->nombre_hotel." del ".date('d/m/Y',strtotime($hab->idBloqueo->fecha_inicio))." al ".date('d/m/Y',strtotime($hab->idBloqueo->fecha_final))." 
								reservada el dia ".date('d/m/Y H:i:s',strtotime($log->fecha_log))." y con anticipo, tiene una nueva fecha límite de <b>".date('d/m/Y',strtotime($hab->fecha_limite))."</b> para liquidar su saldo pendiente.</p>
								<p><a href='http://".$_SERVER['SERVER_NAME']."".Yii::app()->baseUrl."/bloqueos/view/id/".$hab->id_bloqueo."'>Ir al Bloqueo</a></p>
								<h4>SI TIENES ALGUNA DUDA CONTÁCTANOS, CON GUSTO TE ASESORAREMOS</h4>
								<h4>Atentamente el equipo de Ruta Maya Travel</h4>
							</div>";
			}else if(isset($_POST['Bloqueos']['tiempo_limite'])){
				$subject = "Tiempo Limite de Bloqueo ha Cambiado";
				$message = "<div align='center' width='400' style='border:1px solid black'>
								<img src='http://".$_SERVER['SERVER_NAME']."".Yii::app()->baseUrl."/images/logo_rutamaya.jpg'>
								<p>Fecha: ".date('d/m/Y')."</p>
								<h4>EL TIEMPO LIMITE DE APARTADO DE NUEVAS HABITACIONES HA CAMBIADO</h4><hr>
								<p>El bloqueo de ".$hab->idBloqueo->idHotel->nombre_hotel." del ".date('d/m/Y',strtotime($hab->idBloqueo->fecha_inicio))." al ".date('d/m/Y',strtotime($hab->idBloqueo->fecha_final))." 
								tiene un nuevo tiempo límite de apartado de habitación asignado de ".$hab->idBloqueo->tiempo_limite." horas aprox. Esto no afecta a las habitaciones apartadas anteriormente por usted o su agencia, solo aplica para nuevos apartados posteriores a este cambio.</p>
								<p><a href='http://".$_SERVER['SERVER_NAME']."".Yii::app()->baseUrl."/bloqueos/view/id/".$hab->id_bloqueo."'>Ir al Bloqueo</a></p>
								<h4>SI TIENES ALGUNA DUDA CONTÁCTANOS, CON GUSTO TE ASESORAREMOS</h4>
								<h4>Atentamente el equipo de Ruta Maya Travel</h4>
							</div>";
			}else{
				$fecha_inicio = strtotime($log->fecha_log);
				$fecha_final = strtotime($hab->fecha_apartado);
				$horas = ceil(abs($fecha_final - $fecha_inicio) / 3600);
				$subject = "Aviso de Apartado de Habitación";
				$message = "<div align='center' width='400' style='border:1px solid black'>
								<img src='http://".$_SERVER['SERVER_NAME']."".Yii::app()->baseUrl."/images/logo_rutamaya.jpg'>
								<p>Fecha: ".date('d/m/Y')."</p>
								<h4>SU HABITACIÓN APARTADA TIENE TIEMPO LÍMITE DE ".$horas." HORAS</h4><hr>
								<p>La habitación #".$hab->habitacion." del bloqueo de ".$hab->idBloqueo->idHotel->nombre_hotel." del ".date('d/m/Y',strtotime($hab->idBloqueo->fecha_inicio))." al ".date('d/m/Y',strtotime($hab->idBloqueo->fecha_final))." 
								reservada el dia ".date('d/m/Y H:i:s',strtotime($log->fecha_log))." tiene un tiempo límite de apartado de ".$horas." horas aprox. Si durante este plazo no se genera un anticipo o cupón de reservación la habitación será desapartada por el sistema y se le notificará.</p>
								<p><a href='http://".$_SERVER['SERVER_NAME']."".Yii::app()->baseUrl."/bloqueos/view/id/".$hab->id_bloqueo."'>Ir al Bloqueo</a></p>
								<p>IMPORTANTE: Los pagos realizados se veran reflejados despues de 48 hrs de haberse realizado, para ello es indispensable enviar el comprobante de depósito a contabilidad@rutamayatravel.com</p>
								<h4>SI TIENES ALGUNA DUDA CONTÁCTANOS, CON GUSTO TE ASESORAREMOS</h4>
								<h4>Atentamente el equipo de Ruta Maya Travel</h4>
							</div>";
			}
		}else{
			$subject = "Su Apartado de Habitación ha Vencido";
			$message = "<div align='center' width='400' style='border:1px solid black'>
							<img src='http://".$_SERVER['SERVER_NAME']."".Yii::app()->baseUrl."/images/logo_rutamaya.jpg'>
							<p>Fecha: ".date('d/m/Y')."</p>
							<h4>SU HABITACIÓN HA SIDO DESAPARTADA POR EL SISTEMA DE RESERVACIONES DE RUTA MAYA</h4><hr>
							<p>La habitación #".$hab->habitacion." del bloqueo de ".$hab->idBloqueo->idHotel->nombre_hotel." del ".date('d/m/Y',strtotime($hab->idBloqueo->fecha_inicio))." al ".date('d/m/Y',strtotime($hab->idBloqueo->fecha_final))."
							fue desapartada por nuestro sistema debido a que el periodo de apartado ha vencido.</p>
							<p>Puede volver a apartar esta habitación siguiendo este link: <a href='http://".$_SERVER['SERVER_NAME']."".Yii::app()->baseUrl."/bloqueos/view/id/".$hab->id_bloqueo."'>Ir al Bloqueo</a><br/>
							ó contacte a uno de nuestros agentes para más información.</p>
							<h4>SI TIENES ALGUNA DUDA CONTÁCTANOS, CON GUSTO TE ASESORAREMOS</h4>
							<h4>Atentamente el equipo de Ruta Maya Travel</h4>
						</div>";
		}
		$mail = new JPhpMailer;
		$mail->IsSMTP();
		$mail->Host = 'rutamayatravel.com'; 
		$mail->SMTPAuth = true;
		$mail->Username = 'no-reply@rutamayatravel.com'; 
		$mail->Port = '26'; 
		$mail->Password = 'Intelred76'; 
		$mail->SMTPKeepAlive = true;  
		$mail->Mailer = "smtp"; 
		$mail->IsSMTP();  
		$mail->SMTPAuth = true;  
		$mail->CharSet = 'utf-8';  
		$mail->SMTPDebug  = 0;
		$mail->SetFrom('no-reply@rutamayatravel.com', 'Sistema Ruta Maya Travel'); 
		$mail->Subject = $subject; 
		$mail->AltBody = 'To view the message, please use an HTML compatible email viewer!'; 
		$mail->MsgHTML($message);
		if(!empty($hab->id_agencia)){
			if($hab->id_agencia!=9){
				$usuarios = Usuarios::model()->findAll('id_agencia='.$hab->id_agencia.' and estatus="A"');
				foreach($usuarios as $user){
					$mail->AddAddress($user->email_usuario, $user->nombre_usuario);
				}
			}else{
					$mail->AddAddress("grupos@rutamayatravel.com", "Grupos");
					$mail->AddAddress("bloqueos@rutamayatravel.com", "Bloqueos");
			}
		}else{
			$mail->AddAddress($recipent_email, $recipent_name);
		}
		$mail->AddAddress('contabilidad@rutamayatravel.com','Contabilidad');
		$mail->AddAddress('soporte@rutamayatravel.com','Soporte');
		$mail->Send();
*/
	}
	/**
	 * Manages all models.
	 */
	public function actionCambiarcomision()
	{		
		if(isset($_POST['comision']) && isset($_POST['bloqueo']))
		{
			$clave = Yii::app()->createController('reservacion');
			$clave = $clave[0];
			$autorizacion = $clave->verificaClave($_POST['clave']);
			if(!empty($autorizacion))
			{
				$models = Reservacion::model()->findAll('id_bloqueo='.$_POST['bloqueo']);
				foreach($models as $model)
				{
					if($model->saldo!=0)
					{
							$pagos = ReciboDetalles::model()->findAll('id_reservacion='.$model->id_reservacion);
						$count = 0;
						$importe = 0;
						foreach($pagos as $row)
						{
							$recibo = Recibo::model()->findByPk($row->id_recibo);
							if($recibo->estado != 'C')
							{
								$count+= 1;
								$importe+= $row->importe;
							}
						}
						if(!empty($model->tipo_cambio)){
							$total_cambio = round($model->total_tc * $model->tipo_cambio,2);
							$saldo_nuevo = $total_cambio - ($total_cambio*($_POST['comision']/100));
						}else{
							$saldo_nuevo = $model->total - ($model->total*($_POST['comision']/100));
						}
						$model->comision = $_POST['comision'];
						$model->saldo = round($saldo_nuevo - $importe,2);
						if($model->save()){
							$mensaje = 'Se modificó la comisión de la reserva correctamente.';
							$operacion = Yii::app()->createController('operacionesLog');
							$operacion = $operacion[0];
							$operacion->Create($model->id_reservacion,25);
						}else{
							$mensaje = 'Error al modificar la comisión de la reservación #'.$model->id_reservacion.' !';
							break;
						}
					}
				}
				$bloqueo = Bloqueos::model()->findByPk($_POST['bloqueo']);
				$bloqueo->comision=$_POST['comision'];
				$bloqueo->save();
			}
			else{
				$mensaje = 'La clave introducida no existe! Por favor intente de nuevo.';
			}
			//$this->renderPartial('msgcomision',array("mensaje"=>$mensaje));
		}
	}
	public function actionAdmin()
	{
		$model=new Bloqueos('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Bloqueos']))
			$model->attributes=$_GET['Bloqueos'];
		$this->render('admin',array(
			'model'=>$model,
		));
	}
	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model=Bloqueos::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}
	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='bloqueos-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
	public function actionReporteExcel()
	{
		$session=new CHttpSession;
		$session->open();
		if(isset($_SESSION['Bloqueos_records'])){
			$model = $_SESSION['Bloqueos_records'];
		}else{
			$criteria = new CDbCriteria();
			$criteria->addCondition('current_date<=fecha_inicio and estatus=1');
			$criteria->order = "fecha_inicio ASC";
			$model = Bloqueos::model()->findAll($criteria);
		}
		Yii::app()->request->sendFile('ReporteBloqueos_'.date('YmdHis').'.xls',
			$this->renderPartial('excelReportAll', array(
				'model'=>$model,
			), true)
		);
	}
        public function actionGenerateExcel($id)
	{
            $session=new CHttpSession;
            $session->open();		
            $model = Bloqueos::model()->findByPk($id);
			$model->fecha_inicio = implode("-", array_reverse(explode("-", $model->fecha_inicio)));
			$model->fecha_final = implode("-", array_reverse(explode("-", $model->fecha_final)));
			/*$startTimeStamp = strtotime($model->fecha_inicio);
			$endTimeStamp = strtotime($model->fecha_final);
			$timeDiff = abs($endTimeStamp - $startTimeStamp);
			$numberDays = ceil($timeDiff/86400);
			$noches = intval($numberDays);
*/
			$datetime1 = new DateTime($model->fecha_inicio);
			$datetime2 = new DateTime($model->fecha_final);
			$interval = $datetime1->diff($datetime2);
			$noches= $interval->format('%a');
		Yii::app()->request->sendFile('Bloqueo'.$id.'_'.date('YmdHis').'.xls',
			$this->renderPartial('excelReport', array(
				'model'=>$model,'noches'=>$noches,
			), true)
		);
	}
        public function actionGeneratePdf($id) 
	{
        $session=new CHttpSession;
        $session->open();
        $model = Bloqueos::model()->findByPk($id);
		$model->fecha_inicio = implode("-", array_reverse(explode("-", $model->fecha_inicio)));
		$model->fecha_final = implode("-", array_reverse(explode("-", $model->fecha_final)));
/*
		$startTimeStamp = strtotime($model->fecha_inicio);
		$endTimeStamp = strtotime($model->fecha_final);
		$timeDiff = abs($endTimeStamp - $startTimeStamp);
		$numberDays = ceil($timeDiff/86400);
		$noches = intval($numberDays);
*/			$datetime1 = new DateTime($model->fecha_inicio);
			$datetime2 = new DateTime($model->fecha_final);
			$interval = $datetime1->diff($datetime2);
			$noches= $interval->format('%a');
		$html = $this->renderPartial('expenseGridtoReport', array(
			'model'=>$model,'noches'=>$noches,
		), true);
		$pdf = new MIPDF();
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor(Yii::app()->name);
		$pdf->SetTitle('Bloqueo Report');
		$pdf->SetSubject('Bloqueo Report');
		$pdf->SetHeaderData('', 0, "Reporte Generado por ".Yii::app()->name, "");
		$pdf->setHeaderFont(Array('helvetica', '', 8));
		$pdf->setFooterFont(Array('helvetica', '', 6));
		$pdf->SetMargins(15, 20, 15);
		$pdf->SetHeaderMargin(5);
		$pdf->SetFooterMargin(10);
		$pdf->SetAutoPageBreak(TRUE, 17.5);
		$pdf->SetFont('dejavusans', '', 7);
		$pdf->AddPage();
		$pdf->writeHTML($html, true, false, true, false, '');
		$pdf->LastPage();
		$pdf->Output("Bloqueo_001.pdf", "I");
	}
	public function actionTablaProductoHab(){
		$this->renderPartial("_tablaProducto",array("cantidad"=>$_POST["cantidad"], "nocheIni"=>$_POST['nocheIni'], "minNoches"=>$_POST['minNoches']));
	}
	public function actionMovil($idAgencia,$idUsuario,$key){
		//https://www.rutamayatravel.com/reservaciones/sur3/bloqueos/movil/idAgencia/{{idAgencia}}/idUsuario/{{idUsuario}}/key/rmt00
		$this->render("movil");
	}

	public function actionGetLista(){

		header('Access-Control-Allow-Origin: *');
		header("Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept");
		header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE');
		$criteria = new CDbCriteria();            
        $criteria->addCondition('tipo="BLOQUEO"');
        $criteria->addCondition('t.estatus=1 and visibilidad = 1');
        $criteria->addCondition('current_date<=t.fecha_inicio');
        $criteria->addCondition('idTarifa.precio!="BODA"');     
        $criteria->addCondition('tarifaDesgloses.id_base_habitacion=2');
        $criteria->addCondition('tarifaDesgloses.id_tipo_habitacion=t.id_tipo_habitacion');


        $model = Bloqueos::model()->with('idTarifa','idHotel', 'tarifaDesgloses')->findAll($criteria);
        
         $item=array();
        foreach ($model as $key => $data) {
            $apartadas = count(Roominglist::model()->findAll('id_bloqueo='.$data->id_bloqueo.' and (id_agencia is not null and id_reservacion is null)'));
            $reservadas = count(Roominglist::model()->findAll('id_bloqueo='.$data->id_bloqueo.' and (id_reservacion is not null)'));
                    
            $libres= $data->numero_habitaciones - $apartadas - $reservadas; 
            if ($libres==0) {
                 
                    unset($model[$key]);                  

						 } 
						 
						  $tarifas = Tarifa::model()->find('id_tarifa='.$data['id_tarifa']);
							$foto = HotelesFotos::model()->find('id_hotel='.$data['id_hotel'].' and principal=1');
							
							$fotoLogo = HotelesFotos::model()->find('id_hotel='.$data['id_hotel'].' and logotipo=1');
							$fotoSecundaria= HotelesFotos::model()->find('id_hotel='.$data['id_hotel'].' and logotipo=0 and principal=0');
							$estrellasHotel = Hoteles::model()->find('id_hotel='.$data['id_hotel']);

							$plan = TipoPlan::model()->find('id_tipo_plan='.$data['id_tipo_plan']);
							$habitacion = TipoHabitaciones::model()->find('id_tipo_habitacion='.$data['id_tipo_habitacion']);
							

						 $item[$key]["id_bloqueo"] = $data->id_bloqueo;
						 $item[$key]["Estrellas"] = $estrellasHotel->id_categoria;
						 $item[$key]["id_tarifa"] = $tarifas->id_tarifa;
						 $item[$key]["tipo_Precio"] = $data->idTarifa->precio;
						 $item[$key]["tipo"] = $data->tipo;
						 $item[$key]["logotipo"]=$fotoLogo->foto;
						 $item[$key]["id_hotel"] = $data->id_hotel;
				   $item[$key]["foto_principal"]  = $foto->foto;
			       $item[$key]["hotel_nombre"] = $data->idHotel->nombre_hotel;
						 $item[$key]["precio_doble"] = $data->tarifaDesgloses->precio_normal;
						// $item[$key]["id_tipo_habitacion"] = $data->tarifaDesgloses->id_tipo_habitacion;
						 $item[$key]["tipo_habitacion"] = $habitacion->tipo_habitacion;
						 $item[$key]["fecha_inicio"]  = $data->fecha_inicio;
						 $item[$key]["fecha_final"]  = $data->fecha_final;
						 $item[$key]["estatus"] = $data->estatus;
						 $item[$key]["tipo_moneda"] = $data->idTarifa->moneda;
						// $item[$key]["id_tipo_plan"] = $plan->id_tipo_plan;						 
						 $item[$key]["tipo_plan"] = $plan->nombre;
						 $item[$key]["titulo_bloqueo"] = $data->titulo;
						 $item[$key]["id_base_habitacion"] = $data->tarifaDesgloses->id_base_habitacion;
						 $item[$key]["visibilidad"] =$data->visibilidad;
						 $item[$key]["hab_disponibles"] = $libres;
        }

        


				//	echo CJSON::encode($model);
				echo CJSON::encode($item);
			

	}
	public function actionGetBloqueo($id){

		header('Access-Control-Allow-Origin: *');
	
		$criteria = new CDbCriteria();            
        $criteria->addCondition('tipo="BLOQUEO"');
        $criteria->addCondition('t.estatus=1 and visibilidad = 1');
        $criteria->addCondition('current_date<=t.fecha_inicio');
        $criteria->addCondition('idTarifa.precio!="BODA"');     
        $criteria->addCondition('tarifaDesgloses.id_base_habitacion=2');
		$criteria->addCondition('tarifaDesgloses.id_tipo_habitacion=t.id_tipo_habitacion');
		$criteria->addCondition('id_bloqueo='.$id);



		$model = Bloqueos::model()->with('idTarifa','idHotel', 'tarifaDesgloses')->findAll($criteria);
        
         $item=array();
        foreach ($model as $key => $data) {
            $apartadas = count(Roominglist::model()->findAll('id_bloqueo='.$data->id_bloqueo.' and (id_agencia is not null and id_reservacion is null)'));
            $reservadas = count(Roominglist::model()->findAll('id_bloqueo='.$data->id_bloqueo.' and (id_reservacion is not null)'));
                    
            $libres= $data->numero_habitaciones - $apartadas - $reservadas; 
            if ($libres==0) {
                 
                    unset($model[$key]);                  

						 } 
						 
						  $tarifas = Tarifa::model()->find('id_tarifa='.$data['id_tarifa']);
							$foto = HotelesFotos::model()->find('id_hotel='.$data['id_hotel'].' and principal=1');
							
							$fotoLogo = HotelesFotos::model()->find('id_hotel='.$data['id_hotel'].' and logotipo=1');
							$estrellasHotel = Hoteles::model()->find('id_hotel='.$data['id_hotel']);

							$plan = TipoPlan::model()->find('id_tipo_plan='.$data['id_tipo_plan']);
							$habitacion = TipoHabitaciones::model()->find('id_tipo_habitacion='.$data['id_tipo_habitacion']);
							$menores = DesgloseMenores::model()->find('id_tarifa='.$data['id_tarifa']);
							

						 $item[$key]["id_bloqueo"] = $data->id_bloqueo;
						 $item[$key]["Estrellas"] = $estrellasHotel->id_categoria;
						 $item[$key]["descripcion_hotel"] = $estrellasHotel->observaciones;
						 $item[$key]["ubicacion_hotel"]=$estrellasHotel->ubicacion;
						 $item[$key]["id_tarifa"] = $tarifas->id_tarifa;
						 $item[$key]["tipo_Precio"] = $data->idTarifa->precio;
						 $item[$key]["tipo"] = $data->tipo;
						 $item[$key]["logotipo"]=$fotoLogo->foto;
						 $item[$key]["id_hotel"] = $data->id_hotel;
			       $item[$key]["foto_principal"]  = $foto->foto;
			       $item[$key]["hotel_nombre"] = $data->idHotel->nombre_hotel;
						 $item[$key]["precio_doble"] = $data->tarifaDesgloses->precio_normal;
						// $item[$key]["id_tipo_habitacion"] = $data->tarifaDesgloses->id_tipo_habitacion;
						 $item[$key]["tipo_habitacion"] = $habitacion->tipo_habitacion;
						 $item[$key]["fecha_inicio"]  = $data->fecha_inicio;
						 $item[$key]["fecha_final"]  = $data->fecha_final;
						 $item[$key]["estatus"] = $data->estatus;
						 $item[$key]["tipo_moneda"] = $data->idTarifa->moneda;
						// $item[$key]["id_tipo_plan"] = $plan->id_tipo_plan;						 
						 $item[$key]["tipo_plan"] = $plan->nombre;
						 $item[$key]["titulo_bloqueo"] = $data->titulo;
						 $item[$key]["id_base_habitacion"] = $data->tarifaDesgloses->id_base_habitacion;
						 $item[$key]["visibilidad"] =$data->visibilidad;
						 $item[$key]["hab_disponibles"] = $libres;
						 $item[$key]["edad_max_menor"] = $menores->edad_max_menor;
						 $item[$key]["edad_min_menor"] = $menores->edad_min_menor;
						 $item[$key]["num_menores_gratis"] = $menores->num_menores_gratis;
					
        }

        


				//	echo CJSON::encode($model);
				echo CJSON::encode($item);
			

	}




}
Yii::import('application.extensions.bootstrap.gii.*');
require_once('bootstrap/tcpdf/tcpdf.php');
require_once('bootstrap/tcpdf/config/lang/eng.php');
class MIPDF extends TCPDF {
	//Page header
	public function Header() {
		// get the current page break margin
        $bMargin = $this->getBreakMargin();
        // get current auto-page-break mode
        $auto_page_break = $this->AutoPageBreak;
        // disable auto-page-break
        $this->SetAutoPageBreak(false, 0);
        // set bacground image
        $img_file = $_SERVER['DOCUMENT_ROOT'].''.Yii::app()->baseUrl.'/images/pakal.jpg';
        $this->Image($img_file, 60, 50, 95, 135, '', '', '', false, 300, '', false, false, 0);
        // restore auto-page-break status
        $this->SetAutoPageBreak($auto_page_break, $bMargin);
        // set the starting point for the page content
        $this->setPageMark();
		// Set font
		$this->SetFont('helvetica', 'B', 12);
		// Title
		$this->Ln(4);
		$this->Cell(0, 15, 'Reporte Generado por Sistema de Reservaciones', 0, false, 'C', 0, '', 0, false, 'M', 'M');
		$this->Line(15,15,195,15);
	}




}