<?php
//error_reporting(E_ALL & ~E_NOTICE);
$usuario=Profiles::model()->findByPk(Yii::app()->user->id); 
 $tipoUsuario=$usuario->tipo;
 $_SESSION["tipoUsuario"]=$tipoUsuario;
Yii::import('application.extensions.phpmailer.JPhpMailer');
class BloqueosController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	//public $layout='//layouts/column1';
	public $layout = '//layouts/ansonika_site';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
			array(
				'ext.starship.RestfullYii.filters.ERestFilter + 
                REST.GET, REST.PUT, REST.POST, REST.DELETE'
			),
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array(
				'allow', 'actions' => array('REST.GET', 'REST.PUT', 'REST.POST', 'REST.DELETE'),
				'users' => array('@'),
			),
			array(
				'allow',  // allow all users to perform 'index' and 'view' actions
				'actions' => array('index', 'view', 'getLista', 'getNoDisponibles', 'listaBloqueos'),
				'users' => array('*'),
			),
			array(
				'allow',  // allow all users to perform 'index' and 'view' actions
				'actions' => array('index', 'view', 'getBloqueo', 'getDetailBloqueo', 'apartarHabitacion', 'getRoomingList', 'getGrupos', 'getPax','estatusBloqueo','recibos','anticipos','proxPagosGrupos','loadRoomingList'),
				'users' => array('@'),
			),
			array(
				'allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions' => array('create', 'update', 'GeneratePdf', 'GenerateExcel', 'updateRoomingList', 'DeletePax','habitacionesApartadas'),
				'users' => array('@'),
			),
			array(
				'allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions' => array('admin', 'delete'),
				'users' => array('admin'),
			),
			array(
				'deny',  // deny all users
				'users' => array('*'),
			),
		);
	}

	public function actions()
	{
		return array('REST.' => 'ext.starship.RestfullYii.actions.ERestActionProvider',);
	}


	public function actionEstatusBloqueo($id){
		$rooms = Roominglist::model()->findAll('id_bloqueo=' . $id . ' and id_agencia IS NULL ');
		$bloqueo['disponibles'] = count($rooms);


		$rooms = Roominglist::model()->findAll('id_bloqueo=' . $id . ' and id_reservacion IS NOT NULL  ');
		$bloqueo['reservadas'] = count($rooms);

		$rooms = Roominglist::model()->findAll('id_bloqueo=' . $id . ' and id_reservacion IS NULL and id_agencia IS NOT NULL ');
		$bloqueo['apartadas'] = count($rooms);

		echo json_encode($bloqueo);

	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */

	public function actionGetGrupos($id_agencia)
	{
		$tipo="GRUPAL";
		if ($_GET['tipo']=="BODA") {
			$tipo="BODA";
		}
		$primerdiaAño=date('Y')."-01-01";
		$gruposArray = array();
		if ($id_agencia == 9) {
			$grupos = Bloqueos::model()->findAll("tipo = 'GRUPAL'  ORDER BY fecha_creacion DESC ");
		} else {
			$grupos = Bloqueos::model()->findAll("tipo = 'GRUPAL' AND id_agencia = " . $id_agencia . " AND visibilidad=1  ORDER BY fecha_creacion DESC");
		}
		foreach ($grupos as $key => $value) {
			$tarifa = Tarifa::model()->findByPk(intval($value->id_tarifa));
			if ($tarifa->precio == $tipo) {
				$vigente = false;
				$historial = false;
				$hotel = Hoteles::model()->findByPk($value->id_hotel);
				$fotos_hotel = HotelesFotos::model()->findAll("id_hotel = " . $value->id_hotel);
				$logo_hotel = HotelesFotos::model()->find("id_hotel = " . $value->id_hotel." AND logotipo = '1'");
				$tarifa_desglose = TarifaDesglose::model()->find("id_tarifa = " . $value->id_tarifa);
				$habitacion = TipoHabitaciones::model()->findByPk($tarifa_desglose->id_tipo_habitacion);
				$habitaciones = count(Roominglist::model()->findAll("id_bloqueo = " . $value->id_bloqueo));
				if (empty($fotos_hotel)) {
					$fotos_hotel="none";
				}
				if(empty($logo_hotel)){
					$logo_hotel = "none";
				}

				if (strtotime($value->fecha_inicio)>=strtotime(date('Y-m-d')) && $value->estatus==1) {
					$vigente = true;
				}

				if (strtotime($value->fecha_inicio)<=strtotime(date('Y-m-d')) || $value->estatus!=1) {
					$historial = true;
				}

				array_push($gruposArray, array(
					"info" => $value,
					"hotel" => $hotel,
					"fotos" => $fotos_hotel,
					"logo" => $logo_hotel->foto,
					"habitacion" => $habitacion,
					"habitaciones" => $habitaciones,
					"vigente" => $vigente,
					"historial" => $historial
					//"tarifa" => $tarifa,
				));
			}

			/*$gruposArray[$key]['grupo'] = $value;
			$gruposArray[$key]['idHotel'] = $hotel;
			$gruposArray[$key]['hotelesFotoses'] = $fotos_hotel;*/
		}
		echo CJSON::encode($gruposArray);
	}
	public function actionRecibos()
	{
		$recibos = ReciboDetalles::model()->with('idRecibo')->findAll('estado!="C" and id_reservacion in ('.$_POST['habitaciones'].') ');
		echo CJSON::encode($recibos);
	}
	
	public function actionAnticipos()
	{
		$roominglist=Roominglist::model()->findByPk($_POST['id_roominglist']);

			
			$roomingAnticipo = RoominglistAnticipo::model()->with('idNotaCredito')->findAll('id_roominglist='.$value->id_roominglist.' and id_agencia='.$value->id_agencia.'  and estatus="A"');
		
		
		echo CJSON::encode($roomingAnticipo);
	}
	public function actionView($id)
	{
		$model = $this->loadModel($id);
	
		$rooms = Roominglist::model()->findAll('id_bloqueo=' . $id . ' and id_agencia IS NULL ');
		$disponibles = count($rooms);


		$rooms = Roominglist::model()->findAll('id_bloqueo=' . $id . ' and id_reservacion IS NOT NULL  ');
		$reservadas = count($rooms);

		$rooms = Roominglist::model()->findAll('id_bloqueo=' . $id . ' and id_reservacion IS NULL and id_agencia IS NOT NULL ');
		$apartadas = count($rooms);
		$notacredito = new NotaCredito;
		$notacredito->id_ref = $id;
		$notacredito->tipo_ref = "BLOQUEO";
		$notacredito->id_agencia = $model->id_agencia;
		if($_SESSION["tipoUsuario"] == "Agencia")
			$condAgencia = "and id_agencia=".$_SESSION["agenciaUsuario"];
		$notas = NotaCredito::model()->findAll('id_ref='.$id.' and tipo_ref="BLOQUEO" '.$condAgencia.' and estatus="A"');
		$credito = 0;
		foreach($notas as $row){
			$credito += $row->importe;
		}

		$this->render('view', array(
			'model' => $model, 'disponibles' => $disponibles, 'apartadas'=>$apartadas, 'reservadas'=>$reservadas, 'notacredito'=>$notacredito, 'notas'=>$notas, 'credito'=>$credito, 'servicios'=>$servicios));
	}
	public function actionProxPagosGrupos(){
		if (isset($_SESSION['agenciaUsuario'])) {
			# code...
			// if ($_SESSION['agenciaUsuario']==9) {
				// $bloqueos = Bloqueos::model()->findAll('id_agencia=525 AND current_date <= fecha_inicio');
				
			// }else{
				$bloqueos = Bloqueos::model()->findAll('id_agencia='.$_SESSION['agenciaUsuario'].' AND current_date <= fecha_inicio');

			// }
			// $bloqueos = Bloqueos::model()->findAll('id_agencia=145 AND current_date <= fecha_inicio');
			$proxPagos = array();
			foreach ($bloqueos as $key => $value) {
				$grupo_politicas=GruposPoliticasPagos::model()->find('id_bloqueo='.$value->id_bloqueo);

				if(!empty($grupo_politicas->id_politicas_pagos))
				{
					$fecha_actual = date('Y-m-d');
					$fecha_menos_dias = date("Y-m-d",strtotime($fecha_actual."- 30 days"));
					$fecha_mas_dias = date("Y-m-d",strtotime($fecha_actual."+ 30 days"));
					
					$grupo_politicas_desglose=GruposPoliticasPagosDesglose::model()->findAll('id_politicas_pagos='.$grupo_politicas->id_politicas_pagos.' AND pagado=0 AND fecha AND fecha <= "'.$fecha_mas_dias.'"');

					if (count($grupo_politicas_desglose)>0) {
						$proxPagos[$value->id_bloqueo]['bloqueo'] = $value; 
						$proxPagos[$value->id_bloqueo]['nombre_hotel'] = $value->idHotel->nombre_hotel; 
						$proxPagos[$value->id_bloqueo]['nombre_agencia'] = $value->idAgencia->nombre_agencia; 
						foreach ($grupo_politicas_desglose as $val => $pago) {
							$importeTotal += $pago->importe;
							$proxPagos['saldo_pendiente_mxn'] = $importeTotal;
							$proxPagos[$value->id_bloqueo]['pagos'][$val]['descripcion_pago'] = $pago->descripcion_pago;
							$proxPagos[$value->id_bloqueo]['pagos'][$val]['importe'] = $pago->importe;
							// $proxPagos[$value->id_bloqueo]['pagos'][$val]['fecha'] = date('d/m/Y', strtotime($pago->fecha));
							$proxPagos[$value->id_bloqueo]['pagos'][$val]['fecha'] = $pago->fecha;
							$proxPagos[$value->id_bloqueo]['pagos'][$val]['observaciones'] = $pago->observaciones;

							if (strtotime($pago->fecha) < strtotime($fecha_actual)) {
								$proxPagos[$value->id_bloqueo]['pagos'][$val]['pago_vencido'] = true;
							 } else {
								$proxPagos[$value->id_bloqueo]['pagos'][$val]['pago_vencido'] = false;
							 }
						}
					}
				} 
			}

			echo CJSON::encode($proxPagos);
			
		}
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model = new Bloqueos;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if (isset($_POST['Bloqueos'])) {
			$model->attributes = $_POST['Bloqueos'];
			if ($model->save())
				$this->redirect(array('view', 'id' => $model->id_bloqueo));
		}

		$this->render('create', array(
			'model' => $model,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionLoadRoomingList($id_bloqueo) {
		$agencia=" and t.id_agencia=".$_SESSION['agenciaUsuario'];
		if ($_SESSION['agenciaUsuario']==9) {
			$agencia="";
		}
		
		$model = Roominglist::model()->with("anticipos", "idAgencia", "idBloqueo", "Desglose","idReservacion","idBaseHabitacion")->findAll(" t.id_bloqueo =".$id_bloqueo.$agencia);	
		$arrayModel=$this->convertModelToArray($model);
			foreach ($arrayModel as $key=>$value) {
				$arrayModel[$key]['anticipos']=array();
				if ($value['anticipos'] && $value['id_agencia']) {
					foreach ($value['anticipos'] as $ka=>$val) {
						$nota=RoominglistAnticipo::model()->with('idNotaCredito')->find("id=".$val['id']." and estatus='A' and id_agencia=".$value['id_agencia']);
						if ($nota) {
							
							array_push($arrayModel[$key]['anticipos'],$nota);
						}else{
							//unset($arrayModel[$key]['anticipos'][$ka]);
						}
					}
				}
				
			}	

		echo CJSON::encode($arrayModel);
	}
	public function actionUpdate($id)
	{
		$model = $this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if (isset($_POST['Bloqueos'])) {
			$model->attributes = $_POST['Bloqueos'];
			if ($model->save())
				$this->redirect(array('view', 'id' => $model->id_bloqueo));
		}

		$this->render('update', array(
			'model' => $model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		if (Yii::app()->request->isPostRequest) {
			// we only allow deletion via POST request
			$this->loadModel($id)->delete();

			// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
			if (!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
		} else
			throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$this->render('index');
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model = new Bloqueos('search');
		$model->unsetAttributes();  // clear any default values
		if (isset($_GET['Bloqueos']))
			$model->attributes = $_GET['Bloqueos'];

		$this->render('admin', array(
			'model' => $model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model = Bloqueos::model()->findByPk($id);
		if ($model === null)
			throw new CHttpException(404, 'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if (isset($_POST['ajax']) && $_POST['ajax'] === 'bloqueos-form') {
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}

	public function actionGenerateExcel()
	{
		$session = new CHttpSession;
		$session->open();

		if (isset($session['Bloqueos_records'])) {
			$model = $session['Bloqueos_records'];
		} else
			$model = Bloqueos::model()->findAll();

		Yii::app()->request->sendFile(
			date('YmdHis') . '.xls',
			$this->renderPartial('excelReport', array(
				'model' => $model
			), true)
		);
	}

	public function actionGeneratePdf()
	{
		$session = new CHttpSession;
		$session->open();
		Yii::import('application.extensions.bootstrap.gii.*');
		require_once('bootstrap/tcpdf/tcpdf.php');
		require_once('bootstrap/tcpdf/config/lang/eng.php');

		if (isset($session['Bloqueos_records'])) {
			$model = $session['Bloqueos_records'];
		} else
			$model = Bloqueos::model()->findAll();

		$html = $this->renderPartial('expenseGridtoReport', array(
			'model' => $model
		), true);

		//die($html);

		$pdf = new TCPDF();
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor(Yii::app()->name);
		$pdf->SetTitle('Bloqueos Report');
		$pdf->SetSubject('Bloqueos Report');
		//$pdf->SetKeywords('example, text, report');
		$pdf->SetHeaderData('', 0, "Report", '');
		$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, "Example Report by " . Yii::app()->name, "");
		$pdf->setHeaderFont(array('helvetica', '', 8));
		$pdf->setFooterFont(array('helvetica', '', 6));
		$pdf->SetMargins(15, 18, 15);
		$pdf->SetHeaderMargin(5);
		$pdf->SetFooterMargin(10);
		$pdf->SetAutoPageBreak(TRUE, 0);
		$pdf->SetFont('dejavusans', '', 7);
		$pdf->AddPage();
		$pdf->writeHTML($html, true, false, true, false, '');
		$pdf->LastPage();
		$pdf->Output("Bloqueos_002.pdf", "I");
	}

	public function actionGetDetailBloqueo($id)
	{
		$array_bloqueo = array();
		$model=Bloqueos::model()->findByPk($id);
		$array_bloqueo["info_bloqueo"] = $model;
		$model_hotel = Hoteles::model()->find('id_hotel=' . $array_bloqueo["info_bloqueo"]->id_hotel);
		$model_destino = Destinos::model()->findByPk($model_hotel->id_destinoLocal);
		$array_bloqueo["info_adicional"]["nombre_hotel"] = $model_hotel->nombre_hotel;
		$array_bloqueo["info_adicional"]["descripcion_hotel"] = $model_hotel->observaciones;
		$array_bloqueo["info_adicional"]["tipo_habitacion"] = TipoHabitaciones::model()->findByPk($array_bloqueo["info_bloqueo"]->id_tipo_habitacion)->descripcion;
		$array_bloqueo["info_adicional"]["plan"] = Plan::model()->findByPk($array_bloqueo["info_bloqueo"]->id_tipo_plan)->nombre;
		$array_bloqueo["info_adicional"]["destino_hotel"] = $model_destino->destino;
		$array_bloqueo["info_adicional"]["fotos"] = HotelesFotos::model()->findAll("id_hotel = " . $array_bloqueo["info_bloqueo"]->id_hotel);
		$array_bloqueo["info_adicional"]["foto_principal"] = HotelesFotos::model()->findAll("id_hotel = " . $array_bloqueo["info_bloqueo"]->id_hotel . ' and principal=1');
		if ($model_hotel->id_categoria!=NULL || $model_hotel->id_categoria!='') {
			$estrellas_categoria = $model_hotel->id_categoria;
		}else{
			$estrellas_categoria = $model_hotel->estrellas;
		}
		$array_bloqueo["info_adicional"]["estrellas_hotel"] = $estrellas_categoria;
		$array_bloqueo["info_adicional"]["videos_hotel"] = HotelesVideos::model()->findAll("id_hotel = " . $array_bloqueo["info_bloqueo"]->id_hotel . ' and estatus=1');
		$array_bloqueo["tarifa_desglose"] = TarifaDesglose::model()->findAll("id_tarifa = " . $array_bloqueo["info_bloqueo"]->id_tarifa.' and id_tipo_habitacion='.$array_bloqueo["info_bloqueo"]->id_tipo_habitacion);
		$array_bloqueo["politicas"] = GruposPoliticasPagos::model()->find("id_bloqueo = " . $array_bloqueo["info_bloqueo"]->id_bloqueo);
		if ($_GET['id_agencia'] == 9) {
			$roomingList=Roominglist::model()->findAll("id_bloqueo = " . $array_bloqueo["info_bloqueo"]->id_bloqueo);
			        
			$array_bloqueo["rooming_list"] = $roomingList;
		} else {
			$array_bloqueo["rooming_list"] = Roominglist::model()->findAll('id_bloqueo = ' . $array_bloqueo["info_bloqueo"]->id_bloqueo . ' and id_agencia = ' . $_GET['id_agencia']);
		}
		$array_bloqueo["desgloseMenores"] = DesgloseMenores::model()->findAll("id_tarifa = " . $array_bloqueo["info_bloqueo"]->id_tarifa.' and id_tipo_habitacion='.$array_bloqueo["info_bloqueo"]->id_tipo_habitacion);
		$array_bloqueo["tipoPrecio"]=$model->idTarifa->precio;
		$array_bloqueo["noComisionables"]=ServNoComision::model()->findAll('id_bloqueo = ' . $array_bloqueo["info_bloqueo"]->id_bloqueo );
		$array_bloqueo["paquetes"]=PaquetesBoda::model()->findByPk($array_bloqueo["info_bloqueo"]->id_paquete);
		$array_bloqueo["comisionAgencia"]=$model->idAgencia->porcentaje_comision;
		if($_SESSION["tipoUsuario"] == "Agencia")
			$condAgencia = "and id_agencia=".$_SESSION["agenciaUsuario"];
		$notas = NotaCredito::model()->findAll('id_ref='.$id.' and tipo_ref="BLOQUEO" '.$condAgencia.' and estatus="A"');
		$array_bloqueo["notasCredito"]=$notas;

		$tipoproductoOrden = 'Habitacion-';
		if ($model->idTarifa->precio == "BODA") {
			$tipo_bloqueo = "Boda";
		} elseif ($model->tipo == "BLOQUEO") {
			$tipo_bloqueo = "Bloqueo";
			if ($_SESSION["tipoUsuario"] == "Agencia" && !empty($_SESSION["agenciaUsuario"])) {
				$agenciaOrden = "AND op.id_agencia=".$_SESSION["agenciaUsuario"];
			}
		} else {
			$tipo_bloqueo = "Grupo";
		}
		$sqlHab = "SELECT o.*, op.log FROM tbl_orden_pago_detalles o INNER JOIN tbl_orden_pago op USING(id_orden_pago) WHERE (o.identificador='".$model->id_bloqueo."' OR o.identificador LIKE '".$model->id_bloqueo."-%') AND op.estatus='PA' AND o.id_orden_pago_detalles NOT IN(1199) ".$agenciaOrden;
  		$ordendetalles = Yii::app()->db->createCommand($sqlHab)->queryAll();
  		$array_bloqueo["ordenPagos"]=$ordendetalles;

		echo CJSON::encode($array_bloqueo);
	}
	public function convertModelToArray($models) {
        if (is_array($models))
            $arrayMode = TRUE;
        else {
            $models = array($models);
            $arrayMode = FALSE;
        }

        $result = array();

        foreach ($models as $model) {
            $attributes = $model->getAttributes();
            $relations = array();

            foreach ($model->relations() as $key => $related) {
                if ($model->hasRelated($key)) {
                	if ($model->$key) {
                    	$relations[$key] = $this->convertModelToArray($model->$key);	
                	}else if($key=="idBaseHabitacion" || $key=="idReservacion"){
                		$relations[$key] =null;
                	}else{
                		$relations[$key] =[];
                	}
                }
            }

            $all = array_merge($attributes, $relations);

            if ($arrayMode)
                array_push($result, $all);
            else
                $result = $all;
        }

        return $result;
    }
	// public function actionGetRoomingRMT($id){
	// 	$array_roomingList = array();
	// 	$model_bloqueos = Bloqueos::model()->findByPk($id);

	// 	if($_GET['id_agencia'] != "9"){
	// 		$model_roomingList = Roominglist::model()->findAll('id_bloqueo = ' . $model_bloqueos->id_bloqueo .' and id_agencia = ' .$_GET['id_agencia'] );

	// 	}else if($_GET['id_agencia'] == "9"){
	// 		$model_roomingList = Roominglist::model()->findAll("id_bloqueo = " . $model_bloqueos->id_bloqueo);
	// 	}

	// 	foreach($model_roomingList as $key=>$data){
	// 		array_push($array_roomingList, array(
	// 			"id_roominglist" => $data->id_roominglist,
	// 			"habitacion" => $data->habitacion,
	// 			"id_bloqueo" => $data->id_bloqueo,
	// 			"id_agencia" => $data->id_agencia,
	// 			"nombre" => $data->nombre,
	// 			"menor" => $data->menor,
	// 			"edad" => $data->edad,
	// 			"id_base_habitacion" => $data->id_base_habitacion,
	// 			"fecha_inicio" => $data->fecha_inicio,
	// 			"fecha_final" => $data->fecha_final,
	// 			"noches" => $data->noches,
	// 			"id_reservacion" => $data->id_reservacion,
	// 			"anticipo" => $data->anticipo,
	// 			"importe" => $data->importe,
	// 			"fecha_apartado" => $data->fecha_apartado,
	// 			"fecha_limite" => $data->fecha_limite,
	// 			"estatus" => $data->estatus,
	// 			"observaciones" => $data->observaciones,
	// 			"confirmado" => $data->confirmado

	// 		));
	// 	}

	// 	echo CJSON::encode($array_roomingList);

	// }
	public function actionGetRoomingList($id)
	{
		$criteria = new CDbCriteria;
		$criteria->condition = 'id_bloqueo=' . $id . ' and id_agencia=' . $_POST['id_agencia'];

		$model = Roominglist::model()->findAll($criteria);
		echo CJSON::encode($model);
	}
	public function actionGetPax($id)
	{
		
		$model=RoominglistDesglose::model()->findAll('id_roominglist='.$id);
		echo CJSON::encode($model);
	}
	public function actionDeletePax($id)
	{
		$desglose = RoominglistDesglose::model()->findByPk($id);
		$roominglist = Roominglist::model()->findByPk($desglose->id_roominglist);
		$value='id:'.$id;
		if ($desglose->tipo=="A") {
			$nombres=$roominglist->nombre;
		}else{
			$nombres=$roominglist->menor;
			$edad=explode(',',$roominglist->edad);
			if (count($edad)>1) {
				$key=in_array($desglose->edad, $edad);
				unset($edad[$key]);
				$edad=implode(',',$edad);
			}else{
				$edad="";
			}
		}
		$value.=" Edad:".$desglose->edad;
		$nombre=explode('/',$nombres);
		if (count($nombre)>1) {
			$key=in_array($desglose->nombre.' '.$desglose->apellido, $nombre);	
			unset($nombre[$key]);
			$nombre=implode('/',$nombre);
		}else{
			
			$nombre="";
		}
			$value.=" Nombre:".$desglose->nombre." ".$desglose->apellido." tipo:".$desglose->tipo;

		
		if ($desglose->tipo=="A") {
			$roominglist->nombre=$nombre;
		}else{
			$roominglist->menor=$nombre;
			$roominglist->edad=$edad;
		}

		if($roominglist->save()){
			if($desglose->delete())
			{
				$rlog=new RoominglistLog;
			 	$rlog->movimiento="Eliminar Pax";
			 	$rlog->valor=$value;
			 	$rlog->id_usuario=Yii::app()->user->id;
			 	$rlog->id_roominglist=$roominglist->id_roominglist;
			 	$rlog->id_bloqueo=$roominglist->id_bloqueo;
			 	if(!$rlog->save())
			 		print_r($rlog->getErrors());
			}
		}

	}
	public function actionUpdateRoomingList($id)
	{
		$model = Roominglist::model()->findByPk($id);
		$modelAux=CJSON::decode(CJSON::encode($model));
		$nombres= explode(' / ',$_POST['RoomingList']['nombre']);
		$menores= explode(' / ',$_POST['RoomingList']['menor']);
	
		$countA=count($nombres);
		$countM=count($menores);
		$roomDesglose=json_encode($_POST['RoomingList']['Desglose']);
		$roomDesglose=json_decode($roomDesglose);
		$countPaxAdults=RoominglistDesglose::model()->count('tipo="A" and id_roominglist='.$id);
		$countPaxChilds=RoominglistDesglose::model()->count('tipo="N" and id_roominglist='.$id);
		$counHabAdults=$model->idBloqueo->idHab->max_adultos;
		$counHabChilds=$model->idBloqueo->idHab->max_menores;
		$childVacancy=false;

		if ($countPaxChilds<$counHabChilds) {
			$childVacancy=true;
		}

		$adultVacancy=false;
		if ($countPaxAdults<$counHabAdults) {
			$adultVacancy=true;
		}
		
		
		$model->attributes=$_POST['Roominglist'];
		$model->id_base_habitacion=$countA;
		$model->nombre=$_POST['RoomingList']['nombre'];
		$model->menor=$_POST['RoomingList']['menor'];
		$model->edad=str_replace(" ", "", $_POST['RoomingList']['edad']);
		$model->observaciones=$_POST['RoomingList']['observaciones'];
		$array_roomingList=$this->crearArrayReserva($model);
		$validaTarifa=$this->validaTarifa($array_roomingList['Reservacion'],1);
		$model->importe=$validaTarifa['total'][0]['total'];
		if (empty($validaTarifa['error'])) {
			foreach ($roomDesglose as $key=>$nom) {
				$desglose = RoominglistDesglose::model()->findByPk($nom->id_pax);
				if (!$desglose && (($adultVacancy && ($nom->tipo=="Adulto"||$nom->tipo=="A")) || ($childVacancy && ( $nom->tipo=="Menor" || $nom->tipo=="N") ))) {
					$desglose=new RoominglistDesglose;
				}
					$desglose->nombre=$nom->nombre;
					$desglose->apellido=$nom->apellido;
					$desglose->id_agencia=$model->id_agencia;
					$desglose->id_roominglist=$id;
				if ($nom->tipo=="A" || $nom->tipo=="Adulto") {
					$desglose->tipo="A";
					$desglose->importe=$_POST['aImporte'];
				}else{
					$desglose->tipo="N";
					$desglose->edad=$nom->edad;
					$desglose->importe=$_POST['aImporte'];
				}
				if (!$desglose->save()) 
					echo CJSON::encode($desglose->getErrors());			
			}
		}else{
			throw new CHttpException(400,$validaTarifa['error']);
		}
		/*try {
			
		} catch (Exception $e) {
			if($_SESSION['tipoUsuario'] == "Agencia"){
				$mensaje="Contacta a tu agente: La información de los pasajeros ha sido guardada para evitar la recaptura";
			}else{
				$mensaje="Revisa La información de la tarifa, fechas de precompra o dias validos";
			}

			throw new CHttpException(404,$mensaje);
		}*/
	
		if($model->save()){
				$valtext="";
			foreach ($modelAux as $key=>$value) {
				if ($_POST['RoomingList'][$key]!=$value) {
					$valtext.=$key.": ".$value.',';
				}
			}
				 	$rlog=new RoominglistLog;
				 	$rlog->movimiento='Update Roominglist';
				 	$rlog->valor=$valtext;
				 	$rlog->id_usuario=Yii::app()->user->id;
				 	$rlog->id_roominglist=$_POST['RoomingList']['id_roominglist'];
				 	$rlog->id_bloqueo=$_POST['RoomingList']['id_bloqueo'];
				 	if(!$rlog->save())
				 		print_r($rlog->getErrors());
				  
			echo 'ok';
		}else{
			echo CJSON::encode($model->getErrors());
		}

	}
	
	public function crearArrayReserva($rooming)
	{
		if ($rooming->nombre) {
			$nombre=explode('/',stripslashes($rooming->nombre));
			$count=count($nombre);
			$reservAux=array(
							'Reservacion'=>array(
								'Reservacion'=>array(
								  "id_hotel"=>$rooming->idBloqueo->id_hotel,
								  "id_bloqueo"=>$rooming->id_bloqueo,
							      "id_agente"=> Yii::app()->user->id,
							      "id_agencia"=>$rooming->id_agencia,
							      "id_usuario"=>Yii::app()->user->id,
							      "id_tipo_plan"=>$rooming->idBloqueo->id_tipo_plan,
							      "num_habitaciones"=>"1",
							      "fecha_inicial"=>$rooming->fecha_inicio,
							      "num_noches"=>$rooming->noches,
							      "fecha_final"=>$rooming->fecha_final,
							      "observaciones"=>$rooming->observaciones,
							      "total"=>$rooming->importe,
							      "total_tc"=>$rooming->importe,
							      "id_tarifa"=>$rooming->idBloqueo->id_tarifa,

								),
							    'Habitacion'=>array(
							      'id_tipo_habitacion'=>$rooming->idBloqueo->id_tipo_habitacion,
							      'id_base_habitacion'=>$rooming->id_base_habitacion,
							      'num_adultos'=>$count,							      
							      'num_hab'=>$rooming->habitacion,
							    ),
							    
								 'carrito'=>array(),
								 'TotalCotiz'=>array(),
								 'ecomerce'=>array()
							)
						);
				$reservAux['Reservacion']['Habitacion']['num_ninios']=0;
			if ($rooming->menor) {
				$nombreMenor=explode('/',$rooming->menor);
				$edadMenor=explode(',',$rooming->edad);
				$countMenor=count($nombreMenor);
				for ($i=0; $i < $countMenor ; $i++) { 				
					$reservAux['Reservacion']['Habitacion']['Ninio'][($i+1)]['nombre']=$nombreMenor[$i];
					$reservAux['Reservacion']['Habitacion']['Ninio'][($i+1)]['edad']=$edadMenor[$i];
				}
					$reservAux['Reservacion']['Habitacion']['num_ninios']=$countMenor;
			}
			for ($i=0; $i < $count ; $i++) { 
				$name=array();
				for ($j=0; $j < $count; $j++) {
					//$nombre=trim($nombre[$j]); 
					array_push($name,explode(' ', trim($nombre[$j])));											
				}
				$reservAux['Reservacion']['Adulto'][($i+1)]['nombre']=$name[$i][1];				
				$reservAux['Reservacion']['Adulto'][($i+1)]['apellido']=$name[$i][0];		
				$reservAux['Reservacion']['Reservacion']['nombre_cliente']=$name[0][1];	
				$reservAux['Reservacion']['Reservacion']['apellido_cliente']=$name[0][0];				
			}
		}
		return $reservAux;	
	}
	public function validaTarifa($reserva,$roominglist=null)
	{
		$model=(object)$reserva['Reservacion'];
		$hab=(object)$reserva['Habitacion'];

		$reservaControl=Yii::app()->createController('reservacion')[0];
		/*$model=new Reservacion;
		$model->attributes=$reserva['Reservacion'];*/
		$datos=array(); $menores=array();
		$error=NULL; $ocultaT = array();
		$Total = array();
		$maxT = 0;
		$hora = "and curtime() between hora_inicio and hora_final";
		$fecha_promo = "and current_date between fecha_promo_inicio and fecha_promo";
		$early_booking = "and (early_booking is null or DATEDIFF('".implode("-", array_reverse(explode("-", $model->fecha_inicial)))."',current_date) <= early_booking)";
		$release = "and (t.release is null or DATEDIFF('".implode("-", array_reverse(explode("-", $model->fecha_inicial)))."',current_date) >= t.release)";
		if($_SESSION["agenciaUsuario"] != 9){
			$tarifaAgencias = 'and not exists(select NULL from tbl_tarifa_agencia tarifaAgencias where tarifaAgencias.id_tarifa=t.id_tarifa and tarifaAgencias.id_agencia!='.$_SESSION["agenciaUsuario"].')';
			$agenciaUsuario = Agencias::model()->findByPk($_SESSION["agenciaUsuario"]);
			/*$tarifaEstados = 'and exists(select NULL from tbl_tarifa_estados tarifaEstados where tarifaEstados.id_tarifa=t.id_tarifa and tarifaEstados.id_estado='.$agenciaUsuario->id_estado_agencia.')';*/
			$tarifaEstados ="";
		}

		for($dia=0;$dia<$model->num_noches;$dia++)
		{

			$fecha = date("Y-m-d", strtotime(implode("-", array_reverse(explode("-", $model->fecha_inicial))))+$dia*24*60*60);
			$fechadia = strtotime(implode("-", array_reverse(explode("-", $model->fecha_inicial))))+$dia*24*60*60;
			if($model->id_bloqueo != "")
			{
				$bloqueo = Bloqueos::model()->findByPk($model->id_bloqueo);
				$tipo_precio = $bloqueo->idTarifa->precio;
				$tarifa = Tarifa::model()->with('tarifaDiasvalidos')->findAll(array('condition'=>'t.id_tarifa='.$bloqueo->id_tarifa.' and id_tipo_plan='.$model->id_tipo_plan.' '.$fecha_promo.' '.$hora.' and precio="'.$tipo_precio.'" and estatus=1 and dia='.date("N",$fechadia).' and "'.$fecha.'" between t.fecha_inicial and t.fecha_final '.$tarifaAgencias.' '.$tarifaEstados.' and not exists(select NULL from tbl_fechas_bloqueadas tarifaFechasbloqueadas where "'.$fecha.'" between tarifaFechasbloqueadas.fecha_inicio and tarifaFechasbloqueadas.fecha_final and tarifaFechasbloqueadas.id_tipo_habitacion is null and tarifaFechasbloqueadas.id_tarifa=t.id_tarifa)', 'order'=>'precio'));
				if (count($tarifa)==0) {
					$tarifaComb=$bloqueo->idTarifa->id_combina;
					$tarifa = Tarifa::model()->with('tarifaDiasvalidos')->findAll(array('condition'=>'t.id_tarifa IN('.$bloqueo->id_tarifa.','.$tarifaComb.') and id_tipo_plan='.$model->id_tipo_plan.' '.$fecha_promo.' '.$hora.' and precio="'.$tipo_precio.'" and estatus=1 and dia='.date("N",$fechadia).' and "'.$fecha.'" between t.fecha_inicial and t.fecha_final '.$tarifaAgencias.' '.$tarifaEstados.' and not exists(select NULL from tbl_fechas_bloqueadas tarifaFechasbloqueadas where "'.$fecha.'" between tarifaFechasbloqueadas.fecha_inicio and tarifaFechasbloqueadas.fecha_final and tarifaFechasbloqueadas.id_tipo_habitacion is null and tarifaFechasbloqueadas.id_tarifa=t.id_tarifa)', 'order'=>'precio'));
				}
			}
			if($maxT > count($tarifa))
			{
				$tarifaCombi=$bloqueo->idTarifa->id_combina;
				$tarifaComb = Tarifa::model()->with('tarifaDiasvalidos')->findAll(array('condition'=>'t.id_tarifa ='.$tarifaCombi.' and id_tipo_plan='.$model->id_tipo_plan.' '.$fecha_promo.' '.$hora.' and precio="'.$tipo_precio.'" and estatus=1 and dia='.date("N",$fechadia).' and "'.$fecha.'" between t.fecha_inicial and t.fecha_final '.$tarifaAgencias.' '.$tarifaEstados.' and not exists(select NULL from tbl_fechas_bloqueadas tarifaFechasbloqueadas where "'.$fecha.'" between tarifaFechasbloqueadas.fecha_inicio and tarifaFechasbloqueadas.fecha_final and tarifaFechasbloqueadas.id_tipo_habitacion is null and tarifaFechasbloqueadas.id_tarifa=t.id_tarifa)', 'order'=>'precio'));
				if(!empty($tarifaComb)){
					$tarifa = (object) array_merge((array) $tarifa, (array) $tarifaComb);
					$combinada = true;
					$combT = $maxT - 1;
				}else{
					$tarifa = (object) array_merge((array) $tarifa, (array) $tarifa);
					$combinada = true;
					$combT = $maxT - 1;
				}
			}
			else if($maxT < count($tarifa)){
				$datos[$dia-1][$maxT] = $datos[$dia-1][$maxT-1];
				if(!empty($menores[$dia-1][$maxT-1]))$menores[$dia-1][$maxT] = $menores[$dia-1][$maxT-1];
				$Total[$maxT]['total'] += $Total[$maxT-1]['total'];
				$Total[$maxT]['total_tc'] += $Total[$maxT-1]['total_tc'];
					
			}

			if(empty($tarifa))
			{
				$result = "Actualmente este hotel no dispone de tarifas para la fecha ".$fecha.". Le sugerimos modificar e intentar de nuevo, o le invitamos a contactar a nuestros ejecutivos vía telefónica o chat para la generación de una cotización.";
			}else if($tarifa && !$roominglist){
					return true;
			
			}else{
				 
				
			
		
		$t = 0;
				
				
				foreach($tarifa as $keytar => $row)
				{
				
					$costoTotal = 0; $costoTotalTC = 0;
					
							
							 
					if($hab->id_tipo_habitacion != NULL)
					{
						
											
							$tarifaDesglose = TarifaDesglose::model()->find('id_tarifa='.$row->id_tarifa.' and id_tipo_habitacion='.$hab->id_tipo_habitacion.' and id_base_habitacion='.$hab->id_base_habitacion.' and '.$hab->num_ninios.' <= max_menores and estatus=1');
							
							if(empty($tarifaDesglose)){
								
									$error = "No se encontró una tarifa de ".$hab->num_adultos." adultos que acepte un máximo numero de menores de ".$hab->num_ninios." para la habitación ".$hab->num_hab;
								throw new CHttpException(400,$error);
								
							}
							$nocheGratis = NochesGratis::model()->find('id_tarifa='.$row->id_tarifa.' and (id_tipo_habitacion is null or id_tipo_habitacion='.$hab->id_tipo_habitacion.')');
							$suplemento = 0;
							if(!empty($nocheGratis) && (($dia+1) % $nocheGratis->noche == 0)){
								if(($dia+1) > $nocheGratis->noche && $nocheGratis->acumulable != 1){
									$nocheGratis = false;
								}else{
									$tarifaDesglose->precio_normal = 0;
									$nocheGratis = true;
								}
							}
							$suplemento = $reservaControl->Sumarsuplemento($row->id_tarifa,$fecha,$tarifaDesglose->id_base_habitacion,'A',NULL);
							$costoAdultos = $tarifaDesglose->precio_normal + $suplemento;
							$costoAdultosTC = $row->tipoCambio($tarifaDesglose->precio_normal) + $row->tipoCambio($suplemento);
							if($suplemento > 0){
								$datos[$dia][$t][$i]['adultos'] = number_format($row->tipoCambio($tarifaDesglose->precio_normal),'2')." + ".number_format($row->tipoCambio($suplemento),'2')." SUP.";
							}else{
								$datos[$dia][$t][$i]['adultos'] = number_format($costoAdultosTC,'2');
							}
							$costoMenores = 0; $costoMenoresTC = 0;
							$menorgratis = 0; $niniopaga = 1;
							$precompraMenor = "fecha_inicio_precompra is null or current_date between fecha_inicio_precompra and fecha_final_precompra";
							for($n=1;$n<=$hab->num_ninios;$n++){ //Ordenar edades menores mayor a menor
								if($hab->Ninio[$n]->edad < $hab->Ninio[$n+1]->edad){
									$aux = $hab->Ninio[$n]->edad;
									$hab->Ninio[$n]->edad = $hab->Ninio[$n+1]->edad;
									$hab->Ninio[$n+1]->edad = $aux; 
									$n=0;
								}
								
								$hab->Ninio[$n] = (object)$hab->Ninio[$n];
							}
							$esjunior=0;
							foreach ($hab->Ninio as $n=>$Ninio) 
							{
								if($n > 0) {
									$tarifaMenor=DesgloseMenores::model()->find("id_tarifa=".$row->id_tarifa." and id_tipo_habitacion=".$hab->id_tipo_habitacion." and ".$Ninio->edad." <= edad_max_menor and num_evaluar=".$niniopaga." and es_junior=0 and(".$precompraMenor.") and(fecha_inicio is null or '".$fecha."' between fecha_inicio and fecha_final) ORDER BY precio ASC");
									if(empty($tarifaMenor)){
										$tarifaMenor=DesgloseMenores::model()->find("id_tarifa=".$row->id_tarifa." and id_tipo_habitacion=".$hab->id_tipo_habitacion." and ".$Ninio->edad." between edad_min_menor and edad_max_menor and es_junior=1 and(".$precompraMenor.") and(fecha_inicio is null or '".$fecha."' between fecha_inicio and fecha_final) ORDER BY precio ASC");
										if(empty($tarifaMenor)){
											if(count($tarifa) > 1 && count($ocultaT) < count($tarifa)){
												$ocultaT[$t] = true;
											}else{
												$error = "El menor con edad ".$Ninio->edad." de la habitación ".$i." no tiene una tarifa definida para la fecha ".$fecha;
											}
											break;
										}
									}
									if($tarifaMenor->es_junior != 1)$niniopaga++;
									else $esjunior++;
							
									$tarifasJunior=PromocionJunior::model()->find('id_bloqueo='.$model->id_bloqueo.' and id_tarifa='.$tarifaMenor->id_tarifa.' and estatus=1');
									if (!$tarifasJunior)
								 	$tarifasJunior=in_array($tarifaMenor->id_tarifa,array(42449,40171,39852));
									if ($esjunior==2 && $tarifasJunior){
										$tarifaMenor->precio=0;
										
									}
									if($Ninio->edad < $tarifaMenor->edad_min_menor || $nocheGratis == true)$tarifaMenor->precio = 0;
									$suplemento = $reservaControl->Sumarsuplemento($row->id_tarifa,$fecha,0,'N',$Ninio->edad);
									$precioMenor = $tarifaMenor->precio + $suplemento;
									$costoMenores += $precioMenor;
									$precioMenorTC = $row->tipoCambio($tarifaMenor->precio) + $row->tipoCambio($suplemento);
									$costoMenoresTC += $precioMenorTC;
									$menores[$dia][$t][$i] .= "Menor ".$n.": $ ".number_format($precioMenorTC,'2','.',',')." / ";
								}
							}
							$datos[$dia][$t][$i]['menores'] = number_format($costoMenoresTC,'2','.',',');
							$costoHabitacion = $costoAdultos + $costoMenores;
							$costoTotal += $costoHabitacion;
							$costoHabitacionTC = $costoAdultosTC + $costoMenoresTC;
							$costoTotalTC += $costoHabitacionTC;
							$datos[$dia][$t][$i]['fecha'] = implode("-", array_reverse(explode("-", $fecha)));
							$datos[$dia][$t][$i]['total'] = number_format($costoHabitacionTC,'2','.',',');
							$minNoches = MinNoches::model()->find('id_tarifa='.$row->id_tarifa.' and id_tipo_habitacion='.$tarifaDesglose->id_tipo_habitacion.' and "'.$fecha.'" between fecha_inicio and fecha_final');
							if(!empty($minNoches) && $minNoches->minimo > $Total[$t]['min_noches']){
								$Total[$t]['min_noches'] = $minNoches->minimo;
							}else if($row->min_noches > $Total[$t]['min_noches']){
								$Total[$t]['min_noches'] = $row->min_noches;
							}
							$habs++;
						}
						
						if($combinada == true && $Total[$t]['codigo'] != $row->codigo)
						{
							if(strpos($Total[$t]['nombre'], $row->nombre_tarifa) === FALSE){
								$Total[$t]['nombre'] .= " + ".$row->nombre_tarifa;
							}
							if($row->restricciones != ""){
								$Total[$t]['restricciones'] .= "<br><br>Otras Restricciones: ".$row->restricciones;
							}
							$Total[$t]['codigo'] = $row->codigo;
						}
						else{
							if(empty($Total[$t]['tarifa']))$Total[$t]['tarifa'][$keytar] = $row->id_tarifa;
							$Total[$t]['nombre'] = $row->precio." ".$row->nombre_tarifa;
							if($row->restricciones != "" && "<p>".$row->restricciones."</p>" != $Total[$t]['restricciones'])
								$Total[$t]['restricciones'] .= "<p>".$row->restricciones."</p>";
							$Total[$t]['moneda'] = $row->mostrar_conversion == 0 ? $row->moneda:'MXN';
							$Total[$t]['codigo'] = $row->codigo;
						}
						$Total[$t]['total'] += $costoTotal;
						$Total[$t]['total_tc'] += $costoTotalTC;
						$t++;
						if($maxT < $t) $maxT = $t;
					
					
				}
				$result=array(
					'error'=>$error,
					'oculta'=>$ocultaT,
					'tarifas'=>$maxT,
					'noches'=>$model->num_noches,
					'habs'=>$model->num_habitaciones,
					'resul'=>$datos,
					'menores'=>$menores,
					'total'=>$Total
				);
					
			}
		}
		return $result;
		

	}
	/*public function actionApartarHabitacion($id)
	{
		$habs = $_POST['habitaciones'];
		$criteria = new CDbCriteria;
		$criteria->condition = 'id_bloqueo=' . $id . ' and id_agencia is null';
		$criteria->limit = $habs;
		$model = Roominglist::model()->findAll($criteria);
		foreach ($model as $val) {
			$val->id_agencia = $_POST['id_agencia'];
			$val->estatus = "ND";
			if (!$val->save())
				echo CJSON::encode($model->getErrors());
		}
		echo CJSON::encode($model);
	}*/
	public function actionApartarHabitacion($id)
	{
		$criteria = new CDbCriteria;
		$criteria->condition = 'id_bloqueo=' . $id . ' and id_agencia is null';
		$criteria->limit = $_POST['habitaciones'];
		$model = Roominglist::model()->findAll($criteria);
		$habs=array();
		foreach ($model as $val) {
			array_push($habs, $val->habitacion);
		}

		if(isset($_POST['id_agencia'])){
			
			$agencia = Agencias::model()->findByPk($_POST['id_agencia']);
			foreach($habs as $row)
			{
				$roominglist = Roominglist::model()->find('habitacion='.$row.' and id_bloqueo='.$id);
				if(empty($roominglist))
				{					
					$roominglist = new Roominglist;
					$roominglist->habitacion = $row;
					$roominglist->id_bloqueo = $id;
				} 

				else if(!empty($roominglist->id_agencia)){
					throw new CHttpException(400,'La habitación '.$row.' ya está apartada. Por favor, seleccione otra habitación.');
				}
				$modelAux=CJSON::decode(CJSON::encode($roominglist));
				//checar si ya fue apartada
				if($_SESSION['tipoUsuario'] == "Agencia"):
				$apartados = OperacionesLog::model()->findAll('id_operacion_tipo=1 and id_referencia='.$roominglist->id_roominglist.' ORDER BY fecha_log DESC LIMIT 2');
				if(count($apartados) > 0){
					$num_veces = 0;
					foreach($apartados as $log){
						$usuario = Usuarios::model()->findByPk($log->id_usuario);
						if($_POST['id_agencia'] == $usuario->id_agencia){
							$num_veces++;
						}
					}
					if($num_veces > 1 && $roominglist->idBloqueo->tiempo_limite > 24){
						$date1 = new DateTime($apartados[0]->fecha_log);
						$date2 = new DateTime('now');
						$diff = $date2->diff($date1);
						$hours = $diff->h;
						$hours = $hours + ($diff->days*24);
						if($hours < 48){
							throw new CHttpException(400,'La habitación ya fue apartada 2 veces seguidas por su agencia. Debe esperar 48 hrs. para volver a apartarla.');
						}
					}
					else if($num_veces == 1 && $roominglist->idBloqueo->tiempo_limite <= 24){
						throw new CHttpException(400,'Lo sentimos, su agencia no puede volver a apartar esta habitación.');
					}
				}
				endif;
				$agenciaAux=$roominglist->id_agencia;
				$roominglist->id_agencia = $_POST['id_agencia'];
				if($roominglist->idBloqueo->tipo == "BLOQUEO"){
					$roominglist->fecha_limite = date('Y-m-d H:i:s',strtotime('now +'.$roominglist->idBloqueo->tiempo_limite.' hours'));
				}
					$roominglist->fecha_apartado = date('Y-m-d H:i:s');
				$roominglist->estatus = "ND";
				if($roominglist->save()){
				//	$this->roomingLog($agenciaAux,'id_agencia',$roominglist->id_bloqueo,$roominglist->id_roominglist);
					$roominglistDesglose= RoominglistDesglose::model()->findAll('id_roominglist='.$roominglist->id_roominglist);
					if ($roominglistDesglose) {
						$roominglistDesglose= RoominglistDesglose::model()->deleteAll('id_roominglist='.$roominglist->id_roominglist);
						
					}
					$notificar = Usuarios::model()->findAll('aviso LIKE "%h%"');
					foreach($notificar as $user){
						$notificacion = new Notificacion;
						$notificacion->id_item = $roominglist->id_roominglist;
						$notificacion->tipo = 3;
						$notificacion->id_users = $user->id_usuario;
						$notificacion->visto = 0;
						$notificacion->save();
					}
					$operacion=new OperacionesLog;
					$operacion->id_referencia=$roominglist->id_roominglist;
					$operacion->id_operacion_tipo=1;
					$operacion->descripcion="BLOQUEO ".$roominglist->id_bloqueo." Habitación ".$roominglist->habitacion;
					$operacion->id_usuario=Yii::app()->user->id;
					$operacion->save();
					if($roominglist->idBloqueo->tipo == "BLOQUEO"){
						$this->emailAviso($roominglist);
						echo CJSON::encode($roominglist);
					}
						
				}
			}
			
			
		}
	}

	public function actionListaBloqueos()
	{
		$criteria = new CDbCriteria();
		$criteria->addCondition('tipo="BLOQUEO"');
		$criteria->addCondition('t.estatus=1 and t.visibilidad = 1');
		$criteria->addCondition('precio_normal > 0');
		$criteria->addCondition('current_date<=t.fecha_inicio');
		$criteria->addCondition('idTarifa.precio!="BODA"');
		$criteria->addCondition('tarifaDesgloses.id_base_habitacion=2');
		$criteria->addCondition('tarifaDesgloses.id_tipo_habitacion=t.id_tipo_habitacion');

		$model_bloqueo = Bloqueos::model()->with('idTarifa', 'idHotel', 'tarifaDesgloses')->findAll($criteria);
		$array_aux_bloqueo = array();
		foreach ($model_bloqueo as $key => $data) {
			$apartadas = count(Roominglist::model()->findAll('id_bloqueo=' . $data->id_bloqueo . ' and (id_agencia is not null and id_reservacion is null)'));
			$reservadas = count(Roominglist::model()->findAll('id_bloqueo=' . $data->id_bloqueo . ' and (id_reservacion is not null)'));
			$libres = ($data->numero_habitaciones - $apartadas) - $reservadas;

			$model_tarifas = Tarifa::model()->find('id_tarifa=' . $data['id_tarifa']);
			$model_foto = HotelesFotos::model()->find('id_hotel=' . $data['id_hotel'] . ' and principal=1');
			$model_fotoLogo = HotelesFotos::model()->find('id_hotel=' . $data['id_hotel'] . ' and logotipo=1');
			$model_hotel = Hoteles::model()->find('id_hotel=' . $data['id_hotel']);
			$model_tipo_plan = TipoPlan::model()->find('id_tipo_plan=' . $data['id_tipo_plan']);
			$model_habitacion = TipoHabitaciones::model()->find('id_tipo_habitacion=' . $data['id_tipo_habitacion']);
			$date_now = date("Y-m-d", strtotime(date("d-m-Y")));
			$date_a_comparar =  $data->fecha_final;


			if ($libres == 0) {
				unset($data[$key]);
			} else {
				if ($date_now < $date_a_comparar) {
					array_push($array_aux_bloqueo, array(
						"id_bloqueo" => $data->id_bloqueo,
						"Estrellas" => $model_hotel->estrellas,
						"id_tarifa" => $model_tarifas->id_tarifa,
						"tipo" => $data->tipo,
						"logotipo" => $model_fotoLogo->foto,
						"id_hotel" => $data->id_hotel,
						"foto_principal" => $model_foto->foto,
						"hotel_nombre" => $data->idHotel->nombre_hotel,
						"precio_doble" => $data->tarifaDesgloses->precio_normal,
						"tipo_habitacion" => $model_habitacion->tipo_habitacion,
						"fecha_inicio" => $data->fecha_inicio,
						"fecha_final" => $data->fecha_final,
						"estatus" => $data->estatus,
						"tipo_moneda" => $data->idTarifa->moneda,
						"tipo_plan" => $model_tipo_plan->nombre,
						"titulo_bloqueo" => $data->titulo,
						"id_base_habitacion" => $data->tarifaDesgloses->id_base_habitacion,
						"visibilidad" => $data->visibilidad,
						"hab_disponibles" => $libres
					));
				} else {
					unset($data[$key]);
				}
			}
		}

		echo CJSON::encode($array_aux_bloqueo);
	}
	public function actionGetLista($id = null)
	{
		header('Access-Control-Allow-Origin: *');
		header("Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept");
		header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE');
		$criteria = new CDbCriteria();
		if ($id != null) {
			$criteria->addCondition('id_bloqueo = "' . $id . '"');
		}
		$criteria->addCondition('tipo="BLOQUEO"');
		$criteria->addCondition('t.estatus=1 and t.visibilidad = 1');
		$criteria->addCondition('precio_normal > 0');
		$criteria->addCondition('current_date<=t.fecha_inicio');
		$criteria->addCondition('idTarifa.precio!="BODA"');
		$criteria->addCondition('tarifaDesgloses.id_base_habitacion=2');
		$criteria->addCondition('tarifaDesgloses.id_tipo_habitacion=t.id_tipo_habitacion');
		$criteria->order = 't.fecha_inicio ASC';

		$model = Bloqueos::model()->with('idTarifa', 'idHotel', 'tarifaDesgloses')->findAll($criteria);

		$agenciaUsuario = (!empty($_SESSION['agenciaUsuario'])) ? $_SESSION['agenciaUsuario'] : 9;
		$sqlHistorial = "SELECT rg.id_bloqueo, COUNT(*) as apartadas FROM `tbl_roominglist` rg INNER JOIN tbl_bloqueos b USING(id_bloqueo) INNER JOIN tbl_tarifa idTarifa ON b.id_tarifa=idTarifa.id_tarifa WHERE rg.id_agencia=".$agenciaUsuario." AND b.tipo='BLOQUEO' AND b.estatus=1 and b.visibilidad = 1 AND idTarifa.precio!='BODA' AND current_date>=b.fecha_inicio GROUP BY rg.id_bloqueo";
		$response_historial=Yii::app()->db->createCommand($sqlHistorial)->queryAll();

		$historial = array();
		foreach ($response_historial as $row => $val) {
			$apartadas_historial = $val['apartadas'];

			$find_bloqueo = Bloqueos::model()->findByPk($val['id_bloqueo']);

			$tarifas = Tarifa::model()->find('id_tarifa=' . $find_bloqueo->id_tarifa);
			$foto = HotelesFotos::model()->find('id_hotel=' . $find_bloqueo->id_hotel . ' and principal=1');
			$fotoLogo = HotelesFotos::model()->find('id_hotel=' . $find_bloqueo->id_hotel . ' and logotipo=1');
			$estrellasHotel = Hoteles::model()->find('id_hotel=' . $find_bloqueo->id_hotel);
			$plan = TipoPlan::model()->find('id_tipo_plan=' . $find_bloqueo->id_tipo_plan);
			$habitacion = TipoHabitaciones::model()->find('id_tipo_habitacion=' . $find_bloqueo->id_tipo_habitacion);
			$tarifaDesgloses = TarifaDesglose::model()->find('id_base_habitacion=2 AND id_tipo_habitacion='.$find_bloqueo->id_tipo_habitacion);
			$date_now = date("Y-m-d", strtotime(date("d-m-Y")));
			$date_a_comparar =  $data->fecha_final;

			if ($estrellasHotel->id_categoria!=NULL || $estrellasHotel->id_categoria!='') {
				$estrellas_categoria = $estrellasHotel->id_categoria;
			}else{
				$estrellas_categoria = $estrellasHotel->estrellas;
			}
			array_push($historial, array(
				"id_bloqueo" => $val["id_bloqueo"],
				"Estrellas" => $estrellas_categoria,
				"id_tarifa" => $tarifas->id_tarifa,
				"tipo" => $find_bloqueo->tipo,
				"logotipo" => $fotoLogo->foto,
				"id_hotel" => $find_bloqueo->id_hotel,
				"foto_principal" => $foto->foto,
				"hotel_nombre" => $find_bloqueo->idHotel->nombre_hotel,
				"precio_doble" => $tarifaDesgloses->precio_normal,
				"tipo_habitacion" => $habitacion->tipo_habitacion,
				"fecha_inicio" => $find_bloqueo->fecha_inicio,
				"fecha_final" => $find_bloqueo->fecha_final,
				"estatus" => $find_bloqueo->estatus,
				"tipo_moneda" => $find_bloqueo->idTarifa->moneda,
				"tipo_plan" => $plan->nombre,
				"titulo_bloqueo" => $find_bloqueo->titulo,
				"id_base_habitacion" => $tarifaDesgloses->id_base_habitacion,
				"visibilidad" => $find_bloqueo->visibilidad,
				"hab_disponibles" => 0,
				"hab_apartadas"=>$apartadas_historial
			));
		}

		// $model_agencia = Bloqueos::model()->with('idTarifa', 'idHotel', 'tarifaDesgloses')->findAll('tipo="BLOQUEO" AND t.estatus=1 AND t.visibilidad = 1 AND current_date<=t.fecha_inicio AND idTarifa.precio!="BODA" AND id_agencia=92');

		$item = array();
			
		foreach ($model as $key => $data) {
			$apartadas = count(Roominglist::model()->findAll('id_bloqueo=' . $data->id_bloqueo . ' and (id_agencia is not null and id_reservacion is null)'));
			$reservadas = count(Roominglist::model()->findAll('id_bloqueo=' . $data->id_bloqueo . ' and (id_reservacion is not null)'));
			$libres = ($data->numero_habitaciones - $apartadas) - $reservadas;

			if (!empty($_SESSION['agenciaUsuario'])) {
				$apartadas_agencias = count(Roominglist::model()->findAll('id_bloqueo=' . $data->id_bloqueo . ' and id_agencia='.$_SESSION['agenciaUsuario'].' and id_reservacion is null'));
				// $apartadas_agencias = count(Roominglist::model()->findAll('id_bloqueo=' . $data->id_bloqueo . ' and id_agencia=92 and id_reservacion is null'));
			}

			$tarifas = Tarifa::model()->find('id_tarifa=' . $data['id_tarifa']);
			$foto = HotelesFotos::model()->find('id_hotel=' . $data['id_hotel'] . ' and principal=1');
			$fotoLogo = HotelesFotos::model()->find('id_hotel=' . $data['id_hotel'] . ' and logotipo=1');
			$estrellasHotel = Hoteles::model()->find('id_hotel=' . $data['id_hotel']);
			$plan = TipoPlan::model()->find('id_tipo_plan=' . $data['id_tipo_plan']);
			$habitacion = TipoHabitaciones::model()->find('id_tipo_habitacion=' . $data['id_tipo_habitacion']);
			$date_now = date("Y-m-d", strtotime(date("d-m-Y")));
			$date_a_comparar =  $data->fecha_final;
			$datosHotelCriteria = new CDbCriteria();
			$datosHotelCriteria->addCondition('id_hotel=' . $data->id_hotel);
			$datosHotelCriteria->select = "observaciones,id_hotel,nombre_hotel";
			$hotelDatos = Hoteles::model()->find($datosHotelCriteria);
			$destino = Destinations::model()->find('code ="' . $data->idHotel->Destino->destinationsCode . '"');
			$fotosHotel = HotelesFotos::model()->findAll('id_hotel=' . $data->id_hotel . ' and principal=0 and logotipo=0');

			if ($libres == 0) {
				unset($model[$key]);
			} else {
				if ($date_now < $date_a_comparar) {
					if ($estrellasHotel->id_categoria!=NULL || $estrellasHotel->id_categoria!='') {
						$estrellas_categoria = $estrellasHotel->id_categoria;
					}else{
						$estrellas_categoria = $estrellasHotel->estrellas;
					}
					array_push($item, array(
						"id_bloqueo" => $data->id_bloqueo,
						"Estrellas" => $estrellas_categoria,
						"id_tarifa" => $tarifas->id_tarifa,
						"tipo" => $data->tipo,
						"logotipo" => $fotoLogo->foto,
						"id_hotel" => $data->id_hotel,
						"foto_principal" => $foto->foto,
						"hotel_nombre" => $data->idHotel->nombre_hotel,
						"precio_doble" => $data->tarifaDesgloses->precio_normal,
						"tipo_habitacion" => $habitacion->tipo_habitacion,
						"fecha_inicio" => $data->fecha_inicio,
						"fecha_final" => $data->fecha_final,
						"estatus" => $data->estatus,
						"tipo_moneda" => $data->idTarifa->moneda,
						"tipo_plan" => $plan->nombre,
						"titulo_bloqueo" => $data->titulo,
						"id_base_habitacion" => $data->tarifaDesgloses->id_base_habitacion,
						"visibilidad" => $data->visibilidad,
						"hab_disponibles" => $libres,
						"hab_apartadas"=>$apartadas_agencias,
						"fotos" => $fotosHotel,
						"destinos" => $destino->name,
						"datosHotel" => $hotelDatos
					));
				} else {
					unset($model[$key]);
				}
			}
		}
		echo CJSON::encode(array('item'=>$item,'historial'=>$historial));
		// echo CJSON::encode($item);
	}
	public function actionGetNoDisponibles()
	{
		header('Access-Control-Allow-Origin: *');
		header("Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept");
		header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE');
		$criteria = new CDbCriteria();
		$criteria->addCondition('tipo="BLOQUEO"');
		$criteria->addCondition('t.estatus=1 and t.visibilidad = 1');
		$criteria->addCondition('precio_normal > 0');
		$criteria->addCondition('current_date<=t.fecha_inicio');
		$criteria->addCondition('idTarifa.precio!="BODA"');
		$criteria->addCondition('tarifaDesgloses.id_base_habitacion=2');
		$criteria->addCondition('tarifaDesgloses.id_tipo_habitacion=t.id_tipo_habitacion');

		$model = Bloqueos::model()->with('idTarifa', 'idHotel', 'tarifaDesgloses')->findAll($criteria);

		$item = array();
		foreach ($model as $key => $data) {
			
			$apartadas = count(Roominglist::model()->findAll('id_bloqueo=' . $data->id_bloqueo . ' and (id_agencia is not null and id_reservacion is null)'));
			$reservadas = count(Roominglist::model()->findAll('id_bloqueo=' . $data->id_bloqueo . ' and (id_reservacion is not null)'));
			$libres = ($data->numero_habitaciones - $apartadas) - $reservadas;

			$model_tarifas = Tarifa::model()->find('id_tarifa=' . $data['id_tarifa']);
			$model_foto = HotelesFotos::model()->find('id_hotel=' . $data['id_hotel'] . ' and principal=1');
			$model_fotoLogo = HotelesFotos::model()->find('id_hotel=' . $data['id_hotel'] . ' and logotipo=1');
			$model_hotel = Hoteles::model()->find('id_hotel=' . $data['id_hotel']);
			$model_tipo_plan = TipoPlan::model()->find('id_tipo_plan=' . $data['id_tipo_plan']);
			$model_habitacion = TipoHabitaciones::model()->find('id_tipo_habitacion=' . $data['id_tipo_habitacion']);
			$date_now = date("Y-m-d", strtotime(date("d-m-Y")));
			$date_a_comparar =  $data->fecha_final;

			// if ($date_now < $date_a_comparar) {
			if (!$libres) {
				array_push($item, array(
				
					"id_bloqueo" => $data->id_bloqueo,
					"Estrellas" => $model_hotel->estrellas,
					"id_tarifa" => $model_tarifas->id_tarifa,
					"tipo" => $data->tipo,
					"logotipo" => $model_fotoLogo->foto,
					"id_hotel" => $data->id_hotel,
					"foto_principal" => $model_foto->foto,
					"hotel_nombre" => $data->idHotel->nombre_hotel,
					"precio_doble" => $data->tarifaDesgloses->precio_normal,
					"tipo_habitacion" => $model_habitacion->tipo_habitacion,
					"fecha_inicio" => $data->fecha_inicio,
					"fecha_final" => $data->fecha_final,
					"estatus" => $data->estatus,
					"tipo_moneda" => $data->idTarifa->moneda,
					"tipo_plan" => $model_tipo_plan->nombre,
					"titulo_bloqueo" => $data->titulo,
					"id_base_habitacion" => $data->tarifaDesgloses->id_base_habitacion,
					"visibilidad" => $data->visibilidad,
					"hab_disponibles" => $libres,
					"hab_apartadas" => $apartadas_agencias
			
				));
			}
			
			// }else{
			// 	unset($model[$key]);
			// }

		}
		echo CJSON::encode($item);
	}
	public function actionHabitacionesApartadas()
	{
		header('Access-Control-Allow-Origin: *');
		header("Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept");
		header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE');
		$criteria = new CDbCriteria();
		$criteria->addCondition('tipo="BLOQUEO"');
		$criteria->addCondition('t.estatus=1 and t.visibilidad = 1');
		$criteria->addCondition('precio_normal > 0');
		$criteria->addCondition('current_date<=t.fecha_inicio');
		$criteria->addCondition('idTarifa.precio!="BODA"');
		$criteria->addCondition('tarifaDesgloses.id_base_habitacion=2');
		$criteria->addCondition('tarifaDesgloses.id_tipo_habitacion=t.id_tipo_habitacion');

		$model = Bloqueos::model()->with('idTarifa', 'idHotel', 'tarifaDesgloses')->findAll($criteria);

		$item = array();
		foreach ($model as $key => $data) {
			if (!empty($_SESSION['agenciaUsuario'])) {
				$apartadas_agencias = count(Roominglist::model()->findAll('id_bloqueo=' . $data->id_bloqueo . ' and id_agencia='.$_SESSION['agenciaUsuario'].' and id_reservacion is null'));
			}
			$apartadas = count(Roominglist::model()->findAll('id_bloqueo=' . $data->id_bloqueo . ' and (id_agencia is not null and id_reservacion is null)'));
			$reservadas = count(Roominglist::model()->findAll('id_bloqueo=' . $data->id_bloqueo . ' and (id_reservacion is not null)'));
			$model_tarifas = Tarifa::model()->find('id_tarifa=' . $data['id_tarifa']);
			$model_foto = HotelesFotos::model()->find('id_hotel=' . $data['id_hotel'] . ' and principal=1');
			$model_fotoLogo = HotelesFotos::model()->find('id_hotel=' . $data['id_hotel'] . ' and logotipo=1');
			$model_hotel = Hoteles::model()->find('id_hotel=' . $data['id_hotel']);
			$model_tipo_plan = TipoPlan::model()->find('id_tipo_plan=' . $data['id_tipo_plan']);
			$model_habitacion = TipoHabitaciones::model()->find('id_tipo_habitacion=' . $data['id_tipo_habitacion']);
			$date_now = date("Y-m-d", strtotime(date("d-m-Y")));
			$date_a_comparar =  $data->fecha_final;

			// if ($date_now < $date_a_comparar) {
			array_push($item, array(
				
					"id_bloqueo" => $data->id_bloqueo,
					"Estrellas" => $model_hotel->estrellas,
					"id_tarifa" => $model_tarifas->id_tarifa,
					"tipo" => $data->tipo,
					"logotipo" => $model_fotoLogo->foto,
					"id_hotel" => $data->id_hotel,
					"foto_principal" => $model_foto->foto,
					"hotel_nombre" => $data->idHotel->nombre_hotel,
					"precio_doble" => $data->tarifaDesgloses->precio_normal,
					"tipo_habitacion" => $model_habitacion->tipo_habitacion,
					"fecha_inicio" => $data->fecha_inicio,
					"fecha_final" => $data->fecha_final,
					"estatus" => $data->estatus,
					"tipo_moneda" => $data->idTarifa->moneda,
					"tipo_plan" => $model_tipo_plan->nombre,
					"titulo_bloqueo" => $data->titulo,
					"id_base_habitacion" => $data->tarifaDesgloses->id_base_habitacion,
					"visibilidad" => $data->visibilidad,
					"hab_disponibles" => $libres,
					"hab_apartadas" => $apartadas_agencias
			
			));
			// }else{
			// 	unset($model[$key]);
			// }

		}
		echo CJSON::encode($item);
	}
	public function actionGetBloqueo($id)
	{
		header('Access-Control-Allow-Origin: *');

		$criteria = new CDbCriteria();
		$criteria->addCondition('tipo="BLOQUEO"');
		$criteria->addCondition('t.estatus=1 and visibilidad = 1');
		$criteria->addCondition('current_date<=t.fecha_inicio');
		$criteria->addCondition('idTarifa.precio!="BODA"');
		$criteria->addCondition('tarifaDesgloses.id_base_habitacion=2');
		$criteria->addCondition('tarifaDesgloses.id_tipo_habitacion=t.id_tipo_habitacion');
		$criteria->addCondition('id_bloqueo=' . $id);



		$model = Bloqueos::model()->with('idTarifa', 'idHotel', 'tarifaDesgloses')->findAll($criteria);

		$item = array();
		foreach ($model as $key => $data) {
			$apartadas = count(Roominglist::model()->findAll('id_bloqueo=' . $data->id_bloqueo . ' and (id_agencia is not null and id_reservacion is null)'));
			$reservadas = count(Roominglist::model()->findAll('id_bloqueo=' . $data->id_bloqueo . ' and (id_reservacion is not null)'));

			$libres = $data->numero_habitaciones - $apartadas - $reservadas;
			if ($libres == 0) {

				unset($model[$key]);
			}

			$tarifas = Tarifa::model()->find('id_tarifa=' . $data['id_tarifa']);
			$foto = HotelesFotos::model()->find('id_hotel=' . $data['id_hotel'] . ' and principal=1');

			$fotoLogo = HotelesFotos::model()->find('id_hotel=' . $data['id_hotel'] . ' and logotipo=1');
			$estrellasHotel = Hoteles::model()->find('id_hotel=' . $data['id_hotel']);

			$plan = TipoPlan::model()->find('id_tipo_plan=' . $data['id_tipo_plan']);
			$habitacion = TipoHabitaciones::model()->find('id_tipo_habitacion=' . $data['id_tipo_habitacion']);
			$menores = DesgloseMenores::model()->find('id_tarifa=' . $data['id_tarifa']);


			$item[$key]["id_bloqueo"] = $data->id_bloqueo;
			$item[$key]["Estrellas"] = $estrellasHotel->id_categoria;
			$item[$key]["descripcion_hotel"] = $estrellasHotel->observaciones;
			$item[$key]["ubicacion_hotel"] = $estrellasHotel->ubicacion;
			$item[$key]["id_tarifa"] = $tarifas->id_tarifa;
			$item[$key]["tipo_Precio"] = $data->idTarifa->precio;
			$item[$key]["tipo"] = $data->tipo;
			$item[$key]["logotipo"] = $fotoLogo->foto;
			$item[$key]["id_hotel"] = $data->id_hotel;
			$item[$key]["foto_principal"]  = $foto->foto;
			$item[$key]["hotel_nombre"] = $data->idHotel->nombre_hotel;
			$item[$key]["precio_doble"] = $data->tarifaDesgloses->precio_normal;
			// $item[$key]["id_tipo_habitacion"] = $data->tarifaDesgloses->id_tipo_habitacion;
			$item[$key]["tipo_habitacion"] = $habitacion->tipo_habitacion;
			$item[$key]["fecha_inicio"]  = $data->fecha_inicio;
			$item[$key]["fecha_final"]  = $data->fecha_final;
			$item[$key]["estatus"] = $data->estatus;
			$item[$key]["tipo_moneda"] = $data->idTarifa->moneda;
			// $item[$key]["id_tipo_plan"] = $plan->id_tipo_plan;						 
			$item[$key]["tipo_plan"] = $plan->nombre;
			$item[$key]["titulo_bloqueo"] = $data->titulo;
			$item[$key]["id_base_habitacion"] = $data->tarifaDesgloses->id_base_habitacion;
			$item[$key]["visibilidad"] = $data->visibilidad;
			$item[$key]["hab_disponibles"] = $libres;
			$item[$key]["edad_max_menor"] = $menores->edad_max_menor;
			$item[$key]["edad_min_menor"] = $menores->edad_min_menor;
			$item[$key]["num_menores_gratis"] = $menores->num_menores_gratis;
		}




		//	echo CJSON::encode($model);
		echo CJSON::encode($item);
	}
	private function emailAviso($hab)
	{
		$encabezados  = "MIME-Version: 1.0\n";
		$encabezados .= "Content-type: text/html; charset=UTF-8\n";
		$encabezados .= "From:  Ruta Maya Travel <no-reply@rutamayatravel.com>\n";
		$encabezados .= "X-Sender: <contacto web>\n";
		$encabezados .= "X-Mailer: PHP\n";
		$encabezados .= "X-Priority: 3\n";
		$encabezados .= "Return-Path: <web page>\n";
		$log = OperacionesLog::model()->find('id_referencia='.$hab->id_roominglist.' and id_operacion_tipo=1 ORDER BY fecha_log DESC');
		$recipent_email = $log->idUsuario->email;
		$recipent_name = $log->idUsuario->profiles->firstname;
		if($hab->id_agencia != NULL){
			if(isset($_POST['fecha_limite'])){
				$subject = "Fecha Límite de Habitación Asignada";
				$message = "<div align='center' width='400' style='border:1px solid black'>
								<img src='https://".$_SERVER['SERVER_NAME']."".Yii::app()->baseUrl."/images/logo_rutamaya.jpg'>
								<p>Fecha: ".date('d/m/Y')."</p>
								<h4>SU HABITACIÓN CON ANTICIPO TIENE FECHA LÍMITE DE ".date('d/m/Y',strtotime($hab->fecha_limite))."</h4><hr>
								<p>La habitación #".$hab->habitacion." del bloqueo de ".$hab->idBloqueo->idHotel->nombre_hotel." del ".date('d/m/Y',strtotime($hab->idBloqueo->fecha_inicio))." al ".date('d/m/Y',strtotime($hab->idBloqueo->fecha_final))." 
								reservada el dia ".date('d/m/Y H:i:s',strtotime($log->fecha_log))." y con anticipo, tiene una nueva fecha límite de <b>".date('d/m/Y',strtotime($hab->fecha_limite))."</b> para liquidar su saldo pendiente.</p>
								<p><a href='https://".$_SERVER['SERVER_NAME']."".Yii::app()->baseUrl."/bloqueos/view/id/".$hab->id_bloqueo."'>Ir al Bloqueo</a></p>
								<h4>SI TIENES ALGUNA DUDA CONTÁCTANOS, CON GUSTO TE ASESORAREMOS</h4>
								<h4>Atentamente el equipo de Ruta Maya Travel</h4>
							</div>";
			}else if(isset($_POST['Bloqueos']['tiempo_limite'])){
				$subject = "Tiempo Limite de Bloqueo ha Cambiado";
				$message = "<div align='center' width='400' style='border:1px solid black'>
								<img src='https://".$_SERVER['SERVER_NAME']."".Yii::app()->baseUrl."/images/logo_rutamaya.jpg'>
								<p>Fecha: ".date('d/m/Y')."</p>
								<h4>EL TIEMPO LIMITE DE APARTADO DE NUEVAS HABITACIONES HA CAMBIADO</h4><hr>
								<p>El bloqueo de ".$hab->idBloqueo->idHotel->nombre_hotel." del ".date('d/m/Y',strtotime($hab->idBloqueo->fecha_inicio))." al ".date('d/m/Y',strtotime($hab->idBloqueo->fecha_final))." 
								tiene un nuevo tiempo límite de apartado de habitación asignado de ".$hab->idBloqueo->tiempo_limite." horas aprox. Esto no afecta a las habitaciones apartadas anteriormente por usted o su agencia, solo aplica para nuevos apartados posteriores a este cambio.</p>
								<p><a href='https://".$_SERVER['SERVER_NAME']."".Yii::app()->baseUrl."/bloqueos/view/id/".$hab->id_bloqueo."'>Ir al Bloqueo</a></p>
								<h4>SI TIENES ALGUNA DUDA CONTÁCTANOS, CON GUSTO TE ASESORAREMOS</h4>
								<h4>Atentamente el equipo de Ruta Maya Travel</h4>
							</div>";
			}else{
				$fecha_inicio = strtotime($log->fecha_log);
				if (!$hab->fecha_limite) {
					$fecha_final=strtotime(date('Y-m-d H:i:s').'+ 48 hours');		
				}else{
					$fecha_final=strtotime($hab->fecha_limite);
				}
				
				$horas = ceil(abs($fecha_final - $fecha_inicio) / 3600);
				$subject = "Aviso de Apartado de Habitación";
				$message = "<div align='center' width='400' style='border:1px solid black'>
								<img src='https://".$_SERVER['SERVER_NAME']."".Yii::app()->baseUrl."/images/logo_rutamaya.jpg'>
								<p>Fecha: ".date('d/m/Y')."</p>
								<h4>SU HABITACIÓN APARTADA TIENE TIEMPO LÍMITE DE ".$horas." HORAS</h4><hr>
								<p>La habitación #".$hab->habitacion." del bloqueo de ".$hab->idBloqueo->idHotel->nombre_hotel." del ".date('d/m/Y',strtotime($hab->idBloqueo->fecha_inicio))." al ".date('d/m/Y',strtotime($hab->idBloqueo->fecha_final))." 
								reservada el dia ".date('d/m/Y H:i:s',strtotime($log->fecha_log))." tiene un tiempo límite de apartado de ".$horas." horas aprox. Si durante este plazo no se genera un anticipo o cupón de reservación la habitación será desapartada por el sistema y se le notificará.</p>
								<p><a href='https://".$_SERVER['SERVER_NAME']."".Yii::app()->baseUrl."/bloqueos/view/id/".$hab->id_bloqueo."'>Ir al Bloqueo</a></p>
								<p>IMPORTANTE: Los pagos realizados se veran reflejados despues de 48 hrs de haberse realizado, para ello es indispensable enviar el comprobante de depósito a contabilidad@rutamayatravel.com</p>
								<h4>SI TIENES ALGUNA DUDA CONTÁCTANOS, CON GUSTO TE ASESORAREMOS</h4>
								<h4>Atentamente el equipo de Ruta Maya Travel</h4>
							</div>";
			}
		}else{
			$subject = "Su Apartado de Habitación ha Vencido";
			$message = "<div align='center' width='400' style='border:1px solid black'>
							<img src='https://".$_SERVER['SERVER_NAME']."".Yii::app()->baseUrl."/images/logo_rutamaya.jpg'>
							<p>Fecha: ".date('d/m/Y')."</p>
							<h4>SU HABITACIÓN HA SIDO DESAPARTADA POR EL SISTEMA DE RESERVACIONES DE RUTA MAYA</h4><hr>
							<p>La habitación #".$hab->habitacion." del bloqueo de ".$hab->idBloqueo->idHotel->nombre_hotel." del ".date('d/m/Y',strtotime($hab->idBloqueo->fecha_inicio))." al ".date('d/m/Y',strtotime($hab->idBloqueo->fecha_final))."
							fue desapartada por nuestro sistema debido a que el periodo de apartado ha vencido.</p>
							<p>Puede volver a apartar esta habitación siguiendo este link: <a href='https://".$_SERVER['SERVER_NAME']."".Yii::app()->baseUrl."/bloqueos/view/id/".$hab->id_bloqueo."'>Ir al Bloqueo</a><br/>
							ó contacte a uno de nuestros agentes para más información.</p>
							<h4>SI TIENES ALGUNA DUDA CONTÁCTANOS, CON GUSTO TE ASESORAREMOS</h4>
							<h4>Atentamente el equipo de Ruta Maya Travel</h4>
						</div>";
		}
		$mail = new JPhpMailer;
		$mail->IsSMTP();
		$mail->Host = 'rutamayatravel.com'; 
		$mail->SMTPAuth = true;
		$mail->Username = 'no-reply@rutamayatravel.com'; 
		$mail->Port = '26'; 
		$mail->Password = 'Intelred76'; 
		$mail->SMTPKeepAlive = true;  
		$mail->Mailer = "smtp"; 
		$mail->IsSMTP();  
		$mail->SMTPAuth = true;  
		$mail->CharSet = 'utf-8';  
		$mail->SMTPDebug  = 0;
		$mail->SetFrom('no-reply@rutamayatravel.com', 'Sistema Ruta Maya Travel'); 
		$mail->Subject = $subject; 
		$mail->AltBody = 'To view the message, please use an HTML compatible email viewer!'; 
		$mail->MsgHTML($message);
		if(!empty($hab->id_agencia)){
			if($hab->id_agencia!=9){
				$usuarios = Usuarios::model()->findAll('id_agencia='.$hab->id_agencia.' and estatus="A"');
				foreach($usuarios as $user){
					$mail->AddAddress($user->email_usuario, $user->nombre_usuario);
				}
			}else{
					$mail->AddAddress("grupos@rutamayatravel.com", "Grupos");
					$mail->AddAddress("bloqueos@rutamayatravel.com", "Bloqueos");
			}
		}else{
			$mail->AddAddress($recipent_email, $recipent_name);
		}

		$mail->AddAddress("grupos@rutamayatravel.com", "Grupos");
		$mail->AddAddress("bloqueos@rutamayatravel.com", "Bloqueos");
		$mail->AddAddress('contabilidad@rutamayatravel.com','Contabilidad');
		$mail->AddAddress('soporte@rutamayatravel.com','Soporte');
		$mail->Send();
	}
}
