<?php
class AgenciasController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout = '//layouts/column1';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array(
				'allow',  // allow all users to perform 'index' and 'view' actions
				'actions' => array('EnvioEstadoResultadosAgencia', 'EnvioEstadoResultadosAgenciaTest', 'Api', 'ApiDemo', 'getBannerListaApi','NotificarRegistroTest', 'documentos', 'sendfiles'),
				'users' => array('*'),
			),
			array(
				'allow',  // allow all users to perform 'index' and 'view' actions
				'actions' => array('index', 'view'),
				'users' => array('@'),
			),
			array(
				'allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions' => array('create', 'update', 'GeneratePdf', 'GenerateExcel', 'eliminarPie', 'uploadImage', 'perfil', 'getVentasAgencia', 'getVentasMeses', 'getComparativas', 'UpdateAgenciaCfdi', 'BalanceAgencia', 'registro', 'registroTest', 'LandingPage'),
				'users' => array('@'),
			),
			array(
				'allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions' => array('admin', 'delete'),
				'users' => array('admin'),
			),
			array(
				'deny',  // deny all users
				'users' => array('*'),
			),
		);
	}

	public function actionUploadImage()
	{
		if (is_uploaded_file($_FILES['img']['tmp_name'])) {
			$file_name = $_POST['id_agencia'] . '-' . str_replace(" ", "-", $_FILES['img']['name']);
			switch ($_POST["tipo"]) {
				case 'pie':
					$url_img = $_SERVER['DOCUMENT_ROOT'] . '/medios/flyers/pies_agencias/';
					break;

				case 'logo':
					$url_img = $_SERVER['DOCUMENT_ROOT'] . '/imagenes/';
					break;
			}
			$file_url = $url_img . $file_name;
			if (move_uploaded_file($_FILES['img']['tmp_name'], $file_url)) {
				echo json_encode(array(
					"success" => true,
					"id_agencia" => $_POST['id_agencia'],
				));
			}
		} else {
			echo json_encode(array(
				"success" => false,
			));
		}
	}
	public function actionEliminarPie($id)
	{
		$model = $this->loadModel($id);
		$model->pie_flyer = NULL;
		$model->save();
	}
	public function actionGetBannerListaApi()
	{
		// $this->headerCorsApi();
		$criteria = new CDbCriteria();
		$criteria->addCondition("fecha_final >= '" . date("Y-m-d") . "'");
		// $criteria->addCondition("estatus = 1");
		$banner_list = Banners::model()->findAll($criteria);

		echo CJSON::encode($banner_list);
	}

	public function actionPerfil()
	{
		$this->layout = "//layouts/ansonika_site";
		$modeluser = new Usuarios;
		$this->render("miAgencia", array('modeluser' => $modeluser));
	}

	public function actionLandingPage()
	{
		$agencia = Agencias::model()->findByPk($_POST['id_agencia']);
		$agencia_landing = AgenciasInteresadasOutlet::model()->find('id_agencia=' . $agencia->id_agencia);

		if ($_POST['AgenciasInteresadasOutlet']) {
			if (empty($agencia_landing)) {
				$agencia_landing = new AgenciasInteresadasOutlet;
				$agencia_landing->attributes = $_POST['AgenciasInteresadasOutlet'];
				$agencia_landing->nombre_agencia = $agencia->nombre_agencia;
				$agencia_landing->id_agencia = $_POST['id_agencia'];
			} else {
				$agencia_landing->attributes = $_POST['AgenciasInteresadasOutlet'];
				$agencia_landing->nombre_agencia = $agencia->nombre_agencia;
				$agencia_landing->id_agencia = $_POST['id_agencia'];
			}
			$agencia->webslug = $_POST['AgenciasInteresadasOutlet']['webslug'];
			if ($agencia_landing->save()) {
				$agencia->save();
				echo json_encode(array('success' => true));
			} else {
				print_r($agencia_landing->getErrors());
				echo json_encode(array('success' => false));
			}
		} else {
			echo CJSON::encode(array('agencia' => $agencia, 'outlet' => $agencia_landing));
		}
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view', array(
			'model' => $this->loadModel($id),
		));
	}
	public function actionRegistro()
	{
		$resultado = array();
		$ejemplo = array("paramero1" => "paraemtro1");
		$resultado["estatus"] = 1;
		$resultado["cupon"] = "cupon";
		$resultado["data"] = $ejemplo;

		echo json_encode($resultado);
	}
	public function actionRegistroTest()
	{
		$this->render('registroTest');
	}

	public function actionApi()
	{

		$resultado = array();
		$existe = Agencias::model()->find('email_agencia="' . $_POST['Agencias']['email_agencia'] . '"');

		if (!$existe) {
			if ($_POST['Agencias']) {
				$model = new Agencias;
				$model->attributes = $_POST['Agencias'];
				// $model->fecha_alta = date('Y-m-d H:i:s');
				$rfc_mayus = strtoupper($model->rfc);
				$model->rfc = $rfc_mayus;
				$model->segmentos = CJSON::encode($_POST['Agencias']['segmentos']);
				// $model->fecha_alta = date('Y-m-d H:i:s');
				$model->estatus = "P";
				// Guarda El modelo recibido mediante el post
				if ($model->save()) {
					$cuponesAgencia = Yii::app()->createController('cuponesAgencias');
					$cuponesAgencia = $cuponesAgencia[0];
					// Se envia el id agencia al controlador
					$cupon = $cuponesAgencia->generarCupon($model->id_agencia, NULL);
					$this->notificarRegistroAgencia($model, $_POST['Agencias']['segmentos']); // notificar a ejecutivos de ventas
					$this->notificarRegistro($model); // notificar a agencia
					$resultado["estatus"] = 1;
					$resultado["msj"] = "Se ha registrado correctamente";
					$resultado["cupon"] = $cupon;
					$resultado["data"] = $model;
				} else {
					$encabezados  = "MIME-Version: 1.0\n";
					$encabezados .= "Content-type: text/html; charset=UTF-8\n";
					$encabezados .= "From:  Error de registro <soporte@>rutamayatravel.com\n";
					$subject2 = "Error en registro de agencia";
					$message2 .= 'Datos: <br>' . CJSON::encode($model->getErrors()) . '<br>' . CJSON::encode($model);
					mail('programador3@rutamayatravel.com', $subject2, $message2, $encabezados);
					$resultado["estatus"] = 0;
					$resultado["msj"] = "No se pudo completar el registro, Intentelo de nuevo mas tarde.";
				}
			} else {
				$resultado["estatus"] = 0;
				$resultado["msj"] = "Petición Invalida.";
			}
			echo CJSON::encode($resultado);
		} else {
			throw new CHttpException(400, "El correo o el nombre de la agencia ya existen utilice otro e intente de nuevo");
		}
	}
	public function actionApiDemo()
	{
		$this->headerCorsApi();
		$resultado = array();
		$existe = Agencias::model()->find('email_agencia="' . $_REQUEST['Agencias']['email_agencia'] . '"');

		if (!$existe) {
			if ($_REQUEST['Agencias']) {
				$model = new Agencias;
				$model->attributes = $_REQUEST['Agencias'];
				// $model->fecha_alta = date('Y-m-d H:i:s');
				$rfc_mayus = strtoupper($model->rfc);
				$model->rfc = $rfc_mayus;
				// $model->fecha_alta = date('Y-m-d H:i:s');
				$model->estatus = "P";
				// Guarda El modelo recibido mediante el post
				if ($model->save()) {
					$cuponesAgencia = Yii::app()->createController('cuponesAgencias');
					$cuponesAgencia = $cuponesAgencia[0];
					// Se envia el id agencia al controlador
					$cupon = $cuponesAgencia->generarCupon($model->id_agencia, NULL);
					$this->notificarRegistroAgencia($model);
				}
				$resultado["estatus"] = 1;
				// $resultado["cupon"] = $cupon;
				$resultado["data"] = $model;
			} else {
				$resultado["estatus"] = 0;
			}
			echo CJSON::encode($resultado);
		} else {
			throw new CHttpException(400, "El correo o el nombre de la agencia ya existen utilice otro e intente de nuevo");
		}
	}
	public function headerCorsApi()
	{
		header('Access-Control-Allow-Origin: *');
		header("Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept");
		header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE');
		header('content-type: application/json; charset=utf-8');
		header('Content-type: text/javascript');
	}


	public function notificarRegistroAgencia($model, $segmentos)
	{
		if (!empty($segmentos)) {
			$email_segmento = array();
			$text_segmento = '';
			$text_segmento = 'La agencia esta interesada en la venta de los siguientes segmentos:';
			foreach ($segmentos as $value) {
				$nombre_segmento = '';
				switch ($value) {
					case 'Grupos':
						$nombre_segmento = 'GRUPOS';
						array_push($email_segmento,'grupos1@rutamayatravel.com');
						// array_push($email_segmento, 'programador3@rutamayatravel.com');
						break;
					case 'Individuales':
						$nombre_segmento = 'RESERVAS INDIVIDUALES';
						array_push($email_segmento,'leticiavarguez@rutamayatravel.com');
						break;
					case 'Bodas':
						$nombre_segmento = 'BODAS';
						array_push($email_segmento,'bodas@rutamayatravel.com');
						break;
				}
				$text_segmento .= "<li>" . $nombre_segmento . "</li>";
			}
		}
		$subject = "Registro de Agencia";
		$message = "<div align='center' width='400' style='border:1px solid black'>
		<img src='https://rutamayatravel.com/reservaciones/rutamayav3/images/logo_rutamaya.jpg'>
		<p>Fecha: " . date('d/m/Y') . "</p>
		<h4>SE HA REGISTRADO UNA NUEVA AGENCIA EN EL SISTEMA</h4><hr>
		<p><b>Nombre:</b> " . $model->nombre_agencia . "<br>
		<b>Contacto:</b> " . $model->contacto . "<br>
		<b>Teléfono:</b> " . $model->tel_agencia . "<br>
		<b>Ciudad:</b> " . $model->id_ciudad_agencia . "<br>
		<b>Estado:</b> " . $model->idEstado->nombreestado . "<br>
		<b>Email:</b> " . $model->email_agencia . "<br>
		<b>Página Web:</b> " . $model->url_agencia . "</p>
		<p>" . $text_segmento . "</p>
		<p>*Por favor revise la cuenta para activarla.</p>
		<p><a href='" . $_SERVER['SERVER_NAME'] . "/rutamayav3/agencias/update/id/" . $model->id_agencia . "'>
		*Para revisar la cuenta ahora haga clic aqui.</a></p><br>
		</div>";

		Yii::import('application.extensions.phpmailer.JPhpMailer');
		$mail = new JPhpMailer;
		$mail->IsSMTP();
		$mail->Host = 'rutamayatravel.com';
		$mail->SMTPAuth = true;
		$mail->Username = 'no-reply@rutamayatravel.com';
		$mail->Port = '26';
		$mail->Password = 'Intelred76';
		$mail->SMTPKeepAlive = true;
		$mail->Mailer = "smtp";
		$mail->IsSMTP();
		$mail->SMTPAuth   = true;
		$mail->CharSet = 'utf-8';
		$mail->SMTPDebug  = 0;
		$mail->SetFrom('no-reply@rutamayatravel.com', 'Sistema Ruta Maya Travel');
		$mail->Subject = $subject;
		$mail->AltBody = 'To view the message, please use an HTML compatible email viewer!';
		$mail->MsgHTML($message);

		$mail->AddAddress('danielruiz@rutamayatravel.com', 'Daniel Ruiz');
		$mail->AddAddress('leticiavarguez@rutamayatravel.com', 'Leticia Varguez');
		$mail->AddAddress('alfredocanche@rutamayatravel.com', 'Alfredo Canche');
		$mail->AddAddress('mercichan@rutamayatravel.com', 'Merci Chan');

		$mail->AddAddress('jorgevadillo@rutamayatravel.com', 'Maria Jose');
		$mail->AddAddress('fernandoeuan@rutamayatravel.com', 'Fernando Euan');

		// $mail->AddAddress('medios@rutamayatravel.com', 'Mauricio Basto');
		$mail->AddAddress('reservacioneschiapas@rutamayatravel.com', 'Reservaciones Chiapas');
		$mail->AddAddress('ventaschiapas@rutamayatravel.com', 'Ventas Chiapas');
		$mail->AddAddress('ventasnorte@rutamayatravel.com', 'Ventas Norte');
		$mail->AddAddress('ventasmty@rutamayatravel.com', 'Ventas Norte');
		$mail->AddAddress('reservasnorte@rutamayatravel.com', 'Ventas Norte');
		// 
		// 
		if (!empty($email_segmento)) {
			foreach ($email_segmento as $correo) {
				$mail->AddAddress($correo, $correo);
			}
		}
		$mail->AddAddress('programador3@rutamayatravel.com', 'Jose Canul');
		$mail->Send();
	}

	public function notificarRegistro($agenciaModel)
	{
		// $agenciaModel = Agencias::model()->findByPk($agenciaModel);
		$sucursal = SucursalesEstados::model()->find('id_estado = ' . $agenciaModel->id_estado_agencia)->id_sucursal;
		switch ($sucursal) {
			case 1:
				$replyTo = "alfredocanche@rutamayatravel.com";
				$infoSucursal = "<h4>Calle 3 # 236 depto. 1 entre 20 y 22 Col. García Ginerés. C.P. 97070 Mérida, Yucatán, México.</h4>
								<h4>Teléfonos: (999) 925-54-43, (999) 286-49-90</h4>
								<h4>Atentamente</h4>
								<h4>Ruta Maya Travel</h4>";
				break;

			case 2:
				$replyTo = "ventaschiapas@rutamayatravel.com";
				$infoSucursal = "<h4>Dirección 15 OTE Sur número 621, local 3. Plaza Koyá planta alta. CP. 29019,Tuxtla, Gutierrez, Chiapas, México.</h4>
								<h4>Teléfonos: (961) 224 2670, (961) 22 30830</h4>
								<h4>Atentamente</h4>
								<h4>Ruta Maya Travel</h4>";
				break;

			case 3:
				$replyTo = "reservasnorte1@rutamayatravel.com";
				$infoSucursal = "<h4>Av. José Alvarado 2500 desp 120 esq. Nogales M. Asueta, Villa Florida, C.P. 64810, Monterrey Nuevo León.</h4>
								<h4>Teléfonos: (812) 473 2440, (812) 733 1470</h4>
								<h4>Atentamente</h4>
								<h4>Ruta Maya Travel</h4>";
				break;
			case 4:
				$replyTo = "ventascdmx@rutamayatravel.com";
				$infoSucursal = "
								<h4>Teléfono: (55) 8046 2256</h4>
								<h4>Atentamente</h4>
								<h4>Ruta Maya Travel</h4>";
				break;
		}
		$subject = "Solicitud de registro de agencia: " . $agenciaModel->nombre_agencia;
		$style = "<style>
					div.table-title { display: block; margin: auto; max-width: 600px; padding:5px; width: 100%; }
					.table-title h3 { color: #fafafa; font-size: 30px; font-weight: 400; font-style:normal; font-family: helvetica, arial, sans-serif; text-shadow: -1px -1px 1px rgba(0, 0, 0, 0.1); text-transform:uppercase; }
					/*** Table Styles **/
					.table-fill { background: white; border-collapse: collapse; margin: auto; max-width: 600px; padding:5px; width: 100%;  box-shadow: 0 5px 10px rgba(0, 0, 0, 0.1); animation: float 5s infinite; }
					th { color:#FFFFFF; background:#1b1e24; font-size:12px; font-weight: 100; padding:10px; text-align:center; text-shadow: 0 1px 1px rgba(0, 0, 0, 0.1); vertical-align:middle; }
					tr { color:#000000; font-size:16px; font-weight:normal; text-shadow: 0 1px 1px rgba(256, 256, 256, 0.1); }
					tr:first-child { border-top:none; }
					tr:last-child { border-bottom:none; }
					tr:nth-child(odd) td { background:#EBEBEB; }
					td { background:#FFFFFF; padding:10px; text-align:left; vertical-align:middle; font-weight:300; font-size:12px;   text-shadow: -1px -1px 1px rgba(0, 0, 0, 0.1); border-right: 1px solid #C1C3D1; }
					th.text-left { text-align: left; }
					th.text-center { text-align: center; }
					th.text-right { text-align: right; } 
					td.text-left { text-align: left; }
					td.text-center { text-align: center; }
					td.text-right { text-align: right; }

					.button { background: #156297; border-radius: 25px; padding: 5px 15px; color: #fff; text-decoration: none; font-size: 12px; } 
					.gray { background: #D2D2D2; }
					.gray:active { background: #b9b9b9; }
				</style>";
		$message = $style . "<div style='font-family:helvetica'>
								<div style='padding:18px;font-size:16px;'>
									Estimado(a): <label style='font-weight:bold;'>" . $agenciaModel->contacto . "</label>
									<p>Antes que nada reciba un cordial saludo por parte de todo el equipo de Ruta Maya Travel.</p>
									<p>De igual manera agradezco la confianza y la oportunidad que nos brinda para ser uno de sus proveedores de hoteles. </p>

									<p style='background-color: #156297; color: #FFFFFF'>NOTA: Anexo en archivo adjunto el CONTRATO COMERCIAL, donde le pido por favor su apoyo para que lo reenvíe firmado a tráves de la liga de carga de documentos. Esto solo como control y reafirmarnos como socios confiables.</p>
									<p>Igual le pedimos por favor enviar los siguientes documentos a través de la siguiente liga:
									</p>

									<ul>
										<li>Copia de identificación oficial (INE, licencia de conducir, etc)</li>
										<li>Comprobante de domicilio</li>
										<li>Registro Nacional de Turismo (RNT)</li>
									</ul>

									<p><a href='".$_SERVER['SERVER_NAME'].Yii::app()->baseUrl."/agencias/documentos/key/".$agenciaModel->id_agencia."'>Click aquí para carga de documentos.</a>
									</p>
									<p>Adjunto las cuentas bancarias, las comisiones que se aplican, la promoción que tenemos con Banamex y Bancomer, así como el formato para realizar los pagos con el teclado abierto.</p>

									<h4>Si tienes alguna duda contáctanos, con gusto te asesoraremos.</h4>
									" . $infoSucursal . "
								</div>
							</div>";
		Yii::import('application.extensions.phpmailer.JPhpMailer');
		$mail = new JPhpMailer;
		$mail->IsSMTP();
		$mail->Host = 'rutamayatravel.com';
		$mail->SMTPAuth = true;
		$mail->Username = 'no-reply@rutamayatravel.com';
		$mail->Port = '26';
		$mail->Password = 'Intelred76';
		$mail->SMTPKeepAlive = true;
		$mail->Mailer = "smtp";
		$mail->IsSMTP();
		$mail->SMTPAuth = true;
		$mail->CharSet = 'utf-8';
		$mail->SMTPDebug  = 0;
		$mail->SetFrom('no-reply@rutamayatravel.com', 'Sistema Ruta Maya Travel');
		$mail->Subject = $subject;
		$mail->AltBody = 'To view the message, please use an HTML compatible email viewer!';
		$mail->MsgHTML($message);
		// $mail->AddAddress('programador3@rutamayatravel.com');
		$mail->AddAddress($agenciaModel->email_agencia, $agenciaModel->contacto);

		$mail->AddBCC('soporte@rutamayatravel.com');
		// $mail->AddBCC('programador3@rutamayatravel.com');
		// $mail->AddBCC('medios@rutamayatravel.com');
		$mail->AddBCC('mercichan@rutamayatravel.com');

		$mail->AddReplyTo($replyTo);

		$file_contrato = $_SERVER['DOCUMENT_ROOT'] . "/formatos/contrato_comercial_agencia_rmt.pdf";
		$file_comisiones = $_SERVER['DOCUMENT_ROOT'] . "/formatos/comisiones_bancarias.pdf";
		$file_cuentas = $_SERVER['DOCUMENT_ROOT'] . "/formatos/cuentas_para_depositos.pdf";
		$file_autorizacion = $_SERVER['DOCUMENT_ROOT'] . "/formatos/CARTA_AUTORIZACION_COBRO_TECLADO_ABIERTO.pdf";

		$mail->addAttachment($file_contrato, 'Contrato Comercial Agencia.pdf');
		$mail->addAttachment($file_comisiones, 'Comisiones Bancarias.pdf');
		$mail->addAttachment($file_cuentas, 'Cuentas Para Depósitos.pdf');
		$mail->addAttachment($file_autorizacion, 'Carta autorización cobro con teclado abierto.pdf');
		$mail->Send();
	}

	public function actionDocumentos($key)
	{
		$this->layout = '//layouts/uploadDocumentos';
		$model = Agencias::model()->findByPk($key);
		$this->render('documentos', array('model' => $model));
	}

	public function actionsendfiles()
	{
		if ($_FILES) {
			$agencia = Agencias::model()->findByPk($_POST['id']);
			$url = $_SERVER['DOCUMENT_ROOT'];
			$carpeta = $url . '/archivos/documentos/agencia_' . $agencia->id_agencia;
			$documentos = array();
			if (!file_exists($carpeta)) {
				if (mkdir($carpeta, 0777, true)) {
					$existe = true;
				}
			} else {
				$existe = true;
			}
			if (is_uploaded_file($_FILES['identificacion']['tmp_name'])) {
				if ($existe == true) {
					$ruta = $carpeta . '/' . $_FILES['identificacion']['name'];
				} 
				// else {
				// 	$ruta = $url . '/images/documentos/' . $_FILES['identificacion']['name'];
				// }
				if (move_uploaded_file($_FILES['identificacion']['tmp_name'], $ruta)) {
					$success = 1;
					$documentos[0]['ruta'] = $ruta;
					$documentos[0]['nombre'] = 'Identificación oficial';
				} else {
					$success = 0;
				}
			}

			if (is_uploaded_file($_FILES['comprobante']['tmp_name'])) {
				if ($existe == true) {
					$ruta = $carpeta . '/' . $_FILES['comprobante']['name'];
				} 
				// else {
				// 	$ruta = $url . '/images/documentos/' . $_FILES['comprobante']['name'];
				// }
				if (move_uploaded_file($_FILES['comprobante']['tmp_name'], $ruta)) {
					$success = 1;
					$documentos[1]['ruta'] = $ruta;
					$documentos[1]['nombre'] = 'Comprobante de domicilio';
				} else {
					$success = 0;
				}
			}

			if (is_uploaded_file($_FILES['registrornt']['tmp_name'])) {
				if ($existe == true) {
					$ruta = $carpeta . '/' . $_FILES['registrornt']['name'];
				} 
				// else {
				// 	$ruta = $url . '/images/documentos/' . $_FILES['registrornt']['name'];
				// }
				if (move_uploaded_file($_FILES['registrornt']['tmp_name'], $ruta)) {
					$success = 1;
					$documentos[2]['ruta'] = $ruta;
					$documentos[2]['nombre'] = 'Registro Nacional de Turismo (RNT)';
				} else {
					$success = 0;
				}
			}

			if (is_uploaded_file($_FILES['contratocomercial']['tmp_name'])) {
				if ($existe == true) {
					$ruta = $carpeta . '/' . $_FILES['contratocomercial']['name'];
				} 
				// else {
				// 	$ruta = $url . '/images/documentos/' . $_FILES['contratocomercial']['name'];
				// }
				if (move_uploaded_file($_FILES['contratocomercial']['tmp_name'], $ruta)) {
					$success = 1;
					$documentos[3]['ruta'] = $ruta;
					$documentos[3]['nombre'] = 'CONTRATO COMERCIAL firmado';
				} else {
					$success = 0;
				}
			}

			$this->enviardocumentos($documentos, $_POST["id"]);

			echo json_encode($documentos);
		}
	}

	public function enviardocumentos($documentos, $id)
	{
		$agencia = Agencias::model()->findByPk($id);
		$sucursal = SucursalesEstados::model()->find('id_estado = ' . $agencia->id_estado_agencia)->id_sucursal;
		switch ($sucursal) {
			case 1:
				$replyTo = "alfredocanche@rutamayatravel.com";
				break;
			case 2:
				$replyTo = "ventaschiapas@rutamayatravel.com";
				break;
			case 3:
				$replyTo = "reservasnorte1@rutamayatravel.com";
				break;
			case 4:
				$replyTo = "ventascdmx@rutamayatravel.com";
				break;
		}
		$subject = "Documentos de Agencia";
		$message = "<div align='center' width='400' style='border:1px solid black'>
		<img src='https://rutamayatravel.com/reservaciones/rutamayav3/images/logo_rutamaya.jpg'>
		<p>Fecha: " . date('d/m/Y') . "</p>
		<h4>La agencia: " . $agencia->nombre_agencia . " ha enviado los siguientes documentos</h4><br><br>
		<a href=".$_SERVER['SERVER_NAME'].Yii::app()->baseUrl.'/admin/agencias/update/id/'.$agencia->id_agencia.">ver documentos</a>
		<hr>
		<p>*Por favor revisar los documentos lo mas pronto posible para su rapida activación.</p><br>
		</div>";

		Yii::import('application.extensions.phpmailer.JPhpMailer');
		$mail = new JPhpMailer;
		$mail->IsSMTP();
		$mail->Host = 'rutamayatravel.com';
		$mail->SMTPAuth = true;
		$mail->Username = 'no-reply@rutamayatravel.com';
		$mail->Port = '26';
		$mail->Password = 'Intelred76';
		$mail->SMTPKeepAlive = true;
		$mail->Mailer = "smtp";
		$mail->IsSMTP();
		$mail->SMTPAuth   = true;
		$mail->CharSet = 'utf-8';
		$mail->SMTPDebug  = 0;
		$mail->SetFrom('no-reply@rutamayatravel.com', 'Sistema Ruta Maya Travel');
		$mail->Subject = $subject;
		$mail->AltBody = 'To view the message, please use an HTML compatible email viewer!';
		$mail->MsgHTML($message);

		// foreach ($documentos as $doc) {
		// 	$mail->addAttachment($doc['ruta'], $doc['nombre']);
		// }

		// $mail->AddAddress('danielruiz@rutamayatravel.com', 'Daniel Ruiz');
		// $mail->AddAddress('leticiavarguez@rutamayatravel.com', 'Leticia Varguez');
		$mail->AddAddress($replyTo,$replyTo);
		// $mail->AddAddress('alfredocanche@rutamayatravel.com', 'Alfredo Canche');
		// $mail->AddAddress('mercichan@rutamayatravel.com', 'Merci Chan');

		// 
		// 
		$mail->AddAddress('soporte@rutamayatravel.com', 'Soporte');
		$mail->Send();
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model = new Agencias;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if (isset($_POST['Agencias'])) {
			$model->attributes = $_POST['Agencias'];
			if ($model->save())
				$this->redirect(array('view', 'id' => $model->id_agencia));
		}

		$this->render('create', array(
			'model' => $model,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model = $this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if (isset($_POST['Agencias'])) {
			$model->attributes = $_POST['Agencias'];
			if ($model->save())
				$this->redirect(array('view', 'id' => $model->id_agencia));
		}

		$this->render('update', array(
			'model' => $model,
		));
	}


	public function actionUpdateAgenciaCfdi($id)
	{
		$model = $this->loadModel($id);

		if (!empty($model)) {
			$model->razon_social = $_POST['FeFacturas']['receptor_razon_social'];
			$model->rfc = $_POST['FeFacturas']['receptor_rfc'];
			$model->calle_fiscal = $_POST['FeFacturas']['receptor_calle'];
			$model->num_exterior_fiscal = $_POST['FeFacturas']['receptor_no_exterior'];
			$model->num_interior_fiscal = $_POST['FeFacturas']['receptor_no_interior'];
			$model->cruzamientos_fiscal = $_POST['FeFacturas']['receptor_cruzamientos'];
			$model->cp_fiscal = $_POST['FeFacturas']['receptor_cp'];
			$model->id_colonia_fiscal = $_POST['FeFacturas']['receptor_colonia'];
			$model->municipio_fiscal = $_POST['FeFacturas']['receptor_municipio'];
			$model->id_ciudad_fiscal = $_POST['FeFacturas']['receptor_localidad'];
			$model->id_estado_fiscal = $_POST['FeFacturas']['receptor_estado'];
			$model->id_pais_fiscal = $_POST['FeFacturas']['receptor_pais'];
			$model->email_agencia = $_POST['FeFacturas']['correo_fiscal'];
			if ($model->save())
				echo json_encode(array('estatus' => 1));
		} else {
			echo json_encode(array('estatus' => 0));
		}
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		if (Yii::app()->request->isPostRequest) {
			// we only allow deletion via POST request
			$this->loadModel($id)->delete();

			// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
			if (!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
		} else
			throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$session = new CHttpSession;
		$session->open();
		$criteria = new CDbCriteria();

		$model = new Agencias('search');
		$model->unsetAttributes();  // clear any default values

		if (isset($_GET['Agencias'])) {
			$model->attributes = $_GET['Agencias'];

			if (!empty($model->id_agencia)) $criteria->addCondition("id_agencia = '" . $model->id_agencia . "'");

			if (!empty($model->nombre_agencia)) $criteria->addCondition("nombre_agencia = '" . $model->nombre_agencia . "'");

			if (!empty($model->webslug)) $criteria->addCondition("webslug = '" . $model->webslug . "'");

			if (!empty($model->fecha_alta)) $criteria->addCondition("fecha_alta = '" . $model->fecha_alta . "'");

			if (!empty($model->tel_agencia)) $criteria->addCondition("tel_agencia = '" . $model->tel_agencia . "'");

			if (!empty($model->email_agencia)) $criteria->addCondition("email_agencia = '" . $model->email_agencia . "'");

			if (!empty($model->celular)) $criteria->addCondition("celular = '" . $model->celular . "'");

			if (!empty($model->contacto)) $criteria->addCondition("contacto = '" . $model->contacto . "'");

			if (!empty($model->skype_agencia)) $criteria->addCondition("skype_agencia = '" . $model->skype_agencia . "'");

			if (!empty($model->puesto)) $criteria->addCondition("puesto = '" . $model->puesto . "'");

			if (!empty($model->porcentaje_comision)) $criteria->addCondition("porcentaje_comision = '" . $model->porcentaje_comision . "'");

			if (!empty($model->observaciones)) $criteria->addCondition("observaciones = '" . $model->observaciones . "'");

			if (!empty($model->id_pais_agencia)) $criteria->addCondition("id_pais_agencia = '" . $model->id_pais_agencia . "'");

			if (!empty($model->id_estado_agencia)) $criteria->addCondition("id_estado_agencia = '" . $model->id_estado_agencia . "'");

			if (!empty($model->id_ciudad_agencia)) $criteria->addCondition("id_ciudad_agencia = '" . $model->id_ciudad_agencia . "'");

			if (!empty($model->id_colonia_agencia)) $criteria->addCondition("id_colonia_agencia = '" . $model->id_colonia_agencia . "'");

			if (!empty($model->calle_agencia)) $criteria->addCondition("calle_agencia = '" . $model->calle_agencia . "'");

			if (!empty($model->cruzamientos_agencia)) $criteria->addCondition("cruzamientos_agencia = '" . $model->cruzamientos_agencia . "'");

			if (!empty($model->num_interior_agencia)) $criteria->addCondition("num_interior_agencia = '" . $model->num_interior_agencia . "'");

			if (!empty($model->num_exterior_agencia)) $criteria->addCondition("num_exterior_agencia = '" . $model->num_exterior_agencia . "'");

			if (!empty($model->cp_agencia)) $criteria->addCondition("cp_agencia = '" . $model->cp_agencia . "'");

			if (!empty($model->rfc)) $criteria->addCondition("rfc = '" . $model->rfc . "'");

			if (!empty($model->razon_social)) $criteria->addCondition("razon_social = '" . $model->razon_social . "'");

			if (!empty($model->id_estado_fiscal)) $criteria->addCondition("id_estado_fiscal = '" . $model->id_estado_fiscal . "'");

			if (!empty($model->id_ciudad_fiscal)) $criteria->addCondition("id_ciudad_fiscal = '" . $model->id_ciudad_fiscal . "'");

			if (!empty($model->id_colonia_fiscal)) $criteria->addCondition("id_colonia_fiscal = '" . $model->id_colonia_fiscal . "'");

			if (!empty($model->calle_fiscal)) $criteria->addCondition("calle_fiscal = '" . $model->calle_fiscal . "'");

			if (!empty($model->cruzamientos_fiscal)) $criteria->addCondition("cruzamientos_fiscal = '" . $model->cruzamientos_fiscal . "'");

			if (!empty($model->num_exterior_fiscal)) $criteria->addCondition("num_exterior_fiscal = '" . $model->num_exterior_fiscal . "'");

			if (!empty($model->num_interior_fiscal)) $criteria->addCondition("num_interior_fiscal = '" . $model->num_interior_fiscal . "'");

			if (!empty($model->cp_fiscal)) $criteria->addCondition("cp_fiscal = '" . $model->cp_fiscal . "'");

			if (!empty($model->id_pais_fiscal)) $criteria->addCondition("id_pais_fiscal = '" . $model->id_pais_fiscal . "'");

			if (!empty($model->log)) $criteria->addCondition("log = '" . $model->log . "'");

			if (!empty($model->municipio_agencia)) $criteria->addCondition("municipio_agencia = '" . $model->municipio_agencia . "'");

			if (!empty($model->municipio_fiscal)) $criteria->addCondition("municipio_fiscal = '" . $model->municipio_fiscal . "'");

			if (!empty($model->mismadir)) $criteria->addCondition("mismadir = '" . $model->mismadir . "'");

			if (!empty($model->logotipo)) $criteria->addCondition("logotipo = '" . $model->logotipo . "'");

			if (!empty($model->foto)) $criteria->addCondition("foto = '" . $model->foto . "'");

			if (!empty($model->url_agencia)) $criteria->addCondition("url_agencia = '" . $model->url_agencia . "'");

			if (!empty($model->estatus)) $criteria->addCondition("estatus = '" . $model->estatus . "'");

			if (!empty($model->activacion)) $criteria->addCondition("activacion = '" . $model->activacion . "'");

			if (!empty($model->verificada)) $criteria->addCondition("verificada = '" . $model->verificada . "'");

			if (!empty($model->accesows)) $criteria->addCondition("accesows = '" . $model->accesows . "'");

			if (!empty($model->ubicacion)) $criteria->addCondition("ubicacion = '" . $model->ubicacion . "'");

			if (!empty($model->pie_flyer)) $criteria->addCondition("pie_flyer = '" . $model->pie_flyer . "'");

			$session['Agencias_records'] = Agencias::model()->findAll($criteria);
		}


		$this->render('index', array(
			'model' => $model,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model = new Agencias('search');
		$model->unsetAttributes();  // clear any default values
		if (isset($_GET['Agencias']))
			$model->attributes = $_GET['Agencias'];

		$this->render('admin', array(
			'model' => $model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model = Agencias::model()->findByPk($id);
		if ($model === null)
			throw new CHttpException(404, 'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if (isset($_POST['ajax']) && $_POST['ajax'] === 'agencias-form') {
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}

	public function actionGenerateExcel()
	{
		$session = new CHttpSession;
		$session->open();

		if (isset($session['Agencias_records'])) {
			$model = $session['Agencias_records'];
		} else
			$model = Agencias::model()->findAll();


		Yii::app()->request->sendFile(
			date('YmdHis') . '.xls',
			$this->renderPartial('excelReport', array(
				'model' => $model
			), true)
		);
	}

	public function actionGeneratePdf()
	{
		$session = new CHttpSession;
		$session->open();
		Yii::import('application.extensions.bootstrap.gii.*');
		require_once('bootstrap/tcpdf/tcpdf.php');
		require_once('bootstrap/tcpdf/config/lang/eng.php');

		if (isset($session['Agencias_records'])) {
			$model = $session['Agencias_records'];
		} else
			$model = Agencias::model()->findAll();

		$html = $this->renderPartial('expenseGridtoReport', array(
			'model' => $model
		), true);

		//die($html);

		$pdf = new TCPDF();
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor(Yii::app()->name);
		$pdf->SetTitle('Agencias Report');
		$pdf->SetSubject('Agencias Report');
		//$pdf->SetKeywords('example, text, report');
		$pdf->SetHeaderData('', 0, "Report", '');
		$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, "Example Report by " . Yii::app()->name, "");
		$pdf->setHeaderFont(array('helvetica', '', 8));
		$pdf->setFooterFont(array('helvetica', '', 6));
		$pdf->SetMargins(15, 18, 15);
		$pdf->SetHeaderMargin(5);
		$pdf->SetFooterMargin(10);
		$pdf->SetAutoPageBreak(TRUE, 0);
		$pdf->SetFont('dejavusans', '', 7);
		$pdf->AddPage();
		$pdf->writeHTML($html, true, false, true, false, '');
		$pdf->LastPage();
		$pdf->Output("Agencias_002.pdf", "I");
	}

	public function actionGetVentasAgencia($id_agencia)
	{
		if ($_SESSION["tipoUsuario"] == "Agencia") {
			$id_agencia = $_SESSION["agenciaUsuario"];
		}

		$usuariosModel = Usuarios::model()->findAll('id_agencia = ' . $id_agencia);
		$id_usuarios = '';
		foreach ($usuariosModel as $key => $value) {
			$id_usuarios .= $value->id_usuario . ',';
		}
		$id_usuarios = substr($id_usuarios, 0, -1);

		$sql = "SELECT * FROM(SELECT R.id_agencia, IF(R.id_usuario IN (" . $id_usuarios . "), R.id_usuario, 2) AS 'id_usuario', IF(R.id_usuario IN (" . $id_usuarios . "), U.username, 'RMT') AS 'username', R.total AS 'total', 'reservacion' AS 'tipo' FROM tbl_reservacion R INNER JOIN tbl_users U ON R.id_usuario = U.id WHERE  R.estatus != 'C' AND R.id_bloqueo IS NULL AND R.id_agencia = " . $id_agencia . " UNION SELECT R.id_agencia, IF(R.id_usuario IN (" . $id_usuarios . "), R.id_usuario, 2) AS 'id_usuario', IF(R.id_usuario IN (" . $id_usuarios . "), U.username, 'RMT') AS 'username', R.total AS 'total', IF(T.precio = 'BODA', 'boda', 'grupo') AS 'tipo' FROM tbl_reservacion R  INNER JOIN tbl_bloqueos B ON R.id_bloqueo = B.id_bloqueo INNER JOIN tbl_tarifa T ON B.id_tarifa = T.id_tarifa INNER JOIN tbl_users U ON R.id_usuario = U.id WHERE  R.estatus != 'C' AND R.id_agencia = " . $id_agencia . " AND B.tipo = 'GRUPAL' UNION SELECT AR.id_agencia, IF(AR.id_usuario IN (" . $id_usuarios . "), AR.id_usuario, 2) AS 'id_usuario', IF(AR.id_usuario IN (" . $id_usuarios . "), U.username, 'RMT') AS 'username', AR.total AS 'total', 'activity' AS 'tipo' FROM tbl_activity_reservacion AR INNER JOIN tbl_users U ON AR.id_usuario = U.id WHERE  AR.estatus != 'C' AND AR.id_agencia = " . $id_agencia . " UNION SELECT TR.id_agencia, IF(TR.id_usuario IN (" . $id_usuarios . "), TR.id_usuario, 2) AS 'id_usuario', IF(TR.id_usuario IN (" . $id_usuarios . "), U.username, 'RMT') AS 'username', TR.importe AS 'total', 'tour' AS 'tipo' FROM tbl_tour_reservacion TR INNER JOIN tbl_users U ON TR.id_usuario = U.id WHERE  TR.estatus != 'C' AND TR.id_agencia = " . $id_agencia . ") AS DA ORDER BY DA.id_usuario DESC";

		$modelAgencia = Yii::app()->db->createCommand($sql)->queryAll();
		$array_ventas_usuarios = array();
		$id_usuario = 0;
		$nombre_usuario = '';
		$primera_vez = true;
		$total_reservas = 1;
		$total_tours = 0;
		$total_activities = 0;
		$total_bodas = 0;
		$total_grupos = 0;
		$total_reservas_usuario = 0;
		$total_tours_usuario = 0;
		$total_activities_usuario = 0;
		$total_bodas_usuario = 0;
		$total_grupos_usuario = 0;
		$cont_grupos = 0;

		foreach ($modelAgencia as $key => $value) {
			if ($id_usuario != $value['id_usuario']) {
				if ($primera_vez == false) {
					array_push($array_ventas_usuarios, array(
						"id_usuario" => $id_usuario,
						"nombre_usuario" => $nombre_usuario,
						"total_reservas" => $total_reservas_usuario,
						"total_tours" => $total_tours_usuario,
						"total_activities" => $total_activities_usuario,
						"total_bodas" => $total_bodas_usuario,
						"total_grupos" => $total_grupos_usuario,
					));

					$total_reservas_usuario = 0;
					$total_tours_usuario = 0;
					$total_activities_usuario = 0;
					$total_bodas_usuario = 0;
					$total_grupos_usuario = 0;
				}

				switch ($value['tipo']) {
					case 'reservacion':
						$total_reservas_usuario += floatval($value['total']);
						break;

					case 'tour':
						$total_tours_usuario += floatval($value['total']);
						break;

					case 'activity':
						$total_activities_usuario += floatval($value['total']);
						break;

					case 'boda':
						$total_bodas_usuario += floatval($value['total']);
						break;

					case 'grupo':
						$total_grupos_usuario += floatval($value['total']);
						break;
				}
			} else {
				switch ($value['tipo']) {
					case 'reservacion':
						$total_reservas_usuario += floatval($value['total']);
						break;

					case 'tour':
						$total_tours_usuario += floatval($value['total']);
						break;

					case 'activity':
						$total_activities_usuario += floatval($value['total']);
						break;

					case 'boda':
						$total_bodas_usuario += floatval($value['total']);
						break;

					case 'grupo':
						$total_grupos_usuario += floatval($value['total']);
						break;
				}
				$primera_vez = false;
			}

			switch ($value['tipo']) {
				case 'reservacion':
					$total_reservas += floatval($value['total']);
					break;

				case 'tour':
					$total_tours += floatval($value['total']);
					break;

				case 'activity':
					$total_activities += floatval($value['total']);
					break;

				case 'boda':
					$total_bodas += floatval($value['total']);
					break;

				case 'grupo':
					$total_grupos += floatval($value['total']);
					break;
			}

			$id_usuario = $value['id_usuario'];
			$nombre_usuario = $value['username'];

			if ($value['tipo'] == 'grupo') {
				$cont_grupos++;
			}
		}

		array_push($array_ventas_usuarios, array(
			"id_usuario" => $id_usuario,
			"nombre_usuario" => $nombre_usuario,
			"total_reservas" => $total_reservas_usuario,
			"total_tours" => $total_tours_usuario,
			"total_activities" => $total_activities_usuario,
			"total_bodas" => $total_bodas_usuario,
			"total_grupos" => $total_grupos_usuario,
		));

		$detalleModel = new CrmAgencia;
		$detalleModel->ventasxUsuario = $array_ventas_usuarios;
		$detalleModel->total_reservas = $total_reservas;
		$detalleModel->total_tours = $total_tours;
		$detalleModel->total_activities = $total_activities;
		$detalleModel->total_bodas = $total_bodas;
		$detalleModel->total_grupos = $total_grupos;
		$detalleModel->num_grupos_vendidos = $cont_grupos;
		// $detalleModel->log_sql = $sql;
		echo json_encode($detalleModel);
	}

	public function actionGetVentasMeses($id_agencia, $anio)
	{
		// YEAR(CURDATE()) dia actual sql
		$sql_bookings = "SELECT MONTH(res.log) AS Mes, IF(COUNT(*)>1,COUNT(*),0) as Reservaciones,'Reservacion' As Tipo FROM tbl_reservacion res WHERE YEAR(res.log)=" . $anio . " AND res.estatus!='C' AND res.id_agencia=" . $id_agencia . " GROUP BY Mes UNION ALL SELECT MONTH(tr.log) AS Mes, IF(COUNT(*)>1,COUNT(*),0) as Reservaciones, 'Tours' as Tipo FROM tbl_tour_reservacion tr WHERE YEAR(tr.log)=" . $anio . " AND tr.estatus!='C' AND tr.id_agencia=" . $id_agencia . " GROUP BY Mes UNION ALL SELECT MONTH(ac.log) AS Mes, IF(COUNT(*)>1,COUNT(*),0) as Reservaciones, 'Activity' as Tipo FROM tbl_activity_reservacion ac WHERE YEAR(ac.log)=" . $anio . " AND ac.estatus!='C' AND ac.id_agencia=" . $id_agencia . " GROUP BY Mes";
		$bookings = Yii::app()->db->createCommand($sql_bookings)->queryAll();

		$bookingsForMonth = array();
		for ($i = 1; $i <= 12; $i++) {
			$bookingsForMonth[$i]['Mes'] = $i;
			foreach ($bookings as $k => $month) {
				if ($month['Mes'] == $i) {
					$bookingsForMonth[$i][$month['Tipo']] = $month['Reservaciones'];
				}
			}
		}

		echo json_encode($bookingsForMonth);
	}


	public function actionGetComparativas()
	{
		if ($_POST['anios']) {
			asort($_POST['anios']);
			# code...
			$sql_anios_cn = '';
			$sql_anios_res = '';
			$sql_anios_t = '';
			$i = 0;
			foreach ($_POST['anios'] as $anios) {
				if ($i != 0) {
					$sql_anios_cn .= ',';
					$sql_anios_res .= ',';
					$sql_anios_t .= ',';
				} else {
					$i = 1;
				}

				$sql_anios_cn .= " SUM(IF(YEAR(log)=" . $anios . ",num_noches*num_habitaciones,0)) As 'CN_" . $anios . "'";
				$sql_anios_t .= " SUM(IF(YEAR(log)=" . $anios . ",total,0)) As 'Total_" . $anios . "'";
				$sql_anios_res .= " COUNT(IF(YEAR(log)=" . $anios . ",1,null)) as 'R_" . $anios . "'";
			}

			$between = 'BETWEEN ' . reset($_POST['anios']) . ' AND ' . end($_POST['anios']) . '';
		}
		// $log = "log BETWEEN '".$_POST['fechaInicial']." 00:00:00' AND '".$_POST['fechaFinal']." 23:59:59'";
		$resComparativaAño = "SELECT MONTH(log) AS Mes," . $sql_anios_cn . "," . $sql_anios_res . "," . $sql_anios_t . " FROM tbl_reservacion res WHERE YEAR(log) " . $between . " AND estatus!='C' AND id_agencia=" . $_POST['id_agencia'] . " GROUP BY Mes";
		// echo $resComparativaAño;
		// $resComparativaAño = "SELECT MONTH(log) AS Mes, SUM(IF(YEAR(log)=2018,num_noches*num_habitaciones,0)) As 'CN_2018', SUM(IF(YEAR(log)=2019,num_noches*num_habitaciones,0)) As 'CN_2019', COUNT(IF(YEAR(log)=2018,1,null)) as 'R_2018', COUNT(IF(YEAR(log)=2019,1,null)) as 'R_2019', SUM(IF(YEAR(log)=2018,total,0)) As 'Total_2018', SUM(IF(YEAR(log)=2019,total,0)) As 'Total_2019' FROM tbl_reservacion res WHERE YEAR(log) BETWEEN 2018 AND 2019 AND estatus!='C' AND id_agencia=".$_POST['id_agencia']." GROUP BY Mes";
		$consulta = Yii::app()->db->createCommand($resComparativaAño)->queryAll();

		foreach ($_POST['anios'] as $year) {

			for ($m = 0; $m < 12; $m++) {

				$mesAux = $m + 1;
				foreach ($consulta as $data) {
					if (!$filas[$m]['R_' . $year]) {
						$filas[$m]['Mes'] = $mesAux;
						if ($data['Mes'] == $mesAux) {
							$filas[$m]['CN_' . $year] = $data['CN_' . $year];
							$filas[$m]['R_' . $year] = $data['R_' . $year];
							$filas[$m]['Total_' . $year] = $data['Total_' . $year];
						} else {
							$filas[$m]['CN_' . $year] = 0;
							$filas[$m]['R_' . $year] = 0;
							$filas[$m]['Total_' . $year] = 0;
						}
					}
				}
			}
		}


		// foreach($consulta as $data2){		
		// 	$filas2[] = $data2;
		// }

		$response['consulta'] = $resComparativaAño;
		// $response['desglose'] = $filas;
		$response['comparativa_anios'] = $filas;

		echo json_encode($response);
	}

	public function actionBalanceAgencia()
	{

		if ($_POST['fechaInicial'] != '' && $_POST['fechaFinal'] != '') {
			$log = "r.log BETWEEN '" . $_POST['fechaInicial'] . " 00:00:00' AND '" . $_POST['fechaFinal'] . " 23:59:59'";
		} else {
			$log = "r.log BETWEEN '" . date('Y-m-d') . " 00:00:00' AND '" . date('Y-m-d') . " 23:59:59'";
		}
		$mesActual = date('n');
		$anioActual = date('Y');
		$desgloseAgencia = "SELECT r.id_reservacion, r.log, h.nombre_hotel, r.total, r.total*(r.comision/100) as comision_agencia, r.fecha_inicial as checkint, r.fecha_final as checkout, r.num_habitaciones*r.num_noches as cuartos_noches FROM `tbl_reservacion` r INNER JOIN tbl_hoteles h USING(id_hotel) INNER JOIN tbl_agencias a USING(id_agencia) WHERE r.id_agencia=" . $_POST['id_agencia'] . " AND YEAR(r.log)=" . $anioActual . " AND " . $log . " AND r.estatus!='C'  ORDER BY r.log DESC";

		$consulta2 = Yii::app()->db->createCommand($desgloseAgencia)->queryAll();

		foreach ($consulta2 as $desglose) {
			$filas_desglose[] = $desglose;
		}

		$response['consulta'] = $desgloseAgencia;
		$response['desglose_actual'] = $filas_desglose;

		echo json_encode($response);
	}

	public function actionEnvioEstadoResultadosAgencia()
	{
		$anioActual = date('Y');
		$mesActual = date('n');

		if (!empty($_GET['inicio']) && !empty($_GET['fin'])) {
			$between = ' AND id_agencia BETWEEN ' . $_GET['inicio'] . ' AND ' . $_GET['fin'];
		} else if (!empty($_GET['inicio']) && empty($_GET['fin'])) {
			$total_agencias = Agencias::model()->findAll();
			$between = ' AND id_agencia BETWEEN ' . $_GET['inicio'] . ' AND ' . count($total_agencias);
		} else if (empty($_GET['inicio']) && !empty($_GET['fin'])) {
			$between = ' AND id_agencia BETWEEN 1 AND ' . $_GET['fin'];
		} else {
			$between = '';
		}

		$lista_agencias = Agencias::model()->findAll(array('condition' => 'estatus="A" ' . $between . '', 'order' => 'id_agencia ASC'));

		$mesActual = date('n', strtotime('-1 month'));

		$contador = 1;
		$diasAntes = date('Y-m-d', strtotime('-30 day'));
		$diasDespues = date('Y-m-d', strtotime('+30 day'));
		$anioAnterior = date('Y', strtotime('-1 year'));

		$agenciasEnviadas = array();
		Yii::import('application.extensions.phpmailer.JPhpMailer');

		foreach ($lista_agencias as $key => $ag) {

			$agencia = $ag->id_agencia;

			$sql1 = "SELECT COUNT(IF(estatus='C',1, NULL)) 'canceladas', SUM(IF(estatus='C',total, 0)) 'importe_canceladas', COUNT(IF(estatus!='C',1, NULL)) 'confirmadas', SUM(IF(estatus!='C',total, 0)) 'importe_confirmadas', COUNT(*) 'generadas', SUM(total) 'improte_generadas' FROM `tbl_reservacion` r WHERE id_agencia=" . $agencia . " AND MONTH(log)=" . $mesActual . " AND YEAR(log)=" . $anioActual . "";

			$sql2 = "SELECT r.id_usuario, us.nombre_usuario as usuario, COUNT(IF(r.estatus='C',1, NULL)) 'canceladas', COUNT(IF(r.estatus!='C',1, NULL)) 'confirmadas', COUNT(r.id_reservacion) 'generadas' FROM `tbl_reservacion` r LEFT JOIN tbl_usuarios us ON r.id_usuario=us.id_usuario WHERE r.id_agencia=" . $agencia . " AND MONTH(r.log)=" . $mesActual . " AND YEAR(r.log)=" . $anioActual . " GROUP BY r.id_usuario";

			$sql3 = "SELECT COUNT(IF(YEAR(log)=" . $anioAnterior . ",1,null)) 'generadas_" . $anioAnterior . "', COUNT(IF(YEAR(log)=" . $anioActual . ",1,null)) 'generadas_" . $anioActual . "', SUM(IF(YEAR(log)=" . $anioAnterior . ",total,0)) As 'ventas_" . $anioAnterior . "',SUM(IF(YEAR(log)=" . $anioActual . ",total,0)) As 'ventas_" . $anioActual . "' FROM `tbl_reservacion` r WHERE id_agencia=" . $agencia . " AND YEAR(log) BETWEEN " . $anioAnterior . " AND " . $anioActual . " AND estatus!='C' AND MONTH(log)=" . $mesActual . "";

			$sql4 = "SELECT COUNT(*) As 'reservas', SUM(total*(comision/100)) AS 'ganancia', SUM(total) as 'ventas' FROM `tbl_reservacion` r WHERE id_agencia=" . $agencia . " AND YEAR(log)=" . $anioActual . " AND estatus!='C'";

			$sql5 = "SELECT r.id_agente, us.nombre_usuario as usuario, COUNT(IF(r.estatus='C',1, NULL)) 'canceladas', COUNT(IF(r.estatus!='C',1, NULL)) 'confirmadas', COUNT(r.id_reservacion) 'generadas' FROM `tbl_reservacion` r LEFT JOIN tbl_usuarios us ON r.id_agente=us.id_usuario WHERE r.id_agencia=" . $agencia . " AND MONTH(r.log)=" . $mesActual . " AND YEAR(r.log)=" . $anioActual . " GROUP BY r.id_agente";

			$reservaciones = Reservacion::model()->findAll('id_agencia=' . $agencia . ' AND fecha_limite BETWEEN "' . $diasAntes . ' 00:00:00" AND "' . $diasDespues . ' 23:59:59" AND estatus!="C" AND saldo>0');

			$activitys = ActivityReservacion::model()->findAll('id_agencia=' . $agencia . ' AND fecha_limite BETWEEN "' . $diasAntes . ' 00:00:00" AND "' . $diasDespues . ' 23:59:59" AND estatus!="C" AND saldo>0');

			$tours = TourReservacion::model()->findAll('id_agencia=' . $agencia . ' AND fecha_limite BETWEEN "' . $diasAntes . ' 00:00:00" AND "' . $diasDespues . ' 23:59:59" AND estatus!="C" AND saldo>0');

			$pendiente_mxn = 0;
			$pendiente_usd = 0;

			if (!empty($reservaciones) == "" || $reservaciones !== null) {
				foreach ($reservaciones as $kr => $res) {

					if (!empty($res->tipo_cambio) && $res->idHotel->proveedor != 0) {
						$pendiente_usd += (float) $res->saldo;
					} else if ($res->moneda == 'USD' && $res->idHotel->proveedor != 0) {
						$pendiente_usd += (float) $res->saldo;
					} else {
						$pendiente_mxn += (float) $res->saldo;
					}
				}
			}

			if (!empty($activitys) == "" || $activitys !== null) {
				foreach ($activitys as $ka => $act) {
					if (json_decode($act->Booking)->currency == "MXN") {
						$pendiente_mxn += (float) $act->saldo;
					} else {
						$pendiente_usd += (float) $act->saldo;
					}
				}
			}

			if (!empty($tours) == "" || $tours !== null) {
				foreach ($tours as $ktr => $tour) {
					if ($tour->idTarifa->moneda == "USD") {
						$pendiente_usd += (float) $tour->saldo;
					} else {
						$pendiente_mxn += (float) $tour->saldo;
					}
				}
			}

			$estatusBookings = Yii::app()->db->createCommand($sql1)->queryAll();
			$estatusUser = Yii::app()->db->createCommand($sql2)->queryAll();
			$ventasMes = Yii::app()->db->createCommand($sql3)->queryAll();
			$ventasAnual = Yii::app()->db->createCommand($sql4)->queryAll();
			$estatusAgentes = Yii::app()->db->createCommand($sql5)->queryAll();

			$userMasReservasG = $this->max_array_value($estatusUser, 'generadas', true);

			$agenteMasReservasC = $this->max_array_value($estatusAgentes, 'canceladas', true);

			$agenteMasPedido = $this->max_array_value($estatusAgentes, 'generadas', false);

			if (empty($userMasReservasG['usuario'])) {
				$userMasReservasG = $this->max_array_value($estatusAgentes, 'generadas', false);
			}

			$tiene_ventas = number_format($ventasMes[0]['ventas_2019'], 2);
			if ($tiene_ventas > 0) {

				$agenciasEnviadas[$contador]['id_agencia'] = $ag->id_agencia;
				$agenciasEnviadas[$contador]['nombre_agencia'] = $ag->nombre_agencia;

				$subject = "Estado de Resultados de " . $ag->nombre_agencia;
				$mail = new JPhpMailer;
				$mail->IsSMTP();
				$mail->Host = 'rutamayatravel.com';
				$mail->SMTPAuth = true;
				$mail->Username = 'no-reply@rutamayatravel.com';
				$mail->Port = '26';
				$mail->Password = 'Intelred76';
				$mail->SMTPKeepAlive = true;
				$mail->Mailer = "smtp";
				$mail->IsSMTP();
				$mail->SMTPAuth   = true;
				$mail->CharSet = 'utf-8';
				$mail->SMTPDebug  = 0;
				$mail->SetFrom('no-reply@rutamayatravel.com', 'Sistema Ruta Maya Travel');
				$mail->Subject = $subject;
				$mail->AltBody = 'To view the message, please use an HTML compatible email viewer!';
				$mail->Body = $this->renderPartial('estadoResultados', array(
					'ventasDesglose' => $estatusBookings,
					'ventasUser' => $estatusUser,
					'ventasMes' => $ventasMes,
					'ventasAnual' => $ventasAnual,
					'mesActual' => $mesActual,
					'anioAnterior' => $anioAnterior,
					'anioActual' => $anioActual,
					'userMasReservasG' => $userMasReservasG['usuario'],
					'agenteMasReservasC' => $agenteMasReservasC['usuario'],
					'agenteMasPedido' => $agenteMasPedido['usuario'],
					'pendiente_mxn' => $pendiente_mxn,
					'pendiente_usd' => $pendiente_usd,
					'agencia' => $ag
				), true);

				$mail->AddAddress($ag->email_agencia, $ag->nombre_agencia);
				$mail->addBCC('alfredocanche@rutamayatravel.com', 'Alfredo Canche');
				$mail->Send();

				$contador++;
			}
		}

		foreach ($agenciasEnviadas as $k => $val) {
			$emailAgencias .= '<tr>
				<td>' . $val["id_agencia"] . '</td>
				<td>' . $val["nombre_agencia"] . '</td>
			</tr>';
		}

		$subject = "Resumen de estado de Resultados";
		$mail2 = new JPhpMailer;
		$mail2->IsSMTP();
		$mail2->Host = 'rutamayatravel.com';
		$mail2->SMTPAuth = true;
		$mail2->Username = 'no-reply@rutamayatravel.com';
		$mail2->Port = '26';
		$mail2->Password = 'Intelred76';
		$mail2->SMTPKeepAlive = true;
		$mail2->Mailer = "smtp";
		$mail2->IsSMTP();
		$mail2->SMTPAuth   = true;
		$mail2->CharSet = 'utf-8';
		$mail2->SMTPDebug  = 0;
		$mail2->SetFrom('no-reply@rutamayatravel.com', 'Sistema Ruta Maya Travel');
		$mail2->Subject = $subject;
		$mail2->AltBody = 'To view the message, please use an HTML compatible email viewer!';
		$message = "<div align='center' style='width:400px;font-family:verdana'> 
		<h3>Resumen de estado de resultados</h3>
		<p>Agencias: " . count($agenciasEnviadas) . " Rango: " . $_GET['inicio'] . " - " . $_GET['fin'] . "</p>
		<table border='1' bordercolor='#000000'>
		<tr>
			<th>Id Agencia</th>
			<th>Agencia</th>
		</tr>
		" . $emailAgencias . "
		</table>
		</div>";
		$mail2->MsgHTML($message);

		$mail2->AddAddress('soporte@rutamayatravel.com', 'Programadores');
		$mail2->Send();
	}

	public function actionEnvioEstadoResultadosAgenciaTest()
	{
		$anioActual = date('Y');
		$mesActual = date('n');

		if (!empty($_GET['inicio']) && !empty($_GET['fin'])) {
			$between = ' AND id_agencia BETWEEN ' . $_GET['inicio'] . ' AND ' . $_GET['fin'];
		} else if (!empty($_GET['inicio']) && empty($_GET['fin'])) {
			$total_agencias = Agencias::model()->findAll();
			$between = ' AND id_agencia BETWEEN ' . $_GET['inicio'] . ' AND ' . count($total_agencias);
		} else if (empty($_GET['inicio']) && !empty($_GET['fin'])) {
			$between = ' AND id_agencia BETWEEN 1 AND ' . $_GET['fin'];
		} else {
			$between = '';
		}

		$lista_agencias = Agencias::model()->findAll(array('condition' => 'estatus="A" ' . $between . '', 'order' => 'id_agencia ASC'));

		// COMENTAR CUANDO SE SUBA A PRODUCCION 
		$mesActual = date('n', strtotime('-1 month'));
		// $agencia = 1320;
		// $agencia = $_GET['agencia'];
		$contador = 1;
		$diasAntes = date('Y-m-d', strtotime('-30 day'));
		$diasDespues = date('Y-m-d', strtotime('+30 day'));
		$anioAnterior = date('Y', strtotime('-1 year'));

		foreach ($lista_agencias as $key => $ag) {

			$agencia = $ag->id_agencia;

			$sql1 = "SELECT COUNT(IF(estatus='C',1, NULL)) 'canceladas', SUM(IF(estatus='C',total, 0)) 'importe_canceladas', COUNT(IF(estatus!='C',1, NULL)) 'confirmadas', SUM(IF(estatus!='C',total, 0)) 'importe_confirmadas', COUNT(*) 'generadas', SUM(total) 'improte_generadas' FROM `tbl_reservacion` r WHERE id_agencia=" . $agencia . " AND MONTH(log)=" . $mesActual . " AND YEAR(log)=" . $anioActual . "";

			$sql2 = "SELECT r.id_usuario, us.nombre_usuario as usuario, COUNT(IF(r.estatus='C',1, NULL)) 'canceladas', COUNT(IF(r.estatus!='C',1, NULL)) 'confirmadas', COUNT(r.id_reservacion) 'generadas' FROM `tbl_reservacion` r LEFT JOIN tbl_usuarios us ON r.id_usuario=us.id_usuario WHERE r.id_agencia=" . $agencia . " AND MONTH(r.log)=" . $mesActual . " AND YEAR(r.log)=" . $anioActual . " GROUP BY r.id_usuario";

			$sql3 = "SELECT COUNT(IF(YEAR(log)=" . $anioAnterior . ",1,null)) 'generadas_" . $anioAnterior . "', COUNT(IF(YEAR(log)=" . $anioActual . ",1,null)) 'generadas_" . $anioActual . "', SUM(IF(YEAR(log)=" . $anioAnterior . ",total,0)) As 'ventas_" . $anioAnterior . "',SUM(IF(YEAR(log)=" . $anioActual . ",total,0)) As 'ventas_" . $anioActual . "' FROM `tbl_reservacion` r WHERE id_agencia=" . $agencia . " AND YEAR(log) BETWEEN " . $anioAnterior . " AND " . $anioActual . " AND estatus!='C' AND MONTH(log)=" . $mesActual . "";

			$sql4 = "SELECT COUNT(*) As 'reservas', SUM(total*(comision/100)) AS 'ganancia', SUM(total) as 'ventas' FROM `tbl_reservacion` r WHERE id_agencia=" . $agencia . " AND YEAR(log)=" . $anioActual . " AND estatus!='C'";

			$sql5 = "SELECT r.id_agente, us.nombre_usuario as usuario, COUNT(IF(r.estatus='C',1, NULL)) 'canceladas', COUNT(IF(r.estatus!='C',1, NULL)) 'confirmadas', COUNT(r.id_reservacion) 'generadas' FROM `tbl_reservacion` r LEFT JOIN tbl_usuarios us ON r.id_agente=us.id_usuario WHERE r.id_agencia=" . $agencia . " AND MONTH(r.log)=" . $mesActual . " AND YEAR(r.log)=" . $anioActual . " GROUP BY r.id_agente";

			$reservaciones = Reservacion::model()->findAll('id_agencia=' . $agencia . ' AND fecha_limite BETWEEN "' . $diasAntes . ' 00:00:00" AND "' . $diasDespues . ' 23:59:59" AND estatus!="C" AND saldo>0');

			$activitys = ActivityReservacion::model()->findAll('id_agencia=' . $agencia . ' AND fecha_limite BETWEEN "' . $diasAntes . ' 00:00:00" AND "' . $diasDespues . ' 23:59:59" AND estatus!="C" AND saldo>0');

			$tours = TourReservacion::model()->findAll('id_agencia=' . $agencia . ' AND fecha_limite BETWEEN "' . $diasAntes . ' 00:00:00" AND "' . $diasDespues . ' 23:59:59" AND estatus!="C" AND saldo>0');

			$pendiente_mxn = 0;
			$pendiente_usd = 0;

			if (!empty($reservaciones) == "" || $reservaciones !== null) {
				foreach ($reservaciones as $kr => $res) {

					if (!empty($res->tipo_cambio) && $res->idHotel->proveedor != 0) {
						$pendiente_usd += (float) $res->saldo;
					} else if ($res->moneda == 'USD' && $res->idHotel->proveedor != 0) {
						$pendiente_usd += (float) $res->saldo;
					} else {
						$pendiente_mxn += (float) $res->saldo;
					}
				}
			}

			if (!empty($activitys) == "" || $activitys !== null) {
				foreach ($activitys as $ka => $act) {
					if (json_decode($act->Booking)->currency == "MXN") {
						$pendiente_mxn += (float) $act->saldo;
					} else {
						$pendiente_usd += (float) $act->saldo;
					}
				}
			}

			if (!empty($tours) == "" || $tours !== null) {
				foreach ($tours as $ktr => $tour) {
					if ($tour->idTarifa->moneda == "USD") {
						$pendiente_usd += (float) $tour->saldo;
					} else {
						$pendiente_mxn += (float) $tour->saldo;
					}
				}
			}

			$estatusBookings = Yii::app()->db->createCommand($sql1)->queryAll();
			$estatusUser = Yii::app()->db->createCommand($sql2)->queryAll();
			$ventasMes = Yii::app()->db->createCommand($sql3)->queryAll();
			$ventasAnual = Yii::app()->db->createCommand($sql4)->queryAll();
			$estatusAgentes = Yii::app()->db->createCommand($sql5)->queryAll();

			$userMasReservasG = $this->max_array_value($estatusUser, 'generadas', true);

			$agenteMasReservasC = $this->max_array_value($estatusAgentes, 'canceladas', true);
			// $agenteMasReservasC = $this->max_array_value($estatusUser,'canceladas',true);

			$agenteMasPedido = $this->max_array_value($estatusAgentes, 'generadas', false);

			if (empty($userMasReservasG['usuario'])) {
				$userMasReservasG = $this->max_array_value($estatusAgentes, 'generadas', false);
			}

			$tiene_ventas = number_format($ventasMes[0]['ventas_2019'], 2);
			if ($tiene_ventas > 0) {

				// $message = $this->renderPartial('estadoResultados', array(
				// 	'ventasDesglose' => $estatusBookings,
				// 	'ventasUser' => $estatusUser,
				// 	'ventasMes' => $ventasMes,
				// 	'ventasAnual' => $ventasAnual,
				// 	'mesActual' => $mesActual,
				// 	'anioAnterior' => $anioAnterior,
				// 	'anioActual' => $anioActual,
				// 	'userMasReservasG' => $userMasReservasG['usuario'],
				// 	'agenteMasReservasC' => $agenteMasReservasC['usuario'],
				// 	'agenteMasPedido' => $agenteMasPedido['usuario'],
				// 	'pendiente_mxn' => $pendiente_mxn,
				// 	'pendiente_usd' => $pendiente_usd,
				// 	'agencia'=>$ag
				// ));
				// exit;

				Yii::import('application.extensions.phpmailer.JPhpMailer');
				$subject = "Estado de Resultados de " . $ag->nombre_agencia;
				$mail = new JPhpMailer;
				$mail->IsSMTP();
				$mail->Host = 'rutamayatravel.com';
				$mail->SMTPAuth = true;
				$mail->Username = 'no-reply@rutamayatravel.com';
				$mail->Port = '26';
				$mail->Password = 'Intelred76';
				$mail->SMTPKeepAlive = true;
				$mail->Mailer = "smtp";
				$mail->IsSMTP();
				$mail->SMTPAuth   = true;
				$mail->CharSet = 'utf-8';
				$mail->SMTPDebug  = 0;
				$mail->SetFrom('no-reply@rutamayatravel.com', 'Sistema Ruta Maya Travel');
				$mail->Subject = $subject;
				$mail->AltBody = 'To view the message, please use an HTML compatible email viewer!';
				$mail->Body = $this->renderPartial('estadoResultados', array(
					'ventasDesglose' => $estatusBookings,
					'ventasUser' => $estatusUser,
					'ventasMes' => $ventasMes,
					'ventasAnual' => $ventasAnual,
					'mesActual' => $mesActual,
					'anioAnterior' => $anioAnterior,
					'anioActual' => $anioActual,
					'userMasReservasG' => $userMasReservasG['usuario'],
					'agenteMasReservasC' => $agenteMasReservasC['usuario'],
					'agenteMasPedido' => $agenteMasPedido['usuario'],
					'pendiente_mxn' => $pendiente_mxn,
					'pendiente_usd' => $pendiente_usd,
					'agencia' => $ag
				), true);
				// $mail->MsgHTML($message);
				// $mail->AddAddress('jorgevadillo@rutamayatravel.com', 'Jorge Vadillo');
				// $mail->AddAddress($ag->email_agencia, $ag->nombre_agencia);
				$mail->AddAddress('programador3@rutamayatravel.com', 'Programador 3');
				$mail->addBCC('soporte@rutamayatravel.com', 'Programadores');
				$mail->Send();
				// if ($mail->Send()) {
				// 	// echo "Enviado";
				// 	echo 'key: '.$contador.' id: '.$agencia.' --- nombre de agencia: '.$ag->nombre_agencia.' ---- ventas del mes: '.number_format($ventasMes[0]['ventas_2019'],2).'<br>';
				// }
				// $contador++;
			}
		}
	}

	public function max_array_value($array, $key_name, $bool)
	{
		$max = '';
		$usuario = '';
		$agentes = array();
		$conteoUss = Usuarios::model()->findAll('id_agencia=9 AND estatus="A"');
		foreach ($conteoUss as $uss) {
			array_push($agentes, $uss->id_usuario);
		}
		// $agentes = array(1445,686,967,1691,1462,2147,2010,2606,686,1445,967,1468,1461,2015,1882);

		foreach ($array as $key => $value) {
			if (is_numeric($value[$key_name])) {
				if ($value[$key_name] > 0) {
					if (!in_array($value['id_usuario'], $agentes) && $bool == true) {
						$make_array[] = $value[$key_name];
					}

					if (in_array($value['id_agente'], $agentes) && $bool == false) {
						$make_array[] = $value[$key_name];
					}

					// if (!in_array($value['id_usuario'],$agentes) && $bool==true) {
					// 	$make_array[] = $value[$key_name];  
					// }

					$max = max($make_array);

					if ($max == $value[$key_name]) {
						$usuario = $value['usuario'];
					}
				}
			} else {
				$max = "No es un valor numerico";
			}
		}
		return array('max' => $max, 'usuario' => $usuario);
	}
}
