var app = new Vue({
    el: '#element',
    data: {
        id_agencia: id_agencia,
        url_rmt: url_rmt,
        api_url: url_rmt + "/api/",
        info_agencia: [],
        marker: [],

        uluru: '',
        map: '',
    },
    created: function() {
        this.loadInfoAgencia();
    },
    methods: {
        loadInfoAgencia: function() {
            this.$http.get(this.api_url + 'agenciasRest/' + this.id_agencia).then(function(response) {
                var response_var = response.body;
                this.info_agencia = response_var.data.agenciasRest;
                console.log(this.info_agencia);
                this.initMap();
            }, function() {
                console.log('Error');
            });
        },
        initMap: function() {
            if(this.info_agencia.ubicacion == null || this.info_agencia.ubicacion == '') {
                this.uluru = { lat: -25.344, lng: 131.036 };

                console.log(this.uluru);
                var that = this;
                navigator.geolocation.getCurrentPosition(function(position){
                    console.log(position);
                    this.uluru = { lat: position.coords.latitude, lng: position.coords.longitude };
                
                    this.map = new google.maps.Map(
                        document.getElementById('map'), {
                            zoom: 13, center: this.uluru
                        });
                    that.marker = new google.maps.Marker({position: this.uluru, map: this.map, draggable: true, animation: google.maps.Animation.DROP});
                });
            } else {
                var array_ubicacion = this.info_agencia.ubicacion.split("/");
                this.uluru = { lat: parseFloat(array_ubicacion[0]), lng: parseFloat(array_ubicacion[1]) };
                this.map = new google.maps.Map(
                    document.getElementById('map'), {
                        zoom: 13, center: this.uluru
                });
                this.marker = new google.maps.Marker({position: this.uluru, map: this.map, draggable: true, animation: google.maps.Animation.DROP});
            }
            //this.marker = new google.maps.Marker({position: uluru, map: map, draggable: true, animation: google.maps.Animation.DROP});
        },
        saveChanges: function() {
            $("#btnSaveChanges").addClass("disabled");
            var location = app.marker.position.lat() + "/" + app.marker.position.lng();
            var postData = { "ubicacion": location };
            this.$http.put(this.api_url + 'agenciasRest/' + this.id_agencia, JSON.stringify(postData)).then(function(response) {
                var response_var = response.body;
                if(response_var.success == "true") {
                    Swal.fire({
                        type: 'success',
                        title: "Correcto",
                        text: "Se ha guardado la información",
                    });
                } else {
                    Swal.fire({
                        type: 'error',
                        title: "¡Ops!",
                        html: "Algo salió mal. <pre><code>" + JSON.stringify(response_var.body) + "</pre></code>",
                    });
                }
                $("#btnSaveChanges").removeClass("disabled");
            }, function(e) {
                $("#btnSaveChanges").removeClass("disabled");
                console.log(e);
                Swal.fire({
                    type: 'error',
                    title: "¡Ops!",
                    html: "Algo salió mal. <pre><code>" + JSON.stringify(e.body) + "</pre></code>",
                });
            });
        },
        test_method: function() {
            console.log(event.target.value);
        }
    }
});