var app = new Vue({
    el: '#element',
    data: {
        url_rmt: rmt_url,
        api_url: rmt_url + "/api/",
        id_referencia: id_referencia,
        tipo_referencia: tipo_referencia,
        id_usuario: id_usuario,
        comentarios: [],
        comentario_model: '',
    },
    created: function() {
        this.loadComentarios();
    },
    methods: {
        loadComentarios: function(){
            console.log(this.tipo_referencia);
            var url_comentarios = this.api_url + 'comentarios?filter=[{"property":"id_referencia","value":' + this.id_referencia + ',"operator":=},{"property":"tipo_referencia","value":"' + this.tipo_referencia + '","operator":=}]&sort=[{"property":"log", "direction":"DESC"}]';
                this.$http.get(encodeURI(url_comentarios)).then(function(response) {
                var response_json = response.body;
                var that = this;
                this.comentarios = response_json.data.comentarios;
                $("#comments-tab").html("Comentarios <span class='badge bg-primary' style='color: white;'>" + this.comentarios.length + "</span>");
                var cont = 0;
                this.comentarios.forEach(function(element){
                    var array_log = element.log.split(" ");
                    var fecha = ((array_log[0].split("-")).reverse()).join("/");
                    var hora = array_log[1];
                    Object.assign(element, {
                        fecha_log: fecha,
                        hora_log: hora,
                    });
                    that.comentarios[cont] = element;
                    cont++;
                });
            }, function() {
                console.log('Error');
            });
        },
        newComentario: function() {
            var postData = { "comentario": this.comentario_model, "id_referencia": this.id_referencia, "tipo_referencia": this.tipo_referencia, "id_usuario": this.id_usuario };
            this.$http.post(this.api_url + 'comentarios', JSON.stringify(postData)).then(function(response) {
                var response_json = response.body;
                this.comentario_model = '';
                this.loadComentarios();
            }, function() {
                console.log('Error');
            });
        }
    }
});