var tbl_asistencia;
var app = new Vue({
    el: '#element',
    data: {
    	id_event: id_event,
        info_event: [],
        info_guest: [],
        tipo_evento: '',
        guests:[],
        total_asistidos: 0,
        api_url: rmt_url + '/api/',
        model_codigo: '',

        model_nombre_agencia: '',
        nombre_persona_invitada: '',
        model_no_invitados: 0,

        valida_invitado: false,
    },
    created: function(){
        this.loadGuests();
        this.loadInfoEvent();
    },
    methods: {
    	loadGuests: function() {
    		this.$http.get(encodeURI(this.api_url + 'eventsGuests?filter=[{"property":"id_event","value":' + this.id_event +',"operator":=}]')).then(function(response){
	        var response_data = response.body;
	        this.guests = response_data.data.eventsGuests;

	        table_guests = $('#tbl_guests').DataTable({
				destroy:true,
				paging: true,
				lengthMenu: [ [10, 25, 50, -1], [10, 25, 50, "All"] ],
				sDom:"<'dt_colVis_buttons'B><'dt-uikit-header'<'uk-grid'<'uk-width-medium-2-3'l><'uk-width-medium-1-3'f>>>tipr",
				buttons: [
		        	{
		        		extend: 'excel',
		        		text:'<i class="uk-icon-file-excel-o" style="color: #FFFFFF"></i> Exportar a Excel',
		        		className: 'md-btn md-btn-success md-btn-wave-light'
		        	},
		        ],
		        columns: [
		        	null,
		        	null,
		        	null,
		        	null,
		        	{ "orderable": false },
		        	{ "orderable": false },
		        ],
			});
			table_guests.clear();
			var that = this;
			this.guests.forEach(function(element){
				var cbxAsist = '';

				if(element.asistio == 0) {
					cbxAsist = '<input class="cbx" type="checkbox" id="check_a_'+ element.id_event_guest +'" data-confirmo_guest='+ element.confirmo + ' data-asistio_guest='+ element.asistio +' data-id_event_guest='+ element.id_event_guest +' />' +
								'<label class="lbl" for="check_a_'+ element.id_event_guest +'">' +
									'<div><i class="material-icons" style="font-size:18px;">done</i></div>' +
								'</label>';
				} else {
					cbxAsist = 	'<input class="cbx" type="checkbox" id="check_a_'+ element.id_event_guest +'" data-confirmo_guest='+ element.confirmo + ' data-asistio_guest='+ element.asistio +' data-id_event_guest='+ element.id_event_guest +' checked />' +
								'<label class="lbl" for="check_a_'+ element.id_event_guest +'">' +
									'<div><i class="material-icons" style="font-size:18px;">done</i></div>' +
								'</label>';
					that.total_asistidos++;
				}

				var codigo, nombre_agencia, telefono, contacto, email;
				if(element.idAgencia == null) {
					nombre_agencia = element.idInvitado.nombre_agencia;
					telefono = element.idInvitado.telefono;
					contacto = element.idInvitado.contacto;
					email = element.idInvitado.email;
				} else {
					nombre_agencia = element.idAgencia.nombre_agencia;
					telefono = element.idAgencia.tel_agencia;
					contacto = element.idAgencia.contacto;
					email = element.idAgencia.email_agencia;
				}	
				codigo = element.id_event_guest;
				table_guests.row.add([
					codigo,
					nombre_agencia,
					telefono,
					contacto,
					email,
					cbxAsist
				]).draw(false);
			});
				$("#codigo").focus();
	        console.log(this.guests);
	        }, function(){
	            console.log('Error');
	        });
    	},
    	setStatusGuest: function(estatus, tipo_update) {
    		if(tipo_update == 'confirmo') {
				var postData = { "confirmo": estatus };
			} else{	
				var postData = { "asistio": estatus };
			}
	 		this.$http.put(this.api_url + 'eventsGuests/' + this.model_codigo, JSON.stringify(postData)).then(function(response) {
				console.log(response.body);
	        }, function(e) {
	            console.log(e);
	        });
		},
		checkedAsistencia: function() {
			this.$http.get(this.api_url + 'eventsGuests/' + this.model_codigo).then(function(response) {
				this.info_guest = response.body.data.eventsGuests;
			 	this.model_nombre_agencia =  this.info_guest.idInvitado.nombre_agencia;
			 	this.nombre_persona_invitada =  this.info_guest.idInvitado.contacto;
			 	this.model_no_invitados =  this.info_guest.idInvitado.telefono;
			 	if(this.info_guest.asistio == 0) {
			 		var postData = { "asistio": 1 };
			 		this.$http.put(this.api_url + 'eventsGuests/' + this.model_codigo, JSON.stringify(postData)).then(function(response) {
						console.log(response.body);
						this.total_asistidos++;
						Swal.fire({
							type: 'success',
							title: 'Registro correcto',
							html: '<strong>Nombre agencia: </strong>' + this.model_nombre_agencia + '. <p></p><strong>Invitado: </strong>' + this.nombre_persona_invitada + '.',
							onClose: $("#codigo").focus(),
						});
						$("#check_a_" + this.model_codigo).prop('checked', true)
						this.clearModels();
			        }, function(e) {
			            console.log(e);
			        });
			 	} else {
			 		this.nombre_persona_invitada =  this.info_guest.idInvitado.contacto;
			 		Swal.fire({
						type: 'error',
						title: "Advertencia",
						html: "El invitado <strong>" + this.nombre_persona_invitada + "</strong> ya ha registrado asistencia al evento.",
						onClose: $("#codigo").focus(),
					});
			 	}
	        }, function(e) {
	            console.log(e);
	        });
		},
		loadInfoEvent: function() {
			this.$http.get(this.api_url + 'events/' + this.id_event).then(function(response) {
				var response_data = response.body;
				this.info_event = response_data.data.events;
				this.tipo_evento = this.info_event.idTipoEvento.tipo_evento;
				this.info_event.fecha_inicio = ((this.info_event.fecha_inicio.split("-")).reverse()).join("/");
	        }, function(e) {
	            console.log(e);
	        });
		},
		lectorCodigo: function() {
			this.checkedAsistencia();
		},
		clearModels: function() {
			this.model_codigo = '';

	        this.model_nombre_agencia = '';
	        this.nombre_persona_invitada = '';
	        this.model_no_invitados = 0;

	        this.valida_invitado = false;
		}
    }
});

$("body").on('click', '.cbx', function(event) {
	var checked = $(this).prop('checked')
	console.log(checked);
	var id_cbx = $(this).attr('id');
	app.model_codigo = $(this).attr('data-id_event_guest')
	if(id_cbx.includes("check_c")) {
		if(checked == true) {
			app.setStatusGuest(1, "confirmo")
		} else {
			app.setStatusGuest(0, "confirmo")
		}
	} else {
		if(checked == true) {
			app.setStatusGuest(1, "asistio");
			app.total_asistidos++;
		} else {
			app.setStatusGuest(0, "asistio");
			app.total_asistidos--;
		}
	}
});

$('#modal_asistencia').on({
    'hide.uk.modal': function(){
        app.clearModels();
    }
});