<?php

class FacturaApi {
        //Generando CFDI

        public $folio;
        public $serie;
        
        public $rfcReceptor; //SUSTITUIR POR OBJETO
        public $razonSocialReceptor;

        public $importeRecibo;

        public $formaPago;

        public $correo_receptor;


    public function facturar(){
        
        $importe=$this->importeRecibo/1.16;

        $subtotal=$importe;

        $total=$importe*1.16;


		$objDom = new DOMDocument('1.0', 'utf-8');
		$objDom->encoding = 'utf-8';		
		$objComprobante = $objDom->createElement('Comprobante');        
        agregar_atributo($objComprobante, "Version", "3.3");
        agregar_atributo($objComprobante, "Serie", $this->serie);
        agregar_atributo($objComprobante, "Folio", $this->folio);
        agregar_atributo($objComprobante, "Fecha", date("Y-m-d")."T".date("H:i:s"));
        agregar_atributo($objComprobante, "FormaPago", $this->formaPago);
        agregar_atributo($objComprobante, "CondicionesDePago", "");
        agregar_atributo($objComprobante, "SubTotal", round($subtotal, 2));
        agregar_atributo($objComprobante, "Descuento", 0);
        agregar_atributo($objComprobante, "Moneda", "MXN");
        agregar_atributo($objComprobante, "TipoCambio", "1.00");
        agregar_atributo($objComprobante, "Total", round($total, 2));
        agregar_atributo($objComprobante, "TipoDeComprobante", "I");
        agregar_atributo($objComprobante, "MetodoPago", "PUE");
        agregar_atributo($objComprobante, "LugarExpedicion", "97000");
        agregar_atributo($objComprobante, "Confirmacion", "");
		$objDom->appendChild($objComprobante);
        

        //CfdiRelacionados, en caso de contar con elllos

        /*
        $objCfdiRelacionados = $objDom->createElement("CfdiRelacionados");
        agregar_atributo($objCfdiRelacionados, "TipoRelacion", "02");

        $objCfdiRelacionado = $objDom->createElement("CfdiRelacionado");
        agregar_atributo($objCfdiRelacionado, "UUID", "F749FC01-4DA4-4EAA-A032-A4A96E25A417");
        $objCfdiRelacionados->appendChild($objCfdiRelacionado);

        $objCfdiRelacionado = $objDom->createElement("CfdiRelacionado");
        agregar_atributo($objCfdiRelacionado, "UUID", "B3B29505-09F9-43AF-820A-C3D31E9FE402");
        $objCfdiRelacionados->appendChild($objCfdiRelacionado);
        $objComprobante->appendChild($objCfdiRelacionados);
        
		*/


		//EMISOR
		$objEmisor = $objDom->createElement('Emisor');
		agregar_atributo($objEmisor, "Rfc", "LAN7008173R5");
		agregar_atributo($objEmisor, "Nombre", "CONSORCIO PROMOTOR DE VIAJES S.A. DE C.V.");
        agregar_atributo($objEmisor, "RegimenFiscal", "601");
        
        //***********************************************************************
        //Domicilio del Emisor
        //Solo para efectos de impresión en el PDF, no tiene validez fiscal y es opcional
        agregar_atributo($objEmisor, "Domicilio", "CALLE 3 DEPTO. 1 X 20 Y 22 No Ext.236 No Int.DEPTO 1 Col.GARCIA GINERES CP 97070, Mérida, Yucatán, México");
        //***********************************************************************
        $objComprobante->appendChild($objEmisor);
						
		//RECEPTOR
		$objReceptor = $objDom->createElement('Receptor');
		agregar_atributo($objReceptor, "Rfc", $this->rfcReceptor); // RFC DE AGENCIA DE VIAJES
		agregar_atributo($objReceptor, "Nombre", $this->razonSocialReceptor); // RAZON SOCIAL DE AGENCIA DE VIAJES
        //agregar_atributo($objReceptor, "ResidenciaFiscal", "MEX"); 'Sólo es necesario cuando no sea mexicano
        //agregar_atributo($objReceptor, "NumRegIdTrib", /"0123456789");
        agregar_atributo($objReceptor, "UsoCFDI", "G03");
		$objComprobante->appendChild($objReceptor);
		
		//CONCEPTOS
		$objConceptos = $objDom->createElement('Conceptos');
        
        //Concepto 1
        $objConcepto = $objDom->createElement('Concepto');
        agregar_atributo($objConcepto, "ClaveProdServ", "90111500");  //90111500 Hoteles y moteles y pensiones
		agregar_atributo($objConcepto, "NoIdentificacion", "1");
		agregar_atributo($objConcepto, "Cantidad", "1");
        agregar_atributo($objConcepto, "ClaveUnidad", "E48");
		agregar_atributo($objConcepto, "Unidad", "SERVICIO");
		agregar_atributo($objConcepto, "Descripcion", "SERVICIO DE HOSPEDAJE");
		agregar_atributo($objConcepto, "ValorUnitario", round($importe, 2));
		agregar_atributo($objConcepto, "Importe", round($importe, 2));
        
        //IMPUESTOS A NIVEL DE CONCEPTOS
        //***********************************************************************************
        //Concepto 1 -> Impuestos
        $objConceptoImpuestos = $objDom->createElement("Impuestos");
        $objConceptoImpuestosTraslados = $objDom->createElement("Traslados");

        //Concepto 1 -> Impuestos -> Traslados 1
        $objConceptoImpuestosTraslado = $objDom->createElement("Traslado");
        agregar_atributo($objConceptoImpuestosTraslado, "Base", round($importe,2));
        agregar_atributo($objConceptoImpuestosTraslado, "Impuesto", "002");
        agregar_atributo($objConceptoImpuestosTraslado, "TipoFactor", "Tasa");
        agregar_atributo($objConceptoImpuestosTraslado, "TasaOCuota", 0.16);

        $importeIVA=$importe*.16;
        $IVA+=$importeIVA;
        agregar_atributo($objConceptoImpuestosTraslado, "Importe", round($importeIVA,2));


        

        $objConceptoImpuestosTraslados->appendChild($objConceptoImpuestosTraslado);
        $objConceptoImpuestos->appendChild($objConceptoImpuestosTraslados);
        $objConcepto->appendChild($objConceptoImpuestos);
        //***********************************************************************************
        $objConceptos->AppendChild($objConcepto);
        
        
        //Concepto 2
        /*
        $objConcepto = $objDom->createElement("Concepto");
        agregar_atributo($objConcepto, "ClaveProdServ", "43231513");
        agregar_atributo($objConcepto, "NoIdentificacion", "1002");
        agregar_atributo($objConcepto, "Cantidad", 1);
        agregar_atributo($objConcepto, "ClaveUnidad", "EA");
        agregar_atributo($objConcepto, "Unidad", "PIEZA");
        agregar_atributo($objConcepto, "Descripcion", "SISTEMA DE COMPUTO");
        agregar_atributo($objConcepto, "ValorUnitario", round(1000.0, 2));
        agregar_atributo($objConcepto, "Importe", round(1000.0, 2));
        agregar_atributo($objConcepto, "Descuento", round(0.0, 2));


        //IMPUESTOS A NIVEL DE CONCEPTOS
        //***********************************************************************************
        //Concepto 2 -> Impuestos
        $objConceptoImpuestos = $objDom->createElement("Impuestos");
        $objConceptoImpuestosTraslados = $objDom->createElement("Traslados");

        //Concepto 2 -> Impuestos -> Traslados 1
        $objConceptoImpuestosTraslado = $objDom->createElement("Traslado");
        agregar_atributo($objConceptoImpuestosTraslado, "Base", 1000);
        agregar_atributo($objConceptoImpuestosTraslado, "Impuesto", "002");
        agregar_atributo($objConceptoImpuestosTraslado, "TipoFactor", "Tasa");
        agregar_atributo($objConceptoImpuestosTraslado, "TasaOCuota", 0.16);
        agregar_atributo($objConceptoImpuestosTraslado, "Importe", 160);
        $objConceptoImpuestosTraslados->appendChild($objConceptoImpuestosTraslado);
        $objConceptoImpuestos->appendChild($objConceptoImpuestosTraslados);
        */
        //***********************************************************************************
        $objConcepto->appendChild($objConceptoImpuestos);
        $objConceptos->appendChild($objConcepto);
		$objComprobante->appendChild($objConceptos);
		
		//IMPUESTOS
		$objImpuestos = $objDom->createElement('Impuestos');
		agregar_atributo($objImpuestos, "TotalImpuestosTrasladados", round($IVA, 2));   // SACAR EL IVA
		agregar_atributo($objImpuestos, "TotalImpuestosRetenidos", "0");
		
		//IMPUESTOS TRASLADADOS (
		$objTraslados = $objDom->createElement('Traslados');
		$objTraslado = $objDom->createElement('Traslado');
        agregar_atributo($objTraslado, "Impuesto", "002");
        agregar_atributo($objTraslado, "TipoFactor", "Tasa");
        agregar_atributo($objTraslado, "TasaOCuota", 0.16);
        agregar_atributo($objTraslado, "Importe", round($IVA,2));
		$objTraslados->appendChild($objTraslado);
		$objImpuestos->appendChild($objTraslados);

                
		//IMPUESTOS RETENIDOS (ISR, IVA)
		//$objRetenciones = $objDom->createElement('Retenciones');
		//$objRetencion = $objDom->createElement('Retencion');
		//agregar_atributo($objRetencion, "Impuesto", "IVA");
		//agregar_atributo($objRetencion, "Importe", round(160.00, 2));
		//$objRetenciones->appendChild($objRetencion);
		//$objImpuestos->appendChild($objRetenciones);
        $objComprobante->appendChild($objImpuestos);
       
		
        //Generando request
		$xml =  $objDom->saveXML();
        $xml = base64_encode($xml);
        

        
        //PROCESO DE TIMBRADO
        $error = "";
        $timbrado = 0;
	    ini_set('default_socket_timeout', 120);


        try{
       
            // $objParams = array('Usuario'=>"AAA010101AAA", 'Contrasena'=>"demo*16", 'Token'=>'MS1mYWN0dXJhY19wcnVlYmFz', 'Correo'=>"jorgevadillo@rutamayatravel.com", 'CorreoCC'=>'soporte@rutamayatravel.com', 'XML'=>$xml,'Prueba'=>'1');
            $objParams = array('Usuario'=>"AAA010101AAA", 'Contrasena'=>"demo*16", 'Token'=>'MS1mYWN0dXJhY19wcnVlYmFz', 'Correo'=>"programador3@rutamayatravel.com", 'XML'=>$xml,'Prueba'=>'1');
            // $objParams = array('Usuario'=>"AAA010101AAA", 'Contrasena'=>"demo*16", 'Token'=>'MS1mYWN0dXJhY19wcnVlYmFz', 'Correo'=>$this->correo_receptor, 'CorreoCC'=>'soporte@rutamayatravel.com', 'XML'=>$xml,'Prueba'=>'1');
            $paramsws = array('uri'=>'http://testuri.org','trace' => true,  'exception' => true,'connection_timeout'=>9999, 'encoding' => 'ISO-8859-1');
            $objSoapClient = new SoapClient('http://wscfdi.facturacione.com.mx/wsf33/wscfdi.asmx?wsdl', $paramsws);
            $objRespuesta = $objSoapClient->Timbrar($objParams);
            $objValores = $objRespuesta->TimbrarResult->string;
            
        }catch (Exception $e){
            $error = $e->getMessage();
        }



		$id_comprobante = 0; $descarga_xml = ""; $descarga_pdf = "";
        if($error==""){


            $timbrado = "1";
            $mostrar_error_correo = 1;
            if($objValores[0]=="1"){

                try{

                    //Creando directorio para el rfc si no existe
                    $directorio_emisor = "comprobantes/demo/";
                    if(!file_exists($directorio_emisor)){ mkdir($directorio_emisor,0777); }
                    
                    //Bajando los archivos a la carpeta de salida
                    $nombre_xml = $objValores[5].".xml";
                    $nombre_pdf = $objValores[5].".pdf";
                    
                    $descarga_xml = $directorio_emisor."/".$nombre_xml;
                    $descarga_pdf = $directorio_emisor."/".$nombre_pdf;
                    file_put_contents($descarga_xml, utf8_encode($objValores[1]));
                    file_put_contents($descarga_pdf, base64_decode($objValores[2]));
                    

                }catch (Exception $e){
                    $error .= $e->getMessage();
                }

            }else{

                $mostrar_error_correo = 0;
                $error .= "Ocurrieron errores durante el proceso de Timbrado:<br /><br />".$objValores[3]."<br /><br />";
                $objValores[9] = $error;

            }


            //SI HUBO ERROR EN EL ENVÍO DEL CORREO
            if($mostrar_error_correo && $objValores[4]<>""){
                $error .= "Ocurrieron errores durante el proceso de envío de correo:<br /><br />".$objValores[4]."<br /><br />";
            }
            

        }else{

            $error .= "Ocurrieron errores durante el consumo del webservice:<br /><br />".$error."<br /><br />";
            $objValores[7] = $error;
        }



        if($timbrado==1){

		    // $msg .= "Folio Fiscal (UUID): ".$objValores[5]."<br>".
      //               "Fecha de Certificaci&oacute;n: ".$objValores[6]."<br /><br />".
      //               "<h4><a href='comprobantes/".$objValores[5].".pdf' target='_blank'><i class='fa fa-file'></i>&nbsp;Descargue su PDF</a></h4>".
      //               "<h4><a href='comprobantes/".$objValores[5].".xml' target='_blank'><i class='fa fa-file'></i>&nbsp;Descargue su XML</a></h4><br />";

            // echo '<div>
            //             <h3 class="font-w300 push-15">El comprobante se ha certificado correctamente</h3>
            //             <p><center><a class="alert-link" href="javascript:void(0)">'.$msg.'</a></center></p>
            //         </div>';

            // echo json_encode($objValores);
            return $objValores;



         }

         

        if($error!=""){ 

            $msg .= $error;

            $objValores[8] = $msg;
            return $objValores; 
            // echo '<div>
            //             <h3 class="font-w300 push-15">Error</h3>
            //             <p>Han ocurrido errores en el proceso de generación de su comprobante <a class="alert-link" href="javascript:void(0)">Código: 160</a><br />'.$msg.'<br /><a href="index.php" >Inicio</a></p>
            //         </div>';
            exit();
        
        }


        ////LA RESPUESTA DEL SERVICIO (QUE ESTÁ EN LA VARIABLE $objRespuesta ES UN ARREGLO DE CADENAS DE 7 POSICIONES DONDE
        ////$objRespuesta[0]: CONTIENE UN VALOR QUE INDICA SI SE HA TIMBRADO CON ÉXITO O NO, "1" ó "0"
        ////$objRespuesta[1]: CONTIENE UNA CADENA CON EL XML YA TIMBRADO EN CASO DE QUE EL ANTERIOR HAYA SIDO "1"
        ////$objRespuesta[2]: CONTIENE EL PDF EN BINARIO CODIFICADO EN BASE 64
        ////$objRespuesta[3]: CONTIENE UNA CADENA CON EL MENSAJE DE ERROR DEVUELTO EN CASO DE QUE NO HAYA SIDO EXITOSO EL TIMBRADO (LA PRIMERA POSICIÓN DE LA RESPUESTA HAYA SIDO "0")
        ////$objRespuesta[4]: CONTIENE UNA CADENA CON EL MENSAJE DE ERROR DEVUELTO EN CASO DE QUE EL ENVÍO DEL CORREO NO HAYA SIDO EXITOSO, EL TIMBRADO PODRÁ SER EXITOSO Y EL ENVÍO PUEDO O NO SERLO
        ////$objRespuesta[5]: CONTIENE EL UUID DEL TIMBRE
        ////$objRespuesta[6]: CONTIENE LAFECHA Y LA HORA DE CERTIFICACION
        
    
       
    }

}     
function agregar_atributo($objElemento, $campo, $valor)
        {
            if ($valor<>'')
            {
                $objElemento->setAttribute($campo, $valor);
            }
        }