<?php
class Commons
{

	public function changeFormatDate($dateStr){
		$date = str_replace('/', '-', $dateStr);
		return date('Y-m-d', strtotime($date));
	}

	public function callApi($pApiKey, $pSecret, $pEndpoint, $pMethod, $pParams = ''){
		$client = new http\Client;
		$request = new http\Client\Request;

		$body = new http\Message\Body;
		$body->append($pParams);
		$signature = hash("sha256", $pApiKey.$pSecret.time());
		$request->setRequestUrl($pEndpoint);
		$request->setRequestMethod('POST');
		$request->setBody($body);

		$request->setHeaders(array(
		  'Postman-Token' => 'e2d88af3-9f6a-4c59-9cb4-9963e640b4ed',
		  'Api-Key' => $pApiKey,
		  'cache-control' => 'no-cache',
		  'Accept-encoding' => 'Gzip',
		  'Accept' => 'application/json',
		  'X-Signature' => $signature,
		  'Content-Type' => 'application/json;charset=UTF-8'
		));

		$client->enqueue($request)->send();
		$response = $client->getResponse();

		echo $response->getBody();
	}
}