<?php
class Commons
{

	public function changeFormatDate($dateStr){
		$date = str_replace('/', '-', $dateStr);
		return date('Y-m-d', strtotime($date));
	}

	public function callApi($pApiKey, $pSecret, $pEndpoint, $pMethod="GET", $pParams = ''){
		$client = new http\Client;
		$request = new http\Client\Request;
		$signature = hash("sha256", $pApiKey.$pSecret.time());

		$body = new http\Message\Body;
		$body->append($pParams);
		$request->setRequestUrl($pEndpoint);
		$request->setRequestMethod($pMethod);
		$request->setBody($body);

		$request->setHeaders(array(
		  'Api-Key' => $pApiKey,
		  'X-Signature' => $signature,
		  'Content-Type' => 'application/json;charset=UTF-8',
		  'Accept' => 'application/json',
		));

		$client->enqueue($request)->send();
		$response = $client->getResponse();

		return $response->getBody();
	}
}