<?php 

require_once('../Openpay/Openpay.php');

class Functions
{
	private $id = 'mvdr6tqdokmbnboafexd';
	private $sk = 'sk_16dbd05675bd4929a6bbf794c00d107d';
	private $env_production_mode = false;

	public function __construct()
	{
		$this->openpay = Openpay::getInstance($this->id, $this->sk);
	}
	
	public function generarTransferencia($order){
		
		Openpay::setProductionMode($this->env_production_mode);

		$bool = Openpay::getProductionMode();
		try {

			$charge = $this->openpay->charges->create($order);

			return json_encode([
				'openpay' => [
					'transaccion' => $charge,
					'recibo' => "https://sandbox-dashboard.openpay.mx/spei-pdf/".$this->id."/".$charge->id."",
				]
			]);

		} catch (OpenpayApiTransactionError $e) {
			return json_encode([
				'error' => [
					'category' => $e->getCategory(),
					'error_code' => $e->getErrorCode(),
					'description' => $e->getMessage(),
					'http_code' => $e->getHttpCode(),
					'request_id' => $e->getRequestId()
				]
			]);
		} catch (OpenpayApiRequestError $e) {
			return json_encode([
				'error' => [
					'category' => $e->getCategory(),
					'error_code' => $e->getErrorCode(),
					'description' => $e->getMessage(),
					'http_code' => $e->getHttpCode(),
					'request_id' => $e->getRequestId()
				]
			]);
		} catch (OpenpayApiConnectionError $e) {
			return json_encode([
				'error' => [
					'category' => $e->getCategory(),
					'error_code' => $e->getErrorCode(),
					'description' => $e->getMessage(),
					'http_code' => $e->getHttpCode(),
					'request_id' => $e->getRequestId()
				]
			]);
		} catch (OpenpayApiAuthError $e) {
			return json_encode([
				'error' => [
					'category' => $e->getCategory(),
					'error_code' => $e->getErrorCode(),
					'description' => $e->getMessage(),
					'http_code' => $e->getHttpCode(),
					'request_id' => $e->getRequestId()
				]
			]);
		} catch (OpenpayApiError $e) {
			return json_encode([
				'error' => [
					'category' => $e->getCategory(),
					'error_code' => $e->getErrorCode(),
					'description' => $e->getMessage(),
					'http_code' => $e->getHttpCode(),
					'request_id' => $e->getRequestId()
				]
			]);
		} catch (Exception $e) {
			return json_encode([
				'error' => [
					'category' => $e->getCategory(),
					'error_code' => $e->getErrorCode(),
					'description' => $e->getMessage(),
					'http_code' => $e->getHttpCode(),
					'request_id' => $e->getRequestId()
				]
			]);
		}
	}


	public function eliminarCustomer($id_customer,$id_cuenta){
		try {
			
			$customer = $this->openpay->customers->get($id_customer);
			$bankaccount = $customer->bankaccounts->get($id_cuenta);
			$response = $bankaccount->delete();

			if ($response==null || empty($response)) {
				return json_encode(['success'=>1]);
			}
		} catch (Exception $e) {
			return json_encode([
				'error' => [
					'category' => $e->getCategory(),
					'error_code' => $e->getErrorCode(),
					'description' => $e->getMessage(),
					'http_code' => $e->getHttpCode(),
					'request_id' => $e->getRequestId()
				]
			]);
		}
	}

	public function crearWebHook($array){
		try {
			$webhook = $this->openpay->webhooks->add($array);
			return json_encode($webhook);
		} catch (OpenpayApiTransactionError $e) {
			return json_encode([
				'error' => [
					'category' => $e->getCategory(),
					'error_code' => $e->getErrorCode(),
					'description' => $e->getMessage(),
					'http_code' => $e->getHttpCode(),
					'request_id' => $e->getRequestId()
				]
			]);
		} catch (OpenpayApiRequestError $e) {
			return json_encode([
				'error' => [
					'category' => $e->getCategory(),
					'error_code' => $e->getErrorCode(),
					'description' => $e->getMessage(),
					'http_code' => $e->getHttpCode(),
					'request_id' => $e->getRequestId()
				]
			]);
		} catch (OpenpayApiConnectionError $e) {
			return json_encode([
				'error' => [
					'category' => $e->getCategory(),
					'error_code' => $e->getErrorCode(),
					'description' => $e->getMessage(),
					'http_code' => $e->getHttpCode(),
					'request_id' => $e->getRequestId()
				]
			]);
		} catch (OpenpayApiAuthError $e) {
			return json_encode([
				'error' => [
					'category' => $e->getCategory(),
					'error_code' => $e->getErrorCode(),
					'description' => $e->getMessage(),
					'http_code' => $e->getHttpCode(),
					'request_id' => $e->getRequestId()
				]
			]);
		} catch (OpenpayApiError $e) {
			return json_encode([
				'error' => [
					'category' => $e->getCategory(),
					'error_code' => $e->getErrorCode(),
					'description' => $e->getMessage(),
					'http_code' => $e->getHttpCode(),
					'request_id' => $e->getRequestId()
				]
			]);
		} catch (Exception $e) {
			return json_encode([
				'error' => [
					'category' => $e->getCategory(),
					'error_code' => $e->getErrorCode(),
					'description' => $e->getMessage(),
					'http_code' => $e->getHttpCode(),
					'request_id' => $e->getRequestId()
				]
			]);
		}
	}

	public function crearCustomer(){
		
	}
	
}






?>