<?php

/**
 * Openpay API v1 Client for PHP (version 1.0.0)
 * 
 * Copyright © Openpay SAPI de C.V. All rights reserved.
 * http://www.openpay.mx/
 * soporte@openpay.mx
 */
class OpenpayCharge extends OpenpayApiResourceBase
{

    public $authorization;
    public $creation_date;
    public $currency;
    public $customer_id;
    public $operation_type;
    public $status;
    public $transaction_type;
    // temporal hack
    // TODO: checar porque no instancia Openpaycard al recibir el parametro
    protected $card;
    protected $derivedResources = array('Refund' => null, 'Capture' => null);

    public function refund($params) {
        $resource = $this->derivedResources['refunds'];
        if ($resource) {
            return parent::_create($resource->resourceName, $params, array('parent' => $this));
        }
    }

    public function capture($params) {
        $resource = $this->derivedResources['captures'];
        if ($resource) {
            return parent::_create($resource->resourceName, $params, array('parent' => $this));
        }
    }

    public function update($params) {
        return $this->_updateCharge($params);
    }

}

// ----------------------------------------------------------------------------
class OpenpayChargeList extends OpenpayApiDerivedResource
{

    public function create($params) {
        return $this->add($params);
    }

}

?>